/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.arap.billValidator.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.json.JSONUtils;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.function.FunctionObjectInfo;
import com.kingdee.bos.metadata.function.OperationCollection;
import com.kingdee.bos.metadata.function.OperationInfo;
import com.kingdee.bos.search.lucene.SolrSearchService;
import com.kingdee.bos.search.lucene.bean.DeleteParam;
import com.kingdee.bos.search.lucene.bean.PageResult;
import com.kingdee.bos.search.lucene.bean.SearchParam;
import com.kingdee.bos.workflow.service.ormrpc.EnactmentServiceFactory;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.ap.app.util.DateUtils;
import com.kingdee.eas.fi.arap.billValidator.PaySecurityLogCollection;
import com.kingdee.eas.fi.arap.billValidator.PaySecurityLogInfo;
import com.kingdee.eas.fi.arap.billValidator.ScheduleFunctionEnum;
import com.kingdee.eas.fi.arap.billValidator.app.AbstractPaySecurityLogControllerBean;
import com.kingdee.eas.fi.arap.billValidator.util.PaySecurityParam;
import com.kingdee.eas.fi.arap.util.ArApParamsUtil;
import com.kingdee.eas.scm.framework.log.listener.SCMBizLogService;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.sql.SQLException;
import java.util.Date;
import java.util.HashMap;
import org.apache.log4j.Logger;

public class PaySecurityLogControllerBean
extends AbstractPaySecurityLogControllerBean {
    private static final long serialVersionUID = 4994786187121758064L;
    private static Logger logger = Logger.getLogger((String)PaySecurityLogControllerBean.class.getName());
    private final String BOSTYPE = new PaySecurityLogInfo().getBOSType().toString();

    private String wrapperTimestamp(Date date) {
        return String.valueOf(date.getTime());
    }

    @Override
    protected PageResult _pageSearchSolr(Context ctx, PaySecurityParam param) throws BOSException {
        HashMap<String, String> filter = new HashMap<String, String>();
        if (param.getCompanys() != null && param.getCompanys()[0] != null) {
            filter.put("mainOrgId", param.getCompanys()[0].getId().toString());
        }
        String timestamp = null;
        if (param.getDateFrom() != null) {
            timestamp = "[" + this.wrapperTimestamp(param.getDateFrom()) + " TO ";
            timestamp = param.getDateTo() != null ? timestamp + this.wrapperTimestamp(param.getDateTo()) + "]" : timestamp + "*]";
            filter.put("executeTime", timestamp);
        }
        if (param.getUserType() != null) {
            filter.put("userType", String.valueOf(param.getUserType().getValue()));
        }
        if (param.getCrtlBillType() != null) {
            filter.put("ctrlBillType", param.getCrtlBillType().getValue());
        }
        if (!param.isChkPass() || !param.isChkUnPass()) {
            if (param.isChkPass()) {
                filter.put("executeResult", String.valueOf(1));
            }
            if (param.isChkUnPass()) {
                filter.put("executeResult", String.valueOf(0));
            }
        }
        HashMap<String, String> mainQuerys = new HashMap<String, String>();
        mainQuerys.put("*", "*");
        SearchParam searchParam = new SearchParam(ctx.getAIS(), this.BOSTYPE, mainQuerys, filter);
        searchParam.setSortFiled("executeTime");
        searchParam.setDesc(true);
        searchParam.setNotFilterFields(true);
        searchParam.setStart(Integer.valueOf(param.getStartIndex()));
        searchParam.setTop(param.getPageCount());
        PageResult pageResult = SolrSearchService.INS.pageSearch(searchParam);
        return pageResult;
    }

    @Override
    protected void _saveSolr(Context ctx, PaySecurityLogCollection logs) throws BOSException, EASBizException {
        for (int i = 0; i < logs.size(); ++i) {
            PaySecurityLogInfo logInfo = logs.get(i);
            HashMap map = JSONUtils.convertJsonToObject((Context)ctx, (String)JSONUtils.convertObjectToJson((Context)ctx, (Object)logInfo));
            map.put("ctrlBillType", null != logInfo.getCtrlBillType() ? logInfo.getCtrlBillType().getValue() : "");
            map.put("executeTime", null != logInfo.getExecuteTime() ? Long.valueOf(logInfo.getExecuteTime().getTime()) : "0");
            map.put("executeResult", null != logInfo.getExecuteResult() ? Integer.valueOf(logInfo.getExecuteResult().getValue()) : "");
            map.put("userType", null != logInfo.getUserType() ? Integer.valueOf(logInfo.getUserType().getValue()) : "");
            map.put("billAction", null != logInfo.getBillAction() ? logInfo.getBillAction().getValue() : "");
            map.put(SCMBizLogService.DC, ctx.getAIS());
            SCMBizLogService.putLogItem((Context)ctx, (HashMap)map, (String)this.BOSTYPE);
        }
    }

    @Override
    protected void _deleteSolrDoc(Context ctx) throws BOSException, EASBizException {
        DeleteParam deleteParam = new DeleteParam();
        deleteParam.setDc(ctx.getAIS());
        deleteParam.setBosType(this.BOSTYPE);
        StringBuilder buf = new StringBuilder(100);
        buf.append("executeTime").append(":[* TO");
        String value = ArApParamsUtil.getStringBackgroundParam(ctx, "PAY_SECURITY_LOG_RETAIN_MONTH");
        int month = Integer.parseInt(value);
        Date beforeDate = DateUtils.getBeginDayOfDate(month);
        buf.append(beforeDate.getTime()).append(" ]");
        deleteParam.setQueryStr(buf.toString());
        try {
            SolrSearchService.INS.deleteDoc(deleteParam);
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
    }

    @Override
    protected String _getScheduleConfig(Context ctx, ScheduleFunctionEnum funcNumber) throws BOSException, EASBizException {
        String scheduleXml = "";
        if (null == funcNumber) {
            return scheduleXml;
        }
        StringBuilder sql = new StringBuilder(150);
        sql.append(" SELECT FSCHEDULE FROM T_ARAP_SCHEDULECFG WHERE FUNCNUMBER='").append(funcNumber.getValue()).append("'");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        try {
            if (rs.next()) {
                scheduleXml = rs.getString("FSCHEDULE");
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return scheduleXml;
    }

    @Override
    protected void _setScheduleConfig(Context ctx, ScheduleFunctionEnum funcNumber, String scheduleXml, String scheduleFuncClass, String scheduleFuncMethod) throws BOSException, EASBizException {
        if (null == funcNumber || StringUtils.isEmpty((String)scheduleXml) || StringUtils.isEmpty((String)scheduleFuncClass) || StringUtils.isEmpty((String)scheduleFuncMethod)) {
            return;
        }
        String tJobNumber = funcNumber.getValue();
        StringBuilder sql = new StringBuilder(100);
        sql.append("SELECT FJOBDEFID FROM T_JOB_DEF WHERE FTITLE ='" + tJobNumber + "'");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        String jobId = null;
        try {
            if (rs.next()) {
                jobId = rs.getString("FJOBDEFID");
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        if (!StringUtils.isEmpty(jobId)) {
            EnactmentServiceFactory.createEnactService((Context)ctx).removeJobProcessDef(jobId);
        }
        MetaDataPK functionPK = MetaDataPK.create((String)scheduleFuncClass);
        FunctionObjectInfo function = MetaDataLoaderFactory.getMetaDataLoader((Context)ctx).getFunction((IMetaDataPK)functionPK);
        OperationInfo operation = null;
        OperationCollection operCol = function.getOperation();
        int size = operCol.size();
        for (int i = 0; i < size; ++i) {
            if (!scheduleFuncMethod.equalsIgnoreCase(operCol.get(i).getName())) continue;
            operation = operCol.get(i);
            break;
        }
        if (operation == null) {
            throw new BOSException("Cannot found METHOD: " + scheduleFuncMethod);
        }
        HashMap<String, Boolean> jobContext = new HashMap<String, Boolean>();
        jobContext.put("selectedServer", null);
        jobContext.put("isRetainTime", true);
        jobId = EnactmentServiceFactory.createEnactService((Context)ctx).createJobProcessDef(tJobNumber, function, operation, jobContext, scheduleXml, ctx.getLocale());
        sql.setLength(0);
        String oldScheduleXml = this._getScheduleConfig(ctx, funcNumber);
        if (StringUtils.isEmpty((String)oldScheduleXml)) {
            sql.append(" INSERT INTO T_ARAP_SCHEDULECFG (FUNCNAME, FJOBID, FSCHEDULE, FUNCNUMBER) VALUES(?, ?, ?, ?)");
        } else {
            sql.append(" UPDATE T_ARAP_SCHEDULECFG SET FUNCNAME = ?, FJOBID = ?, FSCHEDULE = ? WHERE FUNCNUMBER = ?");
        }
        DbUtil.execute((Context)ctx, (String)sql.toString(), (Object[])new String[]{funcNumber.getAlias(), jobId, scheduleXml, tJobNumber});
    }
}

