/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.arap.electronicInvoice.eiv.method;

import com.kingdee.bos.json.Kson;
import com.kingdee.eas.fi.ap.ApInvoiceEntryCollection;
import com.kingdee.eas.fi.ap.ApInvoiceEntryInfo;
import com.kingdee.eas.fi.ap.ApInvoiceInfo;
import com.kingdee.eas.fi.arap.electronicInvoice.eiv.EIVCError;
import com.kingdee.eas.fi.arap.electronicInvoice.eiv.EIVCService;
import com.kingdee.eas.fi.arap.electronicInvoice.eiv.method.AbstractEIVMethod;
import com.kingdee.eas.fi.arap.util.H;
import com.kingdee.eas.fi.arap.util.remote.exception.AfterInvokingRemoteMethodException;
import com.kingdee.eas.fi.arap.util.remote.exception.BeforeInvokingRemoteMethodException;
import com.kingdee.eas.fi.arap.util.remote.exception.InvokingRemoteMethodException;
import com.kingdee.eas.fi.arap.util.remote.exception.RemoteMethodException;
import com.kingdee.eas.fi.arap.util.remote.exception.ThrowReturn;
import java.io.UnsupportedEncodingException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Map;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.apache.commons.httpclient.methods.StringRequestEntity;
import org.apache.commons.httpclient.params.HttpMethodParams;

public class EIVGetApInvoiceMethod
extends AbstractEIVMethod {
    HttpClient client = null;
    PostMethod httpPost = null;
    String phone;
    String[] ownRevenueNumbers;
    String[] oppRevenueNumbers;
    Date beginDate;
    Date endDate;
    int invoicestatue;
    int statusCode;
    Map cache;
    ApInvoiceInfo[] retVal;
    SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");

    public EIVGetApInvoiceMethod(EIVCService eivcService, String phone, String[] ownRevenueNumbers, String[] oppRevenueNumbers, Date beginDate, Date endDate, int invoicestatue) {
        super(eivcService);
        this.phone = phone;
        this.ownRevenueNumbers = ownRevenueNumbers;
        this.oppRevenueNumbers = oppRevenueNumbers;
        this.beginDate = beginDate;
        this.endDate = endDate;
        this.invoicestatue = invoicestatue;
        this.cache = this.cache;
        this.client = new HttpClient();
    }

    @Override
    protected void beforeInvoking() throws BeforeInvokingRemoteMethodException {
        String url = this.getBaseUrl() + String.format("/api/ssl/invoice/getInvoices.action?access_token=%s&phoneNumber=%s&state=%d", this.eivs.token, this.phone, this.invoicestatue);
        if (this.beginDate != null) {
            url = url + "&startDate=" + this.sdf.format(this.beginDate);
        }
        if (this.endDate != null) {
            url = url + "&endDate=" + this.sdf.format(this.endDate);
        }
        System.out.println("POSTURL " + url);
        this.httpPost = new PostMethod(url);
        Map numbers = H.JSMAP(new Object[0]);
        if (this.ownRevenueNumbers != null) {
            ArrayList<Map> ownNumbers = new ArrayList<Map>();
            for (String ownNumber : this.ownRevenueNumbers) {
                ownNumbers.add(H.JSMAP("ownRevenueNumber", ownNumber));
            }
            numbers.put("ownRevenueNumberList", ownNumbers);
        }
        if (this.oppRevenueNumbers != null) {
            ArrayList<Map> oppNumbers = new ArrayList<Map>();
            for (String oppNumber : this.oppRevenueNumbers) {
                oppNumbers.add(H.JSMAP("otherRevenueNumber", oppNumber));
            }
            numbers.put("otherRevenueNumberList", oppNumbers);
        }
        HttpMethodParams param1 = this.httpPost.getParams();
        param1.setContentCharset("UTF-8");
        String postParamstring = Kson.getGson().toJson((Object)numbers);
        System.out.println("POSTPARAM " + postParamstring);
        try {
            StringRequestEntity se = new StringRequestEntity(postParamstring, "application/json", "UTF-8");
            this.httpPost.setRequestEntity((RequestEntity)se);
        }
        catch (UnsupportedEncodingException e) {
            ThrowReturn.throwBeforeInvokingException(e, EIVCError.EIV_GETAPINVOICE_1001);
        }
    }

    @Override
    protected void invoking() throws InvokingRemoteMethodException {
        this.statusCode = super.execute(this.client, (HttpMethod)this.httpPost);
    }

    @Override
    protected void afterInvoking() throws AfterInvokingRemoteMethodException {
        Map out = this.getHttpResultAsMap((HttpMethod)this.httpPost);
        if (out == null || H.INT(out.get("errcode")) != 0) {
            ThrowReturn.throwAfterInvokingException(EIVCError.EIV_GETAPINVOICE_7001, out);
        } else {
            ApInvoiceInfo[] infos;
            Map<String, Object> outmap = H.generateMapping(null, new String[0]);
            Map<String, Object> ApInvoicemap = H.generateMapping(ApInvoiceInfo.class, "ddh\u2192orderNo", "kplx\u2192colortype", "fpdm\u2192code", "fphm\u2192number", "kprq\u2192billDate", "kprq\u2192bizDate", "hjbhsje\u2192amount", "kphjse\u2192taxRate", "jshjje\u2192totalAmount", "kpy\u2192drawer", "sky\u2192src_invperson_name", "fhr\u2192src_auditperson_name", "yfpdm\u2192srcCode", "yfphm\u2192srcNumber", "bz\u2192description", "xhf_nsrsbh\u2192taxRegisterNo", "xhf_mc\u2192asstActName", "xhf_dzdh\u2192opAddrPhone", "xhf_yhzh\u2192cussAcctBank", "ghf_nsrsbh\u2192selfRegisterNo", "ghf_mc\u2192src_company_name", "ghf_dzdh\u2192src_accountBank_phoneNumber", "checkcode\u2192checkcode", "ghf_yhzh\u2192accountBank.bankAccountNumber", "ghf_sj\u2192selfPhone", "pdf_url\u2192pdfUrl", "items\u2192entries");
            Map<String, Object> ApInvoiceEntrymap = H.generateMapping(ApInvoiceEntryInfo.class, "xmdw\u2192txtUnit", "ggxh\u2192txtMeasure", "se\u2192taxAmount", "xmmc\u2192txtMaterial", "xmdj\u2192unitprice", "xmsl\u2192quantity", "xmje\u2192amount", "sl\u2192taxRate");
            H.setCollectionMapping("datas", outmap, ApInvoicemap, ApInvoiceInfo[].class, null);
            H.setCollectionMapping("items\u2192entries", ApInvoicemap, ApInvoiceEntrymap, ApInvoiceEntryCollection.class, "add");
            Map ret = (Map)H.convert2Object(outmap, out);
            for (ApInvoiceInfo info : infos = (ApInvoiceInfo[])ret.get("datas")) {
                ApInvoiceEntryCollection entries = info.getEntries();
                for (int i = 0; i < entries.size(); ++i) {
                    ApInvoiceEntryInfo einfo = entries.get(i);
                    einfo.setActualAmount(H.BDEC(einfo.getTaxAmount()).add(H.BDEC(einfo.getAmount())));
                }
            }
            this.retVal = infos;
        }
    }

    @Override
    protected void finallyBlock() throws AfterInvokingRemoteMethodException {
        if (this.httpPost != null) {
            this.httpPost.releaseConnection();
        }
    }

    @Override
    protected Object getReturnValue() {
        return this.retVal;
    }

    public static void main(String[] args) throws RemoteMethodException {
    }
}

