/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.arap.gpt.util;

import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.log4j.Logger;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.context.Context;

public class DataToTableUtil {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fi.arap.gpt.velocity.VelocityUtil");

    public static String exchangeDateToHTML(String filePath, VelocityContext context) {
        try {
            Properties properties = new Properties();
            properties.setProperty("resource.loader", "class");
            properties.setProperty("class.resource.loader.class", "org.apache.velocity.runtime.resource.loader.ClasspathResourceLoader");
            VelocityEngine velocityEngine = new VelocityEngine(properties);
            StringWriter writer = new StringWriter();
            velocityEngine.mergeTemplate(filePath, "UTF-8", (Context)context, (Writer)writer);
            String result = writer.toString();
            writer.close();
            return result;
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage());
            return "";
        }
    }

    public static String generateHtmlTables(Map<String, List<List<String>>> dataMap) {
        if (dataMap == null || dataMap.isEmpty()) {
            return "";
        }
        StringBuilder html = new StringBuilder();
        for (Map.Entry<String, List<List<String>>> entry : dataMap.entrySet()) {
            String scenario = entry.getKey();
            List<List<String>> tableData = entry.getValue();
            html.append("<h2>").append(scenario).append("</h2>\n");
            html.append("<table border='1'>\n");
            html.append("<tr>\n");
            for (String header : tableData.get(0)) {
                html.append("<th>").append(header).append("</th>\n");
            }
            html.append("</tr>\n");
            for (int i = 1; i < tableData.size(); ++i) {
                List<String> rowData = tableData.get(i);
                html.append("<tr>\n");
                for (String cellData : rowData) {
                    html.append("<td>").append(cellData).append("</td>\n");
                }
                html.append("</tr>\n");
            }
            html.append("</table>\n<br>\n");
        }
        return html.toString();
    }

    public static String generateMarkdownTables(Map<String, List<List<String>>> dataMap) {
        if (dataMap == null || dataMap.isEmpty()) {
            return "";
        }
        StringBuilder markdown = new StringBuilder();
        for (Map.Entry<String, List<List<String>>> entry : dataMap.entrySet()) {
            int i;
            String scenario = entry.getKey();
            List<List<String>> tableData = entry.getValue();
            markdown.append("### ").append(scenario).append("\n\n");
            markdown.append("| ");
            for (String header : tableData.get(0)) {
                markdown.append(header).append(" | ");
            }
            markdown.append("\n");
            markdown.append("| ");
            for (i = 0; i < tableData.get(0).size(); ++i) {
                markdown.append("--- | ");
            }
            markdown.append("\n");
            for (i = 1; i < tableData.size(); ++i) {
                List<String> rowData = tableData.get(i);
                markdown.append("| ");
                for (String cellData : rowData) {
                    markdown.append(cellData).append(" | ");
                }
                markdown.append("\n");
            }
            markdown.append("\n\n");
        }
        return markdown.toString();
    }

    public static void main(String[] args) {
        HashMap<String, List<List<String>>> map = new HashMap<String, List<List<String>>>();
        ArrayList lists = new ArrayList();
        ArrayList<String> lista = new ArrayList<String>();
        lista.add("\u5e8f\u53f7");
        lista.add("\u7f16\u7801");
        ArrayList<String> listb = new ArrayList<String>();
        listb.add("seq");
        listb.add("number");
        lists.add(lista);
        lists.add(listb);
        map.put("\u573a\u666f1", lists);
        String a = DataToTableUtil.generateMarkdownTables(map);
        System.out.println(a);
    }
}

