/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.arap.invoiceMatch.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.framework.DynamicObjectFactory;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.metadata.bot.BOTMappingInfo;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.transaction.EJBTransactionProxy;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.netctrl.IMutexServiceControl;
import com.kingdee.eas.base.netctrl.MutexServiceControlFactory;
import com.kingdee.eas.base.permission.UserCollection;
import com.kingdee.eas.base.permission.UserFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.master.cssp.SupplierCollection;
import com.kingdee.eas.basedata.master.cssp.SupplierFactory;
import com.kingdee.eas.basedata.master.cssp.SupplierInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitCollection;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.ap.OtherBillInfo;
import com.kingdee.eas.fi.ap.OtherBillentryCollection;
import com.kingdee.eas.fi.arap.fromeip.util.ConvertUtil;
import com.kingdee.eas.fi.arap.invoiceMatch.IInvoiceMatchFacade;
import com.kingdee.eas.fi.arap.invoiceMatch.IMRecordSrcSystemEnum;
import com.kingdee.eas.fi.arap.invoiceMatch.InvoiceMatchFacadeFactory;
import com.kingdee.eas.fi.arap.invoiceMatch.InvoiceMatchRecordCollection;
import com.kingdee.eas.fi.arap.invoiceMatch.InvoiceMatchRecordEntryCollection;
import com.kingdee.eas.fi.arap.invoiceMatch.InvoiceMatchRecordEntryInfo;
import com.kingdee.eas.fi.arap.invoiceMatch.InvoiceMatchRecordInfo;
import com.kingdee.eas.fi.arap.invoiceMatch.MatchBillConfigFactory;
import com.kingdee.eas.fi.arap.invoiceMatch.MatchBillConfigInfo;
import com.kingdee.eas.fi.arap.invoiceMatch.MatchBillConfigType;
import com.kingdee.eas.fi.arap.invoiceMatch.RecordMatchTypeEnum;
import com.kingdee.eas.fi.arap.invoiceMatch.app.AbstractAutoInvoiceMatchFacadeControllerBean;
import com.kingdee.eas.fi.arap.invoiceMatch.config.AbstractConfigHelper;
import com.kingdee.eas.fi.arap.invoiceMatch.util.MatchConstant;
import com.kingdee.eas.fi.arap.util.ArApBillHelper;
import com.kingdee.eas.fi.arap.util.invoice.IncomeInvoiceServerUtils;
import com.kingdee.eas.scm.im.inv.PurInWarehsEntryCollection;
import com.kingdee.eas.scm.im.inv.PurInWarehsEntryFactory;
import com.kingdee.eas.scm.im.inv.PurInWarehsEntryInfo;
import com.kingdee.eas.scm.sm.pur.PurOrderCollection;
import com.kingdee.eas.scm.sm.pur.PurOrderFactory;
import com.kingdee.eas.scm.sm.pur.PurOrderInfo;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.LowTimer;
import com.kingdee.util.StringUtils;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import net.sf.json.JSONObject;
import org.apache.log4j.Logger;

public class AutoInvoiceMatchFacadeControllerBean
extends AbstractAutoInvoiceMatchFacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fi.arap.invoiceMatch.app.AutoInvoiceMatchFacadeControllerBean");
    private static boolean isSupport = false;
    private AbstractConfigHelper bizConfigHelper = null;
    private AbstractConfigHelper invoiceConfigHelper = null;
    private AbstractConfigHelper recordConfigHelper = null;
    private String billType = null;
    private CompanyOrgUnitInfo company = null;
    private SupplierInfo supplier = null;
    private Map<String, String> msgMap = new HashMap<String, String>();
    private List<String> hasMatchedMap = new ArrayList<String>();
    private int step = 1;
    private String logMsgBegin = "@@@@@@@@@@@@@@\u81ea\u52a8\u4e09\u5355\u5339\u914d\uff1a";
    private Map<String, String> invoiceNumberMap = new HashMap<String, String>();
    private Map<String, Object> invoiceNumberObjectMap = new HashMap<String, Object>();
    private Map<String, Object> invoiceNoObjectMap = new HashMap<String, Object>();
    private Map<String, String> botpMsgMap = new HashMap<String, String>();
    private Map<String, String> botpIdCache = new HashMap<String, String>();
    private static final String BILLTYPE_PURINWAREHS = "instock";
    private static final String BILLTYPE_PURORDER = "order";
    private static final String BILLTYPE_PURRECEIVAL = "receipt";

    @Override
    protected Object _createApBill(Context ctx, Map data) throws BOSException, EASBizException {
        logger.error((Object)(this.logMsgBegin + "handleOriginal\u5165\u53e3json\u6570\u636e: " + data.toString()));
        if (this.msgMap.size() > 0) {
            this.msgMap.clear();
        }
        Map retMap = ConvertUtil.convertJsonToMap(ctx, data);
        String createUserIdString = this.getUserIdByNumber(ctx, data.get("usernumber"));
        Map returnData = (Map)retMap.get("data");
        this.initData(ctx, retMap);
        if (this.msgMap.size() > 0) {
            return JSONObject.fromObject(this.msgMap).toString();
        }
        InvoiceMatchRecordCollection coll = null;
        LowTimer timer = new LowTimer();
        if (this.msgMap.size() == 0) {
            Map billRelations = (Map)returnData.get(this.billType);
            logger.error((Object)(this.logMsgBegin + "[InvoiceMatch] Start : " + new Date()));
            coll = this.bulidInvoiceMatchRecord(ctx, billRelations);
            logger.error((Object)(this.logMsgBegin + "[InvoiceMatch] buildCollResult : " + coll.toString() + " ms"));
            logger.error((Object)(this.logMsgBegin + "[InvoiceMatch] buildColl : " + timer.msValue() + " ms"));
        }
        if (this.msgMap.size() == 0) {
            this.checkInvoiceMutexLock(ctx, coll);
        }
        Map result = new HashMap();
        if (this.msgMap.size() == 0 && coll != null && coll.size() > 0) {
            try {
                HashMap<String, Object> matchParams = new HashMap<String, Object>();
                matchParams.put(MatchConstant.MATCHRECORDCOLL, (Object)coll);
                matchParams.put(MatchConstant.CONFIGHELPER, this.bizConfigHelper);
                if (!StringUtils.isEmpty((String)createUserIdString)) {
                    HashMap<String, String> extParamsMapMap = new HashMap<String, String>();
                    extParamsMapMap.put(MatchConstant.CREATE_USER_ID, createUserIdString);
                    matchParams.put(MatchConstant.EXT_PARAMS, extParamsMapMap);
                }
                Method method = IInvoiceMatchFacade.class.getDeclaredMethod("invoiceMatch", Map.class);
                method.setAccessible(true);
                EJBTransactionProxy txInvoker = EJBFactory.getEJBTransactionProxy((Object)InvoiceMatchFacadeFactory.getLocalInstance(ctx));
                result = (Map)txInvoker.invoke(method, new Object[]{matchParams}, 3);
                logger.error((Object)(this.logMsgBegin + "[InvoiceMatch] invoiceMatch : " + timer.msValue() + " ms"));
            }
            catch (Throwable e) {
                throw new BOSException(e);
            }
        }
        Map resultMap = this.getResultData(result);
        JSONObject jsonObject = JSONObject.fromObject((Object)resultMap);
        return jsonObject.toString();
    }

    protected Map getResultData(Map result) {
        String errorMsg;
        int errCount;
        logger.error((Object)(this.logMsgBegin + "getResultData\u5165\u53e3\u6570\u636e\uff1a" + result.toString()));
        int n = errCount = result.get(MatchConstant.ERRCOUNT) == null ? 0 : (Integer)result.get(MatchConstant.ERRCOUNT);
        if (errCount > 0 && !StringUtils.isEmpty((String)(errorMsg = (String)result.get(MatchConstant.ERRMSG)))) {
            this.addErrorMsg(errorMsg.replaceAll("\\\\", ""));
        }
        HashMap resultMap = new HashMap();
        HashMap resultData = new HashMap();
        Map billInfos = result.get(MatchConstant.DESTBILLINFOS) == null ? new HashMap() : (Map)result.get(MatchConstant.DESTBILLINFOS);
        for (String invoiceNumber : this.invoiceNumberMap.keySet()) {
            HashMap<String, Object> infoData = new HashMap<String, Object>();
            infoData.put("status", 200);
            String reason = "";
            if (this.msgMap.size() > 0) {
                reason = this.msgMap.get(invoiceNumber);
                if (StringUtils.isEmpty((String)reason)) {
                    reason = this.msgMap.get("error");
                }
                if (!StringUtils.isEmpty((String)this.botpMsgMap.get(invoiceNumber))) {
                    reason = reason + this.botpMsgMap.get(invoiceNumber);
                }
            }
            infoData.put("invoiceCode", this.invoiceNumberObjectMap.get(invoiceNumber));
            infoData.put("invoiceNo", this.invoiceNoObjectMap.get(invoiceNumber));
            if (this.hasMatchedMap.contains(invoiceNumber) && !StringUtils.isEmpty((String)reason)) {
                infoData.put("status", 500);
                infoData.put("reason", reason);
            } else if (!StringUtils.isEmpty((String)reason)) {
                infoData.put("reason", reason);
            } else {
                String key = this.invoiceNumberMap.get(invoiceNumber);
                List infos = (List)billInfos.get(key);
                BigDecimal sumAmount = new BigDecimal("0.0");
                String apNumbers = "";
                for (int i = 0; i < infos.size(); ++i) {
                    OtherBillInfo info = (OtherBillInfo)infos.get(i);
                    apNumbers = apNumbers + info.getNumber();
                    if (i != 0) {
                        apNumbers = apNumbers + ",";
                    }
                    HashMap<String, String> infoMap = new HashMap<String, String>();
                    OtherBillentryCollection entryCol = info.getEntry();
                    for (int j = 0; j < entryCol.size(); ++j) {
                        infoMap.put(entryCol.get(j).getCoreBillEntryId(), info.getNumber());
                    }
                    infoData.put("billNumber", infoMap);
                    sumAmount = sumAmount.add(info.getAmount());
                }
                infoData.put("sumAmount", sumAmount);
                infoData.put("reason", "");
                infoData.put("apOtherBillNumber", apNumbers);
            }
            resultData.put(invoiceNumber, infoData);
        }
        resultMap.put(this.billType, resultData);
        return resultMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void checkInvoiceMutexLock(Context ctx, InvoiceMatchRecordCollection coll) throws BOSException {
        IMutexServiceControl mutexServiceControl = MutexServiceControlFactory.getLocalInstance((Context)ctx);
        ArrayList<String> idList = new ArrayList<String>();
        HashMap<String, String> numberMap = new HashMap<String, String>();
        for (int i = 0; i < coll.size(); ++i) {
            InvoiceMatchRecordEntryCollection entrys = coll.get(i).getEntry();
            for (int j = 0; j < entrys.size(); ++j) {
                InvoiceMatchRecordEntryInfo entry = entrys.get(j);
                if (StringUtils.isEmpty((String)entry.getBillID()) || !this.invoiceConfigHelper.getConfig().getSrcBosType().equals(entry.getBillBosType())) continue;
                String id = entry.getBillID();
                String number = entry.getBillNumber();
                numberMap.put(id, number);
                idList.add(id);
            }
        }
        try {
            Map map = mutexServiceControl.batchRequestObjIDForUpdate(idList);
            Set idSet = map.keySet();
            for (Object id : idSet) {
                if (((Boolean)map.get(id)).booleanValue()) continue;
                this.addErrorMsg(this.getResource(ctx, "Error_MatchLock", new Object[]{numberMap.get(id)}));
            }
        }
        finally {
            mutexServiceControl.batchReleaseObjIDForUpdate(idList);
        }
    }

    protected InvoiceMatchRecordCollection bulidInvoiceMatchRecord(Context ctx, Map<String, Map> billRelations) throws BOSException {
        InvoiceMatchRecordCollection coll = new InvoiceMatchRecordCollection();
        Map billRelation = null;
        for (String key : billRelations.keySet()) {
            String botpId;
            billRelation = billRelations.get(key);
            List<String> invoiceNo = ConvertUtil.convertObj2StrArr(billRelation.get("invoiceNo"));
            List<String> invoiceCode = ConvertUtil.convertObj2StrArr(billRelation.get("invoiceCode"));
            this.invoiceNumberMap.put(key, invoiceNo.toString().trim() + "_" + invoiceCode.toString().trim());
            this.invoiceNumberObjectMap.put(key, invoiceCode);
            this.invoiceNoObjectMap.put(key, invoiceNo);
            String companyNumber = (String)billRelation.get("companyNumber");
            this.company = this.getCompanyInfoByNumber(ctx, companyNumber);
            if (this.company == null) {
                this.addErrorMsg(key, this.getResource(ctx, "CAN_NOT_GETCOMPANY"));
                continue;
            }
            String supplierNumber = (String)billRelation.get("supplierNumber");
            this.supplier = this.getSupplierInfoByNumber(ctx, supplierNumber);
            if (this.supplier == null) {
                this.addErrorMsg(key, this.getResource(ctx, "CAN_NOT_GETSUPPLIER"));
                continue;
            }
            String companyId = this.company.getId().toString();
            if (this.botpIdCache.get(companyId) != null) {
                botpId = this.botpIdCache.get(companyId);
            } else {
                BOTMappingInfo botp = this.getBotpMapingInfo(ctx);
                if (botp == null) {
                    this.addErrorMsg(key, this.getResource(ctx, "INVOICE_BILL_NUMBER") + key + this.getResource(ctx, "BOTP_ISNULL"));
                    continue;
                }
                String botpMsg = this.getResource(ctx, "BOTPNUMBER_INFO", new String[]{botp.getName(), this.company.getNumber()});
                this.botpMsgMap.put(key, botpMsg);
                logger.error((Object)(this.logMsgBegin + botpMsg));
                botpId = botp.getId().toString();
                this.botpIdCache.put(companyId, botpId);
            }
            InvoiceMatchRecordInfo info = new InvoiceMatchRecordInfo();
            info.put(MatchConstant.BOTP_ID, botpId);
            info.setId(BOSUuid.create((String)MatchConstant.BOSTYPE_INVOICEMATCHRECORD));
            info.setCompany(this.company);
            info.setSupplier(this.supplier);
            info.setBillQtyTotal(BigDecimal.ZERO);
            info.setBillAmtTotal(BigDecimal.ZERO);
            info.setInvoiceQtyTotal(BigDecimal.ZERO);
            info.setInvoiceAmtTotal(BigDecimal.ZERO);
            info.setSrcSystem(IMRecordSrcSystemEnum.MANUAL);
            info.setRecordMatchType(RecordMatchTypeEnum.AUTOGEN);
            InvoiceMatchRecordEntryCollection entryColl = info.getEntry();
            entryColl.addCollection(this.createInvoiceMatchEntryInfo(ctx, billRelation, key));
            if (entryColl.size() <= 0) continue;
            coll.add(info);
        }
        logger.error((Object)(this.logMsgBegin + "invoiceNumberMap\u6570\u636e\uff1a" + this.invoiceNumberMap.toString()));
        HashMap records = new HashMap();
        return coll;
    }

    protected InvoiceMatchRecordEntryCollection createInvoiceMatchEntryInfo(Context ctx, Map billRelation, String key) throws BOSException {
        InvoiceMatchRecordEntryCollection invoiceMatchRecordEntryCol;
        BigDecimal entryQty;
        BigDecimal entryAmount;
        InvoiceMatchRecordEntryCollection coll = new InvoiceMatchRecordEntryCollection();
        Map invoiceTaxAmountMap = (Map)billRelation.get("invoiceTaxAmount");
        Map invoiceQtyMap = (Map)billRelation.get("invoiceQty");
        Map billEntryRelation = (Map)billRelation.get("entry");
        BigDecimal sumInvoiceAmount = BigDecimal.ZERO;
        BigDecimal sumInvoiceQty = BigDecimal.ZERO;
        HashSet<String> entryIdSet = new HashSet<String>();
        HashSet<String> IdSet = new HashSet<String>();
        for (String billId : billEntryRelation.keySet()) {
            IdSet.add(billId);
            List<String> entryIdList = ConvertUtil.convertObj2StrArr(billEntryRelation.get(billId));
            for (String entryId : entryIdList) {
                if (invoiceTaxAmountMap.get(entryId) == null || invoiceQtyMap.get(entryId) == null) {
                    this.addErrorMsg(key, this.getResource(ctx, "DATA_RELATION_ERROR") + entryId);
                    coll.clear();
                    return coll;
                }
                entryAmount = new BigDecimal(invoiceTaxAmountMap.get(entryId).toString());
                entryQty = new BigDecimal(invoiceQtyMap.get(entryId).toString());
                sumInvoiceAmount = sumInvoiceAmount.add(entryAmount);
                sumInvoiceQty = sumInvoiceQty.add(entryQty);
                entryIdSet.add(entryId);
            }
        }
        if (BILLTYPE_PURINWAREHS.equals(this.billType)) {
            Map<String, PurInWarehsEntryInfo> inWarehsInfoMap = this.getPurInWarehsInfoMap(ctx, entryIdSet);
            BigDecimal tempSumInvoiceAmount = BigDecimal.ZERO;
            for (String billId : billEntryRelation.keySet()) {
                List<String> entryIdList = ConvertUtil.convertObj2StrArr(billEntryRelation.get(billId));
                for (int i = 0; i < entryIdList.size(); ++i) {
                    String entryId = entryIdList.get(i);
                    PurInWarehsEntryInfo inWarehsEntryInfo = inWarehsInfoMap.get(entryId);
                    if (inWarehsEntryInfo == null) {
                        this.addErrorMsg(key, this.getResource(ctx, "CAN_NOT_GET_BIZ_ID") + entryId);
                        coll.clear();
                        return coll;
                    }
                    entryQty = new BigDecimal(invoiceQtyMap.get(entryId).toString());
                    entryAmount = new BigDecimal(invoiceTaxAmountMap.get(entryId).toString());
                    InvoiceMatchRecordEntryInfo entryInfo = new InvoiceMatchRecordEntryInfo();
                    entryInfo.setBillID(billId);
                    entryInfo.setBillEntryID(entryId);
                    entryInfo.setBillBosType(this.bizConfigHelper.getConfig().getSrcBosType());
                    entryInfo.setBillName(this.bizConfigHelper.getConfig().getSrcBillName());
                    entryInfo.setBillNumber(inWarehsEntryInfo.getParent().getNumber());
                    entryInfo.setMatchedQty(entryQty);
                    entryInfo.setMatchedAmt(entryAmount);
                    entryInfo.setStepSeq(this.step);
                    coll.add(entryInfo);
                }
            }
        } else if (BILLTYPE_PURRECEIVAL.equals(this.billType)) {
            Map<String, PurOrderInfo> orderInfoMap = this.getPurOrderInfoMap(ctx, IdSet);
            for (String billId : billEntryRelation.keySet()) {
                PurOrderInfo orderInfo = orderInfoMap.get(billId);
                if (orderInfo == null) {
                    this.addErrorMsg(key, this.getResource(ctx, "CAN_NOT_GET_BIZ_ID") + billId);
                    coll.clear();
                    return coll;
                }
                List<String> entryIdList = ConvertUtil.convertObj2StrArr(billEntryRelation.get(billId));
                for (String entryId : entryIdList) {
                    entryAmount = new BigDecimal(invoiceTaxAmountMap.get(entryId).toString());
                    entryQty = new BigDecimal(invoiceQtyMap.get(entryId).toString());
                    InvoiceMatchRecordEntryInfo entryInfo = new InvoiceMatchRecordEntryInfo();
                    entryInfo.setBillID(billId);
                    entryInfo.setBillEntryID(entryId);
                    entryInfo.setBillBosType(this.bizConfigHelper.getConfig().getSrcBosType());
                    entryInfo.setBillName(this.bizConfigHelper.getConfig().getSrcBillName());
                    entryInfo.setBillNumber(orderInfo.getNumber());
                    entryInfo.setMatchedQty(entryQty);
                    entryInfo.setMatchedAmt(entryAmount);
                    entryInfo.setStepSeq(this.step);
                    coll.add(entryInfo);
                }
            }
        }
        if ((invoiceMatchRecordEntryCol = this.getInvoiceMatchRecordEntryToInvoice(ctx, billRelation, sumInvoiceAmount, sumInvoiceQty, key)).size() == 0) {
            coll.clear();
        } else {
            coll.addCollection(invoiceMatchRecordEntryCol);
        }
        return coll;
    }

    private BigDecimal convertPurOrderQty(BigDecimal qty, PurRecOrderInfo purRecOrderInfo) {
        if (qty == null) {
            return BigDecimal.ZERO;
        }
        if (purRecOrderInfo.getPurRecUnitId().equals(purRecOrderInfo.getOrderUnitId())) {
            return qty;
        }
        qty = qty.multiply(purRecOrderInfo.getPurBaseConvsRate()).divide(purRecOrderInfo.getOrdBaseConvsRate(), purRecOrderInfo.getOrdQtyPrecision(), 4);
        return qty;
    }

    public IObjectValue getObjectById(Context ctx, String id) {
        ObjectUuidPK pk = new ObjectUuidPK(id);
        IObjectValue objVal = null;
        try {
            objVal = DynamicObjectFactory.getLocalInstance((Context)ctx).getValue(pk.getObjectType(), (IObjectPK)pk);
        }
        catch (BOSException e) {
            logger.error((Object)e.getMessage());
        }
        return objVal;
    }

    protected InvoiceMatchRecordEntryCollection getInvoiceMatchRecordEntryToInvoice(Context ctx, Map billRelation, BigDecimal invoiceAmount, BigDecimal invoiceQty, String key) throws BOSException {
        InvoiceMatchRecordEntryCollection coll = new InvoiceMatchRecordEntryCollection();
        List<String> invoiceNos = ConvertUtil.convertObj2StrArr(billRelation.get("invoiceNo"));
        List<String> invoiceCodes = ConvertUtil.convertObj2StrArr(billRelation.get("invoiceCode"));
        for (int i = 0; i < invoiceCodes.size(); ++i) {
            String invoiceCode;
            String invoiceNo = invoiceNos.get(i);
            IRowSet rs = this.getEASIncomeInvoice(ctx, invoiceNo, invoiceCode = invoiceCodes.get(i), billRelation);
            if (rs != null && rs.size() > 0) {
                logger.error((Object)(this.logMsgBegin + "\u4ece\u7a0e\u52a1\u4e2d\u67e5\u8be2\u5230\u53d1\u7968" + invoiceNo + "_" + invoiceCode));
                try {
                    BigDecimal EASInvoiceAmount = BigDecimal.ZERO;
                    while (rs.next()) {
                        if (!this.checkEASInvoice(ctx, rs, key, invoiceNo).booleanValue()) {
                            coll.clear();
                            return coll;
                        }
                        InvoiceMatchRecordEntryInfo entryInfo = new InvoiceMatchRecordEntryInfo();
                        entryInfo.setBillID(rs.getString("BillFID"));
                        entryInfo.setBillEntryID(rs.getString("EntryFID"));
                        entryInfo.setBillBosType(this.invoiceConfigHelper.getConfig().getSrcBosType());
                        entryInfo.setBillName(this.invoiceConfigHelper.getConfig().getSrcBillName());
                        entryInfo.setBillNumber(invoiceNo);
                        entryInfo.put(MatchConstant.INVOICE_CODE, invoiceCode);
                        entryInfo.setMatchedQty(rs.getBigDecimal("EntryFQuantity"));
                        entryInfo.setMatchedAmt(rs.getBigDecimal("EntryFTaxTotal"));
                        entryInfo.setStepSeq(this.step);
                        coll.add(entryInfo);
                    }
                    continue;
                }
                catch (SQLException e) {
                    throw new BOSException((Throwable)e);
                }
            }
            logger.error((Object)(this.logMsgBegin + "EAS\u7cfb\u7edf\u65e0\u6b64\u53d1\u7968" + invoiceNo + "_" + invoiceCode));
            InvoiceMatchRecordEntryInfo entryInfo = new InvoiceMatchRecordEntryInfo();
            entryInfo.setBillID(null);
            entryInfo.setBillEntryID(null);
            entryInfo.setBillBosType(this.invoiceConfigHelper.getConfig().getSrcBosType());
            entryInfo.setBillName(this.invoiceConfigHelper.getConfig().getSrcBillName());
            entryInfo.setBillNumber(invoiceNo);
            entryInfo.put(MatchConstant.INVOICE_CODE, invoiceCode);
            entryInfo.setMatchedQty(invoiceQty);
            entryInfo.setMatchedAmt(invoiceAmount);
            entryInfo.setStepSeq(this.step);
            coll.add(entryInfo);
        }
        return coll;
    }

    protected Boolean checkEASInvoice(Context ctx, IRowSet rs, String key, String invoiceNo) throws SQLException {
        String isAccept;
        String status;
        String bizBillType = rs.getString("FBizBIllTypeID");
        if (!StringUtils.isEmpty((String)bizBillType) && !MatchConstant.TYPEID_PAYREQUESTBILL.equalsIgnoreCase(bizBillType)) {
            this.addErrorMsg(key, this.getResource(ctx, "HAS_MATCHRECORD_CANNOT_REPART", new Object[]{invoiceNo}));
            this.hasMatchedMap.add(key);
            return false;
        }
        Boolean result = true;
        String companyId = rs.getString("FCompanyId");
        if (!this.company.getId().toString().equals(companyId)) {
            String companyName = rs.getString("FCompanyName");
            this.addErrorMsg(key, this.getResource(ctx, "BIZ_BILL_NOTEQUALS_INVOCE", new Object[]{this.company.getName(), invoiceNo, companyName}));
            result = false;
        }
        String supplierId = rs.getString("FSupplierId");
        if (!this.supplier.getId().toString().equals(supplierId)) {
            String supplierName = rs.getString("FSupplierName");
            this.addErrorMsg(key, this.getResource(ctx, "BIZ_BILL_NOTEQUALS_SUPPLIER", new Object[]{this.supplier.getName(), invoiceNo, supplierName}));
            result = false;
        }
        if (!"0".equals(status = rs.getString("FStatus")) && !"4".equals(status)) {
            this.addErrorMsg(key, this.getResource(ctx, "INCOICE_STATUS_ERROR", new Object[]{invoiceNo}));
            result = false;
        }
        if (!"1".equals(isAccept = rs.getString("FIsAccept"))) {
            this.addErrorMsg(key, this.getResource(ctx, "INCOICE_NOT_ACCEEPT", new Object[]{invoiceNo}));
            result = false;
        }
        return result;
    }

    private IRowSet getEASIncomeInvoice(Context ctx, String invoiceNo, String invoiceCode, Map invoiceData) throws BOSException {
        if (!isSupport) {
            return null;
        }
        String localStr = "l2";
        if (ctx.getLocale() != null) {
            localStr = ctx.getLocale().getLanguage();
        }
        StringBuffer sql = new StringBuffer();
        sql.append(" Select ");
        sql.append(" company.Fid  FCompanyId, ").append('\n');
        sql.append(" company.FName_").append(localStr).append("  FCompanyName, ").append('\n');
        sql.append(" supplier.Fid  FSupplierId, ").append('\n');
        sql.append(" supplier.FName_").append(localStr).append("  FSupplierName, ").append('\n');
        sql.append(" parent.FStatus  FStatus, ").append('\n');
        sql.append(" parent.FIsAccept  FIsAccept, ").append('\n');
        sql.append(" parent.FInvoiceCode  FInvoiceCode, ").append('\n');
        sql.append(" parent.FInvoiceNumber FInvoiceNumber, ").append('\n');
        sql.append(" parent.FBizDate FInvoiceNumber, ").append('\n');
        sql.append(" parent.FAmountTax BillFAmountTax, ").append('\n');
        sql.append(" parent.FBizBIllTypeID FBizBIllTypeID, ").append('\n');
        sql.append(" parent.FID BillFID, ").append('\n');
        sql.append(" entry.FID EntryFID, ").append('\n');
        sql.append(" entry.FSeq FSEQ, ").append('\n');
        sql.append(" entry.FQuantity EntryFQuantity, ").append('\n');
        sql.append(" entry.FTaxTotal EntryFTaxTotal").append('\n');
        sql.append(" From T_IM_IncomeInvoice parent ").append('\n');
        sql.append(" Left Join T_IM_IncomeInvoiceEntry entry on parent.FID = entry.FIncomeInvoiceID ").append('\n');
        sql.append(" Left Join T_BD_Supplier supplier on parent.FCurrAcctSupplierID = supplier.Fid ").append("\n");
        sql.append(" Inner Join T_ORG_Company company on parent.FCompanyID = company.Fid").append("\n");
        sql.append(" where 1=1 ").append('\n');
        sql.append(" and parent.FInvoiceCode = '").append(invoiceCode).append("'\n");
        sql.append(" and parent.FInvoiceNumber = '").append(invoiceNo).append("'\n");
        IRowSet rs = null;
        logger.info((Object)(this.logMsgBegin + "\u67e5\u8be2\u7a0e\u52a1\u53d1\u7968SQL:" + sql.toString()));
        rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        return rs;
    }

    private Map<String, String> addErrorMsg(String errorStr) {
        return this.addErrorMsg("error", errorStr);
    }

    private Map<String, String> addErrorMsg(String key, String errorStr) {
        logger.error((Object)(this.logMsgBegin + errorStr));
        if (StringUtils.isEmpty((String)this.msgMap.get(key))) {
            this.msgMap.put(key, errorStr);
        } else {
            this.msgMap.put(key, this.msgMap.get(key) + errorStr);
        }
        return this.msgMap;
    }

    private void initData(Context ctx, Map retMap) throws BOSException {
        Map returnData = (Map)retMap.get("data");
        this.billType = (String)returnData.get("srcBillType");
        isSupport = IncomeInvoiceServerUtils.isSupport();
        logger.info((Object)(this.logMsgBegin + "\u662f\u5426\u652f\u6301EAS\u7a0e\u52a1:" + isSupport));
        String srcBosType = null;
        if (BILLTYPE_PURORDER.equalsIgnoreCase(this.billType) || BILLTYPE_PURRECEIVAL.equals(this.billType)) {
            srcBosType = "3171BFAD";
        } else if (BILLTYPE_PURINWAREHS.equalsIgnoreCase(this.billType)) {
            srcBosType = "783061E3";
        } else {
            logger.error((Object)(this.logMsgBegin + this.getResource(ctx, "BILL_TYPE_ERROE")));
            this.addErrorMsg(this.getResource(ctx, "BILL_TYPE_ERROE"));
            return;
        }
        logger.info((Object)(this.logMsgBegin + "\u6e90\u5355\u636e\u7c7b\u578bBOSTYPE:" + srcBosType));
        String destBosType = OtherBillInfo.getBosType();
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("isDefault", (Object)Boolean.TRUE));
        filter.getFilterItems().add(new FilterItemInfo("type", (Object)"1", CompareType.NOTEQUALS));
        filter.getFilterItems().add(new FilterItemInfo("srcBosType", (Object)srcBosType));
        filter.getFilterItems().add(new FilterItemInfo("destBosType", (Object)destBosType));
        filter.getFilterItems().add(new FilterItemInfo("type", (Object)"1"));
        filter.setMaskString("(#0 and #1) or (#2 and #3 and #4)");
        view.setFilter(filter);
        Map result = null;
        try {
            result = MatchBillConfigFactory.getLocalInstance(ctx).getConfig(view);
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage());
        }
        MatchBillConfigInfo bizConfig = (MatchBillConfigInfo)result.get((Object)MatchBillConfigType.BIZ);
        MatchBillConfigInfo invoiceConfig = (MatchBillConfigInfo)result.get((Object)MatchBillConfigType.INVOICE);
        MatchBillConfigInfo recordConfig = (MatchBillConfigInfo)result.get((Object)MatchBillConfigType.RECORD);
        this.bizConfigHelper = (AbstractConfigHelper)result.get(bizConfig.getId().toString());
        this.invoiceConfigHelper = (AbstractConfigHelper)result.get(invoiceConfig.getId().toString());
        this.recordConfigHelper = (AbstractConfigHelper)result.get(recordConfig.getId().toString());
    }

    private BOTMappingInfo getBotpMapingInfo(Context ctx) {
        BOSObjectType srcBosType = BOSObjectType.create((String)this.bizConfigHelper.getConfig().getSrcBosType());
        BOSObjectType destBosType = BOSObjectType.create((String)OtherBillInfo.getBosType());
        String cuId = this.company.getCU().getId().toString();
        BOTMappingInfo botMappingInfo = ArApBillHelper.getBotpMappingInfo(ctx, srcBosType, destBosType, cuId);
        return botMappingInfo;
    }

    public CompanyOrgUnitInfo getCompanyInfoByNumber(Context ctx, String companyNumber) throws BOSException {
        CompanyOrgUnitInfo companyInfo = null;
        if (!StringUtils.isEmpty((String)companyNumber)) {
            EntityViewInfo evi = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("id"));
            sic.add(new SelectorItemInfo("name"));
            sic.add(new SelectorItemInfo("number"));
            sic.add(new SelectorItemInfo("cu.id"));
            filter.getFilterItems().add(new FilterItemInfo("number", (Object)companyNumber, CompareType.EQUALS));
            evi.setFilter(filter);
            evi.setSelector(sic);
            CompanyOrgUnitCollection coll = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitCollection(evi);
            if (coll != null && coll.size() > 0) {
                companyInfo = coll.get(0);
            }
        }
        return companyInfo;
    }

    public SupplierInfo getSupplierInfoByNumber(Context ctx, String supplierNumber) throws BOSException {
        SupplierInfo info = null;
        if (!StringUtils.isEmpty((String)supplierNumber)) {
            EntityViewInfo evi = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("id"));
            sic.add(new SelectorItemInfo("name"));
            sic.add(new SelectorItemInfo("number"));
            filter.getFilterItems().add(new FilterItemInfo("number", (Object)supplierNumber, CompareType.EQUALS));
            evi.setFilter(filter);
            evi.setSelector(sic);
            SupplierCollection coll = SupplierFactory.getLocalInstance((Context)ctx).getSupplierCollection(evi);
            if (coll != null && coll.size() > 0) {
                info = coll.get(0);
            }
        }
        return info;
    }

    public Map<String, PurOrderInfo> getPurOrderInfoMap(Context ctx, Set<String> idSet) throws BOSException {
        HashMap<String, PurOrderInfo> orderInfoMap = new HashMap<String, PurOrderInfo>();
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", idSet, CompareType.INCLUDE));
        view.setFilter(filter);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("name"));
        sic.add(new SelectorItemInfo("number"));
        view.setSelector(sic);
        PurOrderCollection coll = PurOrderFactory.getLocalInstance((Context)ctx).getPurOrderCollection(view);
        for (int i = 0; i < coll.size(); ++i) {
            orderInfoMap.put(coll.get(i).getId().toString(), coll.get(i));
        }
        return orderInfoMap;
    }

    public Map<String, PurInWarehsEntryInfo> getPurInWarehsInfoMap(Context ctx, Set<String> entryIdSet) throws BOSException {
        HashMap<String, PurInWarehsEntryInfo> inWarehsInfoMap = new HashMap<String, PurInWarehsEntryInfo>();
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", entryIdSet, CompareType.INCLUDE));
        view.setFilter(filter);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("parent.number"));
        sic.add(new SelectorItemInfo("unWriteOffQty"));
        sic.add(new SelectorItemInfo("taxPrice"));
        view.setSelector(sic);
        PurInWarehsEntryCollection coll = PurInWarehsEntryFactory.getLocalInstance((Context)ctx).getPurInWarehsEntryCollection(view);
        for (int i = 0; i < coll.size(); ++i) {
            inWarehsInfoMap.put(coll.get(i).getId().toString(), coll.get(i));
        }
        return inWarehsInfoMap;
    }

    public Map<String, PurRecOrderInfo> getPurReceivalOrderInfoMap(Context ctx, Set<String> entryIdSet) throws BOSException {
        HashMap<String, PurRecOrderInfo> purRecOrderInfoMap = new HashMap<String, PurRecOrderInfo>();
        StringBuffer sql = new StringBuffer(200);
        sql.append(" select recEntry.fid as recEntryId,recEntry.FPURORDERENTRYID as orderEntryId, recEntry.FPurOrderID  as orderId,recEntry.FUNITID  as purRecUnitId,ordEntry.FUNITID as orderUnitId,ord.FNUMBER  as ordNumber, ");
        sql.append(" ordEntry.FMATERIALID  as materialId,purmmu.FBaseConvsRate as purBaseConvsRate,purmmu.FQtyPrecision as purQtyPrecision,ordmmu.FBaseConvsRate as ordBaseConvsRate,ordmmu.FQtyPrecision as ordQtyPrecision ");
        sql.append(" from T_IM_PurReceivalentry recEntry  ");
        sql.append(" inner join T_BD_MultiMeasureUnit  purmmu on recEntry.FMATERIALID  = purmmu.FMATERIALID  and recEntry.FUNITID  = purmmu.FMEASUREUNITID ");
        sql.append(" inner join T_SM_PurOrderEntry ordEntry on  recEntry.FPURORDERENTRYID  = ordEntry.fid ");
        sql.append(" inner join T_BD_MultiMeasureUnit  ordmmu on ordEntry.FMATERIALID  = ordmmu.FMATERIALID  and ordEntry.FUNITID  = ordmmu.FMEASUREUNITID ");
        sql.append(" inner join T_SM_PurOrder ord on ordEntry.FPARENTID  = ord.fid ");
        sql.append(" where recEntry.fid ").append(ConvertUtil.set2StrBuf(entryIdSet));
        try {
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
            while (rs.next()) {
                PurRecOrderInfo purRecOrderInfo = new PurRecOrderInfo();
                purRecOrderInfo.setRecEntryId(rs.getString("recEntryId"));
                purRecOrderInfo.setOrdEntryId(rs.getString("orderEntryId"));
                purRecOrderInfo.setOrdId(rs.getString("orderId"));
                purRecOrderInfo.setPurRecUnitId(rs.getString("purRecUnitId"));
                purRecOrderInfo.setOrderUnitId(rs.getString("orderUnitId"));
                purRecOrderInfo.setOrdNumber(rs.getString("ordNumber"));
                purRecOrderInfo.setMaterialId(rs.getString("materialId"));
                purRecOrderInfo.setPurBaseConvsRate(rs.getBigDecimal("purBaseConvsRate"));
                purRecOrderInfo.setPurQtyPrecision(rs.getInt("purQtyPrecision"));
                purRecOrderInfo.setOrdBaseConvsRate(rs.getBigDecimal("ordBaseConvsRate"));
                purRecOrderInfo.setOrdQtyPrecision(rs.getInt("ordQtyPrecision"));
                purRecOrderInfoMap.put(purRecOrderInfo.getRecEntryId(), purRecOrderInfo);
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return purRecOrderInfoMap;
    }

    protected String getResource(Context ctx, String resName) {
        return ResourceBase.getString((String)MatchConstant.INVOICEMATCH_RESOURCE, (String)resName, (Locale)ctx.getLocale());
    }

    protected String getResource(Context ctx, String resName, Object[] params) {
        return ResourceBase.getString((String)MatchConstant.INVOICEMATCH_RESOURCE, (String)resName, (Locale)ctx.getLocale(), (Object[])params);
    }

    private String getUserIdByNumber(Context ctx, Object object) throws EASBizException, BOSException {
        if (object == null) {
            return null;
        }
        String userNumber = (String)object;
        String sql = "select fid where person.number = '" + userNumber + "'";
        UserCollection userColl = UserFactory.getLocalInstance((Context)ctx).getUserCollection(sql);
        UserInfo userInfo = null;
        if (userColl != null && userColl.size() > 0) {
            userInfo = userColl.get(0);
        }
        if (userInfo == null) {
            logger.error((Object)(this.logMsgBegin + "\u6839\u636e\u804c\u5458(person)\u7f16\u7801\uff1a" + userNumber + "\uff0c\u83b7\u53d6\u4eba\u5458(user)\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5EAS\u662f\u5426\u5b58\u5728\u8be5\u7528\u6237\u6240\u5bf9\u5e94\u7684\u8d26\u53f7"));
            return null;
        }
        return userInfo.getId().toString();
    }

    private class OrderMatchInfo {
        private String orderId;
        private String orderEntryId;
        private String orderNumber;
        private BigDecimal qty;
        private BigDecimal amount;

        private OrderMatchInfo() {
        }

        public String getOrderId() {
            return this.orderId;
        }

        public void setOrderId(String orderId) {
            this.orderId = orderId;
        }

        public String getOrderEntryId() {
            return this.orderEntryId;
        }

        public void setOrderEntryId(String orderEntryId) {
            this.orderEntryId = orderEntryId;
        }

        public String getOrderNumber() {
            return this.orderNumber;
        }

        public void setOrderNumber(String orderNumber) {
            this.orderNumber = orderNumber;
        }

        public BigDecimal getQty() {
            return this.qty;
        }

        public void setQty(BigDecimal qty) {
            this.qty = qty;
        }

        public BigDecimal getAmount() {
            return this.amount;
        }

        public void setAmount(BigDecimal amount) {
            this.amount = amount;
        }
    }

    public class PurRecOrderInfo {
        private String recEntryId;
        private String ordEntryId;
        private String ordId;
        private String purRecUnitId;
        private String orderUnitId;
        private String ordNumber;
        private String materialId;
        private BigDecimal purBaseConvsRate;
        private int purQtyPrecision;
        private BigDecimal ordBaseConvsRate;
        private int ordQtyPrecision;

        public String getRecEntryId() {
            return this.recEntryId;
        }

        public void setRecEntryId(String recEntryId) {
            this.recEntryId = recEntryId;
        }

        public String getOrdEntryId() {
            return this.ordEntryId;
        }

        public void setOrdEntryId(String ordEntryId) {
            this.ordEntryId = ordEntryId;
        }

        public String getOrdId() {
            return this.ordId;
        }

        public void setOrdId(String ordId) {
            this.ordId = ordId;
        }

        public String getPurRecUnitId() {
            return this.purRecUnitId;
        }

        public void setPurRecUnitId(String purRecUnitId) {
            this.purRecUnitId = purRecUnitId;
        }

        public String getOrderUnitId() {
            return this.orderUnitId;
        }

        public void setOrderUnitId(String orderUnitId) {
            this.orderUnitId = orderUnitId;
        }

        public String getOrdNumber() {
            return this.ordNumber;
        }

        public void setOrdNumber(String ordNumber) {
            this.ordNumber = ordNumber;
        }

        public String getMaterialId() {
            return this.materialId;
        }

        public void setMaterialId(String materialId) {
            this.materialId = materialId;
        }

        public BigDecimal getPurBaseConvsRate() {
            return this.purBaseConvsRate;
        }

        public void setPurBaseConvsRate(BigDecimal purBaseConvsRate) {
            this.purBaseConvsRate = purBaseConvsRate;
        }

        public int getPurQtyPrecision() {
            return this.purQtyPrecision;
        }

        public void setPurQtyPrecision(int purQtyPrecision) {
            this.purQtyPrecision = purQtyPrecision;
        }

        public BigDecimal getOrdBaseConvsRate() {
            return this.ordBaseConvsRate;
        }

        public void setOrdBaseConvsRate(BigDecimal ordBaseConvsRate) {
            this.ordBaseConvsRate = ordBaseConvsRate;
        }

        public int getOrdQtyPrecision() {
            return this.ordQtyPrecision;
        }

        public void setOrdQtyPrecision(int ordQtyPrecision) {
            this.ordQtyPrecision = ordQtyPrecision;
        }
    }
}

