/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.arap.invoiceMatch.util;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.core.util.StringUtil;
import com.kingdee.eas.base.netctrl.IMutexServiceControl;
import com.kingdee.eas.basedata.org.CompanyOrgUnitCollection;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.client.f7.NewOrgUnitFilterInfoProducer;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fi.arap.invoiceMatch.InvoiceMatchException;
import com.kingdee.eas.fi.arap.invoiceMatch.util.MatchConstant;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.client.FrameWorkClientUtils;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class MatchUtils {
    private static BiMap<String, String> invoiceTypeBiMap = HashBiMap.create((int)2);

    public static void buildBOTPRelation(Context ctx, List<String[]> relation) throws BOSException {
        Connection conn = null;
        PreparedStatement pstmt = null;
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            StringBuffer sql = new StringBuffer();
            sql.setLength(0);
            sql.append("INSERT INTO t_bot_relation(FID,FSrcEntityID,FDestEntityID,FSrcObjectID,FDestObjectID,FDate,FOperatorID,FisEffected,FType)");
            sql.append(" values(?,?,?,?,?,?,?,?,?)");
            Date date = new Date(System.currentTimeMillis());
            pstmt = conn.prepareStatement(sql.toString());
            for (String[] params : relation) {
                pstmt.setString(1, BOSUuid.create((String)MatchConstant.BOSTYPE_BOTP).toString());
                pstmt.setString(2, params[0]);
                pstmt.setString(3, params[1]);
                pstmt.setString(4, params[2]);
                pstmt.setString(5, params[3]);
                pstmt.setDate(6, date);
                pstmt.setString(7, params[4]);
                pstmt.setInt(8, 1);
                pstmt.setInt(9, 0);
                pstmt.addBatch();
            }
            pstmt.executeBatch();
        }
        catch (SQLException e) {
            try {
                throw new BOSException(e.getMessage());
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)pstmt, (Connection)conn);
    }

    public static Object[] getIdArray(Object object) {
        if (object == null) {
            return null;
        }
        ArrayList<String> ids = new ArrayList<String>();
        if (object instanceof Object[]) {
            Object[] infos;
            for (Object info : infos = (Object[])object) {
                if (info == null) {
                    return null;
                }
                if (info instanceof CoreBaseInfo) {
                    ids.add(((CoreBaseInfo)info).getId().toString());
                    continue;
                }
                ids.add(info.toString());
            }
        } else if (object instanceof CoreBaseInfo) {
            ids.add(((CoreBaseInfo)object).getId().toString());
        }
        return ids.toArray();
    }

    public static String buildIn(String name, Object[] set) {
        if (set == null || set.length == 0) {
            return " ";
        }
        StringBuffer sb = new StringBuffer(1204);
        int size = set.length;
        int num = size / 800;
        int j = 0;
        sb.append("(");
        for (int i = 0; i < num; ++i) {
            sb.append(" ");
            sb.append(name);
            sb.append(" ");
            sb.append(" in (");
            StringUtil.appendStrValue((StringBuffer)sb, (Object)set[j]);
            ++j;
            while (j < (i + 1) * 800) {
                sb.append(",");
                StringUtil.appendStrValue((StringBuffer)sb, (Object)set[j]);
                ++j;
            }
            sb.append(")\n ");
            sb.append(" or ");
        }
        if (j == size) {
            sb.delete(sb.length() - 4, sb.length());
            sb.append(" )");
            return sb.toString();
        }
        sb.append(" " + name + " ");
        sb.append(" in (");
        StringUtil.appendStrValue((StringBuffer)sb, (Object)set[j]);
        ++j;
        while (j < size) {
            sb.append(",");
            StringUtil.appendStrValue((StringBuffer)sb, (Object)set[j]);
            ++j;
        }
        sb.append(")");
        sb.append(")");
        return sb.toString();
    }

    public static String buildLike(String name, String str) {
        if (str == null || str.length() == 0) {
            return " ";
        }
        StringBuffer sb = new StringBuffer();
        String[] split = str.split(";");
        sb.append("(");
        for (int i = 0; i < split.length; ++i) {
            sb.append(name).append(" like '%");
            sb.append(split[i]);
            sb.append("%' or ");
        }
        sb.delete(sb.length() - 4, sb.length());
        sb.append(")");
        return sb.toString();
    }

    public static String getStringFromCollection(Collection values) {
        StringBuffer sb = new StringBuffer();
        for (Object value : values) {
            if (sb.length() == 0) {
                sb.append(value.toString());
                continue;
            }
            sb.append(";").append(value.toString());
        }
        return sb.toString();
    }

    public static CompanyOrgUnitInfo getPermissionCompany(String permissionItem) throws BOSException, EASBizException {
        EntityViewInfo view = new EntityViewInfo();
        NewOrgUnitFilterInfoProducer iProducer = new NewOrgUnitFilterInfoProducer(OrgType.Company, permissionItem);
        FilterInfo tmpFilter = iProducer.getFilterInfo();
        view.setFilter(tmpFilter);
        CompanyOrgUnitCollection companyOrgUnitCollection = CompanyOrgUnitFactory.getRemoteInstance().getCompanyOrgUnitCollection(view);
        if (companyOrgUnitCollection.isEmpty()) {
            return null;
        }
        String companyId = SysContext.getSysContext().getCurrentFIUnit().getId().toString();
        for (int i = 0; i < companyOrgUnitCollection.size(); ++i) {
            CompanyOrgUnitInfo companyOrgUnitInfo = companyOrgUnitCollection.get(i);
            if (!companyOrgUnitInfo.getId().toString().equals(companyId)) continue;
            return companyOrgUnitInfo;
        }
        return companyOrgUnitCollection.get(0);
    }

    public static String getString(String resClassName, String resName, Locale locale) {
        return ResourceBase.getString((String)resClassName, (String)resName, (Locale)locale);
    }

    public static String getString(String resClassName, String resName, Locale locale, Object[] params) {
        return ResourceBase.getString((String)resClassName, (String)resName, (Locale)locale, (Object[])params);
    }

    public static boolean isLocked(Map lockList) {
        Iterator iterator = lockList.keySet().iterator();
        while (iterator.hasNext()) {
            String key = iterator.next().toString();
            if (Boolean.parseBoolean(lockList.get(key).toString())) continue;
            return true;
        }
        return false;
    }

    public static void tryLock(List idList) throws EASBizException {
        if (idList == null || idList.size() == 0) {
            return;
        }
        IMutexServiceControl mutexServiceControl = FrameWorkClientUtils.createMutexServiceControl();
        Map map = mutexServiceControl.batchRequestObjIDForUpdate(idList);
        boolean isReqError = MatchUtils.isLocked(map);
        if (isReqError) {
            throw new InvoiceMatchException(InvoiceMatchException.BILL_LOCKED);
        }
    }

    public static void releaseLock(List idList) {
        if (idList == null || idList.size() == 0) {
            return;
        }
        IMutexServiceControl mutexServiceControl = FrameWorkClientUtils.createMutexServiceControl();
        mutexServiceControl.batchReleaseObjIDForUpdate(idList);
    }

    public static String convertPayInvoiceTypeEnumToTMInvoiceType(String value) {
        String result = (String)invoiceTypeBiMap.get((Object)value);
        if (result == null) {
            result = value;
        }
        return result;
    }

    public static String convertTMInvoiceTypeToPayInvoiceTypeEnum(String value) {
        BiMap inverseinvoiceType = invoiceTypeBiMap.inverse();
        String result = (String)inverseinvoiceType.get((Object)value);
        if (result == null) {
            result = value;
        }
        return result;
    }

    static {
        invoiceTypeBiMap.put((Object)"4", (Object)"26");
        invoiceTypeBiMap.put((Object)"5", (Object)"27");
    }
}

