/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.arap.rptformula.calculater;

import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.excel.model.util.SortedParameterArray;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.basedata.org.CompanyOrgUnitCollection;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.fi.arap.rptformula.parambean.ARAPGetAmountParamBean;
import com.kingdee.eas.fi.arap.rptformula.parambean.RecPayOtherbillParamBean;
import com.kingdee.eas.fi.arap.rptformula.util.ARAPReportBatchUtils;
import com.kingdee.eas.fi.arap.rptformula.util.RPTDateUtil;
import com.kingdee.eas.fi.newrpt.formula.ICalculateContextProvider;
import com.kingdee.eas.fi.rpt.ReportException;
import com.kingdee.eas.fi.rpt.RptPeriodTypeEnum;
import com.kingdee.eas.fi.rpt.util.ReportVariables;
import com.kingdee.eas.fi.rpt.util.VariableEntry;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import org.apache.log4j.Logger;

public abstract class ARAPBatchCalculater {
    private static final Logger logger = CoreUIObject.getLogger(ARAPBatchCalculater.class);
    public static final BigDecimal ZERO = new BigDecimal("0.00");
    public static final int BATCH_MAX_SIZE = 3000;
    protected ICalculateContextProvider contextProvider = null;
    private boolean isNeedCheckPermission = true;
    private HashMap permissionFullOrgs = null;
    protected ArrayList params = new ArrayList();
    protected ArrayList[] groupedParams = null;
    protected HashMap methods = new HashMap();
    protected HashMap numberIDCache = new HashMap();
    protected Connection conn = null;
    private int size = 0;
    protected String reportCurrencyNumber = null;
    protected Date reportBeginDate = null;
    protected Date reportEndDate = null;
    protected int periodYear;
    protected int periodNumber;
    protected int periodType;

    public ICalculateContextProvider getContextProvider() {
        return this.contextProvider;
    }

    public ARAPBatchCalculater(ICalculateContextProvider contextProvider) {
        this.contextProvider = contextProvider;
    }

    public abstract void execute(SortedParameterArray var1);

    public void initResource() {
        try {
            this.conn = EJBFactory.getConnection((Context)this.contextProvider.getServerContext());
        }
        catch (SQLException e) {
            logger.error((Object)e);
        }
        this.initPermission();
        this.reportCurrencyNumber = (String)this.contextProvider.getReportAdapter().getReportProperty("Currency.Number");
        this.reportBeginDate = (Date)this.contextProvider.getReportAdapter().getReportProperty("Report_StartDate");
        this.reportEndDate = (Date)this.contextProvider.getReportAdapter().getReportProperty("Report_EndDate");
        this.periodYear = (Integer)this.contextProvider.getReportAdapter().getReportProperty("Report.Year");
        this.periodNumber = (Integer)this.contextProvider.getReportAdapter().getReportProperty("Report.Period");
        this.periodType = (Integer)this.contextProvider.getReportAdapter().getReportProperty("PeriodType");
        RptPeriodTypeEnum type = RptPeriodTypeEnum.getEnum((int)this.periodType);
        if (this.reportBeginDate == null) {
            this.reportBeginDate = RPTDateUtil.getPeriodFirstDate(this.periodYear, this.periodNumber, type);
        }
        if (this.reportEndDate == null) {
            this.reportEndDate = RPTDateUtil.getPeriodLastDate(this.periodYear, this.periodNumber, type);
        }
    }

    public void clearResource() {
        if (this.conn != null) {
            SQLUtils.cleanup((Connection)this.conn);
        }
    }

    private void initPermission() {
        VariableEntry ve;
        ReportVariables rvs = this.contextProvider.getReportVariables();
        if (rvs != null && (ve = rvs.get("Check_Permissioin", null)) != null) {
            this.isNeedCheckPermission = Boolean.valueOf(ve.getValue());
        }
    }

    public HashMap getUserPermissionOrgs() throws Exception {
        if (this.permissionFullOrgs != null) {
            return this.permissionFullOrgs;
        }
        Context ctx = this.contextProvider.getServerContext();
        Map hasPermissionOrgs = ARAPReportBatchUtils.getRptAuthorizedCompany(ctx);
        this.permissionFullOrgs = new HashMap();
        EntityViewInfo ev = new EntityViewInfo();
        ev.setFilter(new FilterInfo());
        ev.getSelector().add(new SelectorItemInfo("id"));
        ev.getSelector().add(new SelectorItemInfo("number"));
        ev.getSelector().add(new SelectorItemInfo("longNumber"));
        ev.getSelector().add(new SelectorItemInfo("isBizUnit"));
        ev.getSelector().add(new SelectorItemInfo("accountPeriodType"));
        ev.getSelector().add(new SelectorItemInfo("reportConvertMode"));
        ev.getSelector().add(new SelectorItemInfo("baseCurrency.id"));
        ev.getSelector().add(new SelectorItemInfo("baseCurrency.number"));
        ev.getSelector().add(new SelectorItemInfo("baseCurrency.precision"));
        ev.getSelector().add(new SelectorItemInfo("reportCurrency.id"));
        ev.getSelector().add(new SelectorItemInfo("reportCurrency.number"));
        ev.getSelector().add(new SelectorItemInfo("reportCurrency.precision"));
        ev = ARAPReportBatchUtils.getMultiEqualEntityView(ev, "id", hasPermissionOrgs.keySet());
        CompanyOrgUnitCollection ouc = ARAPReportBatchUtils.getCompanyOrgUnitCollection(ctx, ev);
        int n = ouc.size();
        for (int i = 0; i < n; ++i) {
            CompanyOrgUnitInfo info = ouc.get(i);
            String number = info.getNumber();
            this.permissionFullOrgs.put(number, info);
        }
        return this.permissionFullOrgs;
    }

    protected abstract String[] getCanMutiSelect();

    protected abstract String[] getCanMutiSelectSplit();

    public int addParam(ARAPGetAmountParamBean paramBean) {
        int number = 0;
        try {
            String company = paramBean.getCompany().trim();
            StringTokenizer st = new StringTokenizer(company, ";");
            while (st.hasMoreTokens()) {
                String tmp = st.nextToken().trim();
                if (!this.isNeedCheckPermission || this.getUserPermissionOrgs().containsKey(tmp)) continue;
                throw new ReportException(ReportException.COMMON_EXCEPTION, (Object[])new String[]{EASResource.getString((String)"com.kingdee.eas.fi.rpt.ReportResource", (String)"NoCompanyPermission")});
            }
            this.processCompanyNumber(paramBean, this.getUserPermissionOrgs());
            number = this.parseParamBean(paramBean, 0);
        }
        catch (Exception e) {
            logger.error((Object)e);
            paramBean.getBackFiller().setException((Throwable)e);
        }
        return number;
    }

    protected String processCompanyNumber(ARAPGetAmountParamBean paramBean, Map map) {
        HashSet set = new HashSet();
        String company = paramBean.getCompany().trim();
        StringTokenizer st = new StringTokenizer(company, ";");
        while (st.hasMoreTokens()) {
            String number = st.nextToken().trim();
            CompanyOrgUnitInfo info = (CompanyOrgUnitInfo)map.get(number);
            set.addAll(this.findCompanyBizChildrenNumber(map, info));
        }
        String newCompany = ARAPReportBatchUtils.convertToString(set, ";");
        paramBean.setCompany(newCompany);
        return company;
    }

    protected HashSet findCompanyBizChildrenNumber(Map map, CompanyOrgUnitInfo info) {
        HashSet<String> set = new HashSet<String>();
        String longNumber = info.getLongNumber();
        if (!info.isIsBizUnit()) {
            for (Map.Entry entry : map.entrySet()) {
                CompanyOrgUnitInfo tmpInfo = (CompanyOrgUnitInfo)entry.getValue();
                if (!tmpInfo.isIsBizUnit() || !tmpInfo.getLongNumber().startsWith(longNumber)) continue;
                set.add(tmpInfo.getNumber());
            }
        } else {
            set.add(info.getNumber());
        }
        return set;
    }

    protected int parseParamBean(ARAPGetAmountParamBean paramBean, int level) {
        int number = 0;
        String[] properties = this.getCanMutiSelect();
        String[] splits = this.getCanMutiSelectSplit();
        if (properties != null && properties.length > 0 && splits != null && splits.length > 0 && properties.length == splits.length && level < properties.length) {
            String propertyName = properties[level];
            String split = splits[level];
            String propertyLongValue = (String)this.invokeGetterMethod(paramBean, propertyName);
            String[] propertyValues = null;
            propertyValues = propertyLongValue == null || propertyLongValue.length() == 0 || split == null || split.length() == 0 || propertyLongValue.indexOf(split) < 0 ? new String[]{propertyLongValue} : propertyLongValue.split(split);
            int n = propertyValues.length;
            for (int i = 0; i < n; ++i) {
                ARAPGetAmountParamBean tmpParamBean = (ARAPGetAmountParamBean)paramBean.clone();
                String propertyValue = propertyValues[i].trim();
                this.invokeSetterMethod(tmpParamBean, propertyName, propertyValue);
                number += this.parseParamBean(tmpParamBean, level + 1);
            }
        } else {
            this.params.add(paramBean);
            number = 1;
        }
        return number;
    }

    private Method getGetterMethod(Class clazz, String methodName) throws Exception {
        Method method = null;
        if (this.methods.containsKey(methodName)) {
            method = (Method)this.methods.get(methodName);
        } else {
            method = clazz.getMethod(methodName, new Class[0]);
            this.methods.put(methodName, method);
        }
        return method;
    }

    private Method getSetterMethod(Class clazz, String methodName, Class parameterClazz) throws Exception {
        Method method = null;
        if (this.methods.containsKey(methodName)) {
            method = (Method)this.methods.get(methodName);
        } else {
            method = clazz.getMethod(methodName, parameterClazz);
            this.methods.put(methodName, method);
        }
        return method;
    }

    protected Object invokeGetterMethod(Object paramBean, String propertyName) {
        String object = null;
        try {
            Class<?> clazz = paramBean.getClass();
            String methodName = "get" + propertyName;
            Method method = this.getGetterMethod(clazz, methodName);
            object = (String)method.invoke(paramBean, new Object[0]);
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
        return object;
    }

    protected Object invokeSetterMethod(Object paramBean, String propertyName, String propertyValue) {
        Object object = null;
        try {
            Class<?> clazz = paramBean.getClass();
            String methodName = "set" + propertyName;
            Method method = this.getSetterMethod(clazz, methodName, String.class);
            object = method.invoke(paramBean, propertyValue);
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
        return object;
    }

    protected void groupByParam() {
        String[] properties = this.getCanMutiSelect();
        logger.info((Object)"groupByParam()  Exception is happened  ");
        if (properties != null && properties.length > 0) {
            this.groupedParams = new ArrayList[1 << properties.length];
            int n = this.params.size();
            for (int i = 0; i < n; ++i) {
                ARAPGetAmountParamBean paramBean = (ARAPGetAmountParamBean)this.params.get(i);
                int group = 0;
                int m = properties.length;
                for (int j = 0; j < m; ++j) {
                    String propertyName = properties[j];
                    String propertyValue = (String)this.invokeGetterMethod(paramBean, propertyName);
                    if (StringUtils.isEmpty((String)propertyValue)) continue;
                    group |= 1 << j;
                    this.initLoadNumberID(propertyName, propertyValue);
                }
                if (this.groupedParams[group] == null) {
                    this.groupedParams[group] = new ArrayList();
                }
                this.groupedParams[group].add(paramBean);
            }
        } else {
            this.groupedParams = new ArrayList[1];
            this.groupedParams[0] = new ArrayList(this.params);
        }
    }

    protected void initLoadNumberID(String propertyName, String propertyValue) {
        HashMap map = null;
        if (this.numberIDCache.containsKey(propertyName)) {
            map = (HashMap)this.numberIDCache.get(propertyName);
        } else {
            map = new HashMap();
            this.numberIDCache.put(propertyName, map);
        }
        if (!map.containsKey(propertyValue)) {
            map.put(propertyValue, null);
        }
    }

    protected void innerExecute() throws Exception {
        String sql = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        logger.info((Object)"innerExecute method Start");
        this.groupByParam();
        this.loadNumberIDCacheData();
        this.size = this.params.size();
        int count = this.groupedParams.length;
        for (int i = 0; i < count; ++i) {
            ArrayList paramList = this.groupedParams[i];
            if (paramList == null || paramList.size() <= 0) continue;
            sql = this.getSqlByID(i);
            logger.info((Object)("sql is : " + sql));
            try {
                pstmt = this.conn.prepareStatement(sql);
                for (int j = 0; j < paramList.size(); ++j) {
                    ARAPGetAmountParamBean paramBean = (ARAPGetAmountParamBean)paramList.get(j);
                    try {
                        this.setSqlParamsByID(pstmt, paramBean, i);
                        logger.info((Object)("company id is" + ((HashMap)this.numberIDCache.get("Company")).get(paramBean.getCompany().toString())));
                        rs = pstmt.executeQuery();
                        BigDecimal value = ZERO;
                        while (rs.next()) {
                            BigDecimal tmp = rs.getBigDecimal(this.getReturnField().trim());
                            if (tmp == null) continue;
                            value = value.add(tmp);
                        }
                        paramBean.getBackFiller().setValue((Object)value);
                        continue;
                    }
                    catch (SQLException e) {
                        logger.info((Object)"innerExecute method sql(pstmt) Exception is happened");
                        logger.error((Object)e);
                        paramBean.getBackFiller().setException((Throwable)e);
                    }
                }
                continue;
            }
            catch (SQLException e) {
                logger.info((Object)"innerExecute method sql(pstmt) Exception is happened 2  ");
                logger.error((Object)e);
                throw e;
            }
            finally {
                SQLUtils.cleanup(rs, (Statement)pstmt);
            }
        }
    }

    protected void loadNumberIDCacheData() throws Exception {
        String[] properties = this.getCanMutiSelect();
        if (properties != null && properties.length > 0) {
            int m = properties.length;
            for (int j = 0; j < m; ++j) {
                HashMap map = (HashMap)this.numberIDCache.get(properties[j]);
                if (map == null || map.size() <= 0) continue;
                Iterator itr = map.entrySet().iterator();
                HashSet numberSet = new HashSet();
                while (itr.hasNext()) {
                    Map.Entry entry = itr.next();
                    Object value = entry.getValue();
                    if (value != null) continue;
                    Object key = entry.getKey();
                    numberSet.add(key);
                }
                this.innerLoadNumberID(j, map, numberSet);
            }
        }
    }

    protected abstract void innerLoadNumberID(int var1, HashMap var2, Set var3) throws Exception;

    protected abstract String getSql(int var1);

    abstract String getSqlByID(int var1);

    protected void setSqlParams(PreparedStatement pstmt, ARAPGetAmountParamBean paramBean, int group) throws SQLException {
        int paramIndex = this.setFixedSqlParams(pstmt, paramBean, 1);
        String[] properties = this.getCanMutiSelect();
        if (properties != null && properties.length > 0) {
            int m = properties.length;
            for (int j = 0; j < m; ++j) {
                String propertyName = properties[j];
                if (!ARAPBatchCalculater.checkBit(group, j)) continue;
                String propertyValue = (String)this.invokeGetterMethod(paramBean, propertyName);
                pstmt.setString(paramIndex++, propertyValue);
            }
        }
    }

    protected void setSqlParamsByID(PreparedStatement pstmt, ARAPGetAmountParamBean paramBean, int group) throws SQLException {
        int paramIndex = this.setFixedSqlParams(pstmt, paramBean, 1);
        String[] properties = this.getCanMutiSelect();
        if (properties != null && properties.length > 0) {
            int m = properties.length;
            for (int j = 0; j < m; ++j) {
                String propertyName = properties[j];
                if (!ARAPBatchCalculater.checkBit(group, j)) continue;
                String propertyValue = (String)this.invokeGetterMethod(paramBean, propertyName);
                HashMap map = (HashMap)this.numberIDCache.get(propertyName);
                String id = (String)map.get(propertyValue);
                pstmt.setString(paramIndex++, id);
            }
        }
    }

    protected int setFixedSqlParams(PreparedStatement pstmt, ARAPGetAmountParamBean paramBean, int paramIndex) throws SQLException {
        return paramIndex;
    }

    protected String getReturnField() {
        return " ";
    }

    public static final boolean checkBit(int i, int index) {
        if (index < 0) {
            return false;
        }
        return (i >> index & 1) == 1;
    }

    protected void initParam(RecPayOtherbillParamBean formulaParam) {
        Timestamp startTime = formulaParam.getStartTime();
        Timestamp endTime = formulaParam.getEndTime();
        if (startTime == null && endTime == null) {
            formulaParam.setStartTime(new Timestamp(this.reportBeginDate.getTime()));
            formulaParam.setEndTime(new Timestamp(this.reportEndDate.getTime()));
        } else if (endTime == null) {
            Calendar cal = Calendar.getInstance();
            Timestamp ts = new Timestamp(cal.getTimeInMillis());
            formulaParam.setEndTime(ts);
        } else if (startTime == null) {
            formulaParam.setStartTime(new Timestamp(this.reportBeginDate.getTime()));
        }
    }

    protected String getCostCenterId(int group, int index) {
        if (ARAPBatchCalculater.checkBit(group, index)) {
            return " and ENTRY.FCOSTCENTERID = ? ";
        }
        return "";
    }
}

