/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.arap.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.common.DCInfo;
import com.kingdee.eas.base.common.DCRegister;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.PeriodUtils;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.fi.ar.IOtherBill;
import com.kingdee.eas.fi.ar.OtherBillFactory;
import com.kingdee.eas.fi.ar.OtherBillInfo;
import com.kingdee.eas.fi.ar.OtherBillPlanCollection;
import com.kingdee.eas.fi.ar.OtherBillPlanInfo;
import com.kingdee.eas.fi.ar.OtherBillentryCollection;
import com.kingdee.eas.fi.ar.OtherBillentryInfo;
import com.kingdee.eas.fi.ar.app.util.CommonServerUtils;
import com.kingdee.eas.fi.arap.ArApConstants;
import com.kingdee.eas.fi.cas.IPaymentBill;
import com.kingdee.eas.fi.cas.IReceivingBill;
import com.kingdee.eas.fi.cas.PaymentBillFactory;
import com.kingdee.eas.fi.cas.PaymentBillInfo;
import com.kingdee.eas.fi.cas.ReceivingBillFactory;
import com.kingdee.eas.fi.cas.ReceivingBillInfo;
import com.kingdee.eas.mm.project.IProject;
import com.kingdee.eas.mm.project.ProjectFactory;
import com.kingdee.eas.mm.project.ProjectInfo;
import com.kingdee.eas.tools.datatask.task.util.IAccountingDataInterface;
import com.kingdee.eas.tools.datatask.task.util.XMLElementAssembeler;
import com.kingdee.eas.tools.datatask.task.util.XMLGenerator;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.util.db.SQLUtils;
import java.io.File;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.apache.log4j.Logger;
import org.dom4j.Document;
import org.dom4j.Element;

public class ARAPXMLGenerator
extends XMLGenerator
implements IAccountingDataInterface {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fi.ap.util.APFileXMLGenerator");
    private String companyInfoId;
    private static final String ARAP_RESOURCE = "com.kingdee.eas.fi.arap.ArapResource";

    public Document generateXML(Context ctx, CompanyOrgUnitInfo companyInfo, PeriodInfo periodinfo) {
        throw new UnsupportedOperationException();
    }

    public File generate(Context ctx, CompanyOrgUnitInfo companyInfo, PeriodInfo periodinfo) {
        String type = this.getTypeName(ctx);
        Element root = this.initHeadAndFileName(ctx, companyInfo, type);
        this.companyInfoId = companyInfo.getId().toString();
        this.generateBillTypeNumber(root, ctx, companyInfo, periodinfo);
        this.generateBizTypeNumber(root, ctx, companyInfo, periodinfo);
        this.generateArOtherBill(root, ctx, companyInfo, periodinfo);
        this.generateApOtherBill(root, ctx, companyInfo, periodinfo);
        this.endElement();
        this.close();
        return this.file;
    }

    public String getTypeName(Context ctx) {
        return ResourceBase.getString((String)ARAP_RESOURCE, (String)"ReceiveAndPayment", (Locale)ctx.getLocale());
    }

    private void generateBillTypeNumber(Element root, Context ctx, CompanyOrgUnitInfo companyInfo, PeriodInfo periodinfo) {
        String[] billTypeNumber = new String[]{"FC910EF3", "FA44FD5B", "48DA3A71", "40284E81"};
        String[] billTypeName = new String[]{ResourceBase.getString((String)ARAP_RESOURCE, (String)"AROtherBill", (Locale)ctx.getLocale()), ResourceBase.getString((String)ARAP_RESOURCE, (String)"ReciveBill", (Locale)ctx.getLocale()), ResourceBase.getString((String)ARAP_RESOURCE, (String)"APOtherBill", (Locale)ctx.getLocale()), ResourceBase.getString((String)ARAP_RESOURCE, (String)"PaymentBill", (Locale)ctx.getLocale())};
        for (int i = 0; i < billTypeNumber.length; ++i) {
            Element billType = this.startElement(ResourceBase.getString((String)ARAP_RESOURCE, (String)"BillType", (Locale)ctx.getLocale()));
            this.addStringElement(billType, ResourceBase.getString((String)ARAP_RESOURCE, (String)"BillTypeNumber", (Locale)ctx.getLocale()), billTypeNumber[i], 40, false);
            this.addStringElement(billType, ResourceBase.getString((String)ARAP_RESOURCE, (String)"BillTypeName", (Locale)ctx.getLocale()), billTypeName[i], 40, false);
            this.endElement();
        }
    }

    private void generateBizTypeNumber(Element root, Context ctx, CompanyOrgUnitInfo companyInfo, PeriodInfo periodinfo) {
        XMLElementAssembeler xmlea = new XMLElementAssembeler(root, ctx, companyInfo, periodinfo){
            String[] bizTypeNumber;
            String[] bizTypeName;
            {
                this.bizTypeNumber = new String[]{"101", "102", "103", "104", "201", "202", "203", "204"};
                this.bizTypeName = new String[]{ResourceBase.getString((String)ARAPXMLGenerator.ARAP_RESOURCE, (String)"OtherAROtherBill", (Locale)this.ctx.getLocale()), ResourceBase.getString((String)ARAPXMLGenerator.ARAP_RESOURCE, (String)"SaleInvoice", (Locale)this.ctx.getLocale()), ResourceBase.getString((String)ARAPXMLGenerator.ARAP_RESOURCE, (String)"SaleFeeInvoice", (Locale)this.ctx.getLocale()), ResourceBase.getString((String)ARAPXMLGenerator.ARAP_RESOURCE, (String)"ARBorrowAdjustBill", (Locale)this.ctx.getLocale()), ResourceBase.getString((String)ARAPXMLGenerator.ARAP_RESOURCE, (String)"OtherApOtherBill", (Locale)this.ctx.getLocale()), ResourceBase.getString((String)ARAPXMLGenerator.ARAP_RESOURCE, (String)"PurInvoice", (Locale)this.ctx.getLocale()), ResourceBase.getString((String)ARAPXMLGenerator.ARAP_RESOURCE, (String)"PurFeeInvoice", (Locale)this.ctx.getLocale()), ResourceBase.getString((String)ARAPXMLGenerator.ARAP_RESOURCE, (String)"APBorrowAdjustBill", (Locale)this.ctx.getLocale())};
            }

            public void addToElement() throws SQLException {
                String lang = this.ctx.getLocale().getLanguage();
                for (int i = 0; i < this.bizTypeNumber.length; ++i) {
                    Element bizType = ARAPXMLGenerator.this.startElement(ResourceBase.getString((String)ARAPXMLGenerator.ARAP_RESOURCE, (String)"DealType", (Locale)this.ctx.getLocale()));
                    ARAPXMLGenerator.this.addStringElement(bizType, ResourceBase.getString((String)ARAPXMLGenerator.ARAP_RESOURCE, (String)"DealTypeNumber", (Locale)this.ctx.getLocale()), this.bizTypeNumber[i], 40, false);
                    ARAPXMLGenerator.this.addStringElement(bizType, ResourceBase.getString((String)ARAPXMLGenerator.ARAP_RESOURCE, (String)"DealTypeName", (Locale)this.ctx.getLocale()), this.bizTypeName[i], 40, false);
                    ARAPXMLGenerator.this.endElement();
                }
                if (this.rowset != null) {
                    while (this.rowset.next()) {
                        String bizTypeNumber = this.rowset.getString("fnumber");
                        String bizTypeName = this.rowset.getString("FNAME_" + lang);
                        Element bizType = ARAPXMLGenerator.this.startElement(ResourceBase.getString((String)ARAPXMLGenerator.ARAP_RESOURCE, (String)"DealType", (Locale)this.ctx.getLocale()));
                        ARAPXMLGenerator.this.addStringElement(bizType, ResourceBase.getString((String)ARAPXMLGenerator.ARAP_RESOURCE, (String)"DealTypeNumber", (Locale)this.ctx.getLocale()), bizTypeNumber, 40, false);
                        ARAPXMLGenerator.this.addStringElement(bizType, ResourceBase.getString((String)ARAPXMLGenerator.ARAP_RESOURCE, (String)"DealTypeNumber", (Locale)this.ctx.getLocale()), bizTypeName, 40, false);
                        ARAPXMLGenerator.this.endElement();
                    }
                }
            }

            public String prePareSQL() {
                String lang = this.ctx.getLocale().getLanguage();
                StringBuffer sql = new StringBuffer();
                sql.append("select fnumber, FNAME_").append(lang);
                sql.append(" from t_cas_receivingbilltype");
                sql.append(" where FDeletedStatus = 1 and FSourceSysType = 100 ");
                sql.append(" union all ");
                sql.append("select fnumber, FNAME_").append(lang);
                sql.append(" from T_CAS_PaymentBillType");
                sql.append(" where FDeletedStatus = 1 and FSourceSysType = 101 ");
                return sql.toString();
            }
        };
        xmlea.excuteAssemble();
    }

    private void generateArOtherBill(Element root, Context ctx, CompanyOrgUnitInfo companyInfo, PeriodInfo periodinfo) {
        XMLElementAssembeler xmlea = new XMLElementAssembeler(root, ctx, companyInfo, periodinfo){

            public void addToElement() throws SQLException {
                if (this.rowset != null) {
                    while (this.rowset.next()) {
                        ProjectInfo project;
                        IProject iProject;
                        OtherBillentryInfo firstEntryInfo;
                        String billID = this.rowset.getString("fid");
                        BOSObjectType srcBillBosType = BOSUuid.read((String)billID).getType();
                        String billNumber = this.rowset.getString("fnumber");
                        String billType = this.rowset.getString("FBillType");
                        String asstActNumber = this.rowset.getString("FAsstActNumber");
                        String voucherType = this.rowset.getString("FVoucherType");
                        String voucherNumber = this.rowset.getString("FVoucherNumber");
                        Date bookedDate = this.rowset.getDate("FBookedDate");
                        BigDecimal exchangeRate = this.rowset.getBigDecimal("FExchangeRate");
                        BigDecimal unVerifyAmountLocal = this.rowset.getBigDecimal("FUnVerifyAmountLocal");
                        BigDecimal unVerifyAmount = this.rowset.getBigDecimal("FUnVerifyAmount");
                        BigDecimal amountLocal = this.rowset.getBigDecimal("FAmountLocal");
                        BigDecimal amount = this.rowset.getBigDecimal("FAmount");
                        String currency = this.rowset.getString("FCurrency");
                        String baseCurrency = this.rowset.getString("FBaseCurrency");
                        String abstractName = this.rowset.getString("FAbstractName");
                        String settlementType = this.rowset.getString("FSettlementType");
                        String account = this.rowset.getString("faccount");
                        String settlementNumber = this.rowset.getString("FSettlementNumber");
                        OtherBillInfo otherbill = null;
                        IOtherBill iAr = null;
                        ReceivingBillInfo receivingBill = null;
                        IReceivingBill iRec = null;
                        java.util.Date recievePayDate = null;
                        String invoiceNumber = null;
                        String contractNum = null;
                        String projectNum = null;
                        if (ArApConstants.AR_OBILL_TYPE.equals((Object)srcBillBosType)) {
                            otherbill = new OtherBillInfo();
                            try {
                                iAr = OtherBillFactory.getLocalInstance(this.ctx);
                                otherbill = iAr.getOtherBillInfo((IObjectPK)new ObjectUuidPK(billID));
                                billType = otherbill.getBillType().getValue() + "";
                                account = ARAPXMLGenerator.this.getArAccount(this.ctx, otherbill).toString();
                                recievePayDate = ARAPXMLGenerator.this.getArRecieveDate(this.ctx, otherbill);
                            }
                            catch (Exception e1) {
                                logger.info((Object)e1);
                            }
                            if (otherbill.getEntry().size() > 0) {
                                firstEntryInfo = otherbill.getEntry().get(0);
                                invoiceNumber = firstEntryInfo.getInvoiceNumber();
                                contractNum = firstEntryInfo.getContractNum();
                                if (firstEntryInfo.getProject() != null) {
                                    iProject = null;
                                    project = null;
                                    try {
                                        iProject = ProjectFactory.getLocalInstance((Context)this.ctx);
                                        project = iProject.getProjectInfo((IObjectPK)new ObjectUuidPK(firstEntryInfo.getProject().getId()));
                                        projectNum = project.getNumber();
                                    }
                                    catch (Exception e) {
                                        logger.info((Object)e);
                                    }
                                }
                            }
                        } else if (ArApConstants.REC_TYPE.equals((Object)srcBillBosType)) {
                            receivingBill = new ReceivingBillInfo();
                            try {
                                iRec = ReceivingBillFactory.getLocalInstance((Context)this.ctx);
                                receivingBill = iRec.getReceivingBillInfo((IObjectPK)new ObjectUuidPK(billID));
                            }
                            catch (Exception e) {
                                logger.info((Object)e);
                            }
                            if (receivingBill.getEntries().size() > 0) {
                                firstEntryInfo = receivingBill.getEntries().get(0);
                                contractNum = firstEntryInfo.getContractNum();
                                if (firstEntryInfo.getProject() != null) {
                                    iProject = null;
                                    project = null;
                                    try {
                                        iProject = ProjectFactory.getLocalInstance((Context)this.ctx);
                                        project = iProject.getProjectInfo((IObjectPK)new ObjectUuidPK(firstEntryInfo.getProject().getId()));
                                        projectNum = project.getNumber();
                                    }
                                    catch (Exception e) {
                                        logger.info((Object)e);
                                    }
                                }
                            }
                        }
                        String isAllVerification = null;
                        isAllVerification = unVerifyAmount.compareTo(new BigDecimal(0)) == 0 ? "2" : (unVerifyAmount.compareTo(amount) == 0 ? "0" : "1");
                        StringBuffer verificationVoucherNum = new StringBuffer("");
                        try {
                            verificationVoucherNum = ARAPXMLGenerator.this.getArApVerificationVouch(this.ctx, billID, this.companyInfo, this.periodinfo);
                        }
                        catch (BOSException e) {
                            logger.info((Object)e);
                        }
                        java.util.Date lastVerifyTime = null;
                        try {
                            lastVerifyTime = ARAPXMLGenerator.this.getArApLastVerification(this.ctx, billID, this.companyInfo, this.periodinfo);
                        }
                        catch (BOSException e) {
                            logger.info((Object)e);
                        }
                        Element arOtherBill = ARAPXMLGenerator.this.startElement(ResourceBase.getString((String)ARAPXMLGenerator.ARAP_RESOURCE, (String)"ARDetailTable", (Locale)this.ctx.getLocale()));
                        ARAPXMLGenerator.this.addStringElement(arOtherBill, ResourceBase.getString((String)ARAPXMLGenerator.ARAP_RESOURCE, (String)"CustomerNumber", (Locale)this.ctx.getLocale()), asstActNumber, 40, true);
                        if (account == null) {
                            ARAPXMLGenerator.this.addStringElement(arOtherBill, ResourceBase.getString((String)ARAPXMLGenerator.ARAP_RESOURCE, (String)"SubjectNumber", (Locale)this.ctx.getLocale()), "        ", 40, true);
                        } else {
                            ARAPXMLGenerator.this.addStringElement(arOtherBill, ResourceBase.getString((String)ARAPXMLGenerator.ARAP_RESOURCE, (String)"SubjectNumber", (Locale)this.ctx.getLocale()), account.toString(), 40, true);
                        }
                        if (bookedDate == null) {
                            ARAPXMLGenerator.this.addStringElement(arOtherBill, ResourceBase.getString((String)ARAPXMLGenerator.ARAP_RESOURCE, (String)"ChargeVoucherDate", (Locale)this.ctx.getLocale()), "        ", 40, true);
                            ARAPXMLGenerator.this.addStringElement(arOtherBill, ResourceBase.getString((String)ARAPXMLGenerator.ARAP_RESOURCE, (String)"ChargeDate", (Locale)this.ctx.getLocale()), "        ", 40, true);
                        } else {
                            ARAPXMLGenerator.this.addDateElement(arOtherBill, ResourceBase.getString((String)ARAPXMLGenerator.ARAP_RESOURCE, (String)"ChargeVoucherDate", (Locale)this.ctx.getLocale()), bookedDate);
                            ARAPXMLGenerator.this.addDateElement(arOtherBill, ResourceBase.getString((String)ARAPXMLGenerator.ARAP_RESOURCE, (String)"ChargeDate", (Locale)this.ctx.getLocale()), bookedDate);
                        }
                        ARAPXMLGenerator.this.addNumberElement(arOtherBill, ResourceBase.getString((String)ARAPXMLGenerator.ARAP_RESOURCE, (String)"PeriodYear", (Locale)this.ctx.getLocale()), this.periodinfo.getPeriodYear() + "");
                        ARAPXMLGenerator.this.addNumberElement(arOtherBill, ResourceBase.getString((String)ARAPXMLGenerator.ARAP_RESOURCE, (String)"PeriodNumber", (Locale)this.ctx.getLocale()), this.periodinfo.getPeriodNumber() + "");
                        ARAPXMLGenerator.this.addStringElement(arOtherBill, ResourceBase.getString((String)ARAPXMLGenerator.ARAP_RESOURCE, (String)"ChargeVoucherTypeNum", (Locale)this.ctx.getLocale()), voucherType, 40, true);
                        ARAPXMLGenerator.this.addStringElement(arOtherBill, ResourceBase.getString((String)ARAPXMLGenerator.ARAP_RESOURCE, (String)"ChargeVoucherNumber", (Locale)this.ctx.getLocale()), voucherNumber, 40, true);
                        ARAPXMLGenerator.this.addStringElement(arOtherBill, ResourceBase.getString((String)ARAPXMLGenerator.ARAP_RESOURCE, (String)"LocalCurrency", (Locale)this.ctx.getLocale()), baseCurrency, 40, true);
                        ARAPXMLGenerator.this.addNumberElement(arOtherBill, ResourceBase.getString((String)ARAPXMLGenerator.ARAP_RESOURCE, (String)"ExchangeRate", (Locale)this.ctx.getLocale()), exchangeRate + "");
                        if (ArApConstants.AR_OBILL_TYPE.equals((Object)srcBillBosType)) {
                            ARAPXMLGenerator.this.addStringElement(arOtherBill, ResourceBase.getString((String)ARAPXMLGenerator.ARAP_RESOURCE, (String)"BalanceDirection", (Locale)this.ctx.getLocale()), ResourceBase.getString((String)ARAPXMLGenerator.ARAP_RESOURCE, (String)"Debit", (Locale)this.ctx.getLocale()), 20, true);
                        } else {
                            ARAPXMLGenerator.this.addStringElement(arOtherBill, ResourceBase.getString((String)ARAPXMLGenerator.ARAP_RESOURCE, (String)"BalanceDirection", (Locale)this.ctx.getLocale()), ResourceBase.getString((String)ARAPXMLGenerator.ARAP_RESOURCE, (String)"Lender", (Locale)this.ctx.getLocale()), 20, true);
                        }
                        ARAPXMLGenerator.this.addNumberElement(arOtherBill, ResourceBase.getString((String)ARAPXMLGenerator.ARAP_RESOURCE, (String)"LocalAmount", (Locale)this.ctx.getLocale()), unVerifyAmountLocal + "");
                        ARAPXMLGenerator.this.addNumberElement(arOtherBill, ResourceBase.getString((String)ARAPXMLGenerator.ARAP_RESOURCE, (String)"SourceAmount", (Locale)this.ctx.getLocale()), unVerifyAmount + "");
                        ARAPXMLGenerator.this.addNumberElement(arOtherBill, ResourceBase.getString((String)ARAPXMLGenerator.ARAP_RESOURCE, (String)"LocalOccurAmount", (Locale)this.ctx.getLocale()), amountLocal + "");
                        ARAPXMLGenerator.this.addStringElement(arOtherBill, ResourceBase.getString((String)ARAPXMLGenerator.ARAP_RESOURCE, (String)"SourceCurrencyType", (Locale)this.ctx.getLocale()), currency, 40, true);
                        ARAPXMLGenerator.this.addNumberElement(arOtherBill, ResourceBase.getString((String)ARAPXMLGenerator.ARAP_RESOURCE, (String)"SourceOccurAmount", (Locale)this.ctx.getLocale()), amount + "");
                        ARAPXMLGenerator.this.addStringElement(arOtherBill, ResourceBase.getString((String)ARAPXMLGenerator.ARAP_RESOURCE, (String)"Remark", (Locale)this.ctx.getLocale()), abstractName, 200, true);
                        ARAPXMLGenerator.this.addDateElement(arOtherBill, ResourceBase.getString((String)ARAPXMLGenerator.ARAP_RESOURCE, (String)"RecievePayDate", (Locale)this.ctx.getLocale()), recievePayDate);
                        if (verificationVoucherNum == null) {
                            ARAPXMLGenerator.this.addStringElement(arOtherBill, ResourceBase.getString((String)ARAPXMLGenerator.ARAP_RESOURCE, (String)"VerificationVoucherNum", (Locale)this.ctx.getLocale()), "        ", 40, true);
                        } else {
                            ARAPXMLGenerator.this.addStringElement(arOtherBill, ResourceBase.getString((String)ARAPXMLGenerator.ARAP_RESOURCE, (String)"VerificationVoucherNum", (Locale)this.ctx.getLocale()), verificationVoucherNum.toString(), 40, true);
                        }
                        ARAPXMLGenerator.this.addDateElement(arOtherBill, ResourceBase.getString((String)ARAPXMLGenerator.ARAP_RESOURCE, (String)"VerifyTime", (Locale)this.ctx.getLocale()), lastVerifyTime);
                        if (ArApConstants.AR_OBILL_TYPE.equals((Object)srcBillBosType)) {
                            ARAPXMLGenerator.this.addStringElement(arOtherBill, ResourceBase.getString((String)ARAPXMLGenerator.ARAP_RESOURCE, (String)"BillTypeNumber", (Locale)this.ctx.getLocale()), "FC910EF3", 40, true);
                        } else {
                            ARAPXMLGenerator.this.addStringElement(arOtherBill, ResourceBase.getString((String)ARAPXMLGenerator.ARAP_RESOURCE, (String)"BillTypeNumber", (Locale)this.ctx.getLocale()), "FA44FD5B", 40, true);
                        }
                        ARAPXMLGenerator.this.addStringElement(arOtherBill, ResourceBase.getString((String)ARAPXMLGenerator.ARAP_RESOURCE, (String)"DealTypeNumber", (Locale)this.ctx.getLocale()), billType, 40, true);
                        ARAPXMLGenerator.this.addStringElement(arOtherBill, ResourceBase.getString((String)ARAPXMLGenerator.ARAP_RESOURCE, (String)"BillNumber", (Locale)this.ctx.getLocale()), billNumber, 40, true);
                        if (ArApConstants.AR_OBILL_TYPE.equals((Object)srcBillBosType)) {
                            ARAPXMLGenerator.this.addStringElement(arOtherBill, ResourceBase.getString((String)ARAPXMLGenerator.ARAP_RESOURCE, (String)"InvoiceNumber", (Locale)this.ctx.getLocale()), invoiceNumber, 40, true);
                        } else {
                            ARAPXMLGenerator.this.addStringElement(arOtherBill, ResourceBase.getString((String)ARAPXMLGenerator.ARAP_RESOURCE, (String)"InvoiceNumber", (Locale)this.ctx.getLocale()), "        ", 40, true);
                        }
                        ARAPXMLGenerator.this.addStringElement(arOtherBill, ResourceBase.getString((String)ARAPXMLGenerator.ARAP_RESOURCE, (String)"ContractNum", (Locale)this.ctx.getLocale()), contractNum, 40, true);
                        ARAPXMLGenerator.this.addStringElement(arOtherBill, ResourceBase.getString((String)ARAPXMLGenerator.ARAP_RESOURCE, (String)"ProjectNum", (Locale)this.ctx.getLocale()), projectNum, 40, true);
                        ARAPXMLGenerator.this.addStringElement(arOtherBill, ResourceBase.getString((String)ARAPXMLGenerator.ARAP_RESOURCE, (String)"SettlementTypeNumber", (Locale)this.ctx.getLocale()), settlementType, 40, true);
                        ARAPXMLGenerator.this.addDateElement(arOtherBill, ResourceBase.getString((String)ARAPXMLGenerator.ARAP_RESOURCE, (String)"PaymentDate", (Locale)this.ctx.getLocale()), lastVerifyTime);
                        ARAPXMLGenerator.this.addStringElement(arOtherBill, ResourceBase.getString((String)ARAPXMLGenerator.ARAP_RESOURCE, (String)"VerificationFlag", (Locale)this.ctx.getLocale()), isAllVerification, 40, true);
                        if (ArApConstants.AR_OBILL_TYPE.equals((Object)srcBillBosType)) {
                            ARAPXMLGenerator.this.addStringElement(arOtherBill, ResourceBase.getString((String)ARAPXMLGenerator.ARAP_RESOURCE, (String)"ExchangeBillNum", (Locale)this.ctx.getLocale()), "        ", 40, true);
                        } else {
                            ARAPXMLGenerator.this.addStringElement(arOtherBill, ResourceBase.getString((String)ARAPXMLGenerator.ARAP_RESOURCE, (String)"ExchangeBillNum", (Locale)this.ctx.getLocale()), settlementNumber, 40, true);
                        }
                        ARAPXMLGenerator.this.endElement();
                    }
                }
            }

            public String prePareSQL() {
                StringBuffer sql = new StringBuffer();
                String lang = this.ctx.getLocale().getLanguage();
                sql.append("select OTHERBILL.fid fid,OTHERBILL.fnumber fnumber,null FBillType,OTHERBILL.FAsstActNumber FAsstActNumber,null FSettlementNumber,");
                sql.append("VOUCHERTYPE.FName_").append(lang).append(" FVoucherType,VOUCHER.FNumber FVoucherNumber,VOUCHER.FBookedDate FBookedDate,OTHERBILL.FExchangeRate FExchangeRate,");
                sql.append("OTHERBILL.FUnVerifyAmountLocal FUnVerifyAmountLocal,OTHERBILL.FUnVerifyAmount FUnVerifyAmount,OTHERBILL.FAmountLocal FAmountLocal,null faccount,");
                sql.append("OTHERBILL.FAmount FAmount,CURRENCY.FName_").append(lang).append(" FCurrency,OTHERBILL.FAbstractName FAbstractName,SettlementType.FNumber FSettlementType,BASECURRENCY.FName_l2 FBaseCurrency ");
                sql.append(" from t_ar_otherbill OTHERBILL LEFT OUTER JOIN T_BD_VoucherTypes VOUCHERTYPE ON OTHERBILL.FVoucherTypeID = VOUCHERTYPE.FID ");
                sql.append(" LEFT OUTER JOIN T_GL_Voucher VOUCHER ON OTHERBILL.FVoucherID = VOUCHER.FID ");
                sql.append(" LEFT OUTER JOIN T_BD_Currency CURRENCY ON CURRENCY.FID = OTHERBILL.FCurrencyID ");
                sql.append(" LEFT OUTER JOIN T_BD_SettlementType SettlementType on SettlementType.FID = OTHERBILL.FSettleTypeID ");
                sql.append(" LEFT OUTER JOIN T_ORG_Company COMPANY ON COMPANY.FID = OTHERBILL.FCompanyID ");
                sql.append(" LEFT OUTER JOIN T_BD_Currency BASECURRENCY ON BASECURRENCY.FID = COMPANY.FBaseCurrencyID ");
                sql.append(" where OTHERBILL.FBillDate  >= ");
                sql.append(ARAPXMLGenerator.this.formatSqlDate(this.ctx, this.periodinfo.getBeginDate()));
                PeriodInfo nextPeriodInfo = null;
                try {
                    nextPeriodInfo = PeriodUtils.getNextPeriodInfo((Context)this.ctx, (PeriodInfo)this.periodinfo);
                }
                catch (Exception e) {
                    logger.info((Object)e);
                }
                if (nextPeriodInfo != null) {
                    sql.append(" and OTHERBILL.FBillDate< ");
                    sql.append(ARAPXMLGenerator.this.formatSqlDate(this.ctx, nextPeriodInfo.getBeginDate()));
                } else {
                    sql.append(" and OTHERBILL.FBillDate<= ");
                    sql.append(ARAPXMLGenerator.this.formatSqlDate(this.ctx, this.periodinfo.getEndDate()));
                }
                sql.append(" and OTHERBILL.FCompanyID = '").append(ARAPXMLGenerator.this.companyInfoId).append("'");
                sql.append(" union all ");
                sql.append("select recBill.fid fid,recBill.fnumber fnumber,ReceivingBillType.fnumber FBillType,recBill.FPayerNumber FAsstActNumber,recBill.FSettlementNumber FSettlementNumber,");
                sql.append("VOUCHERTYPE.FName_").append(lang).append(" FVoucherType,VOUCHER.FNumber FVoucherNumber,VOUCHER.FBookedDate FBookedDate,recBill.FExchangeRate FExchangeRate,");
                sql.append("recBill.FUnVerifiedAmtLoc FUnVerifyAmountLocal,recBill.FUnVerifiedAmt FUnVerifyAmount,recBill.FLocalAmount FAmountLocal,AccountView.FNUMBER faccount,");
                sql.append("recBill.FAmount FAmount,CURRENCY.FName_").append(lang).append(" FCurrency,recBill.fdescription FAbstractName,SettlementType.FNumber FSettlementType,BASECURRENCY.FName_l2 FBaseCurrency ");
                sql.append(" from T_CAS_RECEIVINGBILL recBill LEFT OUTER JOIN T_BD_VoucherTypes VOUCHERTYPE ON recBill.FVoucherTypeID = VOUCHERTYPE.FID ");
                sql.append(" LEFT OUTER JOIN T_GL_Voucher VOUCHER ON recBill.FVoucherID = VOUCHER.FID ");
                sql.append(" LEFT OUTER JOIN T_BD_Currency CURRENCY ON CURRENCY.FID = recBill.FCurrencyID ");
                sql.append(" LEFT OUTER JOIN T_BD_SettlementType SettlementType on SettlementType.FID = recBill.FSettlementTypeID ");
                sql.append(" LEFT OUTER JOIN T_ORG_Company COMPANY ON COMPANY.FID = recBill.FCompanyID ");
                sql.append(" LEFT OUTER JOIN T_BD_Currency BASECURRENCY ON BASECURRENCY.FID = COMPANY.FBaseCurrencyID ");
                sql.append(" LEFT OUTER JOIN T_CAS_ReceivingBillType ReceivingBillType ON ReceivingBillType.FID = recBill.FRecBillTypeID ");
                sql.append(" LEFT OUTER JOIN T_BD_AccountView AccountView ON AccountView.FID = recBill.FOppAccountID ");
                sql.append(" where recBill.FBizDate  >= ");
                sql.append(ARAPXMLGenerator.this.formatSqlDate(this.ctx, this.periodinfo.getBeginDate()));
                try {
                    nextPeriodInfo = PeriodUtils.getNextPeriodInfo((Context)this.ctx, (PeriodInfo)this.periodinfo);
                }
                catch (Exception e) {
                    logger.info((Object)e);
                }
                if (nextPeriodInfo != null) {
                    sql.append(" and recBill.FBizDate< ");
                    sql.append(ARAPXMLGenerator.this.formatSqlDate(this.ctx, nextPeriodInfo.getBeginDate()));
                } else {
                    sql.append(" and recBill.FBizDate<= ");
                    sql.append(ARAPXMLGenerator.this.formatSqlDate(this.ctx, this.periodinfo.getEndDate()));
                }
                sql.append(" and recBill.FCompanyID = '").append(ARAPXMLGenerator.this.companyInfoId).append("'");
                return sql.toString();
            }
        };
        xmlea.excuteAssemble();
    }

    private void generateApOtherBill(Element root, Context ctx, CompanyOrgUnitInfo companyInfo, PeriodInfo periodinfo) {
        XMLElementAssembeler xmlea = new XMLElementAssembeler(root, ctx, companyInfo, periodinfo){

            public void addToElement() throws SQLException {
                if (this.rowset != null) {
                    while (this.rowset.next()) {
                        ProjectInfo project;
                        IProject iProject;
                        com.kingdee.eas.fi.ap.OtherBillentryInfo firstEntryInfo;
                        String billID = this.rowset.getString("fid");
                        BOSObjectType srcBillBosType = BOSUuid.read((String)billID).getType();
                        String billNumber = this.rowset.getString("fnumber");
                        String billType = this.rowset.getString("FBillType");
                        String asstActNumber = this.rowset.getString("FAsstActNumber");
                        String voucherType = this.rowset.getString("FVoucherType");
                        String voucherNumber = this.rowset.getString("FVoucherNumber");
                        Date bookedDate = this.rowset.getDate("FBookedDate");
                        BigDecimal exchangeRate = this.rowset.getBigDecimal("FExchangeRate");
                        BigDecimal unVerifyAmountLocal = this.rowset.getBigDecimal("FUnVerifyAmountLocal");
                        BigDecimal unVerifyAmount = this.rowset.getBigDecimal("FUnVerifyAmount");
                        BigDecimal amountLocal = this.rowset.getBigDecimal("FAmountLocal");
                        BigDecimal amount = this.rowset.getBigDecimal("FAmount");
                        String currency = this.rowset.getString("FCurrency");
                        String baseCurrency = this.rowset.getString("FBaseCurrency");
                        String abstractName = this.rowset.getString("FAbstractName");
                        String settlementType = this.rowset.getString("FSettlementType");
                        String account = this.rowset.getString("faccount");
                        String settlementNumber = this.rowset.getString("FSettlementNumber");
                        com.kingdee.eas.fi.ap.OtherBillInfo otherbill = null;
                        com.kingdee.eas.fi.ap.IOtherBill iAp = null;
                        PaymentBillInfo paymentBill = null;
                        IPaymentBill iRec = null;
                        java.util.Date recievePayDate = null;
                        String invoiceNumber = null;
                        String contractNum = null;
                        String projectNum = null;
                        if (ArApConstants.AP_OBILL_TYPE.equals((Object)srcBillBosType)) {
                            otherbill = new com.kingdee.eas.fi.ap.OtherBillInfo();
                            try {
                                iAp = com.kingdee.eas.fi.ap.OtherBillFactory.getLocalInstance(this.ctx);
                                otherbill = iAp.getOtherBillInfo((IObjectPK)new ObjectUuidPK(billID));
                                billType = otherbill.getBillType().getValue() + "";
                                account = ARAPXMLGenerator.this.getApAccount(this.ctx, otherbill).toString();
                                recievePayDate = ARAPXMLGenerator.this.getApPayDate(this.ctx, otherbill);
                            }
                            catch (Exception e) {
                                logger.info((Object)e);
                            }
                            if (otherbill.getEntry().size() > 0) {
                                firstEntryInfo = otherbill.getEntry().get(0);
                                invoiceNumber = firstEntryInfo.getInvoiceNumber();
                                contractNum = firstEntryInfo.getContractNum();
                                if (firstEntryInfo.getProject() != null) {
                                    iProject = null;
                                    project = null;
                                    try {
                                        iProject = ProjectFactory.getLocalInstance((Context)this.ctx);
                                        project = iProject.getProjectInfo((IObjectPK)new ObjectUuidPK(firstEntryInfo.getProject().getId()));
                                        projectNum = project.getNumber();
                                    }
                                    catch (Exception e) {
                                        logger.info((Object)e);
                                    }
                                }
                            }
                        } else if (ArApConstants.PAY_TYPE.equals((Object)srcBillBosType)) {
                            paymentBill = new PaymentBillInfo();
                            try {
                                iRec = PaymentBillFactory.getLocalInstance((Context)this.ctx);
                                paymentBill = iRec.getPaymentBillInfo((IObjectPK)new ObjectUuidPK(billID));
                            }
                            catch (Exception e) {
                                logger.info((Object)e);
                            }
                            if (paymentBill.getEntries().size() > 0) {
                                firstEntryInfo = paymentBill.getEntries().get(0);
                                contractNum = firstEntryInfo.getContractNum();
                                if (firstEntryInfo.getProject() != null) {
                                    iProject = null;
                                    project = null;
                                    try {
                                        iProject = ProjectFactory.getLocalInstance((Context)this.ctx);
                                        project = iProject.getProjectInfo((IObjectPK)new ObjectUuidPK(firstEntryInfo.getProject().getId()));
                                        projectNum = project.getNumber();
                                    }
                                    catch (Exception e) {
                                        logger.info((Object)e);
                                    }
                                }
                            }
                        }
                        String isAllVerification = null;
                        isAllVerification = unVerifyAmount.compareTo(new BigDecimal(0)) == 0 ? "2" : (unVerifyAmount.compareTo(amount) == 0 ? "0" : "1");
                        StringBuffer verificationVoucherNum = new StringBuffer("");
                        try {
                            verificationVoucherNum = ARAPXMLGenerator.this.getArApVerificationVouch(this.ctx, billID, this.companyInfo, this.periodinfo);
                        }
                        catch (BOSException e) {
                            logger.info((Object)e);
                        }
                        java.util.Date lastVerifyTime = null;
                        try {
                            lastVerifyTime = ARAPXMLGenerator.this.getArApLastVerification(this.ctx, billID, this.companyInfo, this.periodinfo);
                        }
                        catch (BOSException e) {
                            logger.info((Object)e);
                        }
                        Element arOtherBill = ARAPXMLGenerator.this.startElement(ResourceBase.getString((String)ARAPXMLGenerator.ARAP_RESOURCE, (String)"APDetailTable", (Locale)this.ctx.getLocale()));
                        ARAPXMLGenerator.this.addStringElement(arOtherBill, ResourceBase.getString((String)ARAPXMLGenerator.ARAP_RESOURCE, (String)"SupplierNumber", (Locale)this.ctx.getLocale()), asstActNumber, 40, true);
                        if (account == null) {
                            ARAPXMLGenerator.this.addStringElement(arOtherBill, ResourceBase.getString((String)ARAPXMLGenerator.ARAP_RESOURCE, (String)"SubjectNumber", (Locale)this.ctx.getLocale()), "        ", 40, true);
                        } else {
                            ARAPXMLGenerator.this.addStringElement(arOtherBill, ResourceBase.getString((String)ARAPXMLGenerator.ARAP_RESOURCE, (String)"SubjectNumber", (Locale)this.ctx.getLocale()), account.toString(), 40, true);
                        }
                        if (bookedDate == null) {
                            ARAPXMLGenerator.this.addStringElement(arOtherBill, ResourceBase.getString((String)ARAPXMLGenerator.ARAP_RESOURCE, (String)"ChargeVoucherDate", (Locale)this.ctx.getLocale()), "        ", 40, true);
                            ARAPXMLGenerator.this.addStringElement(arOtherBill, ResourceBase.getString((String)ARAPXMLGenerator.ARAP_RESOURCE, (String)"ChargeDate", (Locale)this.ctx.getLocale()), "        ", 40, true);
                        } else {
                            ARAPXMLGenerator.this.addDateElement(arOtherBill, ResourceBase.getString((String)ARAPXMLGenerator.ARAP_RESOURCE, (String)"ChargeVoucherDate", (Locale)this.ctx.getLocale()), bookedDate);
                            ARAPXMLGenerator.this.addDateElement(arOtherBill, ResourceBase.getString((String)ARAPXMLGenerator.ARAP_RESOURCE, (String)"ChargeDate", (Locale)this.ctx.getLocale()), bookedDate);
                        }
                        ARAPXMLGenerator.this.addNumberElement(arOtherBill, ResourceBase.getString((String)ARAPXMLGenerator.ARAP_RESOURCE, (String)"PeriodYear", (Locale)this.ctx.getLocale()), this.periodinfo.getPeriodYear() + "");
                        ARAPXMLGenerator.this.addNumberElement(arOtherBill, ResourceBase.getString((String)ARAPXMLGenerator.ARAP_RESOURCE, (String)"PeriodNumber", (Locale)this.ctx.getLocale()), this.periodinfo.getPeriodNumber() + "");
                        ARAPXMLGenerator.this.addStringElement(arOtherBill, ResourceBase.getString((String)ARAPXMLGenerator.ARAP_RESOURCE, (String)"ChargeVoucherTypeNum", (Locale)this.ctx.getLocale()), voucherType, 40, true);
                        ARAPXMLGenerator.this.addStringElement(arOtherBill, ResourceBase.getString((String)ARAPXMLGenerator.ARAP_RESOURCE, (String)"ChargeVoucherNumber", (Locale)this.ctx.getLocale()), voucherNumber, 40, true);
                        ARAPXMLGenerator.this.addStringElement(arOtherBill, ResourceBase.getString((String)ARAPXMLGenerator.ARAP_RESOURCE, (String)"LocalCurrency", (Locale)this.ctx.getLocale()), baseCurrency, 40, true);
                        ARAPXMLGenerator.this.addNumberElement(arOtherBill, ResourceBase.getString((String)ARAPXMLGenerator.ARAP_RESOURCE, (String)"ExchangeRate", (Locale)this.ctx.getLocale()), exchangeRate + "");
                        if (ArApConstants.AP_OBILL_TYPE.equals((Object)srcBillBosType)) {
                            ARAPXMLGenerator.this.addStringElement(arOtherBill, ResourceBase.getString((String)ARAPXMLGenerator.ARAP_RESOURCE, (String)"BalanceDirection", (Locale)this.ctx.getLocale()), ResourceBase.getString((String)ARAPXMLGenerator.ARAP_RESOURCE, (String)"Lender", (Locale)this.ctx.getLocale()), 20, true);
                        } else {
                            ARAPXMLGenerator.this.addStringElement(arOtherBill, ResourceBase.getString((String)ARAPXMLGenerator.ARAP_RESOURCE, (String)"BalanceDirection", (Locale)this.ctx.getLocale()), ResourceBase.getString((String)ARAPXMLGenerator.ARAP_RESOURCE, (String)"Debit", (Locale)this.ctx.getLocale()), 20, true);
                        }
                        ARAPXMLGenerator.this.addNumberElement(arOtherBill, ResourceBase.getString((String)ARAPXMLGenerator.ARAP_RESOURCE, (String)"LocalAmount", (Locale)this.ctx.getLocale()), unVerifyAmountLocal + "");
                        ARAPXMLGenerator.this.addNumberElement(arOtherBill, ResourceBase.getString((String)ARAPXMLGenerator.ARAP_RESOURCE, (String)"SourceAmount", (Locale)this.ctx.getLocale()), unVerifyAmount + "");
                        ARAPXMLGenerator.this.addNumberElement(arOtherBill, ResourceBase.getString((String)ARAPXMLGenerator.ARAP_RESOURCE, (String)"LocalOccurAmount", (Locale)this.ctx.getLocale()), amountLocal + "");
                        ARAPXMLGenerator.this.addStringElement(arOtherBill, ResourceBase.getString((String)ARAPXMLGenerator.ARAP_RESOURCE, (String)"SourceCurrencyType", (Locale)this.ctx.getLocale()), currency, 40, true);
                        ARAPXMLGenerator.this.addNumberElement(arOtherBill, ResourceBase.getString((String)ARAPXMLGenerator.ARAP_RESOURCE, (String)"SourceOccurAmount", (Locale)this.ctx.getLocale()), amount + "");
                        ARAPXMLGenerator.this.addStringElement(arOtherBill, ResourceBase.getString((String)ARAPXMLGenerator.ARAP_RESOURCE, (String)"Remark", (Locale)this.ctx.getLocale()), abstractName, 200, true);
                        ARAPXMLGenerator.this.addDateElement(arOtherBill, ResourceBase.getString((String)ARAPXMLGenerator.ARAP_RESOURCE, (String)"RecievePayDate", (Locale)this.ctx.getLocale()), recievePayDate);
                        if (verificationVoucherNum == null) {
                            ARAPXMLGenerator.this.addStringElement(arOtherBill, ResourceBase.getString((String)ARAPXMLGenerator.ARAP_RESOURCE, (String)"VerificationVoucherNum", (Locale)this.ctx.getLocale()), "        ", 40, true);
                        } else {
                            ARAPXMLGenerator.this.addStringElement(arOtherBill, ResourceBase.getString((String)ARAPXMLGenerator.ARAP_RESOURCE, (String)"VerificationVoucherNum", (Locale)this.ctx.getLocale()), verificationVoucherNum.toString(), 40, true);
                        }
                        ARAPXMLGenerator.this.addDateElement(arOtherBill, ResourceBase.getString((String)ARAPXMLGenerator.ARAP_RESOURCE, (String)"VerifyTime", (Locale)this.ctx.getLocale()), lastVerifyTime);
                        if (ArApConstants.AP_OBILL_TYPE.equals((Object)srcBillBosType)) {
                            ARAPXMLGenerator.this.addStringElement(arOtherBill, ResourceBase.getString((String)ARAPXMLGenerator.ARAP_RESOURCE, (String)"BillTypeNumber", (Locale)this.ctx.getLocale()), "FC910EF3", 40, true);
                        } else {
                            ARAPXMLGenerator.this.addStringElement(arOtherBill, ResourceBase.getString((String)ARAPXMLGenerator.ARAP_RESOURCE, (String)"BillTypeNumber", (Locale)this.ctx.getLocale()), "40284E81", 40, true);
                        }
                        ARAPXMLGenerator.this.addStringElement(arOtherBill, ResourceBase.getString((String)ARAPXMLGenerator.ARAP_RESOURCE, (String)"DealTypeNumber", (Locale)this.ctx.getLocale()), billType, 40, true);
                        ARAPXMLGenerator.this.addStringElement(arOtherBill, ResourceBase.getString((String)ARAPXMLGenerator.ARAP_RESOURCE, (String)"BillNumber", (Locale)this.ctx.getLocale()), billNumber, 40, true);
                        if (ArApConstants.AP_OBILL_TYPE.equals((Object)srcBillBosType)) {
                            ARAPXMLGenerator.this.addStringElement(arOtherBill, ResourceBase.getString((String)ARAPXMLGenerator.ARAP_RESOURCE, (String)"InvoiceNumber", (Locale)this.ctx.getLocale()), invoiceNumber, 40, true);
                        } else {
                            ARAPXMLGenerator.this.addStringElement(arOtherBill, ResourceBase.getString((String)ARAPXMLGenerator.ARAP_RESOURCE, (String)"InvoiceNumber", (Locale)this.ctx.getLocale()), "        ", 40, true);
                        }
                        ARAPXMLGenerator.this.addStringElement(arOtherBill, ResourceBase.getString((String)ARAPXMLGenerator.ARAP_RESOURCE, (String)"ContractNum", (Locale)this.ctx.getLocale()), contractNum, 40, true);
                        ARAPXMLGenerator.this.addStringElement(arOtherBill, ResourceBase.getString((String)ARAPXMLGenerator.ARAP_RESOURCE, (String)"ProjectNum", (Locale)this.ctx.getLocale()), projectNum, 40, true);
                        ARAPXMLGenerator.this.addStringElement(arOtherBill, ResourceBase.getString((String)ARAPXMLGenerator.ARAP_RESOURCE, (String)"SettlementTypeNumber", (Locale)this.ctx.getLocale()), settlementType, 40, true);
                        ARAPXMLGenerator.this.addDateElement(arOtherBill, ResourceBase.getString((String)ARAPXMLGenerator.ARAP_RESOURCE, (String)"PaymentDate", (Locale)this.ctx.getLocale()), lastVerifyTime);
                        ARAPXMLGenerator.this.addStringElement(arOtherBill, ResourceBase.getString((String)ARAPXMLGenerator.ARAP_RESOURCE, (String)"VerificationFlag", (Locale)this.ctx.getLocale()), isAllVerification, 40, true);
                        if (ArApConstants.AP_OBILL_TYPE.equals((Object)srcBillBosType)) {
                            ARAPXMLGenerator.this.addStringElement(arOtherBill, ResourceBase.getString((String)ARAPXMLGenerator.ARAP_RESOURCE, (String)"ExchangeBillNum", (Locale)this.ctx.getLocale()), "        ", 40, true);
                        } else {
                            ARAPXMLGenerator.this.addStringElement(arOtherBill, ResourceBase.getString((String)ARAPXMLGenerator.ARAP_RESOURCE, (String)"ExchangeBillNum", (Locale)this.ctx.getLocale()), settlementNumber, 40, true);
                        }
                        ARAPXMLGenerator.this.endElement();
                    }
                }
            }

            public String prePareSQL() {
                StringBuffer sql = new StringBuffer();
                String lang = this.ctx.getLocale().getLanguage();
                sql.append("select OTHERBILL.fid fid,OTHERBILL.fnumber fnumber,null FBillType,OTHERBILL.FAsstActNumber FAsstActNumber,");
                sql.append("VOUCHERTYPE.FName_").append(lang).append(" FVoucherType,VOUCHER.FNumber FVoucherNumber,VOUCHER.FBookedDate FBookedDate,OTHERBILL.FExchangeRate FExchangeRate,");
                sql.append("OTHERBILL.FUnVerifyAmountLocal FUnVerifyAmountLocal,OTHERBILL.FUnVerifyAmount FUnVerifyAmount,OTHERBILL.FAmountLocal FAmountLocal,null faccount,null FSettlementNumber,");
                sql.append("OTHERBILL.FAmount FAmount,CURRENCY.FName_").append(lang).append(" FCurrency,OTHERBILL.FAbstractName FAbstractName,SettlementType.FNumber FSettlementType,BASECURRENCY.FName_l2 FBaseCurrency ");
                sql.append(" from T_AP_OTHERBILL OTHERBILL LEFT OUTER JOIN T_BD_VoucherTypes VOUCHERTYPE ON OTHERBILL.FVoucherTypeID = VOUCHERTYPE.FID ");
                sql.append(" LEFT OUTER JOIN T_GL_Voucher VOUCHER ON OTHERBILL.FVoucherID = VOUCHER.FID ");
                sql.append(" LEFT OUTER JOIN T_BD_Currency CURRENCY ON CURRENCY.FID = OTHERBILL.FCurrencyID ");
                sql.append(" LEFT OUTER JOIN T_BD_SettlementType SettlementType on SettlementType.FID = OTHERBILL.FSettleTypeID ");
                sql.append(" LEFT OUTER JOIN T_ORG_Company COMPANY ON COMPANY.FID = OTHERBILL.FCompanyID ");
                sql.append(" LEFT OUTER JOIN T_BD_Currency BASECURRENCY ON BASECURRENCY.FID = COMPANY.FBaseCurrencyID ");
                sql.append(" where OTHERBILL.FBillDate  >= ");
                sql.append(ARAPXMLGenerator.this.formatSqlDate(this.ctx, this.periodinfo.getBeginDate()));
                PeriodInfo nextPeriodInfo = null;
                try {
                    nextPeriodInfo = PeriodUtils.getNextPeriodInfo((Context)this.ctx, (PeriodInfo)this.periodinfo);
                }
                catch (Exception e) {
                    logger.error((Object)e);
                }
                if (nextPeriodInfo != null) {
                    sql.append(" and OTHERBILL.FBillDate< ");
                    sql.append(ARAPXMLGenerator.this.formatSqlDate(this.ctx, nextPeriodInfo.getBeginDate()));
                } else {
                    sql.append(" and OTHERBILL.FBillDate<= ");
                    sql.append(ARAPXMLGenerator.this.formatSqlDate(this.ctx, this.periodinfo.getEndDate()));
                }
                sql.append(" and OTHERBILL.FCompanyID = '").append(ARAPXMLGenerator.this.companyInfoId).append("'");
                sql.append(" union all ");
                sql.append("select payBill.fid fid,payBill.fnumber fnumber,PaymentBillType.fnumber FBillType,payBill.FPayeeNumber FAsstActNumber,");
                sql.append("VOUCHERTYPE.FName_").append(lang).append(" FVoucherType,VOUCHER.FNumber FVoucherNumber,VOUCHER.FBookedDate FBookedDate,payBill.FExchangeRate FExchangeRate,");
                sql.append("payBill.FUnVerifiedAmtLoc FUnVerifyAmountLocal,payBill.FUnVerifiedAmt FUnVerifyAmount,payBill.FLocalAmount FAmountLocal,AccountView.FNUMBER faccount,payBill.FSettlementNumber FSettlementNumber,");
                sql.append("payBill.FAmount FAmount,CURRENCY.FName_").append(lang).append(" FCurrency,payBill.fdescription FAbstractName,SettlementType.FNumber FSettlementType,BASECURRENCY.FName_l2 FBaseCurrency ");
                sql.append(" from T_CAS_PAYMENTBILL payBill LEFT OUTER JOIN T_BD_VoucherTypes VOUCHERTYPE ON payBill.FVoucherTypeID = VOUCHERTYPE.FID ");
                sql.append(" LEFT OUTER JOIN T_GL_Voucher VOUCHER ON payBill.FVoucherID = VOUCHER.FID ");
                sql.append(" LEFT OUTER JOIN T_BD_Currency CURRENCY ON CURRENCY.FID = payBill.FCurrencyID ");
                sql.append(" LEFT OUTER JOIN T_BD_SettlementType SettlementType on SettlementType.FID = payBill.FSettlementTypeID ");
                sql.append(" LEFT OUTER JOIN T_ORG_Company COMPANY ON COMPANY.FID = payBill.FCompanyID ");
                sql.append(" LEFT OUTER JOIN T_BD_Currency BASECURRENCY ON BASECURRENCY.FID = COMPANY.FBaseCurrencyID ");
                sql.append(" LEFT OUTER JOIN T_CAS_PaymentBillType PaymentBillType ON PaymentBillType.FID = payBill.FPayBillTypeID ");
                sql.append(" LEFT OUTER JOIN T_BD_AccountView AccountView ON AccountView.FID = payBill.FOppAccountID ");
                sql.append(" where payBill.FBizDate  >= ");
                sql.append(ARAPXMLGenerator.this.formatSqlDate(this.ctx, this.periodinfo.getBeginDate()));
                try {
                    nextPeriodInfo = PeriodUtils.getNextPeriodInfo((Context)this.ctx, (PeriodInfo)this.periodinfo);
                }
                catch (Exception e) {
                    logger.error((Object)e);
                }
                if (nextPeriodInfo != null) {
                    sql.append(" and payBill.FBizDate< ");
                    sql.append(ARAPXMLGenerator.this.formatSqlDate(this.ctx, nextPeriodInfo.getBeginDate()));
                } else {
                    sql.append(" and payBill.FBizDate<= ");
                    sql.append(ARAPXMLGenerator.this.formatSqlDate(this.ctx, this.periodinfo.getEndDate()));
                }
                sql.append(" and payBill.FCompanyID = '").append(ARAPXMLGenerator.this.companyInfoId).append("'");
                return sql.toString();
            }
        };
        xmlea.excuteAssemble();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StringBuffer getArAccount(Context ctx, OtherBillInfo otherbill) throws BOSException {
        OtherBillentryCollection entryCollection = otherbill.getEntry();
        StringBuffer account = new StringBuffer();
        String accountID = "";
        for (int i = 0; i < entryCollection.size(); ++i) {
            OtherBillentryInfo entryInfo = entryCollection.get(i);
            if (entryInfo.getAccount() != null && i == entryCollection.size() - 1) {
                accountID = accountID + "'" + entryInfo.getAccount().getId() + "'";
                continue;
            }
            if (entryInfo.getAccount() == null) continue;
            accountID = accountID + "'" + entryInfo.getAccount().getId() + "',";
        }
        if (accountID != null) {
            ResultSet rs;
            PreparedStatement pstmt;
            Connection connection;
            block10: {
                StringBuffer sql = new StringBuffer();
                sql.append("select fnumber from T_BD_AccountView ");
                sql.append("where fid in (").append(accountID).append(")");
                connection = null;
                pstmt = null;
                rs = null;
                try {
                    connection = CommonServerUtils.getConnection(ctx);
                    pstmt = connection.prepareStatement(sql.toString());
                    rs = pstmt.executeQuery();
                    ArrayList<String> accountNumList = new ArrayList<String>();
                    while (rs.next()) {
                        accountNumList.add(rs.getString("fnumber"));
                    }
                    if (accountNumList.size() <= 0) break block10;
                    for (int j = 0; j < accountNumList.size(); ++j) {
                        if (j == accountNumList.size() - 1) {
                            account.append(accountNumList.get(j));
                            continue;
                        }
                        account.append(accountNumList.get(j) + ",");
                    }
                }
                catch (Exception e) {
                    try {
                        logger.info((Object)e);
                    }
                    catch (Throwable throwable) {
                        SQLUtils.cleanup(rs, pstmt, (Connection)connection);
                        throw throwable;
                    }
                    SQLUtils.cleanup(rs, (Statement)pstmt, (Connection)connection);
                }
            }
            SQLUtils.cleanup((ResultSet)rs, (Statement)pstmt, (Connection)connection);
        }
        return account;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StringBuffer getApAccount(Context ctx, com.kingdee.eas.fi.ap.OtherBillInfo otherbill) throws BOSException {
        com.kingdee.eas.fi.ap.OtherBillentryCollection entryCollection = otherbill.getEntry();
        StringBuffer account = new StringBuffer();
        String accountID = "";
        for (int i = 0; i < entryCollection.size(); ++i) {
            com.kingdee.eas.fi.ap.OtherBillentryInfo entryInfo = entryCollection.get(i);
            if (entryInfo.getAccount() != null && i == entryCollection.size() - 1) {
                accountID = accountID + "'" + entryInfo.getAccount().getId() + "'";
                continue;
            }
            if (entryInfo.getAccount() == null) continue;
            accountID = accountID + "'" + entryInfo.getAccount().getId() + "',";
        }
        if (accountID != null) {
            ResultSet rs;
            PreparedStatement pstmt;
            Connection connection;
            block10: {
                StringBuffer sql = new StringBuffer();
                sql.append("select fnumber from T_BD_AccountView ");
                sql.append("where fid in (").append(accountID).append(")");
                connection = null;
                pstmt = null;
                rs = null;
                try {
                    connection = CommonServerUtils.getConnection(ctx);
                    pstmt = connection.prepareStatement(sql.toString());
                    rs = pstmt.executeQuery();
                    ArrayList<String> accountNumList = new ArrayList<String>();
                    while (rs.next()) {
                        accountNumList.add(rs.getString("fnumber"));
                    }
                    if (accountNumList.size() <= 0) break block10;
                    for (int j = 0; j < accountNumList.size(); ++j) {
                        if (j == accountNumList.size() - 1) {
                            account.append(accountNumList.get(j));
                            continue;
                        }
                        account.append(accountNumList.get(j) + ",");
                    }
                }
                catch (Exception e) {
                    try {
                        logger.info((Object)e);
                    }
                    catch (Throwable throwable) {
                        SQLUtils.cleanup(rs, pstmt, (Connection)connection);
                        throw throwable;
                    }
                    SQLUtils.cleanup(rs, (Statement)pstmt, (Connection)connection);
                }
            }
            SQLUtils.cleanup((ResultSet)rs, (Statement)pstmt, (Connection)connection);
        }
        return account;
    }

    public java.util.Date getArRecieveDate(Context ctx, OtherBillInfo otherbill) {
        OtherBillPlanCollection planCollection = otherbill.getRecievePlan();
        java.util.Date recieveDate = null;
        for (int i = 0; i < planCollection.size(); ++i) {
            OtherBillPlanInfo planInfo = planCollection.get(i);
            if ((planInfo.getRecievePayAmount().compareTo(planInfo.getVerifyAmount()) == 0 || recieveDate != null) && (planInfo.getRecievePayAmount().compareTo(planInfo.getVerifyAmount()) == 0 || recieveDate == null || !planInfo.getRecievePayDate().before(recieveDate))) continue;
            recieveDate = planInfo.getRecievePayDate();
        }
        if (recieveDate == null) {
            recieveDate = planCollection.get(0).getRecievePayDate();
        }
        return recieveDate;
    }

    public java.util.Date getApPayDate(Context ctx, com.kingdee.eas.fi.ap.OtherBillInfo otherbill) {
        com.kingdee.eas.fi.ap.OtherBillPlanCollection planCollection = otherbill.getPayPlan();
        java.util.Date PayDate = null;
        for (int i = 0; i < planCollection.size(); ++i) {
            com.kingdee.eas.fi.ap.OtherBillPlanInfo planInfo = planCollection.get(i);
            if ((planInfo.getRecievePayAmount().compareTo(planInfo.getVerifyAmount()) == 0 || PayDate != null) && (planInfo.getRecievePayAmount().compareTo(planInfo.getVerifyAmount()) == 0 || PayDate == null || !planInfo.getRecievePayDate().before(PayDate))) continue;
            PayDate = planInfo.getRecievePayDate();
        }
        if (PayDate == null) {
            PayDate = planCollection.get(0).getRecievePayDate();
        }
        return PayDate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public StringBuffer getArApVerificationVouch(Context ctx, String billID, CompanyOrgUnitInfo companyInfo, PeriodInfo periodinfo) throws BOSException {
        StringBuffer sql = new StringBuffer("");
        StringBuffer vouchernumberSql = new StringBuffer("");
        sql.append("select distinct fbillid from t_ar_verificationbillentry where FParentID in ");
        sql.append("(select bill.fid fid ");
        sql.append(" from T_AR_VERIFICATIONBILL bill LEFT OUTER JOIN  t_ar_verificationbillentry entry on entry.FParentID = bill.fid ");
        sql.append("where entry.fbillid='").append(billID).append("'");
        sql.append(" and bill.FBizDate >= ");
        sql.append(this.formatSqlDate(ctx, periodinfo.getBeginDate()));
        sql.append(" and bill.FBizDate < ");
        sql.append(this.formatSqlDate(ctx, periodinfo.getEndDate()));
        sql.append(" and bill.FCompanyID = '").append(this.companyInfoId).append("') ");
        sql.append(" and fbillid != '").append(billID).append("'");
        sql.append(" union all ");
        sql.append("select distinct fbillid from t_ap_verificationbillentry where FParentID in ");
        sql.append("(select bill.fid fid ");
        sql.append(" from T_AP_VERIFICATIONBILL bill LEFT OUTER JOIN  t_ap_verificationbillentry entry on entry.FParentID = bill.fid ");
        sql.append("where entry.fbillid='").append(billID).append("'");
        sql.append(" and bill.FBizDate >= ");
        sql.append(this.formatSqlDate(ctx, periodinfo.getBeginDate()));
        sql.append(" and bill.FBizDate < ");
        sql.append(this.formatSqlDate(ctx, periodinfo.getEndDate()));
        sql.append(" and bill.FCompanyID = '").append(this.companyInfoId).append("') ");
        sql.append(" and fbillid != '").append(billID).append("'");
        Connection connection = null;
        ArrayList<String> billIDList = new ArrayList<String>();
        ArrayList<String> voucherList = new ArrayList<String>();
        StringBuffer voucherNum = new StringBuffer();
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        PreparedStatement pstmt1 = null;
        ResultSet rs1 = null;
        try {
            StringBuffer billList;
            connection = EJBFactory.getConnection((Context)ctx);
            pstmt = connection.prepareStatement(sql.toString());
            rs = pstmt.executeQuery();
            while (rs.next()) {
                String billid = rs.getString("fbillid");
                billIDList.add(billid);
            }
            if (billIDList.size() > 0) {
                billList = new StringBuffer();
            } else {
                billList = null;
                SQLUtils.cleanup((ResultSet)rs, (Statement)pstmt);
                SQLUtils.cleanup(rs1, pstmt1, (Connection)connection);
                return billList;
            }
            for (int j = 0; j < billIDList.size(); ++j) {
                if (j == billIDList.size() - 1) {
                    billList.append("'").append(billIDList.get(j)).append("'");
                    continue;
                }
                billList.append("'").append(billIDList.get(j)).append("',");
            }
            vouchernumberSql.append("select fvouchernumber from t_ar_otherbill ");
            vouchernumberSql.append("where fid in (").append(billList).append(")");
            vouchernumberSql.append(" union all ");
            vouchernumberSql.append("select fvouchernumber from t_ap_otherbill ");
            vouchernumberSql.append("where fid in (").append(billList).append(")");
            vouchernumberSql.append(" union all ");
            vouchernumberSql.append("select fvouchernumber from T_CAS_ReceivingBill ");
            vouchernumberSql.append("where fid in (").append(billList).append(")");
            vouchernumberSql.append(" union all ");
            vouchernumberSql.append("select fvouchernumber from T_CAS_PaymentBill ");
            vouchernumberSql.append("where fid in (").append(billList).append(")");
            pstmt1 = connection.prepareStatement(vouchernumberSql.toString());
            rs1 = pstmt1.executeQuery();
            while (rs1.next()) {
                voucherList.add(rs1.getString("fvouchernumber"));
            }
            if (voucherList.size() > 0) {
            } else {
                StringBuffer stringBuffer = null;
                SQLUtils.cleanup((ResultSet)rs, (Statement)pstmt);
                SQLUtils.cleanup((ResultSet)rs1, (Statement)pstmt1, (Connection)connection);
                return stringBuffer;
            }
            for (int z = 0; z < voucherList.size(); ++z) {
                if (z == voucherList.size() - 1 && voucherList.get(z) != null) {
                    voucherNum.append(voucherList.get(z));
                    continue;
                }
                if (voucherList.get(z) == null) continue;
                voucherNum.append(voucherList.get(z) + ",");
            }
        }
        catch (Exception e) {
            try {
                logger.info((Object)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, pstmt);
                SQLUtils.cleanup(rs1, pstmt1, (Connection)connection);
                throw throwable;
            }
            SQLUtils.cleanup(rs, (Statement)pstmt);
            SQLUtils.cleanup(rs1, pstmt1, (Connection)connection);
            return voucherNum;
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)pstmt);
        SQLUtils.cleanup((ResultSet)rs1, (Statement)pstmt1, (Connection)connection);
        return voucherNum;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public java.util.Date getArApLastVerification(Context ctx, String billID, CompanyOrgUnitInfo companyInfo, PeriodInfo periodinfo) throws BOSException {
        StringBuffer sql = new StringBuffer("");
        sql.append("select distinct bill.fid fid,bill.fbizdate fbizdate");
        sql.append(" from T_AR_VERIFICATIONBILL bill LEFT OUTER JOIN  t_ar_verificationbillentry entry on entry.FParentID = bill.fid ");
        sql.append("where entry.fbillid='").append(billID).append("'");
        sql.append(" and bill.FBizDate >= {");
        sql.append(this.formatSqlDate(ctx, periodinfo.getBeginDate()));
        sql.append(" and bill.FBizDate < ");
        sql.append(this.formatSqlDate(ctx, periodinfo.getEndDate()));
        sql.append(" and bill.FCompanyID = '").append(this.companyInfoId).append("'");
        sql.append(" union all ");
        sql.append("select distinct bill.fid fid,bill.fbizdate fbizdate");
        sql.append(" from T_AP_VERIFICATIONBILL bill LEFT OUTER JOIN  t_ap_verificationbillentry entry on entry.FParentID = bill.fid ");
        sql.append("where entry.fbillid='").append(billID).append("'");
        sql.append(" and bill.FBizDate >= ");
        sql.append(this.formatSqlDate(ctx, periodinfo.getBeginDate()));
        sql.append(" and bill.FBizDate < ");
        sql.append(this.formatSqlDate(ctx, periodinfo.getEndDate()));
        sql.append(" and bill.FCompanyID = '").append(this.companyInfoId).append("'");
        Connection connection = null;
        Object voucherNum = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        java.util.Date lastVerifyTime = null;
        try {
            connection = EJBFactory.getConnection((Context)ctx);
            pstmt = connection.prepareStatement(sql.toString());
            rs = pstmt.executeQuery();
            while (rs.next()) {
                Date verifyTime = rs.getDate("fbizdate");
                if (lastVerifyTime != null && lastVerifyTime.before(verifyTime)) {
                    lastVerifyTime = verifyTime;
                    continue;
                }
                if (lastVerifyTime != null) continue;
                lastVerifyTime = verifyTime;
            }
        }
        catch (Exception e) {
            try {
                logger.info((Object)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, pstmt, (Connection)connection);
                throw throwable;
            }
            SQLUtils.cleanup(rs, (Statement)pstmt, (Connection)connection);
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)pstmt, (Connection)connection);
        return lastVerifyTime;
    }

    public String getTypeName() {
        return null;
    }

    private String formatSqlDate(Context ctx, java.util.Date date) {
        DCInfo dcInfo = this.getDCInfo(ctx);
        if (dcInfo == null) {
            return this.formatSqlDateMssql(ctx, date);
        }
        int dbType = dcInfo.getDBType();
        switch (dbType) {
            case 2: {
                return this.formatSqlDateOracle(ctx, date);
            }
            case 0: {
                return this.formatSqlDateMssql(ctx, date);
            }
            case 1: {
                return this.formatSqlDateDB2(ctx, date);
            }
            case 3: {
                return this.formatSqlDatePostgreSql(ctx, date);
            }
        }
        return this.formatSqlDateMssql(ctx, date);
    }

    private String formatSqlDateOracle(Context ctx, java.util.Date date) {
        String format = "yyyy-MM-dd HH:mm:ss";
        String oracleFormat = "YYYY-MM-DD HH24:MI:SS";
        SimpleDateFormat formatter = new SimpleDateFormat(format);
        return String.format("to_date('%s')", formatter.format(date));
    }

    private String formatSqlDateMssql(Context ctx, java.util.Date date) {
        String format = "yyyy-MM-dd HH:mm:ss";
        SimpleDateFormat formatter = new SimpleDateFormat(format);
        return String.format("'%s'", formatter.format(date));
    }

    private String formatSqlDateDB2(Context ctx, java.util.Date date) {
        String format = "yyyy-MM-dd HH:mm:ss";
        SimpleDateFormat formatter = new SimpleDateFormat(format);
        return String.format("'%s'", formatter.format(date));
    }

    private String formatSqlDatePostgreSql(Context ctx, java.util.Date date) {
        String format = "yyyy-MM-dd HH:mm:ss";
        SimpleDateFormat formatter = new SimpleDateFormat(format);
        return String.format("'%s'", formatter.format(date));
    }

    private DCInfo getDCInfo(Context ctx) {
        try {
            DCRegister dcr = new DCRegister();
            ArrayList dcList = dcr.getDCList();
            DCInfo dci = null;
            int n = dcList.size();
            for (int i = 0; i < n; ++i) {
                dci = (DCInfo)dcList.get(i);
                if (!dci.getNumber().equals(ctx.getAIS())) continue;
                return dci;
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return null;
    }

    public File generate(Context ctx, CompanyOrgUnitInfo companyInfo, List<PeriodInfo> paramList) {
        String type = this.getTypeName(ctx);
        Element root = this.initHeadAndFileName(ctx, companyInfo, type);
        this.companyInfoId = companyInfo.getId().toString();
        for (PeriodInfo periodinfo : paramList) {
            this.generateBillTypeNumber(root, ctx, companyInfo, periodinfo);
            this.generateBizTypeNumber(root, ctx, companyInfo, periodinfo);
            this.generateArOtherBill(root, ctx, companyInfo, periodinfo);
            this.generateApOtherBill(root, ctx, companyInfo, periodinfo);
        }
        this.endElement();
        this.close();
        return this.file;
    }
}

