/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.arap.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.dao.AbstractObjectCollection;
import com.kingdee.bos.dao.AbstractObjectValue;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.framework.DynamicObjectFactory;
import com.kingdee.bos.framework.IDynamicObject;
import com.kingdee.bos.metadata.IMetaDataLoader;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.access.IMetaDataAccess;
import com.kingdee.bos.metadata.access.MetaDataAccessFactory;
import com.kingdee.bos.metadata.access.entity.EntitySelect;
import com.kingdee.bos.metadata.access.entity.SimpleEntity;
import com.kingdee.bos.metadata.bot.BOTMappingCollection;
import com.kingdee.bos.metadata.bot.BOTMappingFactory;
import com.kingdee.bos.metadata.bot.BOTMappingInfo;
import com.kingdee.bos.metadata.bot.BOTRuleCollection;
import com.kingdee.bos.metadata.bot.BOTRuleInfo;
import com.kingdee.bos.metadata.bot.BOTRuleSegmentCollection;
import com.kingdee.bos.metadata.bot.BOTRuleSegmentInfo;
import com.kingdee.bos.metadata.bot.DefineSysEnum;
import com.kingdee.bos.metadata.bot.IBOTMapping;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.LinkPropertyInfo;
import com.kingdee.bos.metadata.entity.OwnPropertyInfo;
import com.kingdee.bos.metadata.entity.PropertyCollection;
import com.kingdee.bos.metadata.entity.PropertyInfo;
import com.kingdee.bos.metadata.entity.RelationshipInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.bos.workflow.service.ormrpc.EnactmentServiceFactory;
import com.kingdee.bos.workflow.service.ormrpc.IEnactmentService;
import com.kingdee.eas.base.botp.BOTPException;
import com.kingdee.eas.base.btp.BTPException;
import com.kingdee.eas.base.btp.BTPManagerFactory;
import com.kingdee.eas.base.btp.BTPTransformResult;
import com.kingdee.eas.base.btp.IBTPManager;
import com.kingdee.eas.base.permission.IPermItem;
import com.kingdee.eas.base.permission.IPermission;
import com.kingdee.eas.base.permission.PermItemFactory;
import com.kingdee.eas.base.permission.PermItemInfo;
import com.kingdee.eas.base.permission.PermissionException;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.assistant.AccountBankCollection;
import com.kingdee.eas.basedata.assistant.AccountBankFactory;
import com.kingdee.eas.basedata.assistant.AccountBankInfo;
import com.kingdee.eas.basedata.assistant.ConvertModeEnum;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.ExchangeRateInfo;
import com.kingdee.eas.basedata.assistant.IAccountBank;
import com.kingdee.eas.basedata.assistant.ICurrency;
import com.kingdee.eas.basedata.assistant.IPayCondition;
import com.kingdee.eas.basedata.assistant.ISystemStatusCtrol;
import com.kingdee.eas.basedata.assistant.MeasureUnitInfo;
import com.kingdee.eas.basedata.assistant.PayConditionFactory;
import com.kingdee.eas.basedata.assistant.PayConditionInfo;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolCollection;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolFactory;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolInfo;
import com.kingdee.eas.basedata.framework.DataBaseDInfo;
import com.kingdee.eas.basedata.master.account.AccountViewInfo;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeCollection;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeFactory;
import com.kingdee.eas.basedata.master.auxacct.IAsstActType;
import com.kingdee.eas.basedata.master.cssp.CustomerCompanyBankCollection;
import com.kingdee.eas.basedata.master.cssp.CustomerCompanyBankFactory;
import com.kingdee.eas.basedata.master.cssp.CustomerCompanyBankInfo;
import com.kingdee.eas.basedata.master.cssp.CustomerCompanyInfoCollection;
import com.kingdee.eas.basedata.master.cssp.CustomerCompanyInfoFactory;
import com.kingdee.eas.basedata.master.cssp.CustomerCompanyInfoInfo;
import com.kingdee.eas.basedata.master.cssp.CustomerFactory;
import com.kingdee.eas.basedata.master.cssp.CustomerInfo;
import com.kingdee.eas.basedata.master.cssp.ICustomer;
import com.kingdee.eas.basedata.master.cssp.ICustomerCompanyBank;
import com.kingdee.eas.basedata.master.cssp.ICustomerCompanyInfo;
import com.kingdee.eas.basedata.master.cssp.ISupplier;
import com.kingdee.eas.basedata.master.cssp.ISupplierCompanyBank;
import com.kingdee.eas.basedata.master.cssp.SupplierCollection;
import com.kingdee.eas.basedata.master.cssp.SupplierCompanyBankCollection;
import com.kingdee.eas.basedata.master.cssp.SupplierCompanyBankFactory;
import com.kingdee.eas.basedata.master.cssp.SupplierCompanyBankInfo;
import com.kingdee.eas.basedata.master.cssp.SupplierCompanyInfoInfo;
import com.kingdee.eas.basedata.master.cssp.SupplierFactory;
import com.kingdee.eas.basedata.master.cssp.SupplierInfo;
import com.kingdee.eas.basedata.master.material.AsstAttrValueInfo;
import com.kingdee.eas.basedata.master.material.IMultiMeasureUnit;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.master.material.MultiMeasureUnitFactory;
import com.kingdee.eas.basedata.org.AdminOrgUnitFactory;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitCollection;
import com.kingdee.eas.basedata.org.IAdminOrgUnit;
import com.kingdee.eas.basedata.org.ICompanyOrgUnit;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitCollection;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.PurchaseOrgUnitInfo;
import com.kingdee.eas.basedata.org.SaleOrgUnitInfo;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.basedata.person.IPerson;
import com.kingdee.eas.basedata.person.IPersonAccount;
import com.kingdee.eas.basedata.person.PersonAccountFactory;
import com.kingdee.eas.basedata.person.PersonAccountInfo;
import com.kingdee.eas.basedata.person.PersonFactory;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.basedata.scm.common.RowTypeInfo;
import com.kingdee.eas.basedata.scm.sd.sale.PriceCondition;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.SysConstant;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.cp.bc.ExpenseTypeInfo;
import com.kingdee.eas.fi.ap.ApBillInfoCalculate;
import com.kingdee.eas.fi.ap.OtherBillType;
import com.kingdee.eas.fi.ap.VerificateBillTypeEnum;
import com.kingdee.eas.fi.ar.ArApBillBaseInfo;
import com.kingdee.eas.fi.ar.ArApBillEntryBaseCollection;
import com.kingdee.eas.fi.ar.ArApBillEntryBaseInfo;
import com.kingdee.eas.fi.ar.ArApBillPlanBaseCollection;
import com.kingdee.eas.fi.ar.ArApBillPlanBaseInfo;
import com.kingdee.eas.fi.ar.ArBillInfoCalculate;
import com.kingdee.eas.fi.ar.BillStatusEnum;
import com.kingdee.eas.fi.ar.IArApBillBase;
import com.kingdee.eas.fi.ar.IncomeConfimEntryInfo;
import com.kingdee.eas.fi.ar.IncomeConfirmBillInfoCalculate;
import com.kingdee.eas.fi.ar.OtherBillAgent;
import com.kingdee.eas.fi.ar.OtherBillBizException;
import com.kingdee.eas.fi.ar.OtherBillFactory;
import com.kingdee.eas.fi.ar.OtherBillInfo;
import com.kingdee.eas.fi.ar.OtherBillPlanAgent;
import com.kingdee.eas.fi.ar.OtherBillPlanInfo;
import com.kingdee.eas.fi.ar.OtherBillTypeEnum;
import com.kingdee.eas.fi.ar.OtherBillentryCollection;
import com.kingdee.eas.fi.ar.OtherBillentryInfo;
import com.kingdee.eas.fi.ar.app.util.BaseDataUtil;
import com.kingdee.eas.fi.ar.util.ListUtil;
import com.kingdee.eas.fi.ar.verifyStatusEnum;
import com.kingdee.eas.fi.arap.ArApBillFacadeFactory;
import com.kingdee.eas.fi.arap.ArApConstants;
import com.kingdee.eas.fi.arap.ArApSysParamInfo;
import com.kingdee.eas.fi.arap.BillRelationOptionEnum;
import com.kingdee.eas.fi.arap.DbUtilFacadeFactory;
import com.kingdee.eas.fi.arap.IArApBillFacade;
import com.kingdee.eas.fi.arap.IDbUtilFacade;
import com.kingdee.eas.fi.arap.PriceSourceEnum;
import com.kingdee.eas.fi.arap.app.util.ArApServerUtils;
import com.kingdee.eas.fi.arap.util.ArApBaseCalculate;
import com.kingdee.eas.fi.arap.util.ArApBillInfoCalculate;
import com.kingdee.eas.fi.arap.util.ArApParamHelper;
import com.kingdee.eas.fi.arap.util.ArApSelectorFactory;
import com.kingdee.eas.fi.arap.util.BotpRuleEvalExecutor;
import com.kingdee.eas.fi.arap.util.CalculateInfoCondition;
import com.kingdee.eas.fi.arap.util.PlanHelper;
import com.kingdee.eas.fi.cas.ArApRecPayException;
import com.kingdee.eas.fi.cas.RecPayBillInfo;
import com.kingdee.eas.fi.cas.RecPayHelper;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.CoreBillBaseCollection;
import com.kingdee.eas.framework.CoreBillBaseInfo;
import com.kingdee.eas.framework.DataBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.scm.common.ISMSDBillConfig;
import com.kingdee.eas.scm.common.SCMGroupFacadeFactory;
import com.kingdee.eas.scm.common.SMSDBillConfigCollection;
import com.kingdee.eas.scm.common.SMSDBillConfigFactory;
import com.kingdee.eas.scm.common.SMSDBillConfigInfo;
import com.kingdee.eas.scm.common.app.SCMGroupServerUtils;
import com.kingdee.eas.scm.common.loadmass.SCMEntryDataVO;
import com.kingdee.eas.scm.common.util.StringUtil;
import com.kingdee.eas.scm.im.inv.IPurInWarehsEntry;
import com.kingdee.eas.scm.im.inv.PurInWarehsEntryFactory;
import com.kingdee.eas.scm.im.inv.PurInWarehsEntryInfo;
import com.kingdee.eas.scm.sm.pur.IPurOrder;
import com.kingdee.eas.scm.sm.pur.PurInnerDealPriceCollection;
import com.kingdee.eas.scm.sm.pur.PurInnerDealPriceFactory;
import com.kingdee.eas.scm.sm.pur.PurInnerDealPriceInfo;
import com.kingdee.eas.scm.sm.pur.PurOrderFactory;
import com.kingdee.eas.scm.sm.pur.PurOrderInfo;
import com.kingdee.eas.scm.util.SCMSelectorFactory;
import com.kingdee.eas.tools.datatask.core.TaskExternalException;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.LocaleUtils;
import com.kingdee.util.StringUtils;
import com.kingdee.util.enums.IntEnum;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class ArApBillHelper {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fi.arap.util.ArApBillHelper");
    public static BigDecimal NEGONE = new BigDecimal("-1");
    public static final BigDecimal ZERO = new BigDecimal("0");
    public static final String PUR_ORDER_ENTRY_BOSTYPE = "26041CC5";
    public static final String SALE_ORDER_ENTRY_BOSTYPE = "88882A58";
    public static final String PUR_INWAREHS_ENTRY_BOSTYPE = "8E088616";
    public static final String SALE_ISSUE_ENTRY_BOSTYPE = "BBC07FBE";
    public static final String PUR_ORDER_BOSTYPE = "3171BFAD";
    public static final String SALE_ORDER_BOSTYPE = "C48A423A";
    public static final String AR_OTHERBILL_BOSTYPE = "FC910EF3";
    public static final String AP_OTHERBILL_BOSTYPE = "48DA3A71";
    private static String ASSTTYPE_CUSTOMER = "YW3xsAEJEADgAAUWwKgTB0c4VZA=";
    private static String ASSTTYPE_SUPPLIER = "YW3xsAEJEADgAAVEwKgTB0c4VZA=";
    protected static final BigDecimal ONE = new BigDecimal("1.0");
    private static final String res = "com.kingdee.eas.fi.arap.ArapResource";

    public static void handleRedBill(IObjectValue billInfo) {
        ArApBillHelper.handleRedBill(billInfo, true);
    }

    public static void handleRedBill(IObjectValue ov, boolean isRedBill) {
        if (ov instanceof ArApBillBaseInfo) {
            ArApBillBaseInfo billInfo = (ArApBillBaseInfo)ov;
            ArApBillHelper.handleRedProps((IObjectValue)billInfo, ArApBillBaseInfo.getRedProp(), isRedBill);
            String[] entryRedProps = ArApBillEntryBaseInfo.getRedProp();
            AbstractObjectCollection entryCol = billInfo.getEntries();
            for (int i = 0; entryCol != null && i < entryCol.size(); ++i) {
                IObjectValue entryInfo = entryCol.getObject(i);
                ArApBillHelper.handleRedProps(entryInfo, entryRedProps, isRedBill);
            }
            AbstractObjectCollection planCol = billInfo.getPlans();
            String[] planRedPros = ArApBillPlanBaseInfo.getRedProp();
            for (int i = 0; planCol != null && i < planCol.size(); ++i) {
                IObjectValue planInfo = planCol.getObject(i);
                ArApBillHelper.handleRedProps(planInfo, planRedPros, isRedBill);
            }
        } else if (ov instanceof ArApBillEntryBaseInfo) {
            String[] entryRedProps = ArApBillEntryBaseInfo.getRedProp();
            ArApBillHelper.handleRedProps(ov, entryRedProps, isRedBill);
        } else if (ov instanceof ArApBillPlanBaseInfo) {
            String[] planRedPros = ArApBillPlanBaseInfo.getRedProp();
            ArApBillHelper.handleRedProps(ov, planRedPros, isRedBill);
        }
    }

    public static void handleRedProps(IObjectValue ov, String[] redProps, boolean isRedBill) {
        for (int i = 0; i < redProps.length; ++i) {
            String key = redProps[i];
            BigDecimal value = ov.getBigDecimal(key);
            if (value == null) continue;
            value = isRedBill ? value.abs().negate() : value.abs();
            ov.setBigDecimal(key, value);
        }
    }

    public static VerificateBillTypeEnum changeBillType(int billType) {
        VerificateBillTypeEnum billTypeEnum = null;
        switch (billType) {
            case 102: {
                billTypeEnum = VerificateBillTypeEnum.SaleInvoice;
                break;
            }
            case 103: {
                billTypeEnum = VerificateBillTypeEnum.SaleChargeInvoice;
                break;
            }
            case 104: {
                billTypeEnum = VerificateBillTypeEnum.AR_DebitAdjust;
                break;
            }
            case 101: {
                billTypeEnum = VerificateBillTypeEnum.OtherReceiveBill;
                break;
            }
            case 202: {
                billTypeEnum = VerificateBillTypeEnum.PurInvoice;
                break;
            }
            case 203: {
                billTypeEnum = VerificateBillTypeEnum.PurChargeInvoice;
                break;
            }
            case 201: {
                billTypeEnum = VerificateBillTypeEnum.OtherPaymentBill;
                break;
            }
            case 204: {
                billTypeEnum = VerificateBillTypeEnum.AP_DebitAdjust;
            }
        }
        return billTypeEnum;
    }

    public static int getDays(Date date1, Date date2) {
        return (int)(date1.getTime() - date2.getTime()) / 86400000;
    }

    public static boolean isOnlyId(DataBaseInfo info) {
        return info != null && info.getId() != null && StringUtils.isEmpty((String)info.getName());
    }

    public static boolean isNull(DataBaseInfo info) {
        return info == null;
    }

    public static boolean isEmptyOrZero(Object obj) {
        if (obj == null) {
            return true;
        }
        if (obj instanceof String && obj.toString().trim().length() == 0) {
            return true;
        }
        return obj instanceof BigDecimal && ((BigDecimal)obj).signum() == 0;
    }

    public static CompanyOrgUnitInfo getCompanyOrgUnitInfo(Context ctx, BOSUuid companyId, CompanyOrgUnitInfo companyInfo) throws EASBizException, BOSException {
        ObjectUuidPK pk = new ObjectUuidPK(companyId);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("CU.id"));
        sic.add(new SelectorItemInfo("CU.number"));
        sic.add(new SelectorItemInfo("CU.name"));
        sic.add(new SelectorItemInfo("CU.code"));
        sic.add(new SelectorItemInfo("CU.longNumber"));
        sic.add(new SelectorItemInfo("isOnlyUnion"));
        sic.add(new SelectorItemInfo("baseCurrency.name"));
        sic.add(new SelectorItemInfo("baseCurrency.number"));
        sic.add(new SelectorItemInfo("baseCurrency.precision"));
        ICompanyOrgUnit iCompany = null;
        iCompany = ctx == null ? CompanyOrgUnitFactory.getRemoteInstance() : CompanyOrgUnitFactory.getLocalInstance((Context)ctx);
        return iCompany.getCompanyOrgUnitInfo((IObjectPK)pk, sic);
    }

    private static CompanyOrgUnitInfo getCompanyBySysEnum(Context ctx, FullOrgUnitCollection orgs, SystemEnum sysEnum) throws BOSException {
        if (orgs == null || orgs.size() == 0) {
            return null;
        }
        LinkedHashSet<String> keys = new LinkedHashSet<String>();
        for (int i = 0; i < orgs.size(); ++i) {
            keys.add(orgs.get(i).getId().toString());
        }
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("company.*"));
        sic.add(new SelectorItemInfo("company.isOnlyUnion"));
        view.getSelector().addObjectCollection((IObjectCollection)sic);
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("company.id", keys, CompareType.INCLUDE));
        filter.getFilterItems().add(new FilterItemInfo("startPeriod.id", null, CompareType.NOTEQUALS));
        if (sysEnum != null) {
            filter.getFilterItems().add(new FilterItemInfo("systemStatus.name", (Object)sysEnum));
        }
        view.setFilter(filter);
        view.getSorter().add(new SorterItemInfo("company.number"));
        ISystemStatusCtrol systemStatusCtrol = null;
        systemStatusCtrol = ctx == null ? SystemStatusCtrolFactory.getRemoteInstance() : SystemStatusCtrolFactory.getLocalInstance((Context)ctx);
        CoreBaseCollection collection = systemStatusCtrol.getCollection(view);
        for (SystemStatusCtrolInfo sysStatusCtrlInfo : collection) {
            if (sysStatusCtrlInfo.getCompany().isIsOnlyUnion()) continue;
            return sysStatusCtrlInfo.getCompany();
        }
        return null;
    }

    public static BigDecimal getTotalValue(AbstractObjectCollection collection, String propName) {
        BigDecimal totalValue = ArApBaseCalculate.ZERO;
        if (collection == null) {
            return totalValue;
        }
        for (IObjectValue entryInfo : collection) {
            Object obj = entryInfo.get(propName);
            if (!(obj instanceof BigDecimal)) continue;
            totalValue = totalValue.add((BigDecimal)obj);
        }
        return totalValue;
    }

    public static HashMap getTotalValue(AbstractObjectCollection collection, String[] fields) {
        HashMap<String, BigDecimal> totalValues = new HashMap<String, BigDecimal>();
        for (int i = 0; i < fields.length; ++i) {
            totalValues.put(fields[i], ArApBaseCalculate.ZERO);
        }
        if (collection == null) {
            return totalValues;
        }
        for (IObjectValue entryInfo : collection) {
            for (int i = 0; i < fields.length; ++i) {
                Object obj = entryInfo.get(fields[i]);
                if (!(obj instanceof BigDecimal)) continue;
                totalValues.put(fields[i], ((BigDecimal)totalValues.get(fields[i])).add((BigDecimal)obj));
            }
        }
        return totalValues;
    }

    public static CompanyOrgUnitInfo getDefaultCompany(Context ctx, UserInfo userInfo, SystemEnum sysEnum, String permissionItem) throws BOSException, EASBizException {
        return ArApBillHelper.getDefaultCompany(ctx, null, userInfo, sysEnum, permissionItem);
    }

    public static CompanyOrgUnitInfo getDefaultCompany(Context ctx, OrgUnitInfo orgUnitInfo, UserInfo userInfo, SystemEnum sysEnum, String permissionItem) throws BOSException, EASBizException {
        CompanyOrgUnitInfo defaultCompany = null;
        if (ctx == null) {
            defaultCompany = SysContext.getSysContext().getCurrentFIUnit();
        } else {
            OrgUnitCollection orgUnitColl;
            OrgUnitInfo currentOrgUnit = orgUnitInfo == null ? ContextUtil.getCurrentOrgUnit((Context)ctx) : orgUnitInfo;
            OrgType srcOrgType = null;
            OrgType destOrgType = OrgType.Company;
            if (currentOrgUnit.isIsSaleOrgUnit() && currentOrgUnit instanceof SaleOrgUnitInfo && ((SaleOrgUnitInfo)currentOrgUnit).isIsBizUnit()) {
                srcOrgType = OrgType.Sale;
            } else if (currentOrgUnit.isIsPurchaseOrgUnit() && currentOrgUnit instanceof PurchaseOrgUnitInfo && ((PurchaseOrgUnitInfo)currentOrgUnit).isIsBizUnit()) {
                srcOrgType = OrgType.Purchase;
            } else if (currentOrgUnit.isIsStorageOrgUnit() && currentOrgUnit instanceof StorageOrgUnitInfo && ((StorageOrgUnitInfo)currentOrgUnit).isIsBizUnit()) {
                srcOrgType = OrgType.Storage;
            } else if (currentOrgUnit.isIsAdminOrgUnit()) {
                srcOrgType = OrgType.Admin;
            }
            if (currentOrgUnit.isIsCompanyOrgUnit() && (defaultCompany = orgUnitInfo != null ? (CompanyOrgUnitInfo)orgUnitInfo : ContextUtil.getCurrentFIUnit((Context)ctx)).isIsOnlyUnion()) {
                defaultCompany = null;
            }
            if (defaultCompany == null && srcOrgType != null && (orgUnitColl = SCMGroupServerUtils.getOrgsByRelation((Context)ctx, (OrgType)srcOrgType, (OrgType)destOrgType, (String)currentOrgUnit.getId().toString())) != null && orgUnitColl.size() > 0) {
                defaultCompany = (CompanyOrgUnitInfo)orgUnitColl.get(0);
            }
        }
        IPermission permission = ctx == null ? PermissionFactory.getRemoteInstance() : PermissionFactory.getLocalInstance((Context)ctx);
        if (defaultCompany != null && !defaultCompany.isIsOnlyUnion()) {
            FilterInfo idFilter = new FilterInfo();
            idFilter.getFilterItems().add(new FilterItemInfo("unit.partFI.isOnlyUnion", (Object)false));
            idFilter.getFilterItems().add(new FilterItemInfo("unit.partFI.unit.id", (Object)defaultCompany.getId().toString()));
            EntityViewInfo idEv = new EntityViewInfo();
            idEv.getSelector().add(new SelectorItemInfo("id"));
            idEv.setFilter(idFilter);
            FullOrgUnitCollection mainOrgs = permission.getAuthorizedOrg((IObjectPK)new ObjectUuidPK(userInfo.getId()), OrgType.Company, null, permissionItem, idEv);
            for (int i = 0; i < mainOrgs.size(); ++i) {
                if (defaultCompany == null || !defaultCompany.getId().equals((Object)mainOrgs.get(i).getId())) continue;
                return ArApBillHelper.getCompanyOrgUnitInfo(ctx, defaultCompany.getId(), defaultCompany);
            }
            defaultCompany = null;
        }
        boolean isFirstLoop = true;
        HashSet<Boolean> valueSet = new HashSet<Boolean>();
        valueSet.add(Boolean.FALSE);
        while (defaultCompany == null || defaultCompany.isIsOnlyUnion()) {
            FullOrgUnitCollection mainOrgs;
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("unit.partFI.isOnlyUnion", valueSet, CompareType.INCLUDE));
            EntityViewInfo ev = new EntityViewInfo();
            ev.getSelector().add(new SelectorItemInfo("id"));
            ev.setFilter(filter);
            if (isFirstLoop) {
                ev.setTopCount(500);
            }
            if ((mainOrgs = permission.getAuthorizedOrg((IObjectPK)new ObjectUuidPK(userInfo.getId()), OrgType.Company, null, permissionItem, ev)).size() == 0 && !isFirstLoop) {
                if (permissionItem != null) {
                    IPermItem iPermItem = null;
                    iPermItem = ctx == null ? PermItemFactory.getRemoteInstance() : PermItemFactory.getLocalInstance((Context)ctx);
                    PermItemInfo permItemInfo = iPermItem.getPermItemInfoByNumber(permissionItem);
                    throw new PermissionException(PermissionException.HAS_NOT_FUNCTION_PERMISSION, new Object[]{permItemInfo.getAlias()});
                }
                throw new OtherBillBizException(OtherBillBizException.COMPANYISNULL);
            }
            if (mainOrgs.size() > 0) {
                defaultCompany = ArApBillHelper.getCompanyBySysEnum(ctx, mainOrgs, sysEnum);
            }
            if (defaultCompany == null && !isFirstLoop) {
                throw new OtherBillBizException(OtherBillBizException.STARTPERIODISNULL, new Object[]{sysEnum});
            }
            isFirstLoop = false;
        }
        return ArApBillHelper.getCompanyOrgUnitInfo(ctx, defaultCompany.getId(), defaultCompany);
    }

    public static CompanyOrgUnitInfo getDefaultCompany(Context ctx, UserInfo userInfo, String permissionItem) throws EASBizException, BOSException {
        return ArApBillHelper.getDefaultCompany(ctx, userInfo, null, permissionItem);
    }

    public static String[] stringArrayAppend(String[] oldArray, String[] appendArray) {
        if (oldArray == null) {
            oldArray = new String[]{};
        }
        if (appendArray == null) {
            appendArray = new String[]{};
        }
        String[] newArray = new String[oldArray.length + appendArray.length];
        System.arraycopy(oldArray, 0, newArray, 0, oldArray.length);
        System.arraycopy(appendArray, 0, newArray, oldArray.length, appendArray.length);
        return newArray;
    }

    public static boolean objectEquals(Object obj1, Object obj2) {
        if (obj1 == null && obj2 == null) {
            return true;
        }
        if (obj1 == null || obj2 == null) {
            return false;
        }
        if (obj1 instanceof BigDecimal && obj2 instanceof BigDecimal) {
            return ((BigDecimal)obj1).compareTo((BigDecimal)obj2) == 0;
        }
        return obj1.equals(obj2);
    }

    public static boolean idEquals(CoreBaseInfo obj1, CoreBaseInfo obj2) {
        if (obj1 == null && obj2 == null) {
            return true;
        }
        if (obj1 == null || obj2 == null) {
            return false;
        }
        return obj1.getId().equals((Object)obj2.getId());
    }

    public static SystemStatusCtrolInfo getSysStatusCtrolInfo(Context ctx, CompanyOrgUnitInfo cmpnyOrgUntInfObj, SystemEnum system) throws BOSException {
        String cmpnyOrgUntID = cmpnyOrgUntInfObj.getId().toString();
        ISystemStatusCtrol systemStatusCtrol = ctx == null ? SystemStatusCtrolFactory.getRemoteInstance() : SystemStatusCtrolFactory.getLocalInstance((Context)ctx);
        String cndtn0 = "(company='" + cmpnyOrgUntID + "')";
        String cndtn1 = "(systemStatus.name=" + system.getValue() + ")";
        String cndtn = cndtn0 + " and " + cndtn1;
        String oql = "select isStart,isRelatedAccount,relatedPeriod,isClosedAccount,company,acPeriod,id,systemStatus,currentPeriod.number,currentPeriod.periodYear,currentPeriod.periodQuarter,currentPeriod.periodNumber,currentPeriod.beginDate,currentPeriod.endDate,currentPeriod.periodType,currentPeriod.isAdjustPeriod,currentPeriod.id,startPeriod.periodYear,startPeriod.numberstartPeriod.periodQuarter,startPeriod.periodNumber,startPeriod.beginDate,startPeriod.endDate,startPeriod.periodType,startPeriod.isAdjustPeriod,startPeriod.id where " + cndtn;
        SystemStatusCtrolCollection systmStsCtrlCllctn = systemStatusCtrol.getSystemStatusCtrolCollection(oql);
        int size = systmStsCtrlCllctn.size();
        if (size <= 0) {
            return null;
        }
        if (size == 1) {
            SystemStatusCtrolInfo systmStsCtrlInf = systmStsCtrlCllctn.get(0);
            return systmStsCtrlInf;
        }
        throw new IllegalArgumentException();
    }

    public static Date getLastPeriodDate(PeriodInfo period) {
        if (period == null) {
            return null;
        }
        Date beforeStartDate = null;
        Calendar cal = Calendar.getInstance();
        cal.setTime(period.getBeginDate());
        cal.add(2, 1);
        cal.add(5, -1);
        beforeStartDate = cal.getTime();
        return beforeStartDate;
    }

    public static Date getVerifiedDate(Date maxBillDate, PeriodInfo curPeriod) {
        Date firstDateCP;
        Date sysDate = new Date();
        Date lastDateCP = curPeriod == null ? new Date() : ArApBillHelper.getLastPeriodDate(curPeriod);
        Date date = firstDateCP = curPeriod == null ? new Date() : curPeriod.getBeginDate();
        if ((maxBillDate.after(sysDate) || maxBillDate.equals(sysDate)) && (sysDate.after(lastDateCP) || sysDate.equals(lastDateCP))) {
            return maxBillDate;
        }
        if ((maxBillDate.after(lastDateCP) || maxBillDate.equals(lastDateCP)) && (lastDateCP.after(sysDate) || lastDateCP.equals(sysDate))) {
            return maxBillDate;
        }
        if ((lastDateCP.after(sysDate) || lastDateCP.equals(sysDate)) && (sysDate.after(maxBillDate) || sysDate.equals(maxBillDate)) && (maxBillDate.after(firstDateCP) || maxBillDate.equals(firstDateCP)) && (maxBillDate.before(lastDateCP) || maxBillDate.equals(lastDateCP))) {
            return maxBillDate;
        }
        if ((lastDateCP.after(sysDate) || lastDateCP.equals(sysDate)) && (sysDate.after(maxBillDate) || sysDate.equals(maxBillDate))) {
            if ((maxBillDate.after(firstDateCP) || maxBillDate.equals(firstDateCP)) && (maxBillDate.before(lastDateCP) || maxBillDate.equals(lastDateCP))) {
                return sysDate;
            }
            if (maxBillDate.before(firstDateCP)) {
                if ((sysDate.after(firstDateCP) || sysDate.equals(firstDateCP)) && (sysDate.before(lastDateCP) || sysDate.equals(lastDateCP))) {
                    return sysDate;
                }
                return lastDateCP;
            }
        }
        if ((lastDateCP.after(maxBillDate) || lastDateCP.equals(maxBillDate)) && (maxBillDate.after(sysDate) || maxBillDate.equals(sysDate))) {
            if ((maxBillDate.after(firstDateCP) || maxBillDate.equals(firstDateCP)) && (maxBillDate.before(lastDateCP) || maxBillDate.equals(lastDateCP))) {
                return maxBillDate;
            }
            if (maxBillDate.before(firstDateCP)) {
                return lastDateCP;
            }
        }
        if ((sysDate.after(lastDateCP) || sysDate.equals(lastDateCP)) && (lastDateCP.after(maxBillDate) || lastDateCP.equals(maxBillDate))) {
            if ((maxBillDate.after(firstDateCP) || maxBillDate.equals(firstDateCP)) && (maxBillDate.before(lastDateCP) || maxBillDate.equals(lastDateCP))) {
                return maxBillDate;
            }
            if (maxBillDate.before(firstDateCP)) {
                return lastDateCP;
            }
        }
        if ((sysDate.after(maxBillDate) || sysDate.equals(maxBillDate)) && (maxBillDate.after(lastDateCP) || maxBillDate.equals(lastDateCP))) {
            return maxBillDate;
        }
        return sysDate;
    }

    public static boolean hasSubmitProcDef(Context ctx, BOSObjectType billBosType) throws BOSException {
        IEnactmentService service;
        UserInfo currentUserInfo;
        if (ctx == null) {
            currentUserInfo = SysContext.getSysContext().getCurrentUserInfo();
            service = EnactmentServiceFactory.createRemoteEnactService();
        } else {
            service = EnactmentServiceFactory.createEnactService((Context)ctx);
            currentUserInfo = ContextUtil.getCurrentUserInfo((Context)ctx);
        }
        String procDefID = service.findSubmitProcDef(billBosType, currentUserInfo.getId().toString());
        return procDefID != null;
    }

    public static boolean isAllInWFOrNotAll(List idList) throws BOSException, EASBizException {
        HashSet idSet = new HashSet();
        Iterator it = idList.iterator();
        while (it.hasNext()) {
            idSet.add(it.next());
        }
        return ArApBillHelper.isAllInWFOrNotAll(idSet);
    }

    public static boolean isAllInWFOrNotAll(Set idSet) throws BOSException, EASBizException {
        String[] idArray = idSet.toArray(new String[idSet.size()]);
        Map result = ArApBillFacadeFactory.getRemoteInstance().checkBizObjInWfProcess(idArray);
        boolean firstIsInWF = (Boolean)result.get(idArray[0]);
        for (int i = 1; i < idArray.length; ++i) {
            boolean isInWF = (Boolean)result.get(idArray[i]);
            if (firstIsInWF == isInWF) continue;
            throw new OtherBillBizException(OtherBillBizException.NOT_ALL_EXIST);
        }
        return firstIsInWF;
    }

    public static boolean isInWF(String billId) throws EASBizException, BOSException {
        Map result = ArApBillFacadeFactory.getRemoteInstance().checkBizObjInWfProcess(new String[]{billId});
        return (Boolean)result.get(billId);
    }

    public static BOTMappingCollection getBOTFullMappingCollection(Context ctx, BOTMappingCollection botMappingCol) throws BOSException, EASBizException {
        if (null == botMappingCol || botMappingCol.size() == 0) {
            return null;
        }
        IBOTMapping botMapping = null;
        botMapping = ctx == null ? BOTMappingFactory.getRemoteInstance() : BOTMappingFactory.getLocalInstance((Context)ctx);
        HashSet<String> idSet = new HashSet<String>();
        for (int i = 0; i < botMappingCol.size(); ++i) {
            idSet.add(botMappingCol.get(i).getId().toString());
        }
        EntityViewInfo ev = new EntityViewInfo();
        ev.getSelector().add("*");
        ev.getSelector().add("rules.ruleSegments.*");
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", idSet, CompareType.INCLUDE));
        ev.setFilter(filter);
        return botMapping.getBOTMappingCollection(ev);
    }

    public static BOTMappingInfo getFirstBotpWithSpecifyProp(Context ctx, BOTMappingCollection botMappingCollection, String propName, String propValue, boolean isMatch) throws BOSException, EASBizException {
        BOTMappingInfo botMapInfo = null;
        if (null == botMappingCollection || botMappingCollection.size() == 0) {
            return botMapInfo;
        }
        BOTMappingCollection botMappingCol = ArApBillHelper.getBOTFullMappingCollection(ctx, botMappingCollection);
        if (null != botMappingCol && botMappingCol.size() > 0) {
            for (int i = 0; i < botMappingCol.size(); ++i) {
                botMapInfo = botMappingCol.get(i);
                if (isMatch) {
                    if (!ArApBillHelper.isBotpPropertyMatch(botMapInfo, propName, propValue)) continue;
                    return botMapInfo;
                }
                if (ArApBillHelper.isBotpPropertyMatch(botMapInfo, propName, propValue)) continue;
                return botMapInfo;
            }
        }
        return botMapInfo;
    }

    public static boolean isBotpPropertyMatch(BOTMappingInfo botMapInfo, String propName, String propValue) throws BOSException, EASBizException {
        BOTRuleCollection rules = botMapInfo.getRules();
        if (rules == null || rules.size() == 0) {
            return false;
        }
        int n = rules.size();
        for (int i = 0; i < n; ++i) {
            BOTRuleInfo ruleInfo = rules.get(i);
            BOTRuleSegmentCollection segs = ruleInfo.getRuleSegments();
            if (segs == null || segs.size() <= 0) continue;
            boolean haspropName = false;
            int m = segs.size();
            for (int j = 0; j < m; ++j) {
                BOTRuleSegmentInfo ruleSegInfo = segs.get(j);
                if (!propName.equalsIgnoreCase(ruleSegInfo.getDestPropertyName())) continue;
                haspropName = true;
                String exprVal = ruleSegInfo.getExpression();
                if (!StringUtils.isEmpty((String)exprVal)) {
                    return propValue.equalsIgnoreCase(exprVal.trim());
                }
                String srcExpr = ruleSegInfo.getSrcPropertyName();
                if (srcExpr != null && !srcExpr.startsWith("__src.")) {
                    srcExpr = "__src." + srcExpr;
                }
                return ("__src." + propValue).equalsIgnoreCase(srcExpr);
            }
            if (haspropName || !StringUtils.isEmpty((String)propValue)) continue;
            return true;
        }
        return false;
    }

    public static void calculate(Context ctx, ArApBillBaseInfo info, ArApSysParamInfo cache) throws EASBizException, BOSException {
        logger.info((Object)(ResourceBase.getString((String)"com.kingdee.eas.fi.arap.ARAPAutoGenerateResource", (String)"155_ArApBillHelper", (Locale)LocaleUtils.locale_l2) + info.getNumber() + "_" + info.getAmountLocal()));
        if (info != null && ArApBillHelper.isEmptyOrZero(info.getAmountLocal()) && info.getCompany() != null && info.getEntries() != null && info.getEntries().size() > 0 && info != null && info.isReqCalculate4Srv() && !ArApBillHelper.isNullEntry(info)) {
            if (!BillRelationOptionEnum.BRINGIN.equals((Object)info.getBillRelationOption()) && !info.isIsImportBill()) {
                IArApBillFacade iBillFacade = ctx == null ? ArApBillFacadeFactory.getRemoteInstance() : ArApBillFacadeFactory.getLocalInstance((Context)ctx);
                iBillFacade.reAdmissionPrices((IObjectValue)info, (IObjectCollection)info.getEntries());
            }
            ArApBillHelper.calculate4Botp(ctx, info, cache);
        }
    }

    public static void calcByInnerPrice(Context ctx, ArApBillBaseInfo info) throws EASBizException, BOSException {
        if (info == null || info.get("InnerPrice") == null) {
            return;
        }
        if (PriceSourceEnum.PriceFromBOTP == info.getPriceSource()) {
            return;
        }
        if (info.get("InnerPrice") instanceof PurInnerDealPriceCollection) {
            PurInnerDealPriceCollection purInnerColl = (PurInnerDealPriceCollection)info.get("InnerPrice");
            ArApBillHelper.setPriceByPurInnerPrice(info, purInnerColl);
            ArApBillHelper.calc4InnerBiz(ctx, info);
        }
    }

    public static void calc4InnerBiz(Context ctx, ArApBillBaseInfo info) throws EASBizException, BOSException {
        if (ArApBillHelper.isOnlyId((DataBaseInfo)info.getCompany()) || ArApBillHelper.isOnlyId((DataBaseInfo)info.getCompany().getBaseCurrency()) || ArApBillHelper.isNull((DataBaseInfo)info.getCompany().getBaseCurrency())) {
            CompanyOrgUnitInfo companyInfo = ArApBillHelper.getCompanyOrgUnitInfo(ctx, info.getCompany().getId(), info.getCompany());
            info.setCompany(companyInfo);
        }
        if (info.getCurrency() == null) {
            throw new OtherBillBizException(OtherBillBizException.COMMON, new Object[]{"Currency of bill [" + info.getNumber() + "] can't be null."});
        }
        if (ArApBillHelper.isOnlyId((DataBaseInfo)info.getCurrency()) || info.getCurrency().getPrecision() == 0 || null == info.getCurrency().get("precision")) {
            ICurrency iCurrency;
            ObjectUuidPK currencyPK = new ObjectUuidPK(info.getCurrency().getId());
            iCurrency = ctx == null ? (iCurrency = CurrencyFactory.getRemoteInstance()) : CurrencyFactory.getLocalInstance((Context)ctx);
            CurrencyInfo currencyInfo = iCurrency.getCurrencyInfo((IObjectPK)currencyPK);
            info.setCurrency(currencyInfo);
        }
        boolean isDirectExchange = true;
        ExchangeRateInfo rateInfo = BaseDataUtil.getExchangeRate(ctx, info.getCompany(), info.getCurrency(), info.getBillDate());
        if (rateInfo != null && rateInfo.getExchangeAux() != null && ConvertModeEnum.DIRECTEXCHANGERATE.equals((Object)rateInfo.getExchangeAux().getConvertMode())) {
            isDirectExchange = true;
        } else if (rateInfo != null && rateInfo.getExchangeAux() != null && ConvertModeEnum.INDIRECTEXCHANGERATE.equals((Object)rateInfo.getExchangeAux().getConvertMode())) {
            isDirectExchange = false;
        }
        CalculateInfoCondition condition = new CalculateInfoCondition();
        condition.setCurrencyPrecision(info.getCurrency().getPrecision());
        condition.setBaseCurrencyPrecision(info.getCompany().getBaseCurrency().getPrecision());
        condition.setPriceWithoutTax(info.isIsPriceWithoutTax());
        condition.setInTax(info.isIsInTax());
        condition.setTransBill(info.isIsTransBill());
        condition.setAllowanceBill(info.isIsAllowanceBill());
        condition.setSplit(info.isIsSplitBill());
        int ratePrecision = ArApParamHelper.getDiscountRatePrecision(ctx);
        condition.setRatePrecision(ratePrecision);
        condition.setNeedCalQty(false);
        condition.setDirectExchangeRate(isDirectExchange);
        condition.setExchangeRate(info.getExchangeRate());
        condition.setEntries(info.getEntries());
        condition.setSourceBillType(info.getSourceBillType());
        condition.setInitializeBill(info.isIsInitializeBill());
        condition.setDebitAdjust(false);
        for (int i = 0; i < info.getEntries().size(); ++i) {
            condition.setRowIndex(i);
            ArApBillEntryBaseInfo entryInfo = (ArApBillEntryBaseInfo)info.getEntries().getObject(i);
            if (entryInfo.getPrice() == null && entryInfo.getTaxPrice() == null) {
                condition.setRecPayAmountChanged(info.isIsInTax());
                condition.setAmountChanged(!info.isIsInTax());
            } else {
                condition.setTaxPriceChanged(info.isIsInTax());
                condition.setPriceChanged(!info.isIsInTax());
            }
            condition.setMaterialBill(entryInfo.getMaterial() != null);
            condition.setPresent(entryInfo.isIsPresent());
            if (entryInfo.getDiscountAmount() != null && entryInfo.getDiscountAmount().compareTo(ZERO) != 0 && entryInfo.getQuantity().compareTo(ZERO) != 0 && (entryInfo.getDiscountRate() == null || entryInfo.getDiscountRate() == ZERO)) {
                condition.setDiscountAmountChanged(true);
            } else {
                condition.setDiscountAmountChanged(false);
            }
            ArApBillInfoCalculate bizCal = null;
            if (ArApConstants.AR_OBILL_TYPE.equals((Object)info.getBOSType())) {
                bizCal = new ArBillInfoCalculate(ctx, condition);
                condition.setAR(true);
            } else {
                bizCal = new ApBillInfoCalculate(ctx, condition);
                condition.setAR(false);
            }
            bizCal.execute(condition);
        }
        info.sumEntry();
        ArApBillHelper.generatePlan(ctx, info);
    }

    public static PurInnerDealPriceCollection getPurInnerDealPrice(Context ctx, ArApBillBaseInfo srcInfo) throws EASBizException, BOSException {
        if (srcInfo == null || srcInfo.getCompany() == null) {
            return null;
        }
        Set<String> coreEntryIds = ArApBillHelper.getCoreEntryIdSet(srcInfo);
        if (coreEntryIds == null || coreEntryIds.size() == 0) {
            return null;
        }
        return PurInnerDealPriceFactory.getLocalInstance((Context)ctx).getInnerDealPrice(coreEntryIds, "supCompanyOrg.id", srcInfo.getCompany().getId().toString());
    }

    public static Set<String> getCoreEntryIdSet(ArApBillBaseInfo srcInfo) {
        if (srcInfo == null) {
            return null;
        }
        ArApBillEntryBaseInfo entryInfo = null;
        HashSet<String> ids = new HashSet<String>();
        int size = srcInfo.getEntries().size();
        for (int i = 0; i < size; ++i) {
            entryInfo = (ArApBillEntryBaseInfo)srcInfo.getEntries().getObject(i);
            if (entryInfo == null || StringUtils.isEmpty((String)entryInfo.getCoreBillEntryId())) continue;
            ids.add(entryInfo.getCoreBillEntryId());
        }
        return ids;
    }

    public static void setPriceByPurInnerPrice(ArApBillBaseInfo info, PurInnerDealPriceCollection purInnerColl) {
        if (info == null || purInnerColl == null || purInnerColl.size() == 0) {
            return;
        }
        Map<String, PurInnerDealPriceInfo> priceMap = ArApBillHelper.mapInnerDealPrice(purInnerColl);
        if (priceMap == null || priceMap.size() == 0) {
            return;
        }
        ArApBillEntryBaseInfo entryInfo = (ArApBillEntryBaseInfo)info.getEntries().getObject(0);
        PurInnerDealPriceInfo priceInfo = priceMap.get(entryInfo.getCoreBillEntryId());
        if (priceInfo != null) {
            info.setCurrency(priceInfo.getCurrency());
            info.setExchangeRate(priceInfo.getExchangeRate());
        }
        ArApBillEntryBaseCollection entryColl = new ArApBillEntryBaseCollection();
        int size = info.getEntries().size();
        for (int i = 0; i < size; ++i) {
            entryInfo = (ArApBillEntryBaseInfo)info.getEntries().getObject(i);
            if (entryInfo == null || StringUtils.isEmpty((String)entryInfo.getCoreBillEntryId()) || !priceMap.containsKey(entryInfo.getCoreBillEntryId())) continue;
            priceInfo = priceMap.get(entryInfo.getCoreBillEntryId());
            if (priceInfo.getPrice() != null) {
                entryInfo.setPrice(priceInfo.getPrice());
            }
            if (priceInfo.getDiscountMode() != null) {
                entryInfo.setDiscountType(priceInfo.getDiscountMode());
            }
            if (priceInfo.getDiscount() != null) {
                entryInfo.setDiscountRate(priceInfo.getDiscount());
            }
            if (priceInfo.getTaxRate() != null) {
                entryInfo.setTaxRate(priceInfo.getTaxRate());
            }
            if (priceInfo.getTaxPrice() != null) {
                entryInfo.setTaxPrice(priceInfo.getTaxPrice());
            }
            entryColl.add(entryInfo);
        }
        info.getEntries().clear();
        info.getEntries().addObjectCollection((IObjectCollection)entryColl);
    }

    public static Map<String, PurInnerDealPriceInfo> mapInnerDealPrice(PurInnerDealPriceCollection coll) {
        if (coll != null && coll.size() > 0) {
            PurInnerDealPriceInfo priceInfo = null;
            HashMap<String, PurInnerDealPriceInfo> map = new HashMap<String, PurInnerDealPriceInfo>();
            int size = coll.size();
            for (int i = 0; i < size; ++i) {
                priceInfo = coll.get(i);
                map.put(priceInfo.getPurOrderEntry().getId().toString(), priceInfo);
            }
            return map;
        }
        return null;
    }

    private static boolean isNullEntry(ArApBillBaseInfo info) {
        if (info == null || info.getEntries() == null || info.getEntries().size() <= 0) {
            return true;
        }
        MaterialInfo materialInfos = null;
        ExpenseTypeInfo expenseItems = null;
        RowTypeInfo rowType = null;
        if (info instanceof com.kingdee.eas.fi.ap.OtherBillInfo && 202 == info.getBillTypeEnum().getValue() || info instanceof OtherBillInfo && 102 == info.getBillTypeEnum().getValue()) {
            for (int i = 0; i < info.getEntries().size(); ++i) {
                ArApBillEntryBaseInfo entryInfo = (ArApBillEntryBaseInfo)info.getEntries().getObject(i);
                materialInfos = entryInfo.getMaterial();
                rowType = entryInfo.getRowType();
                if (materialInfos != null) {
                    return false;
                }
                if (rowType == null || entryInfo.getMaterialName() == null) continue;
                return false;
            }
        } else {
            for (int i = 0; i < info.getEntries().size(); ++i) {
                ArApBillEntryBaseInfo entryInfo = (ArApBillEntryBaseInfo)info.getEntries().getObject(i);
                expenseItems = entryInfo.getExpenseItem();
                materialInfos = entryInfo.getMaterial();
                if (expenseItems == null && materialInfos == null) continue;
                return false;
            }
        }
        return true;
    }

    public static void calculate4Botp(Context ctx, ArApBillBaseInfo info, ArApSysParamInfo cache) throws EASBizException, BOSException {
        boolean isMatchGenerate;
        if (ArApBillHelper.isOnlyId((DataBaseInfo)info.getCompany()) || ArApBillHelper.isOnlyId((DataBaseInfo)info.getCompany().getBaseCurrency()) || ArApBillHelper.isNull((DataBaseInfo)info.getCompany().getBaseCurrency())) {
            CompanyOrgUnitInfo companyInfo = ArApBillHelper.getCompanyOrgUnitInfo(ctx, info.getCompany().getId(), info.getCompany());
            info.setCompany(companyInfo);
        }
        if (info.getCurrency() == null) {
            info.setCurrency(info.getCompany().getBaseCurrency());
        }
        if (ArApBillHelper.isOnlyId((DataBaseInfo)info.getCurrency()) || info.getCurrency().getPrecision() == 0 || null == info.getCurrency().get("precision")) {
            ICurrency iCurrency;
            ObjectUuidPK currencyPK = new ObjectUuidPK(info.getCurrency().getId());
            iCurrency = ctx == null ? (iCurrency = CurrencyFactory.getRemoteInstance()) : CurrencyFactory.getLocalInstance((Context)ctx);
            CurrencyInfo currencyInfo = iCurrency.getCurrencyInfo((IObjectPK)currencyPK);
            info.setCurrency(currencyInfo);
        }
        int precision = info.getCurrency().getPrecision();
        boolean isBaseCurrency = ArApBillHelper.idEquals((CoreBaseInfo)info.getCurrency(), (CoreBaseInfo)info.getCompany().getBaseCurrency());
        BigDecimal lastExchangeRate = ONE;
        boolean isDirectExchange = true;
        ExchangeRateInfo rateInfo = ctx == null ? com.kingdee.eas.fi.ar.client.util.BaseDataUtil.getExchangeRate((CompanyOrgUnitInfo)info.getCompany(), (CurrencyInfo)info.getCurrency(), (Date)info.getBillDate()) : BaseDataUtil.getExchangeRate(ctx, info.getCompany(), info.getCurrency(), info.getBillDate());
        if (rateInfo != null && rateInfo.getExchangeAux() != null && ConvertModeEnum.DIRECTEXCHANGERATE.equals((Object)rateInfo.getExchangeAux().getConvertMode())) {
            isDirectExchange = true;
        } else if (rateInfo != null && rateInfo.getExchangeAux() != null && ConvertModeEnum.INDIRECTEXCHANGERATE.equals((Object)rateInfo.getExchangeAux().getConvertMode())) {
            isDirectExchange = false;
        }
        if (info.getExchangeRate() == null) {
            if (info.getBillDate() == null) {
                info.setBillDate(new Date());
            }
            if (isBaseCurrency) {
                precision = 0;
                lastExchangeRate = ONE;
            } else if (rateInfo != null) {
                precision = rateInfo.getPrecision();
                lastExchangeRate = rateInfo.getConvertRate();
                if (rateInfo.getExchangeAux() != null) {
                    precision = rateInfo.getExchangeAux().getPrecision();
                }
            }
            lastExchangeRate = lastExchangeRate.setScale(precision, 4);
            info.setExchangeRate(lastExchangeRate);
        }
        boolean isDebitAdjust = false;
        if (info instanceof com.kingdee.eas.fi.ap.OtherBillInfo && 204 == info.getBillTypeEnum().getValue() || info instanceof OtherBillInfo && 104 == info.getBillTypeEnum().getValue()) {
            isDebitAdjust = true;
        }
        CalculateInfoCondition condition = new CalculateInfoCondition();
        condition.setCurrencyPrecision(info.getCurrency().getPrecision());
        condition.setBaseCurrencyPrecision(info.getCompany().getBaseCurrency().getPrecision());
        condition.setPriceWithoutTax(info.isIsPriceWithoutTax());
        condition.setInTax(info.isIsInTax());
        condition.setTransBill(info.isIsTransBill());
        condition.setAllowanceBill(info.isIsAllowanceBill());
        condition.setSplit(info.isIsSplitBill());
        int ratePrecision = cache == null ? ArApParamHelper.getDiscountRatePrecision(ctx) : cache.getRatePrecision();
        condition.setRatePrecision(ratePrecision);
        condition.setNeedCalQty(true);
        condition.setDirectExchangeRate(isDirectExchange);
        condition.setExchangeRate(info.getExchangeRate());
        condition.setEntries(info.getEntries());
        condition.setSourceBillType(info.getSourceBillType());
        condition.setInitializeBill(info.isIsInitializeBill());
        condition.setDebitAdjust(isDebitAdjust);
        SCMEntryDataVO resultVO = ArApBillHelper.getSCMEntryDataVO(ctx, info);
        condition.getMapObject().put("SCMEntryDataVO", resultVO);
        HashMap entryBaseQtyMap = new HashMap();
        String sourceBillId = null == info.getEntries().getObject(0).get("sourcebillid") ? null : info.getEntries().getObject(0).get("sourcebillid").toString();
        boolean bl = isMatchGenerate = null == info.get("isMatchGenerate") ? false : new Boolean(info.get("isMatchGenerate").toString());
        if (!(isMatchGenerate || info.getBillRelationOption() == null || BillRelationOptionEnum.BRINGIN.getValue() != info.getBillRelationOption().getValue() || VerificateBillTypeEnum.StockTransferBill.equals((Object)info.getSourceBillType()) || StringUtils.isEmpty((String)sourceBillId) || BOSUuid.read((String)sourceBillId).getType().toString().equals(AR_OTHERBILL_BOSTYPE) || BOSUuid.read((String)sourceBillId).getType().toString().equals(AP_OTHERBILL_BOSTYPE))) {
            ArApBillHelper.getSourceBillEntryBaseQtyNew(ctx, info, entryBaseQtyMap);
        }
        String bizAccountOutBillBosType = "92F938DD";
        String bizAccountBillBosType = "4A44F49F";
        Boolean isSourceIsBizAccountBill = false;
        if (sourceBillId != null && (BOSUuid.read((String)sourceBillId).getType().toString().equals(bizAccountBillBosType) || BOSUuid.read((String)sourceBillId).getType().toString().equals(bizAccountOutBillBosType))) {
            isSourceIsBizAccountBill = true;
        }
        BigDecimal baseQty = new BigDecimal("0.00");
        boolean ischeckBotp = false;
        Boolean quantityToAssistQty = ArApBillHelper.queryCustomParam(ctx, info, ArApConstants.QUANTITY_TO_ASSIST_QTY);
        boolean isAR = info.getBOSType().toString().equals(OtherBillInfo.getBosType().toString());
        Map<String, BigDecimal> sourceUnReverseQtyMap = ArApBillHelper.getSourceUnReverseQtyMap(ctx, info, sourceBillId, isAR);
        for (int i = 0; i < info.getEntries().size(); ++i) {
            condition.setRowIndex(i);
            ArApBillEntryBaseInfo entryInfo = (ArApBillEntryBaseInfo)info.getEntries().getObject(i);
            condition.setNeedCalAsstQty(ArApBillHelper.isNeedCalAssistQty(ctx, entryInfo, quantityToAssistQty));
            if (entryInfo.getPrice() == null && entryInfo.getTaxPrice() == null) {
                condition.setRecPayAmountChanged(info.isIsInTax());
                condition.setAmountChanged(!info.isIsInTax());
            } else {
                condition.setTaxPriceChanged(info.isIsInTax());
                condition.setPriceChanged(!info.isIsInTax());
            }
            if (entryInfo.get("invoiceEntryId") != null && !StringUtils.isEmpty((String)((String)entryInfo.get("invoiceEntryId")))) continue;
            condition.setMaterialBill(entryInfo.getMaterial() != null);
            condition.setPresent(entryInfo.isIsPresent());
            boolean isBizBillAllReversed = ArApBillHelper.getBizBillAllReversed(sourceUnReverseQtyMap, entryInfo, info.isIsBizBill());
            condition.setBillRelation(false);
            if (ctx != null && info.getBillRelationOption() != null && BillRelationOptionEnum.BRINGIN.getValue() == info.getBillRelationOption().getValue() && !VerificateBillTypeEnum.StockTransferBill.equals((Object)info.getSourceBillType())) {
                if (entryBaseQtyMap != null && entryBaseQtyMap.containsKey(entryInfo.getSourceBillEntryId())) {
                    baseQty = (BigDecimal)entryBaseQtyMap.get(entryInfo.getSourceBillEntryId());
                    if (baseQty.compareTo(entryInfo.getBaseQty()) == 0) {
                        if (!ischeckBotp) {
                            ArApBillHelper.checkBotp(ctx, info);
                            ischeckBotp = true;
                        }
                        if (entryBaseQtyMap.get("UnitMap") != null && entryInfo.getMeasureUnit().getId() != null && entryInfo.getMeasureUnit().getId().toString().equals(((Map)entryBaseQtyMap.get("UnitMap")).get(entryInfo.getSourceBillEntryId()))) {
                            condition.setNeedCalQty(false);
                        }
                        condition.setBillRelation(true);
                    }
                } else if (isSourceIsBizAccountBill.booleanValue()) {
                    condition.setBillRelation(true);
                }
            }
            if (isBizBillAllReversed || entryInfo.get("IS_LAST_REVERSE_ENTRY") != null && ((Boolean)entryInfo.get("IS_LAST_REVERSE_ENTRY")).booleanValue()) {
                condition.setBillRelation(true);
            }
            if (entryInfo.getDiscountAmount() != null && entryInfo.getDiscountAmount().compareTo(ZERO) != 0 && entryInfo.getQuantity() != null && entryInfo.getQuantity().compareTo(ZERO) != 0 && (entryInfo.getDiscountRate() == null || entryInfo.getDiscountRate().signum() == 0)) {
                condition.setDiscountAmountChanged(true);
            } else {
                condition.setDiscountAmountChanged(false);
            }
            ArApBillInfoCalculate bizCal = null;
            if (ArApConstants.AR_OBILL_TYPE.equals((Object)info.getBOSType())) {
                bizCal = new ArBillInfoCalculate(ctx, condition);
                condition.setAR(true);
            } else if (ArApConstants.AP_OBILL_TYPE.equals((Object)info.getBOSType())) {
                bizCal = new ApBillInfoCalculate(ctx, condition);
                condition.setAR(false);
            } else if (ArApConstants.AR_INCOMECONFIMBILL_TYPE.equals((Object)info.getBOSType())) {
                bizCal = new IncomeConfirmBillInfoCalculate(ctx, condition);
                condition.setAR(true);
            } else {
                return;
            }
            if (entryInfo.getMaterial() != null && entryInfo.getBaseUnit() == null) {
                MaterialInfo materialInfo = entryInfo.getMaterial();
                ((ArApBillEntryBaseInfo)bizCal.entryCol.getObject(condition.getRowIndex())).setBaseUnit(materialInfo.getBaseUnit());
            }
            if (info.isIsTransBill() || info.isIsAllowanceBill()) {
                bizCal.execute4Trans(condition);
                continue;
            }
            if (info.isIsSplitBill()) {
                bizCal.execute4Split(condition);
                continue;
            }
            if (info.isIsBizBill() && null != entryInfo.getRecievePayAmount() && entryInfo.getRecievePayAmountLocal().signum() != 0 && !info.isIsImportBill()) {
                bizCal.execute4BizBill(condition);
                continue;
            }
            if (entryInfo.isIsQtyZero()) {
                condition.setEntryQtyZero(entryInfo.isIsQtyZero());
                condition.setNeedCalAsstQty(false);
                condition.setNeedCalQty(false);
                bizCal.execute4EntryQtyZero(condition);
                continue;
            }
            if (isMatchGenerate) {
                condition.setRecPayAmountChanged(true);
                condition.setTaxPriceChanged(false);
                condition.setNeedCalQty(false);
                condition.setNeedCalBaseQty(true);
                bizCal.execute(condition);
                continue;
            }
            bizCal.execute(condition);
        }
        info.sumEntry();
        boolean isArApBill = info instanceof com.kingdee.eas.fi.ap.OtherBillInfo || info instanceof OtherBillInfo;
        boolean isproxybill = false;
        if (VerificateBillTypeEnum.ApAgentBizBill.equals((Object)info.getSourceBillType()) || VerificateBillTypeEnum.ArAgentBizBill.equals((Object)info.getSourceBillType())) {
            isproxybill = true;
        }
        if (isArApBill && !info.isIsSplitBill() && !isproxybill) {
            ArApBillHelper.generatePlan(ctx, info);
        }
    }

    private static boolean isNeedCalAssistQty(Context ctx, ArApBillEntryBaseInfo entryInfo, Boolean isQtyToAssistQty) throws BOSException {
        return entryInfo.getAssistQty() == null && isQtyToAssistQty != false && entryInfo.getMaterial() != null && entryInfo.getMeasureUnit() != null && entryInfo.getAssistUnit() != null;
    }

    public static boolean queryCustomParam(Context ctx, ArApBillBaseInfo info, String configKey) throws BOSException {
        String billClassName;
        boolean isEnable = false;
        if (ArApConstants.AR_OBILL_TYPE.equals((Object)info.getBOSType())) {
            billClassName = "com.kingdee.eas.fi.ar.client.OtherBillEditUI";
        } else if (ArApConstants.AP_OBILL_TYPE.equals((Object)info.getBOSType())) {
            billClassName = "com.kingdee.eas.fi.ap.client.OtherBillEditUI";
        } else if (ArApConstants.AR_INCOMECONFIMBILL_TYPE.equals((Object)info.getBOSType())) {
            billClassName = "com.kingdee.eas.fi.ar.client.IncomeConfimEditUI";
        } else {
            return isEnable;
        }
        SMSDBillConfigInfo smsdBillConfigInfo = ArApBillHelper.queryBillEditSMSDBillConfig(ctx, billClassName, configKey);
        if (smsdBillConfigInfo != null) {
            String value = smsdBillConfigInfo.getConfigValue();
            isEnable = "1".equals(value);
        }
        return isEnable;
    }

    public static void saveCustomParams(Context ctx, String uiName, String configKey, String isSelected) throws BOSException, EASBizException {
        UserInfo currentUserInfo;
        ISMSDBillConfig iSMSDBillConfig;
        if (ctx == null) {
            iSMSDBillConfig = SMSDBillConfigFactory.getRemoteInstance();
            currentUserInfo = SysContext.getSysContext().getCurrentUserInfo();
        } else {
            iSMSDBillConfig = SMSDBillConfigFactory.getLocalInstance((Context)ctx);
            currentUserInfo = ContextUtil.getCurrentUserInfo((Context)ctx);
        }
        SMSDBillConfigInfo smsdBillConfigInfo = ArApBillHelper.queryBillEditSMSDBillConfig(ctx, uiName, configKey);
        SMSDBillConfigInfo aSMSDBillConfig = null == smsdBillConfigInfo ? new SMSDBillConfigInfo() : smsdBillConfigInfo;
        aSMSDBillConfig.setUserID(currentUserInfo.getId());
        aSMSDBillConfig.setBillClassName(uiName);
        aSMSDBillConfig.setConfigType(configKey);
        aSMSDBillConfig.setConfigValue(isSelected);
        iSMSDBillConfig.submit((CoreBaseInfo)aSMSDBillConfig);
    }

    private static SMSDBillConfigInfo queryBillEditSMSDBillConfig(Context ctx, String uiName, String configKey) throws BOSException {
        UserInfo currentUserInfo;
        ISMSDBillConfig iSMSDBillConfig;
        if (ctx == null) {
            iSMSDBillConfig = SMSDBillConfigFactory.getRemoteInstance();
            currentUserInfo = SysContext.getSysContext().getCurrentUserInfo();
        } else {
            iSMSDBillConfig = SMSDBillConfigFactory.getLocalInstance((Context)ctx);
            currentUserInfo = ContextUtil.getCurrentUserInfo((Context)ctx);
        }
        FilterInfo filter = new FilterInfo();
        FilterItemInfo billClassNameFilter = new FilterItemInfo("billClassName", (Object)uiName, CompareType.EQUALS);
        FilterItemInfo userIDFilter = new FilterItemInfo("userID", (Object)currentUserInfo.getId(), CompareType.EQUALS);
        FilterItemInfo configTypeFilter = new FilterItemInfo("configType", (Object)configKey, CompareType.EQUALS);
        filter.getFilterItems().add(billClassNameFilter);
        filter.getFilterItems().add(userIDFilter);
        filter.getFilterItems().add(configTypeFilter);
        EntityViewInfo ev = new EntityViewInfo();
        ev.setFilter(filter);
        ev.setSelector(SCMSelectorFactory.getSMSDBillConfigSelector());
        SMSDBillConfigCollection billConfigCollection = iSMSDBillConfig.getSMSDBillConfigCollection(ev);
        SMSDBillConfigInfo sMSDBillConfig = null;
        if (billConfigCollection != null && billConfigCollection.size() > 0) {
            sMSDBillConfig = billConfigCollection.get(0);
        }
        return sMSDBillConfig;
    }

    public static Map queryBillEditConfig(Context ctx, boolean isAR) throws BOSException {
        UserInfo userInfo;
        ISMSDBillConfig iSMSDBillConfig;
        if (ctx == null) {
            iSMSDBillConfig = SMSDBillConfigFactory.getRemoteInstance();
            userInfo = SysContext.getSysContext().getCurrentUserInfo();
        } else {
            iSMSDBillConfig = SMSDBillConfigFactory.getLocalInstance((Context)ctx);
            userInfo = ContextUtil.getCurrentUserInfo((Context)ctx);
        }
        String billClassName = isAR ? "com.kingdee.eas.fi.ar.client.OtherBillEditUI" : "com.kingdee.eas.fi.ap.client.OtherBillEditUI";
        FilterInfo filter = new FilterInfo();
        FilterItemInfo billClassNameFilter = new FilterItemInfo("billClassName", (Object)billClassName, CompareType.EQUALS);
        FilterItemInfo userIDFilter = new FilterItemInfo("userID", (Object)userInfo.getId().toString(), CompareType.EQUALS);
        filter.getFilterItems().add(billClassNameFilter);
        filter.getFilterItems().add(userIDFilter);
        EntityViewInfo ev = new EntityViewInfo();
        ev.setFilter(filter);
        SMSDBillConfigCollection billConfigCollection = iSMSDBillConfig.getSMSDBillConfigCollection(ev);
        HashMap<String, String> resultMap = new HashMap<String, String>(billConfigCollection.size());
        int size = billConfigCollection.size();
        for (int i = 0; i < size; ++i) {
            if (billConfigCollection.get(i) == null) continue;
            resultMap.put(billConfigCollection.get(i).getConfigType(), billConfigCollection.get(i).getConfigValue());
        }
        return resultMap;
    }

    public static void generatePlan(Context ctx, ArApBillBaseInfo info) throws EASBizException, BOSException {
        AbstractObjectCollection planCol = info.getPlans();
        planCol.clear();
        if (info.getPayCondition() != null) {
            PayConditionInfo payConditionInfo = info.getPayCondition();
            ObjectUuidPK pcPK = new ObjectUuidPK(payConditionInfo.getId());
            IPayCondition iPayCondition = null;
            iPayCondition = ctx == null ? PayConditionFactory.getRemoteInstance() : PayConditionFactory.getLocalInstance((Context)ctx);
            payConditionInfo = iPayCondition.getPayConditionInfo((IObjectPK)pcPK);
            AbstractObjectCollection plans = PlanHelper.generatePlanCollection(ctx, info, payConditionInfo);
            planCol.addObjectCollection((IObjectCollection)plans);
        } else {
            planCol.addObject((IObjectValue)ArApBillHelper.createDefaultPlanInfo(ctx, info));
        }
    }

    public static ArApBillPlanBaseCollection generateArApPlan(Context ctx, ArApBillBaseInfo info) throws EASBizException, BOSException {
        ArApBillPlanBaseCollection planCol = new ArApBillPlanBaseCollection();
        if (info.getPayCondition() != null) {
            PayConditionInfo payConditionInfo = info.getPayCondition();
            ObjectUuidPK pcPK = new ObjectUuidPK(payConditionInfo.getId());
            IPayCondition iPayCondition = null;
            iPayCondition = ctx == null ? PayConditionFactory.getRemoteInstance() : PayConditionFactory.getLocalInstance((Context)ctx);
            payConditionInfo = iPayCondition.getPayConditionInfo((IObjectPK)pcPK);
            AbstractObjectCollection plans = PlanHelper.generatePlanCollection(ctx, info, payConditionInfo);
            planCol.addObjectCollection((IObjectCollection)plans);
        } else {
            planCol.addObject((IObjectValue)ArApBillHelper.createDefaultPlanInfo(ctx, info));
        }
        return planCol;
    }

    public static ArApBillPlanBaseInfo createDefaultPlanInfo(Context ctx, ArApBillBaseInfo info) throws BOSException {
        ArApBillPlanBaseInfo planInfo = null;
        planInfo = ArApConstants.AR_OBILL_TYPE.equals((Object)info.getBOSType()) ? (ctx == null ? OtherBillPlanAgent.create() : (info instanceof OtherBillAgent ? OtherBillPlanAgent.create() : new OtherBillPlanInfo())) : (ctx == null ? com.kingdee.eas.fi.ap.OtherBillPlanAgent.create() : (info instanceof com.kingdee.eas.fi.ap.OtherBillAgent ? com.kingdee.eas.fi.ap.OtherBillPlanAgent.create() : new com.kingdee.eas.fi.ap.OtherBillPlanInfo()));
        planInfo.setRecievePayDate(info.getBillDate());
        planInfo.setRecievePayAmount(info.getAmount());
        planInfo.setRecievePayAmountLocal(info.getAmountLocal());
        planInfo.setVerifyAmount(info.getVerifyAmount());
        planInfo.setVerifyAmountLocal(info.getVerifyAmountLocal());
        planInfo.setUnVerifyAmount(info.getUnVerifyAmount());
        planInfo.setUnVerifyAmountLocal(info.getUnVerifyAmountLocal());
        planInfo.setLockAmount(info.getVerifyAmount());
        planInfo.setLockAmountLoc(info.getVerifyAmountLocal());
        planInfo.setUnLockAmount(info.getUnVerifyAmount());
        planInfo.setUnLockAmountLoc(info.getUnVerifyAmountLocal());
        return planInfo;
    }

    public static Date getBeforeSysDate(PeriodInfo period) {
        Date beforeStartDate = null;
        Calendar cal = Calendar.getInstance();
        cal.setTime(period.getBeginDate());
        cal.add(5, -1);
        beforeStartDate = cal.getTime();
        return beforeStartDate;
    }

    public static Date getBillBizRecPayDate(boolean isInitBill, ArApSysParamInfo cache) {
        Date date = new Date();
        if (isInitBill) {
            date = ArApBillHelper.getBeforeSysDate(cache.getStartPeriod(null));
        } else if (date.before(cache.getCurrentPeriod(null).getBeginDate())) {
            date = cache.getCurrentPeriod(null).getBeginDate();
        }
        return date;
    }

    public static PriceCondition getPriceCondition(Context ctx, CustomerInfo customerInfo, SaleOrgUnitInfo saleOrg, Date billDate, CurrencyInfo currency, CtrlUnitInfo cu, OtherBillentryInfo entryInfo) throws EASBizException, BOSException {
        MaterialInfo tempMaterialInfo = entryInfo.getMaterial();
        if (tempMaterialInfo == null) {
            return null;
        }
        MeasureUnitInfo tempMeasureUnitInfo = entryInfo.getMeasureUnit();
        if (tempMeasureUnitInfo == null) {
            return null;
        }
        BigDecimal qty = entryInfo.getQuantity() == null ? SysConstant.BIGZERO : entryInfo.getQuantity();
        AsstAttrValueInfo assistantAttr = entryInfo.getAssistProperty();
        PriceCondition priceCondition = new PriceCondition();
        priceCondition.setMaterialInfo(tempMaterialInfo);
        priceCondition.setMeasureUnit(tempMeasureUnitInfo.getId().toString());
        priceCondition.setCustomerInfo(customerInfo);
        priceCondition.setOrderQty(qty);
        priceCondition.setSaleOrg(saleOrg);
        priceCondition.setCurDate(billDate);
        priceCondition.setCurrencyInfo(currency);
        priceCondition.setCu(cu);
        priceCondition.setAssiProperty(assistantAttr);
        return priceCondition;
    }

    public static BOTMappingInfo getBotpMappingInfo(Context ctx, int createToFlag, BOSObjectType bosType, String cuId, ArApBillBaseInfo srcInfo) throws BOTPException, Exception {
        IBOTMapping botMapping = null;
        botMapping = ctx == null ? BOTMappingFactory.getRemoteInstance() : BOTMappingFactory.getLocalInstance((Context)ctx);
        BOTMappingCollection botMappingCollection = null;
        EntityViewInfo ev = new EntityViewInfo();
        ev.getSelector().add("*");
        ev.getSelector().add("rules.ruleSegments.*");
        FilterInfo filter = new FilterInfo();
        FilterItemInfo filterItem1 = new FilterItemInfo("SRCENTITYNAME", (Object)bosType.toString());
        FilterItemInfo filterItem2 = new FilterItemInfo("DESTENTITYNAME", (Object)bosType.toString());
        FilterItemInfo filterItem3 = new FilterItemInfo("extRule.isEffected", (Object)new Integer(1));
        FilterItemInfo filterItem4 = new FilterItemInfo("extRule.transMode", (Object)new Integer(10));
        FilterItemInfo filterItem5 = new FilterItemInfo("extRule.transMode", (Object)new Integer(30));
        FilterItemInfo filterItem6 = new FilterItemInfo("defineSys", (Object)new Integer(20));
        FilterItemInfo filterItem7 = new FilterItemInfo("cu.id", (Object)cuId);
        FilterItemInfo filterItem8 = new FilterItemInfo("cu.id", (Object)"00000000-0000-0000-0000-000000000000CCE7AED4");
        filter.getFilterItems().add(filterItem1);
        filter.getFilterItems().add(filterItem2);
        filter.getFilterItems().add(filterItem3);
        filter.getFilterItems().add(filterItem4);
        filter.getFilterItems().add(filterItem5);
        filter.getFilterItems().add(filterItem6);
        filter.getFilterItems().add(filterItem7);
        filter.getFilterItems().add(filterItem8);
        filter.setMaskString("#0 and #1 and #2 and (#3 or #4) and #5 and (#6 or #7)");
        ev.setFilter(filter);
        SorterItemInfo sii1 = new SorterItemInfo("LASTUPDATETIME");
        sii1.setSortType(SortType.DESCEND);
        SorterItemInfo sii2 = new SorterItemInfo("cu.id");
        sii2.setSortType(SortType.DESCEND);
        ev.getSorter().add(sii1);
        ev.getSorter().add(sii2);
        botMappingCollection = botMapping.getBOTMappingCollection(ev);
        for (BOTMappingInfo mappingInfo : botMappingCollection) {
            BotpRuleEvalExecutor evalExecutor = new BotpRuleEvalExecutor(mappingInfo.getRules().get(0).getRuleSegments());
            boolean isTransBill = Boolean.parseBoolean(String.valueOf(evalExecutor.eval("isTransBill", (IObjectValue)srcInfo)));
            boolean isAllowanceBill = Boolean.parseBoolean(String.valueOf(evalExecutor.eval("isAllowanceBill", (IObjectValue)srcInfo)));
            if (!(createToFlag == 1 ? isTransBill && !isAllowanceBill : createToFlag == 2 && !isTransBill && isAllowanceBill)) continue;
            return mappingInfo;
        }
        return null;
    }

    public static BOTMappingInfo getBotpMappingInfo(Context ctx, BOSObjectType bosType, String cuId, String botpName) {
        IBOTMapping botMapping = null;
        try {
            botMapping = ctx == null ? BOTMappingFactory.getRemoteInstance() : BOTMappingFactory.getLocalInstance((Context)ctx);
            BOTMappingCollection botMappingCollection = null;
            EntityViewInfo entityViewInfo = new EntityViewInfo();
            entityViewInfo.getSelector().add("*");
            entityViewInfo.getSelector().add("rules.ruleSegments.*");
            FilterInfo filter = new FilterInfo();
            FilterItemInfo filterItem1 = new FilterItemInfo("SRCENTITYNAME", (Object)bosType.toString());
            FilterItemInfo filterItem2 = new FilterItemInfo("DESTENTITYNAME", (Object)bosType.toString());
            FilterItemInfo filterItem3 = new FilterItemInfo("extRule.isEffected", (Object)new Integer(1));
            FilterItemInfo filterItem4 = new FilterItemInfo("extRule.transMode", (Object)new Integer(10));
            FilterItemInfo filterItem5 = new FilterItemInfo("extRule.transMode", (Object)new Integer(30));
            FilterItemInfo filterItem6 = new FilterItemInfo("defineSys", (Object)new Integer(20));
            FilterItemInfo filterItem7 = new FilterItemInfo("cu.id", (Object)cuId);
            FilterItemInfo filterItem8 = new FilterItemInfo("cu.id", (Object)"00000000-0000-0000-0000-000000000000CCE7AED4");
            filter.getFilterItems().add(filterItem1);
            filter.getFilterItems().add(filterItem2);
            filter.getFilterItems().add(filterItem3);
            filter.getFilterItems().add(filterItem4);
            filter.getFilterItems().add(filterItem5);
            filter.getFilterItems().add(filterItem6);
            filter.getFilterItems().add(filterItem7);
            filter.getFilterItems().add(filterItem8);
            filter.setMaskString("#0 and #1 and #2 and (#3 or #4) and #5 and (#6 or #7)");
            if (botpName != null) {
                FilterItemInfo filterItem9 = new FilterItemInfo("name", (Object)botpName);
                filter.getFilterItems().add(filterItem9);
                filter.setMaskString("#0 and #1 and #2 and (#3 or #4) and #5 and (#6 or #7) and #8");
            }
            entityViewInfo.setFilter(filter);
            SorterItemInfo sii1 = new SorterItemInfo("LASTUPDATETIME");
            sii1.setSortType(SortType.DESCEND);
            SorterItemInfo sii2 = new SorterItemInfo("cu.id");
            sii2.setSortType(SortType.DESCEND);
            entityViewInfo.getSorter().add(sii1);
            entityViewInfo.getSorter().add(sii2);
            botMappingCollection = botMapping.getBOTMappingCollection(entityViewInfo);
            botMappingCollection.size();
            Iterator ite = botMappingCollection.iterator();
            if (ite.hasNext()) {
                BOTMappingInfo mappingInfo = (BOTMappingInfo)ite.next();
                return mappingInfo;
            }
        }
        catch (BOSException e) {
            logger.error((Object)e);
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
        return null;
    }

    public static BOTMappingInfo getBotpMapping4DebitAdjust(Context ctx, BOSObjectType bosType, String cuId, String pk, IObjectValue srcInfo, IntEnum debitAdjustVal) throws BOSException, EASBizException {
        IBOTMapping botMapping = null;
        botMapping = ctx == null ? BOTMappingFactory.getRemoteInstance() : BOTMappingFactory.getLocalInstance((Context)ctx);
        SelectorItemCollection botpSelectors = new SelectorItemCollection();
        botpSelectors.add("id");
        BOTMappingCollection botMappingCollection = botMapping.getMappingCollectionForSelectUseRuleFilter(bosType.toString(), bosType.toString(), DefineSysEnum.BTP, null, new String[]{pk}, new String[]{"entry"}, new ArrayList(), botpSelectors);
        if (botMappingCollection == null || botMappingCollection.size() == 0) {
            throw new BTPException(BTPException.GETMAPPINGINFOERROR);
        }
        Iterator botCollIterator = botMappingCollection.iterator();
        HashSet<String> pkList = new HashSet<String>();
        BOTMappingInfo botInfo = null;
        while (botCollIterator.hasNext()) {
            botInfo = (BOTMappingInfo)botCollIterator.next();
            pkList.add(botInfo.getId().toString());
        }
        EntityViewInfo entityViewInfo = new EntityViewInfo();
        entityViewInfo.getSelector().add("*");
        entityViewInfo.getSelector().add("rules.ruleSegments.*");
        FilterInfo filter = new FilterInfo();
        FilterItemInfo filterItem1 = new FilterItemInfo("id", pkList, CompareType.INCLUDE);
        filter.getFilterItems().add(filterItem1);
        entityViewInfo.setFilter(filter);
        SorterItemInfo sorterItem = new SorterItemInfo("LASTUPDATETIME");
        sorterItem.setSortType(SortType.DESCEND);
        entityViewInfo.getSorter().add(sorterItem);
        botMappingCollection = botMapping.getBOTMappingCollection(entityViewInfo);
        Iterator botCollIteratorCheck = botMappingCollection.iterator();
        while (botCollIteratorCheck.hasNext()) {
            if (ArApBillHelper.checkBotpInfo4DebitAdjust((BOTMappingInfo)botCollIteratorCheck.next(), srcInfo, debitAdjustVal)) continue;
            botCollIteratorCheck.remove();
        }
        if (botMappingCollection.size() == 0) {
            throw new BTPException(BTPException.GETMAPPINGINFOERROR);
        }
        return botMappingCollection.get(0);
    }

    public static boolean checkBotpInfo4DebitAdjust(BOTMappingInfo botInfo, IObjectValue srcInfo, IntEnum debitAdjustVal) {
        BOTRuleInfo ruleInfo = botInfo.getRules().get(0);
        BOTRuleSegmentCollection segmentCol = ruleInfo.getRuleSegments();
        BotpRuleEvalExecutor evalExecutor = new BotpRuleEvalExecutor(segmentCol);
        Object billTypeObj = evalExecutor.eval("billType", srcInfo);
        if (null == billTypeObj) {
            return false;
        }
        boolean isDebitAjust = false;
        if (billTypeObj instanceof String) {
            isDebitAjust = debitAdjustVal.getValue() == new Integer(billTypeObj.toString()).intValue();
        } else if (billTypeObj instanceof IntEnum) {
            isDebitAjust = debitAdjustVal.equals(billTypeObj);
        }
        Boolean isTransBillObj = Boolean.parseBoolean(String.valueOf(evalExecutor.eval("isTransBill", srcInfo)));
        boolean isAllowanceBill = Boolean.parseBoolean(String.valueOf(evalExecutor.eval("isAllowanceBill", srcInfo)));
        return isDebitAjust && isTransBillObj == false && !isAllowanceBill;
    }

    public static BOTMappingInfo getBotpMappingInfo(Context ctx, BOSObjectType srcType, BOSObjectType destType, String cuId) {
        IBOTMapping botMapping = null;
        try {
            botMapping = ctx == null ? BOTMappingFactory.getRemoteInstance() : BOTMappingFactory.getLocalInstance((Context)ctx);
            BOTMappingCollection botMappingCollection = null;
            EntityViewInfo entityViewInfo = new EntityViewInfo();
            entityViewInfo.getSelector().add("*");
            entityViewInfo.getSelector().add("rules.ruleSegments.*");
            FilterInfo filter = new FilterInfo();
            FilterItemInfo filterItem1 = new FilterItemInfo("SRCENTITYNAME", (Object)srcType.toString());
            FilterItemInfo filterItem2 = new FilterItemInfo("DESTENTITYNAME", (Object)destType.toString());
            FilterItemInfo filterItem3 = new FilterItemInfo("extRule.isEffected", (Object)new Integer(1));
            FilterItemInfo filterItem4 = new FilterItemInfo("extRule.transMode", (Object)new Integer(10));
            FilterItemInfo filterItem5 = new FilterItemInfo("extRule.transMode", (Object)new Integer(30));
            FilterItemInfo filterItem6 = new FilterItemInfo("defineSys", (Object)new Integer(20));
            FilterItemInfo filterItem7 = new FilterItemInfo("cu.id", (Object)cuId);
            FilterItemInfo filterItem8 = new FilterItemInfo("cu.id", (Object)"00000000-0000-0000-0000-000000000000CCE7AED4");
            filter.getFilterItems().add(filterItem1);
            filter.getFilterItems().add(filterItem2);
            filter.getFilterItems().add(filterItem3);
            filter.getFilterItems().add(filterItem4);
            filter.getFilterItems().add(filterItem5);
            filter.getFilterItems().add(filterItem6);
            filter.getFilterItems().add(filterItem7);
            filter.getFilterItems().add(filterItem8);
            filter.setMaskString("#0 and #1 and #2 and (#3 or #4) and #5 and (#6 or #7)");
            entityViewInfo.setFilter(filter);
            SorterItemInfo sii1 = new SorterItemInfo("LASTUPDATETIME");
            sii1.setSortType(SortType.DESCEND);
            SorterItemInfo sii2 = new SorterItemInfo("cu.id");
            sii2.setSortType(SortType.DESCEND);
            entityViewInfo.getSorter().add(sii1);
            entityViewInfo.getSorter().add(sii2);
            botMappingCollection = botMapping.getBOTMappingCollection(entityViewInfo);
            Iterator ite = botMappingCollection.iterator();
            if (ite.hasNext()) {
                BOTMappingInfo mappingInfo = (BOTMappingInfo)ite.next();
                return mappingInfo;
            }
        }
        catch (BOSException e) {
            logger.error((Object)e);
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
        return null;
    }

    public static BOTMappingInfo getBotpMappingInfo(Context ctx, BOSObjectType srcType, BOSObjectType destType, String cuId, String[] botMappingIDs) {
        IBOTMapping botMapping = null;
        try {
            botMapping = ctx == null ? BOTMappingFactory.getRemoteInstance() : BOTMappingFactory.getLocalInstance((Context)ctx);
            BOTMappingCollection botMappingCollection = null;
            EntityViewInfo entityViewInfo = new EntityViewInfo();
            entityViewInfo.getSelector().add("*");
            entityViewInfo.getSelector().add("rules.ruleSegments.*");
            FilterInfo filter = new FilterInfo();
            FilterItemInfo filterItem1 = new FilterItemInfo("SRCENTITYNAME", (Object)srcType.toString());
            FilterItemInfo filterItem2 = new FilterItemInfo("DESTENTITYNAME", (Object)destType.toString());
            FilterItemInfo filterItem3 = new FilterItemInfo("extRule.isEffected", (Object)new Integer(1));
            FilterItemInfo filterItem4 = new FilterItemInfo("extRule.transMode", (Object)new Integer(10));
            FilterItemInfo filterItem5 = new FilterItemInfo("extRule.transMode", (Object)new Integer(30));
            FilterItemInfo filterItem6 = new FilterItemInfo("defineSys", (Object)new Integer(20));
            FilterItemInfo filterItem7 = new FilterItemInfo("cu.id", (Object)cuId);
            FilterItemInfo filterItem8 = new FilterItemInfo("cu.id", (Object)"00000000-0000-0000-0000-000000000000CCE7AED4");
            filter.getFilterItems().add(filterItem1);
            filter.getFilterItems().add(filterItem2);
            filter.getFilterItems().add(filterItem3);
            filter.getFilterItems().add(filterItem4);
            filter.getFilterItems().add(filterItem5);
            filter.getFilterItems().add(filterItem6);
            filter.getFilterItems().add(filterItem7);
            filter.getFilterItems().add(filterItem8);
            filter.setMaskString("#0 and #1 and #2 and (#3 or #4) and #5 and (#6 or #7)");
            entityViewInfo.setFilter(filter);
            SorterItemInfo sii1 = new SorterItemInfo("LASTUPDATETIME");
            sii1.setSortType(SortType.DESCEND);
            SorterItemInfo sii2 = new SorterItemInfo("cu.id");
            sii2.setSortType(SortType.DESCEND);
            entityViewInfo.getSorter().add(sii1);
            entityViewInfo.getSorter().add(sii2);
            botMappingCollection = botMapping.getBOTMappingCollection(entityViewInfo);
            Iterator ite = botMappingCollection.iterator();
            if (ite.hasNext()) {
                BOTMappingInfo mappingInfo = (BOTMappingInfo)ite.next();
                int length = botMappingIDs.length;
                for (int i = 0; i < length; ++i) {
                    if (mappingInfo.getId() == null || !mappingInfo.getId().toString().equals(botMappingIDs[i])) continue;
                    mappingInfo = (BOTMappingInfo)ite.next();
                }
                return mappingInfo;
            }
        }
        catch (BOSException e) {
            logger.error((Object)e);
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
        return null;
    }

    public static BOTMappingCollection getBotpMappingCollection(Context ctx, BOSObjectType srcType, BOSObjectType destType, String cuId) {
        BOTMappingCollection botMappingCollection = null;
        try {
            IBOTMapping botMapping = null;
            botMapping = ctx == null ? BOTMappingFactory.getRemoteInstance() : BOTMappingFactory.getLocalInstance((Context)ctx);
            EntityViewInfo entityViewInfo = new EntityViewInfo();
            entityViewInfo.getSelector().add("*");
            entityViewInfo.getSelector().add("rules.ruleSegments.*");
            FilterInfo filter = new FilterInfo();
            FilterItemInfo filterItem1 = new FilterItemInfo("SRCENTITYNAME", (Object)srcType.toString());
            FilterItemInfo filterItem2 = new FilterItemInfo("DESTENTITYNAME", (Object)destType.toString());
            FilterItemInfo filterItem3 = new FilterItemInfo("extRule.isEffected", (Object)new Integer(1));
            FilterItemInfo filterItem4 = new FilterItemInfo("extRule.transMode", (Object)new Integer(10));
            FilterItemInfo filterItem5 = new FilterItemInfo("extRule.transMode", (Object)new Integer(30));
            FilterItemInfo filterItem6 = new FilterItemInfo("defineSys", (Object)new Integer(20));
            FilterItemInfo filterItem7 = new FilterItemInfo("cu.id", (Object)cuId);
            FilterItemInfo filterItem8 = new FilterItemInfo("cu.id", (Object)"00000000-0000-0000-0000-000000000000CCE7AED4");
            filter.getFilterItems().add(filterItem1);
            filter.getFilterItems().add(filterItem2);
            filter.getFilterItems().add(filterItem3);
            filter.getFilterItems().add(filterItem4);
            filter.getFilterItems().add(filterItem5);
            filter.getFilterItems().add(filterItem6);
            filter.getFilterItems().add(filterItem7);
            filter.getFilterItems().add(filterItem8);
            filter.setMaskString("#0 and #1 and #2 and (#3 or #4) and #5 and (#6 or #7)");
            entityViewInfo.setFilter(filter);
            SorterItemInfo sii1 = new SorterItemInfo("LASTUPDATETIME");
            sii1.setSortType(SortType.DESCEND);
            SorterItemInfo sii2 = new SorterItemInfo("cu.id");
            sii2.setSortType(SortType.DESCEND);
            entityViewInfo.getSorter().add(sii1);
            entityViewInfo.getSorter().add(sii2);
            botMappingCollection = botMapping.getBOTMappingCollection(entityViewInfo);
        }
        catch (BOSException e) {
            logger.error((Object)e);
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
        return botMappingCollection;
    }

    public static BOTMappingCollection getBotpMappingCollectionForSelectUseRuleFilter(Context ctx, List idList, String[] entryNames, List entryIdList, String srcBillType, String targetBosType, SelectorItemCollection botpSelect) throws BOSException, BOTPException {
        IBOTMapping iBOTMapping = null;
        iBOTMapping = ctx == null ? BOTMappingFactory.getRemoteInstance() : BOTMappingFactory.getLocalInstance((Context)ctx);
        String[] idArray = new String[idList.size()];
        idList.toArray(idArray);
        BOTMappingCollection botMappingCol = iBOTMapping.getMappingCollectionForSelectUseRuleFilter(srcBillType, targetBosType, DefineSysEnum.BTP, new HashMap(), idArray, entryNames, entryIdList, botpSelect);
        HashSet<String> idSet = new HashSet<String>();
        for (int i = 0; i < botMappingCol.size(); ++i) {
            idSet.add(botMappingCol.get(i).getId().toString());
        }
        EntityViewInfo ev = new EntityViewInfo();
        ev.getSelector().add("*");
        ev.getSelector().add("rules.ruleSegments.*");
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", idSet, CompareType.INCLUDE));
        ev.setFilter(filter);
        botMappingCol = BOTMappingFactory.getRemoteInstance().getBOTMappingCollection(ev);
        return botMappingCol;
    }

    public static IObjectPK getBotpMappingPK(Context ctx, BOSObjectType srcType, BOSObjectType destType, DefineSysEnum system, String cuId) {
        IBOTMapping botMapping = null;
        try {
            botMapping = BOTMappingFactory.getLocalInstance((Context)ctx);
            BOTMappingCollection botMappingCollection = null;
            EntityViewInfo entityViewInfo = new EntityViewInfo();
            entityViewInfo.getSelector().add("id");
            FilterInfo filter = new FilterInfo();
            FilterItemInfo filterItem1 = new FilterItemInfo("SRCENTITYNAME", (Object)srcType.toString());
            FilterItemInfo filterItem2 = new FilterItemInfo("DESTENTITYNAME", (Object)destType.toString());
            FilterItemInfo filterItem3 = new FilterItemInfo("extRule.isEffected", (Object)new Integer(1));
            FilterItemInfo filterItem4 = new FilterItemInfo("extRule.transMode", (Object)new Integer(10));
            FilterItemInfo filterItem5 = new FilterItemInfo("extRule.transMode", (Object)new Integer(30));
            FilterItemInfo filterItem6 = new FilterItemInfo("defineSys", (Object)new Integer(system.getValue()));
            FilterItemInfo filterItem7 = new FilterItemInfo("cu.id", (Object)cuId);
            FilterItemInfo filterItem8 = new FilterItemInfo("cu.id", (Object)"00000000-0000-0000-0000-000000000000CCE7AED4");
            filter.getFilterItems().add(filterItem1);
            filter.getFilterItems().add(filterItem2);
            filter.getFilterItems().add(filterItem3);
            filter.getFilterItems().add(filterItem4);
            filter.getFilterItems().add(filterItem5);
            filter.getFilterItems().add(filterItem6);
            filter.getFilterItems().add(filterItem7);
            filter.getFilterItems().add(filterItem8);
            filter.setMaskString("#0 and #1 and #2 and (#3 or #4) and #5 and (#6 or #7)");
            entityViewInfo.setFilter(filter);
            SorterItemInfo sii1 = new SorterItemInfo("LASTUPDATETIME");
            sii1.setSortType(SortType.DESCEND);
            SorterItemInfo sii2 = new SorterItemInfo("cu.id");
            sii2.setSortType(SortType.DESCEND);
            entityViewInfo.getSorter().add(sii1);
            entityViewInfo.getSorter().add(sii2);
            botMappingCollection = botMapping.getBOTMappingCollection(entityViewInfo);
            Iterator ite = botMappingCollection.iterator();
            if (ite.hasNext()) {
                BOTMappingInfo mappingInfo = (BOTMappingInfo)ite.next();
                return new ObjectUuidPK(mappingInfo.getId());
            }
        }
        catch (BOSException e) {
            logger.error((Object)e);
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
        return null;
    }

    public static HashMap arap2Arap(Context ctx, ICoreBase icorebase, SelectorItemCollection transSelectors, BOTMappingInfo btpMappingInfo, CoreBillBaseCollection coll, BOSObjectType bosType, CompanyOrgUnitInfo company, int createToFlag, UserInfo currentUser) throws BOTPException, Exception {
        ArApBillBaseInfo destBillInfo = null;
        BTPTransformResult btpResult = null;
        IBTPManager iBTPManager = null;
        iBTPManager = ctx == null ? BTPManagerFactory.getRemoteInstance() : BTPManagerFactory.getLocalInstance((Context)ctx);
        if (bosType != null && btpMappingInfo != null && btpMappingInfo.getId() != null) {
            btpResult = iBTPManager.transform(coll, bosType.toString(), (IObjectPK)new ObjectUuidPK(btpMappingInfo.getId().toString()));
        }
        if (btpResult == null) {
            throw new BOTPException(BOTPException.MAPPINGNUMZERO);
        }
        destBillInfo = (ArApBillBaseInfo)btpResult.getBills().getObject(0);
        destBillInfo.setCompany(company);
        destBillInfo.setCU(company.getCU());
        destBillInfo.setSourceBillId(coll.get(0).getId().toString());
        if (createToFlag == 1 && destBillInfo.getAccountCussent() instanceof CustomerInfo) {
            ICustomerCompanyInfo iCustComp = null;
            iCustComp = ctx == null ? CustomerCompanyInfoFactory.getRemoteInstance() : CustomerCompanyInfoFactory.getLocalInstance((Context)ctx);
            ObjectUuidPK pk = new ObjectUuidPK(destBillInfo.getAccountCussent().getId());
            StringBuffer oql = new StringBuffer();
            oql.append("select bank, bankAccount, phone,operationer,adminOrgUnit where ");
            oql.append(" companyOrgUnit.id = '").append(destBillInfo.getCompany().getId());
            oql.append("' and customer.id = '");
            oql.append(pk).append("' ");
            EntityViewInfo view = new EntityViewInfo(oql.toString());
            CustomerCompanyInfoCollection infos = iCustComp.getCustomerCompanyInfoCollection(view);
            if (infos != null && infos.size() > 0) {
                CustomerCompanyInfoInfo CustcompInfo = infos.get(0);
                if (CustcompInfo.getOperationer() != null) {
                    IPerson iPerson = null;
                    iPerson = ctx == null ? PersonFactory.getRemoteInstance() : PersonFactory.getLocalInstance((Context)ctx);
                    PersonInfo personInfo = iPerson.getPersonInfo((IObjectPK)new ObjectUuidPK(CustcompInfo.getOperationer().getId().toString()));
                    destBillInfo.setPerson(personInfo);
                }
                if (CustcompInfo.getAdminOrgUnit() != null) {
                    IAdminOrgUnit iAdminOrgUnit = null;
                    iAdminOrgUnit = ctx == null ? AdminOrgUnitFactory.getRemoteInstance() : AdminOrgUnitFactory.getLocalInstance((Context)ctx);
                    AdminOrgUnitInfo adminOrgUnitInfo = iAdminOrgUnit.getAdminOrgUnitInfo((IObjectPK)new ObjectUuidPK(CustcompInfo.getAdminOrgUnit().getId()));
                    destBillInfo.setAdminOrgUnit(adminOrgUnitInfo);
                }
            }
        }
        if (destBillInfo.isIsInitializeBill()) {
            destBillInfo.setIsInitializeBill(false);
        }
        boolean isAr = destBillInfo.getBOSType().toString().equals(OtherBillInfo.getBosType().toString());
        destBillInfo.setBillDate(ArApServerUtils.getBizDateBySystem(ctx, isAr, company));
        destBillInfo.setBizDate(ArApServerUtils.getBizDateBySystem(ctx, isAr, company));
        destBillInfo.setCreator(currentUser);
        destBillInfo.setCreateTime(new Timestamp(new Date().getTime()));
        destBillInfo.setIsAllowanceBill(createToFlag != 1);
        if (destBillInfo.isIsTransBill() && destBillInfo.getEntries() != null && destBillInfo.getEntries().size() != 0) {
            for (int i = 0; i < destBillInfo.getEntries().size(); ++i) {
                ArApBillEntryBaseInfo entryInfo = (ArApBillEntryBaseInfo)destBillInfo.getEntries().getObject(i);
                if (entryInfo.getUnVerifyAmount() == null) {
                    entryInfo.setUnVerifyAmount(entryInfo.getLockUnVerifyAmt());
                    entryInfo.setUnVerifyAmountLocal(entryInfo.getLockUnVerifyAmtLocal());
                }
                entryInfo.setWittenOffBaseQty(entryInfo.getBaseQty());
                entryInfo.setLocalWrittenOffAmount(entryInfo.getRecievePayAmountLocal());
                entryInfo.setUnwriteOffBaseQty(ZERO);
                entryInfo.setLocalUnwriteOffAmount(ZERO);
                entryInfo.setInvoiceReqQty(ZERO);
                entryInfo.setInvoiceReqBaseQty(ZERO);
                entryInfo.setUnInvoiceReqQty(entryInfo.getQuantity());
                entryInfo.setUnInvoiceReqBaseQty(entryInfo.getBaseQty());
                entryInfo.setInvoiceReqAmount(ZERO);
                entryInfo.setInvoiceReqAmountLocal(ZERO);
                entryInfo.setUnInvoiceReqAmount(entryInfo.getRecievePayAmount());
                entryInfo.setUnInvoiceReqAmountLocal(entryInfo.getRecievePayAmountLocal());
            }
        }
        if (createToFlag == 2 && destBillInfo.getEntries() != null) {
            BigDecimal recPayAmount = ZERO;
            BigDecimal recPayAmountLocal = ZERO;
            OtherBillentryInfo entryInfo = null;
            for (int i = 0; i < destBillInfo.getEntries().size(); ++i) {
                entryInfo = (OtherBillentryInfo)destBillInfo.getEntries().getObject(i);
                if (entryInfo.getMaterial() != null) {
                    entryInfo.setMaterial(entryInfo.getMaterial());
                    entryInfo.setMaterialName(entryInfo.getMaterial().getName());
                }
                if (entryInfo.getOrderCustomer() != null) {
                    entryInfo.setOrdCustName(entryInfo.getOrderCustomer().getName());
                    entryInfo.setOrdCustNumber(entryInfo.getOrderCustomer().getNumber());
                    entryInfo.setOrderCustomer(entryInfo.getOrderCustomer());
                }
                if (entryInfo.getServiceCustomer() != null) {
                    entryInfo.setSerCustName(entryInfo.getServiceCustomer().getName());
                    entryInfo.setSerCustNumber(entryInfo.getServiceCustomer().getNumber());
                    entryInfo.setServiceCustomer(entryInfo.getServiceCustomer());
                }
                entryInfo.setQuantity(ZERO);
                entryInfo.setBaseQty(ZERO);
                entryInfo.setAssistQty(ZERO);
                entryInfo.setActualPrice(ZERO);
                entryInfo.setDiscountAmount(ZERO);
                entryInfo.setDiscountAmountLocal(ZERO);
                entryInfo.setDiscountRate(ZERO);
                entryInfo.setDiscountType(null);
                recPayAmount = entryInfo.getRecievePayAmount() != null ? entryInfo.getRecievePayAmount() : ZERO;
                recPayAmountLocal = entryInfo.getRecievePayAmountLocal() != null ? entryInfo.getRecievePayAmountLocal() : ZERO;
                entryInfo.setPrice(entryInfo.getAmount() != null ? entryInfo.getAmount().abs() : ZERO);
                entryInfo.setTaxPrice(recPayAmount.abs());
                entryInfo.setLockUnVerifyAmt(recPayAmount);
                entryInfo.setLockUnVerifyAmtLocal(recPayAmountLocal);
                entryInfo.setBadAmount(ZERO);
                entryInfo.setBadAmountLocal(ZERO);
            }
        }
        if (ctx != null) {
            destBillInfo.setAmountLocal(ZERO);
        }
        ArApBillHelper.calculate(ctx, destBillInfo, null);
        if (createToFlag > 0) {
            destBillInfo.setBillStatus(BillStatusEnum.SAVE);
        }
        if (destBillInfo instanceof com.kingdee.eas.fi.ap.OtherBillInfo) {
            ArApBillHelper.setBankAndAccountBank(destBillInfo.getAccountCussent(), (com.kingdee.eas.fi.ap.OtherBillInfo)destBillInfo, ctx);
        }
        if (btpMappingInfo.getIsTempSave() == 1 && BillStatusEnum.SAVE.equals((Object)destBillInfo.getBillStatus())) {
            IObjectPK pk;
            IArApBillBase iOtherBill;
            if (destBillInfo instanceof com.kingdee.eas.fi.ap.OtherBillInfo) {
                iOtherBill = null;
                iOtherBill = ctx == null ? com.kingdee.eas.fi.ap.OtherBillFactory.getRemoteInstance() : com.kingdee.eas.fi.ap.OtherBillFactory.getLocalInstance(ctx);
                pk = iBTPManager.saveRelations((CoreBillBaseInfo)destBillInfo, btpResult.getBOTRelationCollection());
                destBillInfo = iOtherBill.getOtherBillInfo(pk, ArApSelectorFactory.getApOtherbillSelector(true));
            } else {
                iOtherBill = null;
                iOtherBill = ctx == null ? OtherBillFactory.getRemoteInstance() : OtherBillFactory.getLocalInstance(ctx);
                pk = iBTPManager.saveRelations((CoreBillBaseInfo)destBillInfo, btpResult.getBOTRelationCollection());
                destBillInfo = iOtherBill.getOtherBillInfo(pk, ArApSelectorFactory.getArOtherbillSelector(true));
            }
        }
        String destBillEditUIClassName = iBTPManager.getEntityObjectInfoExtendPro(bosType.toString(), "editUI");
        btpResult.getBills().setObject(0, (IObjectValue)destBillInfo);
        HashMap<String, Object> hm = new HashMap<String, Object>();
        hm.put("btpResult", btpResult);
        hm.put("DestBillEditUIClassName", destBillEditUIClassName);
        return hm;
    }

    public static ArApSysParamInfo getArApSysParam(Context ctx, CompanyOrgUnitInfo company, HashMap uiparam) throws EASBizException, BOSException {
        CompanyOrgUnitInfo tempCompany = null;
        if (company != null) {
            tempCompany = new CompanyOrgUnitInfo();
            tempCompany.setId(company.getId());
            tempCompany.setName(company.getName());
        }
        IArApBillFacade iBillFacade = ctx == null ? ArApBillFacadeFactory.getRemoteInstance() : ArApBillFacadeFactory.getLocalInstance((Context)ctx);
        return iBillFacade.getSysParams(tempCompany, uiparam);
    }

    public static BigDecimal getConvsRate(Context ctx, Map mmuConvsRate, MeasureUnitInfo mui, MeasureUnitInfo mui2, MaterialInfo mi) throws BOSException, EASBizException {
        IMultiMeasureUnit immu;
        BigDecimal coefficient = new BigDecimal("1.00");
        BigDecimal baseExchangeRate1 = new BigDecimal("1.00");
        BigDecimal baseExchangeRate2 = new BigDecimal("1.00");
        if (mmuConvsRate.get(mi.getId().toString() + mui.getId().toString()) != null) {
            baseExchangeRate1 = (BigDecimal)mmuConvsRate.get(mi.getId().toString() + mui.getId().toString());
        } else {
            immu = null;
            immu = ctx == null ? MultiMeasureUnitFactory.getRemoteInstance() : MultiMeasureUnitFactory.getLocalInstance((Context)ctx);
            if (mui != null && mi != null) {
                baseExchangeRate1 = immu.getMultiUnit(mi.getId().toString(), mui.getId().toString()).getBaseConvsRate();
            }
        }
        if (mmuConvsRate.get(mi.getId().toString() + mui2.getId().toString()) != null) {
            baseExchangeRate2 = (BigDecimal)mmuConvsRate.get(mi.getId().toString() + mui2.getId().toString());
        } else {
            immu = null;
            immu = ctx == null ? MultiMeasureUnitFactory.getRemoteInstance() : MultiMeasureUnitFactory.getLocalInstance((Context)ctx);
            if (mui2 != null && mi != null) {
                baseExchangeRate2 = immu.getMultiUnit(mi.getId().toString(), mui2.getId().toString()).getBaseConvsRate();
            }
        }
        if (mui != null && mui2 != null) {
            coefficient = baseExchangeRate1.divide(baseExchangeRate2, 18, 4);
        }
        return coefficient;
    }

    public static Date createDate() {
        Date date = new Date();
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        return cal.getTime();
    }

    public static Date createDate(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        return cal.getTime();
    }

    public static SCMEntryDataVO getSCMEntryDataVO(Context ctx, ArApBillBaseInfo info) throws EASBizException, BOSException {
        SCMEntryDataVO resultVO = null;
        SCMEntryDataVO inputVo = null;
        MaterialInfo[] materialInfos = null;
        if (info instanceof com.kingdee.eas.fi.ap.OtherBillInfo && 202 == info.getBillTypeEnum().getValue() || info instanceof OtherBillInfo && 102 == info.getBillTypeEnum().getValue()) {
            inputVo = new SCMEntryDataVO();
            inputVo.setMainOrgType(OrgType.Company);
            inputVo.setMainOrg((OrgUnitInfo)info.getCompany());
            inputVo.setIsLoadingMaterialInfo(true);
            materialInfos = new MaterialInfo[info.getEntries().size()];
            for (int i = 0; i < info.getEntries().size(); ++i) {
                ArApBillEntryBaseInfo entryInfo = (ArApBillEntryBaseInfo)info.getEntries().getObject(i);
                materialInfos[i] = entryInfo.getMaterial();
                if (materialInfos[i] != null) continue;
            }
            if (!ArApBillHelper.isNullEntry(info)) {
                inputVo.setMaterialInfos(materialInfos);
                inputVo.setIsLoadingMaterialInfo(true);
                resultVO = ctx == null ? SCMGroupFacadeFactory.getRemoteInstance().loadComplexData(inputVo) : SCMGroupFacadeFactory.getLocalInstance((Context)ctx).loadComplexData(inputVo);
            }
            inputVo.setIsLoadingMou(true);
            inputVo.setIsLoadingMaterialInfo(false);
            inputVo.setIsLoadingMmuPrecision(true);
            MeasureUnitInfo[] measureUnitInfos = null;
            MeasureUnitInfo[] measureBaseUnitInfos = null;
            MeasureUnitInfo[] measureAssistUnitInfos = null;
            if (inputVo.isLoadingMou() || inputVo.isLoadingMmuPrecision()) {
                measureUnitInfos = new MeasureUnitInfo[info.getEntries().size()];
                measureBaseUnitInfos = new MeasureUnitInfo[info.getEntries().size()];
                measureAssistUnitInfos = new MeasureUnitInfo[info.getEntries().size()];
            }
            for (int i = 0; i < info.getEntries().size(); ++i) {
                ArApBillEntryBaseInfo entryInfo = (ArApBillEntryBaseInfo)info.getEntries().getObject(i);
                if (materialInfos[i] == null || !inputVo.isLoadingMou() && !inputVo.isLoadingMmuPrecision()) continue;
                measureUnitInfos[i] = entryInfo.getMeasureUnit();
                measureBaseUnitInfos[i] = entryInfo.getBaseUnit();
                if (measureBaseUnitInfos[i] == null) {
                    measureBaseUnitInfos[i] = resultVO.getMaterialInfos()[i].getBaseUnit();
                    entryInfo.setBaseUnit(resultVO.getMaterialInfos()[i].getBaseUnit());
                }
                if (entryInfo.getAssistUnit() == null) continue;
                measureAssistUnitInfos[i] = entryInfo.getAssistUnit();
            }
            inputVo.setMaterialInfos(materialInfos);
            inputVo.setMeasureUnitInfos(measureUnitInfos);
            inputVo.setBaseMeasureUnitInfos(measureBaseUnitInfos);
            inputVo.setAssistMeasureUnitInfos(measureAssistUnitInfos);
            if (!ArApBillHelper.isNullEntry(info)) {
                resultVO = ctx == null ? SCMGroupFacadeFactory.getRemoteInstance().loadComplexData(inputVo) : SCMGroupFacadeFactory.getLocalInstance((Context)ctx).loadComplexData(inputVo);
                return resultVO;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void handleSupplier(Context context, com.kingdee.eas.fi.ap.OtherBillInfo info) throws BOSException, EASBizException {
        if (!VerificateBillTypeEnum.PurInWarehsBill.equals((Object)info.getSourceBillType()) || info.getEntry() == null) {
            return;
        }
        IPurInWarehsEntry ipb = null;
        ipb = context == null ? PurInWarehsEntryFactory.getRemoteInstance() : PurInWarehsEntryFactory.getLocalInstance((Context)context);
        IPurOrder ipo = null;
        ipo = context == null ? PurOrderFactory.getRemoteInstance() : PurOrderFactory.getLocalInstance((Context)context);
        int size = info.getEntry().size();
        for (int i = 0; i < size; ++i) {
            if (context != null) {
                context.put((Object)"disablePermissionForKScript", (Object)new Boolean(true));
            }
            try {
                com.kingdee.eas.fi.ap.OtherBillentryInfo otherEntryInfo = info.getEntry().get(i);
                if (otherEntryInfo.getCoreBillType() == null || !otherEntryInfo.getCoreBillType().getId().toString().equals("510b6503-0105-1000-e000-010bc0a812fd463ED552")) continue;
                String purInWarhsEntryID = otherEntryInfo.getSourceBillEntryId();
                String orderID = otherEntryInfo.getCoreBillId();
                if (purInWarhsEntryID == null && orderID == null) continue;
                PurInWarehsEntryInfo puwInfo = ipb.getPurInWarehsEntryInfo((IObjectPK)new ObjectStringPK(purInWarhsEntryID));
                SelectorItemCollection sic = new SelectorItemCollection();
                sic.add("*");
                sic.add("supplier.*");
                PurOrderInfo poInfo = ipo.getPurOrderInfo((IObjectPK)new ObjectStringPK(orderID), sic);
                if (puwInfo == null || poInfo == null || poInfo.getCompanyOrgUnit() == null || puwInfo.getCompanyOrgUnit() == null) continue;
                SupplierInfo sInfo = poInfo.getSupplier();
                if (!poInfo.getCompanyOrgUnit().getId().toString().equals(puwInfo.getCompanyOrgUnit().getId().toString()) && poInfo.isIsCentralBalance()) {
                    ISupplier is = null;
                    is = context == null ? SupplierFactory.getRemoteInstance() : SupplierFactory.getLocalInstance((Context)context);
                    SupplierCollection suppliers = is.getSupplierCollectionByInter(poInfo.getCompanyOrgUnit().getId().toString());
                    SupplierInfo tempSInfo = null;
                    if (suppliers != null && suppliers.size() > 0) {
                        int len = suppliers.size();
                        for (int j = 0; j < len; ++j) {
                            tempSInfo = suppliers.get(j);
                            if (tempSInfo == null || !tempSInfo.isIsInternalCompany()) continue;
                            sInfo = tempSInfo;
                            break;
                        }
                    }
                }
                if (sInfo == null) continue;
                info.setAsstActID(sInfo.getId().toString());
                info.setAsstActName(sInfo.getName());
                info.setAsstActNumber(sInfo.getNumber());
                continue;
            }
            finally {
                if (context != null) {
                    context.put((Object)"disablePermissionForKScript", (Object)new Boolean(false));
                }
            }
        }
    }

    public static String getStrResource(String resKey) {
        return resKey;
    }

    public static Timestamp getServerDate() throws Exception {
        IArApBillFacade iArApBillFacade = ArApBillFacadeFactory.getRemoteInstance();
        return iArApBillFacade.getServerDate();
    }

    public static CoreBillBaseCollection getSrcDebitAdjCollection(Context ctx, CoreBillBaseCollection srcBillCollection) {
        return srcBillCollection;
    }

    protected static void mergeAPEntry(Context ctx, CoreBillBaseCollection srcBillCollection, com.kingdee.eas.fi.ap.OtherBillInfo apBillInfo) {
        CoreBillBaseCollection collection = null;
        HashSet<String> setSrcEntryIds = new HashSet<String>();
        com.kingdee.eas.fi.ap.OtherBillentryCollection entryColl = apBillInfo.getEntry();
        if (entryColl != null) {
            for (int j = 0; j < entryColl.size(); ++j) {
                com.kingdee.eas.fi.ap.OtherBillentryInfo entryInfo = entryColl.get(j);
                if (entryInfo == null || entryInfo.getId() == null) continue;
                setSrcEntryIds.add(entryInfo.getId().toString());
            }
        }
        EntityViewInfo entityViewInfo = new EntityViewInfo();
        entityViewInfo.getSelector().add("*");
        FilterInfo filterInfo = new FilterInfo();
        StringBuffer sbFormula = new StringBuffer();
        if (apBillInfo.getBillType().equals((Object)OtherBillType.DebitAdjust)) {
            filterInfo.getFilterItems().add(new FilterItemInfo("sourceBillId", (Object)apBillInfo.getSourceBillId()));
            filterInfo.getFilterItems().add(new FilterItemInfo("billType", (Object)new Integer(204)));
            filterInfo.getFilterItems().add(new FilterItemInfo("id", (Object)apBillInfo.getSourceBillId()));
            filterInfo.getFilterItems().add(new FilterItemInfo("billStatus", (Object)new Integer(3)));
            sbFormula.append("((#0 and #1) or #2) and #3");
        } else {
            filterInfo.getFilterItems().add(new FilterItemInfo("sourceBillId", (Object)apBillInfo.getId()));
            filterInfo.getFilterItems().add(new FilterItemInfo("billType", (Object)new Integer(204)));
            filterInfo.getFilterItems().add(new FilterItemInfo("id", (Object)apBillInfo.getId()));
            filterInfo.getFilterItems().add(new FilterItemInfo("billStatus", (Object)new Integer(3)));
            sbFormula.append("((#0 and #1) or #2) and #3");
        }
        filterInfo.setMaskString(sbFormula.toString());
        entityViewInfo.setFilter(filterInfo);
        try {
            collection = ctx == null ? com.kingdee.eas.fi.ap.OtherBillFactory.getRemoteInstance().getCoreBillBaseCollection(entityViewInfo) : com.kingdee.eas.fi.ap.OtherBillFactory.getLocalInstance(ctx).getCoreBillBaseCollection(entityViewInfo);
        }
        catch (BOSException e) {
            logger.error((Object)e);
        }
        if (collection != null && collection.size() > 0) {
            for (int i = 0; i < collection.size(); ++i) {
                com.kingdee.eas.fi.ap.OtherBillInfo billinfo = (com.kingdee.eas.fi.ap.OtherBillInfo)collection.get(i);
                if (!billinfo.getBillStatus().equals((Object)BillStatusEnum.AUDITED)) continue;
                if (apBillInfo.getBillType().equals((Object)OtherBillType.DebitAdjust)) {
                    srcBillCollection.add((CoreBillBaseInfo)billinfo);
                    continue;
                }
                if (collection.size() <= 1) continue;
                srcBillCollection.add((CoreBillBaseInfo)billinfo);
            }
        }
    }

    protected static void mergeAREntry(Context ctx, CoreBillBaseCollection srcBillCollection, OtherBillInfo arBillInfo) {
        CoreBillBaseCollection collection = null;
        HashSet<String> setSrcEntryIds = new HashSet<String>();
        OtherBillentryCollection entryColl = arBillInfo.getEntry();
        if (entryColl != null) {
            for (int j = 0; j < entryColl.size(); ++j) {
                OtherBillentryInfo entryInfo = entryColl.get(j);
                if (entryInfo == null || entryInfo.getId() == null) continue;
                setSrcEntryIds.add(entryInfo.getId().toString());
            }
        }
        EntityViewInfo entityViewInfo = new EntityViewInfo();
        entityViewInfo.getSelector().add("*");
        FilterInfo filterInfo = new FilterInfo();
        StringBuffer sbFormula = new StringBuffer();
        if (arBillInfo.getBillType().equals((Object)OtherBillTypeEnum.DebitAdjust)) {
            filterInfo.getFilterItems().add(new FilterItemInfo("sourceBillId", (Object)arBillInfo.getSourceBillId()));
            filterInfo.getFilterItems().add(new FilterItemInfo("billType", (Object)new Integer(104)));
            filterInfo.getFilterItems().add(new FilterItemInfo("id", (Object)arBillInfo.getSourceBillId()));
            filterInfo.getFilterItems().add(new FilterItemInfo("billStatus", (Object)new Integer(3)));
            sbFormula.append("((#0 and #1) or #2) and #3");
        } else {
            filterInfo.getFilterItems().add(new FilterItemInfo("sourceBillId", (Object)arBillInfo.getId()));
            filterInfo.getFilterItems().add(new FilterItemInfo("billType", (Object)new Integer(104)));
            filterInfo.getFilterItems().add(new FilterItemInfo("id", (Object)arBillInfo.getId()));
            filterInfo.getFilterItems().add(new FilterItemInfo("billStatus", (Object)new Integer(3)));
            sbFormula.append("((#0 and #1) or #2) and #3");
        }
        filterInfo.setMaskString(sbFormula.toString());
        entityViewInfo.setFilter(filterInfo);
        try {
            collection = ctx == null ? OtherBillFactory.getRemoteInstance().getCoreBillBaseCollection(entityViewInfo) : OtherBillFactory.getLocalInstance(ctx).getCoreBillBaseCollection(entityViewInfo);
        }
        catch (BOSException e) {
            logger.error((Object)e);
        }
        if (collection != null && collection.size() > 0) {
            for (int i = 0; i < collection.size(); ++i) {
                OtherBillInfo billinfo = (OtherBillInfo)collection.get(i);
                if (!billinfo.getBillStatus().equals((Object)BillStatusEnum.AUDITED)) continue;
                if (arBillInfo.getBillType().equals((Object)OtherBillTypeEnum.DebitAdjust)) {
                    srcBillCollection.add((CoreBillBaseInfo)billinfo);
                    continue;
                }
                if (collection.size() <= 1) continue;
                srcBillCollection.add((CoreBillBaseInfo)billinfo);
            }
        }
    }

    public static AccountViewInfo getKAClassAccount(String cuID, String companyID, String asstActId, boolean isArBill, boolean isArSystem, int isPreRecPay) throws Exception {
        IArApBillFacade iArAp = ArApBillFacadeFactory.getRemoteInstance();
        AccountViewInfo account = new AccountViewInfo();
        IRowSet accountResult = iArAp.getKAClzzAccCheck(cuID, companyID, asstActId, isArBill, isArSystem, isPreRecPay);
        if (accountResult == null) {
            return null;
        }
        if (!accountResult.next()) {
            return null;
        }
        account.setId(BOSUuid.read((String)accountResult.getString("account_id")));
        account.setNumber(accountResult.getString("account_number"));
        account.setName(accountResult.getString("account_name"));
        return account;
    }

    public static String ids2SqlString(Collection billIDs) {
        StringBuffer ids = new StringBuffer();
        Iterator iter = billIDs.iterator();
        while (iter.hasNext()) {
            String id = String.valueOf(iter.next());
            if (!BOSUuid.isValid((String)id, (boolean)false)) continue;
            ids.append("'");
            ids.append(id);
            ids.append("',");
        }
        if (ids.length() > 0) {
            ids.deleteCharAt(ids.length() - 1);
        }
        return ids.toString();
    }

    public static Set Array2Set(String[] array) {
        if (array == null || array.length < 1) {
            return null;
        }
        HashSet<String> idSet = new HashSet<String>();
        int len = array.length;
        for (int i = 0; i < len; ++i) {
            idSet.add(array[i]);
        }
        return idSet;
    }

    public static String getStrResourceByKey(Context ctx, String resKey) {
        return ResourceBase.getString((String)"com.kingdee.eas.fi.ar.ArApBillResource", (String)resKey, (Locale)ctx.getLocale());
    }

    public static void throwExcetion(String message) throws EASBizException {
        throw new ArApRecPayException(ArApRecPayException.BLANK, (Object[])new String[]{message});
    }

    public static List getList(Collection billIDs) {
        Iterator iter = billIDs.iterator();
        ArrayList<String> billidcol = new ArrayList<String>();
        String id = null;
        while (iter.hasNext()) {
            id = (String)iter.next();
            if (id == null) continue;
            billidcol.add(id);
        }
        return billidcol;
    }

    public static boolean isIdEqualsByDataChangeEvent(DataChangeEvent e) {
        boolean idEquals = false;
        if (e != null && e.getNewValue() != null && e.getOldValue() != null) {
            CoreBaseInfo obj1 = (CoreBaseInfo)e.getNewValue();
            CoreBaseInfo obj2 = (CoreBaseInfo)e.getOldValue();
            idEquals = ArApBillHelper.idEquals(obj1, obj2);
        }
        return idEquals;
    }

    public static boolean takeConfigType(Context ctx, String billClassName, String configTypeValue, boolean defaultValue) throws BOSException {
        FilterInfo filter = new FilterInfo();
        FilterItemInfo billClassNameFilter = new FilterItemInfo("billClassName", (Object)billClassName, CompareType.EQUALS);
        FilterItemInfo userIDFilter = null;
        userIDFilter = ctx == null ? new FilterItemInfo("userID", (Object)SysContext.getSysContext().getCurrentUserInfo().getId(), CompareType.EQUALS) : new FilterItemInfo("userID", (Object)ContextUtil.getCurrentUserInfo((Context)ctx).getId(), CompareType.EQUALS);
        FilterItemInfo configTypeFilter = new FilterItemInfo("configType", (Object)configTypeValue, CompareType.EQUALS);
        filter.getFilterItems().add(billClassNameFilter);
        filter.getFilterItems().add(userIDFilter);
        filter.getFilterItems().add(configTypeFilter);
        EntityViewInfo ev = new EntityViewInfo();
        ev.setFilter(filter);
        ISMSDBillConfig iSMSDBillConfig = null;
        iSMSDBillConfig = ctx == null ? SMSDBillConfigFactory.getRemoteInstance() : SMSDBillConfigFactory.getLocalInstance((Context)ctx);
        SMSDBillConfigCollection aSMSDBillConfigCollection = iSMSDBillConfig.getSMSDBillConfigCollection(ev);
        SMSDBillConfigInfo aSMSDBillConfig = null;
        if (aSMSDBillConfigCollection.size() <= 0) {
            return defaultValue;
        }
        aSMSDBillConfig = aSMSDBillConfigCollection.get(0);
        if (aSMSDBillConfig.getConfigValue().toString().equals("0")) {
            return false;
        }
        return aSMSDBillConfig.getConfigValue().toString().equals("1");
    }

    private static void getSourceBillEntryBaseQty(Context ctx, ArApBillBaseInfo info, HashMap entryBaseQtyMap) throws EASBizException, BOSException {
        if (info == null || info.getEntries() == null) {
            return;
        }
        ArApBillEntryBaseInfo entry = null;
        StringBuffer sqlString = new StringBuffer("");
        boolean isSourceBillSaleIssue = false;
        if (info.getSourceBillType() != null && info.getSourceBillType().equals((Object)VerificateBillTypeEnum.PurOrder)) {
            sqlString.append("select t1.FParentId AS FSourceBillId,t1.FID AS FSourceBillEntryId,t1.FUNITID as FUNITID, t1.FBaseQty as FBaseQty,ISNULL(FIsBetweenCompanyRec,0) as FIsBetweenCompany,0 as FIsSquareBalance  FROM T_SM_PurOrderEntry t1 where t1.FParentID=? ");
        }
        if (info.getSourceBillType() != null && info.getSourceBillType().equals((Object)VerificateBillTypeEnum.SubOrder)) {
            sqlString.append("select t1.FParentId AS FSourceBillId,t1.FID AS FSourceBillEntryId,t1.FUNITID as FUNITID, t1.FBaseQty as FBaseQty,0 as FIsBetweenCompany,0 as FIsSquareBalance  FROM T_SM_SubContractOrderEntry t1 where t1.FParentID=? ");
        }
        if (info.getSourceBillType() != null && info.getSourceBillType().equals((Object)VerificateBillTypeEnum.PurInWarehsBill)) {
            if ("1x7KMBq4mUmpj58T4jNPqiQHQ1w=".equals(info.getBizType().getId().toString())) {
                sqlString.append("select t1.FParentId AS FSourceBillId,t1.FID AS FSourceBillEntryId,t1.FUNITID as FUNITID, t1.FBaseQty as FBaseQty,ISNULL(FIsBetweenCompanySend,0) as FIsBetweenCompany,0 as FIsSquareBalance  FROM T_IM_PurInWarehsEntry t1 where t1.FParentID=? ");
            } else {
                sqlString.append("select t1.FParentId AS FSourceBillId,t1.FID AS FSourceBillEntryId,t1.FUNITID as FUNITID, t1.FBaseQty as FBaseQty,ISNULL(t2.FIsBetweenCompanyRec,0) as FIsBetweenCompany,0 as FIsSquareBalance  FROM T_IM_PurInWarehsEntry t1  inner join T_SM_PurOrderEntry t2 on t1.FPurorderID=t2.FParentID AND t1.FPurorderentryID=t2.FID where t1.FParentID=? ");
            }
        }
        if (info.getSourceBillType() != null && info.getSourceBillType().equals((Object)VerificateBillTypeEnum.SaleOrder)) {
            sqlString.append("select t1.FParentId AS FSourceBillId,t1.FID AS FSourceBillEntryId,t1.FUNITID as FUNITID, t1.FBaseQty as FBaseQty,ISNULL(t1.FIsBetweenCompanySend,0) as FIsBetweenCompany   ,(case when t2.FIsCentralBalance=1 and t2.FIsSquareBalance=1 and t1.FIsBetweenCompanySend=1 then 1 else 0 end) as FIsSquareBalance  FROM T_SD_SaleOrderEntry t1  inner join T_SD_SaleOrder t2 on t1.FParentID=t2.FID where t1.FParentID=? ");
        }
        if (info.getSourceBillType() != null && info.getSourceBillType().equals((Object)VerificateBillTypeEnum.SaleIssueBill)) {
            isSourceBillSaleIssue = true;
            sqlString.append("select t1.FParentId AS FSourceBillId,t1.FID AS FSourceBillEntryId,");
            sqlString.append("t1.FUNITID as FUNITID, t1.FBaseQty as FBaseQty,ISNULL(t2.FIsBetweenCompanySend,0) as FIsBetweenCompany  ");
            sqlString.append(" ,(case when t3.FIsCentralBalance=1 and t3.FIsSquareBalance=1 and t2.FIsBetweenCompanySend=1 then 1 else 0 end) as FIsSquareBalance ");
            sqlString.append(" FROM T_IM_SaleIssueEntry t1 inner join T_SD_SaleOrder t3 on t1.FSaleorderID=t3.FID ");
            sqlString.append(" inner join T_SD_SaleOrderEntry t2 on t1.FSaleorderID=t2.FParentID AND t1.FSaleorderentryID=t2.FID  where t1.FParentID=? ");
            sqlString.append(" union all");
            sqlString.append(" select t1.FParentId AS FSourceBillId,t1.FID AS FSourceBillEntryId,t1.FUNITID as FUNITID, t1.FBaseQty as FBaseQty,0 as FIsBetweenCompany ,0 as FIsSquareBalance");
            sqlString.append(" FROM T_IM_SaleIssueEntry t1 where t1.FParentID=? ");
            sqlString.append(" and t1.FParentID = t1.FSALEORDERID");
        }
        if (sqlString.toString().length() > 0) {
            HashMap<String, ArApBillEntryBaseInfo> orderMap = new HashMap<String, ArApBillEntryBaseInfo>();
            HashMap<String, String> unitMap = new HashMap<String, String>();
            int size = info.getEntries().size();
            for (int i = 0; i < size; ++i) {
                Object[] objectArray;
                entry = (ArApBillEntryBaseInfo)info.getEntries().getObject(i);
                if (entry == null || entry.getSourceBillId() == null || orderMap.containsKey(entry.getSourceBillId().toString())) continue;
                orderMap.put(entry.getSourceBillId(), entry);
                ObjectStringPK pk = new ObjectStringPK(entry.getSourceBillId());
                String string = sqlString.toString();
                if (isSourceBillSaleIssue) {
                    Object[] objectArray2 = new Object[2];
                    objectArray2[0] = pk.toString();
                    objectArray = objectArray2;
                    objectArray2[1] = pk.toString();
                } else {
                    Object[] objectArray3 = new Object[1];
                    objectArray = objectArray3;
                    objectArray3[0] = pk.toString();
                }
                IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)string, (Object[])objectArray);
                try {
                    while (rowSet.next()) {
                        if (rowSet.getString("FSourceBillEntryId") == null || entryBaseQtyMap.containsKey(rowSet.getString("FSourceBillEntryId").toString())) continue;
                        if (ZERO.equals(rowSet.getBigDecimal("FIsBetweenCompany")) && ZERO.equals(rowSet.getBigDecimal("FIsSquareBalance"))) {
                            entryBaseQtyMap.put(rowSet.getString("FSourceBillEntryId").toString(), rowSet.getBigDecimal("FBaseQty"));
                        } else {
                            entryBaseQtyMap.put(rowSet.getString("FSourceBillEntryId").toString(), ZERO);
                        }
                        unitMap.put(rowSet.getString("FSourceBillEntryId"), rowSet.getString("FUNITID"));
                    }
                    continue;
                }
                catch (SQLException e) {
                    logger.error((Object)e);
                }
            }
            entryBaseQtyMap.put("UnitMap", unitMap);
        }
    }

    private static void checkBotp(Context ctx, ArApBillBaseInfo info) throws BOSException, EASBizException {
        ArApBillEntryBaseInfo entry = (ArApBillEntryBaseInfo)info.getEntries().getObject(0);
        if (entry == null) {
            return;
        }
        StringBuffer detail = new StringBuffer();
        StringBuffer errorMsg = new StringBuffer();
        String commaStr = ResourceBase.getString((String)res, (String)"Comma", (Locale)ctx.getLocale());
        if (entry.getPrice() == null) {
            detail.append(ResourceBase.getString((String)res, (String)"price", (Locale)ctx.getLocale())).append(commaStr);
        }
        if (entry.getTaxPrice() == null) {
            detail.append(ResourceBase.getString((String)res, (String)"taxPrice", (Locale)ctx.getLocale())).append(commaStr);
        }
        if (entry.getDiscountType() == null) {
            detail.append(ResourceBase.getString((String)res, (String)"discountType", (Locale)ctx.getLocale())).append(commaStr);
        }
        if (entry.getDiscountRate() == null) {
            detail.append(ResourceBase.getString((String)res, (String)"discountRate", (Locale)ctx.getLocale())).append(commaStr);
        }
        if (entry.getDiscountAmount() == null) {
            detail.append(ResourceBase.getString((String)res, (String)"discountAmount", (Locale)ctx.getLocale())).append(commaStr);
        }
        if (entry.getRealPrice() == null) {
            detail.append(ResourceBase.getString((String)res, (String)"realPrice", (Locale)ctx.getLocale())).append(commaStr);
        }
        if (entry.getActualPrice() == null) {
            detail.append(ResourceBase.getString((String)res, (String)"actualPrice", (Locale)ctx.getLocale())).append(commaStr);
        }
        if (entry.getTaxRate() == null) {
            detail.append(ResourceBase.getString((String)res, (String)"taxRate", (Locale)ctx.getLocale())).append(commaStr);
        }
        if (entry.getAmount() == null) {
            detail.append(ResourceBase.getString((String)res, (String)"amount", (Locale)ctx.getLocale())).append(commaStr);
        }
        if (entry.getAmountLocal() == null) {
            detail.append(ResourceBase.getString((String)res, (String)"amountLocal", (Locale)ctx.getLocale())).append(commaStr);
        }
        if (entry.getTaxAmount() == null) {
            detail.append(ResourceBase.getString((String)res, (String)"taxAmount", (Locale)ctx.getLocale())).append(commaStr);
        }
        if (entry.getTaxAmountLocal() == null) {
            detail.append(ResourceBase.getString((String)res, (String)"taxAmountLocal", (Locale)ctx.getLocale())).append(commaStr);
        }
        if (entry.getRecievePayAmount() == null) {
            if (info instanceof OtherBillInfo) {
                detail.append(ResourceBase.getString((String)res, (String)"recieveAmount", (Locale)ctx.getLocale())).append(commaStr);
            } else if (info instanceof com.kingdee.eas.fi.ap.OtherBillInfo) {
                detail.append(ResourceBase.getString((String)res, (String)"PayAmount", (Locale)ctx.getLocale())).append(commaStr);
            }
        }
        if (entry.getRecievePayAmountLocal() == null) {
            if (info instanceof OtherBillInfo) {
                detail.append(ResourceBase.getString((String)res, (String)"recieveAmountLocal", (Locale)ctx.getLocale())).append(commaStr);
            } else if (info instanceof com.kingdee.eas.fi.ap.OtherBillInfo) {
                detail.append(ResourceBase.getString((String)res, (String)"PayAmountLocal", (Locale)ctx.getLocale())).append(commaStr);
            }
        }
        if (entry instanceof IncomeConfimEntryInfo) {
            IncomeConfimEntryInfo incomeConfimEntryInfo = (IncomeConfimEntryInfo)entry;
            if (null == incomeConfimEntryInfo.getIncomeConfimAmount()) {
                detail.append(ResourceBase.getString((String)res, (String)"IncomeConfirmAmount", (Locale)ctx.getLocale())).append(commaStr);
            }
            if (null == incomeConfimEntryInfo.getIncomeConfimAmountLoc()) {
                detail.append(ResourceBase.getString((String)res, (String)"IncomeConfirmAmountLocal", (Locale)ctx.getLocale())).append(commaStr);
            }
        }
        if (detail.length() > 0) {
            errorMsg.append(detail.toString().substring(0, detail.toString().length() - 1));
            throw new OtherBillBizException(OtherBillBizException.BILLRELATIONFIELDNOTNULL, new String[]{errorMsg.toString()});
        }
    }

    public static IObjectPK getBotpMappingPKByRuleFilter(Context ctx, String sourceBillType, String[] idList, String[] entrysName, List entriesKey, SelectorItemCollection botpSelectors, String cuId) {
        String VOUCHERTYPE = "2652E01E";
        HashMap<String, String> ctxMap = new HashMap<String, String>();
        ctxMap.put("TRANSMITCU", cuId);
        BOTMappingCollection coll = null;
        IBOTMapping botMapping = null;
        try {
            botMapping = BOTMappingFactory.getLocalInstance((Context)ctx);
            coll = botMapping.getMappingCollectionForSelectUseRuleFilter(sourceBillType, "2652E01E", DefineSysEnum.DAP, ctxMap, idList, entrysName, entriesKey, botpSelectors);
        }
        catch (BOSException e) {
            logger.error((Object)e);
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
        if (coll != null && coll.get(0) != null) {
            return new ObjectUuidPK(coll.get(0).getId());
        }
        return null;
    }

    public static DataBaseInfo getAccountCussent(Context ctx, String asstActTypeID, String asstActID, String asstActNumber) throws BOSException {
        if (!BOSUuid.isValidLength((String)asstActID)) {
            return null;
        }
        if (StringUtils.isEmpty((String)asstActTypeID)) {
            return null;
        }
        Object objectValue = null;
        BOSObjectType bosType = BOSUuid.read((String)asstActID).getType();
        objectValue = asstActTypeID.equals(ArApBillHelper.getAsstactTypeCustomerId(ctx)) ? new CustomerInfo() : (asstActTypeID.equals(ArApBillHelper.getAsstactTypeSupplierId(ctx)) ? new SupplierInfo() : new DataBaseDInfo());
        objectValue.setId(BOSUuid.read((String)asstActID));
        objectValue.setNumber(asstActNumber);
        IDynamicObject iDyna = DynamicObjectFactory.getRemoteInstance();
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        viewInfo.setFilter(filterInfo);
        filterInfo.getFilterItems().add(new FilterItemInfo("id", (Object)asstActID, CompareType.EQUALS));
        viewInfo.getSelector().add(new SelectorItemInfo("id"));
        viewInfo.getSelector().add(new SelectorItemInfo("name"));
        IObjectCollection col = iDyna.getCollection(bosType, viewInfo);
        IObjectValue obj = col.getObject(0);
        objectValue.setName((String)obj.get("name"));
        return objectValue;
    }

    public static DataBaseInfo getAccountCussent(String asstActTypeID, String asstActID, String asstActNumber) throws BOSException {
        return ArApBillHelper.getAccountCussent(null, asstActTypeID, asstActID, asstActNumber);
    }

    public static CompanyOrgUnitInfo getDefaultCompanyWithOutCheckPermission(Context ctx, UserInfo userInfo, SystemEnum sysEnum) throws BOSException, EASBizException {
        CompanyOrgUnitInfo defaultCompany = null;
        if (ctx == null) {
            defaultCompany = SysContext.getSysContext().getCurrentFIUnit();
        } else {
            OrgUnitCollection orgUnitColl;
            OrgUnitInfo currentOrgUnit = ContextUtil.getCurrentOrgUnit((Context)ctx);
            OrgType srcOrgType = null;
            OrgType destOrgType = OrgType.Company;
            if (currentOrgUnit.isIsSaleOrgUnit() && ContextUtil.getCurrentSaleUnit((Context)ctx).isIsBizUnit()) {
                srcOrgType = OrgType.Sale;
            } else if (currentOrgUnit.isIsPurchaseOrgUnit() && ContextUtil.getCurrentPurchaseUnit((Context)ctx).isIsBizUnit()) {
                srcOrgType = OrgType.Purchase;
            } else if (currentOrgUnit.isIsStorageOrgUnit() && ContextUtil.getCurrentStorageUnit((Context)ctx).isIsBizUnit()) {
                srcOrgType = OrgType.Storage;
            } else if (currentOrgUnit.isIsAdminOrgUnit()) {
                srcOrgType = OrgType.Admin;
            }
            if (currentOrgUnit.isIsCompanyOrgUnit() && (defaultCompany = ContextUtil.getCurrentFIUnit((Context)ctx)).isIsOnlyUnion()) {
                defaultCompany = null;
            }
            if (defaultCompany == null && srcOrgType != null && (orgUnitColl = SCMGroupServerUtils.getOrgsByRelation((Context)ctx, (OrgType)srcOrgType, (OrgType)destOrgType, (String)currentOrgUnit.getId().toString())) != null && orgUnitColl.size() > 0) {
                defaultCompany = (CompanyOrgUnitInfo)orgUnitColl.get(0);
            }
        }
        if (defaultCompany == null) {
            throw new OtherBillBizException(OtherBillBizException.COMPANYISNULL);
        }
        return ArApBillHelper.getCompanyOrgUnitInfo(ctx, defaultCompany.getId(), defaultCompany);
    }

    private static void getSourceBillEntryBaseQtyNew(Context ctx, ArApBillBaseInfo info, HashMap entryBaseQtyMap) throws EASBizException, BOSException {
        IDynamicObject iObjectInstance = ctx == null ? DynamicObjectFactory.getRemoteInstance() : DynamicObjectFactory.getLocalInstance((Context)ctx);
        Iterator entryIterator = info.getEntries().iterator();
        BOSObjectType type = null;
        StringBuffer idsBuffer = new StringBuffer();
        while (entryIterator.hasNext()) {
            ArApBillEntryBaseInfo entryInfo = (ArApBillEntryBaseInfo)entryIterator.next();
            String sourceBillEntryId = entryInfo.getSourceBillEntryId();
            if (StringUtils.isEmpty((String)sourceBillEntryId)) continue;
            type = BOSUuid.read((String)sourceBillEntryId).getType();
            idsBuffer.append("'").append(sourceBillEntryId).append("',");
        }
        if (idsBuffer.length() == 0 || !info.isIsSCMBill()) {
            return;
        }
        String coreBillIdField = "";
        String typeStr = type.toString();
        if (typeStr.equals(SALE_ORDER_ENTRY_BOSTYPE) || typeStr.equals(PUR_ORDER_ENTRY_BOSTYPE)) {
            coreBillIdField = ", parent";
        } else if (typeStr.equals(PUR_INWAREHS_ENTRY_BOSTYPE)) {
            coreBillIdField = ", purOrder";
        } else if (typeStr.equals(SALE_ISSUE_ENTRY_BOSTYPE)) {
            coreBillIdField = ", saleOrder";
        }
        String idsStr = idsBuffer.toString().substring(0, idsBuffer.length() - 1);
        String oql = "select Id, Unit, BaseQty" + coreBillIdField + " where id in (" + idsStr + ")";
        IObjectCollection sourceBillEntryCollection = iObjectInstance.getCollection(type, oql);
        int sourceBillEntrySize = sourceBillEntryCollection.size();
        HashMap<String, String> unitMap = new HashMap<String, String>();
        String id = null;
        String UnitID = null;
        IObjectValue srcEntryInfo = null;
        BigDecimal baseQty = null;
        String coreBillId = null;
        String coreTypeStr = null;
        BOSObjectType coreType = null;
        StringBuffer coreBillIdsBuffer = new StringBuffer();
        HashMap coreBillRelMap = new HashMap();
        for (int i = 0; i < sourceBillEntrySize; ++i) {
            srcEntryInfo = sourceBillEntryCollection.getObject(i);
            id = srcEntryInfo.get("id").toString();
            UnitID = null == srcEntryInfo.get("Unit") ? null : ((MeasureUnitInfo)srcEntryInfo.get("Unit")).getId().toString();
            baseQty = (BigDecimal)srcEntryInfo.get("baseQty");
            entryBaseQtyMap.put(id, baseQty);
            unitMap.put(id, UnitID);
            if (typeStr.equals(SALE_ORDER_ENTRY_BOSTYPE) || typeStr.equals(PUR_ORDER_ENTRY_BOSTYPE)) {
                coreBillId = ((IObjectValue)srcEntryInfo.get("parent")).get("id").toString();
            } else if (typeStr.equals(PUR_INWAREHS_ENTRY_BOSTYPE)) {
                coreBillId = null == srcEntryInfo.get("purOrder") ? null : srcEntryInfo.get("purOrder").toString();
            } else if (typeStr.equals(SALE_ISSUE_ENTRY_BOSTYPE)) {
                String string = coreBillId = null == srcEntryInfo.get("saleOrder") ? null : srcEntryInfo.get("saleOrder").toString();
            }
            if (StringUtils.isEmpty((String)coreBillId)) continue;
            coreType = BOSUuid.read((String)coreBillId).getType();
            coreTypeStr = coreType.toString();
            if (StringUtils.isEmpty((String)coreBillId) || !coreTypeStr.equals(PUR_ORDER_BOSTYPE) && !coreTypeStr.equals(SALE_ORDER_BOSTYPE)) continue;
            coreBillIdsBuffer.append("'").append(coreBillId).append("',");
            if (null != coreBillRelMap.get(coreBillId)) {
                ((Set)coreBillRelMap.get(coreBillId)).add(id);
                continue;
            }
            HashSet<String> entryIdSet = new HashSet<String>();
            entryIdSet.add(id);
            coreBillRelMap.put(coreBillId, entryIdSet);
        }
        entryBaseQtyMap.put("UnitMap", unitMap);
        if (coreBillIdsBuffer.length() == 0) {
            return;
        }
        String coreBillIds = coreBillIdsBuffer.toString().substring(0, coreBillIdsBuffer.length() - 1);
        oql = "select Id, isCentralBalance where id in (" + coreBillIds + ")";
        IObjectCollection coreBillCollection = iObjectInstance.getCollection(coreType, oql);
        IObjectValue coreBillInfo = null;
        boolean isCentralBalance = false;
        String coreId = null;
        for (int i = 0; i < coreBillCollection.size(); ++i) {
            Set notNeedReCalIds;
            coreBillInfo = coreBillCollection.getObject(i);
            coreId = coreBillInfo.get("id").toString();
            boolean bl = isCentralBalance = null == coreBillInfo.get("isCentralBalance") ? false : new Boolean(coreBillInfo.get("isCentralBalance").toString());
            if (!isCentralBalance || null == (notNeedReCalIds = (Set)coreBillRelMap.get(coreId)) || notNeedReCalIds.size() <= 0) continue;
            for (String notNeedReCalId : notNeedReCalIds) {
                entryBaseQtyMap.remove(notNeedReCalId);
            }
        }
    }

    public static String getResourceStr(Context ctx, String res, String str) {
        return ArApBillHelper.getResourceStr(ctx, res, str, null);
    }

    public static String getResourceStr(Context ctx, String res, String str, Object[] param) {
        String resourceStr = "";
        resourceStr = ctx == null ? (param == null ? EASResource.getString((String)res, (String)str) : EASResource.getString((String)res, (String)str, (Object[])param)) : (param == null ? ResourceBase.getString((String)res, (String)str, (Locale)ctx.getLocale()) : ResourceBase.getString((String)res, (String)str, (Locale)ctx.getLocale(), (Object[])param));
        return resourceStr;
    }

    public static void updateArApVerifyStatus(ArApBillBaseInfo info) {
        boolean verifyedAmtAllZero = true;
        boolean unVerifyedAmtAllZero = true;
        boolean recPayAmtAllZero = true;
        ArApBillEntryBaseInfo entry = null;
        ArApBillEntryBaseCollection coll = new ArApBillEntryBaseCollection();
        coll.addObjectCollection((IObjectCollection)info.getEntries());
        for (int i = 0; i < coll.size(); ++i) {
            BigDecimal recPayAmount;
            entry = coll.get(i);
            BigDecimal verifyAmount = entry.getVerifyAmount() == null ? BigDecimal.ZERO : entry.getVerifyAmount();
            BigDecimal unVerifyAmount = entry.getUnVerifyAmount() == null ? BigDecimal.ZERO : entry.getUnVerifyAmount();
            BigDecimal bigDecimal = recPayAmount = entry.getRecievePayAmount() == null ? BigDecimal.ZERO : entry.getRecievePayAmount();
            if (verifyAmount.compareTo(BigDecimal.ZERO) != 0) {
                verifyedAmtAllZero = false;
            }
            if (unVerifyAmount.compareTo(BigDecimal.ZERO) != 0) {
                unVerifyedAmtAllZero = false;
            }
            if (recPayAmount.compareTo(BigDecimal.ZERO) == 0) continue;
            recPayAmtAllZero = false;
        }
        if (recPayAmtAllZero && info.getBillStatus().equals((Object)BillStatusEnum.AUDITED) || !recPayAmtAllZero && unVerifyedAmtAllZero) {
            info.setVerifyStatus(verifyStatusEnum.VERIFIED);
        } else if (recPayAmtAllZero && !info.getBillStatus().equals((Object)BillStatusEnum.AUDITED) || !recPayAmtAllZero && verifyedAmtAllZero) {
            info.setVerifyStatus(verifyStatusEnum.UNVERIFY);
        } else {
            info.setVerifyStatus(verifyStatusEnum.SOME_VERIFIED);
        }
    }

    public static void updateRecPayVerifyStatus(RecPayBillInfo info) {
        BigDecimal unVerifyAmount;
        BigDecimal verifyAmount = info.getVerifiedAmt() == null ? BigDecimal.ZERO : info.getVerifiedAmt();
        BigDecimal bigDecimal = unVerifyAmount = info.getUnVerifiedAmt() == null ? BigDecimal.ZERO : info.getUnVerifiedAmt();
        if (verifyAmount.compareTo(BigDecimal.ZERO) == 0) {
            info.setVerifyStatus(com.kingdee.eas.fi.cas.verifyStatusEnum.UNVERIFY);
        } else if (unVerifyAmount.compareTo(BigDecimal.ZERO) == 0) {
            info.setVerifyStatus(com.kingdee.eas.fi.cas.verifyStatusEnum.VERIFIED);
        } else {
            info.setVerifyStatus(com.kingdee.eas.fi.cas.verifyStatusEnum.SOME_VERIFIED);
        }
    }

    public static SelectorItemCollection getEntityDepPropertySelector(Context ctx, BOSObjectType bosType, boolean isGetDepOwnProperty, boolean isGetDepLinkProperty, boolean isGetEntryDepProperty, List needGetEntriesList) {
        SelectorItemCollection sic = new SelectorItemCollection();
        IMetaDataLoader loader = null;
        loader = ctx == null ? MetaDataLoaderFactory.getRemoteMetaDataLoader() : MetaDataLoaderFactory.getLocalMetaDataLoader((Context)ctx);
        EntityObjectInfo entityInfo = loader.getEntity(bosType);
        PropertyCollection pCollection = entityInfo.getPropertiesRuntime();
        int size = pCollection.size();
        for (int i = 0; i < size; ++i) {
            RelationshipInfo resInfo;
            PropertyInfo propInfo = entityInfo.getPropertyByName(pCollection.get(i).toString());
            if (propInfo == null) continue;
            if (propInfo.isConfigured()) {
                if (isGetDepOwnProperty && propInfo instanceof OwnPropertyInfo) {
                    sic.add(new SelectorItemInfo(pCollection.get(i).toString()));
                } else if (isGetDepLinkProperty && propInfo instanceof LinkPropertyInfo) {
                    sic.add(new SelectorItemInfo(pCollection.get(i).toString() + ".id"));
                    sic.add(new SelectorItemInfo(pCollection.get(i).toString() + ".name"));
                    sic.add(new SelectorItemInfo(pCollection.get(i).toString() + ".number"));
                }
            }
            if (!isGetEntryDepProperty || propInfo.getMappingField() != null || !(propInfo instanceof LinkPropertyInfo) || needGetEntriesList != null && !needGetEntriesList.contains(propInfo.getName()) || (resInfo = ((LinkPropertyInfo)propInfo).getRelationship()) == null || resInfo.getSupplierObject() == null) continue;
            SelectorItemCollection entrySelector = ArApBillHelper.getEntityEntryDepPropertySelector(ctx, resInfo.getSupplierObject().getType(), propInfo, isGetDepOwnProperty, isGetDepLinkProperty);
            sic.addObjectCollection((IObjectCollection)entrySelector);
        }
        return sic;
    }

    public static SelectorItemCollection getEntityEntryDepPropertySelector(Context ctx, BOSObjectType bosType, PropertyInfo entryPropertyInfo, boolean isGetDepOwnProperty, boolean isGetDepLinkProperty) {
        SelectorItemCollection sic = new SelectorItemCollection();
        IMetaDataLoader loader = null;
        loader = ctx == null ? MetaDataLoaderFactory.getRemoteMetaDataLoader() : MetaDataLoaderFactory.getLocalMetaDataLoader((Context)ctx);
        EntityObjectInfo entityInfo = loader.getEntity(bosType);
        PropertyCollection pCollection = entityInfo.getPropertiesRuntime();
        int size = pCollection.size();
        for (int i = 0; i < size; ++i) {
            PropertyInfo propInfo = entityInfo.getPropertyByName(pCollection.get(i).toString());
            if (propInfo == null || !propInfo.isConfigured()) continue;
            if (isGetDepOwnProperty && propInfo instanceof OwnPropertyInfo) {
                sic.add(new SelectorItemInfo(entryPropertyInfo.getName() + "." + pCollection.get(i).toString()));
                continue;
            }
            if (!isGetDepLinkProperty || !(propInfo instanceof LinkPropertyInfo)) continue;
            sic.add(new SelectorItemInfo(entryPropertyInfo.getName() + "." + pCollection.get(i).toString() + ".id"));
            sic.add(new SelectorItemInfo(entryPropertyInfo.getName() + "." + pCollection.get(i).toString() + ".name"));
            sic.add(new SelectorItemInfo(entryPropertyInfo.getName() + "." + pCollection.get(i).toString() + ".number"));
        }
        return sic;
    }

    public static String getAsstactTypeCustomerId(Context ctx) throws BOSException {
        String asstactId = ArApBillHelper.getAsstactTypeId(ctx, "customer");
        if (StringUtils.isEmpty((String)asstactId)) {
            asstactId = ASSTTYPE_CUSTOMER;
        }
        return asstactId;
    }

    public static String getAsstactTypeSupplierId(Context ctx) throws BOSException {
        String asstactId = ArApBillHelper.getAsstactTypeId(ctx, "provider");
        if (StringUtils.isEmpty((String)asstactId)) {
            asstactId = ASSTTYPE_SUPPLIER;
        }
        return asstactId;
    }

    public static String getAsstactTypeId(Context ctx, String asstHGAttribute) throws BOSException {
        String asstactId = null;
        IAsstActType iAsstActType = null;
        iAsstActType = ctx == null ? AsstActTypeFactory.getRemoteInstance() : AsstActTypeFactory.getLocalInstance((Context)ctx);
        EntityViewInfo viewInfo = new EntityViewInfo();
        SelectorItemCollection coll = new SelectorItemCollection();
        coll.add(new SelectorItemInfo("id"));
        viewInfo.setSelector(coll);
        FilterInfo filterInfo = new FilterInfo();
        viewInfo.setFilter(filterInfo);
        filterInfo.getFilterItems().add(new FilterItemInfo("asstHGAttribute", (Object)asstHGAttribute, CompareType.EQUALS));
        AsstActTypeCollection col = iAsstActType.getAsstActTypeCollection(viewInfo);
        if (col != null && col.size() > 0) {
            asstactId = col.get(0).getId().toString();
        }
        return asstactId;
    }

    public static String checkEntryAmountForInitBill(Context ctx, ArApBillBaseInfo otherBillInfo, int scale, ExchangeRateInfo exgRateInfo, ArApBillEntryBaseInfo entryInfo) throws TaskExternalException {
        if (!otherBillInfo.isIsInitializeBill()) {
            return null;
        }
        boolean isAr = otherBillInfo instanceof OtherBillInfo;
        boolean isDirectExchange = true;
        if (exgRateInfo != null && exgRateInfo.getExchangeAux() != null && ConvertModeEnum.DIRECTEXCHANGERATE.equals((Object)exgRateInfo.getExchangeAux().getConvertMode())) {
            isDirectExchange = true;
        } else if (exgRateInfo != null && exgRateInfo.getExchangeAux() != null && ConvertModeEnum.INDIRECTEXCHANGERATE.equals((Object)exgRateInfo.getExchangeAux().getConvertMode())) {
            isDirectExchange = false;
        }
        StringBuilder exceptionMsg = new StringBuilder(300);
        BigDecimal recPayAmt = entryInfo.getRecievePayAmount();
        BigDecimal verifyAmt = entryInfo.getVerifyAmount();
        BigDecimal verifyAmtLoc = entryInfo.getVerifyAmountLocal();
        BigDecimal exchangeRate = otherBillInfo.getExchangeRate();
        if (!ArApBillHelper.checkCal(scale, isDirectExchange, verifyAmt, verifyAmtLoc, exchangeRate)) {
            exceptionMsg.append("\u3010").append(ArApBillHelper.getString("BILL_VERIFY_AMOUNT_NOT_MATCH_CALC", ctx)).append("\u3011");
        }
        if (ArApBillHelper.checkOverAmtForVerifyAmt(recPayAmt, verifyAmt)) {
            exceptionMsg.append("\u3010").append(ArApBillHelper.getString("BILL_VERIFY_AMOUNT_GT_RECPAY_AMT", ctx)).append("\u3011");
        }
        if (isAr) {
            BigDecimal preparedBadAmountLocal;
            BigDecimal badAmountLocal;
            BigDecimal badAmount = entryInfo.getBigDecimal("badAmount");
            if (!ArApBillHelper.checkCal(scale, isDirectExchange, badAmount, badAmountLocal = entryInfo.getBigDecimal("badAmountLocal"), exchangeRate)) {
                exceptionMsg.append("\u3010").append(ArApBillHelper.getString("BILL_BAD_AMT_NOT_MATCH_CAL", ctx)).append("\u3011");
            }
            if (ArApBillHelper.checkOverAmt(verifyAmt, badAmount)) {
                exceptionMsg.append("\u3010").append(ArApBillHelper.getString("BILL_BAD_AMT_GT_VERIFY_AMT", ctx)).append("\u3011");
            }
            BigDecimal preparedBadAmount = null == entryInfo.getBigDecimal("preparedBadAmount") ? BigDecimal.ZERO : entryInfo.getBigDecimal("preparedBadAmount");
            BigDecimal bigDecimal = preparedBadAmountLocal = null == entryInfo.getBigDecimal("preparedBadAmountLocal") ? BigDecimal.ZERO : entryInfo.getBigDecimal("preparedBadAmountLocal");
            if (!ArApBillHelper.checkCal(scale, isDirectExchange, preparedBadAmount, preparedBadAmountLocal, exchangeRate)) {
                exceptionMsg.append("\u3010").append(ArApBillHelper.getString("BILL_PRE_BAD_AMT_NOT_MATCH_CALC", ctx)).append("\u3011");
            }
            if (ArApBillHelper.checkOverAmt(recPayAmt, preparedBadAmount)) {
                exceptionMsg.append("\u3010").append(ArApBillHelper.getString("BILL_PRE_BAD_AMT_GT_RECPAY_AMT", ctx)).append("\u3011");
            }
        }
        return exceptionMsg.toString();
    }

    protected static boolean checkOverAmtForVerifyAmt(BigDecimal baseAmt, BigDecimal compareAmt) {
        boolean isOver = false;
        if (compareAmt.signum() * baseAmt.signum() < 0 || compareAmt.abs().compareTo(baseAmt.abs()) >= 0) {
            isOver = true;
        }
        return isOver;
    }

    protected static boolean checkOverAmt(BigDecimal baseAmt, BigDecimal compareAmt) {
        boolean isOver = false;
        if (compareAmt.signum() * baseAmt.signum() < 0 || compareAmt.abs().compareTo(baseAmt.abs()) > 0) {
            isOver = true;
        }
        return isOver;
    }

    public static String getString(String resName, Context ctx) {
        String AR_RESOURCE_PATH = "com.kingdee.eas.fi.ar.ARImportData";
        return ResourceBase.getString((String)AR_RESOURCE_PATH, (String)resName, (Locale)ctx.getLocale());
    }

    protected static boolean checkCal(int scale, boolean isDirectExchange, BigDecimal amt, BigDecimal amtLoc, BigDecimal exchangeRate) {
        boolean isPassed = true;
        if (isDirectExchange) {
            if (amtLoc.compareTo(amt.multiply(exchangeRate).setScale(scale, 4)) != 0) {
                isPassed = false;
            }
        } else if (amt.divide(exchangeRate, scale, 4).compareTo(amtLoc) != 0) {
            isPassed = false;
        }
        return isPassed;
    }

    public static Map getAccountInfoByPerson(Context ctx, String personId, String currencyId) throws BOSException, EASBizException {
        Map result = new HashMap();
        if (StringUtils.isEmpty((String)personId) || StringUtils.isEmpty((String)currencyId)) {
            return result;
        }
        HashSet<String> personIdSet = new HashSet<String>();
        personIdSet.add(personId);
        result = (Map)ArApBillHelper.getAccountInfoByPerson(ctx, personIdSet, currencyId).get(personId);
        return result;
    }

    public static Map getAccountInfoByPerson(Context ctx, Set<String> personIdSet, String currencyId) throws BOSException, EASBizException {
        HashMap result = new HashMap();
        HashMap<String, String> personBankInfo = new HashMap<String, String>();
        String bank = null;
        Object bankAccount = null;
        EntityViewInfo ev = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        SorterItemCollection sortColl = new SorterItemCollection();
        sortColl.add(new SorterItemInfo("person.id"));
        SorterItemInfo sorter1 = new SorterItemInfo("isDefault");
        sorter1.setSortType(SortType.DESCEND);
        sortColl.add(sorter1);
        sortColl.add(new SorterItemInfo("currency.id"));
        SorterItemInfo sorter2 = new SorterItemInfo("lastUpdateTime");
        sorter2.setSortType(SortType.DESCEND);
        sortColl.add(sorter2);
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add("bank");
        selector.add("bankAccount");
        selector.add("isDefault");
        selector.add("person.id");
        selector.add("currency.id");
        selector.add("bankId.id");
        selector.add("bankId.name");
        selector.add("bankId.number");
        filter.getFilterItems().add(new FilterItemInfo("person.id", personIdSet, CompareType.INCLUDE));
        filter.getFilterItems().add(new FilterItemInfo("deletedStatus", (Object)1, CompareType.EQUALS));
        ev.setFilter(filter);
        ev.setSelector(selector);
        ev.setSorter(sortColl);
        IPersonAccount iPersonAccount = ctx == null ? PersonAccountFactory.getRemoteInstance() : PersonAccountFactory.getLocalInstance((Context)ctx);
        CoreBaseCollection personAccountColl = iPersonAccount.getCollection(ev);
        block0: for (String personId : personIdSet) {
            result.put(personId, new HashMap());
            for (int i = 0; i < personAccountColl.size(); ++i) {
                PersonAccountInfo personAccountInfo = (PersonAccountInfo)personAccountColl.get(i);
                if (personId.equals(personAccountInfo.getPerson().getId().toString()) && personAccountInfo.isIsDefault() && (personAccountInfo.getCurrency() == null || currencyId.equals(personAccountInfo.getCurrency().getId().toString()))) {
                    personBankInfo.put("bank", personAccountInfo.getBank());
                    personBankInfo.put("bankAccount", personAccountInfo.getBankAccount());
                    personBankInfo.put("bebank", (String)personAccountInfo.getBankId());
                    result.put(personId, personBankInfo);
                    continue block0;
                }
                if (personId.equals(personAccountInfo.getPerson().getId().toString()) && personAccountInfo.getCurrency() != null && personAccountInfo.getCurrency().getId() != null) {
                    if (!currencyId.equals(personAccountInfo.getCurrency().getId().toString())) continue;
                    personBankInfo.put("bank", personAccountInfo.getBank());
                    personBankInfo.put("bankAccount", personAccountInfo.getBankAccount());
                    personBankInfo.put("bebank", (String)personAccountInfo.getBankId());
                    result.put(personId, personBankInfo);
                    continue block0;
                }
                if (!personId.equals(personAccountInfo.getPerson().getId().toString()) || !StringUtils.isEmpty(bank) || !StringUtils.isEmpty(bank)) continue;
                personBankInfo.put("bank", personAccountInfo.getBank());
                personBankInfo.put("bankAccount", personAccountInfo.getBankAccount());
                personBankInfo.put("bebank", (String)personAccountInfo.getBankId());
                result.put(personId, personBankInfo);
                continue block0;
            }
        }
        return result;
    }

    public static void setBankAndAccountBank(Object obj, com.kingdee.eas.fi.ap.OtherBillInfo info, Context ctx) throws BOSException, EASBizException {
        if (obj instanceof SupplierInfo) {
            IAccountBank iAccountBank;
            ISupplierCompanyBank iSupCompBank;
            ISupplier iSupplier;
            if (ctx == null) {
                iSupplier = SupplierFactory.getRemoteInstance();
                iSupCompBank = SupplierCompanyBankFactory.getRemoteInstance();
                iAccountBank = AccountBankFactory.getRemoteInstance();
            } else {
                iSupplier = SupplierFactory.getLocalInstance((Context)ctx);
                iSupCompBank = SupplierCompanyBankFactory.getLocalInstance((Context)ctx);
                iAccountBank = AccountBankFactory.getLocalInstance((Context)ctx);
            }
            SupplierInfo supplierInfo = iSupplier.getSupplierInfo((IObjectPK)new ObjectUuidPK(((SupplierInfo)obj).getId()));
            ObjectUuidPK supplierPK = new ObjectUuidPK(supplierInfo.getId());
            ObjectUuidPK companyPK = new ObjectUuidPK(info.getCompany().getId());
            SupplierCompanyInfoInfo supplierCompanyInfo = iSupplier.getCompanyInfo((IObjectPK)supplierPK, (IObjectPK)companyPK);
            SupplierCompanyBankInfo supBankInfo = null;
            if (supplierCompanyInfo != null) {
                EntityViewInfo evi = new EntityViewInfo();
                FilterInfo filter = new FilterInfo();
                filter.getFilterItems().add(new FilterItemInfo("supplierCompanyInfo.id", (Object)supplierCompanyInfo.getId().toString()));
                evi.setFilter(filter);
                SorterItemCollection sort = new SorterItemCollection();
                sort.add(new SorterItemInfo("seq"));
                evi.setSorter(sort);
                SupplierCompanyBankCollection supCompBankColls = iSupCompBank.getSupplierCompanyBankCollection(evi);
                if (supCompBankColls != null && supCompBankColls.size() > 0) {
                    for (int i = 0; i < supCompBankColls.size(); ++i) {
                        if (!supCompBankColls.get(i).isIsDefault()) continue;
                        supBankInfo = supCompBankColls.get(i);
                        break;
                    }
                    if (null == supBankInfo) {
                        supBankInfo = supCompBankColls.get(0);
                    }
                }
            }
            AccountBankInfo accountBankInfo = null;
            CompanyOrgUnitInfo companyOrgUnitInfo = supplierInfo.getInternalCompany();
            if (companyOrgUnitInfo != null) {
                EntityViewInfo evew = new EntityViewInfo();
                FilterInfo fi = new FilterInfo();
                fi.getFilterItems().add(new FilterItemInfo("company.id", (Object)companyOrgUnitInfo.getId().toString()));
                fi.getFilterItems().add(new FilterItemInfo("isClosed", (Object)0));
                evew.setFilter(fi);
                evew.getSelector().add(new SelectorItemInfo("bankAccountNumber"));
                evew.getSelector().add(new SelectorItemInfo("bank.name"));
                evew.getSelector().add("company.id");
                AccountBankCollection accountBankColls = iAccountBank.getAccountBankCollection(evew);
                if (accountBankColls != null && accountBankColls.size() > 0) {
                    accountBankInfo = accountBankColls.get(0);
                }
            }
            if (!supplierInfo.isIsInternalCompany()) {
                if (supBankInfo != null && (info.getRecAccountBank() == null || info.getRecBank() == null)) {
                    info.setRecAccountBank(supBankInfo.getBankAccount());
                    info.setRecBank(supBankInfo.getBank());
                }
            } else if (supplierInfo.isIsInternalCompany()) {
                if (supBankInfo != null && (info.getRecAccountBank() == null || info.getRecBank() == null)) {
                    info.setRecAccountBank(supBankInfo.getBankAccount());
                    info.setRecBank(supBankInfo.getBank());
                } else if (accountBankInfo != null && (info.getRecAccountBank() == null || info.getRecBank() == null)) {
                    info.setRecAccountBank(accountBankInfo.getBankAccountNumber());
                    info.setRecBank(accountBankInfo.getBank().getName());
                }
            }
        } else if (obj instanceof CustomerInfo) {
            PersonInfo person;
            String operatorid;
            AdminOrgUnitInfo admin;
            String id;
            IAdminOrgUnit iAdmin;
            IPerson iPerson;
            IAccountBank iAccountBank;
            ICustomer iCustomer;
            ICustomerCompanyBank iCustCompBank;
            if (ctx == null) {
                iCustCompBank = CustomerCompanyBankFactory.getRemoteInstance();
                iCustomer = CustomerFactory.getRemoteInstance();
                iAccountBank = AccountBankFactory.getRemoteInstance();
                iPerson = PersonFactory.getRemoteInstance();
                iAdmin = AdminOrgUnitFactory.getRemoteInstance();
            } else {
                iCustCompBank = CustomerCompanyBankFactory.getLocalInstance((Context)ctx);
                iCustomer = CustomerFactory.getLocalInstance((Context)ctx);
                iAccountBank = AccountBankFactory.getLocalInstance((Context)ctx);
                iPerson = PersonFactory.getLocalInstance((Context)ctx);
                iAdmin = AdminOrgUnitFactory.getLocalInstance((Context)ctx);
            }
            CustomerInfo customerInfo = (CustomerInfo)obj;
            ObjectUuidPK supplierPK = new ObjectUuidPK(customerInfo.getId());
            ObjectUuidPK companyPK = new ObjectUuidPK(info.getCompany().getId());
            CustomerCompanyInfoInfo customerCompanyInfo = iCustomer.getCustomerCompanyInfo((IObjectPK)supplierPK, (IObjectPK)companyPK);
            CustomerCompanyBankInfo custBankInfo = null;
            if (customerCompanyInfo != null) {
                EntityViewInfo evi = new EntityViewInfo();
                FilterInfo filter = new FilterInfo();
                filter.getFilterItems().add(new FilterItemInfo("customerCompanyInfo.id", (Object)customerCompanyInfo.getId().toString()));
                evi.setFilter(filter);
                SorterItemCollection sort = new SorterItemCollection();
                sort.add(new SorterItemInfo("seq"));
                evi.setSorter(sort);
                CustomerCompanyBankCollection custCompBankColls = iCustCompBank.getCustomerCompanyBankCollection(evi);
                if (custCompBankColls != null && custCompBankColls.size() > 0) {
                    for (int i = 0; i < custCompBankColls.size(); ++i) {
                        if (!custCompBankColls.get(i).isIsDefault()) continue;
                        custBankInfo = custCompBankColls.get(i);
                        break;
                    }
                    if (null == custBankInfo) {
                        custBankInfo = custCompBankColls.get(0);
                    }
                }
            }
            CompanyOrgUnitInfo companyOrgUnitInfo = customerInfo.getInternalCompany();
            AccountBankInfo accountBankInfo = null;
            if (companyOrgUnitInfo != null) {
                EntityViewInfo evi = new EntityViewInfo();
                FilterInfo filter = new FilterInfo();
                filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)companyOrgUnitInfo.getId().toString()));
                evi.setFilter(filter);
                evi.getSelector().add(new SelectorItemInfo("bankAccountNumber"));
                evi.getSelector().add(new SelectorItemInfo("bank.name"));
                AccountBankCollection accountBankColls = iAccountBank.getAccountBankCollection(evi);
                if (accountBankColls != null && accountBankColls.size() > 0) {
                    accountBankInfo = accountBankColls.get(0);
                }
            }
            if (!customerInfo.isIsInternalCompany()) {
                if (customerCompanyInfo == null) {
                    return;
                }
                if (customerCompanyInfo.getAdminOrgUnit() != null) {
                    id = customerCompanyInfo.getAdminOrgUnit().getId().toString();
                    admin = iAdmin.getAdminOrgUnitInfo((IObjectPK)new ObjectUuidPK(id));
                    info.setAdminOrgUnit(admin);
                }
                if (customerCompanyInfo.getOperationer() != null) {
                    operatorid = customerCompanyInfo.getOperationer().getId().toString();
                    person = iPerson.getPersonInfo((IObjectPK)new ObjectUuidPK(operatorid));
                    info.setPerson(person);
                }
                if (custBankInfo != null && (info.getRecAccountBank() == null || info.getRecBank() == null)) {
                    info.setRecAccountBank(custBankInfo.getBankAccount());
                    info.setRecBank(custBankInfo.getBank());
                }
            } else if (customerInfo.isIsInternalCompany()) {
                if (companyOrgUnitInfo == null || customerCompanyInfo == null) {
                    return;
                }
                if (customerCompanyInfo.getAdminOrgUnit() != null) {
                    id = customerCompanyInfo.getAdminOrgUnit().getId().toString();
                    admin = iAdmin.getAdminOrgUnitInfo((IObjectPK)new ObjectUuidPK(id));
                    info.setAdminOrgUnit(admin);
                }
                if (customerCompanyInfo.getOperationer() != null) {
                    operatorid = customerCompanyInfo.getOperationer().getId().toString();
                    person = iPerson.getPersonInfo((IObjectPK)new ObjectUuidPK(operatorid));
                    info.setPerson(person);
                }
                if (custBankInfo != null && (info.getRecAccountBank() == null || info.getRecBank() == null)) {
                    info.setRecAccountBank(custBankInfo.getBankAccount());
                    info.setRecBank(custBankInfo.getBank());
                } else if (accountBankInfo != null && (info.getRecAccountBank() == null || info.getRecBank() == null)) {
                    info.setRecAccountBank(accountBankInfo.getBankAccountNumber());
                    info.setRecBank(accountBankInfo.getBank().getName());
                }
            }
        } else if (obj instanceof PersonInfo && info.getCurrency() != null && StringUtil.isEmpty((String)info.getRecBank()) && StringUtil.isEmpty((String)info.getRecAccountBank())) {
            Map personBank = ArApBillHelper.getAccountInfoByPerson(ctx, ((PersonInfo)obj).getId().toString(), info.getCurrency().getId().toString());
            info.setRecBank((String)personBank.get("bank"));
            info.setRecAccountBank((String)personBank.get("bankAccount"));
        }
    }

    protected static Map<String, BigDecimal> getSourceUnReverseQtyMap(Context ctx, ArApBillBaseInfo info, String sourceBillId, boolean isAR) throws BOSException {
        HashMap<String, BigDecimal> resultMap = new HashMap<String, BigDecimal>();
        if (StringUtils.isEmpty((String)sourceBillId)) {
            return resultMap;
        }
        if (!info.isIsBizBill()) {
            return resultMap;
        }
        HashSet<String> sourceEntryIdSet = new HashSet<String>();
        AbstractObjectCollection entryColl = info.getEntries();
        int size = entryColl.size();
        for (int i = 0; i < size; ++i) {
            String sourceBillEntryId = entryColl.getObject(i).getString("sourceBillEntryId");
            if (StringUtils.isEmpty((String)sourceBillEntryId)) continue;
            sourceEntryIdSet.add(sourceBillEntryId);
        }
        if (sourceEntryIdSet.isEmpty()) {
            return resultMap;
        }
        String sourceEntryIdStr = ListUtil.transList2String(sourceEntryIdSet);
        String headTableName = isAR ? "T_AR_OTHERBILL" : "T_AP_OTHERBILL";
        String entryTableName = isAR ? "T_AR_OTHERBILLENTRY" : "T_AP_OTHERBILLENTRY";
        StringBuilder selectSql = new StringBuilder(100);
        selectSql.append(" SELECT entry.FID FID");
        selectSql.append(" \t,isnull(entry.FBASEQTY, 0) - isnull(entry.FREVERSEDBASEQTY, 0) FUNREVERSEDBASEQTY");
        selectSql.append(" FROM ").append(headTableName).append(" bill");
        selectSql.append(" INNER JOIN ").append(entryTableName).append(" entry ON bill.FID = entry.FPARENTID");
        selectSql.append(" WHERE entry.FID IN ").append(sourceEntryIdStr);
        selectSql.append(" \tAND bill.FISBIZBILL = 1");
        IDbUtilFacade iDbUtilFacade = ctx == null ? DbUtilFacadeFactory.getRemoteInstance() : DbUtilFacadeFactory.getLocalInstance(ctx);
        IRowSet rowSet = iDbUtilFacade.executeQuery(selectSql.toString());
        try {
            while (rowSet.next()) {
                resultMap.put(rowSet.getString("FID"), rowSet.getBigDecimal("FUNREVERSEDBASEQTY"));
            }
        }
        catch (SQLException e) {
            throw new BOSException("getSourceUnReverseQtyMap.SQLError", (Throwable)e);
        }
        return resultMap;
    }

    protected static boolean getBizBillAllReversed(Map<String, BigDecimal> sourceUnReverseQtyMap, ArApBillEntryBaseInfo entryInfo, boolean isBizBill) {
        String sourceEntryId = entryInfo.getSourceBillEntryId();
        if (sourceUnReverseQtyMap.isEmpty() || !isBizBill || StringUtils.isEmpty((String)sourceEntryId)) {
            return false;
        }
        BigDecimal sourceBillUnReverseQty = sourceUnReverseQtyMap.get(sourceEntryId);
        BigDecimal baseQty = entryInfo.getBaseQty();
        if (null == sourceBillUnReverseQty || null == baseQty) {
            return false;
        }
        return baseQty.abs().equals(sourceBillUnReverseQty.abs());
    }

    public static void removeEmptyEntry(IObjectValue info, String entryField, String[] emptyFields) {
        if (info == null) {
            return;
        }
        IObjectCollection entryColl = (IObjectCollection)info.get(entryField);
        if (entryColl == null) {
            return;
        }
        for (int i = entryColl.size() - 1; i >= 0; --i) {
            Object fieldValue;
            IObjectValue entryInfo = entryColl.getObject(i);
            for (int j = 0; !(j >= emptyFields.length || (fieldValue = entryInfo.get(emptyFields[j])) instanceof BigDecimal && BigDecimal.ZERO.compareTo((BigDecimal)fieldValue) != 0 || fieldValue != null); ++j) {
                if (j != emptyFields.length - 1) continue;
                entryColl.removeObject(i);
            }
        }
    }

    public static String getEntryField(String bosType) {
        String entryField = "";
        if (AR_OTHERBILL_BOSTYPE.equals(bosType) || AP_OTHERBILL_BOSTYPE.equals(bosType)) {
            entryField = "entry";
        } else if ("40284E81".equals(bosType) || "FA44FD5B".equals(bosType)) {
            entryField = "entries";
        } else if ("D001019A".equals(bosType)) {
            entryField = "entrys";
        }
        return entryField;
    }

    public static String[] getEmptyFields(String bosType) {
        String[] emptyFields = new String[]{};
        if (AR_OTHERBILL_BOSTYPE.equals(bosType) || AP_OTHERBILL_BOSTYPE.equals(bosType)) {
            emptyFields = new String[]{"material", "expenseItem"};
        } else if ("D001019A".equals(bosType)) {
            emptyFields = new String[]{"asstActID", "asstActNumber"};
        } else if ("40284E81".equals(bosType) || "FA44FD5B".equals(bosType)) {
            emptyFields = new String[]{"amount"};
        }
        return emptyFields;
    }

    public static void handleInfoBeforeViewBudget(IObjectValue info) {
        if (info instanceof RecPayBillInfo) {
            RecPayHelper.setBgCtrlAmt((RecPayBillInfo)((RecPayBillInfo)info));
        }
    }

    public static void clearInfoPk(Context ctx, AbstractObjectValue dataObject) throws BOSException {
        if (dataObject == null) {
            return;
        }
        BOSObjectType bosType = dataObject.getBOSType();
        EntitySelect select = new EntitySelect(bosType);
        select.selectPKFields();
        try {
            IMetaDataAccess iMetaDataAccess = null;
            iMetaDataAccess = ctx == null ? MetaDataAccessFactory.getRemoteInstance() : MetaDataAccessFactory.getLocalInstance((Context)ctx);
            SimpleEntity entity = iMetaDataAccess.select(select);
            String[] pks = entity.getPKFields();
            String className = "com.kingdee.eas.framework.ObjectValueUtil";
            Class<?> c = Class.forName(className);
            Class[] paramsTypes = new Class[]{AbstractObjectValue.class, String[].class};
            Method removePKFieldM = c.getDeclaredMethod("removePKField", paramsTypes);
            removePKFieldM.setAccessible(true);
            Object instance = null;
            removePKFieldM.invoke(instance, dataObject, pks);
        }
        catch (BOSException e) {
            logger.error((Object)("data object copy error." + dataObject), (Throwable)e);
        }
        catch (Exception e1) {
            logger.error((Object)"clearInfoPk error.", (Throwable)e1);
        }
    }
}

