/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.arap.util;

import com.kingdee.bos.Context;
import com.kingdee.bos.dao.AbstractObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.basedata.master.material.IMaterial;
import com.kingdee.eas.basedata.master.material.MaterialFactory;
import com.kingdee.eas.basedata.scm.common.DestinationTypeEnum;
import com.kingdee.eas.fi.ar.ArApBillEntryBaseInfo;
import com.kingdee.eas.fi.arap.util.ArApBaseCalculate;
import com.kingdee.eas.fi.arap.util.ArApBillHelper;
import com.kingdee.eas.fi.arap.util.CalculateInfoCondition;
import com.kingdee.eas.framework.DataBaseInfo;
import java.math.BigDecimal;
import org.apache.log4j.Logger;

public abstract class ArApBillInfoCalculate
extends ArApBaseCalculate {
    private static final Logger logger = CoreUIObject.getLogger(ArApBillInfoCalculate.class);
    protected AbstractObjectCollection entryCol;

    public ArApBillInfoCalculate(Context ctx, CalculateInfoCondition condition) {
        super(ctx, condition);
        if (condition.getEntries() == null) {
            throw new IllegalArgumentException();
        }
        this.entryCol = condition.getEntries();
    }

    @Override
    protected void updateData() {
        ArApBillEntryBaseInfo entryInfo = (ArApBillEntryBaseInfo)this.entryCol.getObject(this.condition.getRowIndex());
        if ((((CalculateInfoCondition)this.getCondition()).isDebitAdjust() || ((CalculateInfoCondition)this.getCondition()).isAllowanceBill()) && this.getBigDecimal(entryInfo.getQuantity(), ZERO).compareTo(BigDecimal.ZERO) == 0) {
            this.qty = ZERO;
            this.baseQty = ZERO;
            this.assistQty = ZERO;
            this.realPrice = this.realPrice.abs();
            this.actualPrice = this.actualPrice.abs();
            this.taxPrice = this.taxPrice.abs();
            this.price = this.price.abs();
        }
        entryInfo.setActualPrice(this.actualPrice);
        entryInfo.setAmount(this.amount);
        entryInfo.setAmountLocal(this.amountLocal);
        entryInfo.setAssistQty(this.assistQty);
        entryInfo.setAssistUnit(this.assistUnitInfo);
        entryInfo.setBaseQty(this.baseQty);
        entryInfo.setBaseUnit(this.baseUnitInfo);
        entryInfo.setDiscountAmount(this.discountAmount);
        entryInfo.setDiscountAmountLocal(this.discountAmountLocal);
        entryInfo.setDiscountRate(this.discountRate);
        entryInfo.setDiscountType(this.discountType);
        entryInfo.setMaterial(this.materialInfo);
        entryInfo.setPrice(this.price);
        entryInfo.setQuantity(this.qty);
        entryInfo.setRealPrice(this.realPrice);
        entryInfo.setRecievePayAmount(this.recPayAmount);
        entryInfo.setRecievePayAmountLocal(this.recPayAmountLocal);
        entryInfo.setTaxAmount(this.taxAmount);
        entryInfo.setTaxAmountLocal(this.taxAmountLocal);
        entryInfo.setTaxPrice(this.taxPrice);
        entryInfo.setTaxRate(this.taxRate);
        entryInfo.setMeasureUnit(this.unitInfo);
        if (!((CalculateInfoCondition)this.getCondition()).isInitializeBill()) {
            entryInfo.setUnVerifyAmount(this.recPayAmount);
            entryInfo.setUnVerifyAmountLocal(this.recPayAmountLocal);
            entryInfo.setLockUnVerifyAmt(this.recPayAmount);
            entryInfo.setLockUnVerifyAmtLocal(this.recPayAmountLocal);
            entryInfo.setLockVerifyAmt(ZERO);
            entryInfo.setLockVerifyAmtLocal(ZERO);
        }
        entryInfo.setApportionAmtLocal(ZERO);
        if (this.condition.isTransBill()) {
            entryInfo.setUnwriteOffBaseQty(ZERO);
            entryInfo.setWittenOffBaseQty(this.baseQty);
            entryInfo.setLocalUnwriteOffAmount(ZERO);
            entryInfo.setLocalWrittenOffAmount(this.recPayAmountLocal);
        } else if (!this.condition.isSplit()) {
            entryInfo.setUnwriteOffBaseQty(this.baseQty);
            entryInfo.setWittenOffBaseQty(ZERO);
        }
        if (this.rowType != null && DestinationTypeEnum.COSTS.equals((Object)this.rowType.getDestinationType())) {
            entryInfo.setBaseQty(entryInfo.getQuantity());
            entryInfo.setBaseUnit(entryInfo.getMeasureUnit());
            entryInfo.setUnwriteOffBaseQty(this.qty);
            entryInfo.setWittenOffBaseQty(ZERO);
            entryInfo.setLocalUnwriteOffAmount(this.amountLocal);
            entryInfo.setLocalWrittenOffAmount(ZERO);
        }
        entryInfo.setInvoiceReqQty(ZERO);
        entryInfo.setInvoiceReqBaseQty(ZERO);
        entryInfo.setUnInvoiceReqQty(this.qty);
        entryInfo.setUnInvoiceReqBaseQty(this.baseQty);
        entryInfo.setInvoiceReqAmount(ZERO);
        entryInfo.setInvoiceReqAmountLocal(ZERO);
        entryInfo.setUnInvoiceReqAmount(this.recPayAmount);
        entryInfo.setUnInvoiceReqAmountLocal(this.recPayAmountLocal);
    }

    @Override
    protected void afterUpdateData() {
        super.afterUpdateData();
        ArApBillEntryBaseInfo entryInfo = (ArApBillEntryBaseInfo)this.entryCol.getObject(this.condition.getRowIndex());
        ArApBillHelper.handleRedBill((IObjectValue)entryInfo, this.isRed);
    }

    @Override
    protected void beforeInitData() {
        ArApBillEntryBaseInfo entryInfo = (ArApBillEntryBaseInfo)this.entryCol.getObject(this.condition.getRowIndex());
        this.isRed = entryInfo.isRed();
        ArApBillHelper.handleRedBill((IObjectValue)entryInfo, false);
        super.beforeInitData();
    }

    @Override
    protected void initData() {
        ArApBillEntryBaseInfo entryInfo = (ArApBillEntryBaseInfo)this.entryCol.getObject(this.condition.getRowIndex());
        this.actualPrice = this.getBigDecimal(entryInfo.getActualPrice(), ZERO);
        this.amount = this.getBigDecimal(entryInfo.getAmount(), ZERO);
        this.amountLocal = this.getBigDecimal(entryInfo.getAmountLocal(), ZERO);
        this.assistQty = this.getBigDecimal(entryInfo.getAssistQty(), ZERO);
        this.assistUnitInfo = entryInfo.getAssistUnit();
        this.baseQty = this.getBigDecimal(entryInfo.getBaseQty(), ZERO);
        this.baseUnitInfo = entryInfo.getBaseUnit();
        this.discountAmount = this.getBigDecimal(entryInfo.getDiscountAmount(), ZERO);
        this.discountAmountLocal = this.getBigDecimal(entryInfo.getDiscountAmountLocal(), ZERO);
        this.discountRate = this.getBigDecimal(entryInfo.getDiscountRate(), ZERO);
        this.discountType = entryInfo.getDiscountType();
        this.rowType = entryInfo.getRowType();
        this.materialInfo = entryInfo.getMaterial();
        this.sourceEntryID = entryInfo.getSourceBillEntryId();
        if (ArApBillHelper.isOnlyId((DataBaseInfo)this.materialInfo)) {
            IMaterial iMaterial = null;
            try {
                iMaterial = this.ctx == null ? MaterialFactory.getRemoteInstance() : MaterialFactory.getLocalInstance((Context)this.ctx);
                this.materialInfo = iMaterial.getMaterialInfo((IObjectPK)new ObjectUuidPK(this.materialInfo.getId()));
            }
            catch (Exception e) {
                logger.error((Object)e);
            }
        }
        this.price = this.getBigDecimal(entryInfo.getPrice(), ZERO);
        this.qty = this.getBigDecimal(entryInfo.getQuantity(), ZERO);
        this.realPrice = this.getBigDecimal(entryInfo.getRealPrice(), ZERO);
        this.recPayAmount = this.getBigDecimal(entryInfo.getRecievePayAmount(), ZERO);
        this.recPayAmountLocal = this.getBigDecimal(entryInfo.getRecievePayAmountLocal(), ZERO);
        this.taxAmount = this.getBigDecimal(entryInfo.getTaxAmount(), ZERO);
        this.taxAmountLocal = this.getBigDecimal(entryInfo.getTaxAmountLocal(), ZERO);
        this.taxPrice = this.getBigDecimal(entryInfo.getTaxPrice(), ZERO);
        this.taxRate = this.getBigDecimal(entryInfo.getTaxRate(), ZERO);
        this.unitInfo = entryInfo.getMeasureUnit();
        if (this.materialInfo != null) {
            this.getCondition().setPricePrecision(this.materialInfo.getPricePrecision());
        }
        if (((CalculateInfoCondition)this.getCondition()).isDebitAdjust() || ((CalculateInfoCondition)this.getCondition()).isAllowanceBill()) {
            this.qty = this.getBigDecimal(entryInfo.getQuantity(), ZERO);
            this.baseQty = this.getBigDecimal(entryInfo.getBaseQty(), ZERO);
            this.assistQty = this.getBigDecimal(entryInfo.getAssistQty(), ZERO);
            if (this.qty.compareTo(BigDecimal.ZERO) == 0) {
                if (this.isRed) {
                    this.qty = ONE.negate();
                    this.baseQty = ONE.negate();
                    this.assistQty = ONE.negate();
                } else {
                    this.qty = ONE;
                    this.baseQty = ONE;
                    this.assistQty = ONE;
                }
            }
        } else {
            this.qty = this.getBigDecimal(entryInfo.getQuantity(), ZERO);
            this.baseQty = this.getBigDecimal(entryInfo.getBaseQty(), ZERO);
            this.assistQty = this.getBigDecimal(entryInfo.getAssistQty(), ZERO);
        }
    }

    private BigDecimal getBigDecimal(BigDecimal value, BigDecimal defaultVal) {
        return value == null ? defaultVal : value;
    }
}

