/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.arap.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.param.IParam;
import com.kingdee.eas.base.param.IParamControl;
import com.kingdee.eas.base.param.ParamCollection;
import com.kingdee.eas.base.param.ParamControlFactory;
import com.kingdee.eas.base.param.ParamFactory;
import com.kingdee.eas.base.param.ParamInfo;
import com.kingdee.eas.base.param.util.ParamManager;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.ap.APParamEnum;
import com.kingdee.eas.fi.ar.ARParamEnum;
import com.kingdee.eas.fi.arap.ARAPCommonServerFacadeFactory;
import com.kingdee.eas.fi.arap.DbUtilFacadeFactory;
import com.kingdee.eas.fi.arap.IARAPCommonServerFacade;
import com.kingdee.eas.fi.arap.IDbUtilFacade;
import com.kingdee.eas.fi.arap.util.ArApBillHelper;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import com.kingdee.util.enums.StringEnum;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import org.apache.log4j.Logger;

public class ArApParamHelper {
    private static final Logger logger = Logger.getLogger((String)"com.kingdee.eas.fi.arap.util.ArApParamHelper");
    public static final String AR_SUBSYS_ID = "com.kingdee.eas.fi.ar.ar";
    public static final String AP_SUBSYS_ID = "com.kingdee.eas.fi.ap.ap";

    private ArApParamHelper() {
    }

    public static boolean isBillAutoVatInv(Context ctx, String companyId, boolean fAR) throws BOSException, EASBizException {
        if (StringUtils.isEmpty((String)companyId)) {
            logger.error((Object)"companyId is null !");
            return false;
        }
        ObjectUuidPK companyPK = new ObjectUuidPK(companyId);
        String paramVal = fAR ? "AR_BILL_VATINV" : "AP_BILL_VATINV";
        String value = null;
        value = ctx == null ? ParamControlFactory.getRemoteInstance().getParamValue((IObjectPK)companyPK, paramVal) : ParamControlFactory.getLocalInstance((Context)ctx).getParamValue((IObjectPK)companyPK, paramVal);
        if (value == null) {
            return ArApParamHelper.getDefaultParam(ctx, fAR);
        }
        return value.equalsIgnoreCase("true") || value.equals("1");
    }

    private static boolean getDefaultParam(Context ctx, boolean fAR) throws BOSException, EASBizException {
        ParamInfo paramInfo;
        String subSysId = fAR ? AR_SUBSYS_ID : AP_SUBSYS_ID;
        String paramVal = fAR ? "AR_BILL_VATINV" : "AP_BILL_VATINV";
        StringBuffer oql = new StringBuffer("");
        oql.append(" select * where number ='").append(paramVal).append("'");
        oql.append(" and subSysID ='").append(subSysId).append("'");
        IParam iParam = null;
        iParam = ctx == null ? ParamFactory.getRemoteInstance() : ParamFactory.getLocalInstance((Context)ctx);
        ParamCollection params = iParam.getParamCollection(oql.toString());
        return params != null && params.size() != 0 && (paramInfo = params.get(0)) != null && ("true".equalsIgnoreCase(paramInfo.getDefaultValue()) || "1".equals(paramInfo.getDefaultValue()));
    }

    public static boolean getDefaultParam(Context ctx, StringEnum sEnum) throws BOSException {
        String subSysId = sEnum instanceof ARParamEnum ? AR_SUBSYS_ID : AP_SUBSYS_ID;
        return ArApParamHelper.getDefaultParam(ctx, subSysId, sEnum.getValue());
    }

    public static boolean getDefaultParam(Context ctx, String subSysId, String key) throws BOSException {
        ParamInfo paramInfo;
        StringBuffer oql = new StringBuffer("");
        oql.append(" select * where number ='").append(key).append("'");
        oql.append(" and subSysID ='").append(subSysId).append("'");
        IParam iParam = null;
        iParam = ctx == null ? ParamFactory.getRemoteInstance() : ParamFactory.getLocalInstance((Context)ctx);
        ParamCollection params = iParam.getParamCollection(oql.toString());
        return params != null && params.size() != 0 && (paramInfo = params.get(0)) != null && ("true".equalsIgnoreCase(paramInfo.getDefaultValue()) || "1".equals(paramInfo.getDefaultValue()));
    }

    public static boolean isArBillAuditNow(Context ctx, String sCompanyId) {
        return ArApParamHelper.getBooleanParamValue(ctx, sCompanyId, ARParamEnum.ARBILL_AUDIT_NOW);
    }

    public static boolean isProxyBillAuditNow(Context ctx, String sCompanyId) {
        return ArApParamHelper.getBooleanParamValue(ctx, sCompanyId, ARParamEnum.PROXYBILL_AUDIT_NOW);
    }

    public static boolean isRecBillAuditNow(Context ctx, String sCompanyId) {
        return ArApParamHelper.getBooleanParamValue(ctx, sCompanyId, ARParamEnum.RECBILL_AUDIT_NOW);
    }

    public static boolean isApBillAuditNow(Context ctx, String sCompanyId) {
        return ArApParamHelper.getBooleanParamValue(ctx, sCompanyId, APParamEnum.APBILL_AUDIT_NOW);
    }

    public static boolean isPayBillAuditNow(Context ctx, String sCompanyId) {
        return ArApParamHelper.getBooleanParamValue(ctx, sCompanyId, APParamEnum.PAYBILL_AUDIT_NOW);
    }

    public static boolean isPAYBILL_PurPayAmtOverAmt(Context ctx, String sCompanyId) {
        return ArApParamHelper.getBooleanParamValue(ctx, sCompanyId, APParamEnum.PAYBILL_PurPayAmtOverAmt);
    }

    public static boolean isAutoGenRecBill(Context ctx, String sCompanyId) {
        return ArApParamHelper.getBooleanParamValue(ctx, sCompanyId, ARParamEnum.CURRENCYSALE_AUTO_GEN_RECBILL);
    }

    public static boolean isAutoGenPayBill(Context ctx, String sCompanyId) {
        return ArApParamHelper.getBooleanParamValue(ctx, sCompanyId, APParamEnum.CURRENCYPUR_AUTO_GEN_PAYBILL);
    }

    private static boolean getBooleanParamValue(Context ctx, String sCompanyId, StringEnum sEnum) {
        ObjectUuidPK pk = new ObjectUuidPK(sCompanyId);
        String value = null;
        try {
            value = ParamManager.getParamValue((Context)ctx, (IObjectPK)pk, (String)sEnum.getValue());
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
        if (value == null) {
            try {
                return ArApParamHelper.getDefaultParam(ctx, sEnum);
            }
            catch (BOSException e) {
                logger.error((Object)e);
            }
        }
        return "true".equalsIgnoreCase(value) || "1".equalsIgnoreCase(value);
    }

    public static HashMap getParamHashMap(Context ctx, HashMap paramKeyMap) {
        HashMap value = null;
        try {
            value = ParamManager.getParamHashMap((Context)ctx, (HashMap)paramKeyMap);
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
        return value;
    }

    public static boolean hasSubmitProcDef(Context ctx, BOSObjectType billBosType) throws BOSException {
        return ArApBillHelper.hasSubmitProcDef(ctx, billBosType);
    }

    public static int getDiscountRatePrecision(Context ctx) {
        int discountRatePrecision = 4;
        try {
            IParamControl ipc = ctx == null ? ParamControlFactory.getRemoteInstance() : ParamControlFactory.getLocalInstance((Context)ctx);
            String paramvalue = ipc.getParamValue(null, "DISCOUNTRATEPRECISION");
            discountRatePrecision = Integer.valueOf(paramvalue);
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
        return discountRatePrecision;
    }

    public static boolean isRelationSCM(Context ctx, String sCompanyId, SystemEnum sysEnum) throws BOSException, EASBizException {
        StringEnum param = null;
        if (SystemEnum.ACCOUNTSPAYABLE.equals((Object)sysEnum)) {
            param = APParamEnum.AP_SCM_001;
        } else if (SystemEnum.ACCOUNTSRECEIVABLE.equals((Object)sysEnum)) {
            param = ARParamEnum.AR_SCM_001;
        } else {
            throw new IllegalArgumentException();
        }
        return ArApParamHelper.getBooleanParamValue(ctx, sCompanyId, param);
    }

    public static boolean isARRelGL(Context ctx, String companyID) throws BOSException, EASBizException {
        return !ArApParamHelper.getBooleanParamValue(ctx, companyID, ARParamEnum.AR_REL_GL);
    }

    public static boolean isAPRelGL(Context ctx, String companyID) throws BOSException, EASBizException {
        return !ArApParamHelper.getBooleanParamValue(ctx, companyID, APParamEnum.AP_REL_GL);
    }

    public static boolean isDAPCheckAccount(Context ctx) throws BOSException, EASBizException {
        IARAPCommonServerFacade iARAPCommonServer = null;
        iARAPCommonServer = ctx == null ? ARAPCommonServerFacadeFactory.getRemoteInstance() : ARAPCommonServerFacadeFactory.getLocalInstance((Context)ctx);
        return iARAPCommonServer.isDAPCheckAccount();
    }

    public static boolean isArBillSamePersion(Context ctx, String sCompanyId) {
        return ArApParamHelper.getBooleanParamValue(ctx, sCompanyId, ARParamEnum.ARBILL_IS_SAME_PERSON);
    }

    public static boolean isRecBillSamePersion(Context ctx, String sCompanyId) {
        return ArApParamHelper.getBooleanParamValue(ctx, sCompanyId, ARParamEnum.ARBILL_IS_SAME_PERSON);
    }

    public static boolean isProxyBillSamePersion(Context ctx, String sCompanyId) {
        return ArApParamHelper.getBooleanParamValue(ctx, sCompanyId, ARParamEnum.ARBILL_IS_SAME_PERSON);
    }

    public static boolean isApBillSamePersion(Context ctx, String sCompanyId) {
        return ArApParamHelper.getBooleanParamValue(ctx, sCompanyId, APParamEnum.APBILL_IS_SAME_PERSON);
    }

    public static boolean isPayBillSamePersion(Context ctx, String sCompanyId) {
        return ArApParamHelper.getBooleanParamValue(ctx, sCompanyId, APParamEnum.APBILL_IS_SAME_PERSON);
    }

    public static boolean isPayRequestBillSamePersion(Context ctx, String sCompanyId) {
        return ArApParamHelper.getBooleanParamValue(ctx, sCompanyId, APParamEnum.APBILL_IS_SAME_PERSON);
    }

    public static boolean isProxyBillSameAuditor(Context ctx, String sCompanyId) {
        return ArApParamHelper.getBooleanParamValue(ctx, sCompanyId, ARParamEnum.AR_034);
    }

    public static boolean isPayRequestBillSameAuditor(Context ctx, String sCompanyId) {
        return ArApParamHelper.getBooleanParamValue(ctx, sCompanyId, APParamEnum.AP_026);
    }

    public static boolean isPayBillPayment(Context ctx, String sCompanyId) {
        return ArApParamHelper.getBooleanParamValue(ctx, sCompanyId, APParamEnum.PAYBILL_IS_PAYMENT);
    }

    public static boolean isRecBillReceiving(Context ctx, String sCompanyId) {
        return ArApParamHelper.getBooleanParamValue(ctx, sCompanyId, ARParamEnum.RECBILL_IS_RECEIVING);
    }

    public static boolean isARCoopBillEdit(Context ctx, String sCompanyId) {
        return ArApParamHelper.getBooleanParamValue(ctx, sCompanyId, ARParamEnum.AR_COOP_BILL_IS_EDIT);
    }

    public static boolean isAPCoopBillEdit(Context ctx, String sCompanyId) {
        return ArApParamHelper.getBooleanParamValue(ctx, sCompanyId, APParamEnum.AP_COOP_BILL_IS_EDIT);
    }

    public static String getInvoiceslimits(Context ctx, String companyId, StringEnum sEnum) throws BOSException, EASBizException {
        ObjectUuidPK pk = new ObjectUuidPK(companyId);
        String value = null;
        try {
            value = ParamManager.getParamValue((Context)ctx, (IObjectPK)pk, (String)sEnum.getValue());
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
        return value;
    }

    public static String getARInvoicesVATlimits(Context ctx, String companyID) throws BOSException, EASBizException {
        return ArApParamHelper.getInvoiceslimits(ctx, companyID, ARParamEnum.ARINVOICESVAT_LIMITS_SET);
    }

    public static String getARInvoicesNORMALlimits(Context ctx, String companyID) throws BOSException, EASBizException {
        return ArApParamHelper.getInvoiceslimits(ctx, companyID, ARParamEnum.ARINVOICESNORMAL_LIMITS_SET);
    }

    public static String getAPInvoicesVATlimits(Context ctx, String companyID) throws BOSException, EASBizException {
        return ArApParamHelper.getInvoiceslimits(ctx, companyID, APParamEnum.APINVOICESVAT_LIMITS_SET);
    }

    public static String getAPInvoicesNORMALlimits(Context ctx, String companyID) throws BOSException, EASBizException {
        return ArApParamHelper.getInvoiceslimits(ctx, companyID, APParamEnum.APINVOICESNORMAL_LIMITS_SET);
    }

    public static boolean isInvoiceToVoid(Context ctx, String companyId, boolean fAR) throws BOSException, EASBizException {
        if (StringUtils.isEmpty((String)companyId)) {
            logger.error((Object)"companyId is null !");
            return false;
        }
        ObjectUuidPK companyPK = new ObjectUuidPK(companyId);
        String paramVal = fAR ? "AR_INV_TO_VOID" : "AP_INV_TO_VOID";
        String value = null;
        value = ctx == null ? ParamControlFactory.getRemoteInstance().getParamValue((IObjectPK)companyPK, paramVal) : ParamControlFactory.getLocalInstance((Context)ctx).getParamValue((IObjectPK)companyPK, paramVal);
        if (value == null) {
            return ArApParamHelper.getDefaultParam(ctx, fAR);
        }
        return value.equalsIgnoreCase("true") || value.equals("1");
    }

    public static boolean isAPOtherBillQtyOverSource(Context ctx, String sCompanyId) {
        return ArApParamHelper.getBooleanParamValue(ctx, sCompanyId, APParamEnum.AP_OTHERBILL_QtyOverSource);
    }

    public static boolean isAPAmountCanOverPurOrderAmt(Context ctx, String sCompanyId) {
        return ArApParamHelper.getBooleanParamValue(ctx, sCompanyId, APParamEnum.AP_QTY_GT_PO);
    }

    public static boolean isPrePayAmoutCanOverOrderPrepayAmt(Context ctx, String sCompanyId) {
        return ArApParamHelper.getBooleanParamValue(ctx, sCompanyId, APParamEnum.ORDERPAYMENT);
    }

    public static boolean isPrePayAmtCanOverPurContractAmt(Context ctx, String companyId) {
        return ArApParamHelper.getBooleanParamValue(ctx, companyId, APParamEnum.PurContractPrePay);
    }

    public static boolean isARSrcDebitAdjust(Context ctx, String sCompanyId) {
        return ArApParamHelper.getBooleanParamValue(ctx, sCompanyId, APParamEnum.AR_IS_SRCDEBITADJUST);
    }

    public static boolean isAPSrcDebitAdjust(Context ctx, String sCompanyId) {
        return ArApParamHelper.getBooleanParamValue(ctx, sCompanyId, APParamEnum.AP_IS_SRCDEBITADJUST);
    }

    public static boolean isAPContrastEstimateAndGL(Context ctx, String sCompanyId) {
        return ArApParamHelper.getBooleanParamValue(ctx, sCompanyId, APParamEnum.AP_CONTRAST_ESTIMATE_GL);
    }

    public static boolean isARBizBillNeedVocher(Context ctx, String sCompanyId) {
        return ArApParamHelper.getBooleanParamValue(ctx, sCompanyId, ARParamEnum.AR_IS_BIZ_VOUCHER);
    }

    public static boolean isHandleBizAPPointNormal(Context ctx, String sCompanyId) {
        return ArApParamHelper.getBooleanParamValue(ctx, sCompanyId, APParamEnum.AP_BIZ_HANDLE);
    }

    public static boolean isHandleBizARPointNormal(Context ctx, String sCompanyId) {
        return ArApParamHelper.getBooleanParamValue(ctx, sCompanyId, ARParamEnum.AR_BIZ_HANDLE);
    }

    public static boolean isApPayBillBank(Context ctx, String sCompanyId) {
        return ArApParamHelper.getBooleanParamValue(ctx, sCompanyId, APParamEnum.AP_PAYBILL_BANK);
    }

    public static boolean isPaySchedual(Context ctx, String sCompanyId) {
        return ArApParamHelper.getBooleanParamValue(ctx, sCompanyId, APParamEnum.AP_PAY_SCHEDUAL);
    }

    public static boolean isContrastByBillAccount(Context ctx, String companyID, int periodNum, boolean isAr) throws EASBizException, BOSException {
        boolean isContrastByBillAccount = false;
        if (StringUtils.isEmpty((String)companyID) || periodNum < 100000) {
            return isContrastByBillAccount;
        }
        int newContrastPeriodNumber = 999999;
        StringBuilder buf = new StringBuilder(200).append("SELECT FPERIODNUMBER FROM T_ARAP_CONTRASTPARAMRECORD WHERE FCOMPANYID = '" + companyID + "' and FISAR = " + (isAr ? 1 : 0));
        IDbUtilFacade dbUtil = null == ctx ? DbUtilFacadeFactory.getRemoteInstance() : DbUtilFacadeFactory.getLocalInstance(ctx);
        IRowSet rs = dbUtil.executeQuery(buf.toString());
        try {
            if (rs.next()) {
                newContrastPeriodNumber = rs.getInt("FPeriodNumber");
            }
        }
        catch (SQLException e) {
            logger.error((Object)e);
            throw new BOSException((Throwable)e);
        }
        isContrastByBillAccount = periodNum >= newContrastPeriodNumber;
        return isContrastByBillAccount;
    }

    public static void updateStartPeriodForAR_045(Context ctx, String companyId, PeriodInfo startPeriod, boolean isAr) throws BOSException {
        boolean enable_AR_045 = ArApParamHelper.getBooleanParamValue(ctx, companyId, ARParamEnum.AR_045);
        if (!enable_AR_045) {
            return;
        }
        String checkSql = " SELECT FISAR, FPERIODNUMBER FROM T_ARAP_CONTRASTPARAMRECORD WHERE FCOMPANYID = ?";
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)checkSql, (Object[])new Object[]{companyId});
        HashMap<SystemEnum, Integer> checkMap = new HashMap<SystemEnum, Integer>(4);
        ArrayList<Object[]> paramsList = new ArrayList<Object[]>();
        int fisAR = isAr ? 1 : 0;
        try {
            while (rs.next()) {
                SystemEnum systemEnum = rs.getInt("FISAR") == 1 ? SystemEnum.ACCOUNTSRECEIVABLE : SystemEnum.ACCOUNTSPAYABLE;
                checkMap.put(systemEnum, rs.getInt("FPeriodNumber"));
            }
            int startPeriodNumber = startPeriod.getNumber();
            if (checkMap.isEmpty()) {
                paramsList.add(new Object[]{startPeriod.getId().toString(), startPeriodNumber, companyId, fisAR, 1});
            } else {
                Integer newContrastPeriodNumber = (Integer)checkMap.get(isAr ? SystemEnum.ACCOUNTSRECEIVABLE : SystemEnum.ACCOUNTSPAYABLE);
                if (newContrastPeriodNumber == null) {
                    paramsList.add(new Object[]{startPeriod.getId().toString(), startPeriodNumber, companyId, fisAR, 1});
                } else if (newContrastPeriodNumber != 0 && startPeriodNumber != 0 && newContrastPeriodNumber != startPeriodNumber) {
                    String updateSql = " UPDATE T_ARAP_CONTRASTPARAMRECORD SET FPERIODNUMBER = ? WHERE FCOMPANYID = ? and FISAR = ? ";
                    DbUtil.execute((Context)ctx, (String)updateSql, (Object[])new Object[]{startPeriodNumber, companyId, fisAR});
                }
            }
            if (!paramsList.isEmpty()) {
                StringBuilder insertSql = new StringBuilder("INSERT INTO T_ARAP_CONTRASTPARAMRECORD (FPERIODID, FPERIODNUMBER, FCOMPANYID, FISAR, FISINIT, FID) VALUES (?, ?, ?, ?, ?, NEWBOSID('88888888'))");
                DbUtil.executeBatch((Context)ctx, (String)insertSql.toString(), paramsList);
            }
        }
        catch (SQLException e) {
            logger.error((Object)e);
            throw new BOSException((Throwable)e);
        }
    }

    public static boolean isContrastByBillAccountWithCheck(Context ctx, String companyID, int periodNum, boolean isAr) throws EASBizException, BOSException {
        boolean isContrastByBillAccount = false;
        if (StringUtils.isEmpty((String)companyID) || periodNum < 100000 || !BOSUuid.isValid((String)companyID, (boolean)false)) {
            return isContrastByBillAccount;
        }
        int newContrastPeriodNumber = 999999;
        StringBuilder buf = new StringBuilder(200).append("SELECT FPERIODNUMBER FROM T_ARAP_CONTRASTPARAMRECORD WHERE FCOMPANYID = '" + companyID + "' and FISAR = " + (isAr ? 1 : 0));
        IDbUtilFacade dbUtil = null == ctx ? DbUtilFacadeFactory.getRemoteInstance() : DbUtilFacadeFactory.getLocalInstance(ctx);
        IRowSet rs = dbUtil.executeQuery(buf.toString());
        try {
            if (rs.next()) {
                newContrastPeriodNumber = rs.getInt("FPeriodNumber");
            }
        }
        catch (SQLException e) {
            logger.error((Object)e);
            throw new BOSException((Throwable)e);
        }
        isContrastByBillAccount = periodNum >= newContrastPeriodNumber;
        return isContrastByBillAccount;
    }

    public static boolean isAR_045(Context ctx, String companyID) throws BOSException, EASBizException {
        return ArApParamHelper.getBooleanParamValue(ctx, companyID, ARParamEnum.AR_045);
    }
}

