/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.arap.util;

import com.kingdee.bos.ctrl.kdf.table.IColumn;
import com.kingdee.bos.ctrl.kdf.table.KDTCell;
import com.kingdee.bos.ctrl.kdf.table.KDTRow;
import com.kingdee.bos.ctrl.kdf.table.KDTSortManager;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import java.text.Collator;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Locale;

public class ArApSorter
extends KDTSortManager {
    public ArApSorter(KDTable table) {
        super(table);
    }

    public void sort(int colIndex, int sortType) {
        if (this.isSortAuto()) {
            IColumn column = this.table.getColumn(colIndex);
            if (column == null) {
                return;
            }
            boolean refresh = this.table.isRefresh();
            this.table.setRefresh(false);
            this.changeHeadStatus(this.colIndex, colIndex, sortType);
            List rows = this.table.getBody().getRows();
            if (this.groupSortConfig != null && this.groupSortConfig.size() > 0) {
                this.sortByGroups(colIndex, sortType);
            } else {
                Collections.sort(rows, new TableCellComparator(this.colIndex, sortType));
            }
            this.table.setRefresh(refresh);
        } else {
            this.changeHeadStatus(this.colIndex, colIndex, sortType);
        }
    }

    static class TableCellComparator
    implements Comparator {
        int colIndex = 0;
        int sortType;
        Collator comparator = Collator.getInstance(Locale.getDefault());

        public TableCellComparator(int i, int sortType) {
            this.colIndex = i;
            this.sortType = sortType;
        }

        public int compare(Object kdtRow1, Object kdtRow2) {
            int result = this.doCompare(kdtRow1, kdtRow2);
            if (this.sortType == 0) {
                return result;
            }
            if (result < 0) {
                return 1;
            }
            if (result > 0) {
                return -1;
            }
            return result;
        }

        public int doCompare(Object kdtRow1, Object kdtRow2) {
            Object o1 = null;
            Object o2 = null;
            KDTCell cell = ((KDTRow)kdtRow1).getCell(this.colIndex);
            if (cell != null) {
                o1 = cell.getValue();
            }
            if ((cell = ((KDTRow)kdtRow2).getCell(this.colIndex)) != null) {
                o2 = cell.getValue();
            }
            if (o1 == o2) {
                return 0;
            }
            if (o1 == null && o2 != null) {
                return -1;
            }
            if (o1 != null && o2 == null) {
                return 1;
            }
            if (o1 instanceof MaterialInfo) {
                if (o2 instanceof MaterialInfo) {
                    return ((MaterialInfo)o1).getNumber().compareTo(((MaterialInfo)o2).getNumber());
                }
                return o1.toString().compareTo(o2.toString());
            }
            if (o1 instanceof Number) {
                if (o2 instanceof Number) {
                    double d2;
                    double d1 = ((Number)o1).doubleValue();
                    if (d1 == (d2 = ((Number)o2).doubleValue())) {
                        return 0;
                    }
                    if (d1 < d2) {
                        return -1;
                    }
                    return 1;
                }
                return o1.toString().compareTo(o2.toString());
            }
            if (o1 instanceof String) {
                if (o2 instanceof String) {
                    return this.comparator.compare(o1, o2);
                }
                return ((String)o1).compareTo(o2.toString());
            }
            if (o1 instanceof Date) {
                if (o2 instanceof Date) {
                    return ((Date)o1).compareTo((Date)o2);
                }
                return o1.toString().compareTo(o2.toString());
            }
            if (o1 instanceof Calendar) {
                if (o2 instanceof Calendar) {
                    long d2;
                    long d1 = ((Calendar)o1).getTimeInMillis();
                    if (d1 == (d2 = ((Calendar)o2).getTimeInMillis())) {
                        return 0;
                    }
                    if (d1 < d2) {
                        return -1;
                    }
                    return 1;
                }
                return o1.toString().compareTo(o2.toString());
            }
            if (o1 instanceof Comparable) {
                if (o2 instanceof Comparable) {
                    return ((Comparable)o1).compareTo((Comparable)o2);
                }
                return o1.toString().compareTo(o2.toString());
            }
            if (null != o1 && null != o2) {
                if (null == o1.toString() && null == o2.toString()) {
                    return 0;
                }
                if (null == o1.toString() && null != o2.toString()) {
                    return -1;
                }
                if (null != o1.toString() && null == o2.toString()) {
                    return 1;
                }
                return o1.toString().compareTo(o2.toString());
            }
            return 0;
        }
    }
}

