/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.arap.util;

import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.eas.basedata.org.CompanyOrgUnitCollection;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.fi.ar.ArApCommonException;
import com.kingdee.eas.fi.arap.util.ArApBillHelper;
import com.kingdee.util.StringUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class CollectionUtil {
    public static String SPLIT_COMMA = ",";

    private CollectionUtil() {
    }

    public static String toSqlString(Collection idList) {
        return ArApBillHelper.ids2SqlString(idList);
    }

    public static String ids2SqlString(Collection idList) throws ArApCommonException {
        return ArApBillHelper.ids2SqlString(idList);
    }

    public static String join(String[] array, String token) {
        StringBuffer sb = new StringBuffer();
        int len = array.length;
        for (int i = 0; i < len && array[i] != null; ++i) {
            if (i > 0) {
                sb.append(token);
            }
            sb.append(array[i]);
        }
        return sb.toString();
    }

    public static String join(Collection col, String token) {
        StringBuffer sb = new StringBuffer();
        Iterator iter = col.iterator();
        boolean isFirst = true;
        while (iter.hasNext()) {
            if (isFirst) {
                isFirst = false;
            } else {
                sb.append(token);
            }
            sb.append(iter.next());
        }
        return sb.toString();
    }

    public static Map toMap(IObjectCollection iObjCol) {
        HashMap<String, IObjectValue> map = new HashMap<String, IObjectValue>();
        IObjectValue iObjVal = null;
        int colSize = iObjCol.size();
        for (int i = 0; i < colSize; ++i) {
            iObjVal = iObjCol.getObject(i);
            map.put(iObjVal.get("id").toString(), iObjVal);
        }
        return map;
    }

    public static void addCollection(List<IObjectValue> list, IObjectCollection iObjCol) {
        if (list == null) {
            return;
        }
        IObjectValue iObjVal = null;
        int colSize = iObjCol.size();
        for (int i = 0; i < colSize; ++i) {
            iObjVal = iObjCol.getObject(i);
            list.add(iObjVal);
        }
    }

    public static void mapToCollection(IObjectCollection col, Map<String, Object> infoMap) {
        if (col == null) {
            return;
        }
        Iterator<Object> iter = infoMap.values().iterator();
        while (iter.hasNext()) {
            col.addObject((IObjectValue)iter.next());
        }
    }

    public static Set<String> toSet(String elements) {
        return CollectionUtil.toSet(elements, SPLIT_COMMA);
    }

    public static Set<String> toSet(String elements, String split) {
        HashSet<String> resultSet = null;
        if (StringUtils.isEmpty((String)elements) || StringUtils.isEmpty((String)split)) {
            return resultSet;
        }
        String[] elementArr = elements.split(split);
        resultSet = new HashSet<String>(elementArr.length);
        for (int i = 0; i < elementArr.length; ++i) {
            resultSet.add(elementArr[i]);
        }
        return resultSet;
    }

    public static List<FullOrgUnitInfo> toList(CompanyOrgUnitCollection companys) {
        ArrayList<FullOrgUnitInfo> companyList = null;
        if (companys != null) {
            companyList = new ArrayList<FullOrgUnitInfo>(companys.size());
            int n = companys.size();
            for (int i = 0; i < n; ++i) {
                CompanyOrgUnitInfo compInfo = companys.get(i);
                FullOrgUnitInfo orgInfo = new FullOrgUnitInfo();
                orgInfo.setId(compInfo.getId());
                orgInfo.setName(compInfo.getName());
                orgInfo.setNumber(compInfo.getNumber());
                companyList.add(orgInfo);
            }
        }
        return companyList;
    }
}

