/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.arap.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.ICurrency;
import com.kingdee.eas.basedata.assistant.MeasureUnitInfo;
import com.kingdee.eas.basedata.master.material.IMaterial;
import com.kingdee.eas.basedata.master.material.IMultiMeasureUnit;
import com.kingdee.eas.basedata.master.material.MaterialFactory;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.master.material.MultiMeasureUnitFactory;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.arap.util.NumericBizCalculator;
import java.math.BigDecimal;
import java.util.Hashtable;
import java.util.Map;

public abstract class PrecisionFormatUtils {
    private static Map currencyScals = new Hashtable();
    private static Map priceScals = new Hashtable();
    private static Map qtyScals = new Hashtable();

    public static String getFormatString(int precision) {
        StringBuffer buffer = new StringBuffer();
        for (int i = 0; i < precision; ++i) {
            buffer.append("0");
        }
        String precisionTag = buffer.toString();
        if (precisionTag.length() > 0) {
            precisionTag = "." + precisionTag;
        }
        String format = "#,##0" + precisionTag;
        return format;
    }

    public static String getFormatString(CurrencyInfo currencyInfo) {
        int precision = 0;
        if (currencyInfo == null) {
            precision = 2;
        } else {
            precision = currencyInfo.getPrecision();
            if (precision == 0) {
                precision = 2;
            }
        }
        return PrecisionFormatUtils.getFormatString(precision);
    }

    public static BigDecimal formatByPrecision(BigDecimal value, int scale) {
        return NumericBizCalculator.effectualNumeric(value).setScale(PrecisionFormatUtils.effectualPrecision(scale), 4);
    }

    public static BigDecimal formatByPrecision(BigDecimal value, int scale, int roundingMode) {
        int mode = roundingMode >= 0 ? roundingMode : 4;
        return NumericBizCalculator.effectualNumeric(value).setScale(PrecisionFormatUtils.effectualPrecision(scale), mode);
    }

    public static BigDecimal formatQtyByAssistUnitPrecision(BigDecimal qty, MaterialInfo material) throws EASBizException, BOSException {
        return NumericBizCalculator.effectualNumeric(qty).setScale(PrecisionFormatUtils.getAssistUnitPrecision(material), 4);
    }

    public static BigDecimal formatQtyByBaseUnitPrecision(BigDecimal qty, MaterialInfo material) throws EASBizException, BOSException {
        return NumericBizCalculator.effectualNumeric(qty).setScale(PrecisionFormatUtils.getBaseUnitPrecision(material), 4);
    }

    public static BigDecimal formatQtyByBaseUnitPrecision(BigDecimal qty, MaterialInfo material, MeasureUnitInfo unit) throws EASBizException, BOSException {
        return NumericBizCalculator.effectualNumeric(qty).setScale(PrecisionFormatUtils.getQuantityPrecision(material, unit), 4);
    }

    public static BigDecimal formatQtyByUnitPrecision(BigDecimal qty, String materialId, String unitId) throws EASBizException, BOSException {
        return NumericBizCalculator.effectualNumeric(qty).setScale(PrecisionFormatUtils.getQuantityPrecision(materialId, unitId), 4);
    }

    public static BigDecimal formatCurrencyPrecision(BigDecimal money, CurrencyInfo currency) throws EASBizException, BOSException {
        return NumericBizCalculator.effectualNumeric(money).setScale(PrecisionFormatUtils.getCurrencyPrecision(currency), 4);
    }

    public static BigDecimal formatCurrencyPrecision(BigDecimal money, CurrencyInfo currency, int roundingMode) throws EASBizException, BOSException {
        int mode = roundingMode >= 0 ? roundingMode : 4;
        return NumericBizCalculator.effectualNumeric(money).setScale(PrecisionFormatUtils.getCurrencyPrecision(currency), mode);
    }

    public static BigDecimal formatPricePrecision(BigDecimal price, MaterialInfo material) throws EASBizException, BOSException {
        return NumericBizCalculator.effectualNumeric(price).setScale(PrecisionFormatUtils.getMaterialPricePrecision(material), 4);
    }

    public static BigDecimal formatPricePrecision(BigDecimal price, MaterialInfo material, int roundingMode) throws EASBizException, BOSException {
        int mode = roundingMode >= 0 ? roundingMode : 4;
        return NumericBizCalculator.effectualNumeric(price).setScale(PrecisionFormatUtils.getMaterialPricePrecision(material), mode);
    }

    public static int effectualPrecision(int scale) {
        return PrecisionFormatUtils.isDistrust(scale) ? scale : 2;
    }

    public static boolean isDistrust(int scale) {
        return scale >= 0;
    }

    public static int getCurrencyPrecision(CurrencyInfo currency) throws BOSException, EASBizException {
        return PrecisionFormatUtils._getCurrencyPrecision(null, currency);
    }

    public static int getCurrencyPrecision(Context ctx, CurrencyInfo currency) throws EASBizException, BOSException {
        return PrecisionFormatUtils._getCurrencyPrecision(ctx, currency);
    }

    private static int _getCurrencyPrecision(Context ctx, CurrencyInfo currency) throws BOSException, EASBizException {
        int s = PrecisionFormatUtils.effectualPrecision(0);
        if (currency != null && currency.getId() != null) {
            String id = currency.getId().toString();
            int sc = currency.getPrecision();
            if (currencyScals.containsKey(id)) {
                s = Integer.parseInt(currencyScals.get(id).toString());
            } else if (!PrecisionFormatUtils.isDistrust(sc)) {
                ICurrency ie = null;
                ie = ctx == null ? CurrencyFactory.getRemoteInstance() : CurrencyFactory.getLocalInstance((Context)ctx);
                SelectorItemCollection selectors = new SelectorItemCollection();
                selectors.add(new SelectorItemInfo("id"));
                selectors.add(new SelectorItemInfo("precision"));
                CurrencyInfo cry = ie.getCurrencyInfo((IObjectPK)new ObjectStringPK(id), selectors);
                if (cry != null) {
                    s = PrecisionFormatUtils.effectualPrecision(cry.getPrecision());
                    currencyScals.put(id, new Integer(s));
                }
            } else {
                s = sc;
                currencyScals.put(id, new Integer(s));
            }
        }
        return s;
    }

    public static int getMaterialPricePrecision(MaterialInfo material) throws BOSException, EASBizException {
        return PrecisionFormatUtils._getMaterialPricePrecision(null, material);
    }

    public static int getMaterialPricePrecision(Context ctx, MaterialInfo material) throws BOSException, EASBizException {
        return PrecisionFormatUtils._getMaterialPricePrecision(ctx, material);
    }

    private static int _getMaterialPricePrecision(Context ctx, MaterialInfo material) throws BOSException, EASBizException {
        int s = PrecisionFormatUtils.effectualPrecision(0);
        if (material != null && material.getId() != null) {
            String id = material.getId().toString();
            int sc = material.getPricePrecision();
            if (priceScals.containsKey(id)) {
                s = Integer.parseInt(priceScals.get(id).toString());
            } else if (!PrecisionFormatUtils.isDistrust(sc)) {
                IMaterial ie = null;
                ie = ctx == null ? MaterialFactory.getRemoteInstance() : MaterialFactory.getLocalInstance((Context)ctx);
                SelectorItemCollection selectors = new SelectorItemCollection();
                selectors.add(new SelectorItemInfo("id"));
                selectors.add(new SelectorItemInfo("pricePrecision"));
                MaterialInfo mp = ie.getMaterialInfo((IObjectPK)new ObjectStringPK(id), selectors);
                if (mp != null) {
                    s = PrecisionFormatUtils.effectualPrecision(mp.getPricePrecision());
                    priceScals.put(id, new Integer(s));
                }
            } else {
                s = sc;
                priceScals.put(id, new Integer(s));
            }
        }
        return s;
    }

    public static int getAssistUnitPrecision(MaterialInfo material) throws BOSException, EASBizException {
        return 2;
    }

    public static int getAssistUnitPrecision(Context ctx, MaterialInfo material) throws BOSException, EASBizException {
        return 2;
    }

    public static int getBaseUnitPrecision(MaterialInfo material) throws BOSException, EASBizException {
        return PrecisionFormatUtils.getQuantityPrecision(material, null);
    }

    public static int getBaseUnitPrecision(Context ctx, MaterialInfo material) throws BOSException, EASBizException {
        return PrecisionFormatUtils.getQuantityPrecision(ctx, material, null);
    }

    public static int getQuantityPrecision(Context ctx, MaterialInfo material, MeasureUnitInfo unit) throws BOSException, EASBizException {
        return PrecisionFormatUtils._getQuantityPrecision(ctx, material, unit);
    }

    public static int getQuantityPrecision(MaterialInfo material, MeasureUnitInfo unit) throws BOSException, EASBizException {
        return PrecisionFormatUtils._getQuantityPrecision(null, material, unit);
    }

    public static int getQuantityPrecision(String materialId, String unitId) throws BOSException, EASBizException {
        return PrecisionFormatUtils.getQuantityPrecision(null, materialId, unitId);
    }

    public static int getQuantityPrecision(Context ctx, String materialId, String unitId) throws BOSException, EASBizException {
        MaterialInfo material = new MaterialInfo();
        material.setId(BOSUuid.read((String)materialId));
        MeasureUnitInfo unit = new MeasureUnitInfo();
        unit.setId(BOSUuid.read((String)unitId));
        return PrecisionFormatUtils._getQuantityPrecision(ctx, material, unit);
    }

    private static int _getQuantityPrecision(Context ctx, MaterialInfo material, MeasureUnitInfo unit) throws BOSException, EASBizException {
        int s = PrecisionFormatUtils.effectualPrecision(0);
        if (material != null && material.getId() != null) {
            String unitId = null;
            String materialId = material.getId().toString();
            if (unit != null && unit.getId() != null) {
                unitId = unit.getId().toString();
            } else if (material.getBaseUnit() != null && material.getBaseUnit().getId() != null) {
                unitId = material.getBaseUnit().getId().toString();
            }
            if (unitId != null && unitId.trim().length() != 0) {
                int sc = -1;
                if (qtyScals.containsKey(materialId)) {
                    Hashtable<String, Integer> ls = (Hashtable<String, Integer>)qtyScals.get(materialId);
                    if (ls != null && ls.containsKey(unitId)) {
                        s = Integer.parseInt(ls.get(unitId).toString());
                    } else {
                        sc = PrecisionFormatUtils._getQuantityPrecisionFromServer(ctx, materialId, unitId);
                        if (PrecisionFormatUtils.isDistrust(sc)) {
                            s = sc;
                            if (ls == null) {
                                ls = new Hashtable<String, Integer>();
                            }
                            ls.put(unitId, new Integer(s));
                        }
                    }
                } else {
                    sc = PrecisionFormatUtils._getQuantityPrecisionFromServer(ctx, materialId, unitId);
                    if (PrecisionFormatUtils.isDistrust(sc)) {
                        s = sc;
                        Hashtable<String, Integer> ls = new Hashtable<String, Integer>();
                        ls.put(unitId, new Integer(s));
                        qtyScals.put(materialId, ls);
                    }
                }
            }
        }
        return s;
    }

    private static int _getQuantityPrecisionFromServer(Context ctx, String materialId, String unitId) throws BOSException, EASBizException {
        IMultiMeasureUnit ie = null;
        ie = ctx == null ? MultiMeasureUnitFactory.getRemoteInstance() : MultiMeasureUnitFactory.getLocalInstance((Context)ctx);
        return ie.getQtyPrecision(materialId, unitId);
    }
}

