/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.sd.sale.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.framework.ejb.BizController;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.dynbusiness.adv.chain.app.BusinessChainExecutingHelper;
import com.kingdee.eas.dynbusiness.app.processor.ApplicationContext;
import com.kingdee.eas.dynbusiness.util.BusinessProcessUtil;
import com.kingdee.eas.fi.ar.ArApCommonException;
import com.kingdee.eas.fi.arap.ARAPScmOrderException;
import com.kingdee.eas.fi.cas.ReceivingBillEntryFactory;
import com.kingdee.eas.fi.cas.ReceivingBillEntryInfo;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.CoreBillBaseInfo;
import com.kingdee.eas.framework.batchaction.BatchActionEnum;
import com.kingdee.eas.framework.batchaction.BatchActionResults;
import com.kingdee.eas.framework.report.util.DBUtilx;
import com.kingdee.eas.framework.report.util.RptRowSet;
import com.kingdee.eas.framework.report.util.SqlParams;
import com.kingdee.eas.scm.PaymentReceivingMatchBusinessProcessorBuilder;
import com.kingdee.eas.scm.sd.sale.ReceivingMatchCollection;
import com.kingdee.eas.scm.sd.sale.ReceivingMatchEntryInfo;
import com.kingdee.eas.scm.sd.sale.ReceivingMatchFactory;
import com.kingdee.eas.scm.sd.sale.ReceivingMatchInfo;
import com.kingdee.eas.scm.sd.sale.app.AbstractReceivingMatchControllerBean;
import com.kingdee.util.db.SQLUtils;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Date;
import java.util.HashSet;
import org.apache.log4j.Logger;

public class ReceivingMatchControllerBean
extends AbstractReceivingMatchControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.scm.sd.sale.app.ReceivingMatchControllerBean");
    private static final BigDecimal zero = new BigDecimal("0");

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected void _antiMatch(Context ctx, String orderId) throws BOSException, EASBizException {
        ReceivingMatchInfo receivingMatchInfo = this._getMatchInfo(ctx, orderId);
        if (receivingMatchInfo.isIsAudit()) {
            throw new ARAPScmOrderException(ARAPScmOrderException.ORDER_MATCH_HAS_AUDITED_REFUSE_ANTIMATCH);
        }
        ApplicationContext applicationContext = new ApplicationContext();
        applicationContext.putData("saleOrderID", (Object)orderId);
        BatchActionResults batchResults = BusinessChainExecutingHelper.batchExecute((Context)ctx, (BizController)this, (BOSObjectType)this.getBOSType(), (Object[])new Object[]{orderId}, (BatchActionEnum)PaymentReceivingMatchBusinessProcessorBuilder.RECEIVING_UN_MATCH, PaymentReceivingMatchBusinessProcessorBuilder.class, (ApplicationContext)applicationContext);
        Connection con = null;
        PreparedStatement statement = null;
        String sp = "\r\n";
        try {
            con = this.getConnection(ctx);
            StringBuffer sql = new StringBuffer();
            sql.append(" update t_sd_saleorderentry set fpreReceived = isnull(( select isnull(sum(re.famount),0) ").append(sp);
            sql.append(" from T_CAS_ReceivingBillEntry re inner join  T_CAS_ReceivingBill  r on re.FRECEIVINGBILLID = r.fid ").append(sp);
            sql.append(" where re.fcorebillid = ? ");
            sql.append(" and re.frecbilltypeid in ('DAWSqQEREADgAAILwKgSfCqo2zU=' ,'DAWSqQEREADgAAIswKgSfCqo2zU=') ");
            sql.append(" and t_sd_saleorderentry.fid = re.fcorebillentryid");
            sql.append(" and r.FBILLSTATUS = 14");
            sql.append(" group by fcorebillentryid  ),0)");
            sql.append(" where fparentid = ? ");
            statement = con.prepareStatement(sql.toString());
            String orderIDStr = orderId;
            statement.setString(1, orderIDStr);
            statement.setString(2, orderIDStr);
            statement.executeUpdate();
            sql.setLength(0);
            sql.append(" update t_sd_saleorderentry set funPrereceivedAmount = isnull(fprepayment,0) - isnull(fpreReceived,0) ");
            sql.append(" where fparentid = ? ");
            statement = con.prepareStatement(sql.toString());
            statement.setString(1, orderIDStr);
            statement.executeUpdate();
        }
        catch (SQLException er) {
            try {
                throw new BOSException("sql Execute Error :", (Throwable)er);
                catch (BOSException e) {
                    throw new BOSException((Throwable)e);
                }
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(statement, (Connection)con);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)statement, (Connection)con);
        CoreBaseCollection cc = new CoreBaseCollection();
        int i = 0;
        while (true) {
            if (i >= receivingMatchInfo.getEntrys().size()) {
                ReceivingBillEntryFactory.getLocalInstance((Context)ctx).update(cc);
                this._delete(ctx, (IObjectPK)new ObjectUuidPK(receivingMatchInfo.getId()));
                return;
            }
            ReceivingMatchEntryInfo receivingMatchEntryInfo = receivingMatchInfo.getEntrys().get(i);
            ReceivingBillEntryInfo receivingBillEntryInfo = receivingMatchEntryInfo.getReceivingBillEntry();
            receivingBillEntryInfo.setMatchedAmount(receivingBillEntryInfo.getMatchedAmount().subtract(receivingMatchEntryInfo.getAmount()));
            this.setMatchedAmountLocByRate(receivingBillEntryInfo);
            cc.add((CoreBaseInfo)receivingBillEntryInfo);
            ++i;
        }
    }

    private void setMatchedAmountLocByRate(ReceivingBillEntryInfo receivingBillEntryInfo) {
        BigDecimal amount = receivingBillEntryInfo.getAmount();
        if (amount != null && amount.doubleValue() > 0.0) {
            int scan = amount.scale() + 1;
            if (scan < 3) {
                scan = 3;
            }
            BigDecimal rate = receivingBillEntryInfo.getActualLocAmt().divide(amount, scan, 4);
            receivingBillEntryInfo.setMatchedAmountLoc(receivingBillEntryInfo.getMatchedAmount().multiply(rate));
        }
    }

    @Override
    protected void _match(Context ctx, String orderId, ReceivingMatchInfo receivingMatchInfo) throws BOSException, EASBizException {
        receivingMatchInfo.setMatchDate(new Date());
        receivingMatchInfo.setSourceBillId(receivingMatchInfo.getSaleOrderID());
        ApplicationContext applicationContext = new ApplicationContext();
        applicationContext.putData("saleOrderID", (Object)receivingMatchInfo.getSaleOrderID());
        applicationContext.putData("matchedAmount", (Object)receivingMatchInfo.getAmount());
        BatchActionResults batchResults = BusinessChainExecutingHelper.batchExecute((Context)ctx, (BizController)this, (BOSObjectType)this.getBOSType(), (Object[])new Object[]{receivingMatchInfo.getSaleOrderID()}, (BatchActionEnum)PaymentReceivingMatchBusinessProcessorBuilder.RECEIVING_MATCH, PaymentReceivingMatchBusinessProcessorBuilder.class, (ApplicationContext)applicationContext);
        HashSet<String> idSet = new HashSet<String>();
        int n = receivingMatchInfo.getEntrys().size();
        for (int i = 0; i < n; ++i) {
            idSet.add(receivingMatchInfo.getEntrys().get(i).getReceivingBillEntry().getId().toString());
        }
        EntityViewInfo ev = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        ev.setFilter(filterInfo);
        filterInfo.getFilterItems().add(new FilterItemInfo("id", idSet, CompareType.INCLUDE));
        CoreBaseCollection receivingMatchColl = ReceivingBillEntryFactory.getLocalInstance((Context)ctx).getCollection(ev);
        ReceivingMatchEntryInfo matcheEntryInfo = null;
        ReceivingBillEntryInfo receivingEntryInfo = null;
        int size = receivingMatchInfo.getEntrys().size();
        for (int i = 0; i < size; ++i) {
            matcheEntryInfo = receivingMatchInfo.getEntrys().get(i);
            receivingEntryInfo = this.getReceivingBillEntryInfo(matcheEntryInfo.getReceivingBillEntry().getId().toString(), receivingMatchColl);
            receivingEntryInfo.setMatchedAmount(receivingEntryInfo.getMatchedAmount().add(matcheEntryInfo.getAmount()));
            if (receivingEntryInfo.getMatchedAmount().compareTo(receivingEntryInfo.getAmount()) > 0) {
                throw new ArApCommonException(ArApCommonException.MATCHEDAMOUNT_OVER_AMOUNT_181);
            }
            this.setMatchedAmountLocByRate(receivingEntryInfo);
        }
        ReceivingBillEntryFactory.getLocalInstance((Context)ctx).update(receivingMatchColl);
        this.addnew(ctx, receivingMatchInfo);
    }

    private ReceivingBillEntryInfo getReceivingBillEntryInfo(String id, CoreBaseCollection cc) {
        int n = cc.size();
        for (int i = 0; i < n; ++i) {
            ReceivingBillEntryInfo info = (ReceivingBillEntryInfo)cc.get(i);
            if (!id.equals(info.getId().toString())) continue;
            return info;
        }
        return null;
    }

    @Override
    protected ReceivingMatchInfo _getMatchInfo(Context ctx, String orderId) throws BOSException, EASBizException {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("saleOrderId", (Object)orderId));
        view.setFilter(filter);
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add("*");
        selector.add("entrys.*");
        selector.add("entrys.receivingBillEntry.*");
        selector.add("entrys.receivingBillEntry.receivingBill.*");
        selector.add("entrys.receivingBillEntry.receivingBill.number");
        selector.add("entrys.receivingBillEntry.receivingBill.payerName");
        selector.add("entrys.receivingBillEntry.receivingBill.payerType.*");
        view.setSelector(selector);
        ReceivingMatchCollection mc = ReceivingMatchFactory.getLocalInstance((Context)ctx).getReceivingMatchCollection(view);
        ReceivingMatchInfo receivingMatchInfo = mc.size() > 0 ? mc.get(0) : new ReceivingMatchInfo();
        return receivingMatchInfo;
    }

    @Override
    protected boolean _haveMatchRecord(Context ctx, String orderId, String receivingBillId, String receivingBillEntryId) throws BOSException, EASBizException {
        StringBuffer sql = new StringBuffer();
        sql.append("select count(1) cc from T_CAS_RECEIVINGMATCH A").append(" inner join T_CAS_RECEIVINGMATCHENTRY B on B.Fparentid=A.FID").append(" inner join T_CAS_RECEIVINGBILLENTRY C on C.Fid=B.FRECEIVINGBILLENTRYID").append(" where 1=1");
        SqlParams sp = new SqlParams();
        if (orderId != null) {
            sql.append(" and A.FSaleOrderId=?");
            sp.addString(orderId);
        }
        if (receivingBillId != null) {
            sql.append(" and C.FReceivingBillId=?");
            sp.addString(receivingBillId);
        }
        if (receivingBillEntryId != null) {
            sql.append(" and C.FID=?");
            sp.addString(receivingBillEntryId);
        }
        try {
            RptRowSet rs = DBUtilx.executeQuery((String)sql.toString(), (SqlParams)sp, (Context)ctx);
            rs.next();
            return rs.getInt("cc") > 0;
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
    }

    @Override
    protected boolean _haveMatchRecords(Context ctx, String[] orderIds, String[] receivingBillIds, String[] receivingBillEntryIds) throws BOSException, EASBizException {
        StringBuffer sql = new StringBuffer();
        sql.append("select count(1) cc from T_CAS_RECEIVINGMATCH A").append(" inner join T_CAS_RECEIVINGMATCHENTRY B on B.Fparentid=A.FID").append(" inner join T_CAS_RECEIVINGBILLENTRY C on C.Fid=B.FRECEIVINGBILLENTRYID").append(" where 1=1");
        SqlParams sp = new SqlParams();
        this.appendHaveMatchRecordsOrFilter("A.FSaleOrderId", orderIds, sql, sp);
        this.appendHaveMatchRecordsOrFilter("C.FReceivingBillId", receivingBillIds, sql, sp);
        this.appendHaveMatchRecordsOrFilter("C.FID", receivingBillEntryIds, sql, sp);
        try {
            RptRowSet rs = DBUtilx.executeQuery((String)sql.toString(), (SqlParams)sp, (Context)ctx);
            rs.next();
            return rs.getInt("cc") > 0;
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
    }

    private void appendHaveMatchRecordsOrFilter(String linkField, String[] values, StringBuffer sql, SqlParams sp) {
        int n;
        if (values != null && (n = values.length) > 0) {
            sql.append(" and (");
            for (int i = 0; i < n; ++i) {
                sql.append(linkField).append("=?");
                sp.addString(values[i]);
                if (i == n - 1) continue;
                sql.append(" or ");
            }
            sql.append(")");
        }
    }

    @Override
    protected void _audit(Context ctx, String orderId) throws BOSException, EASBizException {
        ReceivingMatchInfo mm = this._getMatchInfo(ctx, orderId);
        String saleOrderId = mm.getSaleOrderID();
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("number"));
        CoreBillBaseInfo saleOrder = (CoreBillBaseInfo)BusinessProcessUtil.getValueByBosType((Context)ctx, (IObjectPK)new ObjectUuidPK(saleOrderId), (SelectorItemCollection)sic);
        if (mm.getId() != null) {
            if (mm.isIsAudit()) {
                throw new ARAPScmOrderException(ARAPScmOrderException.ORDER_MATCH_HAS_AUDITED, new String[]{saleOrder.getNumber()});
            }
            UserInfo user = new UserInfo();
            user.setId(BOSUuid.read((String)ctx.getCaller().toString()));
            mm.setAuditor(user);
            mm.setIsAudit(true);
            ReceivingMatchFactory.getLocalInstance((Context)ctx).save((CoreBaseInfo)mm);
        }
    }

    @Override
    protected void _antiAudit(Context ctx, String orderId) throws BOSException, EASBizException {
        ReceivingMatchInfo mm = this._getMatchInfo(ctx, orderId);
        String saleOrderId = mm.getSaleOrderID();
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("number"));
        CoreBillBaseInfo saleOrder = (CoreBillBaseInfo)BusinessProcessUtil.getValueByBosType((Context)ctx, (IObjectPK)new ObjectUuidPK(saleOrderId), (SelectorItemCollection)sic);
        if (mm.getId() != null) {
            if (!mm.isIsAudit()) {
                throw new ARAPScmOrderException(ARAPScmOrderException.ORDER_MATCH_HAS_UNAUDITED, new String[]{saleOrder.getNumber()});
            }
            UserInfo user = new UserInfo();
            user.setId(BOSUuid.read((String)ctx.getCaller().toString()));
            mm.setAuditor(user);
            mm.setIsAudit(false);
            ReceivingMatchFactory.getLocalInstance((Context)ctx).save((CoreBaseInfo)mm);
        }
    }

    @Override
    protected boolean _haveAudited(Context ctx, String orderId) throws BOSException, EASBizException {
        String sql = "select FIsAudit from t_cas_receivingmatch where FSaleOrderID=?";
        SqlParams sp = new SqlParams().addString(orderId);
        try {
            RptRowSet rs = DBUtilx.executeQuery((String)sql, (SqlParams)sp, (Context)ctx);
            if (rs.next()) {
                return rs.getInt("FIsAudit") == 1;
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        return false;
    }

    @Override
    protected void _batchAntiAudit(Context ctx, String[] pks) throws BOSException, EASBizException {
        int size = pks.length;
        for (int i = 0; i < size; ++i) {
            this._antiAudit(ctx, pks[i].toString());
        }
    }

    @Override
    protected void _batchAudit(Context ctx, String[] pks) throws BOSException, EASBizException {
        int size = pks.length;
        for (int i = 0; i < size; ++i) {
            this._audit(ctx, pks[i].toString());
        }
    }
}

