/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.arap_tax;

import com.kingdee.eas.util.client.EASResource;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;

public class FormulaUtil {
    private int leftBracket = 0;
    private int rightBracket = 0;
    private int startL = 0;
    private int startR = 0;
    private BigDecimal answer = new BigDecimal("0.0");
    private String leftNumber = "0";
    private String rightNumber = "0";
    public String Msg = "";
    int[] sym = new int[4];
    Vector list = new Vector();
    boolean debug = false;
    public String resClassName = "com.kingdee.eas.fi.ar.ArReport";

    private int getLeftBracket(String calRule) {
        this.leftBracket = 0;
        this.startL = calRule.indexOf("(");
        if (this.startL != -1) {
            calRule = calRule.substring(this.startL + 1, calRule.length());
        }
        while (this.startL != -1) {
            ++this.leftBracket;
            this.startL = calRule.indexOf("(");
            calRule = calRule.substring(this.startL + 1, calRule.length());
        }
        return this.leftBracket;
    }

    private void setLeftBracket(int leftBracket) {
        this.leftBracket = leftBracket;
    }

    private int getRightBracket(String calRule) {
        this.rightBracket = 0;
        this.startR = calRule.indexOf(")");
        if (this.startR != -1) {
            calRule = calRule.substring(this.startR + 1, calRule.length());
        }
        while (this.startR != -1) {
            ++this.rightBracket;
            this.startR = calRule.indexOf(")");
            calRule = calRule.substring(this.startR + 1, calRule.length());
        }
        return this.rightBracket;
    }

    private void setRightBracket(int rightBracket) {
        this.rightBracket = rightBracket;
    }

    private boolean compareToLR(String calRule) {
        int lb = this.getLeftBracket(calRule);
        int rb = this.getRightBracket(calRule);
        boolean CTLR = false;
        if (lb == rb) {
            this.Msg = EASResource.getString((String)this.resClassName, (String)"taxformula_1");
            CTLR = true;
        } else if (lb > rb) {
            this.Msg = EASResource.getString((String)this.resClassName, (String)"taxformula_2");
            CTLR = false;
        } else {
            this.Msg = EASResource.getString((String)this.resClassName, (String)"taxformula_3");
            CTLR = false;
        }
        return CTLR;
    }

    public BigDecimal ComputValue(String strval) throws Exception {
        String strvalst = strval;
        if (null == strval) {
            return new BigDecimal("0");
        }
        if (strval.charAt(strval.length() - 1) != ')') {
            strvalst = "(" + strvalst + ")";
        }
        this.formulaString(strvalst);
        return this.parseString();
    }

    private void formulaString(String calRule) throws Exception {
        String formulaStr = "";
        if (this.compareToLR(calRule)) {
            for (int i = 0; i < this.leftBracket; ++i) {
                formulaStr = calRule.substring(calRule.lastIndexOf("(") + 1, calRule.indexOf(")", calRule.lastIndexOf("("))).trim();
                this.symbolParse(formulaStr);
                BigDecimal value = this.parseString();
                if (!this.debug) continue;
                calRule = calRule.substring(0, calRule.lastIndexOf("(")).trim() + value + calRule.substring(calRule.indexOf(")", calRule.lastIndexOf("(")) + 1, calRule.length()).trim();
            }
        } else {
            throw new Exception("formula error");
        }
    }

    public List getFieldParsed(String formula) {
        if (null == formula) {
            return null;
        }
        String strFormula = formula.trim();
        if (strFormula.length() == 0) {
            return null;
        }
        String field = "";
        ArrayList<String> list = new ArrayList<String>();
        strFormula = strFormula.replace('(', '~');
        strFormula = strFormula.replace(')', '~');
        strFormula = strFormula.replace('+', '~');
        strFormula = strFormula.replace('-', '~');
        strFormula = strFormula.replace('*', '~');
        strFormula = strFormula.replace('/', '~');
        String[] s = strFormula.split("~");
        for (int idx = 0; idx < s.length; ++idx) {
            field = s[idx];
            try {
                if (field.trim().length() <= 0) continue;
                Double.parseDouble(field);
                continue;
            }
            catch (Exception e) {
                list.add(field.trim());
            }
        }
        return list;
    }

    public boolean validateFormula(String formula) {
        if (null == formula || formula.trim().length() == 0) {
            return false;
        }
        List list = this.getFieldParsed(formula);
        String s_ = formula;
        int cnt = list.size();
        for (int idx = 0; idx < cnt; ++idx) {
            s_ = s_.replaceAll(list.get(idx).toString(), " 1.68686 ");
        }
        try {
            this.ComputValue(s_);
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    private void symbolParse(String str) {
        this.list.clear();
        this.compareMin(str);
        for (int i = 0; i < 4; ++i) {
            while (this.sym[i] != -1) {
                String insStr = str.substring(0, this.sym[i]).trim();
                this.list.add(insStr);
                insStr = str.substring(this.sym[i], this.sym[i] + 1).trim();
                this.list.add(insStr);
                str = str.substring(this.sym[i] + 1, str.length()).trim();
                this.compareMin(str);
            }
        }
        if (this.sym[0] == -1 && this.sym[1] == -1 && this.sym[2] == -1 & this.sym[3] == -1) {
            this.list.add(str);
        }
    }

    private void compareMin(String str) {
        int spm;
        int spd;
        int spa;
        int sps = str.indexOf("-");
        int n = this.sym[0] = sps == 0 ? -1 : sps;
        if (sps == 0 && (sps = str.indexOf("-", 1)) > 0) {
            this.sym[0] = sps;
        }
        this.sym[1] = spa = str.indexOf("+");
        this.sym[2] = spd = str.indexOf("/");
        this.sym[3] = spm = str.indexOf("*");
        for (int i = 1; i < this.sym.length; ++i) {
            for (int j = 0; j < this.sym.length - i; ++j) {
                if (this.sym[j] <= this.sym[j + 1]) continue;
                int temp = this.sym[j];
                this.sym[j] = this.sym[j + 1];
                this.sym[j + 1] = temp;
            }
        }
    }

    public BigDecimal parseString() throws NumberFormatException, StringIndexOutOfBoundsException {
        this.calculate();
        return this.answer;
    }

    private void calculate() {
        int spd = this.list.indexOf("/");
        while (spd != -1) {
            this.leftNumber = this.list.get(spd - 1).toString();
            this.rightNumber = this.list.get(spd + 1).toString();
            this.list.remove(spd - 1);
            this.list.remove(spd - 1);
            this.list.remove(spd - 1);
            BigDecimal ln = new BigDecimal(this.leftNumber);
            BigDecimal rn = new BigDecimal(this.rightNumber);
            BigDecimal answer = ln.divide(rn, 10, 4);
            this.list.add(spd - 1, String.valueOf(answer.toString()));
            spd = this.list.indexOf("/");
        }
        int spm = this.list.indexOf("*");
        while (spm != -1) {
            this.leftNumber = this.list.get(spm - 1).toString();
            this.rightNumber = this.list.get(spm + 1).toString();
            this.list.remove(spm - 1);
            this.list.remove(spm - 1);
            this.list.remove(spm - 1);
            BigDecimal ln = new BigDecimal(this.leftNumber);
            BigDecimal rn = new BigDecimal(this.rightNumber);
            BigDecimal answer = ln.multiply(rn);
            this.list.add(spm - 1, String.valueOf(answer.toString()));
            spm = this.list.indexOf("*");
        }
        int sps = this.list.indexOf("-");
        while (sps != -1) {
            this.leftNumber = this.list.get(sps - 1).toString();
            this.rightNumber = this.list.get(sps + 1).toString();
            this.list.remove(sps - 1);
            this.list.remove(sps - 1);
            this.list.remove(sps - 1);
            BigDecimal ln = new BigDecimal(this.leftNumber);
            BigDecimal rn = new BigDecimal(this.rightNumber);
            BigDecimal answer = ln.subtract(rn);
            this.list.add(sps - 1, String.valueOf(answer.toString()));
            sps = this.list.indexOf("-");
        }
        int spa = this.list.indexOf("+");
        while (spa != -1) {
            this.leftNumber = this.list.get(spa - 1).toString();
            this.rightNumber = this.list.get(spa + 1).toString();
            this.list.remove(spa - 1);
            this.list.remove(spa - 1);
            this.list.remove(spa - 1);
            BigDecimal ln = new BigDecimal(this.leftNumber);
            BigDecimal rn = new BigDecimal(this.rightNumber);
            BigDecimal answer = ln.add(rn);
            this.list.add(spa - 1, String.valueOf(answer.toString()));
            spa = this.list.indexOf("+");
        }
        if (this.list.size() != 0) {
            String result = this.list.get(0).toString();
            if (result == null || result.length() == 0) {
                result = "0";
            }
            this.answer = new BigDecimal(this.list.get(0).toString());
        }
    }
}

