/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.arap_tax;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.swing.util.SimpleFileFilter;
import com.kingdee.eas.fi.arap_tax.DataParse;
import com.kingdee.eas.fi.arap_tax.GTaxImportLog;
import com.kingdee.eas.fi.arap_tax.ImportExportException;
import com.kingdee.eas.fi.arap_tax.TaxDataTransformer;
import com.kingdee.eas.fi.arap_tax.TaxEnumUtil;
import com.kingdee.eas.fi.arap_tax.TaxFileTypeEnum;
import com.kingdee.eas.fi.arap_tax.TaxForeignHeadEnum;
import com.kingdee.eas.fi.arap_tax.TaxQualifySymbolEnum;
import com.kingdee.eas.fi.arap_tax.TaxRelationEntryCollection;
import com.kingdee.eas.fi.arap_tax.TaxRelationInfo;
import com.kingdee.eas.fi.arap_tax.TaxSeparatorTepeEnum;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.apache.log4j.Logger;

public class GTaxImporter {
    private static final Logger logger = Logger.getLogger(GTaxImporter.class);
    private TaxRelationInfo relationInfo = null;
    private FileReader fReader = null;
    private BufferedReader buffReader = null;
    private String seperator = null;
    private String qualifySymbol = null;
    private List gTaxEntryFields = new ArrayList();
    private List gTaxDiscountFields = new ArrayList();
    private DataParse dp;

    public GTaxImporter(TaxRelationInfo rInfo) {
        if (rInfo == null) {
            throw new IllegalArgumentException("please specify the relationInfo.");
        }
        this.relationInfo = rInfo;
        this.init();
    }

    private void init() {
        TaxSeparatorTepeEnum sepType = this.relationInfo.getSeparatortype();
        TaxQualifySymbolEnum qualifySymboType = this.relationInfo.getQualifySymbolType();
        if (sepType.equals((Object)TaxSeparatorTepeEnum.Lumpy)) {
            this.seperator = "~~";
        } else if (sepType.equals((Object)TaxSeparatorTepeEnum.Tab)) {
            this.seperator = "\t";
        } else if (TaxSeparatorTepeEnum.Space.equals((Object)sepType)) {
            this.seperator = " ";
        } else if (sepType.equals((Object)TaxSeparatorTepeEnum.Other)) {
            this.seperator = this.relationInfo.getSeparator();
        }
        if (TaxQualifySymbolEnum.SingleQuotes.equals((Object)qualifySymboType)) {
            this.qualifySymbol = "'";
        } else if (TaxQualifySymbolEnum.DoubleQuotes.equals((Object)qualifySymboType)) {
            this.qualifySymbol = "\"";
        } else if (TaxQualifySymbolEnum.Other.equals((Object)qualifySymboType)) {
            this.qualifySymbol = this.relationInfo.getQualifySymbol();
        }
        this.dp = new DataParse(this.seperator, this.qualifySymbol);
        this.initFields();
    }

    private void initFields() {
        this.gTaxEntryFields = TaxEnumUtil.getEntryProductFieldList();
        this.gTaxDiscountFields = TaxEnumUtil.getEntryDiscountFieldList();
    }

    public GTaxImportLog importData(File dataFile) throws IOException, ImportExportException {
        TaxFileTypeEnum fileType = this.relationInfo.getFiletype();
        SimpleFileFilter filter = new SimpleFileFilter(fileType.getName());
        if (!filter.accept(dataFile)) {
            logger.error((Object)("the file type is not right, specified fileType: " + (Object)((Object)fileType) + ", supplied file:" + dataFile));
            throw new ImportExportException(ImportExportException.FILE_INVALID);
        }
        GTaxImportLog importLog = new GTaxImportLog();
        try {
            this.fReader = new FileReader(dataFile);
            this.buffReader = new BufferedReader(this.fReader);
            this.processData(importLog);
        }
        catch (FileNotFoundException ex) {
            logger.error((Object)"the specified data file is not exist.");
            throw new ImportExportException(ImportExportException.FILE_INVALID);
        }
        catch (IOException ex) {
            throw ex;
        }
        finally {
            this.cleanRes();
        }
        importLog.endTime = new Date();
        return importLog;
    }

    private void processData(GTaxImportLog importLog) throws IOException, ImportExportException {
        TaxDataTransformer bizAction = new TaxDataTransformer(this.relationInfo);
        String sData = null;
        int lineNumber = 0;
        while ((sData = this.buffReader.readLine()) != null) {
            ++lineNumber;
            if (sData.indexOf("//") == 0) continue;
            HashMap billRaw = null;
            billRaw = this.toBillRaw(sData, lineNumber);
            if (billRaw == null) continue;
            try {
                int entryCount = -1;
                String sCount = billRaw.get(TaxForeignHeadEnum.DetailCount.getName()).toString();
                boolean isDigit = sCount.matches("[1-9]*[0-9]");
                if (!isDigit) {
                    Object[] objs = new String[]{billRaw.get(TaxForeignHeadEnum.InvoiceNumber.getName()).toString(), TaxForeignHeadEnum.DetailCount.getAlias(), sCount};
                    logger.error((Object)("the entryCount is not right. line:" + sData));
                    throw new ImportExportException(ImportExportException.DATA_INVALID, objs);
                }
                entryCount = Integer.parseInt(sCount);
                if (entryCount > 0) {
                    ArrayList<HashMap> entryList = new ArrayList<HashMap>(entryCount);
                    billRaw.put("entries", entryList);
                    for (int i = 0; i < entryCount; ++i) {
                        sData = this.buffReader.readLine();
                        ++lineNumber;
                        try {
                            HashMap entryRaw = this.toEntryRaw(sData, lineNumber);
                            entryList.add(entryRaw);
                            continue;
                        }
                        catch (ImportExportException ex) {
                            importLog.errList.add(ex.getMessage());
                        }
                    }
                }
                ++importLog.billCount;
                int rtVal = -1;
                try {
                    rtVal = bizAction.submit(bizAction.transfer2Info(billRaw));
                }
                catch (BOSException e) {
                    throw new ImportExportException(ImportExportException.SYS_ERROR);
                }
                if (rtVal == 0) {
                    ++importLog.newCount;
                    continue;
                }
                if (rtVal != 1) continue;
                ++importLog.overCount;
            }
            catch (ImportExportException ex) {
                ++importLog.failCount;
                importLog.errList.add(ex.getMessage());
            }
        }
    }

    private void cleanRes() {
        try {
            if (this.fReader != null) {
                this.fReader.close();
            }
            if (this.buffReader != null) {
                this.buffReader.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    protected HashMap toBillRaw(String sData, int lineNumber) throws IOException, ImportExportException {
        List dataList = this.dp.parse(sData);
        if (dataList == null || dataList.size() == 0) {
            return null;
        }
        TaxRelationEntryCollection hdCol = this.relationInfo.getEntryHD();
        if (dataList.size() != hdCol.size()) {
            throw new ImportExportException(ImportExportException.HEAD_FIELD_COUNT_ERROR, new String[]{String.valueOf(lineNumber)});
        }
        HashMap<String, String> rawMap = new HashMap<String, String>();
        for (int i = 0; i < hdCol.size(); ++i) {
            Object obj = dataList.get(i);
            String val = obj == null ? "" : (String)obj;
            rawMap.put(hdCol.get(i).getForeignField().getName(), val);
        }
        return rawMap;
    }

    private List parseIt(String sRow) {
        if (sRow == null || sRow.length() == 0) {
            return null;
        }
        ArrayList<String> dataList = new ArrayList<String>();
        logger.info((Object)sRow);
        int begin = 0;
        int end = sRow.indexOf(this.seperator);
        if (end == -1) {
            return dataList;
        }
        String s1 = null;
        while (end != -1) {
            s1 = sRow.substring(begin, end);
            dataList.add(s1);
            if (end + 2 > sRow.length()) break;
            sRow = sRow.substring(end + 2);
            end = sRow.indexOf(this.seperator);
        }
        if (end == -1) {
            dataList.add(sRow);
        } else {
            dataList.add("");
        }
        logger.info(dataList);
        return dataList;
    }

    protected HashMap toEntryRaw(String sData, int lineNumber) throws ImportExportException {
        List dataList = this.dp.parse(sData);
        if (dataList == null || dataList.size() == 0) {
            return null;
        }
        int dataCount = dataList.size();
        if (dataCount != this.gTaxEntryFields.size() || dataCount != this.gTaxDiscountFields.size()) {
            logger.error((Object)("the line is not entry data: " + sData));
            throw new ImportExportException(ImportExportException.ENTRY_FIELD_COUNT_ERROR, new String[]{String.valueOf(lineNumber)});
        }
        HashMap entryRaw = new HashMap();
        boolean fDiscount = dataList.get(0).equals("1");
        int n = dataCount;
        for (int i = 0; i < n; ++i) {
            String val;
            Object obj = dataList.get(i);
            String string = val = obj == null ? "" : (String)obj;
            if (fDiscount) {
                if (i == 1) {
                    int left = val.indexOf("(");
                    int right = val.indexOf("%");
                    if (left != -1 && right != -1 && left != right) {
                        val = val.substring(left + 1, right);
                        try {
                            BigDecimal discount = new BigDecimal(val);
                            discount = discount.divide(new BigDecimal("100"), 4);
                            discount = discount.setScale(6, 4);
                            val = discount.toString();
                        }
                        catch (NumberFormatException numberFormatException) {
                            // empty catch block
                        }
                    }
                }
                entryRaw.put(this.gTaxDiscountFields.get(i), val);
                continue;
            }
            entryRaw.put(this.gTaxEntryFields.get(i), val);
        }
        return entryRaw;
    }
}

