/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.arap_tax;

import com.kingdee.eas.fi.ar.ArInvoiceCollection;
import com.kingdee.eas.fi.ar.ArInvoiceInfo;
import com.kingdee.eas.fi.arap_tax.DataParse;
import com.kingdee.eas.fi.arap_tax.GTaxImportLog;
import com.kingdee.eas.fi.arap_tax.ImportExportException;
import com.kingdee.eas.fi.arap_tax.TaxDataTransformer;
import com.kingdee.eas.fi.arap_tax.TaxEnumUtil;
import com.kingdee.eas.fi.arap_tax.TaxQualifySymbolEnum;
import com.kingdee.eas.fi.arap_tax.TaxRelationInfo;
import com.kingdee.eas.fi.arap_tax.TaxSeparatorTepeEnum;
import com.kingdee.eas.framework.CoreBillBaseInfo;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.io.FilenameUtils;
import org.apache.log4j.Logger;

public class SaleInvoiceExporter {
    private static final Logger logger = Logger.getLogger(SaleInvoiceExporter.class);
    private TaxRelationInfo relationInfo = null;
    private String seperator = null;
    private FileWriter writer = null;
    private BufferedWriter buffWriter = null;
    private List gTaxFields = new ArrayList();
    private List gTaxEntryFields = new ArrayList();
    private String qualifySymbol;
    private DataParse dp;

    public SaleInvoiceExporter(TaxRelationInfo rInfo) {
        if (rInfo == null) {
            throw new IllegalArgumentException("please specify the relationInfo.");
        }
        this.relationInfo = rInfo;
        this.init();
    }

    private void init() {
        TaxSeparatorTepeEnum sepType = this.relationInfo.getSeparatortype();
        TaxQualifySymbolEnum qualifySymboType = this.relationInfo.getQualifySymbolType();
        if (sepType.equals((Object)TaxSeparatorTepeEnum.Lumpy)) {
            this.seperator = "~~";
        } else if (sepType.equals((Object)TaxSeparatorTepeEnum.Tab)) {
            this.seperator = "\t";
        } else if (TaxSeparatorTepeEnum.Space.equals((Object)sepType)) {
            this.seperator = " ";
        } else if (sepType.equals((Object)TaxSeparatorTepeEnum.Other)) {
            this.seperator = this.relationInfo.getSeparator();
        }
        if (TaxQualifySymbolEnum.SingleQuotes.equals((Object)qualifySymboType)) {
            this.qualifySymbol = "'";
        } else if (TaxQualifySymbolEnum.DoubleQuotes.equals((Object)qualifySymboType)) {
            this.qualifySymbol = "\"";
        } else if (TaxQualifySymbolEnum.Other.equals((Object)qualifySymboType)) {
            this.qualifySymbol = this.relationInfo.getQualifySymbol();
        }
        this.dp = new DataParse(this.seperator, this.qualifySymbol);
        this.initFields();
    }

    private void initFields() {
        this.gTaxFields = TaxEnumUtil.getRelationForeignFieldList(this.relationInfo, true);
        this.gTaxEntryFields = TaxEnumUtil.getRelationForeignFieldList(this.relationInfo, false);
    }

    public GTaxImportLog export(ArInvoiceCollection invoiceColl, File outFile) throws ImportExportException, IOException {
        if (invoiceColl == null || invoiceColl.size() == 0) {
            logger.error((Object)"the param invoiceColl is null.");
            throw new IllegalArgumentException("the data collection is null");
        }
        if (outFile == null) {
            logger.error((Object)"the outFile must be specified.");
            throw new IllegalArgumentException("the outFile is null");
        }
        GTaxImportLog actionLog = new GTaxImportLog();
        actionLog.fExport = true;
        actionLog.billCount = invoiceColl.size();
        TaxDataTransformer bizAction = new TaxDataTransformer(this.relationInfo);
        try {
            this.writer = new FileWriter(outFile);
            this.buffWriter = new BufferedWriter(this.writer);
            ArInvoiceInfo info = null;
            HashMap rawBill = null;
            int n = invoiceColl.size();
            for (int i = 0; i < n; ++i) {
                info = invoiceColl.get(i);
                try {
                    if (i == 0) {
                        rawBill = bizAction.transfer2Raw((CoreBillBaseInfo)info);
                    } else {
                        rawBill = bizAction.transfer2Raw((CoreBillBaseInfo)info);
                        rawBill.remove("FlagString");
                    }
                    this.write2File(rawBill);
                    ++actionLog.newCount;
                    continue;
                }
                catch (ImportExportException e) {
                    ++actionLog.failCount;
                    actionLog.errList.add(e.getMessage());
                }
            }
            this.buffWriter.flush();
        }
        catch (FileNotFoundException ex) {
            throw new ImportExportException(ImportExportException.FILE_OPENED);
        }
        catch (IOException ex) {
            throw ex;
        }
        finally {
            this.cleanRes();
        }
        return actionLog;
    }

    private void cleanRes() {
        try {
            if (this.writer != null) {
                this.writer.close();
            }
            if (this.buffWriter != null) {
                this.buffWriter.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    protected File createDefaultOutFile() throws IOException {
        String sLogDir = System.getProperty("user.home") + File.pathSeparator + ".EAS";
        File outFile = new File(sLogDir = FilenameUtils.normalize((String)sLogDir));
        if (!outFile.exists()) {
            outFile.mkdir();
        }
        String sLogFile = sLogDir + File.pathSeparator + "EASSaleInv" + System.currentTimeMillis() + ".txt";
        outFile = new File(sLogFile);
        outFile.createNewFile();
        return outFile;
    }

    private void write2File(HashMap rawBill) throws IOException {
        if (rawBill == null) {
            return;
        }
        StringBuffer sBill = new StringBuffer();
        Object objVal = null;
        int n = this.gTaxFields.size();
        for (int i = 0; i < n; ++i) {
            objVal = rawBill.get(this.gTaxFields.get(i));
            if ("".equals(this.dp.format(objVal)) && "FlagString".equals(this.gTaxFields.get(i))) continue;
            sBill.append(objVal);
            if ("SJJK0101~~".equals(objVal)) {
                sBill.append("\r\n");
                continue;
            }
            sBill.append(i < n - 1 ? this.seperator : "\r\n");
        }
        List entries = (List)rawBill.get("entries");
        if (entries != null && entries.size() > 0) {
            String field = null;
            int m = entries.size();
            for (int i = 0; i < m; ++i) {
                HashMap rawEntry = (HashMap)entries.get(i);
                int n2 = this.gTaxEntryFields.size();
                for (int j = 0; j < n2; ++j) {
                    field = (String)this.gTaxEntryFields.get(j);
                    objVal = rawEntry.get(field);
                    if (field.equals("DiscountRatio")) {
                        if (objVal != null) {
                            BigDecimal ratio = new BigDecimal(objVal.toString());
                            if (ratio.signum() == 0) {
                                sBill.append("0");
                            } else {
                                ratio = ratio.multiply(new BigDecimal("100"));
                                sBill.append(TaxDataTransformer.removeZero(ratio)).append("%");
                            }
                        }
                    } else {
                        sBill.append(this.dp.format(objVal));
                    }
                    sBill.append(j < n2 - 1 ? this.seperator : "\r\n");
                }
            }
        }
        this.buffWriter.write(sBill.toString());
    }
}

