/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.arap_tax;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.dao.AbstractObjectCollection;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.framework.DynamicObjectFactory;
import com.kingdee.bos.framework.IDynamicObject;
import com.kingdee.bos.metadata.IMetaDataLoader;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.LinkPropertyInfo;
import com.kingdee.bos.metadata.entity.OwnPropertyInfo;
import com.kingdee.bos.metadata.entity.PropertyCollection;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.assistant.AccountBankInfo;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.MeasureUnitInfo;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolUtils;
import com.kingdee.eas.basedata.master.cssp.CustomerCompanyInfoInfo;
import com.kingdee.eas.basedata.master.cssp.CustomerFactory;
import com.kingdee.eas.basedata.master.cssp.CustomerInfo;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fi.ar.ArInvoiceEntryCollection;
import com.kingdee.eas.fi.ar.ArInvoiceEntryInfo;
import com.kingdee.eas.fi.ar.ArInvoiceFactory;
import com.kingdee.eas.fi.ar.ArInvoiceInfo;
import com.kingdee.eas.fi.ar.BillStatusEnum;
import com.kingdee.eas.fi.ar.IArInvoice;
import com.kingdee.eas.fi.arap.InvoiceTypeEnum;
import com.kingdee.eas.fi.arap_tax.FormulaUtil;
import com.kingdee.eas.fi.arap_tax.IBizTransferAction;
import com.kingdee.eas.fi.arap_tax.ITaxBaseData;
import com.kingdee.eas.fi.arap_tax.ImportExportException;
import com.kingdee.eas.fi.arap_tax.TaxBaseDataEntryAInfo;
import com.kingdee.eas.fi.arap_tax.TaxBaseDataEntryBInfo;
import com.kingdee.eas.fi.arap_tax.TaxBaseDataEntryCInfo;
import com.kingdee.eas.fi.arap_tax.TaxBaseDataEntryDInfo;
import com.kingdee.eas.fi.arap_tax.TaxBaseDataFactory;
import com.kingdee.eas.fi.arap_tax.TaxBaseDataInfo;
import com.kingdee.eas.fi.arap_tax.TaxDuplicateRecordEnum;
import com.kingdee.eas.fi.arap_tax.TaxEnumUtil;
import com.kingdee.eas.fi.arap_tax.TaxFieldPropertyEnum;
import com.kingdee.eas.fi.arap_tax.TaxForeignDetailEnum;
import com.kingdee.eas.fi.arap_tax.TaxForeignHeadEnum;
import com.kingdee.eas.fi.arap_tax.TaxRelationEntryCollection;
import com.kingdee.eas.fi.arap_tax.TaxRelationEntryDCollection;
import com.kingdee.eas.fi.arap_tax.TaxRelationEntryDInfo;
import com.kingdee.eas.fi.arap_tax.TaxRelationEntryInfo;
import com.kingdee.eas.fi.arap_tax.TaxRelationInfo;
import com.kingdee.eas.fi.arap_tax.TaxRelationTypeEnum;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.CoreBillBaseInfo;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.util.DateTimeUtils;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class TaxDataTransformer
implements IBizTransferAction {
    private TaxRelationInfo solutionInfo = null;
    private static BOSObjectType billBosType = new ArInvoiceInfo().getBOSType();
    private static BOSObjectType entryBosType = new ArInvoiceEntryInfo().getBOSType();
    private static final Logger logger = Logger.getLogger((String)"com.kingdee.eas.scm.sd.sale.TaxDataTransformer");
    private Map headLinkPropsBosMap = null;
    private Map entryLinkPropsBosMap = null;
    private Map baseDataA = new HashMap();
    private Map baseDataB = new HashMap();
    private Map baseDataC = new HashMap();
    private Map baseDataD = new HashMap();
    private boolean isImport = false;
    private String easPrimaryKey = "number";
    private Map dataMap = null;
    private IObjectValue bizInfo = null;
    private CompanyOrgUnitInfo currentCompany = null;
    private CurrencyInfo baseCurrency = null;
    private CurrencyInfo currency = null;
    PeriodInfo currentPeriod = null;
    String[] AMOUNT_FIELDS = new String[]{"totalAmount", "amount", "taxAmount", "actualAmount", "unitPrice"};
    String[] QTY_FIELDS = new String[]{"quantity"};
    String[] RATE_FIELDS = new String[]{"taxRate"};

    public TaxDataTransformer(TaxRelationInfo solutionInfo) throws ImportExportException {
        this.solutionInfo = solutionInfo;
        this.baseData2Map(solutionInfo.getId().toString());
        this.headLinkPropsBosMap = TaxDataTransformer.getLinkPropsBosType(billBosType);
        this.headLinkPropsBosMap.put("asstActName", new CustomerInfo().getBOSType());
        this.entryLinkPropsBosMap = TaxDataTransformer.getLinkPropsBosType(entryBosType);
        this.currentCompany = SysContext.getSysContext().getCurrentFIUnit();
        if (solutionInfo.getRelationType().equals((Object)TaxRelationTypeEnum.Import)) {
            this.isImport = true;
            try {
                this.currentPeriod = SystemStatusCtrolUtils.getCurrentPeriod(null, (SystemEnum)SystemEnum.SALESMANAGEMENT, (CompanyOrgUnitInfo)this.currentCompany);
                this.baseCurrency = CurrencyFactory.getRemoteInstance().getCurrencyInfo((IObjectPK)new ObjectUuidPK(this.currentCompany.getBaseCurrency().getId()));
            }
            catch (Exception e) {
                logger.error((Object)e);
                throw new ImportExportException(ImportExportException.SYS_ERROR);
            }
        }
    }

    public static Map getLinkPropsBosType(BOSObjectType bosType) {
        HashMap<String, BOSObjectType> map = new HashMap<String, BOSObjectType>();
        IMetaDataLoader imdl = MetaDataLoaderFactory.getRemoteMetaDataLoader();
        EntityObjectInfo eoi = imdl.getEntity(bosType);
        PropertyCollection pc = eoi.getInheritedProperties();
        LinkPropertyInfo lpi = null;
        Object o2 = null;
        for (Object o2 : pc) {
            if (!(o2 instanceof LinkPropertyInfo)) continue;
            lpi = o2;
            map.put(lpi.getName(), lpi.getRelationship().getSupplierObject().getType());
        }
        return map;
    }

    private void baseData2Map(String solutionId) throws ImportExportException {
        TaxBaseDataInfo baseDataInfo = null;
        try {
            ITaxBaseData iBaseData = TaxBaseDataFactory.getRemoteInstance();
            baseDataInfo = (TaxBaseDataInfo)iBaseData.getValue("where relationID = '" + solutionId + "'");
        }
        catch (Exception e) {
            logger.error((Object)e);
            return;
        }
        AbstractObjectCollection col = null;
        int size = 0;
        TaxBaseDataEntryAInfo infoA = null;
        TaxBaseDataEntryBInfo infoB = null;
        TaxBaseDataEntryCInfo infoC = null;
        TaxBaseDataEntryDInfo infoD = null;
        if (baseDataInfo != null) {
            int i;
            col = baseDataInfo.getEntryA();
            size = col.size();
            for (i = 0; i < size; ++i) {
                infoA = (TaxBaseDataEntryAInfo)col.getObject(i);
                if (this.isImport) {
                    this.baseDataA.put(infoA.getTaxCustomer(), infoA.getEasCustomer());
                    continue;
                }
                this.baseDataA.put(infoA.getEasCustomer(), infoA.getTaxCustomer());
            }
            col = baseDataInfo.getEntryB();
            size = col.size();
            for (i = 0; i < size; ++i) {
                infoB = (TaxBaseDataEntryBInfo)col.getObject(i);
                if (this.isImport) {
                    this.baseDataB.put(infoB.getTaxMaterial(), infoB.getEasMaterial());
                    continue;
                }
                this.baseDataB.put(infoB.getEasMaterial(), infoB.getTaxMaterial());
            }
            col = baseDataInfo.getEntryC();
            size = col.size();
            for (i = 0; i < size; ++i) {
                infoC = (TaxBaseDataEntryCInfo)col.getObject(i);
                if (this.isImport) {
                    this.baseDataC.put(infoC.getTaxUnit(), infoC.getEasUnit());
                    continue;
                }
                this.baseDataC.put(infoC.getEasUnit(), infoC.getTaxUnit());
            }
            col = baseDataInfo.getEntryD();
            size = col.size();
            for (i = 0; i < size; ++i) {
                infoD = (TaxBaseDataEntryDInfo)col.getObject(i);
                if (this.isImport) {
                    this.baseDataD.put(infoD.getTaxHandler(), infoD.getEasHandler());
                    continue;
                }
                this.baseDataD.put(infoD.getEasHandler(), infoD.getTaxHandler());
            }
        }
    }

    @Override
    public CoreBillBaseInfo transfer2Info(HashMap dataMap) throws ImportExportException {
        this.dataMap = dataMap;
        String billNum = (String)dataMap.get(TaxForeignHeadEnum.InvoiceNumber.getName());
        String entriesKey = "entries";
        List entries = (List)dataMap.get(entriesKey);
        if (entries == null || entries.size() == 0) {
            Object[] obj = new Object[]{billNum, "0"};
            throw new ImportExportException(ImportExportException.ENTRY_COUNT_ERROR, obj);
        }
        TaxRelationEntryCollection hdEntryCol = this.solutionInfo.getEntryHD();
        TaxRelationEntryInfo relationHD = null;
        ArInvoiceInfo arInvoiceInfo = new ArInvoiceInfo();
        String easField = "";
        String taxField = "";
        Object easValue = null;
        Object taxValue = null;
        for (int i = 0; i < hdEntryCol.size(); ++i) {
            Object[] obj;
            relationHD = hdEntryCol.get(i);
            easField = relationHD.getEasFieldID();
            if (easField == null) {
                obj = new Object[]{relationHD.getEasFieldName()};
                throw new ImportExportException(ImportExportException.RELATION_ERROR, obj);
            }
            if (relationHD.isIsUseFormula()) {
                easValue = this.computeValueByFormula(dataMap, relationHD.getFormula(), easField);
            } else if (easValue == null && TaxForeignHeadEnum.nullvalue.equals((Object)relationHD.getForeignField())) {
                taxValue = relationHD.getDefaultValue();
            } else {
                taxField = relationHD.getForeignField().getValue();
                taxValue = (String)dataMap.get(taxField);
            }
            if (taxValue == null) {
                taxValue = relationHD.getDefaultValue();
            }
            try {
                easValue = this.classCast(taxValue, relationHD.getEasFieldType());
            }
            catch (ParseException e) {
                Object[] obj2 = new Object[]{billNum, taxField, e.getMessage()};
                throw new ImportExportException(ImportExportException.DATA_INVALID, obj2);
            }
            if (this.headLinkPropsBosMap.containsKey(easField)) {
                easValue = this.getBaseDataValue(easField, (String)taxValue);
                BOSObjectType bosType = (BOSObjectType)this.headLinkPropsBosMap.get(easField);
                easValue = this.getLinkPropValue(bosType, easValue, relationHD.getFieldProperty());
                if (easValue instanceof CurrencyInfo) {
                    this.currency = (CurrencyInfo)easValue;
                }
            }
            if (easValue == null && relationHD.isIsNotNull()) {
                obj = new Object[]{billNum, taxField};
                throw new ImportExportException(ImportExportException.NOT_NULL, obj);
            }
            arInvoiceInfo.put(easField, easValue);
        }
        ArInvoiceEntryCollection arInvoiceEntryCol = new ArInvoiceEntryCollection();
        TaxRelationEntryDCollection dtEntryCol = this.solutionInfo.getEntryDT();
        TaxRelationEntryDInfo relationDT = null;
        HashMap entryMapClone = null;
        for (int i = 0; entries != null && i < entries.size(); ++i) {
            ArInvoiceEntryInfo arInvoiceEntryInfo = new ArInvoiceEntryInfo();
            HashMap entryMap = (HashMap)entries.get(i);
            if (entryMap == null) continue;
            String discountKey = TaxEnumUtil.getEntryDiscountFieldList().get(0).toString();
            if (entryMap.containsKey(discountKey)) {
                if (arInvoiceEntryCol.size() > 0) {
                    arInvoiceEntryInfo = arInvoiceEntryCol.get(arInvoiceEntryCol.size() - 1);
                    arInvoiceEntryCol.removeObject(arInvoiceEntryCol.size() - 1);
                }
                entryMap.putAll(entryMapClone);
            } else {
                entryMapClone = (HashMap)entryMap.clone();
            }
            for (int j = 0; j < dtEntryCol.size(); ++j) {
                Object[] obj;
                relationDT = dtEntryCol.get(j);
                easField = relationDT.getEasFieldID();
                if (easField == null) {
                    obj = new Object[]{taxField};
                    throw new ImportExportException(ImportExportException.NOT_NULL, obj);
                }
                if (relationDT.isIsUseFormula()) {
                    taxValue = this.computeValueByFormula(entryMap, relationDT.getFormula(), easField);
                } else if (TaxForeignDetailEnum.nullvalue.equals((Object)relationDT.getForeignField())) {
                    taxValue = relationDT.getDefaultValue();
                } else {
                    taxField = relationDT.getForeignField().getValue();
                    taxValue = (String)entryMap.get(taxField);
                }
                if (taxValue == null) {
                    taxValue = relationDT.getDefaultValue();
                }
                easValue = taxValue;
                if (this.entryLinkPropsBosMap.containsKey(easField)) {
                    easValue = this.getBaseDataValue(easField, (String)taxValue);
                    BOSObjectType bosType = (BOSObjectType)this.entryLinkPropsBosMap.get(easField);
                    easValue = this.getLinkPropValue(bosType, easValue, relationDT.getFieldProperty());
                }
                if (this.isMaterialField(easField)) {
                    easValue = this.getMaterialValue(entryMap, relationDT.getFieldProperty());
                }
                if (easValue == null && relationDT.isIsNotNull()) {
                    obj = new Object[]{dataMap.get(TaxForeignHeadEnum.InvoiceNumber.getName()), taxField};
                    throw new ImportExportException(ImportExportException.NOT_NULL, obj);
                }
                arInvoiceEntryInfo.put(easField, easValue);
            }
            this.setEntryDefualtValue(arInvoiceEntryInfo);
            arInvoiceEntryCol.add(arInvoiceEntryInfo);
        }
        arInvoiceInfo.getEntries().addCollection(arInvoiceEntryCol);
        try {
            this.setHeadDefaultValue(arInvoiceInfo);
        }
        catch (Exception e) {
            logger.error((Object)e);
            Object[] obj = new Object[]{"", "", "set default value error"};
            throw new ImportExportException(ImportExportException.DATA_INVALID, obj);
        }
        return arInvoiceInfo;
    }

    private CurrencyInfo getCurrency(String taxValue) {
        return null;
    }

    private Object getMaterialValue(HashMap entryMap, TaxFieldPropertyEnum compField) throws ImportExportException {
        BOSObjectType materialBosType = new MaterialInfo().getBOSType();
        IObjectValue objectValue = null;
        StringBuffer sCUBuffer = new StringBuffer();
        sCUBuffer.append("(cu.id='").append(this.currentCompany.getCU().getId()).append("' ");
        sCUBuffer.append(" or cu.id='").append("00000000-0000-0000-0000-000000000000CCE7AED4").append("' ");
        sCUBuffer.append(" or cu.id='").append("11111111-1111-1111-1111-111111111111CCE7AED4").append("')");
        String sCompField = "name";
        if (TaxFieldPropertyEnum.TaxFieldName.equals((Object)compField)) {
            sCompField = "name";
        } else if (TaxFieldPropertyEnum.TaxFieldNumber.equals((Object)compField)) {
            sCompField = "number";
        }
        String materialName = (String)entryMap.get("ProductName");
        String model = (String)entryMap.get("SpecNumber");
        StringBuffer oql = new StringBuffer();
        oql.append("select id,name where ");
        oql.append(sCompField).append(" ='").append(materialName).append("'");
        oql.append("and model='").append(model).append("'");
        oql.append(" and ").append(sCUBuffer);
        try {
            IDynamicObject dynamicObject = DynamicObjectFactory.getRemoteInstance();
            IObjectCollection col = dynamicObject.getCollection(materialBosType, oql.toString());
            objectValue = col.getObject(0);
        }
        catch (BOSException col) {
            // empty catch block
        }
        if (objectValue == null) {
            Object[] obj = new Object[]{this.dataMap != null ? this.dataMap.get(TaxForeignHeadEnum.InvoiceNumber.getName()) : "", "'" + materialName + "','" + model + "'", EASResource.getString((String)"com.kingdee.eas.scm.sd.sale.SALEAutoGenerateResource", (String)"37_SaleIncomDetailConditionUI")};
            throw new ImportExportException(ImportExportException.DATA_INVALID, obj);
        }
        return objectValue;
    }

    private void setHeadDefaultValue(ArInvoiceInfo arInvInfo) throws EASBizException, BOSException {
        arInvInfo.setType(InvoiceTypeEnum.VAT);
        arInvInfo.setBillStatus(BillStatusEnum.SUBMITED);
        Date bizDate = arInvInfo.getBizDate();
        if (this.currentPeriod != null && (bizDate.before(this.currentPeriod.getBeginDate()) || bizDate.after(this.currentPeriod.getEndDate()))) {
            arInvInfo.setBizDate(this.currentPeriod.getBeginDate());
        } else {
            arInvInfo.setBizDate(bizDate);
        }
        ArInvoiceEntryCollection arInvoiceEntryCol = arInvInfo.getEntries();
        ArInvoiceEntryInfo arInvoiceEntryInfo = null;
        BigDecimal totalAmount = new BigDecimal("0.000000");
        for (int i = 0; arInvoiceEntryCol != null && i < arInvoiceEntryCol.size(); ++i) {
            arInvoiceEntryInfo = arInvoiceEntryCol.get(i);
            if (arInvoiceEntryInfo.getTaxAmount() == null) continue;
            totalAmount = totalAmount.add(arInvoiceEntryInfo.getActualAmount());
        }
        arInvInfo.setTotalAmount(totalAmount);
    }

    private void setEntryDefualtValue(ArInvoiceEntryInfo arInvoiceEntryInfo) {
    }

    private BigDecimal getValueScale(BigDecimal value, String easField) {
        int i;
        int precision = 2;
        for (i = 0; i < this.AMOUNT_FIELDS.length; ++i) {
            if (!this.AMOUNT_FIELDS[i].equalsIgnoreCase(easField)) continue;
            if (this.currency != null && this.currency.getPrecision() > 0) {
                precision = this.currency.getPrecision();
                break;
            }
            precision = this.baseCurrency.getPrecision();
            break;
        }
        for (i = 0; i < this.QTY_FIELDS.length; ++i) {
            if (!this.QTY_FIELDS[i].equalsIgnoreCase(easField)) continue;
            precision = 3;
            break;
        }
        for (i = 0; i < this.RATE_FIELDS.length; ++i) {
            if (!this.RATE_FIELDS[i].equalsIgnoreCase(easField)) continue;
            precision = 2;
            break;
        }
        return value.setScale(precision);
    }

    private BigDecimal computeValueByFormula(Map dataMap, String formulaStr, String easField) throws ImportExportException {
        FormulaUtil formulaUtil = new FormulaUtil();
        String oldFormula = formulaStr;
        List list = formulaUtil.getFieldParsed(formulaStr);
        for (int i = 0; list != null && i < list.size(); ++i) {
            String taxKey = (String)list.get(i);
            String taxValue = (String)dataMap.get(taxKey);
            if (taxValue == null) {
                taxValue = "0";
            }
            formulaStr = formulaStr.replaceAll(taxKey, taxValue);
        }
        try {
            return this.getValueScale(formulaUtil.ComputValue(formulaStr), easField);
        }
        catch (Exception e) {
            Object[] obj = new Object[]{TaxForeignHeadEnum.InvoiceNumber.getAlias() + ":" + this.dataMap.get(TaxForeignHeadEnum.InvoiceNumber.getValue()) + ", " + oldFormula};
            throw new ImportExportException(ImportExportException.FORMULA_INVALID, e, obj);
        }
    }

    private Object computeValueByFormula(IObjectValue bizInfo, String formulaStr) throws ImportExportException {
        int i;
        String oldFormula = formulaStr;
        FormulaUtil formulaUtil = new FormulaUtil();
        List list = formulaUtil.getFieldParsed(formulaStr);
        String easField = "";
        boolean isStringFormula = false;
        for (i = 0; list != null && i < list.size(); ++i) {
            if (bizInfo.get((String)list.get(i)) instanceof BigDecimal) continue;
            isStringFormula = true;
            formulaStr = formulaStr.replaceAll("\\+", "");
            break;
        }
        for (i = 0; list != null && i < list.size(); ++i) {
            formulaStr = formulaStr.replaceAll(easField, bizInfo.get(easField = (String)list.get(i)) == null ? "" : bizInfo.get(easField).toString());
        }
        try {
            if (isStringFormula) {
                return formulaStr;
            }
            return formulaUtil.ComputValue(formulaStr);
        }
        catch (Exception e) {
            Object[] obj = new Object[]{TaxForeignHeadEnum.InvoiceNumber.getAlias() + ":" + this.bizInfo.get(TaxForeignHeadEnum.InvoiceNumber.getValue()) + ", " + oldFormula};
            throw new ImportExportException(ImportExportException.FORMULA_INVALID, e, obj);
        }
    }

    private IObjectValue getLinkPropValue(BOSObjectType bosType, Object easValue, TaxFieldPropertyEnum compField) throws ImportExportException {
        IObjectValue objectValue = this.getValue(bosType, easValue, compField);
        return objectValue;
    }

    private IObjectValue getValue(BOSObjectType bosType, Object easValue, TaxFieldPropertyEnum compField) throws ImportExportException {
        IObjectValue objectValue;
        StringBuffer sCUBuffer = new StringBuffer();
        sCUBuffer.append("(cu.id='").append(this.currentCompany.getCU().getId()).append("' ");
        sCUBuffer.append(" or cu.id='").append("00000000-0000-0000-0000-000000000000CCE7AED4").append("' ");
        sCUBuffer.append(" or cu.id='").append("11111111-1111-1111-1111-111111111111CCE7AED4").append("')");
        String sCompField = "name";
        if (TaxFieldPropertyEnum.TaxFieldName.equals((Object)compField)) {
            sCompField = "name";
        } else if (TaxFieldPropertyEnum.TaxFieldNumber.equals((Object)compField)) {
            sCompField = "number";
        }
        StringBuffer oql = new StringBuffer();
        oql.append("select id,name where ");
        oql.append(sCompField).append("='");
        oql.append(easValue).append("'");
        oql.append(" and ").append(sCUBuffer);
        try {
            IDynamicObject dynamicObject = DynamicObjectFactory.getRemoteInstance();
            IObjectCollection col = dynamicObject.getCollection(bosType, oql.toString());
            objectValue = col.getObject(0);
        }
        catch (BOSException e) {
            Object[] obj = new Object[3];
            obj[0] = this.dataMap != null ? this.dataMap.get(TaxForeignHeadEnum.InvoiceNumber.getName()) : "";
            IMetaDataLoader imdl = MetaDataLoaderFactory.getRemoteMetaDataLoader();
            EntityObjectInfo eoi = imdl.getEntity(bosType);
            obj[1] = easValue;
            obj[2] = eoi.getAlias();
            throw new ImportExportException(ImportExportException.DATA_INVALID, obj);
        }
        return objectValue;
    }

    @Override
    public HashMap transfer2Raw(CoreBillBaseInfo bizInfo) throws ImportExportException {
        this.bizInfo = bizInfo;
        HashMap<String, Object> dataMap = new HashMap<String, Object>();
        ArrayList entryList = new ArrayList();
        ArInvoiceInfo arInvoiceInfo = (ArInvoiceInfo)bizInfo;
        ArInvoiceEntryCollection arInvoiceEntryCol = arInvoiceInfo.getEntries();
        ArInvoiceEntryInfo arInvoiceEntryInfo = null;
        CustomerInfo customerInfo = this.getCustomer(arInvoiceInfo.getAsstActID());
        TaxRelationEntryCollection hdEntryCol = this.solutionInfo.getEntryHD();
        TaxRelationEntryInfo relationHD = null;
        String easField = "";
        String taxField = "";
        Object easValue = null;
        Object taxValue = null;
        String easValues = null;
        boolean isFirstTime = true;
        for (int j = 0; j < hdEntryCol.size(); ++j) {
            if (isFirstTime && hdEntryCol.get(j).get("foreignfield").equals("FlagString")) {
                taxField = hdEntryCol.get(j).getForeignField().getValue();
                easValues = hdEntryCol.get(j).getDefaultValue();
                isFirstTime = false;
            }
            if (!isFirstTime) break;
        }
        if ((taxValue = easValues) != null) {
            taxValue = TaxDataTransformer.removeZero(taxValue);
        }
        dataMap.put(taxField, taxValue);
        dataMap.put(TaxForeignHeadEnum.DetailCount.getValue(), new Integer(arInvoiceEntryCol.size()));
        for (int i = 0; i < hdEntryCol.size(); ++i) {
            relationHD = hdEntryCol.get(i);
            taxField = relationHD.getForeignField().getValue();
            if (taxField == null) {
                throw new ImportExportException(ImportExportException.RELATION_ERROR, new Object[]{""});
            }
            if (relationHD != null && relationHD.isIsUseFormula()) {
                taxValue = this.computeValueByFormula((IObjectValue)bizInfo, relationHD.getFormula());
            } else if (relationHD != null) {
                easField = relationHD.getEasFieldID();
                if (easField == null || bizInfo.get(easField) == null) {
                    easValue = relationHD.getDefaultValue();
                } else {
                    if (!hdEntryCol.get(i).get("foreignfield").equals("FlagString")) {
                        easField = relationHD.getEasFieldID();
                    }
                    if (easField == null || bizInfo.get(easField) == null) {
                        easValue = relationHD.getDefaultValue();
                    } else {
                        easValue = bizInfo.get(easField);
                        if (easValue instanceof AccountBankInfo) {
                            easValue = ((AccountBankInfo)easValue).getBankAccountNumber();
                        } else if (easValue instanceof IObjectValue) {
                            easValue = ((IObjectValue)easValue).get("name");
                        } else if (easValue instanceof Date) {
                            easValue = DateTimeUtils.format((Date)((Date)easValue), (String)"yyyyMMdd");
                        }
                    }
                    if (easValue == null) {
                        easValue = "";
                    }
                    taxValue = easValue;
                    if ("asstActName".equals(easField)) {
                        taxValue = (String)this.baseDataA.get(easField);
                    }
                    if (this.headLinkPropsBosMap.containsKey(easField)) {
                        taxValue = this.getBaseDataValue(easField, easValue.toString());
                    }
                }
                if (easValue == null) {
                    easValue = "";
                }
                taxValue = easValue;
                if ("asstActName".equals(easField)) {
                    taxValue = (String)this.baseDataA.get(easField);
                }
                if (this.headLinkPropsBosMap.containsKey(easField)) {
                    taxValue = this.getBaseDataValue(easField, easValue.toString());
                }
            }
            if (TaxEnumUtil.CUSTOMER_BANKACCMOUNT.id.equalsIgnoreCase(easField) || TaxEnumUtil.CUSTOMER_TAXACCOUNT.id.equalsIgnoreCase(easField) || TaxEnumUtil.CUSTOMER_ADDRESS.id.equalsIgnoreCase(easField)) {
                taxValue = this.setTaxValueByCustomer(easField, customerInfo, arInvoiceInfo.getCompany());
            }
            if (taxValue == null && relationHD.isIsNotNull()) {
                Object[] obj = new Object[]{dataMap.get(TaxForeignHeadEnum.InvoiceNumber.getName()), taxField};
                throw new ImportExportException(ImportExportException.NOT_NULL, obj);
            }
            if (taxValue == null || "null".equalsIgnoreCase(taxValue.toString())) {
                taxValue = "";
            }
            if (taxValue != null) {
                taxValue = TaxDataTransformer.removeZero(taxValue);
            }
            if (taxField.equals("FlagString")) continue;
            dataMap.put(taxField, taxValue);
        }
        dataMap.put(TaxForeignHeadEnum.DetailCount.getValue(), new Integer(arInvoiceEntryCol.size()));
        TaxRelationEntryDCollection dtEntryCol = this.solutionInfo.getEntryDT();
        TaxRelationEntryDInfo relationDT = null;
        for (int i = 0; i < arInvoiceEntryCol.size(); ++i) {
            arInvoiceEntryInfo = arInvoiceEntryCol.get(i);
            HashMap<String, Object> entryMap = new HashMap<String, Object>();
            for (int j = 0; j < dtEntryCol.size(); ++j) {
                relationDT = dtEntryCol.get(j);
                if (relationDT == null) continue;
                taxField = relationDT.getForeignField().getValue();
                if (relationDT.isIsUseFormula()) {
                    taxValue = this.computeValueByFormula((IObjectValue)arInvoiceEntryInfo, relationDT.getFormula());
                } else {
                    easField = relationDT.getEasFieldID();
                    if (easField == null || arInvoiceEntryInfo.get(easField) == null) {
                        easValue = relationDT.getDefaultValue();
                    } else {
                        easValue = arInvoiceEntryInfo.get(easField);
                        if (easValue instanceof IObjectValue) {
                            easValue = ((IObjectValue)easValue).get("name");
                        }
                        if (easValue instanceof Date) {
                            easValue = DateTimeUtils.format((Date)((Date)easValue), (String)"yyyyMMdd");
                        }
                    }
                    if (easValue == null) {
                        easValue = "";
                    }
                    taxValue = easValue;
                    if (this.entryLinkPropsBosMap.containsKey(easField)) {
                        taxValue = this.getBaseDataValue(easField, easValue.toString());
                    }
                    if (TaxEnumUtil.SPECIFICATION.id.equalsIgnoreCase(easField)) {
                        MaterialInfo materialInfo = arInvoiceEntryInfo.getMaterial();
                        taxValue = materialInfo.getModel();
                    }
                }
                if (taxValue == null && relationDT.isIsNotNull()) {
                    Object[] obj = new Object[]{dataMap.get(TaxForeignHeadEnum.InvoiceNumber.getName()), taxField, " can not be null"};
                    throw new ImportExportException(ImportExportException.DATA_INVALID, obj);
                }
                if (taxValue == null || "null".equalsIgnoreCase(taxValue.toString())) {
                    taxValue = "";
                }
                if (taxValue != null) {
                    taxValue = TaxDataTransformer.removeZero(taxValue);
                }
                entryMap.put(taxField, taxValue);
            }
            entryList.add(entryMap);
        }
        dataMap.put("entries", entryList);
        return dataMap;
    }

    private Object setTaxValueByCustomer(String easField, CustomerInfo customerInfo, CompanyOrgUnitInfo companyInfo) {
        String taxValue = null;
        if (customerInfo == null) {
            return null;
        }
        if (TaxEnumUtil.CUSTOMER_BANKACCMOUNT.id.equalsIgnoreCase(easField)) {
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("bankName"));
            sic.add(new SelectorItemInfo("bankAccount"));
            CustomerCompanyInfoInfo customerCompanyInfo = null;
            if (companyInfo != null) {
                try {
                    customerCompanyInfo = CustomerFactory.getRemoteInstance().getCustomerCompanyInfo((IObjectPK)new ObjectUuidPK(customerInfo.getId()), (IObjectPK)new ObjectUuidPK(companyInfo.getId()), sic);
                }
                catch (Exception e) {
                    logger.error((Object)e);
                }
            }
            if (customerCompanyInfo != null) {
                taxValue = customerCompanyInfo.getBank() + customerCompanyInfo.getBankAccount();
            }
        }
        if (TaxEnumUtil.CUSTOMER_TAXACCOUNT.id.equalsIgnoreCase(easField)) {
            taxValue = customerInfo.getTaxRegisterNo();
        }
        if (TaxEnumUtil.CUSTOMER_ADDRESS.id.equalsIgnoreCase(easField)) {
            taxValue = customerInfo.getAddress();
        }
        return taxValue;
    }

    public static String getSelectStr() {
        StringBuffer oql = new StringBuffer();
        oql.append("select ");
        IMetaDataLoader imdl = MetaDataLoaderFactory.getRemoteMetaDataLoader();
        EntityObjectInfo eoi = imdl.getEntity(billBosType);
        PropertyCollection pc = eoi.getInheritedProperties();
        Object o2 = null;
        for (Object o2 : pc) {
            if (o2 instanceof LinkPropertyInfo) {
                LinkPropertyInfo lpi = o2;
                if ("entries".equalsIgnoreCase(lpi.getName())) {
                    EntityObjectInfo entryeoi = imdl.getEntity(entryBosType);
                    PropertyCollection entryPC = entryeoi.getInheritedProperties();
                    Iterator entryIT = entryPC.iterator();
                    Object entryObj = null;
                    while (entryIT.hasNext()) {
                        entryObj = entryIT.next();
                        if (entryObj instanceof LinkPropertyInfo) {
                            LinkPropertyInfo entrylpi = entryObj;
                            oql.append("entries.").append(entrylpi.getName()).append(".name,");
                            if (!"material".equalsIgnoreCase(entrylpi.getName())) continue;
                            oql.append("entries.material.name,entries.material.model,");
                            continue;
                        }
                        if (!(entryObj instanceof OwnPropertyInfo)) continue;
                        OwnPropertyInfo entryopi = entryObj;
                        oql.append("entries.").append(entryopi.getName()).append(",");
                    }
                }
                if ("customer".equalsIgnoreCase(lpi.getName())) {
                    oql.append("customer.name,customer.bank,customer.bankAccount,customer.customer.address,");
                    oql.append("customer.taxRegisterNo,customer.address,");
                }
                oql.append(lpi.getName()).append(".name,");
                continue;
            }
            if (!(o2 instanceof OwnPropertyInfo)) continue;
            OwnPropertyInfo opi = o2;
            oql.append(opi.getName()).append(",");
        }
        oql.deleteCharAt(oql.length() - 1);
        oql.append(" ");
        return oql.toString();
    }

    @Override
    public int submit(CoreBillBaseInfo bizInfo) throws ImportExportException, BOSException {
        CoreBaseInfo objctValue = null;
        IArInvoice iArInvoice = null;
        String value = (String)bizInfo.get(this.easPrimaryKey);
        StringBuffer oql = new StringBuffer();
        oql.append("select id where ").append(this.easPrimaryKey);
        oql.append("= '").append(value).append("'");
        oql.append("and cu.id='").append(this.currentCompany.getCU().getId()).append("'");
        try {
            iArInvoice = ArInvoiceFactory.getRemoteInstance();
            objctValue = iArInvoice.getValue(oql.toString());
        }
        catch (BOSException e) {
            try {
                IObjectPK pk = iArInvoice.submit((CoreBaseInfo)bizInfo);
                bizInfo.put(bizInfo.getPKField(), (Object)pk);
                iArInvoice.update(pk, (CoreBaseInfo)bizInfo);
                return 0;
            }
            catch (EASBizException e1) {
                throw new ImportExportException(ImportExportException.SUBMIT_ERROR, new String[]{value, e1.getMessage()});
            }
        }
        catch (EASBizException e) {
            throw new ImportExportException(ImportExportException.SYS_ERROR);
        }
        if (TaxDuplicateRecordEnum.OVER.equals((Object)this.solutionInfo.getDuplicateRecord())) {
            ObjectUuidPK pk = new ObjectUuidPK(objctValue.getId());
            try {
                bizInfo.setId(objctValue.getId());
                iArInvoice.update((IObjectPK)pk, (CoreBaseInfo)bizInfo);
                return 1;
            }
            catch (EASBizException e) {
                throw new ImportExportException(ImportExportException.SUBMIT_OVER_ERROR, new String[]{value});
            }
        }
        return -1;
    }

    private Object classCast(Object value, String className) throws ParseException {
        Object obj = value;
        String dateFormat = "yyyyMMdd";
        if ("date".equalsIgnoreCase(className)) {
            obj = DateTimeUtils.parseDate((String)((String)value), (String)dateFormat);
        }
        if ("TimeStamp".equalsIgnoreCase(className)) {
            obj = new Timestamp(DateTimeUtils.parseDate((String)((String)value), (String)dateFormat).getTime());
        }
        return obj;
    }

    private String getBaseDataValue(String easField, String key) {
        String baseDataStr = key;
        if (this.isCustomerField(easField) && this.baseDataA.containsKey(key)) {
            baseDataStr = (String)this.baseDataA.get(key);
        } else if (this.isMaterialField(easField) && this.baseDataB.containsKey(key)) {
            baseDataStr = (String)this.baseDataB.get(key);
        } else if (this.isMeasureUnitField(easField) && this.baseDataC.containsKey(key)) {
            baseDataStr = (String)this.baseDataC.get(key);
        } else if (this.isHandlerField(easField) && this.baseDataD.containsKey(key)) {
            baseDataStr = (String)this.baseDataD.get(key);
        }
        return baseDataStr;
    }

    private boolean isCustomerField(String easField) {
        boolean isCustomerField = false;
        BOSObjectType bosType = (BOSObjectType)this.headLinkPropsBosMap.get(easField);
        if (bosType == null) {
            bosType = (BOSObjectType)this.entryLinkPropsBosMap.get(easField);
        }
        if (bosType != null && new CustomerInfo().getBOSType().toString().equalsIgnoreCase(bosType.toString())) {
            isCustomerField = true;
        }
        return isCustomerField;
    }

    private boolean isMaterialField(String easField) {
        boolean isMaterialField = false;
        BOSObjectType bosType = (BOSObjectType)this.headLinkPropsBosMap.get(easField);
        if (bosType == null) {
            bosType = (BOSObjectType)this.entryLinkPropsBosMap.get(easField);
        }
        if (bosType != null && new MaterialInfo().getBOSType().toString().equalsIgnoreCase(bosType.toString())) {
            isMaterialField = true;
        }
        return isMaterialField;
    }

    private boolean isMeasureUnitField(String easField) {
        boolean isMeasureUnitField = false;
        BOSObjectType bosType = (BOSObjectType)this.headLinkPropsBosMap.get(easField);
        if (bosType == null) {
            bosType = (BOSObjectType)this.entryLinkPropsBosMap.get(easField);
        }
        if (bosType != null && new MeasureUnitInfo().getBOSType().toString().equalsIgnoreCase(bosType.toString())) {
            isMeasureUnitField = true;
        }
        return isMeasureUnitField;
    }

    private boolean isHandlerField(String easField) {
        boolean isHandlerField = false;
        BOSObjectType bosType = (BOSObjectType)this.headLinkPropsBosMap.get(easField);
        if (bosType == null) {
            bosType = (BOSObjectType)this.entryLinkPropsBosMap.get(easField);
        }
        if (bosType != null && new PersonInfo().getBOSType().toString().equalsIgnoreCase(bosType.toString())) {
            isHandlerField = true;
        }
        return isHandlerField;
    }

    public static String removeZero(Object obj) {
        StringBuffer s = new StringBuffer();
        String sNum = obj.toString();
        try {
            new BigDecimal(sNum);
        }
        catch (NumberFormatException e) {
            logger.error((Object)e);
            return sNum;
        }
        int index = sNum.indexOf(".");
        if (index == -1) {
            return sNum;
        }
        s.append(sNum);
        for (int i = s.length() - 1; i > index && i > 0 && s.charAt(i) == '0'; --i) {
            s.deleteCharAt(i);
        }
        if (s.charAt(s.length() - 1) == '.') {
            s.deleteCharAt(s.length() - 1);
        }
        return s.toString();
    }

    private CustomerInfo getCustomer(String asstActId) {
        CustomerInfo customerInfo = null;
        BOSUuid asstActId1 = BOSUuid.read((String)asstActId);
        if (CustomerInfo.getBosType().equals(asstActId1.getType().toString())) {
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add("taxRegisterNo");
            sic.add("address");
            sic.add("name");
            sic.add("number");
            ObjectUuidPK pk = new ObjectUuidPK(asstActId);
            try {
                customerInfo = CustomerFactory.getRemoteInstance().getCustomerInfo((IObjectPK)pk, sic);
            }
            catch (Exception e) {
                logger.error((Object)e);
            }
        }
        return customerInfo;
    }
}

