/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.cas;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.base.vc.VerifyScopeEnum;
import com.kingdee.eas.basedata.assistant.AccountBankCollection;
import com.kingdee.eas.basedata.assistant.AccountBankFactory;
import com.kingdee.eas.basedata.assistant.AccountBankInfo;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.PeriodUtils;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolUtils;
import com.kingdee.eas.basedata.master.account.AccountViewInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.cas.AgentPayBillCollection;
import com.kingdee.eas.fi.cas.AgentPayBillFactory;
import com.kingdee.eas.fi.cas.AgentPayBillInfo;
import com.kingdee.eas.fi.cas.BillTypeEnum;
import com.kingdee.eas.fi.cas.DefaultBookNotifyBuilder;
import com.kingdee.eas.fi.cas.IAgentPayBill;
import com.kingdee.eas.fi.cas.JournalCollection;
import com.kingdee.eas.fi.cas.JournalInfo;
import com.kingdee.eas.fi.cas.JournalSourceEnum;
import com.kingdee.eas.fi.cas.JournalTypeEnum;
import com.kingdee.eas.fm.common.ContextHelperFactory;
import com.kingdee.eas.fm.common.FMConstants;
import com.kingdee.eas.fm.fin.LoanException;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.util.client.ExceptionHandler;
import java.math.BigDecimal;
import java.util.Date;
import java.util.Iterator;
import java.util.Set;

public class AgentPayBillBookNotifyBuilder
extends DefaultBookNotifyBuilder {
    private SelectorItemCollection getSelector() {
        SelectorItemCollection cel = new SelectorItemCollection();
        cel.add("*");
        cel.add("company.*");
        cel.add("payerAccount.*");
        cel.add("oppAccount.*");
        cel.add("payBankAccount.*");
        return cel;
    }

    private AgentPayBillInfo getAgentPayBillInfo(Context ctx, String billId) throws BOSException, EASBizException {
        IAgentPayBill AgentPayBill2 = AgentPayBillFactory.getLocalInstance(ctx);
        AgentPayBillInfo AgentPayBillInfo2 = AgentPayBill2.getAgentPayBillInfo((IObjectPK)new ObjectUuidPK(billId), this.getSelector());
        return AgentPayBillInfo2;
    }

    private AgentPayBillCollection getAgentPayBillCollection(Context ctx, Set idSet) throws BOSException, EASBizException {
        IAgentPayBill agentPayBill = AgentPayBillFactory.getLocalInstance(ctx);
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)idSet, CompareType.INCLUDE));
        evi.setSelector(this.getSelector());
        evi.setFilter(filter);
        return agentPayBill.getAgentPayBillCollection(evi);
    }

    @Override
    public JournalCollection getJournalColl(Context ctx, Set idSet) throws BOSException, EASBizException {
        AgentPayBillCollection coll = this.getAgentPayBillCollection(ctx, idSet);
        JournalCollection journalCollection = new JournalCollection();
        Iterator it = coll.iterator();
        while (it.hasNext()) {
            AgentPayBillInfo info = (AgentPayBillInfo)it.next();
            this.book(ctx, info.getId().toString(), journalCollection, info);
        }
        return journalCollection;
    }

    @Override
    public JournalCollection getJournalColl(Context ctx, String billId) throws BOSException, EASBizException {
        JournalCollection journalCollection = new JournalCollection();
        AgentPayBillInfo billInfo = this.getAgentPayBillInfo(ctx, billId);
        this.book(ctx, billId, journalCollection, billInfo);
        return journalCollection;
    }

    private void book(Context ctx, String billId, JournalCollection journalCollection, AgentPayBillInfo billInfo) throws BOSException, EASBizException {
        int cs072 = ContextHelperFactory.getLocalInstance((Context)ctx).getIntParam("CS072", (IObjectPK)new ObjectUuidPK(billInfo.getCompany().getId()));
        if (billInfo.getPayerAccount() != null) {
            BigDecimal amount;
            JournalInfo journalInfo;
            if (billInfo.getPayerAccount().isIsBank()) {
                journalInfo = this.createBaseJournal(ctx, billInfo);
                journalInfo.setType(JournalTypeEnum.BANK);
                journalInfo.setAccountBank(billInfo.getPayBankAccount());
                journalInfo.setAccountView(billInfo.getPayerAccount());
                journalInfo.setOppAccountView(billInfo.getOppAccount());
                amount = billInfo.getActualAmount();
                BigDecimal bigDecimal = amount = amount == null ? FMConstants.ZERO : amount;
                if (cs072 == 0) {
                    journalInfo.setCreditAmount(amount);
                    journalInfo.setDebitAmount(FMConstants.ZERO);
                } else if (amount.signum() == 1) {
                    journalInfo.setCreditAmount(amount);
                    journalInfo.setDebitAmount(FMConstants.ZERO);
                } else {
                    journalInfo.setDebitAmount(amount.abs());
                    journalInfo.setCreditAmount(FMConstants.ZERO);
                }
                journalCollection.add(journalInfo);
            } else if (billInfo.getPayerAccount().isIsCash()) {
                journalInfo = this.createBaseJournal(ctx, billInfo);
                journalInfo.setType(JournalTypeEnum.CASH);
                journalInfo.setAccountView(billInfo.getPayerAccount());
                journalInfo.setOppAccountView(billInfo.getOppAccount());
                amount = billInfo.getActualAmount();
                if (cs072 == 0) {
                    journalInfo.setCreditAmount(amount);
                    journalInfo.setDebitAmount(FMConstants.ZERO);
                } else if (amount.signum() == 1) {
                    journalInfo.setCreditAmount(amount);
                    journalInfo.setDebitAmount(FMConstants.ZERO);
                } else {
                    journalInfo.setDebitAmount(amount.abs());
                    journalInfo.setCreditAmount(FMConstants.ZERO);
                }
                journalCollection.add(journalInfo);
            }
        }
        if (billInfo.getOppAccount() != null) {
            JournalInfo journalInfo;
            AccountViewInfo oppAccount = billInfo.getOppAccount();
            if (oppAccount.isIsBank()) {
                journalInfo = this.createBaseJournal(ctx, billInfo);
                journalInfo.setType(JournalTypeEnum.BANK);
                journalInfo.setAccountView(billInfo.getOppAccount());
                journalInfo.setAccountBank(billInfo.getPayBankAccount());
                journalInfo.setOppAccountView(billInfo.getPayerAccount());
                BigDecimal amount = billInfo.getActualAmount();
                if (cs072 == 0) {
                    journalInfo.setDebitAmount(amount);
                    journalInfo.setCreditAmount(FMConstants.ZERO);
                } else if (amount.signum() == 1) {
                    journalInfo.setDebitAmount(amount);
                    journalInfo.setCreditAmount(FMConstants.ZERO);
                } else {
                    journalInfo.setCreditAmount(amount.abs());
                    journalInfo.setDebitAmount(FMConstants.ZERO);
                }
                journalCollection.add(journalInfo);
            } else if (oppAccount.isIsCash()) {
                journalInfo = this.createBaseJournal(ctx, billInfo);
                journalInfo.setType(JournalTypeEnum.CASH);
                journalInfo.setAccountView(billInfo.getOppAccount());
                journalInfo.setOppAccountView(billInfo.getPayerAccount());
                BigDecimal amount = billInfo.getActualAmount();
                if (cs072 == 0) {
                    journalInfo.setDebitAmount(amount);
                    journalInfo.setCreditAmount(FMConstants.ZERO);
                } else if (amount.signum() == 1) {
                    journalInfo.setDebitAmount(amount);
                    journalInfo.setCreditAmount(FMConstants.ZERO);
                } else {
                    journalInfo.setCreditAmount(amount.abs());
                    journalInfo.setDebitAmount(FMConstants.ZERO);
                }
                journalCollection.add(journalInfo);
            }
        }
    }

    private void bookReverse(Context ctx, String billId, JournalCollection journalCollection, AgentPayBillInfo billInfo) throws BOSException, EASBizException {
        if (billInfo.getPayerAccount() != null) {
            BigDecimal amount;
            JournalInfo journalInfo;
            if (billInfo.getPayerAccount().isIsBank()) {
                journalInfo = this.createBaseJournal(ctx, billInfo);
                journalInfo.setType(JournalTypeEnum.BANK);
                journalInfo.setAccountBank(billInfo.getPayBankAccount());
                journalInfo.setAccountView(billInfo.getPayerAccount());
                journalInfo.setOppAccountView(billInfo.getOppAccount());
                amount = billInfo.getActualAmount().negate();
                journalInfo.setCreditAmount(FMConstants.ZERO);
                journalInfo.setDebitAmount(amount);
                journalCollection.add(journalInfo);
            } else if (billInfo.getPayerAccount().isIsCash()) {
                journalInfo = this.createBaseJournal(ctx, billInfo);
                journalInfo.setType(JournalTypeEnum.CASH);
                journalInfo.setAccountView(billInfo.getPayerAccount());
                journalInfo.setOppAccountView(billInfo.getOppAccount());
                amount = billInfo.getActualAmount().negate();
                journalInfo.setCreditAmount(FMConstants.ZERO);
                journalInfo.setDebitAmount(amount);
                journalCollection.add(journalInfo);
            }
        }
        if (billInfo.getOppAccount() != null) {
            JournalInfo journalInfo;
            AccountViewInfo oppAccount = billInfo.getOppAccount();
            if (oppAccount.isIsBank()) {
                journalInfo = this.createBaseJournal(ctx, billInfo);
                journalInfo.setType(JournalTypeEnum.BANK);
                journalInfo.setAccountView(billInfo.getOppAccount());
                journalInfo.setAccountBank(billInfo.getPayBankAccount());
                journalInfo.setOppAccountView(billInfo.getPayerAccount());
                BigDecimal amount = billInfo.getActualAmount().negate();
                journalInfo.setDebitAmount(FMConstants.ZERO);
                journalInfo.setCreditAmount(amount);
                journalCollection.add(journalInfo);
            } else if (oppAccount.isIsCash()) {
                journalInfo = this.createBaseJournal(ctx, billInfo);
                journalInfo.setType(JournalTypeEnum.CASH);
                journalInfo.setAccountView(billInfo.getOppAccount());
                journalInfo.setOppAccountView(billInfo.getPayerAccount());
                BigDecimal amount = billInfo.getActualAmount().negate();
                journalInfo.setDebitAmount(FMConstants.ZERO);
                journalInfo.setCreditAmount(amount);
                journalCollection.add(journalInfo);
            }
        }
    }

    private JournalInfo createBaseJournal(Context ctx, AgentPayBillInfo billInfo) throws BOSException, EASBizException {
        JournalInfo journalInfo = new JournalInfo();
        journalInfo.setCompany(billInfo.getCompany());
        journalInfo.setSource(JournalSourceEnum.BYBILL);
        journalInfo.setBillId(billInfo.getId().toString());
        if (billInfo.isIsCBPay()) {
            journalInfo.setBillType(BillTypeEnum.cbAgentPayBill);
        } else {
            journalInfo.setBillType(BillTypeEnum.AgentPayBill);
        }
        journalInfo.setBillNumber(billInfo.getNumber());
        journalInfo.setBizDate(billInfo.getBizDate());
        CompanyOrgUnitInfo companyInfo1 = billInfo.getCompany();
        Date bookDate = this.getBookDate(ctx, billInfo, companyInfo1);
        journalInfo.setCreateDate(bookDate);
        PeriodInfo bookPeriodInfo = PeriodUtils.getPeriodInfo((Context)ctx, (Date)bookDate, (CompanyOrgUnitInfo)companyInfo1);
        journalInfo.setPeriod(bookPeriodInfo);
        journalInfo.setCurrency(billInfo.getCurrency());
        journalInfo.setPlanItem(billInfo.getFpItem());
        journalInfo.setSettlementType(billInfo.getSettlementType());
        journalInfo.setSettlementNumber(billInfo.getSettleNumber());
        journalInfo.setDescription(billInfo.getDescription());
        UserInfo userInfo = ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentUser();
        journalInfo.setCashier(userInfo);
        journalInfo.setVerifyStatus(VerifyScopeEnum.NOVA);
        journalInfo.setDescription(billInfo.getUsage());
        return journalInfo;
    }

    private Date getBookDate(Context ctx, AgentPayBillInfo billInfo, CompanyOrgUnitInfo companyInfo) throws BOSException, EASBizException {
        PeriodInfo currPeriodInfo = SystemStatusCtrolUtils.getCurrentPeriod((Context)ctx, (SystemEnum)SystemEnum.CASHMANAGEMENT, (CompanyOrgUnitInfo)companyInfo);
        if (currPeriodInfo == null) {
            throw new EASBizException(EASBizException.CHECKBLANK, new Object[]{"current Period"});
        }
        Date bookDate = billInfo.getBizDate();
        boolean iscommit = billInfo.isIsCommitToBE();
        int cs104 = ContextHelperFactory.getLocalInstance((Context)ctx).getIntParam("CS104", (IObjectPK)new ObjectUuidPK(billInfo.getCompany().getId()));
        if (cs104 == 1) {
            bookDate = new Date();
        }
        if (bookDate.before(currPeriodInfo.getBeginDate())) {
            bookDate = currPeriodInfo.getBeginDate();
        }
        if (cs104 == 2) {
            if (iscommit) {
                bookDate = new Date();
            } else if (bookDate.before(currPeriodInfo.getBeginDate())) {
                bookDate = currPeriodInfo.getBeginDate();
            }
        }
        return bookDate;
    }

    public static AccountBankInfo getDefaultAccountBankInfo(Context ctx, String bankAccountNumber, AccountViewInfo Account) throws LoanException {
        EntityViewInfo vi = new EntityViewInfo();
        FilterInfo fInfo = new FilterInfo();
        fInfo.getFilterItems().add(new FilterItemInfo("bankAccountNumber", (Object)bankAccountNumber, CompareType.EQUALS));
        fInfo.getFilterItems().add(new FilterItemInfo("account.id", (Object)Account.getId().toString(), CompareType.EQUALS));
        vi.setFilter(fInfo);
        AccountBankCollection bftCollection = null;
        try {
            bftCollection = AccountBankFactory.getLocalInstance((Context)ctx).getAccountBankCollection(vi);
        }
        catch (BOSException e) {
            ExceptionHandler.handle((Throwable)e);
        }
        if (bftCollection == null || bftCollection.size() == 0) {
            throw new LoanException(LoanException.BLOCKINGFLOWTYPENUMBER001NOTEXISTS);
        }
        AccountBankInfo bftInfo = bftCollection.get(0);
        return bftInfo;
    }
}

