/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.cas;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.IMetaDataLoader;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.fi.cas.AgentPayBillEntryCollection;
import com.kingdee.eas.fi.cas.AgentPayBillEntryInfo;
import com.kingdee.eas.fi.cas.AgentPayBillInfo;
import com.kingdee.eas.fi.cas.IPaymentDisposer;

public class AgentPayBillDisposerFactory {
    public static IPaymentDisposer getDisposer(Context ctx, AgentPayBillInfo info) throws BOSException {
        IPaymentDisposer disposer = null;
        AgentPayBillEntryCollection coll = info.getEntrys();
        int size = coll.size();
        for (int i = 0; i < size; ++i) {
            AgentPayBillEntryInfo entryInfo = coll.get(i);
            if (entryInfo == null) continue;
            disposer = AgentPayBillDisposerFactory.getDisposeInstance(ctx, entryInfo.getSourceBillId());
            break;
        }
        if (disposer == null) {
            disposer = AgentPayBillDisposerFactory.getDisposeInstance(ctx, info.getSourceBillId());
        }
        return disposer;
    }

    private static IPaymentDisposer getDisposeInstance(Context ctx, String bizBillId) throws BOSException {
        if (EmptyUtil.isEmpty((String)bizBillId)) {
            return null;
        }
        IMetaDataLoader loader = null;
        loader = ctx == null ? MetaDataLoaderFactory.getRemoteMetaDataLoader() : MetaDataLoaderFactory.getLocalMetaDataLoader((Context)ctx);
        BOSObjectType bosType = BOSUuid.read((String)bizBillId).getType();
        EntityObjectInfo entity = loader.getEntity(bosType);
        String disposerName = entity.getExtendedProperty("DisposerForPayment");
        if (bosType.equals((Object)BOSObjectType.create((String)"8110AAB2")) || bosType.equals((Object)BOSObjectType.create((String)"7AE53B38")) || bosType.equals((Object)BOSObjectType.create((String)"4A44F49F")) || bosType.equals((Object)BOSObjectType.create((String)"C57003BC")) || bosType.equals((Object)BOSObjectType.create((String)"92F938DD")) || bosType.equals((Object)BOSObjectType.create((String)"30BD2798"))) {
            disposerName = "com.kingdee.eas.cp.bc.AgentBillReBack";
        } else if (bosType.equals((Object)BOSObjectType.create((String)"08E5DB8E")) || bosType.equals((Object)BOSObjectType.create((String)"69DB4584"))) {
            disposerName = "com.kingdee.shr.compensation.agentpay.AgentBillReBack";
        }
        if (EmptyUtil.isEmpty((String)disposerName)) {
            return null;
        }
        try {
            return (IPaymentDisposer)Class.forName(disposerName).newInstance();
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
    }
}

