/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.cas;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.eas.base.param.INewParamCheck;
import com.kingdee.eas.base.param.IParamSetModify;
import com.kingdee.eas.base.param.ParamInfo;
import com.kingdee.eas.base.param.ParamItemCollection;
import com.kingdee.eas.base.param.ParamItemInfo;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolUtils;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.cas.CasException;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.Date;
import java.sql.SQLException;

public class CASParamCheck
implements INewParamCheck,
IParamSetModify {
    public void check(Context ctx, ParamItemCollection coll) throws BOSException, EASBizException {
        ParamItemInfo model = null;
        String key = null;
        String companyId = null;
        for (int i = 0; i < coll.size(); ++i) {
            model = coll.get(i);
            key = model.getKeyID().getNumber();
            companyId = model.getOrgUnitID().getId().toString();
            CompanyOrgUnitInfo company = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(companyId));
            boolean isReal = company.isIsBizUnit();
            if (!"CS001".equals(key) || !isReal) continue;
            this.checkCS001(ctx, companyId);
        }
    }

    private void checkCS001(Context ctx, String companyId) throws BOSException, EASBizException, CasException {
        PeriodInfo currentPeriod = SystemStatusCtrolUtils.getCurrentPeriod((Context)ctx, (SystemEnum)SystemEnum.CASHMANAGEMENT, (IObjectPK)new ObjectUuidPK(companyId));
        if (currentPeriod == null) {
            return;
        }
        java.util.Date beginDate = currentPeriod.getBeginDate();
        String sqlGetPaymentBill = "select top 1 fid from T_CAS_PAYMENTBILL where fcompanyid=? and FBizDate >=? ";
        String sqlGetReceivingBill = "select top 1 fid from T_CAS_RECEIVINGBILL where fcompanyid=? and FBizDate >=? ";
        String sqlGetAgentPayBill = "select top 1 fid from T_CAS_AGENTPAYBILL where fcompanyid=? and FBizDate >=? ";
        String sqlGetFundsMoveBill = "select top 1 fid from T_CAS_FUNDSMOVEBILL where fcompanyid=? and FBizDate >=? ";
        String sqlGetJournal = "select top 1 fid from T_CAS_JOURNAL where fcompanyid=? and FCreateDate >=? ";
        String[] sqlArray = new String[]{sqlGetPaymentBill, sqlGetReceivingBill, sqlGetAgentPayBill, sqlGetFundsMoveBill, sqlGetJournal};
        IRowSet rs = null;
        for (int i = 0; i < sqlArray.length; ++i) {
            rs = DbUtil.executeQuery((Context)ctx, (String)sqlArray[i], (Object[])new Object[]{companyId, new Date(beginDate.getTime())});
            try {
                if (!rs.next()) continue;
                throw new CasException(CasException.CS001CHANGE);
            }
            catch (SQLException e) {
                throw new BOSException((Throwable)e);
            }
        }
    }

    public boolean setParamModify(Context ctx, ParamInfo paramInfo) throws BOSException, EASBizException {
        return false;
    }
}

