/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.cas;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.base.netctrl.IMutexServiceControl;
import com.kingdee.eas.basedata.assistant.ConvertModeEnum;
import com.kingdee.eas.basedata.assistant.ExchangeRateFactory;
import com.kingdee.eas.basedata.assistant.ExchangeRateInfo;
import com.kingdee.eas.basedata.assistant.IExchangeRate;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fi.cas.ArApRecPayException;
import com.kingdee.eas.framework.client.FrameWorkClientUtils;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Date;
import java.util.List;

public class CasRecPayUtil {
    public static void execute(Context ctx, String[] sql) throws BOSException {
        Connection conn = null;
        Statement statement = null;
        StringBuffer sqlstr = new StringBuffer();
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            statement = conn.createStatement();
            if (sql != null) {
                for (int i = 0; i < sql.length; ++i) {
                    statement.addBatch(sql[i]);
                    sqlstr.append(sql[i]).append("\t\n");
                }
            }
            statement.executeBatch();
            statement.clearBatch();
        }
        catch (SQLException exc) {
            try {
                throw new BOSException("Sql execute exception : " + sqlstr, (Throwable)exc);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(statement, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)statement, (Connection)conn);
    }

    public static String getMainOrgNullMsg(OrgType orgType) {
        if (orgType.equals((Object)OrgType.Company)) {
            return CasRecPayUtil.getResource("COMPANYORGNOTNULL");
        }
        return CasRecPayUtil.getResource("MAINBIZORGISNULL");
    }

    public static String getResource(String strKey) {
        if (strKey == null || strKey.trim().length() == 0) {
            return null;
        }
        return EASResource.getString((String)"com.kingdee.eas.fi.cas.CasResource", (String)strKey);
    }

    public static void requestPureMutex(List idList) throws EASBizException {
        IMutexServiceControl mutexServiceControl = FrameWorkClientUtils.createMutexServiceControl();
        String userName = SysContext.getSysContext().getUserName();
        String dcName = SysContext.getSysContext().getDcName();
        boolean flag = true;
        int n = idList.size();
        for (int i = 0; i < n; ++i) {
            if (idList.get(i) == null) continue;
            flag = mutexServiceControl.requestObjIDForUpdate(idList.get(i).toString(), userName, dcName);
        }
        if (!flag) {
            CasRecPayUtil.throwExcetion(EASResource.getString((String)"com.kingdee.eas.fi.cas.client.CasResource", (String)"DataMutex"));
        }
    }

    public static void releasePureMutex(List idList) {
        IMutexServiceControl mutexServiceControl = FrameWorkClientUtils.createMutexServiceControl();
        int n = idList.size();
        for (int i = 0; i < n; ++i) {
            if (idList.get(i) == null) continue;
            mutexServiceControl.releaseObjIDForUpdate(idList.get(i).toString());
        }
    }

    public static ExchangeRateInfo getExchangeRate(Context ctx, CompanyOrgUnitInfo companyOrgUnitInfo, String sourceCur, String destCurrId, Date date) throws EASBizException, BOSException {
        IExchangeRate iexchangRate = null;
        ObjectUuidPK excTablepk = null;
        ObjectUuidPK destCurrpk = null;
        if (companyOrgUnitInfo.getBaseExchangeTable() != null) {
            excTablepk = new ObjectUuidPK(companyOrgUnitInfo.getBaseExchangeTable().getId());
        } else {
            companyOrgUnitInfo = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(companyOrgUnitInfo.getId()));
            excTablepk = new ObjectUuidPK(companyOrgUnitInfo.getBaseExchangeTable().getId());
        }
        if (EmptyUtil.isEmpty((String)destCurrId) && (destCurrId = companyOrgUnitInfo.getBaseCurrency().getId().toString()).equals(sourceCur)) {
            return null;
        }
        destCurrpk = new ObjectUuidPK(destCurrId);
        iexchangRate = ExchangeRateFactory.getLocalInstance((Context)ctx);
        ObjectUuidPK sourceCurrpk = new ObjectUuidPK(sourceCur);
        ExchangeRateInfo erInfo = iexchangRate.getExchangeRateConvertInfo((IObjectPK)excTablepk, (IObjectPK)sourceCurrpk, (IObjectPK)destCurrpk, date);
        return erInfo;
    }

    public static boolean isIndirectExRate(ExchangeRateInfo exRateInfo) {
        if (exRateInfo == null) {
            return false;
        }
        return ConvertModeEnum.INDIRECTEXCHANGERATE.equals((Object)exRateInfo.getConvertMode());
    }

    public static void throwExcetion(String message) throws EASBizException {
        throw new ArApRecPayException(ArApRecPayException.BLANK, new String[]{message});
    }
}

