/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.cas;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.PeriodUtils;
import com.kingdee.eas.basedata.master.account.AccountRefContrastCollection;
import com.kingdee.eas.basedata.master.account.AccountRefContrastFactory;
import com.kingdee.eas.basedata.master.account.AccountRefContrastInfo;
import com.kingdee.eas.basedata.master.account.AccountTools;
import com.kingdee.eas.basedata.master.account.IAccountRefContrast;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.cas.CasException;
import com.kingdee.eas.fm.common.ContextHelperFactory;
import com.kingdee.eas.fm.common.FMException;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.util.DateTimeUtils;
import java.util.Date;

public class CashAccountTool {
    public static String getCurrentAcctTable(Context ctx, String companyID, String curAcctTableID, int periodYear, int periodNumber) throws BOSException, EASBizException {
        AccountRefContrastInfo info = (ctx == null ? AccountRefContrastFactory.getRemoteInstance() : AccountRefContrastFactory.getLocalInstance((Context)ctx)).getLastAcctInfo(companyID, curAcctTableID, periodYear, periodNumber);
        return info == null ? null : info.getEnabledAcctTable().getId().toString();
    }

    public static String getDisplayAcctTable(Context ctx, String companyId, String accountTableId, int beginYear, int beginMonth, int endYear, int endMonth) throws EASBizException, BOSException {
        if (ctx == null) {
            return CashAccountTool.getDisplayAcctTable(companyId, accountTableId, beginYear, beginMonth, endYear, endMonth);
        }
        return null;
    }

    public static String getDisplayAcctTable(String companyId, String accountTableId, int beginYear, int beginMonth, int endYear, int endMonth) throws EASBizException, BOSException {
        AccountRefContrastInfo info;
        CompanyOrgUnitInfo companyInfo = null;
        if (FMHelper.isEmpty((String)companyId)) {
            companyInfo = ContextHelperFactory.getRemoteInstance().getCurrentCompany();
            companyId = companyInfo.getId().toString();
        }
        ObjectUuidPK companyPK = new ObjectUuidPK(companyId);
        if (FMHelper.isEmpty((String)accountTableId)) {
            if (companyInfo == null) {
                companyInfo = CompanyOrgUnitFactory.getRemoteInstance().getCompanyOrgUnitInfo((IObjectPK)companyPK);
            }
            accountTableId = companyInfo.getAccountTable().getId().toString();
        }
        PeriodInfo beginPeriod = PeriodUtils.getPeriodInfo((int)beginYear, (int)beginMonth, (IObjectPK)companyPK);
        PeriodInfo endPeriod = PeriodUtils.getPeriodInfo((int)endYear, (int)endMonth, (IObjectPK)companyPK);
        if (EmptyUtil.isEmpty((CoreBaseInfo)beginPeriod) || EmptyUtil.isEmpty((CoreBaseInfo)endPeriod)) {
            throw new CasException(CasException.STARTPERIODNULL);
        }
        AccountRefContrastCollection coll = CashAccountTool.getStrideAcctRefContrastColl(companyId, beginPeriod.getBeginDate(), endPeriod.getEndDate());
        if (coll != null && coll.size() > 0) {
            AccountRefContrastInfo info2 = null;
            String acctTable = "";
            for (int i = 0; i < coll.size(); ++i) {
                info2 = coll.get(i);
                if (info2.getRefType() != null && 1 == info2.getRefType().getValue()) {
                    throw new FMException(FMException.HASCOMPANYADJUSTACCT, new Object[]{companyInfo.getName()});
                }
                if (info2.getRefType() == null || 2 == info2.getRefType().getValue()) continue;
                acctTable = info2.getDisabledAcctTable().getId().toString();
            }
            if (EmptyUtil.isEmpty((String)acctTable)) {
                acctTable = coll.get(0).getEnabledAcctTable().getId().toString();
            }
            return acctTable;
        }
        if (endPeriod.isIsAdjustPeriod() && (info = AccountRefContrastFactory.getRemoteInstance().getLastAcctInfo(companyId, accountTableId, endYear, endMonth)).getEnabledPeriod() != null && info.getEnabledPeriod().getId().equals((Object)endPeriod.getId())) {
            return info.getDisabledAcctTable() == null ? null : info.getDisabledAcctTable().getId().toString();
        }
        return AccountTools.getCurrentAcctTable((String)companyId, (String)accountTableId, (int)endYear, (int)endMonth);
    }

    public static AccountRefContrastCollection getStrideAcctRefContrastColl(String companyId, Date beginDate, Date endDate) throws BOSException {
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)companyId));
        filter.getFilterItems().add(new FilterItemInfo("enabledPeriod.endDate", (Object)DateTimeUtils.truncateDate((Date)beginDate), CompareType.GREATER_EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("enabledPeriod.endDate", (Object)DateTimeUtils.truncateDate((Date)endDate), CompareType.LESS));
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(filter);
        IAccountRefContrast acctContrast = AccountRefContrastFactory.getRemoteInstance();
        AccountRefContrastCollection coll = acctContrast.getAccountRefContrastCollection(evi);
        return coll;
    }
}

