/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.cas;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.ISQLExecutor;
import com.kingdee.bos.dao.query.SQLExecutorFactory;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.base.multiapprove.IMultiApprove;
import com.kingdee.eas.base.multiapprove.MultiApproveCollection;
import com.kingdee.eas.base.multiapprove.MultiApproveFactory;
import com.kingdee.eas.base.param.IParamControl;
import com.kingdee.eas.base.param.ParamControlFactory;
import com.kingdee.eas.base.permission.IPermissionServiceProvider;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.base.permission.PermissionServiceProviderFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.assistant.AccountBankCollection;
import com.kingdee.eas.basedata.assistant.AccountBankFactory;
import com.kingdee.eas.basedata.assistant.AccountBankInfo;
import com.kingdee.eas.basedata.assistant.ConvertModeEnum;
import com.kingdee.eas.basedata.assistant.CurrencyCollection;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.ExchangeRateFactory;
import com.kingdee.eas.basedata.assistant.ExchangeRateInfo;
import com.kingdee.eas.basedata.assistant.ExchangeTableInfo;
import com.kingdee.eas.basedata.assistant.ICurrency;
import com.kingdee.eas.basedata.assistant.IExchangeRate;
import com.kingdee.eas.basedata.assistant.ISystemStatusCtrol;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.PeriodUtils;
import com.kingdee.eas.basedata.assistant.SharedAcctCollection;
import com.kingdee.eas.basedata.assistant.SharedAcctEntriesCollection;
import com.kingdee.eas.basedata.assistant.SharedAcctEntriesInfo;
import com.kingdee.eas.basedata.assistant.SharedAcctFactory;
import com.kingdee.eas.basedata.assistant.SharedAcctInfo;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolCollection;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolFactory;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolUtils;
import com.kingdee.eas.basedata.master.account.AccountRefContrastCollection;
import com.kingdee.eas.basedata.master.account.AccountRefContrastFactory;
import com.kingdee.eas.basedata.master.account.AccountTableCollection;
import com.kingdee.eas.basedata.master.account.AccountTableFactory;
import com.kingdee.eas.basedata.master.account.AccountTableInfo;
import com.kingdee.eas.basedata.master.account.AccountTools;
import com.kingdee.eas.basedata.master.account.Account_ControlCollection;
import com.kingdee.eas.basedata.master.account.Account_ControlFactory;
import com.kingdee.eas.basedata.master.account.IAccountRefContrast;
import com.kingdee.eas.basedata.org.CompanyOrgUnitCollection;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.ICompanyOrgUnit;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.SysConstant;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fi.cas.BookNotifyException;
import com.kingdee.eas.fi.cas.CasConstants;
import com.kingdee.eas.fi.cas.CasDataException;
import com.kingdee.eas.fi.cas.CashDataSourceEnum;
import com.kingdee.eas.fi.cas.CashDataTypeEnum;
import com.kingdee.eas.fi.cas.client.PeriodHelper;
import com.kingdee.eas.fi.gl.EntryDC;
import com.kingdee.eas.fi.gl.VoucherEntryCollection;
import com.kingdee.eas.fi.gl.VoucherEntryInfo;
import com.kingdee.eas.fi.gl.VoucherInfo;
import com.kingdee.eas.fm.common.ContextHelperFactory;
import com.kingdee.eas.fm.common.DateHelper;
import com.kingdee.eas.fm.common.FMConstants;
import com.kingdee.eas.fm.common.FMException;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.common.IContextHelper;
import com.kingdee.eas.fm.common.UserOptionFactory;
import com.kingdee.eas.fm.common.client.FMClientHelper;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.DateTimeUtils;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.EventListener;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class CashHelper {
    private static Logger logger = Logger.getLogger((String)CashHelper.class.getName());
    private static final String resourcePath = "com.kingdee.eas.fi.cas.CasResources";
    public static final int BOOK_BILL = 0;
    public static final int BOOK_VOUCHER = 1;
    private static final String BEGINDATESTR = "1999-12-31 23:59:59";
    private static final String ENDDATESTR = "2099-12-31 23:59:59";
    private static Map exchangeMap;
    private static Map BankJournalExchangeMap;
    public static final String IS_ONLINE_VC_CHEQUE_PARAM = "CS007";
    private static CurrencyCollection currencyColl;
    private static final String[] glKeys;
    private static Map periodToDate;

    public static int getBookType(String companyId) throws BOSException, EASBizException {
        IParamControl iParamControl = ParamControlFactory.getRemoteInstance();
        String strValue = iParamControl.getParamValue((IObjectPK)new ObjectUuidPK(companyId), "CS001");
        if (strValue == null) {
            return 0;
        }
        return Integer.parseInt(strValue);
    }

    public static void initCombCurrency(KDComboBox cboCurrency, boolean hasAll) {
        cboCurrency.removeAllItems();
        try {
            if (currencyColl == null || currencyColl.isEmpty()) {
                EntityViewInfo view = new EntityViewInfo();
                FilterInfo filter = new FilterInfo();
                filter.getFilterItems().add(new FilterItemInfo("deletedStatus", (Object)1));
                view.setFilter(filter);
                ICurrency iCurrency = CurrencyFactory.getRemoteInstance();
                currencyColl = iCurrency.getCurrencyCollection(view, true);
            }
            cboCurrency.addItems(currencyColl.toArray());
            if (hasAll) {
                CurrencyInfo allCurrencyInfo = new CurrencyInfo();
                allCurrencyInfo.setNumber("all");
                allCurrencyInfo.setName(EASResource.getString((String)resourcePath, (String)"Currency_All"));
                cboCurrency.addItem((Object)allCurrencyInfo);
            }
            CompanyOrgUnitInfo company = SysContext.getSysContext().getCurrentFIUnit();
            FMClientHelper.setSelectObject((KDComboBox)cboCurrency, (Object)company.getBaseCurrency());
        }
        catch (BOSException e) {
            SysUtil.abort((Throwable)e);
        }
        catch (EASBizException e) {
            SysUtil.abort((Throwable)e);
        }
    }

    public static void initCombCurrency(KDComboBox cboCurrency, CurrencyCollection currencyCollParam, boolean hasAll) {
        cboCurrency.removeAllItems();
        cboCurrency.addItems(currencyCollParam.toArray());
        if (hasAll) {
            CurrencyInfo allCurrencyInfo = new CurrencyInfo();
            allCurrencyInfo.setNumber("all");
            allCurrencyInfo.setName(EASResource.getString((String)resourcePath, (String)"all"));
            cboCurrency.addItem((Object)allCurrencyInfo);
        }
        CompanyOrgUnitInfo company = SysContext.getSysContext().getCurrentFIUnit();
        FMClientHelper.setSelectObject((KDComboBox)cboCurrency, (Object)company.getBaseCurrency());
    }

    public static void initCombCurrency(KDComboBox cboCurrency, boolean hasAll, CompanyOrgUnitInfo company) {
        cboCurrency.removeAllItems();
        try {
            if (currencyColl == null || currencyColl.isEmpty()) {
                ICurrency iCurrency = CurrencyFactory.getRemoteInstance();
                currencyColl = iCurrency.getCurrencyCollection(true);
            }
            cboCurrency.addItems(currencyColl.toArray());
            if (hasAll) {
                CurrencyInfo allCurrencyInfo = new CurrencyInfo();
                allCurrencyInfo.setNumber("all");
                allCurrencyInfo.setName(EASResource.getString((String)resourcePath, (String)"all"));
                cboCurrency.addItem((Object)allCurrencyInfo);
            }
            FMClientHelper.setSelectObject((KDComboBox)cboCurrency, (Object)company.getBaseCurrency());
        }
        catch (BOSException e) {
            SysUtil.abort((Throwable)e);
        }
        catch (EASBizException e) {
            SysUtil.abort((Throwable)e);
        }
    }

    public static BigDecimal getYearStartAmount(CashDataSourceEnum dataSource, String companyId, String accountId, String accountBankIds, String currencyId, CashDataTypeEnum dataType) throws EASBizException, BOSException, SQLException {
        CompanyOrgUnitInfo company = new CompanyOrgUnitInfo();
        company.setId(BOSUuid.read((String)companyId));
        PeriodInfo startPeriod = PeriodHelper.getCashStartPeriod((CompanyOrgUnitInfo)company);
        if (startPeriod == null) {
            return CasConstants.ZERO;
        }
        StringBuffer sql = new StringBuffer();
        if (dataType.equals((Object)CashDataTypeEnum.JF)) {
            sql.append("select FDebitStartAmt result from T_CAS_JournalBalance where ");
        } else if (dataType.equals((Object)CashDataTypeEnum.DF)) {
            sql.append("select FCreditStartAmt result from T_CAS_JournalBalance where ");
        } else {
            return SysConstant.BIGZERO;
        }
        sql.append("FCompanyId='").append(companyId).append("' and FCurrencyId ='").append(currencyId).append("' and FPeriodId='").append(startPeriod.getId().toString()).append("'");
        if (dataSource.getValue() == 3) {
            sql.append("and FType= 3");
        } else if (dataSource.getValue() == 1) {
            sql.append("and FType= 2");
        } else {
            sql.append("and FType= 1");
        }
        if (!dataSource.equals((Object)CashDataSourceEnum.C) && !dataSource.equals((Object)CashDataSourceEnum.S) && accountBankIds != null && accountBankIds.length() > 0) {
            sql.append(" and FAccountBankID ='").append(accountBankIds + "'");
        }
        if (accountId != null) {
            sql.append(" and FAccountViewId ='").append(accountId).append("'");
        }
        sql.append(" and FIsInit =1");
        ISQLExecutor executor = SQLExecutorFactory.getRemoteInstance((String)sql.toString());
        IRowSet rowSet = executor.executeSQL();
        BigDecimal result = SysConstant.BIGZERO;
        if (rowSet.next()) {
            result = rowSet.getBigDecimal("result");
        }
        return result;
    }

    public static AccountBankCollection getAccountBankCollection(String[] companyIds, String[] bankIds, boolean isIncludeClosed) throws BOSException {
        Set bankSet = null;
        bankSet = FMHelper.asSet((String[])bankIds);
        HashSet<String> companySet = new HashSet<String>();
        for (int i = 0; i < companyIds.length; ++i) {
            companySet.add(companyIds[i]);
        }
        EntityViewInfo evi = new EntityViewInfo();
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add("id");
        selector.add("number");
        selector.add("bankAccountNumber");
        selector.add("name");
        selector.add("account.id");
        selector.add("account.number");
        selector.add("account.name");
        selector.add("bank.id");
        selector.add("bank.name");
        selector.add("company.name");
        selector.add("company.number");
        FilterInfo fi = new FilterInfo();
        if (companySet != null && companySet.size() > 0) {
            fi.getFilterItems().add(new FilterItemInfo("company.id", companySet, CompareType.INCLUDE));
        }
        if (bankSet != null && bankSet.size() > 0) {
            fi.getFilterItems().add(new FilterItemInfo("bank.id", (Object)bankSet, CompareType.INCLUDE));
        }
        if (!isIncludeClosed) {
            fi.getFilterItems().add(new FilterItemInfo("isClosed", (Object)new Integer(0)));
        }
        evi.setFilter(fi);
        evi.getSelector().addObjectCollection((IObjectCollection)selector);
        evi.getSorter().add(new SorterItemInfo("company"));
        evi.getSorter().add(new SorterItemInfo("bank"));
        AccountBankCollection acctBankCol = AccountBankFactory.getRemoteInstance().getAccountBankCollection(evi);
        return acctBankCol;
    }

    public static BigDecimal getExchange(String companyId, String sourceCurrencyId, String desCurrencyId) throws EASBizException, BOSException {
        CompanyOrgUnitInfo company = CashHelper.getCompanyInfo(BOSUuid.read((String)companyId));
        CurrencyInfo sourceCurrency = new CurrencyInfo();
        sourceCurrency.setId(BOSUuid.read((String)sourceCurrencyId));
        CurrencyInfo desCurrency = null;
        if (desCurrencyId != null) {
            desCurrency = new CurrencyInfo();
            desCurrency.setId(BOSUuid.read((String)desCurrencyId));
        }
        return CashHelper.getExchange(company, sourceCurrency, desCurrency);
    }

    public static BigDecimal getExchange(CompanyOrgUnitInfo company, String sourceCurrencyId, String desCurrencyId) throws EASBizException, BOSException {
        CurrencyInfo sourceCurrency = new CurrencyInfo();
        sourceCurrency.setId(BOSUuid.read((String)sourceCurrencyId));
        CurrencyInfo desCurrency = null;
        if (desCurrencyId != null) {
            desCurrency = new CurrencyInfo();
            desCurrency.setId(BOSUuid.read((String)desCurrencyId));
        }
        return CashHelper.getExchange(company, sourceCurrency, desCurrency);
    }

    public static BigDecimal getExchange(CompanyOrgUnitInfo company, CurrencyInfo sourceCurrency, CurrencyInfo desCurrency) throws EASBizException, BOSException {
        return CashHelper.getExchange(company, sourceCurrency, desCurrency, null);
    }

    public static BigDecimal getExchange(CompanyOrgUnitInfo company, CurrencyInfo sourceCurrency, CurrencyInfo desCurrency, Date date) throws EASBizException, BOSException {
        if (null == date) {
            date = Calendar.getInstance().getTime();
        }
        IExchangeRate iexchangRate = null;
        ObjectUuidPK excTablepk = null;
        ObjectUuidPK sourceCurrpk = null;
        ObjectUuidPK destCurrpk = null;
        if (company == null) {
            company = ContextHelperFactory.getRemoteInstance().getCurrentCompany();
        } else if (company.getBaseExchangeTable() == null || company.getBaseCurrency() == null) {
            company = CashHelper.getCompanyInfo(company.getId());
        }
        if (sourceCurrency == null) {
            MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"221_CashHelper"));
            return null;
        }
        if (desCurrency == null) {
            desCurrency = company.getBaseCurrency();
        }
        if (company.getBaseExchangeTable() == null) {
            MsgBox.showWarning((String)EASResource.getString((String)resourcePath, (String)"NoExchangeTable"));
            return new BigDecimal("0");
        }
        excTablepk = new ObjectUuidPK(company.getBaseExchangeTable().getId());
        if (desCurrency == null) {
            MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"222_CashHelper"));
            return null;
        }
        if (desCurrency.getId().equals((Object)sourceCurrency.getId())) {
            return new BigDecimal("1").setScale(2, 4);
        }
        destCurrpk = new ObjectUuidPK(desCurrency.getId());
        iexchangRate = ExchangeRateFactory.getRemoteInstance();
        sourceCurrpk = new ObjectUuidPK(sourceCurrency.getId());
        BigDecimal er = CashHelper.getBankJournalExchangeCache((IObjectPK)excTablepk, (IObjectPK)sourceCurrpk, (IObjectPK)destCurrpk, date);
        if (er == null) {
            MsgBox.showWarning((String)EASResource.getString((String)resourcePath, (String)"NoExchange"));
            SysUtil.abort();
            return new BigDecimal("0");
        }
        return er;
    }

    public static BigDecimal getBankJournalExchangeCache(IObjectPK excTablepk, IObjectPK sourceCurrpk, IObjectPK destCurrpk, Date date) throws EASBizException, BOSException {
        IExchangeRate iexchangRate = null;
        if (excTablepk == null) {
            return null;
        }
        if (sourceCurrpk == null) {
            return null;
        }
        if (destCurrpk == null) {
            return null;
        }
        if (destCurrpk.equals((Object)sourceCurrpk)) {
            return CasConstants.ONE;
        }
        String key = excTablepk.toString() + sourceCurrpk + destCurrpk + date.getTime();
        if (BankJournalExchangeMap == null) {
            BankJournalExchangeMap = new HashMap();
        }
        if (BankJournalExchangeMap.containsKey(key)) {
            return (BigDecimal)BankJournalExchangeMap.get(key);
        }
        iexchangRate = ExchangeRateFactory.getRemoteInstance();
        ExchangeRateInfo erInfo = iexchangRate.getExchangeRateConvertInfo(excTablepk, sourceCurrpk, destCurrpk, date);
        if (erInfo == null) {
            return null;
        }
        BankJournalExchangeMap.put(key, erInfo.getConvertRate());
        return erInfo.getConvertRate();
    }

    public static int getExchangePre(String companyId, String sourceCurrencyId, String desCurrencyId) throws EASBizException, BOSException {
        CompanyOrgUnitInfo company = CashHelper.getCompanyInfo(BOSUuid.read((String)companyId));
        CurrencyInfo sourceCurrency = new CurrencyInfo();
        sourceCurrency.setId(BOSUuid.read((String)sourceCurrencyId));
        CurrencyInfo desCurrency = null;
        if (desCurrencyId != null) {
            desCurrency = new CurrencyInfo();
            desCurrency.setId(BOSUuid.read((String)desCurrencyId));
        }
        IExchangeRate iexchangRate = null;
        ObjectUuidPK excTablepk = null;
        ObjectUuidPK sourceCurrpk = null;
        ObjectUuidPK destCurrpk = null;
        if (company == null) {
            company = ContextHelperFactory.getRemoteInstance().getCurrentCompany();
        } else if (company.getBaseExchangeTable() == null || company.getBaseCurrency() == null) {
            company = CashHelper.getCompanyInfo(company.getId());
        }
        if (sourceCurrency == null) {
            MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"221_CashHelper"));
            SysUtil.abort();
        }
        if (desCurrency == null) {
            desCurrency = company.getBaseCurrency();
        }
        if (company.getBaseExchangeTable() == null) {
            return 6;
        }
        excTablepk = new ObjectUuidPK(company.getBaseExchangeTable().getId());
        if (desCurrency == null) {
            MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"222_CashHelper"));
            SysUtil.abort();
        }
        destCurrpk = new ObjectUuidPK(desCurrency.getId());
        iexchangRate = ExchangeRateFactory.getRemoteInstance();
        ExchangeRateInfo erInfo = iexchangRate.getExchangeRateConvertInfo((IObjectPK)excTablepk, (IObjectPK)(sourceCurrpk = new ObjectUuidPK(sourceCurrency.getId())), (IObjectPK)destCurrpk, Calendar.getInstance().getTime());
        if (erInfo == null) {
            return 6;
        }
        return erInfo.getPrecision();
    }

    public static int getExchangePre(CompanyOrgUnitInfo company, String sourceCurrencyId, String desCurrencyId) throws EASBizException, BOSException {
        CurrencyInfo sourceCurrency = new CurrencyInfo();
        sourceCurrency.setId(BOSUuid.read((String)sourceCurrencyId));
        CurrencyInfo desCurrency = null;
        if (desCurrencyId != null) {
            desCurrency = new CurrencyInfo();
            desCurrency.setId(BOSUuid.read((String)desCurrencyId));
        }
        IExchangeRate iexchangRate = null;
        ObjectUuidPK excTablepk = null;
        ObjectUuidPK sourceCurrpk = null;
        ObjectUuidPK destCurrpk = null;
        if (company == null) {
            company = ContextHelperFactory.getRemoteInstance().getCurrentCompany();
        } else if (company.getBaseExchangeTable() == null || company.getBaseCurrency() == null) {
            company = CashHelper.getCompanyInfo(company.getId());
        }
        if (sourceCurrency == null) {
            MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"221_CashHelper"));
            SysUtil.abort();
        }
        if (desCurrency == null) {
            desCurrency = company.getBaseCurrency();
        }
        if (company.getBaseExchangeTable() == null) {
            return 6;
        }
        excTablepk = new ObjectUuidPK(company.getBaseExchangeTable().getId());
        if (desCurrency == null) {
            MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"222_CashHelper"));
            SysUtil.abort();
        }
        destCurrpk = new ObjectUuidPK(desCurrency.getId());
        iexchangRate = ExchangeRateFactory.getRemoteInstance();
        ExchangeRateInfo erInfo = iexchangRate.getExchangeRateConvertInfo((IObjectPK)excTablepk, (IObjectPK)(sourceCurrpk = new ObjectUuidPK(sourceCurrency.getId())), (IObjectPK)destCurrpk, Calendar.getInstance().getTime());
        if (erInfo == null) {
            return 6;
        }
        return erInfo.getPrecision();
    }

    public static CompanyOrgUnitInfo getCompanyInfo(BOSUuid bosuuid) {
        ObjectUuidPK compk = new ObjectUuidPK(bosuuid);
        ICompanyOrgUnit comorg = null;
        CompanyOrgUnitInfo comorgInfo = null;
        try {
            comorg = CompanyOrgUnitFactory.getRemoteInstance();
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("number"));
            sic.add(new SelectorItemInfo("name"));
            sic.add(new SelectorItemInfo("accountBank.id"));
            sic.add(new SelectorItemInfo("accountBank.name"));
            sic.add(new SelectorItemInfo("accountBank.number"));
            sic.add(new SelectorItemInfo("baseCurrency.id"));
            sic.add(new SelectorItemInfo("baseCurrency.name"));
            sic.add(new SelectorItemInfo("baseExchangeTable"));
            sic.add(new SelectorItemInfo("accountTable.id"));
            comorgInfo = comorg.getCompanyOrgUnitInfo((IObjectPK)compk, sic);
        }
        catch (Exception e) {
            MsgBox.showInfo((String)"get company fail");
            logger.error((Object)e);
        }
        return comorgInfo;
    }

    public static void analysisVoucher(VoucherInfo voucherInfo, HashMap mapDebit, HashMap mapCredit) {
        if (voucherInfo == null || voucherInfo.getEntries() == null) {
            return;
        }
        if (mapDebit == null) {
            mapDebit = new HashMap<BOSUuid, VoucherEntryInfo>();
        }
        if (mapCredit == null) {
            mapCredit = new HashMap<BOSUuid, VoucherEntryInfo>();
        }
        VoucherEntryCollection voucherEntCollection = voucherInfo.getEntries();
        Iterator iter = voucherEntCollection.iterator();
        VoucherEntryInfo entryInfo = null;
        while (iter.hasNext()) {
            entryInfo = (VoucherEntryInfo)iter.next();
            if (entryInfo.getEntryDC() == EntryDC.DEBIT) {
                mapDebit.put(entryInfo.getId(), entryInfo);
                continue;
            }
            if (entryInfo.getEntryDC() != EntryDC.CREDIT) continue;
            mapCredit.put(entryInfo.getId(), entryInfo);
        }
    }

    public static Map getGLBalanceHashSearchMap(IObjectCollection iObjCol) {
        HashMap<String, IObjectValue> map = new HashMap<String, IObjectValue>();
        IObjectValue objVal = null;
        int colSize = iObjCol.size();
        for (int i = 0; i < colSize; ++i) {
            objVal = iObjCol.getObject(i);
            map.put(CashHelper.getKeyString(objVal, glKeys), objVal);
        }
        return map;
    }

    public static Map getVOHashSearchMap(IObjectCollection iObjCol, String[] keys) {
        HashMap<String, IObjectValue> map = new HashMap<String, IObjectValue>();
        IObjectValue objVal = null;
        int colSize = iObjCol.size();
        for (int i = 0; i < colSize; ++i) {
            objVal = iObjCol.getObject(i);
            map.put(CashHelper.getKeyString(objVal, keys), objVal);
        }
        return map;
    }

    public static Map getVOHashSearchMapWithPeriod(IObjectCollection iObjCol, String[] keys) {
        HashMap<String, IObjectValue> map = new HashMap<String, IObjectValue>();
        IObjectValue objVal = null;
        int colSize = iObjCol.size();
        for (int i = 0; i < colSize; ++i) {
            objVal = iObjCol.getObject(i);
            map.put(FMHelper.getKeyStringWithPeriod((IObjectValue)objVal, (String[])keys), objVal);
        }
        return map;
    }

    public static String getKeyString(IObjectValue iter, String[] keys) {
        return FMHelper.getKeyString((IObjectValue)iter, (String[])keys);
    }

    public static AccountBankCollection getAccountBankCollectionByBank(String[] bankIds, boolean isIncludeClosed) throws BOSException {
        HashSet<String> bankSet = new HashSet<String>();
        for (int i = 0; i < bankIds.length; ++i) {
            bankSet.add(bankIds[i]);
        }
        EntityViewInfo evi = new EntityViewInfo();
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add("id");
        selector.add("number");
        selector.add("name");
        selector.add("account.id");
        selector.add("account.number");
        selector.add("account.name");
        selector.add("company.id");
        FilterInfo fi = new FilterInfo();
        if (bankIds != null) {
            fi.getFilterItems().add(new FilterItemInfo("bank.id", bankSet, CompareType.INCLUDE));
        }
        if (!isIncludeClosed) {
            fi.getFilterItems().add(new FilterItemInfo("isClosed", (Object)new Integer(0)));
        }
        evi.setFilter(fi);
        evi.getSelector().addObjectCollection((IObjectCollection)selector);
        AccountBankCollection acctBankCol = AccountBankFactory.getRemoteInstance().getAccountBankCollection(evi);
        return acctBankCol;
    }

    public static boolean isAssociationGeneralLeger(CompanyOrgUnitInfo company) throws BOSException, EASBizException {
        boolean association = false;
        ISystemStatusCtrol system = SystemStatusCtrolFactory.getRemoteInstance();
        FilterInfo filter = new FilterInfo();
        FilterItemCollection fic = filter.getFilterItems();
        int sb = 7;
        fic.add(new FilterItemInfo("SystemStatus.name", (Object)String.valueOf(sb)));
        fic.add(new FilterItemInfo("isRelatedAccount", (Object)Boolean.TRUE));
        fic.add(new FilterItemInfo("company.ID", (Object)company.getId().toString()));
        association = system.exists(filter);
        return association;
    }

    public static CompanyOrgUnitCollection getAssociationGeneralLeger() throws BOSException, EASBizException {
        ISystemStatusCtrol system = SystemStatusCtrolFactory.getRemoteInstance();
        FilterInfo filter = new FilterInfo();
        FilterItemCollection fic = filter.getFilterItems();
        int sb = 7;
        fic.add(new FilterItemInfo("SystemStatus.name", (Object)String.valueOf(sb)));
        fic.add(new FilterItemInfo("isRelatedAccount", (Object)Boolean.TRUE));
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("*"));
        selector.add(new SelectorItemInfo("company.*"));
        view.setSelector(selector);
        view.setFilter(filter);
        SorterItemCollection sorterColl = new SorterItemCollection();
        sorterColl.add(new SorterItemInfo("company.number"));
        view.setSorter(sorterColl);
        SystemStatusCtrolCollection coll = system.getSystemStatusCtrolCollection(view);
        CompanyOrgUnitCollection companyColl = new CompanyOrgUnitCollection();
        for (int i = 0; i < coll.size(); ++i) {
            companyColl.add(coll.get(i).getCompany());
        }
        return companyColl;
    }

    public static Set getSetByArray(String[] array) {
        HashSet<String> set = new HashSet<String>();
        if (array == null) {
            return set;
        }
        for (int i = 0; i < array.length; ++i) {
            set.add(array[i]);
        }
        return set;
    }

    public static EntityViewInfo getIncludeEntityView(String key, String[] array) {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        view.setFilter(filter);
        Set bankSet = CashHelper.getSetByArray(array);
        if (bankSet != null && bankSet.size() > 0) {
            filter.getFilterItems().add(new FilterItemInfo(key, (Object)bankSet, CompareType.INCLUDE));
        }
        return view;
    }

    public static BigDecimal getExchangeByCache(CompanyOrgUnitInfo company, CurrencyInfo sourceCurrency, CurrencyInfo desCurrency) throws EASBizException, BOSException {
        IExchangeRate iexchangRate = null;
        ObjectUuidPK excTablepk = null;
        ObjectUuidPK sourceCurrpk = null;
        ObjectUuidPK destCurrpk = null;
        if (company == null) {
            return null;
        }
        if (sourceCurrency == null) {
            return null;
        }
        if (desCurrency == null) {
            desCurrency = company.getBaseCurrency();
        }
        if (desCurrency == null) {
            return null;
        }
        if (desCurrency.getId().equals((Object)sourceCurrency.getId())) {
            return CasConstants.ONE;
        }
        String key = company.getId().toString() + sourceCurrency.getId() + desCurrency.getId();
        if (exchangeMap == null) {
            exchangeMap = new HashMap();
        }
        if (exchangeMap.containsKey(key)) {
            return (BigDecimal)exchangeMap.get(key);
        }
        if (company.getBaseExchangeTable() == null) {
            return null;
        }
        excTablepk = new ObjectUuidPK(company.getBaseExchangeTable().getId());
        destCurrpk = new ObjectUuidPK(desCurrency.getId());
        iexchangRate = ExchangeRateFactory.getRemoteInstance();
        sourceCurrpk = new ObjectUuidPK(sourceCurrency.getId());
        ExchangeRateInfo erInfo = iexchangRate.getExchangeRateConvertInfo((IObjectPK)excTablepk, (IObjectPK)sourceCurrpk, (IObjectPK)destCurrpk, Calendar.getInstance().getTime());
        if (erInfo == null) {
            return null;
        }
        exchangeMap.put(key, erInfo.getConvertRate());
        return erInfo.getConvertRate();
    }

    public static AccountTableCollection getAccountViewTable(CompanyOrgUnitInfo company) throws BOSException {
        String cuId = company.getCU().getId().toString();
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("destcu", (Object)cuId));
        filter.getFilterItems().add(new FilterItemInfo("isDefaultForRefer", (Object)new Integer(0)));
        view.setFilter(filter);
        Account_ControlCollection account_ControlCollection = Account_ControlFactory.getRemoteInstance().getAccount_ControlCollection(view);
        int size = account_ControlCollection.size();
        String[] ids = new String[size];
        for (int i = 0; i < size; ++i) {
            ids[i] = account_ControlCollection.get(i).getAccountTableID().getId().toString();
        }
        AccountTableCollection accountTableCollection = AccountTableFactory.getRemoteInstance().getAccountTableCollection(CashHelper.getIncludeEntityView("id", ids));
        return accountTableCollection;
    }

    public static boolean isShowLocalCurrency(String companyId) {
        IContextHelper iCtxHelper = ContextHelperFactory.getRemoteInstance();
        return iCtxHelper.getBooleanParam("CS003", (IObjectPK)new ObjectUuidPK(companyId));
    }

    public static PeriodInfo getPeriodInfo(int periodYear, int periodNumber, CompanyOrgUnitInfo companyInfo) throws BOSException, EASBizException {
        String key = CashHelper.genKey(periodYear, periodNumber);
        if (periodToDate.get(key) == null) {
            PeriodInfo info = PeriodUtils.getPeriodInfo((int)periodYear, (int)periodNumber, (CompanyOrgUnitInfo)companyInfo);
            periodToDate.put(key, info);
        }
        return (PeriodInfo)periodToDate.get(key);
    }

    private static String genKey(int periodYear, int periodNumber) {
        return String.valueOf(periodYear) + "-" + String.valueOf(periodNumber);
    }

    public static int checkVoucherBookDate(String voucherId, CompanyOrgUnitInfo company, boolean isAuto) throws EASBizException, BOSException {
        PeriodInfo currPeriodInfo = SystemStatusCtrolUtils.getCurrentPeriod(null, (SystemEnum)SystemEnum.CASHMANAGEMENT, (CompanyOrgUnitInfo)company);
        VoucherInfo voucher = new VoucherInfo();
        String sSQL = "Select Fid, FNumber, FBookedDate, FBizDate From T_GL_Voucher Where Fid = '" + voucherId + "'";
        ISQLExecutor executor = SQLExecutorFactory.getRemoteInstance((String)sSQL);
        IRowSet rs = executor.executeSQL();
        try {
            if (rs.next()) {
                voucher.setId(BOSUuid.read((String)rs.getString("Fid")));
                voucher.setNumber(rs.getString("FNumber"));
                voucher.setBookedDate((Date)rs.getDate("FBookedDate"));
                voucher.setBizDate((Date)rs.getDate("FBizDate"));
            }
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
        Date voucherBookDate = CashHelper.getVoucherBookDate(voucher, currPeriodInfo, company);
        int result = 0;
        if (isAuto) {
            boolean isBookByAppointTime = CashHelper.isBookByAppointTime(company);
            if (!isBookByAppointTime && currPeriodInfo != null && voucherBookDate != null && currPeriodInfo.getBeginDate().after(voucherBookDate)) {
                result = MsgBox.showConfirm2((String)EASResource.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"224_CashHelper", (Object[])new Object[]{voucher.getNumber()}));
            }
        } else if (currPeriodInfo != null && voucherBookDate != null && currPeriodInfo.getBeginDate().after(voucherBookDate)) {
            String msg = EASResource.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"429_CashHelper") + voucher.getNumber() + EASResource.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"430_CashHelper");
            result = MsgBox.showConfirm2((String)msg);
        }
        return result;
    }

    private static boolean isBookByAppointTime(CompanyOrgUnitInfo company) throws EASBizException, BOSException {
        String BOOK_USER_OPTION_UI = "com.kingdee.eas.fi.cas.client.BookUserOptionUI";
        Map map = CashHelper.getBookOptionMap(BOOK_USER_OPTION_UI, company);
        if (map == null) {
            throw new BookNotifyException(BookNotifyException.SETOPTION);
        }
        boolean isByAppointTime = new Boolean((String)map.get("kDRadioButtonAppointTime"));
        return isByAppointTime;
    }

    private static Date getVoucherBookDate(VoucherInfo voucher, PeriodInfo currPeriod, CompanyOrgUnitInfo company) throws EASBizException, BOSException {
        String BOOK_USER_OPTION_UI = "com.kingdee.eas.fi.cas.client.BookUserOptionUI";
        String BOOK_APPOINT_DATE_UI_NAME = "com.kingdee.eas.fi.cas.client.BookAppointDateUI";
        Map map = CashHelper.getBookOptionMap(BOOK_USER_OPTION_UI, company);
        boolean isBySystemTime = false;
        boolean isByBillTime = true;
        boolean isByBizTime = false;
        boolean isByAppointTime = false;
        if (map != null) {
            isBySystemTime = new Boolean((String)map.get("kDRadioButtonSystemTime"));
            isByBillTime = new Boolean((String)map.get("kDRadioButtonBillTime"));
            isByBizTime = new Boolean((String)map.get("kDRadioButtonBizTime"));
            isByAppointTime = new Boolean((String)map.get("kDRadioButtonAppointTime"));
        }
        Date bookDate = null;
        if (isBySystemTime) {
            bookDate = DateHelper.getDayBegin();
        } else if (isByBillTime) {
            bookDate = voucher.getBookedDate();
        } else if (isByAppointTime) {
            Map bookDateMap = CashHelper.getBookOptionMap(BOOK_APPOINT_DATE_UI_NAME);
            bookDate = bookDateMap != null && bookDateMap.get("dpkBookDate") != null ? DateHelper.stringToDate((String)((String)bookDateMap.get("dpkBookDate"))) : voucher.getBookedDate();
        } else if (isByBizTime && (bookDate = voucher.getBizDate()).before(currPeriod.getBeginDate())) {
            String number;
            String companyName;
            String message = EASResource.getString((String)resourcePath, (String)"bookDateConfig");
            String detail = MessageFormat.format(message, companyName = company.getName(), number = voucher.getNumber());
            if (MsgBox.showConfirm2((String)detail) == 2) {
                SysUtil.abort();
            }
            bookDate = currPeriod.getBeginDate();
        }
        return bookDate;
    }

    private static Map getBookOptionMap(String uiName) throws BOSException, EASBizException {
        Map map = UserOptionFactory.getRemoteInstance().getUserOptionMap(uiName);
        return map;
    }

    private static Map getBookOptionMap(String uiName, CompanyOrgUnitInfo company) throws BOSException, EASBizException {
        Map map = UserOptionFactory.getRemoteInstance().getUserOptionMap(null, company.getId().toString(), uiName, null);
        return map;
    }

    public static Set getCompanyIds(Context ctx, String companyNum) throws BOSException {
        if (FMHelper.isEmpty((String)companyNum)) {
            return null;
        }
        companyNum = companyNum.replaceAll("'", "''");
        StringBuffer sql = new StringBuffer(120);
        sql.append("select fid from t_org_company where (");
        if (companyNum.indexOf(";") > 0) {
            String[] nums = companyNum.split(";");
            for (int i = 0; i < nums.length; ++i) {
                if (i > 0) {
                    sql.append(" or ");
                }
                sql.append(" (FNumber = '").append(nums[i].trim()).append("'").append(" or FLongNumber like '").append(companyNum).append("!%' ").append(" or FLongNumber like '%!").append(companyNum).append("!%') ");
            }
        } else {
            sql.append(" FNumber = '").append(companyNum.trim()).append("'").append(" or FLongNumber like '").append(companyNum).append("!%' ").append(" or FLongNumber like '%!").append(companyNum).append("!%'");
        }
        sql.append(" ) and FIsOnlyUnion =0 ");
        sql.append(" order by FLongNumber asc");
        try {
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
            HashSet<String> idSet = new HashSet<String>();
            while (rs.next()) {
                idSet.add(rs.getString("fid"));
            }
            if (idSet.size() > 0) {
                return idSet;
            }
            return null;
        }
        catch (SQLException ex) {
            throw new BOSException((Throwable)ex);
        }
    }

    public static Set getBankAcctIds(Context ctx, String companyNum, String bankAcctNum, boolean isMulUnionQuery) throws BOSException, EASBizException {
        Set<String> ids;
        if (FMHelper.isEmpty((String)bankAcctNum)) {
            return null;
        }
        HashSet<String> acctIdSet = new HashSet<String>();
        StringBuffer sql = new StringBuffer(100);
        sql.append("select acct.Fid FID from t_bd_accountbanks acct left join T_Org_Company org ON Acct.FCompanyID = org.Fid where 1=1 ");
        sql.append(" and acct.FNumber = '").append(bankAcctNum.trim()).append("'");
        sql.append(" and org.FNumber = '").append(companyNum.trim()).append("'");
        try {
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
            while (rs.next()) {
                if (rs.getString("FID") == null) continue;
                acctIdSet.add(rs.getString("FID"));
            }
        }
        catch (SQLException ex) {
            throw new BOSException((Throwable)ex);
        }
        if (isMulUnionQuery && !EmptyUtil.isEmpty(ids = CashHelper.getMulUnionQueryBankAccts(ctx, companyNum, bankAcctNum))) {
            acctIdSet.addAll(ids);
        }
        if (acctIdSet.size() > 0) {
            return acctIdSet;
        }
        throw new CasDataException(CasDataException.NULL_ACCOUNTBANK);
    }

    private static Set<String> getMulUnionQueryBankAccts(Context ctx, String companyNum, String bankAcctNum) throws BOSException {
        HashSet<String> acctIdSet = new HashSet<String>();
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        view.setFilter(filter);
        SelectorItemCollection sic = new SelectorItemCollection();
        view.setSelector(sic);
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("entries.accountBank.id"));
        sic.add(new SelectorItemInfo("entries.id"));
        filter.getFilterItems().add(new FilterItemInfo("bankAccount.number", (Object)bankAcctNum));
        filter.getFilterItems().add(new FilterItemInfo("shareBalanceOfAcctCompany.number", (Object)companyNum));
        SharedAcctCollection colls = SharedAcctFactory.getLocalInstance((Context)ctx).getSharedAcctCollection(view);
        if (colls.size() > 0) {
            SharedAcctInfo info = colls.get(0);
            for (int index = 0; index < info.getEntries().size(); ++index) {
                SharedAcctEntriesInfo entry = info.getEntries().get(index);
                if (entry == null || entry.getAccountBank() == null) continue;
                acctIdSet.add(entry.getAccountBank().getId().toString());
            }
        } else {
            String sql = "select FPARENTID  from T_BD_SharedAcctentries where FACCOUNTBANKID in (select acct.fid from T_BD_ACCOUNTBANKS acct LEFT JOIN T_Org_Company org ON acct.FCOMPANYID = org.FID WHERE acct.FNUMBER = ? AND org.FNUMBER = ?)";
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{bankAcctNum, companyNum});
            try {
                while (rs.next()) {
                    String id = rs.getString("FPARENTID");
                    sic.add(new SelectorItemInfo("bankAccount.id"));
                    SharedAcctInfo sharedAcct = SharedAcctFactory.getLocalInstance((Context)ctx).getSharedAcctInfo((IObjectPK)new ObjectUuidPK(id), sic);
                    if (sharedAcct != null && sharedAcct.getBankAccount() != null) {
                        acctIdSet.add(sharedAcct.getBankAccount().getId().toString());
                    }
                    if (sharedAcct == null || sharedAcct.getEntries() == null || sharedAcct.getEntries().size() <= 0) continue;
                    for (int index = 0; index < sharedAcct.getEntries().size(); ++index) {
                        SharedAcctEntriesInfo entry = sharedAcct.getEntries().get(index);
                        if (entry == null || entry.getAccountBank() == null) continue;
                        acctIdSet.add(entry.getAccountBank().getId().toString());
                    }
                }
            }
            catch (SQLException e) {
                logger.error((Object)e);
            }
            catch (EASBizException e) {
                logger.error((Object)e);
            }
        }
        return acctIdSet;
    }

    public static String getPermissionRule(Context ctx, String permission) {
        IContextHelper ctxHelper = ctx != null ? ContextHelperFactory.getLocalInstance((Context)ctx) : ContextHelperFactory.getRemoteInstance();
        ObjectUuidPK userPK = new ObjectUuidPK(ctxHelper.getCurrentUser().getId());
        ObjectUuidPK orgPK = new ObjectUuidPK(ctxHelper.getCurrentCompany().getId());
        try {
            IPermissionServiceProvider provider = ctx != null ? PermissionServiceProviderFactory.getLocalInstance((Context)ctx) : PermissionServiceProviderFactory.getRemoteInstance();
            return provider.getPermissionRule((IObjectPK)userPK, (IObjectPK)orgPK, permission);
        }
        catch (EASBizException e) {
            logger.error((Object)e);
            return null;
        }
        catch (BOSException e) {
            logger.error((Object)e);
            return null;
        }
    }

    public static String getAccBankPermissionRule(Context ctx) {
        return CashHelper.getPermissionRule(ctx, "bd_assistant_accountBank_view");
    }

    public static MultiApproveCollection getMutiApprove(String billId) throws BOSException {
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("billId", (Object)billId));
        evi.setFilter(filter);
        evi.getSelector().add(new SelectorItemInfo("creator.name"));
        evi.getSelector().add(new SelectorItemInfo("isPass"));
        evi.getSelector().add(new SelectorItemInfo("opinion"));
        SorterItemInfo sic = new SorterItemInfo("CreateTime");
        sic.setSortType(SortType.ASCEND);
        evi.getSorter().add(sic);
        IMultiApprove iMutiApprove = MultiApproveFactory.getRemoteInstance();
        MultiApproveCollection col = iMutiApprove.getMultiApproveCollection(evi);
        return col;
    }

    public static boolean isTheSameMonth(Date bdate, Date edate) {
        String s2;
        SimpleDateFormat df = new SimpleDateFormat("yyyyMM");
        String s1 = df.format(bdate);
        return s1 == (s2 = df.format(edate)) || s1.equals(s2);
    }

    public static String getActualAcctTable(Context ctx, String companyId, Date beginDate, Date endDate) throws BOSException, EASBizException {
        ICompanyOrgUnit iCompany = null;
        iCompany = ctx == null ? CompanyOrgUnitFactory.getRemoteInstance() : CompanyOrgUnitFactory.getLocalInstance((Context)ctx);
        CompanyOrgUnitInfo company = iCompany.getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(companyId));
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)companyId));
        filter.getFilterItems().add(new FilterItemInfo("enabledPeriod.endDate", (Object)beginDate, CompareType.GREATER_EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("enabledPeriod.endDate", (Object)endDate, CompareType.LESS));
        evi.setFilter(filter);
        try {
            IAccountRefContrast acctContrast = null;
            acctContrast = ctx == null ? AccountRefContrastFactory.getRemoteInstance() : AccountRefContrastFactory.getLocalInstance((Context)ctx);
            AccountRefContrastCollection coll = acctContrast.getAccountRefContrastCollection(evi);
            if (coll == null || coll.isEmpty()) {
                PeriodInfo period = PeriodUtils.getPeriodInfo((Context)ctx, (Date)beginDate, (CompanyOrgUnitInfo)company);
                int yearNumber = period.getPeriodYear();
                int monthNumber = period.getPeriodNumber();
                AccountTableInfo tbl = company.getAccountTable();
                String currTableId = AccountTools.getCurrentAcctTable((Context)ctx, (String)companyId, (String)tbl.getId().toString(), (int)yearNumber, (int)monthNumber);
                return currTableId;
            }
        }
        catch (EASBizException e) {
            logger.error((Object)e);
        }
        catch (BOSException e) {
            logger.error((Object)e);
        }
        throw new FMException(FMException.HASADJUSTACCT);
    }

    public static void setBankF7IncludeShared(KDBizPromptBox prmt, CompanyOrgUnitInfo info, boolean isClosed) throws BOSException {
        int i;
        EntityViewInfo evi = new EntityViewInfo();
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add("id");
        selector.add("*");
        selector.add("number");
        selector.add("name");
        selector.add("bankAccountNumber");
        selector.add("account.id");
        selector.add("account.number");
        selector.add("account.name");
        FilterInfo fi = new FilterInfo();
        if (info.getId() != null) {
            fi.getFilterItems().add(new FilterItemInfo("company.id", (Object)info.getId().toString()));
        }
        if (!isClosed) {
            fi.getFilterItems().add(new FilterItemInfo("isClosed", (Object)new Integer(0)));
        }
        fi.getFilterItems().add(new FilterItemInfo("isBank", (Object)FMConstants.TRUE));
        fi.getFilterItems().add(new FilterItemInfo("shareType", (Object)0, CompareType.EQUALS));
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("bankAccount.id");
        sic.add("bankAccount.company.id");
        sic.add("entries.accountBank.company.id");
        view.setSelector(sic);
        filter.getFilterItems().add(new FilterItemInfo("shareBalanceOfAcctCompany.id", (Object)info.getId().toString(), CompareType.EQUALS));
        view.setFilter(filter);
        SharedAcctCollection coll = SharedAcctFactory.getRemoteInstance().getSharedAcctCollection(view);
        HashSet<String> sharedAcctSet = new HashSet<String>();
        for (int i2 = 0; i2 < coll.size(); ++i2) {
            SharedAcctInfo sharedAcct = coll.get(i2);
            AccountBankInfo bankAcct = sharedAcct.getBankAccount();
            if (bankAcct.getCompany().getId().equals((Object)info.getId())) {
                sharedAcctSet.add(bankAcct.getId().toString());
                continue;
            }
            SharedAcctEntriesCollection colls = sharedAcct.getEntries();
            for (int index = 0; index < colls.size(); ++index) {
                bankAcct = colls.get(index).getAccountBank();
                if (!bankAcct.getCompany().getId().equals((Object)info.getId())) continue;
                sharedAcctSet.add(bankAcct.getId().toString());
            }
        }
        if (!EmptyUtil.isEmpty(sharedAcctSet)) {
            fi.getFilterItems().add(new FilterItemInfo("id", sharedAcctSet, CompareType.INCLUDE));
            if (isClosed) {
                fi.setMaskString("((#0 and #1 and #2) or #3)");
            } else {
                fi.setMaskString("((#0 and #1 and #2 and #3) or #4)");
            }
        }
        try {
            ObjectUuidPK userPK = new ObjectUuidPK(SysContext.getSysContext().getCurrentUserInfo().getId().toString());
            ObjectUuidPK orgPK = new ObjectUuidPK(info.getId().toString());
            String sql = PermissionFactory.getRemoteInstance().getQueryPermissionSQL((IObjectPK)userPK, (IObjectPK)orgPK, "bd_assistant_accountBank_view");
            if (!EmptyUtil.isEmpty((String)sql.trim())) {
                FilterInfo filt = new FilterInfo();
                filt.getFilterItems().add(new FilterItemInfo("id", (Object)sql, CompareType.INNER));
                fi.mergeFilter(filt, "AND");
            }
        }
        catch (Exception e) {
            logger.info((Object)e);
        }
        evi.setFilter(fi);
        evi.getSelector().addObjectCollection((IObjectCollection)selector);
        evi.getSorter().add(new SorterItemInfo("number"));
        AccountBankCollection acctBankCol = AccountBankFactory.getRemoteInstance().getAccountBankCollection(evi);
        EventListener[] el = prmt.getListeners(DataChangeListener.class);
        for (i = 0; i < el.length; ++i) {
            prmt.removeDataChangeListener((DataChangeListener)el[i]);
        }
        if (prmt.getValue() == null) {
            prmt.setValue((Object)acctBankCol.get(0));
        }
        for (i = 0; i < el.length; ++i) {
            prmt.addDataChangeListener((DataChangeListener)el[i]);
        }
        EntityViewInfo evi2 = new EntityViewInfo();
        evi2.setFilter(fi);
        prmt.setEntityViewInfo(evi2);
    }

    public static void setBankF7IncludeSharedNew(KDBizPromptBox prmt, CompanyOrgUnitInfo info, boolean isClosed) throws BOSException {
        int i;
        EntityViewInfo evi = new EntityViewInfo();
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add("id");
        selector.add("*");
        selector.add("number");
        selector.add("name");
        selector.add("bankAccountNumber");
        selector.add("account.id");
        selector.add("account.number");
        selector.add("account.name");
        FilterInfo fi = new FilterInfo();
        if (info.getId() != null) {
            fi.getFilterItems().add(new FilterItemInfo("company.id", (Object)info.getId().toString()));
        }
        if (!isClosed) {
            fi.getFilterItems().add(new FilterItemInfo("isClosed", (Object)new Integer(0)));
        }
        fi.getFilterItems().add(new FilterItemInfo("isBank", (Object)FMConstants.TRUE));
        fi.getFilterItems().add(new FilterItemInfo("shareType", (Object)0, CompareType.EQUALS));
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("bankAccount.id");
        sic.add("bankAccount.company.id");
        sic.add("entries.accountBank.company.id");
        view.setSelector(sic);
        filter.getFilterItems().add(new FilterItemInfo("shareBalanceOfAcctCompany.id", (Object)info.getId().toString(), CompareType.EQUALS));
        view.setFilter(filter);
        SharedAcctCollection coll = SharedAcctFactory.getRemoteInstance().getSharedAcctCollection(view);
        HashSet<String> sharedAcctSet = new HashSet<String>();
        block2: for (int i2 = 0; i2 < coll.size(); ++i2) {
            SharedAcctInfo sharedAcct = coll.get(i2);
            AccountBankInfo bankAcct = sharedAcct.getBankAccount();
            if (bankAcct.getCompany().getId().toString().equals(info.getId().toString())) {
                sharedAcctSet.add(bankAcct.getId().toString());
                continue;
            }
            SharedAcctEntriesCollection colls = sharedAcct.getEntries();
            for (int index = 0; index < colls.size(); ++index) {
                bankAcct = colls.get(index).getAccountBank();
                if (bankAcct == null || !bankAcct.getCompany().getId().toString().equals(info.getId().toString())) continue;
                sharedAcctSet.add(bankAcct.getId().toString());
                continue block2;
            }
        }
        if (!EmptyUtil.isEmpty(sharedAcctSet)) {
            fi.getFilterItems().add(new FilterItemInfo("id", sharedAcctSet, CompareType.INCLUDE));
            if (isClosed) {
                fi.setMaskString("((#0 and #1 and #2) or #3)");
            } else {
                fi.setMaskString("((#0 and #1 and #2 and #3) or #4)");
            }
        }
        try {
            ObjectUuidPK userPK = new ObjectUuidPK(SysContext.getSysContext().getCurrentUserInfo().getId().toString());
            ObjectUuidPK orgPK = new ObjectUuidPK(info.getId().toString());
            String sql = PermissionFactory.getRemoteInstance().getQueryPermissionSQL((IObjectPK)userPK, (IObjectPK)orgPK, "bd_assistant_accountBank_view");
            if (!EmptyUtil.isEmpty((String)sql.trim())) {
                FilterInfo filt = new FilterInfo();
                filt.getFilterItems().add(new FilterItemInfo("id", (Object)sql, CompareType.INNER));
                fi.mergeFilter(filt, "AND");
            }
        }
        catch (Exception e) {
            logger.info((Object)e);
        }
        evi.setFilter(fi);
        evi.getSelector().addObjectCollection((IObjectCollection)selector);
        evi.getSorter().add(new SorterItemInfo("number"));
        AccountBankCollection acctBankCol = AccountBankFactory.getRemoteInstance().getAccountBankCollection(evi);
        EventListener[] el = prmt.getListeners(DataChangeListener.class);
        for (i = 0; i < el.length; ++i) {
            prmt.removeDataChangeListener((DataChangeListener)el[i]);
        }
        if (prmt.getValue() == null) {
            prmt.setValue((Object)acctBankCol.get(0));
        }
        for (i = 0; i < el.length; ++i) {
            prmt.addDataChangeListener((DataChangeListener)el[i]);
        }
        EntityViewInfo evi2 = new EntityViewInfo();
        evi2.setFilter(fi);
        prmt.setEntityViewInfo(evi2);
    }

    public static void setBankF7(KDBizPromptBox prmt, CompanyOrgUnitInfo info, boolean isClosed) throws BOSException {
        int i;
        EntityViewInfo evi = new EntityViewInfo();
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add("id");
        selector.add("*");
        selector.add("number");
        selector.add("name");
        selector.add("bankAccountNumber");
        selector.add("account.id");
        selector.add("account.number");
        selector.add("account.name");
        FilterInfo fi = new FilterInfo();
        if (info.getId() != null) {
            fi.getFilterItems().add(new FilterItemInfo("company.id", (Object)info.getId().toString()));
        }
        if (!isClosed) {
            fi.getFilterItems().add(new FilterItemInfo("isClosed", (Object)new Integer(0)));
        }
        fi.getFilterItems().add(new FilterItemInfo("isBank", (Object)FMConstants.TRUE));
        try {
            ObjectUuidPK userPK = new ObjectUuidPK(SysContext.getSysContext().getCurrentUserInfo().getId().toString());
            ObjectUuidPK orgPK = new ObjectUuidPK(info.getId().toString());
            String sql = PermissionFactory.getRemoteInstance().getQueryPermissionSQL((IObjectPK)userPK, (IObjectPK)orgPK, "bd_assistant_accountBank_view");
            if (!EmptyUtil.isEmpty((String)sql.trim())) {
                FilterInfo filt = new FilterInfo();
                filt.getFilterItems().add(new FilterItemInfo("id", (Object)sql, CompareType.INNER));
                fi.mergeFilter(filt, "AND");
            }
        }
        catch (Exception e) {
            logger.info((Object)e);
        }
        evi.setFilter(fi);
        evi.getSelector().addObjectCollection((IObjectCollection)selector);
        evi.getSorter().add(new SorterItemInfo("number"));
        AccountBankCollection acctBankCol = AccountBankFactory.getRemoteInstance().getAccountBankCollection(evi);
        EventListener[] el = prmt.getListeners(DataChangeListener.class);
        for (i = 0; i < el.length; ++i) {
            prmt.removeDataChangeListener((DataChangeListener)el[i]);
        }
        if (prmt.getValue() == null) {
            prmt.setValue((Object)acctBankCol.get(0));
        } else {
            boolean isContain = false;
            AccountBankInfo accountBankInfo = (AccountBankInfo)prmt.getValue();
            int length = acctBankCol.size();
            for (int i2 = 0; i2 < length; ++i2) {
                if (!acctBankCol.get(i2).getId().equals((Object)accountBankInfo.getId())) continue;
                isContain = true;
                break;
            }
            if (!isContain) {
                prmt.setValue((Object)acctBankCol.get(0));
            }
        }
        for (i = 0; i < el.length; ++i) {
            prmt.addDataChangeListener((DataChangeListener)el[i]);
        }
        EntityViewInfo evi2 = new EntityViewInfo();
        evi2.setFilter(fi);
        prmt.setEntityViewInfo(evi2);
    }

    public static boolean isValidDate(Object obj) throws BOSException {
        boolean b = false;
        String strObj = obj.toString();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        SimpleDateFormat sdf2 = new SimpleDateFormat("yyyy-MM-dd");
        Date date = null;
        Date beginDate = null;
        Date endDate = null;
        try {
            date = sdf2.parse(strObj);
            beginDate = sdf.parse(BEGINDATESTR);
            endDate = sdf.parse(ENDDATESTR);
        }
        catch (Exception e) {
            logger.error((Object)e);
            return false;
        }
        if (date.before(endDate) && date.after(beginDate)) {
            b = true;
        }
        return b;
    }

    public static String periodFormatConvert(PeriodInfo period) {
        StringBuffer sb = new StringBuffer();
        sb.append(period.getPeriodNumber());
        sb.append("-" + period.getPeriodYear());
        return sb.toString();
    }

    public static boolean isEmpty(String s) {
        return s == null || s.trim().length() == 0;
    }

    public static ExchangeRateInfo getExRateInfo(Context ctx, CurrencyInfo srcCurr, CurrencyInfo destCurr, CompanyOrgUnitInfo company, Date date) throws EASBizException, BOSException {
        ExchangeTableInfo baseExchangeTable;
        if (srcCurr == null || date == null) {
            return null;
        }
        if (company == null) {
            company = ctx == null ? ContextHelperFactory.getRemoteInstance().getCurrentCompany() : ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentCompany();
        }
        if (destCurr == null) {
            destCurr = company.getBaseCurrency();
        }
        if ((baseExchangeTable = company.getBaseExchangeTable()) == null) {
            return null;
        }
        date = DateTimeUtils.truncateDate((Date)date);
        if (srcCurr.equalsPK((IObjectValue)destCurr)) {
            return null;
        }
        ObjectUuidPK sourceCurrpk = new ObjectUuidPK(srcCurr.getId());
        ObjectUuidPK destCurrpk = new ObjectUuidPK(destCurr.getId());
        ObjectUuidPK exchangeTablepk = new ObjectUuidPK(baseExchangeTable.getId());
        IExchangeRate iExchangeRate = null;
        iExchangeRate = ctx == null ? ExchangeRateFactory.getRemoteInstance() : ExchangeRateFactory.getLocalInstance((Context)ctx);
        ExchangeRateInfo exRateInfo = iExchangeRate.getExchangeRate((IObjectPK)exchangeTablepk, (IObjectPK)sourceCurrpk, (IObjectPK)destCurrpk, date);
        return exRateInfo;
    }

    public static boolean isIndirectExRate(ExchangeRateInfo exRateInfo) {
        if (exRateInfo == null) {
            return false;
        }
        return exRateInfo.getConvertMode().equals((Object)ConvertModeEnum.INDIRECTEXCHANGERATE);
    }

    public static boolean isDatePeriod(Date date, PeriodInfo period, CompanyOrgUnitInfo companyInfo) {
        PeriodInfo periodTmp = null;
        try {
            periodTmp = PeriodUtils.getPeriodInfo((Date)date, (CompanyOrgUnitInfo)companyInfo);
        }
        catch (EASBizException e) {
            SysUtil.abort((Throwable)e);
        }
        catch (BOSException e) {
            SysUtil.abort((Throwable)e);
        }
        if (periodTmp == null) {
            return false;
        }
        return periodTmp.equals((Object)period);
    }

    public static boolean isEquals(String s1, String s2) {
        if (null == s1) {
            return null == s2;
        }
        return s1.equals(s2);
    }

    public static boolean isEquals(Date date1, Date date2) {
        return CashHelper.isEquals(date1.toString(), date2.toString());
    }

    public static boolean isShareBalanceOfAcctCompany(Context ctx, AccountBankInfo accountbank) throws EASBizException, BOSException {
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("id"));
        selector.add(new SelectorItemInfo("company.*"));
        selector.add(new SelectorItemInfo("shareAcct.*"));
        selector.add(new SelectorItemInfo("shareType"));
        AccountBankInfo accBankInfo = null;
        accBankInfo = ctx == null ? AccountBankFactory.getRemoteInstance().getAccountBankInfo((IObjectPK)new ObjectUuidPK(accountbank.getId().toString()), selector) : AccountBankFactory.getLocalInstance((Context)ctx).getAccountBankInfo((IObjectPK)new ObjectUuidPK(accountbank.getId().toString()), selector);
        if (accBankInfo.getShareType().getValue() == 0) {
            return true;
        }
        SharedAcctInfo sharedAcctInfo = accBankInfo.getShareAcct();
        String currentCompanyid = "";
        currentCompanyid = ctx == null ? ContextHelperFactory.getRemoteInstance().getCurrentCompany().getId().toString() : ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentCompany().getId().toString();
        return sharedAcctInfo.getShareBalanceOfAcctCompany().getId().toString().equals(currentCompanyid);
    }

    public static boolean isShareBalanceOfAcctCompany(Context ctx, AccountBankInfo accountbank, String companyid) throws EASBizException, BOSException {
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("id"));
        selector.add(new SelectorItemInfo("company.*"));
        selector.add(new SelectorItemInfo("shareAcct.*"));
        selector.add(new SelectorItemInfo("shareType"));
        AccountBankInfo accBankInfo = null;
        accBankInfo = ctx == null ? AccountBankFactory.getRemoteInstance().getAccountBankInfo((IObjectPK)new ObjectUuidPK(accountbank.getId().toString()), selector) : AccountBankFactory.getLocalInstance((Context)ctx).getAccountBankInfo((IObjectPK)new ObjectUuidPK(accountbank.getId().toString()), selector);
        if (accBankInfo.getShareType().getValue() == 0) {
            return true;
        }
        SharedAcctInfo sharedAcctInfo = accBankInfo.getShareAcct();
        return sharedAcctInfo.getShareBalanceOfAcctCompany() != null && sharedAcctInfo.getShareBalanceOfAcctCompany().getId().toString().equals(companyid);
    }

    public static AccountBankInfo getShareBalanceOfAcct(Context ctx, AccountBankInfo accountbank, String companyid) throws EASBizException, BOSException {
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("id"));
        selector.add(new SelectorItemInfo("company.*"));
        selector.add(new SelectorItemInfo("currency.*"));
        selector.add(new SelectorItemInfo("shareAcct.*"));
        selector.add(new SelectorItemInfo("shareAcct.bankAccount.*"));
        selector.add(new SelectorItemInfo("shareType"));
        AccountBankInfo accBankInfo = null;
        boolean a = true;
        accBankInfo = ctx == null ? AccountBankFactory.getRemoteInstance().getAccountBankInfo((IObjectPK)new ObjectUuidPK(accountbank.getId().toString()), selector) : AccountBankFactory.getLocalInstance((Context)ctx).getAccountBankInfo((IObjectPK)new ObjectUuidPK(accountbank.getId().toString()), selector);
        if (accBankInfo.getShareType().getValue() == 0) {
            return accBankInfo;
        }
        SharedAcctInfo sharedAcctInfo = accBankInfo.getShareAcct();
        accBankInfo = AccountBankFactory.getRemoteInstance().getAccountBankInfo((IObjectPK)new ObjectUuidPK(sharedAcctInfo.getBankAccount().getId().toString()), selector);
        return accBankInfo;
    }

    public static void lockedTransDetailIds(Context ctx, Set idSet) throws BOSException {
        if (idSet.size() <= 0) {
            return;
        }
        UserInfo user = ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentUser();
        String sql = "update T_Be_TransDetail set FlastUpdateUserId = ?  where fid in " + FMHelper.setTran2String((Set)idSet);
        DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{user.getId().toString()});
    }

    static {
        currencyColl = null;
        glKeys = new String[]{"account", "currency"};
        periodToDate = new HashMap();
    }
}

