/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.cas;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.kdf.data.logging.Logger;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.cas.FlowItemPropertyEnum;
import com.kingdee.eas.fi.cas.FundFlowDirection;
import com.kingdee.eas.fi.cas.FundFlowItemCollection;
import com.kingdee.eas.fi.cas.FundFlowItemFactory;
import com.kingdee.eas.fi.cas.FundFlowItemInfo;
import com.kingdee.eas.fi.cas.IFundFlowItem;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.tools.datatask.AbstractDataTransmission;
import com.kingdee.eas.tools.datatask.core.TaskExternalException;
import com.kingdee.eas.tools.datatask.runtime.DataToken;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.UuidException;
import java.sql.SQLException;
import java.util.Hashtable;
import java.util.Locale;

public class FundFlowItemDataImport
extends AbstractDataTransmission {
    private Object getData(Hashtable hsData, String fieldName) {
        Object data = null;
        if (hsData.get(fieldName) != null) {
            data = ((DataToken)hsData.get((Object)fieldName)).data;
        }
        return data;
    }

    public CoreBaseInfo transmit(Hashtable hsData, Context ctx) throws TaskExternalException {
        FundFlowItemInfo info = new FundFlowItemInfo();
        Integer datataskMode = (Integer)this.getContextParameter().get("DATATASKMODE");
        int mode = datataskMode;
        Object data = null;
        data = this.getData(hsData, "FNumber");
        if (data == null || data.equals("")) {
            throw new TaskExternalException(ResourceBase.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"459_FundFlowItemDataImport", (Locale)ctx.getLocale()));
        }
        if (data != null && data.toString().trim().length() > 0) {
            try {
                info = this.getFundFlowItemInfo(ctx, mode, data.toString());
            }
            catch (EASBizException e) {
                Logger.error((Throwable)e);
            }
            catch (BOSException e) {
                Logger.error((Throwable)e);
            }
            info.setNumber(data.toString());
        }
        if ((data = this.getData(hsData, "FName_l2")) == null || data.equals("")) {
            throw new TaskExternalException(ResourceBase.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"460_FundFlowItemDataImport", (Locale)ctx.getLocale()));
        }
        if (data != null && data.toString().trim().length() > 0) {
            info.setName(data.toString());
        }
        if ((data = this.getData(hsData, "FDirection")) == null || data.equals("")) {
            throw new TaskExternalException(ResourceBase.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"461_FundFlowItemDataImport", (Locale)ctx.getLocale()));
        }
        if (data != null && data.toString().trim().length() > 0) {
            if (!(data.toString().equals("0") || data.toString().equals("1") || data.toString().equals("2"))) {
                throw new TaskExternalException(ResourceBase.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"462_FundFlowItemDataImport", (Locale)ctx.getLocale()));
            }
            info.setDirection(FundFlowDirection.getEnum(Integer.parseInt(data.toString())));
        }
        if ((data = this.getData(hsData, "FProperty")) == null || data.equals("")) {
            throw new TaskExternalException(ResourceBase.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"463_FundFlowItemDataImport", (Locale)ctx.getLocale()));
        }
        if (data != null && data.toString().trim().length() > 0) {
            if (!(data.toString().equals("0") || data.toString().equals("1") || data.toString().equals("2") || data.toString().equals("3") || data.toString().equals("4"))) {
                throw new TaskExternalException(ResourceBase.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"464_FundFlowItemDataImport", (Locale)ctx.getLocale()));
            }
            info.setProperty(FlowItemPropertyEnum.getEnum(Integer.parseInt(data.toString())));
        }
        if ((data = this.getData(hsData, "FParent_number")) != null && data.toString().trim().length() > 0) {
            String sqlToGetGaa = "SELECT TOP 1 FID,fdirection,fproperty FROM t_cas_FundFlowItem  WHERE FNUMBER=?";
            try {
                FundFlowItemInfo parentInfo;
                IRowSet rsToGetGaa = DbUtil.executeQuery((Context)ctx, (String)sqlToGetGaa, (Object[])new Object[]{data.toString()});
                if (rsToGetGaa != null && rsToGetGaa.next()) {
                    parentInfo = new FundFlowItemInfo();
                    parentInfo.setId(BOSUuid.read((String)rsToGetGaa.getString("FID")));
                    parentInfo.setDirection(FundFlowDirection.getEnum(rsToGetGaa.getInt("fdirection")));
                    parentInfo.setProperty(FlowItemPropertyEnum.getEnum(rsToGetGaa.getInt("fproperty")));
                    if (parentInfo.getDirection().equals((Object)FundFlowDirection.IN) && !parentInfo.getDirection().equals((Object)info.getDirection())) {
                        throw new TaskExternalException(ResourceBase.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"465_FundFlowItemDataImport", (Locale)ctx.getLocale()));
                    }
                    if (parentInfo.getDirection().equals((Object)FundFlowDirection.OUT) && !parentInfo.getDirection().equals((Object)info.getDirection())) {
                        throw new TaskExternalException(ResourceBase.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"466_FundFlowItemDataImport", (Locale)ctx.getLocale()));
                    }
                } else {
                    throw new TaskExternalException(ResourceBase.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"468_FundFlowItemDataImport", (Locale)ctx.getLocale()) + data.toString() + ResourceBase.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"469_FundFlowItemDataImport", (Locale)ctx.getLocale()));
                }
                info.setParent(parentInfo);
            }
            catch (BOSException e) {
                e.printStackTrace();
            }
            catch (UuidException e) {
                e.printStackTrace();
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        } else if (mode == 16 || mode == 128) {
            throw new TaskExternalException(EASResource.getString((String)"com.kingdee.eas.fi.cas.CASAutoResource", (String)"406_FundFlowItemDataImport"));
        }
        if ((data = this.getData(hsData, "FRemarks")) != null) {
            info.setRemarks(data.toString());
        }
        return info;
    }

    protected ICoreBase getController(Context ctx) throws TaskExternalException {
        try {
            return FundFlowItemFactory.getLocalInstance(ctx);
        }
        catch (BOSException e) {
            throw new TaskExternalException(e.getMessage());
        }
    }

    private FundFlowItemInfo getFundFlowItemInfo(Context ctx, int mode, String number) throws BOSException, EASBizException {
        if (mode == 16 || mode == 128) {
            if (number == null) {
                return new FundFlowItemInfo();
            }
            try {
                FundFlowItemCollection coll = ((IFundFlowItem)this.getController(ctx)).getFundFlowItemCollection("where number = '" + number + "'");
                if (coll != null && coll.size() > 0) {
                    return coll.get(0);
                }
                return new FundFlowItemInfo();
            }
            catch (Exception e) {
                throw new BOSException(ResourceBase.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"15_AgentPayBillDataImport", (Locale)ctx.getLocale()));
            }
        }
        if (mode == 8) {
            return new FundFlowItemInfo();
        }
        return new FundFlowItemInfo();
    }

    protected void _submit(CoreBaseInfo coreBaseInfo, Context ctx) throws BOSException, EASBizException {
        try {
            if (coreBaseInfo.getId() == null || !this.getController(ctx).exists((IObjectPK)new ObjectUuidPK(coreBaseInfo.getId()))) {
                this.getController(ctx).addnew(coreBaseInfo);
            } else {
                this.getController(ctx).update((IObjectPK)new ObjectUuidPK(coreBaseInfo.getId()), coreBaseInfo);
            }
        }
        catch (TaskExternalException e) {
            e.printStackTrace();
        }
    }
}

