/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.cas;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.base.core.util.BOTPUtil;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.cas.BillTypeEnum;
import com.kingdee.eas.fi.cas.CasException;
import com.kingdee.eas.fi.cas.IJournal;
import com.kingdee.eas.fi.cas.JournalFactory;
import com.kingdee.eas.fi.cas.JournalInfo;
import com.kingdee.eas.fi.cas.JournalSourceEnum;
import com.kingdee.eas.fi.cas.PaymentBillFactory;
import com.kingdee.eas.fi.cas.PaymentBillInfo;
import com.kingdee.eas.fi.gl.GlUtils;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.nt.ChequeCollection;
import com.kingdee.eas.fm.nt.ChequeFactory;
import com.kingdee.eas.fm.nt.ChequeInfo;
import com.kingdee.eas.fm.nt.ChequeStatusEnum;
import com.kingdee.eas.fm.nt.ICheque;
import com.kingdee.eas.fm.nt.NTException;
import com.kingdee.eas.fm.nt.NTTypeGroupEnum;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.app.DbUtil;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Locale;
import java.util.Map;

public class Journal4ChequeMnt {
    private HashMap param_CS007_Map = new HashMap();

    public void autoVCCheque(Context ctx, IObjectPK objectPK) throws BOSException, EASBizException {
        ChequeCollection chequecoll;
        NTTypeGroupEnum group;
        PaymentBillInfo pay;
        JournalInfo newJournal = null;
        newJournal = this.getJournalInfo(ctx, objectPK);
        ObjectUuidPK companyID = new ObjectUuidPK(newJournal.getCompany().getId());
        boolean CS007 = false;
        if (this.param_CS007_Map.get(companyID) == null) {
            CS007 = ContextHelperFactory.getLocalInstance((Context)ctx).getBooleanParam("CS007", (IObjectPK)companyID);
            this.param_CS007_Map.put(companyID, CS007);
        } else {
            CS007 = (Boolean)this.param_CS007_Map.get(companyID);
        }
        boolean relateCheque = false;
        if (newJournal.getBillId() != null && BOSUuid.read((String)newJournal.getBillId()).getType().equals((Object)new PaymentBillInfo().getBOSType()) && PaymentBillFactory.getLocalInstance(ctx).exists((IObjectPK)new ObjectUuidPK(newJournal.getBillId())) && (pay = PaymentBillFactory.getLocalInstance(ctx).getPaymentBillInfo((IObjectPK)new ObjectUuidPK(newJournal.getBillId()))).isIsRelateCheque()) {
            relateCheque = true;
        }
        if (!CS007 && !relateCheque) {
            return;
        }
        if (JournalSourceEnum.BYBILL.equals((Object)newJournal.getSource()) && (BillTypeEnum.Cheque.equals((Object)newJournal.getBillType()) || BillTypeEnum.TeleOrder.equals((Object)newJournal.getBillType()))) {
            return;
        }
        if (newJournal.getSettlementType() != null && newJournal.getSettlementType().getNtType() != null && newJournal.getAccountBank() != null && NTTypeGroupEnum.CHEQUE.equals((Object)(group = newJournal.getSettlementType().getNtType().getGroup())) && (chequecoll = this.getNotVCChequeColl(ctx, newJournal)) != null && chequecoll.size() > 0) {
            ChequeInfo chequeInfo = chequecoll.get(0);
            this.checkChequeData(ctx, chequeInfo, newJournal);
            this.reWriteCheque(ctx, chequeInfo, newJournal);
        }
    }

    public void autoCancelVCCheque(Context ctx, IObjectPK objectPK) throws BOSException, EASBizException {
        PaymentBillInfo pay;
        JournalInfo newJournal = null;
        newJournal = this.getJournalInfo(ctx, objectPK);
        ObjectUuidPK companyID = new ObjectUuidPK(newJournal.getCompany().getId());
        boolean CS007 = false;
        if (this.param_CS007_Map.get(companyID) == null) {
            CS007 = ContextHelperFactory.getLocalInstance((Context)ctx).getBooleanParam("CS007", (IObjectPK)companyID);
            this.param_CS007_Map.put(companyID, CS007);
        } else {
            CS007 = (Boolean)this.param_CS007_Map.get(companyID);
        }
        boolean relateCheque = false;
        if (newJournal.getBillId() != null && BOSUuid.read((String)newJournal.getBillId()).getType().equals((Object)new PaymentBillInfo().getBOSType()) && PaymentBillFactory.getLocalInstance(ctx).exists((IObjectPK)new ObjectUuidPK(newJournal.getBillId())) && (pay = PaymentBillFactory.getLocalInstance(ctx).getPaymentBillInfo((IObjectPK)new ObjectUuidPK(newJournal.getBillId()))).isIsRelateCheque()) {
            relateCheque = true;
        }
        if (!CS007 && !relateCheque) {
            return;
        }
        if (newJournal.isIsDebit() || newJournal.getTicketNumber() == null || newJournal.getSettlementType() == null || newJournal.getSettlementNumber() == null || JournalSourceEnum.BYBILL.equals((Object)newJournal.getSource()) && (BillTypeEnum.Cheque.equals((Object)newJournal.getBillType()) || BillTypeEnum.TeleOrder.equals((Object)newJournal.getBillType()))) {
            return;
        }
        ChequeCollection chequecoll = this.getVCChequeColl(ctx, newJournal);
        if (chequecoll != null && chequecoll.size() > 0) {
            ChequeInfo info = chequecoll.get(0);
            if (!info.isIsVC()) {
                throw new CasException(CasException.CHEQUEISNOTVC, new Object[]{info.getNumber()});
            }
            if (info.getJournal() != null && info.getJournal().getBillType() == BillTypeEnum.Cheque) {
                throw new NTException(NTException.NOTVCJOURNALBILLCHEQUE, new Object[]{info.getNumber()});
            }
            info.setJournal(null);
            info.setAmount(null);
            info.setCapitalization(null);
            info.setVcDate(null);
            info.setReimburseDate(null);
            info.setState(ChequeStatusEnum.APPLIED);
            info.setIsVC(false);
            ChequeFactory.getLocalInstance((Context)ctx).submit((CoreBaseInfo)info);
        }
    }

    private void checkChequeData(Context ctx, ChequeInfo chequeInfo, JournalInfo newJournal) throws EASBizException, BOSException {
        if (chequeInfo.isIsVC()) {
            throw new CasException(CasException.CHEQUEISVC, new Object[]{chequeInfo.getNumber()});
        }
        if (chequeInfo.isIsAbandon()) {
            throw new CasException(CasException.CHEQUEISCANCEL, new Object[]{chequeInfo.getNumber()});
        }
        if (ChequeStatusEnum.STORE.equals((Object)chequeInfo.getState())) {
            throw new CasException(CasException.CHEQUEISSTORE, new Object[]{chequeInfo.getNumber()});
        }
        if (ChequeStatusEnum.NEW.equals((Object)chequeInfo.getState())) {
            throw new CasException(CasException.CHEQUEISNEW, new Object[]{chequeInfo.getNumber()});
        }
        if (chequeInfo.getCurrency() != null && !chequeInfo.getCurrency().getId().equals((Object)newJournal.getCurrency().getId())) {
            throw new CasException(CasException.CHEQUEVERIFYCURRENCY, new Object[]{chequeInfo.getNumber()});
        }
        BigDecimal creditAmount = newJournal.getCreditAmount();
        if (chequeInfo.getApplyRec() != null && !BOTPUtil.isZERO((BigDecimal)chequeInfo.getApplyRec().getCeiling()) && creditAmount.compareTo(chequeInfo.getApplyRec().getCeiling()) > 0) {
            throw new CasException(CasException.CHEQUEVERIFYCEILING, new Object[]{chequeInfo.getNumber(), chequeInfo.getApplyRec().getCeiling()});
        }
        if (!BOTPUtil.isZERO((BigDecimal)chequeInfo.getAmount()) && chequeInfo.getAmount().compareTo(creditAmount) != 0) {
            Map map = FMHelper.getNantionalDateMap((Context)ctx);
            DecimalFormat df = (DecimalFormat)map.get("numberFormat");
            df.applyPattern(FMHelper.toPattern((int)chequeInfo.getCurrency().getPrecision()));
            throw new CasException(CasException.CHEQUEVERIFYAMOUNT, new Object[]{chequeInfo.getNumber(), df.format(chequeInfo.getAmount())});
        }
    }

    protected void reWriteCheque(Context ctx, ChequeInfo chequeInfo, JournalInfo newJournal) throws BOSException, EASBizException {
        this.setShareProperty(ctx, chequeInfo, newJournal);
        chequeInfo.setOriVCState(chequeInfo.getState());
        chequeInfo.setState(ChequeStatusEnum.WRITTEN_OFF);
        Date date = new Date();
        if (chequeInfo.getReimburseDate() == null) {
            chequeInfo.setReimburseDate(date);
        }
        chequeInfo.setIsVC(true);
        chequeInfo.setVcDate(date);
        chequeInfo.setJournal(newJournal);
        this.updateJouranl(ctx, newJournal);
        ChequeFactory.getLocalInstance((Context)ctx).submit((CoreBaseInfo)chequeInfo);
    }

    protected void setShareProperty(Context ctx, ChequeInfo chequeInfo, JournalInfo newJournal) {
        if (!EmptyUtil.isEmpty((CoreBaseInfo)newJournal.getOppAccountView())) {
            chequeInfo.setOppAccount(newJournal.getOppAccountView());
        }
        if (!EmptyUtil.isEmpty((String)newJournal.getOppUnit())) {
            chequeInfo.setPayeeName(newJournal.getOppUnit());
        }
        if (!EmptyUtil.isEmpty((String)newJournal.getOppBank())) {
            chequeInfo.setPayeeAcctBank(newJournal.getOppBank());
        }
        if (!EmptyUtil.isEmpty((String)newJournal.getOppAcctNumber())) {
            chequeInfo.setPayeeAcctNumber(newJournal.getOppAcctNumber());
        }
        chequeInfo.setCurrency(newJournal.getCurrency());
        chequeInfo.setAmount(newJournal.getCreditAmount());
        chequeInfo.setCapitalization(GlUtils.getChineseFormat((BigDecimal)chequeInfo.getAmount(), (boolean)false, (Locale)ctx.getLocale()));
        if (!EmptyUtil.isEmpty((String)newJournal.getDescription()) && EmptyUtil.isEmpty((String)chequeInfo.getUsage())) {
            chequeInfo.setUsage(newJournal.getDescription());
        }
    }

    private void updateJouranl(Context ctx, JournalInfo newJournal) throws BOSException {
        String sql = " update T_CAS_Journal set  FTicketNumber = ? , FIsOnlineVCCheque=1 where fid =?";
        Object[] params = new Object[]{newJournal.getSettlementNumber(), newJournal.getId().toString()};
        DbUtil.execute((Context)ctx, (String)sql, (Object[])params);
    }

    private ChequeCollection getNotVCChequeColl(Context ctx, JournalInfo newJournal) throws BOSException {
        ICheque cheque = ChequeFactory.getLocalInstance((Context)ctx);
        EntityViewInfo ev = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)newJournal.getCompany().getId().toString()));
        filter.getFilterItems().add(new FilterItemInfo("bankAcct.id", (Object)newJournal.getAccountBank().getId().toString()));
        if (newJournal.getSettlementType() != null && newJournal.getSettlementType().getNtType() != null) {
            filter.getFilterItems().add(new FilterItemInfo("ntType.id", (Object)newJournal.getSettlementType().getNtType().getId().toString()));
        }
        filter.getFilterItems().add(new FilterItemInfo("number", (Object)newJournal.getSettlementNumber()));
        ev.setFilter(filter);
        ev.getSelector().add("*");
        ev.getSelector().add("applyRec.*");
        ev.getSelector().add("currency.precision");
        ChequeCollection chequecoll = cheque.getChequeCollection(ev);
        return chequecoll;
    }

    private JournalInfo getJournalInfo(Context ctx, IObjectPK objectPK) throws BOSException, EASBizException {
        SelectorItemCollection select = this.getJournalSelector();
        IJournal journal = JournalFactory.getLocalInstance(ctx);
        JournalInfo newJournal = journal.getJournalInfo(objectPK, select);
        return newJournal;
    }

    private SelectorItemCollection getJournalSelector() {
        SelectorItemCollection select = new SelectorItemCollection();
        select.add("*");
        select.add("settlementType.id");
        select.add("settlementType.nttype.id");
        select.add("settlementType.nttype.group");
        select.add("accountBank.id");
        select.add("accountBank.bankAccountNumber");
        select.add("accountBank.bank.id");
        select.add("accountBank.bank.name");
        select.add("currency.id");
        select.add("currency.isoCode");
        return select;
    }

    private ChequeCollection getVCChequeColl(Context ctx, JournalInfo newJournal) throws BOSException {
        ICheque cheque = ChequeFactory.getLocalInstance((Context)ctx);
        EntityViewInfo ev = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)newJournal.getCompany().getId().toString()));
        filter.getFilterItems().add(new FilterItemInfo("bankAcct.id", (Object)newJournal.getAccountBank().getId().toString()));
        filter.getFilterItems().add(new FilterItemInfo("journal.id", (Object)newJournal.getId().toString()));
        ev.setFilter(filter);
        ChequeCollection chequecoll = cheque.getChequeCollection(ev);
        return chequecoll;
    }

    public void autoVCCheque(Context ctx, IObjectPK[] objectPK) throws BOSException, EASBizException {
        int i;
        LinkedHashSet<String> idSet = new LinkedHashSet<String>();
        for (i = 0; i < objectPK.length; ++i) {
            idSet.add(objectPK[i].toString());
        }
        for (i = 0; i < objectPK.length; ++i) {
            this.autoVCCheque(ctx, objectPK[i]);
        }
    }

    public void autoCancelVCCheque(Context ctx, IObjectPK[] objectPK) throws BOSException, EASBizException {
        int i;
        LinkedHashSet<String> idSet = new LinkedHashSet<String>();
        for (i = 0; i < objectPK.length; ++i) {
            idSet.add(objectPK[i].toString());
        }
        for (i = 0; i < objectPK.length; ++i) {
            this.autoCancelVCCheque(ctx, objectPK[i]);
        }
    }
}

