/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.cas;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.base.core.Constants;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.base.vc.VerifyScopeEnum;
import com.kingdee.eas.basedata.assistant.AccountBankCollection;
import com.kingdee.eas.basedata.assistant.AccountBankFactory;
import com.kingdee.eas.basedata.assistant.AccountBankInfo;
import com.kingdee.eas.basedata.assistant.IAccountBank;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.PeriodUtils;
import com.kingdee.eas.basedata.master.account.AccountViewInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.cas.AbstractPayPackageJournal;
import com.kingdee.eas.fi.cas.AssItemsForCashPayInfo;
import com.kingdee.eas.fi.cas.BillTypeEnum;
import com.kingdee.eas.fi.cas.IPaymentBill;
import com.kingdee.eas.fi.cas.JournalCollection;
import com.kingdee.eas.fi.cas.JournalInfo;
import com.kingdee.eas.fi.cas.JournalSourceEnum;
import com.kingdee.eas.fi.cas.JournalTypeEnum;
import com.kingdee.eas.fi.cas.PayEntryPackageJournal;
import com.kingdee.eas.fi.cas.PayHeadPackageJournal;
import com.kingdee.eas.fi.cas.PaymentBillCollection;
import com.kingdee.eas.fi.cas.PaymentBillEntryCollection;
import com.kingdee.eas.fi.cas.PaymentBillEntryInfo;
import com.kingdee.eas.fi.cas.PaymentBillFactory;
import com.kingdee.eas.fi.cas.PaymentBillInfo;
import com.kingdee.eas.fi.cas.RecPayBookNotifyBuilder;
import com.kingdee.eas.util.app.DbUtil;
import java.math.BigDecimal;
import java.util.Date;
import java.util.Iterator;
import java.util.Set;

public class PaymentBillBookNotifyBuilder
extends RecPayBookNotifyBuilder {
    private SelectorItemCollection getSelector() {
        SelectorItemCollection cel = new SelectorItemCollection();
        cel.add("*");
        cel.add("company.*");
        cel.add("payerAccount.*");
        cel.add("oppAccount.*");
        cel.add("payeeAccountBankO.*");
        cel.add("payBillType.isFinanceTranUp");
        cel.add("entries.*");
        cel.add("entries.oppAccount.isCash");
        cel.add("entries.oppAccount.isBank");
        cel.add("entries.assItemsEntries.asstActType.id");
        cel.add("entries.assItemsEntries.asstActType.realtionDataObject");
        cel.add("entries.assItemsEntries.entryParent.id");
        cel.add("entries.assItemsEntries.isSelected");
        cel.add("entries.assItemsEntries.fromNumber");
        cel.add("entries.assItemsEntries.entrySeq");
        cel.add("entries.fundFlowItem.id");
        cel.add("entries.fundFlowItem.direction");
        cel.add("voucher.id");
        cel.add("voucher.number");
        cel.add("voucher.voucherType");
        cel.add("voucher.bizStatus");
        cel.add("voucher.creator.id");
        cel.add("voucher.entries.id");
        cel.add("voucher.entries.account.id");
        cel.add("voucher.entries.entryDC");
        cel.add("cbPayInfo.*");
        cel.add("bizType.type");
        return cel;
    }

    private boolean getCS106(Context ctx, CompanyOrgUnitInfo companyInfo) {
        int bookType = ContextHelperFactory.getLocalInstance((Context)ctx).getIntParam("CS106", (IObjectPK)new ObjectUuidPK(companyInfo.getId()));
        boolean isBookByHeadAmount = bookType == 0;
        return isBookByHeadAmount;
    }

    private PaymentBillInfo getPaymentBillInfo(Context ctx, String billId) throws BOSException, EASBizException {
        IPaymentBill paymentBill = PaymentBillFactory.getLocalInstance(ctx);
        PaymentBillInfo paymentBillInfo = paymentBill.getPaymentBillInfo((IObjectPK)new ObjectUuidPK(billId), this.getSelector());
        return paymentBillInfo;
    }

    @Override
    public JournalCollection getJournalColl(Context ctx, String billId) throws BOSException, EASBizException {
        JournalCollection journalCollection = new JournalCollection();
        PaymentBillInfo billInfo = this.getPaymentBillInfo(ctx, billId);
        if (this.getCS106(ctx, billInfo.getCompany()) || billInfo.getFundDispatchType().getValue() == 1 || billInfo.getFundDispatchType().getValue() == 2) {
            this.book(ctx, billId, journalCollection, billInfo);
        } else {
            PaymentBillEntryCollection paymentBillEntryCollection = billInfo.getEntries();
            PaymentBillEntryCollection paymentBillEntryCollectionTemp = new PaymentBillEntryCollection();
            PaymentBillEntryInfo paymentBillEntryTemp = null;
            for (int i = 0; i < paymentBillEntryCollection.size(); ++i) {
                paymentBillEntryTemp = paymentBillEntryCollection.get(i);
                paymentBillEntryCollectionTemp.add(paymentBillEntryTemp);
                billInfo.put("entries", (Object)paymentBillEntryCollectionTemp);
                this.book(ctx, billId, journalCollection, billInfo);
                paymentBillEntryCollectionTemp.clear();
            }
        }
        return journalCollection;
    }

    private void book(Context ctx, String billId, JournalCollection journalCollection, PaymentBillInfo billInfo) throws BOSException, EASBizException {
        this.cs072 = ContextHelperFactory.getLocalInstance((Context)ctx).getIntParam("CS072", null);
        boolean isMinusReverse = this.cs072 != 0;
        this.cs106 = this.getCS106(ctx, billInfo.getCompany());
        this.cs104 = ContextHelperFactory.getLocalInstance((Context)ctx).getIntParam("CS104", (IObjectPK)new ObjectUuidPK(billInfo.getCompany().getId()));
        AbstractPayPackageJournal payPackage = this.cs106 || billInfo.getFundDispatchType().getValue() == 1 || billInfo.getFundDispatchType().getValue() == 2 ? new PayHeadPackageJournal(ctx, billInfo, this.currPeriodInfo, this.cs104, isMinusReverse, this) : new PayEntryPackageJournal(ctx, billInfo, this.currPeriodInfo, this.cs104, isMinusReverse, this);
        ((AbstractPayPackageJournal)payPackage).bookPaymentBill(journalCollection);
    }

    private void bookReverse(Context ctx, String billId, JournalCollection journalCollection, PaymentBillInfo billInfo) throws BOSException, EASBizException {
        if (billInfo.getPayerAccount() != null) {
            BigDecimal amount;
            JournalInfo journalInfo;
            if (billInfo.getPayerAccount().isIsBank()) {
                journalInfo = this.createBaseJournal(ctx, billInfo);
                journalInfo.setType(JournalTypeEnum.BANK);
                journalInfo.setAccountBank(billInfo.getPayerAccountBank());
                journalInfo.setAccountView(billInfo.getPayerAccount());
                journalInfo.setOppAccountView(billInfo.getOppAccount());
                amount = billInfo.getActPayAmt().negate();
                journalInfo.setCreditAmount(Constants.ZERO);
                journalInfo.setDebitAmount(amount);
                journalCollection.add(journalInfo);
            } else if (billInfo.getPayerAccount().isIsCash()) {
                journalInfo = this.createBaseJournal(ctx, billInfo);
                journalInfo.setType(JournalTypeEnum.CASH);
                journalInfo.setAccountView(billInfo.getPayerAccount());
                journalInfo.setOppAccountView(billInfo.getOppAccount());
                amount = billInfo.getActPayAmt().negate();
                journalInfo.setCreditAmount(Constants.ZERO);
                journalInfo.setDebitAmount(amount);
                journalCollection.add(journalInfo);
            }
        }
        if (billInfo.getOppAccount() != null) {
            JournalInfo journalInfo;
            AccountViewInfo oppAccount = billInfo.getOppAccount();
            if (oppAccount.isIsBank()) {
                journalInfo = this.createBaseJournal(ctx, billInfo);
                journalInfo.setType(JournalTypeEnum.BANK);
                journalInfo.setAccountView(billInfo.getOppAccount());
                journalInfo.setAccountBank(billInfo.getPayeeAccountBankO());
                journalInfo.setOppAccountView(billInfo.getPayerAccount());
                BigDecimal amount = billInfo.getActPayAmt().negate();
                journalInfo.setDebitAmount(Constants.ZERO);
                journalInfo.setCreditAmount(amount);
                journalCollection.add(journalInfo);
                String sql = "UPDATE T_CAS_PaymentBill SET FIsCtrlOppAcct = 1 WHERE FID =?";
                DbUtil.execute((Context)ctx, (String)sql, (Object[])new String[]{billId});
            } else if (oppAccount.isIsCash()) {
                journalInfo = this.createBaseJournal(ctx, billInfo);
                journalInfo.setType(JournalTypeEnum.CASH);
                journalInfo.setAccountView(billInfo.getOppAccount());
                journalInfo.setOppAccountView(billInfo.getPayerAccount());
                BigDecimal amount = billInfo.getActPayAmt().negate();
                journalInfo.setDebitAmount(Constants.ZERO);
                journalInfo.setCreditAmount(amount);
                journalCollection.add(journalInfo);
                String sql = "UPDATE T_CAS_PaymentBill SET FIsCtrlOppAcct = 1 WHERE FID =?";
                DbUtil.execute((Context)ctx, (String)sql, (Object[])new String[]{billId});
            }
        }
    }

    private JournalInfo createBaseJournal(Context ctx, PaymentBillInfo billInfo) throws BOSException, EASBizException {
        JournalInfo journalInfo = new JournalInfo();
        journalInfo.setCompany(billInfo.getCompany());
        journalInfo.setSource(JournalSourceEnum.BYBILL);
        journalInfo.setBillId(billInfo.getId().toString());
        journalInfo.setBillType(BillTypeEnum.paymentBill);
        journalInfo.setBillNumber(billInfo.getNumber());
        journalInfo.setBizDate(billInfo.getBizDate());
        CompanyOrgUnitInfo companyInfo1 = billInfo.getCompany();
        Date bookDate = this.getBookDate_cs104(ctx, billInfo.getBizDate(), companyInfo1);
        journalInfo.setCreateDate(bookDate);
        PeriodInfo bookPeriodInfo = PeriodUtils.getPeriodInfo((Context)ctx, (Date)bookDate, (CompanyOrgUnitInfo)companyInfo1);
        journalInfo.setPeriod(bookPeriodInfo);
        journalInfo.setCurrency(billInfo.getCurrency());
        journalInfo.setPlanItem(billInfo.getFpItem());
        journalInfo.setSettlementType(billInfo.getSettlementType());
        journalInfo.setSettlementNumber(billInfo.getSettlementNumber());
        journalInfo.setDescription(billInfo.getDescription());
        UserInfo userInfo = ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentUser();
        journalInfo.setCashier(userInfo);
        journalInfo.setOppUnit(billInfo.getPayeeName());
        journalInfo.setVerifyStatus(VerifyScopeEnum.NOVA);
        if (billInfo.getBankCheckFlag() != null) {
            journalInfo.setBankCheckFlag(billInfo.getBankCheckFlag());
        }
        return journalInfo;
    }

    @Override
    public JournalCollection getJournalColl(Context ctx, Set idSet) throws BOSException, EASBizException {
        PaymentBillCollection coll = this.getPaymentBillCollection(ctx, idSet);
        this.setCompanyId(coll.get(0).getCompany().getId().toString());
        JournalCollection journalCollection = super.getJournalColl(ctx, idSet);
        Iterator it = coll.iterator();
        while (it.hasNext()) {
            PaymentBillInfo info = (PaymentBillInfo)it.next();
            this.book(ctx, info.getId().toString(), journalCollection, info);
        }
        return journalCollection;
    }

    private PaymentBillCollection getPaymentBillCollection(Context ctx, Set idSet) throws BOSException, EASBizException {
        IPaymentBill paymentBill = PaymentBillFactory.getLocalInstance(ctx);
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)idSet, CompareType.INCLUDE));
        evi.setSelector(this.getSelector());
        evi.setFilter(filter);
        return paymentBill.getPaymentBillCollection(evi);
    }

    private AccountBankInfo getAccountBank(Context ctx, PaymentBillInfo info) throws BOSException, EASBizException {
        PaymentBillEntryInfo entryInfo = info.getEntries().get(0);
        int size = entryInfo.getAssItemsEntries().size();
        AssItemsForCashPayInfo assItemsinfo = null;
        String accountBankNumber = "";
        for (int i = 0; i < size; ++i) {
            assItemsinfo = entryInfo.getAssItemsEntries().get(i);
            if (!assItemsinfo.isIsSelected() || !"T_BD_AccountBanks".equals(assItemsinfo.getAsstActType().getRealtionDataObject())) continue;
            accountBankNumber = assItemsinfo.getFromNumber();
        }
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        evi.setFilter(filter);
        filter.getFilterItems().add(new FilterItemInfo("number", (Object)accountBankNumber, CompareType.EQUALS));
        IAccountBank iaccountBank = AccountBankFactory.getLocalInstance((Context)ctx);
        AccountBankCollection accountBankColl = iaccountBank.getAccountBankCollection(evi);
        return accountBankColl.get(0);
    }
}

