/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.cas;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.cas.IReceivingBill;
import com.kingdee.eas.fi.cas.ReceivingBillCollection;
import com.kingdee.eas.fi.cas.ReceivingBillFactory;
import com.kingdee.eas.fi.cas.ReceivingBillInfo;
import com.kingdee.eas.fm.common.ContextHelperFactory;
import com.kingdee.eas.fm.common.FMConstants;
import com.kingdee.eas.fm.common.FMVerifyHelper;
import com.kingdee.eas.fm.fs.FSException;
import com.kingdee.eas.fm.fs.FSHelper;
import com.kingdee.eas.fm.fs.IGenSettlementBillBuilder;
import com.kingdee.eas.fm.fs.SettlementBillCollection;
import com.kingdee.eas.fm.fs.SettlementBillInfo;
import java.sql.Timestamp;
import java.util.Set;

public class RecGenSettleBillBuilder
implements IGenSettlementBillBuilder {
    public SettlementBillCollection getSettlementBillColl(Context ctx, Set idSet) throws BOSException, EASBizException {
        if (idSet == null || idSet.size() == 0) {
            throw new NullPointerException("The Set of Bill ID is NULL!");
        }
        SettlementBillCollection coll = new SettlementBillCollection();
        IReceivingBill iReceivingBill = ReceivingBillFactory.getLocalInstance(ctx);
        ReceivingBillInfo srcInfo = null;
        EntityViewInfo ev = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)idSet, CompareType.INCLUDE));
        ev.setFilter(filter);
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add("*");
        selector.add("payeeAccountBank.*");
        ev.getSelector().addObjectCollection((IObjectCollection)selector);
        ReceivingBillCollection srcColl = iReceivingBill.getReceivingBillCollection(ev);
        for (int i = 0; i < srcColl.size(); ++i) {
            srcInfo = srcColl.get(i);
            SettlementBillInfo destInfo = this.trans2SettlementBill(ctx, srcInfo);
            coll.add(destInfo);
        }
        return coll;
    }

    private SettlementBillInfo trans2SettlementBill(Context ctx, ReceivingBillInfo srcInfo) throws BOSException, EASBizException {
        UserInfo userInfo = null;
        CtrlUnitInfo cuInfo = null;
        userInfo = ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentUser();
        cuInfo = ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentCtrlUnit();
        SettlementBillInfo destInfo = new SettlementBillInfo();
        destInfo.setId(BOSUuid.create((BOSObjectType)destInfo.getBOSType()));
        destInfo.setApplyUnit(srcInfo.getCompany());
        destInfo.setType(srcInfo.getSettleBizType());
        if (srcInfo.getPayeeAccountBank() != null) {
            destInfo.setPayeeInnerAcct(srcInfo.getPayeeAccountBank().getInnerAcct());
        }
        if (destInfo.getPayeeBankAcct() != null) {
            // empty if block
        }
        destInfo.setCurrency(srcInfo.getCurrency());
        destInfo.setAmount(srcInfo.getActRecAmt());
        destInfo.setExchange(FMConstants.ONE);
        String number = srcInfo.getNumber() == null ? "" : srcInfo.getNumber();
        String payerBank = srcInfo.getPayerBank() == null ? "" : srcInfo.getPayerBank();
        String payerAccountBank = srcInfo.getPayerAccountBank() == null ? "" : srcInfo.getPayerAccountBank();
        String description = srcInfo.getDescription() == null ? "" : srcInfo.getDescription();
        destInfo.setDescription(number + payerBank + payerAccountBank + description);
        destInfo.setSourceBillId(srcInfo.getId().toString());
        destInfo.setBizDate(srcInfo.getBizDate());
        destInfo.setFiVouchered(false);
        destInfo.setCreator(userInfo);
        destInfo.setCreateTime(new Timestamp(System.currentTimeMillis()));
        destInfo.setLastUpdateTime(new Timestamp(System.currentTimeMillis()));
        destInfo.setLastUpdateUser(userInfo);
        destInfo.setCU(cuInfo);
        destInfo.setCompany(FSHelper.getClearingHouseInfo((Context)ctx, null).getRelatedCompany());
        destInfo.setIsAccepted(false);
        destInfo.setHasEffected(false);
        destInfo.setIsGenPaymentBill(false);
        destInfo.setIsGenReceivingBill(true);
        CompanyOrgUnitInfo company = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(srcInfo.getCompany().getId()));
        destInfo.setPayeeFullName(company.getName());
        String payerName = srcInfo.getPayerName() == null ? "" : srcInfo.getPayerName();
        destInfo.setPayerFullName(payerName);
        this.verifyInfo(ctx, destInfo);
        return destInfo;
    }

    private void verifyInfo(Context ctx, SettlementBillInfo info) throws EASBizException {
        FMVerifyHelper.checkBlank((Context)ctx, (IObjectValue)info, (String)"amount");
        FMVerifyHelper.checkBlank((Context)ctx, (IObjectValue)info, (String)"currency");
        FMVerifyHelper.checkBlank((Context)ctx, (IObjectValue)info, (String)"applyUnit");
        FMVerifyHelper.checkBlank((Context)ctx, (IObjectValue)info, (String)"type");
        FMVerifyHelper.checkBlank((Context)ctx, (IObjectValue)info, (String)"exchange");
        FMVerifyHelper.checkBlank((Context)ctx, (IObjectValue)info, (String)"description");
        FMVerifyHelper.checkBlank((Context)ctx, (IObjectValue)info, (String)"payeeAmount");
        if (info.getAmount().signum() <= 0) {
            throw new FSException(FSException.AMOUNTBIGGERZERO);
        }
        if (info.getPayeeBankAcct() != null && info.getPayeeInnerAcct() == null) {
            throw new FSException(FSException.BANKACCTNOINNERACCT);
        }
        if (info.getPayerBankAcct() != null && info.getPayerInnerAcct() == null) {
            throw new FSException(FSException.BANKACCTNOINNERACCT);
        }
    }
}

