/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.cas;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.base.core.Constants;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.base.core.fm.IContextHelper;
import com.kingdee.eas.base.vc.VerifyScopeEnum;
import com.kingdee.eas.basedata.assistant.AccountBankCollection;
import com.kingdee.eas.basedata.assistant.AccountBankFactory;
import com.kingdee.eas.basedata.assistant.AccountBankInfo;
import com.kingdee.eas.basedata.assistant.IAccountBank;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.PeriodUtils;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolUtils;
import com.kingdee.eas.basedata.master.account.AccountViewInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.cas.AbstractRecPackageJournal;
import com.kingdee.eas.fi.cas.AssItemsForCashRecInfo;
import com.kingdee.eas.fi.cas.BillTypeEnum;
import com.kingdee.eas.fi.cas.IReceivingBill;
import com.kingdee.eas.fi.cas.JournalCollection;
import com.kingdee.eas.fi.cas.JournalInfo;
import com.kingdee.eas.fi.cas.JournalSourceEnum;
import com.kingdee.eas.fi.cas.JournalTypeEnum;
import com.kingdee.eas.fi.cas.RecEntryPackageJournal;
import com.kingdee.eas.fi.cas.RecHeadPackageJournal;
import com.kingdee.eas.fi.cas.RecPayBookNotifyBuilder;
import com.kingdee.eas.fi.cas.ReceivingBillCollection;
import com.kingdee.eas.fi.cas.ReceivingBillEntryCollection;
import com.kingdee.eas.fi.cas.ReceivingBillEntryInfo;
import com.kingdee.eas.fi.cas.ReceivingBillFactory;
import com.kingdee.eas.fi.cas.ReceivingBillInfo;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.util.app.DbUtil;
import java.math.BigDecimal;
import java.util.Date;
import java.util.Iterator;
import java.util.Set;

public class ReceivingBillBookNotifyBuilder
extends RecPayBookNotifyBuilder {
    private SelectorItemCollection getSelector() {
        SelectorItemCollection cel = new SelectorItemCollection();
        cel.add("*");
        cel.add("company.*");
        cel.add("payeeAccount.*");
        cel.add("oppAccount.*");
        cel.add("payerAccountBankO.*");
        cel.add("payeeAccountBank.*");
        cel.add("payerBank.*");
        cel.add("entries.*");
        cel.add("entries.oppAccount.isCash");
        cel.add("entries.oppAccount.isBank");
        cel.add("entries.assItemsEntries.asstActType.id");
        cel.add("entries.assItemsEntries.asstActType.realtionDataObject");
        cel.add("entries.assItemsEntries.entryParent.id");
        cel.add("entries.assItemsEntries.isSelected");
        cel.add("entries.assItemsEntries.fromNumber");
        cel.add("entries.assItemsEntries.entrySeq");
        cel.add("entries.fundFlowItem.id");
        cel.add("entries.fundFlowItem.direction");
        cel.add("voucher.id");
        cel.add("voucher.number");
        cel.add("voucher.voucherType");
        cel.add("voucher.bizStatus");
        cel.add("voucher.creator.id");
        cel.add("voucher.entries.id");
        cel.add("voucher.entries.entryDC");
        cel.add("voucher.entries.account.id");
        return cel;
    }

    private boolean getCS106(Context ctx, CompanyOrgUnitInfo companyInfo) {
        int bookType = ContextHelperFactory.getLocalInstance((Context)ctx).getIntParam("CS106", (IObjectPK)new ObjectUuidPK(companyInfo.getId()));
        boolean isBookByHeadAmount = bookType == 0;
        return isBookByHeadAmount;
    }

    private ReceivingBillInfo getReceivingBillInfoById(Context ctx, String billId) throws BOSException, EASBizException {
        IReceivingBill receivingBill = ReceivingBillFactory.getLocalInstance(ctx);
        ReceivingBillInfo receivingBillInfo = receivingBill.getReceivingBillInfo((IObjectPK)new ObjectUuidPK(billId), this.getSelector());
        return receivingBillInfo;
    }

    @Override
    public JournalCollection getJournalColl(Context ctx, String billId) throws BOSException, EASBizException {
        JournalCollection journalCollection = new JournalCollection();
        ReceivingBillInfo billInfo = this.getReceivingBillInfoById(ctx, billId);
        CompanyOrgUnitInfo currentCompany = ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentCompany();
        if (!billInfo.getCompany().getId().equals((Object)currentCompany.getId())) {
            billInfo.setAgentBook(true);
        }
        if (this.getCS106(ctx, billInfo.getCompany())) {
            this.book(ctx, billId, journalCollection, billInfo);
        } else {
            ReceivingBillEntryCollection receivingBillEntryCollection = billInfo.getEntries();
            ReceivingBillEntryCollection receivingBillEntryCollectionTemp = new ReceivingBillEntryCollection();
            ReceivingBillEntryInfo receivingBillEntryTemp = null;
            for (int i = 0; i < receivingBillEntryCollection.size(); ++i) {
                receivingBillEntryTemp = receivingBillEntryCollection.get(i);
                receivingBillEntryCollectionTemp.add(receivingBillEntryTemp);
                billInfo.put("entries", (Object)receivingBillEntryCollectionTemp);
                this.book(ctx, billId, journalCollection, billInfo);
                receivingBillEntryCollectionTemp.clear();
            }
        }
        return journalCollection;
    }

    private void book(Context ctx, String billId, JournalCollection journalCollection, ReceivingBillInfo billInfo) throws BOSException, EASBizException {
        this.cs072 = ContextHelperFactory.getLocalInstance((Context)ctx).getIntParam("CS072", null);
        boolean isMinusReverse = this.cs072 != 0;
        this.cs106 = this.getCS106(ctx, billInfo.getCompany());
        this.cs104 = ContextHelperFactory.getLocalInstance((Context)ctx).getIntParam("CS104", (IObjectPK)new ObjectUuidPK(billInfo.getCompany().getId()));
        AbstractRecPackageJournal recPackage = this.cs106 ? new RecHeadPackageJournal(ctx, billInfo, this.currPeriodInfo, this.cs104, isMinusReverse, this) : new RecEntryPackageJournal(ctx, billInfo, this.currPeriodInfo, this.cs104, isMinusReverse, this);
        recPackage.bookReceivingBill(journalCollection);
    }

    private void bookReverseBook(Context ctx, String billId, JournalCollection journalCollection, ReceivingBillInfo billInfo) throws BOSException, EASBizException {
        BigDecimal amount;
        JournalInfo journalInfo;
        AccountViewInfo acct = billInfo.getPayeeAccount();
        if (acct.isIsBank()) {
            journalInfo = this.createBaseJournal(ctx, billInfo);
            journalInfo.setType(JournalTypeEnum.BANK);
            journalInfo.setAccountBank(billInfo.getPayeeAccountBank());
            journalInfo.setAccountView(billInfo.getPayeeAccount());
            journalInfo.setOppAccountView(billInfo.getOppAccount());
            amount = billInfo.getActRecAmt().negate();
            journalInfo.setCreditAmount(amount);
            journalInfo.setDebitAmount(Constants.ZERO);
            journalCollection.add(journalInfo);
        } else if (acct.isIsCash()) {
            journalInfo = this.createBaseJournal(ctx, billInfo);
            journalInfo.setType(JournalTypeEnum.CASH);
            journalInfo.setAccountView(billInfo.getPayeeAccount());
            journalInfo.setOppAccountView(billInfo.getOppAccount());
            amount = billInfo.getActRecAmt().negate();
            journalInfo.setCreditAmount(amount);
            journalInfo.setDebitAmount(Constants.ZERO);
            journalCollection.add(journalInfo);
        }
        AccountViewInfo oppacct = billInfo.getOppAccount();
        if (oppacct != null) {
            JournalInfo journalInfo2;
            if (oppacct.isIsBank()) {
                journalInfo2 = this.createBaseJournal(ctx, billInfo);
                journalInfo2.setType(JournalTypeEnum.BANK);
                journalInfo2.setAccountBank(billInfo.getPayerAccountBankO());
                journalInfo2.setAccountView(oppacct);
                journalInfo2.setOppAccountView(billInfo.getPayeeAccount());
                BigDecimal amount2 = billInfo.getActRecAmt().negate();
                journalInfo2.setCreditAmount(Constants.ZERO);
                journalInfo2.setDebitAmount(amount2);
                journalCollection.add(journalInfo2);
                String sql = "UPDATE T_CAS_ReceivingBill SET FIsCtrlOppAcct = 1 WHERE FID =?";
                DbUtil.execute((Context)ctx, (String)sql, (Object[])new String[]{billId});
            } else if (oppacct.isIsCash()) {
                journalInfo2 = this.createBaseJournal(ctx, billInfo);
                journalInfo2.setType(JournalTypeEnum.CASH);
                journalInfo2.setAccountView(oppacct);
                journalInfo2.setOppAccountView(billInfo.getPayeeAccount());
                BigDecimal amount3 = billInfo.getActRecAmt().negate();
                journalInfo2.setCreditAmount(Constants.ZERO);
                journalInfo2.setDebitAmount(amount3);
                journalCollection.add(journalInfo2);
                String sql = "UPDATE T_CAS_ReceivingBill SET FIsCtrlOppAcct = 1 WHERE FID =?";
                DbUtil.execute((Context)ctx, (String)sql, (Object[])new String[]{billId});
            }
        }
    }

    private JournalInfo createBaseJournal(Context ctx, ReceivingBillInfo billInfo) throws BOSException, EASBizException {
        JournalInfo journalInfo = new JournalInfo();
        journalInfo.setAgentBook(billInfo.isAgentBook());
        journalInfo.setCompany(billInfo.getCompany());
        journalInfo.setSource(JournalSourceEnum.BYBILL);
        journalInfo.setBillId(billInfo.getId().toString());
        journalInfo.setBillType(BillTypeEnum.receiveBill);
        journalInfo.setBillNumber(billInfo.getNumber());
        journalInfo.setBizDate(billInfo.getBizDate());
        CompanyOrgUnitInfo companyInfo1 = billInfo.getCompany();
        Date bookDate = this.getBookDate_cs104(ctx, billInfo.getBizDate(), companyInfo1);
        journalInfo.setCreateDate(bookDate);
        PeriodInfo bookPeriodInfo = PeriodUtils.getPeriodInfo((Context)ctx, (Date)bookDate, (CompanyOrgUnitInfo)companyInfo1);
        journalInfo.setPeriod(bookPeriodInfo);
        journalInfo.setCurrency(billInfo.getCurrency());
        journalInfo.setPlanItem(billInfo.getFpItem());
        journalInfo.setSettlementType(billInfo.getSettlementType());
        journalInfo.setSettlementNumber(billInfo.getSettlementNumber());
        journalInfo.setDescription(billInfo.getDescription());
        journalInfo.setVerifyStatus(VerifyScopeEnum.NOVA);
        journalInfo.setOppUnit(billInfo.getPayerName());
        if (billInfo.getBankCheckFlag() != null) {
            journalInfo.setBankCheckFlag(billInfo.getBankCheckFlag());
        }
        return journalInfo;
    }

    @Override
    public JournalCollection getJournalColl(Context ctx, Set idSet) throws BOSException, EASBizException {
        ReceivingBillCollection coll = this.getReceivingBillCollection(ctx, idSet);
        this.setCompanyId(coll.get(0).getCompany().getId().toString());
        JournalCollection journalCollection = super.getJournalColl(ctx, idSet);
        Iterator it = coll.iterator();
        while (it.hasNext()) {
            ReceivingBillInfo info = (ReceivingBillInfo)it.next();
            this.book(ctx, info.getId().toString(), journalCollection, info);
        }
        return journalCollection;
    }

    private ReceivingBillCollection getReceivingBillCollection(Context ctx, Set idSet) throws BOSException, EASBizException {
        IReceivingBill receivingBill = ReceivingBillFactory.getLocalInstance(ctx);
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)idSet, CompareType.INCLUDE));
        evi.setSelector(this.getSelector());
        evi.setFilter(filter);
        return receivingBill.getReceivingBillCollection(evi);
    }

    private Date getBookDate(Context ctx, ReceivingBillInfo billInfo, CompanyOrgUnitInfo companyInfo) throws BOSException, EASBizException {
        IContextHelper comtextHelper = ContextHelperFactory.getLocalInstance((Context)ctx);
        int cs104 = comtextHelper.getIntParam("CS104", (IObjectPK)new ObjectUuidPK(billInfo.getCompany().getId()));
        if (cs104 == 1) {
            return new Date();
        }
        PeriodInfo currPeriodInfo = SystemStatusCtrolUtils.getCurrentPeriod((Context)ctx, (SystemEnum)SystemEnum.CASHMANAGEMENT, (CompanyOrgUnitInfo)companyInfo);
        if (currPeriodInfo == null) {
            throw new EASBizException(EASBizException.CHECKBLANK, new Object[]{"current Period"});
        }
        Date bookDate = billInfo.getBizDate();
        if (bookDate.before(currPeriodInfo.getBeginDate())) {
            bookDate = currPeriodInfo.getBeginDate();
        }
        return bookDate;
    }

    private AccountBankInfo getAccountBank(Context ctx, ReceivingBillInfo info) throws BOSException, EASBizException {
        ReceivingBillEntryInfo entryInfo = info.getEntries().get(0);
        int size = entryInfo.getAssItemsEntries().size();
        AssItemsForCashRecInfo assItemsinfo = null;
        String accountBankNumber = "";
        for (int i = 0; i < size; ++i) {
            assItemsinfo = entryInfo.getAssItemsEntries().get(i);
            if (!assItemsinfo.isIsSelected() || !"T_BD_AccountBanks".equals(assItemsinfo.getAsstActType().getRealtionDataObject())) continue;
            accountBankNumber = assItemsinfo.getFromNumber();
        }
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        evi.setFilter(filter);
        filter.getFilterItems().add(new FilterItemInfo("number", (Object)accountBankNumber, CompareType.EQUALS));
        IAccountBank iaccountBank = AccountBankFactory.getLocalInstance((Context)ctx);
        AccountBankCollection accountBankColl = iaccountBank.getAccountBankCollection(evi);
        return accountBankColl.get(0);
    }
}

