/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.cas;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.eas.base.core.Constants;
import com.kingdee.eas.basedata.assistant.ConvertModeEnum;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.ExchangeRateFactory;
import com.kingdee.eas.basedata.assistant.ExchangeRateInfo;
import com.kingdee.eas.basedata.assistant.ExchangeTableInfo;
import com.kingdee.eas.basedata.assistant.IExchangeRate;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.SysConstant;
import com.kingdee.eas.fi.cas.ArApRecPayException;
import com.kingdee.eas.fi.cas.CasForArApUtil;
import com.kingdee.eas.fi.cas.ReceivingBillEntryCollection;
import com.kingdee.eas.fi.cas.ReceivingBillEntryInfo;
import com.kingdee.eas.fi.cas.ReceivingBillInfo;
import com.kingdee.eas.fi.cas.SourceTypeEnum;
import com.kingdee.eas.fi.cas.VcStatusEnum;
import com.kingdee.eas.fm.fs.SettBizTypeEnum;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.util.DateTimeUtils;
import java.math.BigDecimal;
import java.util.Date;
import java.util.Locale;

public class ReceivingBillDataProcess {
    static String resourcePath = "com.kingdee.eas.fi.ar.ARRecPayResource";

    public static void setAmountProp(Context ctx, ReceivingBillInfo info) throws EASBizException, BOSException {
        ReceivingBillEntryCollection coll = info.getEntries();
        if (info.getSourceType() != SourceTypeEnum.AR || coll.size() == 0) {
            return;
        }
        if (info.getCurrency() != null) {
            CurrencyInfo currencyInfo = CurrencyFactory.getLocalInstance((Context)ctx).getCurrencyInfo((IObjectPK)new ObjectUuidPK(info.getCurrency().getId()));
            info.setCurrency(currencyInfo);
        }
        if (info.getExchangeRate() == null) {
            ReceivingBillDataProcess.throwBlankExcetion(ResourceBase.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"399_PaymentBillDataProcess", (Locale)ctx.getLocale()));
        }
        StringBuffer errMsg = new StringBuffer(0);
        for (int i = 0; i < info.getEntries().size(); ++i) {
            BigDecimal actAmt;
            ReceivingBillEntryInfo entry = info.getEntries().get(i);
            BigDecimal amt = entry.getAmount() == null ? BigDecimal.ZERO : entry.getAmount();
            BigDecimal rebate = entry.getRebate() == null ? BigDecimal.ZERO : entry.getRebate();
            BigDecimal commission = entry.getCommission() == null ? BigDecimal.ZERO : entry.getCommission();
            BigDecimal bigDecimal = actAmt = entry.getActualAmt() == null ? BigDecimal.ZERO : entry.getActualAmt();
            if (amt.multiply(commission).compareTo(BigDecimal.ZERO) >= 0 && amt.multiply(actAmt).compareTo(BigDecimal.ZERO) >= 0) continue;
            errMsg.append(ResourceBase.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"570_AMOUNT_RANGE_DIFF", (Locale)ctx.getLocale(), (Object[])new String[]{Integer.toString(entry.getSeq())}));
        }
        if (errMsg.length() > 0) {
            ReceivingBillDataProcess.throwBlankExcetion(errMsg.toString());
        }
        BigDecimal amountVc = SysConstant.BIGZERO;
        int size = coll.size();
        for (int i = 0; i < size; ++i) {
            amountVc = coll.get(i).getAmountVc();
            BigDecimal bigDecimal = amountVc = amountVc == null ? SysConstant.BIGZERO : amountVc;
            if (amountVc.compareTo(SysConstant.BIGZERO) == 0) {
                coll.get(i).setVcStatus(VcStatusEnum.NOT_VERIFICATED);
                continue;
            }
            if (amountVc.compareTo(SysConstant.BIGZERO) > 0 && amountVc.compareTo(coll.get(i).getAmount()) < 0) {
                coll.get(i).setVcStatus(VcStatusEnum.PART_VERIFICATED);
                continue;
            }
            if (amountVc.compareTo(coll.get(i).getAmount()) != 0) continue;
            coll.get(i).setVcStatus(VcStatusEnum.FULL_VERIFICATED);
        }
        ExchangeRateInfo rateInfo = CasForArApUtil.getExchangeRate(ctx, info.getCompany(), info.getCurrency(), new Date(), false);
        Object amountLoc = null;
        boolean isDirectExchange = true;
        if (rateInfo != null) {
            isDirectExchange = CasForArApUtil.isDirectExchangeRate(rateInfo);
        }
        int basePrecision = 4;
        CompanyOrgUnitInfo companyInfo = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo("select baseCurrency.precision where id = '" + info.getCompany().getId().toString() + "'");
        if (companyInfo != null) {
            basePrecision = companyInfo.getBaseCurrency().getPrecision();
        }
        ReceivingBillDataProcess.setAmt(info.getEntries(), info.getExchangeRate(), isDirectExchange, basePrecision);
        for (int i = 0; i < coll.size(); ++i) {
            if (coll.get(i).getAmount().compareTo(SysConstant.BIGZERO) == 0) {
                coll.get(i).setAmount(coll.get(i).getActualAmt().add(coll.get(i).getRebate()));
                if (!info.isIsInitializeBill() || info.getEntries().get(i).getUnVcLocAmount() == null || info.getEntries().get(i).getUnVcLocAmount().compareTo(SysConstant.BIGZERO) == 0) {
                    coll.get(i).setLocalAmt(coll.get(i).getActualLocAmt().add(coll.get(i).getRebateLocAmt()));
                }
            }
            if (coll.get(i).getActualAmt().compareTo(SysConstant.BIGZERO) != 0) continue;
            coll.get(i).setActualAmt(coll.get(i).getAmount().subtract(coll.get(i).getRebate()));
            if (info.isIsInitializeBill() && info.getEntries().get(i).getUnVcLocAmount() != null && info.getEntries().get(i).getUnVcLocAmount().compareTo(SysConstant.BIGZERO) != 0) continue;
            coll.get(i).setActualLocAmt(coll.get(i).getLocalAmt().subtract(coll.get(i).getRebateLocAmt()));
        }
        if (info.isIsInitializeBill()) {
            ReceivingBillDataProcess.setLockAmt(ctx, info, info.getEntries());
        }
        ReceivingBillDataProcess.setUnLockAmt(info.getEntries(), info.getExchangeRate(), isDirectExchange, basePrecision);
        BigDecimal flag = info.getEntries().get(0).getUnVcLocAmount();
        if (!info.isIsInitializeBill() || info.isIsImport() || flag == null || flag.compareTo(SysConstant.BIGZERO) == 0) {
            ReceivingBillDataProcess.setUnVcAmt(info.getEntries(), info.getExchangeRate(), isDirectExchange, basePrecision);
        }
        ReceivingBillDataProcess.setMatchedAmount(info.getEntries(), info.getExchangeRate(), isDirectExchange, basePrecision);
        ReceivingBillDataProcess.setActualAmt(info.getEntries(), info.getExchangeRate(), isDirectExchange, basePrecision);
        if (info.isIsInitializeBill() && ctx.get((Object)"haveDesbill") == null) {
            ReceivingBillDataProcess.setHisUnVcAmt(info.getEntries());
        }
        if (info.getBizType() != null && info.getBizType().getType() != null) {
            SettBizTypeEnum type = info.getBizType().getType();
            info.setSettleBizType(type);
        }
        ReceivingBillDataProcess.setHeadAmt(info);
    }

    private static void setAmt(ReceivingBillEntryCollection coll, BigDecimal exchangeRate, boolean isDirectExchange, int basePrecision) {
        BigDecimal Amt = null;
        BigDecimal AmtLoc = null;
        for (int i = 0; i < coll.size(); ++i) {
            Amt = coll.get(i).getAmount();
            Amt = Amt == null ? BigDecimal.ZERO : Amt;
            AmtLoc = CasForArApUtil.calculateLocalAmount(Amt, exchangeRate, isDirectExchange, basePrecision);
            coll.get(i).setAmount(Amt);
            coll.get(i).setLocalAmt(AmtLoc);
        }
    }

    private static void setMatchedAmount(ReceivingBillEntryCollection coll, BigDecimal exchangeRate, boolean isDirectExchange, int basePrecision) {
        BigDecimal apAmt = null;
        BigDecimal apLocAmt = null;
        BigDecimal matchedAmount = null;
        BigDecimal matchedAmountLoc = null;
        for (int i = 0; i < coll.size(); ++i) {
            apAmt = coll.get(i).getAmount();
            apLocAmt = coll.get(i).getLocalAmt();
            matchedAmount = coll.get(i).getMatchedAmount();
            matchedAmount = matchedAmount == null ? BigDecimal.ZERO : matchedAmount;
            matchedAmountLoc = CasForArApUtil.calculateLocalAmount(matchedAmount, exchangeRate, isDirectExchange, basePrecision);
            coll.get(i).setMatchedAmount(matchedAmount);
            coll.get(i).setMatchedAmountLoc(matchedAmountLoc);
        }
    }

    private static void setActualAmt(ReceivingBillEntryCollection coll, BigDecimal exchangeRate, boolean isDirectExchange, int basePrecision) {
        BigDecimal Amt = null;
        BigDecimal AmtLoc = null;
        BigDecimal actualAmt = null;
        BigDecimal actualAmtLoc = null;
        BigDecimal rebate = null;
        BigDecimal rebateLoc = null;
        BigDecimal commission = null;
        BigDecimal commissionLoc = null;
        for (int i = 0; i < coll.size(); ++i) {
            Amt = coll.get(i).getAmount();
            AmtLoc = coll.get(i).getLocalAmt();
            rebate = coll.get(i).getRebate();
            rebate = rebate == null ? BigDecimal.ZERO : rebate;
            rebateLoc = CasForArApUtil.calculateLocalAmount(rebate, exchangeRate, isDirectExchange, basePrecision);
            commission = coll.get(i).getCommission();
            commission = commission == null ? BigDecimal.ZERO : commission;
            commissionLoc = CasForArApUtil.calculateLocalAmount(commission, exchangeRate, isDirectExchange, basePrecision);
            actualAmt = Amt.subtract(rebate).subtract(commission);
            actualAmtLoc = AmtLoc.subtract(rebateLoc).subtract(commissionLoc);
            coll.get(i).setActualAmt(actualAmt);
            coll.get(i).setActualLocAmt(actualAmtLoc);
            coll.get(i).setRebate(rebate);
            coll.get(i).setRebateLocAmt(rebateLoc);
        }
    }

    private static void throwBlankExcetion(String messageItem) throws EASBizException {
        throw new ArApRecPayException(ArApRecPayException.BLANK, new String[]{messageItem});
    }

    private static void setHisUnVcAmt(ReceivingBillEntryCollection coll) {
        BigDecimal unVcAmt = null;
        BigDecimal unVcLocAmt = null;
        int size = coll.size();
        for (int i = 0; i < size; ++i) {
            unVcAmt = coll.get(i).getUnVcAmount();
            unVcAmt = unVcAmt == null ? SysConstant.BIGZERO : unVcAmt;
            coll.get(i).setHisUnVcAmount(unVcAmt);
            unVcLocAmt = coll.get(i).getUnVcLocAmount();
            unVcLocAmt = unVcLocAmt == null ? SysConstant.BIGZERO : unVcLocAmt;
            coll.get(i).setHisUnVcLocAmount(unVcLocAmt);
        }
    }

    private static void setHeadAmt(ReceivingBillInfo info) throws EASBizException, BOSException {
        BigDecimal Amt = null;
        BigDecimal LocAmt = null;
        BigDecimal actualAmt = SysConstant.BIGZERO;
        BigDecimal actualLocAmt = SysConstant.BIGZERO;
        BigDecimal verifiedAmt = SysConstant.BIGZERO;
        BigDecimal verifiedLocAmt = SysConstant.BIGZERO;
        BigDecimal unVerifiedAmt = SysConstant.BIGZERO;
        BigDecimal unVerifiedLocAmt = SysConstant.BIGZERO;
        BigDecimal actualAmtSum = SysConstant.BIGZERO;
        BigDecimal actualLocAmtSum = SysConstant.BIGZERO;
        BigDecimal verifiedAmtSum = SysConstant.BIGZERO;
        BigDecimal verifiedLocAmtSum = SysConstant.BIGZERO;
        BigDecimal unVerifiedAmtSum = SysConstant.BIGZERO;
        BigDecimal unVerifiedLocAmtSum = SysConstant.BIGZERO;
        BigDecimal HAmt = null;
        BigDecimal HLocAmt = null;
        HAmt = SysConstant.BIGZERO;
        HLocAmt = SysConstant.BIGZERO;
        ReceivingBillEntryCollection entryColl = info.getEntries();
        int size = entryColl.size();
        for (int i = 0; i < size; ++i) {
            Amt = entryColl.get(i).getAmount();
            Amt = Amt == null ? SysConstant.BIGZERO : Amt;
            LocAmt = entryColl.get(i).getLocalAmt();
            LocAmt = LocAmt == null ? SysConstant.BIGZERO : LocAmt;
            HAmt = HAmt.add(Amt);
            HLocAmt = HLocAmt.add(LocAmt);
            actualAmt = entryColl.get(i).getActualAmt();
            actualAmt = actualAmt == null ? SysConstant.BIGZERO : actualAmt;
            actualLocAmt = entryColl.get(i).getActualLocAmt();
            actualLocAmt = actualLocAmt == null ? SysConstant.BIGZERO : actualLocAmt;
            verifiedAmt = entryColl.get(i).getAmountVc();
            verifiedAmt = verifiedAmt == null ? SysConstant.BIGZERO : verifiedAmt;
            verifiedLocAmt = entryColl.get(i).getLocalAmtVc();
            verifiedLocAmt = verifiedLocAmt == null ? SysConstant.BIGZERO : verifiedLocAmt;
            unVerifiedAmt = entryColl.get(i).getUnVcAmount();
            unVerifiedAmt = unVerifiedAmt == null ? SysConstant.BIGZERO : unVerifiedAmt;
            unVerifiedLocAmt = entryColl.get(i).getUnVcLocAmount();
            unVerifiedLocAmt = unVerifiedLocAmt == null ? SysConstant.BIGZERO : unVerifiedLocAmt;
            actualAmtSum = actualAmtSum.add(actualAmt);
            actualLocAmtSum = actualLocAmtSum.add(actualLocAmt);
            verifiedAmtSum = verifiedAmtSum.add(verifiedAmt);
            verifiedLocAmtSum = verifiedLocAmtSum.add(verifiedLocAmt);
            unVerifiedAmtSum = unVerifiedAmtSum.add(unVerifiedAmt);
            unVerifiedLocAmtSum = unVerifiedLocAmtSum.add(unVerifiedLocAmt);
        }
        info.setAmount(HAmt);
        info.setLocalAmt(HLocAmt);
        info.setActRecAmt(actualAmtSum);
        info.setActRecLocAmt(actualLocAmtSum);
        info.setVerifiedAmt(verifiedAmtSum);
        info.setVerifiedAmtLoc(verifiedLocAmtSum);
        info.setUnVerifiedAmt(unVerifiedAmtSum);
        info.setUnVerifiedAmtLoc(unVerifiedLocAmtSum);
    }

    private static void setUnLockAmt(ReceivingBillEntryCollection coll, BigDecimal exchangeRate, boolean isDirectExchange, int basePrecision) {
        BigDecimal arAmt = null;
        BigDecimal arLocAmt = null;
        BigDecimal lockAmt = null;
        BigDecimal lockLocAmt = null;
        int size = coll.size();
        for (int i = 0; i < size; ++i) {
            arAmt = coll.get(i).getAmount();
            lockAmt = coll.get(i).getLockAmt();
            lockAmt = lockAmt == null ? BigDecimal.ZERO : lockAmt;
            coll.get(i).setLockAmt(lockAmt);
            coll.get(i).setUnLockAmt(arAmt.add(lockAmt.negate()));
            arLocAmt = coll.get(i).getLocalAmt();
            arLocAmt = arLocAmt == null ? SysConstant.BIGZERO : arLocAmt;
            lockLocAmt = CasForArApUtil.calculateLocalAmount(lockAmt, exchangeRate, isDirectExchange, basePrecision);
            lockLocAmt = lockLocAmt == null ? SysConstant.BIGZERO : lockLocAmt;
            coll.get(i).setLockLocAmt(lockLocAmt);
            coll.get(i).setUnLockLocAmt(arLocAmt.add(lockLocAmt.negate()));
        }
    }

    private static void setLockAmt(Context ctx, ReceivingBillInfo info, ReceivingBillEntryCollection coll) throws EASBizException, BOSException {
        BigDecimal arAmtVc = null;
        BigDecimal arLocAmtVc = null;
        CurrencyInfo curr = info.getCurrency();
        BigDecimal exchangeRate = info.getExchangeRate();
        boolean isIndirectExRate = ReceivingBillDataProcess.getIsIndirectExchangeRate(ctx, curr, null, info.getCompany(), info.getBizDate());
        if (!isIndirectExRate && exchangeRate.compareTo(SysConstant.BIGZERO) != 0) {
            exchangeRate = Constants.ONE.divide(exchangeRate, exchangeRate.scale(), 4);
        }
        int size = coll.size();
        for (int i = 0; i < size; ++i) {
            arAmtVc = coll.get(i).getAmountVc();
            arAmtVc = arAmtVc == null ? SysConstant.BIGZERO : arAmtVc;
            coll.get(i).setLockAmt(arAmtVc);
            arLocAmtVc = ReceivingBillDataProcess.getLocalAmt(exchangeRate, curr.getPrecision(), arAmtVc);
            arLocAmtVc = arLocAmtVc == null ? SysConstant.BIGZERO : arLocAmtVc;
            coll.get(i).setLockLocAmt(arLocAmtVc);
        }
    }

    private static void setUnVcAmt(ReceivingBillEntryCollection coll, BigDecimal exchangeRate, boolean isDirectExchange, int basePrecision) throws EASBizException, BOSException {
        BigDecimal arAmt = null;
        BigDecimal arLocAmt = null;
        BigDecimal vcAmt = null;
        BigDecimal vcLocAmt = null;
        int size = coll.size();
        for (int i = 0; i < size; ++i) {
            arAmt = coll.get(i).getAmount();
            vcAmt = coll.get(i).getAmountVc();
            vcAmt = vcAmt == null ? SysConstant.BIGZERO : vcAmt;
            coll.get(i).setUnVcAmount(arAmt.subtract(vcAmt));
            arLocAmt = coll.get(i).getLocalAmt();
            vcLocAmt = CasForArApUtil.calculateLocalAmount(vcAmt, exchangeRate, isDirectExchange, basePrecision);
            vcLocAmt = vcLocAmt == null ? SysConstant.BIGZERO : vcLocAmt;
            coll.get(i).setUnVcLocAmount(arLocAmt.subtract(vcLocAmt));
        }
    }

    private static BigDecimal getLocalAmt(BigDecimal exchangeRate, int precision, BigDecimal amt) {
        if (exchangeRate == null) {
            exchangeRate = new BigDecimal("1");
        }
        return amt.multiply(exchangeRate).setScale(precision, 4);
    }

    private static boolean getIsIndirectExchangeRate(Context ctx, CurrencyInfo srcCurr, CurrencyInfo destCurr, CompanyOrgUnitInfo company, Date date) throws EASBizException, BOSException {
        ExchangeTableInfo baseExchangeTable;
        if (srcCurr == null || date == null) {
            return true;
        }
        if (company == null) {
            company = (CompanyOrgUnitInfo)ctx.get((Object)"CompanyInfo");
        }
        CompanyOrgUnitInfo newcompany = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(company.getId()));
        if (destCurr == null) {
            destCurr = newcompany.getBaseCurrency();
        }
        if ((baseExchangeTable = newcompany.getBaseExchangeTable()) == null) {
            return true;
        }
        date = DateTimeUtils.truncateDate((Date)date);
        ObjectUuidPK sourceCurrpk = new ObjectUuidPK(srcCurr.getId());
        ObjectUuidPK destCurrpk = new ObjectUuidPK(destCurr.getId());
        ObjectUuidPK exchangeTablepk = new ObjectUuidPK(baseExchangeTable.getId());
        IExchangeRate iExchangRate = ExchangeRateFactory.getLocalInstance((Context)ctx);
        ExchangeRateInfo exRateInfo = iExchangRate.getExchangeRateConvertInfo((IObjectPK)exchangeTablepk, (IObjectPK)sourceCurrpk, (IObjectPK)destCurrpk, date);
        if (exRateInfo == null) {
            return true;
        }
        return !exRateInfo.getConvertMode().equals((Object)ConvertModeEnum.INDIRECTEXCHANGERATE);
    }

    public static void setCasAmount(Context ctx, ReceivingBillInfo info) throws EASBizException, BOSException {
        boolean isIndirectExRate;
        CurrencyInfo curr = info.getCurrency();
        BigDecimal exchangeRate = info.getExchangeRate();
        if (exchangeRate == null) {
            exchangeRate = Constants.ONE;
        }
        if (!(isIndirectExRate = ReceivingBillDataProcess.getIsIndirectExchangeRate(ctx, curr, null, info.getCompany(), info.getBizDate())) && exchangeRate.compareTo(SysConstant.BIGZERO) != 0) {
            exchangeRate = Constants.ONE.divide(exchangeRate, exchangeRate.scale(), 4);
        }
        int baseCurrencyPrecision = 0;
        CurrencyInfo baseCurrency = info.getCompany().getBaseCurrency();
        if (baseCurrency != null) {
            if (baseCurrency.getPrecision() == 0) {
                baseCurrency = (CurrencyInfo)CurrencyFactory.getLocalInstance((Context)ctx).getValue("SELECT id, number, name, precision WHERE id = '" + String.valueOf(baseCurrency.getId()) + "'");
            }
            baseCurrencyPrecision = baseCurrency.getPrecision();
        }
        ReceivingBillEntryCollection coll = info.getEntries();
        for (int i = 0; i < coll.size(); ++i) {
            if (coll.get(i).getRebate() == null) {
                coll.get(i).setRebate(SysConstant.BIGZERO);
            }
            if (coll.get(i).getRebateLocAmt() == null) {
                coll.get(i).setRebateLocAmt(ReceivingBillDataProcess.getLocalAmt(exchangeRate, baseCurrencyPrecision, coll.get(i).getRebate()));
            }
            if (coll.get(i).getActualAmt() == null) {
                coll.get(i).setActualAmt(SysConstant.BIGZERO);
            }
            if (coll.get(i).getActualLocAmt() == null) {
                coll.get(i).setActualLocAmt(ReceivingBillDataProcess.getLocalAmt(exchangeRate, baseCurrencyPrecision, coll.get(i).getActualAmt()));
            }
            if (coll.get(i).getCommission() == null) {
                coll.get(i).setCommission(SysConstant.BIGZERO);
            }
            if (coll.get(i).getCommissionLocAmt() == null) {
                coll.get(i).setCommissionLocAmt(ReceivingBillDataProcess.getLocalAmt(exchangeRate, baseCurrencyPrecision, coll.get(i).getCommission()));
            }
            if (coll.get(i).getActualAmt().compareTo(SysConstant.BIGZERO) != 0) {
                coll.get(i).setAmount(coll.get(i).getActualAmt().add(coll.get(i).getRebate()).add(coll.get(i).getCommission()));
                coll.get(i).setLocalAmt(coll.get(i).getActualLocAmt().add(coll.get(i).getRebateLocAmt()).add(coll.get(i).getCommissionLocAmt()));
            }
            if (coll.get(i).getActualAmtVc() == null) {
                coll.get(i).setActualAmtVc(SysConstant.BIGZERO);
            }
            if (coll.get(i).getActualLocAmtVc() != null) continue;
            coll.get(i).setActualLocAmtVc(SysConstant.BIGZERO);
        }
    }
}

