/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.cas;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.dao.query.ISQLExecutor;
import com.kingdee.bos.dao.query.SQLExecutorFactory;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.cas.client.ClientUtils;
import com.kingdee.eas.fi.gl.GLPeriodFacadeFactory;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.common.FilterParam;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import org.apache.log4j.Logger;

public class VoucherCheckFilterParam
implements FilterParam {
    private static Logger logger = Logger.getLogger((String)VoucherCheckFilterParam.class.getName());
    private static final long serialVersionUID = -5355192293311958891L;
    private boolean isByDate;
    private int spiBeginYear;
    private int spiEndYear;
    private int spiBeginMonth;
    private int spiEndMonth;
    private Date dptFromDate;
    private Date dptToDate;
    private int accountType;
    private String accountNumberFrom;
    private String accountNumberTo;
    private String currencyId;
    private int isChecked;
    private boolean isBookByEntry;
    private CompanyOrgUnitInfo currentCompany;
    private int isAuditCheck;
    private String acctBankID;

    public String getAccountNumberFrom() {
        return this.accountNumberFrom;
    }

    public void setAccountNumberFrom(String accountNumberFrom) {
        this.accountNumberFrom = accountNumberFrom;
    }

    public String getAccountNumberTo() {
        return this.accountNumberTo;
    }

    public void setAccountNumberTo(String accountNumberTo) {
        this.accountNumberTo = accountNumberTo;
    }

    public int getAccountType() {
        if (this.accountType == 0) {
            this.accountType = 999;
        }
        return this.accountType;
    }

    public void setAccountType(int accountType) {
        this.accountType = accountType;
    }

    public String getCurrencyId() {
        return this.currencyId;
    }

    public void setCurrencyId(String currencyId) {
        this.currencyId = currencyId;
    }

    public Date getDptFromDate() {
        return this.dptFromDate;
    }

    public void setDptFromDate(Date dptFromDate) {
        this.dptFromDate = dptFromDate;
    }

    public Date getDptToDate() {
        return this.dptToDate;
    }

    public void setDptToDate(Date dptToDate) {
        this.dptToDate = dptToDate;
    }

    public boolean isByDate() {
        return this.isByDate;
    }

    public void setByDate(boolean isByDate) {
        this.isByDate = isByDate;
    }

    public int getIsChecked() {
        return this.isChecked;
    }

    public void setIsChecked(int isChecked) {
        this.isChecked = isChecked;
    }

    public int getSpiBeginMonth() {
        if (this.spiBeginMonth == 0) {
            this.initDefaultPeriod();
        }
        return this.spiBeginMonth;
    }

    public void setSpiBeginMonth(int spiBeginMonth) {
        this.spiBeginMonth = spiBeginMonth;
    }

    public int getSpiBeginYear() {
        if (this.spiBeginYear == 0) {
            this.initDefaultPeriod();
        }
        return this.spiBeginYear;
    }

    private void initDefaultPeriod() {
        try {
            PeriodInfo curPeriod = ClientUtils.getCurrentPeriod(null, (CompanyOrgUnitInfo)this.getCurrentCompany());
            this.spiBeginYear = curPeriod.getPeriodYear();
            this.spiBeginMonth = curPeriod.getPeriodNumber();
            this.spiEndYear = curPeriod.getPeriodYear();
            this.spiEndMonth = curPeriod.getPeriodNumber();
        }
        catch (EASBizException e) {
            e.printStackTrace();
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
    }

    public void setSpiBeginYear(int spiBeginYear) {
        this.spiBeginYear = spiBeginYear;
    }

    public int getSpiEndMonth() {
        if (this.spiEndMonth == 0) {
            this.initDefaultPeriod();
        }
        return this.spiEndMonth;
    }

    public void setSpiEndMonth(int spiEndMonth) {
        this.spiEndMonth = spiEndMonth;
    }

    public int getSpiEndYear() {
        if (this.spiEndYear == 0) {
            this.initDefaultPeriod();
        }
        return this.spiEndYear;
    }

    public void setSpiEndYear(int spiEndYear) {
        this.spiEndYear = spiEndYear;
    }

    public FilterInfo getFilter() {
        FilterInfo filterInfo = new FilterInfo();
        String sql = null;
        sql = this.isBookByEntry ? "SELECT E.FID ID FROM T_GL_VoucherEntry E INNER JOIN T_BD_AccountView V ON E.FAccountID = V.FID Inner join T_GL_Voucher vo on vo.fid= e.fbillid " : "SELECT E.FBillID ID FROM T_GL_VoucherEntry E LEFT  JOIN T_BD_AccountView V ON E.FAccountID = V.FID INNER  JOIN T_GL_Voucher vo on vo.fid= e.fbillid ";
        StringBuffer sqlBuf = new StringBuffer(256);
        sqlBuf.append(sql);
        if (!FMHelper.isEmpty((String)this.getAcctBankID())) {
            sqlBuf.append(" LEFT OUTER JOIN T_GL_VoucherAssistRecord AS ASSISTRECORDS ON E.FID = ASSISTRECORDS.FEntryID  LEFT OUTER JOIN T_BD_AssistantHG AS ASSGRP  ON ASSISTRECORDS.FAssGrpID = ASSGRP.FID  LEFT OUTER JOIN T_BD_AccountBanks AS BANKACCOUNT  ON ASSGRP.FBankAccountID = BANKACCOUNT.FID ");
        }
        sqlBuf.append(" where ");
        if (this.getAccountType() == 999) {
            sqlBuf.append(" (V.FIsCash=1 Or V.FIsBank=1) ");
        } else if (this.getAccountType() == 1) {
            sqlBuf.append(" V.FIsCash=1 ");
        } else if (this.getAccountType() == 2) {
            sqlBuf.append(" V.FIsBank=1 ");
        }
        sqlBuf.append("\u3000and V.fCompanyid ='" + this.getCurrentCompany().getId().toString() + "'");
        if (this.getAccountNumberFrom() != null) {
            sqlBuf.append("  and V.FNumber>='");
            sqlBuf.append(this.getAccountNumberFrom());
            sqlBuf.append("'");
        }
        if (this.getAccountNumberTo() != null) {
            sqlBuf.append("  and V.FNumber<='");
            sqlBuf.append(this.getAccountNumberTo());
            sqlBuf.append("'");
        }
        if (this.getCurrencyId() != null) {
            sqlBuf.append(" and E.fcurrencyId='");
            sqlBuf.append(this.getCurrencyId());
            sqlBuf.append("'");
        }
        if (this.isByDate) {
            if (this.dptFromDate != null) {
                sqlBuf.append(" and vo.fbookedDate>=");
                sqlBuf.append(FMHelper.formateSqlDate((Date)this.dptFromDate));
            }
            if (this.dptToDate != null) {
                sqlBuf.append(" and vo.fbookedDate<=");
                sqlBuf.append(FMHelper.formateSqlDate((Date)this.dptToDate));
            }
        } else {
            HashSet<String> companyIds = new HashSet<String>();
            CompanyOrgUnitInfo companyInfo = this.getCurrentCompany();
            if (!EmptyUtil.isEmpty((CoreBaseInfo)companyInfo)) {
                companyIds.add(companyInfo.getId().toString());
            }
            Integer from = new Integer(this.spiBeginYear * 100 + this.spiBeginMonth);
            Integer to = new Integer(this.spiEndYear * 100 + this.spiEndMonth);
            try {
                Set pIds = GLPeriodFacadeFactory.getRemoteInstance().getPeriodIds(companyIds, from.intValue(), to.intValue());
                if (pIds.size() == 0) {
                    pIds.add("unknow");
                }
                if (pIds != null && !pIds.isEmpty()) {
                    sqlBuf.append(" and vo.FPeriodID in ");
                    sqlBuf.append(FMHelper.setTran2String((Set)pIds));
                }
            }
            catch (BOSException e) {
                logger.error((Object)e);
                SysUtil.abort((Throwable)e);
            }
        }
        sqlBuf.append(" and vo.fcompanyid='");
        sqlBuf.append(this.getCurrentCompany().getId());
        sqlBuf.append("'");
        if (!FMHelper.isEmpty((String)this.getAcctBankID())) {
            sqlBuf.append(" and BANKACCOUNT.FID='");
            sqlBuf.append(this.getAcctBankID());
            sqlBuf.append("'");
        }
        if (this.isAuditCheck == 2) {
            filterInfo.getFilterItems().add(new FilterItemInfo("bizStatus", (Object)new Integer(3), CompareType.GREATER_EQUALS));
        }
        filterInfo.getFilterItems().add(new FilterItemInfo("bizStatus", (Object)new Integer(2), CompareType.NOTEQUALS));
        filterInfo.getFilterItems().add(new FilterItemInfo("bizStatus", (Object)new Integer(0), CompareType.NOTEQUALS));
        HashSet<String> idSet = new HashSet<String>();
        ISQLExecutor executor = SQLExecutorFactory.getRemoteInstance((String)sqlBuf.toString());
        try {
            IRowSet rs = executor.executeSQL();
            while (rs.next()) {
                idSet.add(rs.getString("ID"));
            }
        }
        catch (Exception e) {
            logger.error((Object)e);
            e.printStackTrace();
        }
        if (idSet.size() <= 0) {
            idSet.add("---");
        }
        if (this.isBookByEntry) {
            filterInfo.getFilterItems().add(new FilterItemInfo("entries.id", idSet, CompareType.INCLUDE));
            if (this.getIsChecked() != 999) {
                if (this.getIsChecked() == 1) {
                    filterInfo.getFilterItems().add(new FilterItemInfo("entries.isCheck", (Object)Boolean.TRUE));
                } else {
                    filterInfo.getFilterItems().add(new FilterItemInfo("entries.isCheck", (Object)Boolean.FALSE));
                }
            }
        } else {
            filterInfo.getFilterItems().add(new FilterItemInfo("id", idSet, CompareType.INCLUDE));
            if (this.getIsChecked() != 999) {
                if (this.getIsChecked() == 1) {
                    filterInfo.getFilterItems().add(new FilterItemInfo("isCheck", (Object)Boolean.TRUE));
                } else {
                    filterInfo.getFilterItems().add(new FilterItemInfo("isCheck", (Object)Boolean.FALSE));
                }
            }
        }
        logger.info((Object)filterInfo.toSql());
        return filterInfo;
    }

    public boolean isBookByEntry() {
        return this.isBookByEntry;
    }

    public SorterItemCollection getSorterItems() {
        SorterItemCollection sorter = new SorterItemCollection();
        sorter.add(new SorterItemInfo("bookedDate"));
        return sorter;
    }

    public String getAcctBankID() {
        return this.acctBankID;
    }

    public void setAcctBankID(String acctBankID) {
        this.acctBankID = acctBankID;
    }

    public void setBookByEntry(boolean isBookByEntry) {
        this.isBookByEntry = isBookByEntry;
    }

    public void setCurrentCompany(CompanyOrgUnitInfo currentCompany) {
        this.currentCompany = currentCompany;
    }

    public CompanyOrgUnitInfo getCurrentCompany() {
        return this.currentCompany;
    }

    public void setIsAuditCheck(int isAuditCheck) {
        this.isAuditCheck = isAuditCheck;
    }

    public int getIsAuditCheck() {
        return this.isAuditCheck;
    }
}

