/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.cas;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.ISQLExecutor;
import com.kingdee.bos.dao.query.SQLExecutorFactory;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.PeriodUtils;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fm.common.ContextHelperFactory;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.common.FilterParam;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import org.apache.log4j.Logger;

public class VoucherImport2JournalFilterParam
implements FilterParam {
    private static Logger logger = Logger.getLogger((String)VoucherImport2JournalFilterParam.class.getName());
    private static final long serialVersionUID = -994625663898400381L;
    private boolean isByDate;
    private int spiBeginYear;
    private int spiEndYear;
    private int spiBeginMonth;
    private int spiEndMonth;
    private Date dptFromDate;
    private Date dptToDate;
    private int accountType;
    private String accountNumberFrom;
    private String accountNumberTo;
    private String currencyId;
    private int isChecked;
    private CompanyOrgUnitInfo company;
    private Set bank;

    public CompanyOrgUnitInfo getCompany() {
        return this.company;
    }

    public void setCompany(CompanyOrgUnitInfo company) {
        this.company = company;
    }

    public Set getBank() {
        return this.bank;
    }

    public void setBank(Set bank) {
        this.bank = bank;
    }

    public String getAccountNumberFrom() {
        return this.accountNumberFrom;
    }

    public void setAccountNumberFrom(String accountNumberFrom) {
        this.accountNumberFrom = accountNumberFrom;
    }

    public String getAccountNumberTo() {
        return this.accountNumberTo;
    }

    public void setAccountNumberTo(String accountNumberTo) {
        this.accountNumberTo = accountNumberTo;
    }

    public int getAccountType() {
        return this.accountType;
    }

    public void setAccountType(int accountType) {
        this.accountType = accountType;
    }

    public String getCurrencyId() {
        return this.currencyId;
    }

    public void setCurrencyId(String currencyId) {
        this.currencyId = currencyId;
    }

    public Date getDptFromDate() {
        return this.dptFromDate;
    }

    public void setDptFromDate(Date dptFromDate) {
        this.dptFromDate = dptFromDate;
    }

    public Date getDptToDate() {
        return this.dptToDate;
    }

    public void setDptToDate(Date dptToDate) {
        this.dptToDate = dptToDate;
    }

    public boolean isByDate() {
        return this.isByDate;
    }

    public void setByDate(boolean isByDate) {
        this.isByDate = isByDate;
    }

    public int getIsChecked() {
        return this.isChecked;
    }

    public void setIsChecked(int isChecked) {
        this.isChecked = isChecked;
    }

    public int getSpiBeginMonth() {
        return this.spiBeginMonth;
    }

    public void setSpiBeginMonth(int spiBeginMonth) {
        this.spiBeginMonth = spiBeginMonth;
    }

    public int getSpiBeginYear() {
        return this.spiBeginYear;
    }

    public void setSpiBeginYear(int spiBeginYear) {
        this.spiBeginYear = spiBeginYear;
    }

    public int getSpiEndMonth() {
        return this.spiEndMonth;
    }

    public void setSpiEndMonth(int spiEndMonth) {
        this.spiEndMonth = spiEndMonth;
    }

    public int getSpiEndYear() {
        return this.spiEndYear;
    }

    public void setSpiEndYear(int spiEndYear) {
        this.spiEndYear = spiEndYear;
    }

    public FilterInfo getFilter() {
        boolean isBookByEntry = true;
        FilterInfo filterInfo = new FilterInfo();
        String sql = null;
        sql = isBookByEntry ? "SELECT E.FID ID FROM T_GL_VoucherEntry E LEFT JOIN T_BD_AccountView V ON E.FAccountID = V.FID LEFT join T_GL_Voucher vo on vo.fid= e.fbillid " : "SELECT E.FBillID ID FROM T_GL_VoucherEntry E LEFT JOIN T_BD_AccountView V ON E.FAccountID = V.FID LEFT join T_GL_Voucher vo on vo.fid= e.fbillid ";
        StringBuffer sqlBuf = new StringBuffer(256);
        sqlBuf.append(sql);
        sqlBuf.append(" where ");
        CompanyOrgUnitInfo companyInfo = this.company;
        if (this.getAccountType() == 999) {
            sqlBuf.append(" (V.FIsCash=1 Or V.FIsBank=1) ");
        } else if (this.getAccountType() == 1) {
            sqlBuf.append(" V.FIsCash=1 ");
        } else if (this.getAccountType() == 2) {
            sqlBuf.append(" V.FIsBank=1 ");
        }
        sqlBuf.append("\u3000and V.FCompanyID ='" + companyInfo.getId().toString() + "'");
        if (this.getAccountNumberFrom() != null) {
            sqlBuf.append("  and V.FNumber>='");
            sqlBuf.append(this.getAccountNumberFrom());
            sqlBuf.append("'");
        }
        if (this.getAccountNumberTo() != null) {
            sqlBuf.append("  and V.FNumber<='");
            sqlBuf.append(this.getAccountNumberTo());
            sqlBuf.append("'");
        }
        if (this.getCurrencyId() != null) {
            sqlBuf.append(" and E.fcurrencyId='");
            sqlBuf.append(this.getCurrencyId());
            sqlBuf.append("'");
        }
        if (this.isByDate) {
            if (this.dptFromDate != null) {
                sqlBuf.append(" and vo.fbookedDate<=");
                sqlBuf.append(FMHelper.formateSqlDate((Date)this.dptFromDate));
            }
            if (this.dptToDate != null) {
                sqlBuf.append(" and vo.fbookedDate>=");
                sqlBuf.append(FMHelper.formateSqlDate((Date)this.dptToDate));
            }
        } else {
            PeriodInfo beginPeriod = null;
            PeriodInfo endPeriod = null;
            try {
                beginPeriod = PeriodUtils.getPeriodInfo((int)this.spiBeginYear, (int)this.spiBeginMonth, (CompanyOrgUnitInfo)companyInfo);
                endPeriod = PeriodUtils.getPeriodInfo((int)this.spiEndYear, (int)this.spiEndMonth, (CompanyOrgUnitInfo)companyInfo);
            }
            catch (EASBizException e) {
                logger.error((Object)e);
                SysUtil.abort();
            }
            catch (BOSException e) {
                logger.error((Object)e);
                SysUtil.abort();
            }
            if (beginPeriod != null) {
                sqlBuf.append(" and vo.fbookedDate>=");
                sqlBuf.append(FMHelper.formateSqlDate((Date)beginPeriod.getBeginDate()));
            }
            if (endPeriod != null) {
                sqlBuf.append(" and vo.fbookedDate<=");
                sqlBuf.append(FMHelper.formateSqlDate((Date)endPeriod.getEndDate()));
            }
        }
        sqlBuf.append(" and vo.fcompanyid='");
        sqlBuf.append(companyInfo.getId());
        sqlBuf.append("'");
        HashSet<String> idSet = new HashSet<String>();
        ISQLExecutor executor = SQLExecutorFactory.getRemoteInstance((String)sqlBuf.toString());
        try {
            IRowSet rs = executor.executeSQL();
            while (rs.next()) {
                idSet.add(rs.getString("ID"));
            }
        }
        catch (Exception e) {
            logger.error((Object)e);
            e.printStackTrace();
        }
        if (idSet.size() <= 0) {
            idSet.add("---");
        }
        if (isBookByEntry) {
            filterInfo.getFilterItems().add(new FilterItemInfo("entries.id", idSet, CompareType.INCLUDE));
            if (this.getIsChecked() != 999) {
                if (this.getIsChecked() == 1) {
                    filterInfo.getFilterItems().add(new FilterItemInfo("entries.isCheck", (Object)Boolean.TRUE));
                } else {
                    filterInfo.getFilterItems().add(new FilterItemInfo("entries.isCheck", (Object)Boolean.FALSE));
                }
            }
        } else {
            filterInfo.getFilterItems().add(new FilterItemInfo("id", idSet, CompareType.INCLUDE));
            if (this.getIsChecked() != 999) {
                if (this.getIsChecked() == 1) {
                    filterInfo.getFilterItems().add(new FilterItemInfo("isCheck", (Object)Boolean.TRUE));
                } else {
                    filterInfo.getFilterItems().add(new FilterItemInfo("isCheck", (Object)Boolean.FALSE));
                }
            }
        }
        ObjectUuidPK pk = new ObjectUuidPK(ContextHelperFactory.getRemoteInstance().getCurrentCompany().getId());
        boolean isAuditCheck = ContextHelperFactory.getRemoteInstance().getBooleanParam("GL_047", (IObjectPK)pk);
        if (isAuditCheck) {
            filterInfo.getFilterItems().add(new FilterItemInfo("bizStatus", (Object)new Integer(3), CompareType.GREATER_EQUALS));
        }
        filterInfo.getFilterItems().add(new FilterItemInfo("bizStatus", (Object)new Integer(2), CompareType.NOTEQUALS));
        filterInfo.getFilterItems().add(new FilterItemInfo("bizStatus", (Object)new Integer(0), CompareType.NOTEQUALS));
        if (this.getAccountType() == 2 && this.getBank() != null) {
            filterInfo.getFilterItems().add(new FilterItemInfo("bankAccount.number", (Object)this.getBank(), CompareType.INCLUDE));
        }
        return filterInfo;
    }

    public SorterItemCollection getSorterItems() {
        SorterItemCollection sorter = new SorterItemCollection();
        SorterItemInfo sorterinfo = new SorterItemInfo("bookedDate");
        sorterinfo.setSortType(SortType.DESCEND);
        sorter.add(sorterinfo);
        SorterItemInfo sorterinfo2 = new SorterItemInfo("createTime");
        sorterinfo2.setSortType(SortType.DESCEND);
        sorter.add(sorterinfo2);
        sorter.add(new SorterItemInfo("id"));
        sorter.add(new SorterItemInfo("entries.seq"));
        return sorter;
    }
}

