/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.cas.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.eas.base.param.util.ParamManager;
import com.kingdee.eas.base.permission.IPermission;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.basedata.assistant.AccountBankInfo;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.ExchangeRateInfo;
import com.kingdee.eas.basedata.assistant.PaymentTypeInfo;
import com.kingdee.eas.basedata.assistant.SettlementTypeInfo;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolInfo;
import com.kingdee.eas.basedata.master.account.AccountViewInfo;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeInfo;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitCollection;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.NewOrgViewHelper;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.basedata.scm.common.BillTypeInfo;
import com.kingdee.eas.fi.cas.CasForArApUtil;
import com.kingdee.eas.fi.cas.RecPayHelper;
import com.kingdee.eas.fi.cas.ReceivingBillTypeInfo;
import com.kingdee.eas.fi.cas.app.RecAndPayDataImportUtil;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.tools.datatask.core.TaskExternalException;
import com.kingdee.eas.util.ResourceBase;
import java.util.Date;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Map;

public class ARAPImportCache {
    private Map isContrastAccountCache = new HashMap(10);
    private Map companyCache = new HashMap(10);
    private Map receivingTypeCache = new HashMap(10);
    private Map sysStatusCtrolCache = new HashMap(10);
    private Map paymentTypeCache = new HashMap(10);
    private Map asstActTypeCache = new HashMap(10);
    private Map billTypeCache = new HashMap(10);
    private Map accountViewCache = new HashMap(10);
    private Map paramCache = new HashMap(10);
    private Map exchangeRateCache = new HashMap(10);
    private Map payTypeCache = new HashMap(10);
    private Map recTypeCache = new HashMap(10);
    private Map currencyCache = new HashMap(10);
    private Map accountBankCache = new HashMap(10);
    private Map settlementTypeCache = new HashMap(10);
    private Map adminOrgCache = new HashMap(10);
    private Map personCache = new HashMap(10);
    private Map<String, FullOrgUnitCollection> orgPermissionCache = new HashMap<String, FullOrgUnitCollection>(10);
    private Map<String, Map> cache = new HashMap<String, Map>();

    public void ARAPImportCache() {
    }

    public Map getIsContrastAccountCache() {
        return this.isContrastAccountCache;
    }

    public Map getCompanyCache() {
        return this.companyCache;
    }

    public Map getPaymentTypeCache() {
        return this.paymentTypeCache;
    }

    public Map getAsstActTypeCache() {
        return this.asstActTypeCache;
    }

    public Map getBillTypeCache() {
        return this.billTypeCache;
    }

    public Map getAccountViewCache() {
        return this.accountViewCache;
    }

    public Map getParamCache() {
        return this.paramCache;
    }

    public Map getExchangeRateCache() {
        return this.exchangeRateCache;
    }

    public Map<String, FullOrgUnitCollection> getOrgPermissionCache() {
        return this.orgPermissionCache;
    }

    public Map<String, Map> getCache() {
        return this.cache;
    }

    public Map getSysStatusCtrolCache() {
        return this.sysStatusCtrolCache;
    }

    public boolean getImportParamByCache(Context ctx) {
        boolean importDataByRule = false;
        if (this.paramCache.get("importDataByRule") != null) {
            importDataByRule = (Boolean)this.paramCache.get("importDataByRule");
        } else {
            importDataByRule = RecPayHelper.getImportParam(ctx);
            this.paramCache.put("importDataByRule", importDataByRule);
        }
        return importDataByRule;
    }

    public void checkOrgPermissionByCache(Context ctx, CompanyOrgUnitInfo company, String permItemName) throws TaskExternalException {
        OrgType orgType = OrgType.Company;
        try {
            FullOrgUnitCollection orgCol;
            ObjectUuidPK treePK = new ObjectUuidPK(NewOrgViewHelper.convert2TreeId((OrgType)orgType));
            ObjectUuidPK cuId = new ObjectUuidPK(company.getCU().getId().toString());
            String key = permItemName + treePK.toString() + cuId.toString();
            if (this.orgPermissionCache.get(key) == null) {
                IPermission permission = PermissionFactory.getLocalInstance((Context)ctx);
                orgCol = permission.getAuthorizedOrgOfCU((IObjectPK)cuId, ctx.getCaller(), OrgType.Company, (IObjectPK)treePK, permItemName);
                this.orgPermissionCache.put(key, orgCol);
            } else {
                orgCol = this.orgPermissionCache.get(key);
            }
            boolean isHasPerm = false;
            for (int i = 0; i < orgCol.size(); ++i) {
                FullOrgUnitInfo orgInfo = orgCol.get(i);
                if (!orgInfo.getId().toString().equals(company.getId().toString())) continue;
                isHasPerm = true;
            }
            if (!isHasPerm) {
                throw new TaskExternalException(ResourceBase.getString((String)"com.kingdee.eas.fi.cas.ArApRecPayDataImportResource", (String)"MULTIORGIMPORT", (Locale)ctx.getLocale(), (Object[])new Object[]{company.getNumber()}));
            }
        }
        catch (Exception e) {
            throw new TaskExternalException(e.getMessage());
        }
    }

    public CompanyOrgUnitInfo getCompanyByCache(Context ctx, Hashtable hsData, String field) throws TaskExternalException {
        String companyNumber = RecAndPayDataImportUtil.getDataString(hsData, field);
        CompanyOrgUnitInfo info = null;
        if (this.companyCache.get(companyNumber) != null) {
            return (CompanyOrgUnitInfo)this.companyCache.get(companyNumber);
        }
        info = RecAndPayDataImportUtil.getCompanyByNumberWithSeletor(ctx, companyNumber);
        this.companyCache.put(companyNumber, info);
        return info;
    }

    public SystemStatusCtrolInfo getSysStatusCtrolInfoByCache(Context ctx, SystemEnum system, CompanyOrgUnitInfo currentCompany) throws BOSException {
        SystemStatusCtrolInfo sscInfo;
        if (currentCompany == null) {
            return null;
        }
        String key = currentCompany.getNumber() + system.getValue();
        if (this.sysStatusCtrolCache.get(key) != null) {
            sscInfo = (SystemStatusCtrolInfo)this.sysStatusCtrolCache.get(key);
        } else {
            sscInfo = RecAndPayDataImportUtil.getSysStatusCtrolInfo(ctx, currentCompany, system);
            this.sysStatusCtrolCache.put(key, sscInfo);
        }
        return sscInfo;
    }

    public PaymentTypeInfo getPaymentTypeInfoByCache(Context ctx, Hashtable hsData, String field) throws TaskExternalException, BOSException {
        PaymentTypeInfo paymentTypeInfo;
        String paymentTypeNumber = RecAndPayDataImportUtil.getDataString(hsData, field);
        if (this.paymentTypeCache.get(paymentTypeNumber) != null) {
            paymentTypeInfo = (PaymentTypeInfo)this.paymentTypeCache.get(paymentTypeNumber);
        } else {
            paymentTypeInfo = RecAndPayDataImportUtil.getPaymentTypeInfo(ctx, hsData, field);
            this.paymentTypeCache.put(paymentTypeNumber, paymentTypeInfo);
        }
        return paymentTypeInfo;
    }

    public ReceivingBillTypeInfo getReceivingTypeInfoByCache(Context ctx, Hashtable hsData, String field) throws TaskExternalException {
        ReceivingBillTypeInfo receivingTypeInfo;
        String receivingTypeNumber = RecAndPayDataImportUtil.getDataString(hsData, field);
        if (this.receivingTypeCache.get(receivingTypeNumber) != null) {
            receivingTypeInfo = (ReceivingBillTypeInfo)this.receivingTypeCache.get(receivingTypeNumber);
        } else {
            receivingTypeInfo = RecAndPayDataImportUtil.getRecTypeByNumber(receivingTypeNumber, ctx);
            this.receivingTypeCache.put(receivingTypeNumber, receivingTypeInfo);
        }
        return receivingTypeInfo;
    }

    public AsstActTypeInfo getAsstActTypeInfoByCache(Context ctx, Hashtable hsData, String field) throws TaskExternalException {
        AsstActTypeInfo asstActTypeInfo;
        String asstActType = RecAndPayDataImportUtil.getDataString(hsData, field);
        if (this.asstActTypeCache.get(asstActType) != null) {
            asstActTypeInfo = (AsstActTypeInfo)this.asstActTypeCache.get(asstActType);
        } else {
            String msg = ResourceBase.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"38_ArApPaymentBillDataImport", (Locale)ctx.getLocale());
            asstActTypeInfo = RecAndPayDataImportUtil.getAsstActTypeByNumber(ctx, msg, asstActType);
            this.asstActTypeCache.put(asstActType, asstActTypeInfo);
        }
        return asstActTypeInfo;
    }

    public String getParamByCache(Context ctx, String paramKey, String companyId) throws TaskExternalException {
        try {
            String paramValue;
            String key = paramKey + companyId;
            if (this.paramCache.get(key) != null) {
                paramValue = (String)this.paramCache.get(key);
            } else {
                paramValue = ParamManager.getParamValue((Context)ctx, (IObjectPK)new ObjectUuidPK(companyId), (String)paramKey);
                this.paramCache.put(key, paramValue);
            }
            return paramValue;
        }
        catch (Exception e) {
            throw new TaskExternalException(e.getMessage());
        }
    }

    public ExchangeRateInfo getExchangeRateInfoByCache(Context ctx, CompanyOrgUnitInfo companyOrgUnitInfo, CurrencyInfo currencyInfo, Date date) throws TaskExternalException {
        try {
            ExchangeRateInfo exchangeRateInfo = null;
            if (companyOrgUnitInfo == null || currencyInfo == null) {
                return null;
            }
            String key = companyOrgUnitInfo.getId().toString() + currencyInfo.getId().toString() + date.toString();
            if (this.exchangeRateCache.get(key) != null) {
                exchangeRateInfo = (ExchangeRateInfo)this.exchangeRateCache.get(key);
            } else {
                exchangeRateInfo = CasForArApUtil.getExchangeRate(ctx, companyOrgUnitInfo, currencyInfo, date);
                this.exchangeRateCache.put(key, exchangeRateInfo);
            }
            return exchangeRateInfo;
        }
        catch (Exception e) {
            throw new TaskExternalException(e.getMessage());
        }
    }

    public Map getPayTypeCache() {
        return this.payTypeCache;
    }

    public Map getRecTypeCache() {
        return this.recTypeCache;
    }

    public Map getCurrencyCache() {
        return this.currencyCache;
    }

    public CurrencyInfo getCurrencyInfoByCache(Context ctx, Hashtable hsData, String field) throws TaskExternalException {
        CurrencyInfo currencyInfo;
        String currencyNumber = RecAndPayDataImportUtil.getDataString(hsData, field);
        if (this.currencyCache.get(currencyNumber) != null) {
            currencyInfo = (CurrencyInfo)this.currencyCache.get(currencyNumber);
        } else {
            currencyInfo = RecAndPayDataImportUtil.getCurrencyByNumber(ctx, currencyNumber);
            this.currencyCache.put(currencyNumber, currencyInfo);
        }
        return currencyInfo;
    }

    public Map getAccountBankCache() {
        return this.accountBankCache;
    }

    public AccountBankInfo getAccountBankByCache(Context ctx, Hashtable hsData, String companyId, String msg, String field) throws TaskExternalException {
        AccountBankInfo accountBankInfo;
        String accountBankNumber = RecAndPayDataImportUtil.getDataString(hsData, field);
        String key = accountBankNumber + companyId;
        if (this.accountBankCache.get(key) != null) {
            accountBankInfo = (AccountBankInfo)this.accountBankCache.get(key);
        } else {
            accountBankInfo = RecAndPayDataImportUtil.getAccountBankByNumber(ctx, msg, companyId, accountBankNumber);
            this.accountBankCache.put(key, accountBankInfo);
        }
        return accountBankInfo;
    }

    public AccountViewInfo getRecPayAccountViewInfoByCache(Context ctx, Hashtable hsData, String companyId, String currencyId, String msg, String field) throws TaskExternalException {
        AccountViewInfo accountViewInfo;
        String acountViewInfoNumber = RecAndPayDataImportUtil.getDataString(hsData, field);
        String key = companyId + currencyId + acountViewInfoNumber;
        if (this.accountViewCache.get(key) != null) {
            accountViewInfo = (AccountViewInfo)this.accountViewCache.get(key);
        } else {
            accountViewInfo = RecAndPayDataImportUtil.getAccountByNumber(ctx, msg, companyId, currencyId, acountViewInfoNumber);
            this.accountViewCache.put(key, accountViewInfo);
        }
        return accountViewInfo;
    }

    public Map getSettlementTypeCache() {
        return this.settlementTypeCache;
    }

    public SettlementTypeInfo getSettlementTypeInfoByCache(Context ctx, Hashtable hsData, String field) throws TaskExternalException {
        SettlementTypeInfo settTypeInfo;
        String settTypeNumber = RecAndPayDataImportUtil.getDataString(hsData, field);
        String key = settTypeNumber;
        if (this.settlementTypeCache.get(key) != null) {
            settTypeInfo = (SettlementTypeInfo)this.settlementTypeCache.get(key);
        } else {
            settTypeInfo = RecAndPayDataImportUtil.getSettlementTypeByNumber(settTypeNumber, ctx);
            this.settlementTypeCache.put(key, settTypeInfo);
        }
        return settTypeInfo;
    }

    public AdminOrgUnitInfo getAdminOrgUnitInfoByCache(Context ctx, Hashtable hsData, String field) throws TaskExternalException {
        AdminOrgUnitInfo adminOrgUnitInfo;
        String adminOrgUnitNumber = RecAndPayDataImportUtil.getDataString(hsData, field);
        String key = adminOrgUnitNumber;
        if (this.adminOrgCache.get(key) != null) {
            adminOrgUnitInfo = (AdminOrgUnitInfo)this.adminOrgCache.get(key);
        } else {
            adminOrgUnitInfo = RecAndPayDataImportUtil.getAdminOrgUnitByNumber(ctx, ResourceBase.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"39_ArApPaymentBillDataImport", (Locale)ctx.getLocale()), adminOrgUnitNumber);
            this.adminOrgCache.put(key, adminOrgUnitInfo);
        }
        return adminOrgUnitInfo;
    }

    public PersonInfo getPersonInfoByCache(Context ctx, Hashtable hsData, String field) throws TaskExternalException {
        PersonInfo personInfo;
        String personNumber = RecAndPayDataImportUtil.getDataString(hsData, field);
        String key = personNumber;
        if (this.personCache.get(key) != null) {
            personInfo = (PersonInfo)this.personCache.get(key);
        } else {
            personInfo = RecAndPayDataImportUtil.getPersonInfoByNumber(ctx, ResourceBase.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"40_ArApPaymentBillDataImport", (Locale)ctx.getLocale()), personNumber);
            this.personCache.put(key, personInfo);
        }
        return personInfo;
    }

    public BillTypeInfo getBillTypeByCache(Context ctx, Hashtable hsData, String field) throws TaskExternalException {
        BillTypeInfo billTypeInfo;
        String billTypeNumber = RecAndPayDataImportUtil.getDataString(hsData, field);
        String key = billTypeNumber;
        if (this.billTypeCache.get(key) != null) {
            billTypeInfo = (BillTypeInfo)this.billTypeCache.get(key);
        } else {
            billTypeInfo = RecAndPayDataImportUtil.getBillType(ctx, hsData, field);
            this.billTypeCache.put(key, billTypeInfo);
        }
        return billTypeInfo;
    }
}

