/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.cas.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.AbstractObjectCollection;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.dao.query.QueryExecutorFactory;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.bot.BOTRelationCollection;
import com.kingdee.bos.metadata.bot.BOTRelationFactory;
import com.kingdee.bos.metadata.bot.BOTRelationInfo;
import com.kingdee.bos.metadata.bot.IBOTRelation;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.botp.BOTBillOperStateEnum;
import com.kingdee.eas.base.btp.BTPException;
import com.kingdee.eas.base.codingrule.CodingRuleException;
import com.kingdee.eas.base.core.Constants;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.base.core.util.NumberRuleUtil;
import com.kingdee.eas.base.core.util.StringUtil;
import com.kingdee.eas.base.log.LogUtil;
import com.kingdee.eas.base.netctrl.IMutexServiceControl;
import com.kingdee.eas.base.netctrl.MutexServiceControlFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.base.wssc.BillImageFacadeFactory;
import com.kingdee.eas.base.wssc.IBillImageFacade;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.master.account.AccountViewInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitCollection;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.cp.bc.BizAccountBillInfo;
import com.kingdee.eas.cp.bc.BizAccountOutBillInfo;
import com.kingdee.eas.cp.bc.BizCollUtil;
import com.kingdee.eas.cp.bc.DailyLoanBillInfo;
import com.kingdee.eas.cp.bc.DailyPurchaseAccountBillInfo;
import com.kingdee.eas.cp.bc.EvectionLoanBillInfo;
import com.kingdee.eas.cp.bc.ExpenseTypeInfo;
import com.kingdee.eas.cp.bc.ExpenseTypeSubjectMappingCollection;
import com.kingdee.eas.cp.bc.ExpenseTypeSubjectMappingFactory;
import com.kingdee.eas.cp.bc.IBizCollBillBase;
import com.kingdee.eas.cp.bc.TravelAccountBillInfo;
import com.kingdee.eas.fi.cas.AgentPayBillBookNotifyBuilder;
import com.kingdee.eas.fi.cas.AgentPayBillCollection;
import com.kingdee.eas.fi.cas.AgentPayBillDisposerFactory;
import com.kingdee.eas.fi.cas.AgentPayBillEntryCollection;
import com.kingdee.eas.fi.cas.AgentPayBillEntryFactory;
import com.kingdee.eas.fi.cas.AgentPayBillEntryInfo;
import com.kingdee.eas.fi.cas.AgentPayBillException;
import com.kingdee.eas.fi.cas.AgentPayBillFactory;
import com.kingdee.eas.fi.cas.AgentPayBillInfo;
import com.kingdee.eas.fi.cas.BankAgentPayBillBuilder;
import com.kingdee.eas.fi.cas.BillDisposerAction;
import com.kingdee.eas.fi.cas.BillStatusEnum;
import com.kingdee.eas.fi.cas.BookNotifyFacadeFactory;
import com.kingdee.eas.fi.cas.CasException;
import com.kingdee.eas.fi.cas.CashBgHelper;
import com.kingdee.eas.fi.cas.DisposerActionEnum;
import com.kingdee.eas.fi.cas.IAgentPayBill;
import com.kingdee.eas.fi.cas.IAgentPayBillEntry;
import com.kingdee.eas.fi.cas.IPaymentDisposer;
import com.kingdee.eas.fi.cas.JournalFactory;
import com.kingdee.eas.fi.cas.OperateBillEnum;
import com.kingdee.eas.fi.cas.PaymentBillLogFactory;
import com.kingdee.eas.fi.cas.PaymentBillLogInfo;
import com.kingdee.eas.fi.cas.PaymentOperateType;
import com.kingdee.eas.fi.cas.RecPayAcctBankStratageCtrl;
import com.kingdee.eas.fi.cas.RecPayException;
import com.kingdee.eas.fi.cas.RecPayHelper;
import com.kingdee.eas.fi.cas.app.AbstractAgentPayBillControllerBean;
import com.kingdee.eas.fi.cas.basedata.CasUtilFacadeFactory;
import com.kingdee.eas.fi.cas.basedata.ICasUtilFacade;
import com.kingdee.eas.fi.cas.utils.PayAdmitUtils;
import com.kingdee.eas.fi.gl.EntryDC;
import com.kingdee.eas.fi.gl.VoucherEntryCollection;
import com.kingdee.eas.fi.gl.VoucherEntryInfo;
import com.kingdee.eas.fi.gl.VoucherFactory;
import com.kingdee.eas.fi.gl.VoucherInfo;
import com.kingdee.eas.fm.be.BEBankCollection;
import com.kingdee.eas.fm.be.BEBankFactory;
import com.kingdee.eas.fm.be.BEBankInfo;
import com.kingdee.eas.fm.be.BEException;
import com.kingdee.eas.fm.be.BankAgentPayBillFactory;
import com.kingdee.eas.fm.be.BankAgentPayBillInfo;
import com.kingdee.eas.fm.be.BankFacadeFactory;
import com.kingdee.eas.fm.be.BankPayingBillStateEnum;
import com.kingdee.eas.fm.be.ErrCodeHelper;
import com.kingdee.eas.fm.be.IBankAgentPayBill;
import com.kingdee.eas.fm.cbs.CBAgentPayBillWebFacadeFactory;
import com.kingdee.eas.fm.cbs.CBPaymentFactory;
import com.kingdee.eas.fm.cbs.CBPaymentInfo;
import com.kingdee.eas.fm.common.DateHelper;
import com.kingdee.eas.fm.common.FMBGHelper;
import com.kingdee.eas.fm.common.FMException;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.common.FMVerifyHelper;
import com.kingdee.eas.fm.common.IFMBgUsed;
import com.kingdee.eas.framework.BillBaseInfo;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.CoreBillBaseCollection;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.ma.budget.BgControlFacadeFactory;
import com.kingdee.eas.ma.budget.IBgControlFacade;
import com.kingdee.eas.ma.nbudget.BgControlCaller;
import com.kingdee.eas.ma.pca.PcVoucherInfo;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.DateTimeUtils;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;

public class AgentPayBillControllerBean
extends AbstractAgentPayBillControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fi.cas.app.AgentPayBillControllerBean");
    public static final String BIZFLOW_BOTP_RELATION_KEY = "relationColl";
    private final BOSObjectType billBosType = BOSObjectType.create((String)"131C7D36");
    RecPayHelper helper = new RecPayHelper();
    private static final String FEETYPE = "\u6536\u4ed8\u7c7b\u522b";
    private static final String PAYBANKACCOUNT = "\u4ed8\u6b3e\u8d26\u53f7";
    private static final String PAYERACCOUNT = "\u4ed8\u6b3e\u79d1\u76ee";
    private static final String PAYERBANK = "\u4ed8\u6b3e\u94f6\u884c";
    private static final String CURRENCY = "\u5e01\u522b";
    private static final String EXCHANGERATE = "\u6c47\u7387";
    private static final String SETTLEMENTTYPE = "\u7ed3\u7b97\u65b9\u5f0f";
    private static final String USAGE = "\u7528\u9014";
    private static final String EXPECTDEALTIME = "\u671f\u671b\u4ea4\u6613\u65f6\u95f4";
    private static final String FUNDFLOWITEM = "\u8d44\u91d1\u6d41\u91cf\u9879\u76ee";
    private static final String RECNAME = "\u59d3\u540d";
    private static final String RECBANKACCOUNT = "\u94f6\u884c\u8d26\u53f7";
    private static final String RECBANKNAME = "\u6536\u6b3e\u94f6\u884c";
    private static final String AMOUNT = "\u91d1\u989d";
    private static final String RECPROVINCE = "\u6536\u6b3e\u65b9\u7701";
    private static final String RECCITY = "\u6536\u6b3e\u65b9\u5e02\u53bf";
    private static final String CERTTYPE = "\u8bc1\u4ef6\u7c7b\u578b";
    private static final String CERTNUM = "\u8bc1\u4ef6\u53f7";

    protected IObjectPK _addnew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        IObjectPK pkOut;
        AgentPayBillInfo info = (AgentPayBillInfo)model;
        if (EmptyUtil.isEmpty((String)info.getNumber())) {
            try {
                AgentPayBillControllerBean.initAgentPayBillNumber(ctx, info);
            }
            catch (CodingRuleException e) {
                logger.info((Object)e);
                throw new FMException(FMException.COMMMONEXCEPTION, new Object[]{e.getMessage()});
            }
        }
        if (info.isIsReGenBill()) {
            String sql = "Update T_CAS_AgentPayBill Set FIsGenerateBill = FIsGenerateBill where Fid = ?";
            DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{info.getSourceBillId()});
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)info.getSourceBillId()));
            filter.getFilterItems().add(new FilterItemInfo("isGenerateBill", (Object)true));
            if (AgentPayBillFactory.getLocalInstance(ctx).exists(filter)) {
                throw new RecPayException(RecPayException.NOT_GEN_AGENTPAY);
            }
            sql = "Update T_CAS_AgentPayBill Set FIsGenerateBill = 1 where Fid= ?";
            DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{info.getSourceBillId()});
        }
        FMVerifyHelper.checkBlank((Context)ctx, (IObjectValue)info, (String)"number");
        this.checkNumberDup(ctx, (IObjectValue)info);
        this.fillHandAmountProperty(ctx, info);
        this.initEntryOppAccount(ctx, info);
        if (info.isIsCBPay() && info.getCbPayInfo() == null) {
            CBPaymentInfo cbInfo = CBAgentPayBillWebFacadeFactory.getLocalInstance((Context)ctx).setCBPayInfo4BOTP(info);
            CBPaymentFactory.getLocalInstance((Context)ctx).addnew((CoreBaseInfo)cbInfo);
            info.setCbPayInfo(cbInfo);
        }
        if (info.getSourceBillId() != null) {
            this.setEntries_oppAccount(ctx, info);
        }
        if (!EmptyUtil.isEmpty((String)info.getDescription()) && info.getDescription().length() > 255) {
            info.setDescription(info.getDescription().substring(0, 255));
        }
        if (!EmptyUtil.isEmpty((String)info.getUsage()) && info.getUsage().length() > 200) {
            info.setUsage(info.getUsage().substring(0, 200));
        }
        for (int index = 0; index < info.getEntrys().size(); ++index) {
            AgentPayBillEntryInfo entry = info.getEntrys().get(index);
            if (EmptyUtil.isEmpty((String)entry.getRemark()) || entry.getRemark().length() <= 255) continue;
            entry.setRemark(entry.getRemark().substring(0, 255));
        }
        if (info.getEntrys().size() != info.getCount()) {
            logger.error((Object)("\u4ee3\u53d1\u5355\u603b\u7b14\u6570\u4e0e\u5206\u5f55\u7b14\u6570\u4e0d\u4e00\u81f4\uff0c\u603b\u7b14\u6570\uff1a" + info.getCount() + "\u5206\u5f55\u7b14\u6570\uff1a" + info.getEntrys().size()));
        }
        PayAdmitUtils.verifyPayadmit(ctx, (CoreBaseInfo)info, true);
        IObjectPK pk = super._addnew(ctx, model);
        if (info.isIsReGenBill()) {
            this.helper.createBotpRelation(ctx, info.getSourceBillId(), pk.toString());
            pkOut = LogUtil.beginLog((Context)ctx, null, (BOSObjectType)info.getBOSType(), null, (String)info.getNumber(), (String)"cas_agentpaymentbill_genbill");
            LogUtil.afterLog((Context)ctx, (IObjectPK)pkOut);
        } else {
            pkOut = LogUtil.beginLog((Context)ctx, null, (BOSObjectType)info.getBOSType(), null, (String)info.getNumber(), (String)"cas_agentpaymentBill_addnew");
            LogUtil.afterLog((Context)ctx, (IObjectPK)pkOut);
        }
        return pk;
    }

    protected void _update(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        AgentPayBillInfo info = (AgentPayBillInfo)model;
        PayAdmitUtils.verifyPayadmit(ctx, (CoreBaseInfo)info, false);
        super._update(ctx, pk, model);
    }

    protected void _newHandleAfterTransform(Context ctx, String action, IObjectValue objectValue, String mappingId, IObjectCollection relationCol) throws BOSException, EASBizException {
        objectValue.put(BIZFLOW_BOTP_RELATION_KEY, (Object)relationCol);
        objectValue.put("mappingId", (Object)mappingId);
    }

    protected void _newHandleAfterTransform(Context ctx, String action, IObjectCollection collection, String mappingId, IObjectCollection relationCol) throws BOSException, EASBizException {
        int size = collection.size();
        for (int i = 0; i < size; ++i) {
            collection.getObject(i).put(BIZFLOW_BOTP_RELATION_KEY, (Object)relationCol);
            collection.getObject(i).put("mappingId", (Object)mappingId);
        }
    }

    protected void initEntryOppAccount(Context ctx, AgentPayBillInfo info) throws BOSException, EASBizException {
        BOSUuid sbid;
        if (!EmptyUtil.isEmpty((String)info.getSourceBillId()) && ((sbid = BOSUuid.read((String)info.getSourceBillId())).getType().equals((Object)new BizAccountBillInfo().getBOSType()) || sbid.getType().equals((Object)new BizAccountOutBillInfo().getBOSType()) || sbid.getType().equals((Object)new DailyPurchaseAccountBillInfo().getBOSType()) || sbid.getType().equals((Object)new TravelAccountBillInfo().getBOSType()) || sbid.getType().equals((Object)new DailyLoanBillInfo().getBOSType()) || sbid.getType().equals((Object)new EvectionLoanBillInfo().getBOSType()))) {
            for (int index = 0; index < info.getEntrys().size(); ++index) {
                ExpenseTypeInfo expenseType = info.getEntrys().get(index).getExpenseType();
                if (EmptyUtil.isEmpty((CoreBaseInfo)expenseType)) continue;
                EntityViewInfo view = new EntityViewInfo();
                FilterInfo filter = new FilterInfo();
                view.setFilter(filter);
                SelectorItemCollection sic = new SelectorItemCollection();
                view.setSelector(sic);
                sic.add(new SelectorItemInfo("id"));
                sic.add(new SelectorItemInfo("accountId.*"));
                filter.getFilterItems().add(new FilterItemInfo("expenseTypeId.id", (Object)expenseType.getId().toString()));
                filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)info.getCompany().getId().toString()));
                ExpenseTypeSubjectMappingCollection colls = ExpenseTypeSubjectMappingFactory.getLocalInstance((Context)ctx).getExpenseTypeSubjectMappingCollection(view);
                if (colls.size() <= 0) continue;
                AccountViewInfo oppAcct = colls.get(0).getAccountId();
                if (!EmptyUtil.isEmpty((Object)info.getId()) || !EmptyUtil.isEmpty((CoreBaseInfo)info.getEntrys().get(index).getOppAccount())) continue;
                ObjectUuidPK pk = new ObjectUuidPK(info.getId());
                if (!EmptyUtil.isEmpty((Object)info.getId()) && (EmptyUtil.isEmpty((Object)info.getId()) || AgentPayBillFactory.getLocalInstance(ctx).exists((IObjectPK)pk))) continue;
                info.getEntrys().get(index).setOppAccount(oppAcct);
            }
        }
    }

    protected void fillHandAmountProperty(Context ctx, AgentPayBillInfo info) {
        BigDecimal amount = Constants.ZERO;
        if (EmptyUtil.isEmpty((Object)info.getAmount())) {
            for (int index = 0; index < info.getEntrys().size(); ++index) {
                AgentPayBillEntryInfo entry = info.getEntrys().get(index);
                if (entry.getAmount() == null) continue;
                amount = amount.add(entry.getAmount());
            }
            info.setAmount(amount);
            if (EmptyUtil.isEmpty((Object)info.getExchangeRate())) {
                info.setExchangeRate(Constants.ONE);
            }
            try {
                if (info.getCompany() != null && info.getCompany().getBaseCurrency() == null) {
                    EntityViewInfo view = new EntityViewInfo();
                    FilterInfo filter = new FilterInfo();
                    filter.getFilterItems().add(new FilterItemInfo("id", (Object)info.getCompany().getId().toString(), CompareType.EQUALS));
                    view.setFilter(filter);
                    view.getSelector().add("*");
                    view.getSelector().add("basecurrency.*");
                    CompanyOrgUnitCollection collection = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitCollection(view);
                    info.setCompany(collection.get(0));
                }
                CurrencyInfo baseCurrency = CurrencyFactory.getLocalInstance((Context)ctx).getCurrencyInfo((IObjectPK)new ObjectUuidPK(info.getCompany().getBaseCurrency().getId()));
                info.setLocalAmount(amount.multiply(info.getExchangeRate()).setScale(baseCurrency.getPrecision(), 4));
                info.setActualAmount(Constants.ZERO);
                info.setActualCount(0);
            }
            catch (EASBizException e) {
                e.printStackTrace();
            }
            catch (BOSException e) {
                e.printStackTrace();
            }
        }
        if (EmptyUtil.isEmpty((Object)info.getActualAmount())) {
            info.setActualAmount(Constants.ZERO);
        }
        if (info.getActualCount() == 0) {
            info.setActualCount(0);
        }
        if (info.getCount() == 0 && info.getEntrys() != null && info.getEntrys().size() > 0) {
            info.setCount(info.getEntrys().size());
        }
    }

    protected void checkNumberDup(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        FilterInfo filter = FMHelper.getCheckNumberDupFilter((IObjectValue)model, (boolean)true);
        if (this._exists(ctx, filter)) {
            throw new EASBizException(EASBizException.CHECKDUPNUMBER, new Object[]{model.getString("number"), ""});
        }
    }

    protected IObjectPK _submit(Context ctx, IObjectValue value) throws BOSException, EASBizException {
        IBillImageFacade image;
        String imageNumber;
        AgentPayBillInfo oldInfo;
        AgentPayBillInfo oldInfo2;
        ICoreBase iCoreBase;
        AgentPayBillInfo info = (AgentPayBillInfo)value;
        boolean delFlag = false;
        if (info.getSourceBillId() != null && (iCoreBase = BizCollUtil.getBizInterfaceByBOSUuid((Context)ctx, (BOSUuid)BOSUuid.read((String)info.getSourceBillId().toString()))) != null && iCoreBase instanceof IBizCollBillBase) {
            delFlag = true;
        }
        AgentPayBillEntryCollection dbillentrycoll = null;
        if (delFlag) {
            AgentPayBillEntryCollection ebillentrycoll = info.getEntrys();
            ArrayList<String> elist = new ArrayList<String>();
            ArrayList dlist = new ArrayList();
            if (ebillentrycoll != null) {
                for (int i = 0; i < ebillentrycoll.size(); ++i) {
                    if (ebillentrycoll.get(i).getId() == null) continue;
                    elist.add(ebillentrycoll.get(i).getId().toString());
                }
                if (info.getId() != null) {
                    String billId = info.getId().toString();
                    EntityViewInfo View = new EntityViewInfo();
                    SelectorItemCollection Sic = new SelectorItemCollection();
                    Sic.add(new SelectorItemInfo("*"));
                    View.setSelector(Sic);
                    FilterInfo filter = new FilterInfo();
                    filter.getFilterItems().add(new FilterItemInfo("parent", (Object)billId, CompareType.EQUALS));
                    View.setFilter(filter);
                    dbillentrycoll = AgentPayBillEntryFactory.getLocalInstance(ctx).getAgentPayBillEntryCollection(View);
                    for (int i = 0; i < dbillentrycoll.size(); ++i) {
                        String pid = dbillentrycoll.get(i).getId().toString();
                        if (!elist.contains(pid)) continue;
                        dbillentrycoll.removeObject(i);
                    }
                }
            }
        }
        if (EmptyUtil.isEmpty((Object)((Object)info.getBillStatus())) || info.getBillStatus().equals((Object)BillStatusEnum.SAVE)) {
            info.setBillStatus(BillStatusEnum.SUBMIT);
        }
        if (info.getId() != null && this._exists(ctx, (IObjectPK)new ObjectUuidPK(info.getId())) && (oldInfo2 = (AgentPayBillInfo)this.getValue(ctx, (IObjectPK)new ObjectStringPK(info.getId().toString()))).getBillStatus().getValue() != 10 && oldInfo2.getBillStatus().getValue() != 11) {
            throw new AgentPayBillException(AgentPayBillException.CANNOTSUBMIT);
        }
        info.setBizDate(DateTimeUtils.truncateDate((Date)info.getBizDate()));
        AgentPayBillEntryCollection acoll = info.getEntrys();
        for (int i = 0; i < acoll.size(); ++i) {
            Pattern pattern;
            Matcher isNum;
            AgentPayBillEntryInfo ainfo = acoll.get(i);
            if (!EmptyUtil.isEmpty((String)ainfo.getRecBankAccount()) && !(isNum = (pattern = Pattern.compile("^[^\\s]*$")).matcher(ainfo.getRecBankAccount().toString())).matches()) {
                throw new CasException(CasException.ISNOTNUMBER);
            }
            if (!EmptyUtil.isEmpty((Object)ainfo.getAmount()) && ainfo.getAmount().compareTo(BigDecimal.ZERO) != 0) continue;
            throw new CasException(CasException.SUBMITERROR, new Object[]{info.getNumber(), ResourceBase.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"230_AgentPayBillEditUI", (Locale)ctx.getLocale())});
        }
        if (EmptyUtil.isEmpty((Object)info.getAmount()) || info.getAmount().compareTo(BigDecimal.ZERO) == 0) {
            throw new CasException(CasException.SUBMITERROR, new Object[]{info.getNumber(), ResourceBase.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"502_CASReceivingBillImportVerify", (Locale)ctx.getLocale())});
        }
        if (info.getEntrys().size() != info.getCount()) {
            throw new CasException(CasException.AGENTCOUNTNOTEQUAL);
        }
        this.fillBgItem(ctx, info);
        if (null != info.getId() && this._exists(ctx, (IObjectPK)new ObjectUuidPK(info.getId())) && (oldInfo = this.getAgentPayBillInfo(ctx, "select * where id='" + info.getId().toString() + "'")) != null) {
            FMBGHelper.signBgItemRelease((Context)ctx, (IObjectPK)new ObjectStringPK(oldInfo.getId().toString()));
            ObjectStringPK[] entryPks = new ObjectStringPK[oldInfo.getEntrys().size()];
            AgentPayBillEntryInfo entryInfo = null;
            String entryId = null;
            int n = oldInfo.getEntrys().size();
            for (int i = 0; i < n; ++i) {
                entryInfo = oldInfo.getEntrys().get(i);
                entryId = entryInfo.getId().toString();
                entryPks[i] = new ObjectStringPK(entryId);
            }
            FMBGHelper.signBgItemRelease((Context)ctx, (IObjectPK[])entryPks);
        }
        if (!EmptyUtil.isEmpty((CoreBaseInfo)info.getPayBankAccount())) {
            RecPayAcctBankStratageCtrl.acctBankBalanceCtrl(ctx, (IObjectValue)info);
        }
        oldInfo = null;
        if (null != info.getId() && AgentPayBillFactory.getLocalInstance(ctx).exists((IObjectPK)new ObjectUuidPK(info.getId()))) {
            oldInfo = AgentPayBillFactory.getLocalInstance(ctx).getAgentPayBillInfo((IObjectPK)new ObjectUuidPK(info.getId().toString()), this.getSelectorForLog());
        }
        if (dbillentrycoll != null) {
            this.disporse(ctx, info, dbillentrycoll, DisposerActionEnum.SUBMIT);
        } else {
            this.disporse(ctx, info, DisposerActionEnum.SUBMIT);
        }
        IObjectPK pk = super._submit(ctx, value);
        boolean CS127 = ContextHelperFactory.getLocalInstance((Context)ctx).getBooleanParam("CS127", (IObjectPK)new ObjectUuidPK(info.getCompany().getId()));
        if (CS127) {
            this.recordPayInfoLog(ctx, oldInfo, info, PaymentOperateType.SUBMIT);
        }
        if (StringUtils.isEmpty((String)(imageNumber = (image = BillImageFacadeFactory.getLocalInstance((Context)ctx)).getImageNumber(this.billBosType.toString(), pk.toString())))) {
            imageNumber = image.genImageNumber(this.billBosType.toString(), pk.toString());
        }
        AgentPayBillInfo sumbittedInfo = this.getAgentPayBillInfo(ctx, "select *, entries.* where id='" + pk.toString() + "'");
        FMBGHelper.signBgItemUsed((Context)ctx, (IObjectPK)pk, (IFMBgUsed)sumbittedInfo);
        HashMap<ObjectUuidPK, AgentPayBillEntryInfo> entryMap = new HashMap<ObjectUuidPK, AgentPayBillEntryInfo>();
        int n = sumbittedInfo.getEntrys().size();
        for (int i = 0; i < n; ++i) {
            AgentPayBillEntryInfo entryInfo = sumbittedInfo.getEntrys().get(i);
            ObjectUuidPK enPK = new ObjectUuidPK(entryInfo.getId());
            entryMap.put(enPK, entryInfo);
        }
        CashBgHelper.BatchSignBgItemUsed(ctx, entryMap);
        boolean CS108 = ContextHelperFactory.getLocalInstance((Context)ctx).getBooleanParam("CS108", (IObjectPK)new ObjectUuidPK(info.getCompany().getId()));
        if (CS108) {
            boolean isGenerateBill = false;
            if (!EmptyUtil.isEmpty((String)info.getSourceBillId()) && BOSUuid.read((String)info.getSourceBillId()).getType().equals((Object)new AgentPayBillInfo().getBOSType())) {
                SelectorItemCollection sic = new SelectorItemCollection();
                sic.add(new SelectorItemInfo("id"));
                sic.add(new SelectorItemInfo("isGenerateBill"));
                AgentPayBillInfo srcInfo = AgentPayBillFactory.getLocalInstance(ctx).getAgentPayBillInfo((IObjectPK)new ObjectUuidPK(info.getSourceBillId()), sic);
                if (srcInfo.isIsGenerateBill()) {
                    isGenerateBill = true;
                }
            }
            if (!isGenerateBill) {
                logger.info((Object)"-----------------\u8c03\u7528\u9884\u7b97\u6263\u51cf-----------------");
                this.bgCtrlAndAudit(ctx, pk);
            }
        }
        for (int i = 0; i < info.getEntrys().size(); ++i) {
            if (EmptyUtil.isEmpty((Object)info.getEntrys().get(i).get("RecBankAccount"))) continue;
            char[] chars_test2 = info.getEntrys().get(i).get("RecBankAccount").toString().toCharArray();
            for (int j = 0; j < chars_test2.length; ++j) {
                String temp = String.valueOf(chars_test2[j]);
                if (!temp.matches("[^\\x00-\\xff]")) continue;
                throw new CasException(CasException.RECACCT_CANNOT_FULL);
            }
        }
        IObjectPK pkOut = LogUtil.beginLog((Context)ctx, null, (BOSObjectType)info.getBOSType(), null, (String)info.getNumber(), (String)"cas_agentpaymentBill_batchSubmit");
        LogUtil.afterLog((Context)ctx, (IObjectPK)pkOut);
        return pk;
    }

    private boolean isStatusChanged(Context ctx, AgentPayBillInfo info) throws BOSException {
        IAgentPayBill iAgentPayBill = AgentPayBillFactory.getLocalInstance(ctx);
        boolean changed = false;
        AgentPayBillInfo agentPayBillInfo = null;
        AgentPayBillCollection coll = null;
        EntityViewInfo query = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        query.setFilter(filter);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("billStatus");
        sic.add("Fivouchered");
        query.setSelector(sic);
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)info.getId().toString()));
        coll = iAgentPayBill.getAgentPayBillCollection(query);
        if (coll.size() > 0) {
            agentPayBillInfo = coll.get(0);
            if (info.getBillStatus() != agentPayBillInfo.getBillStatus()) {
                changed = true;
            }
            if (info.isFivouchered() != agentPayBillInfo.isFivouchered()) {
                changed = true;
            }
        }
        return changed;
    }

    protected void bgCtrlAndAudit(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        RecPayHelper.bgCtrlAudit(ctx, pk.toString());
    }

    protected void fillBgItem(Context ctx, AgentPayBillInfo info) throws BOSException, EASBizException {
        FMBGHelper.fillBgItem((Context)ctx, (IFMBgUsed)info);
        IFMBgUsed[] entryInfoNumber = new IFMBgUsed[info.getEntrys().size()];
        int n = info.getEntrys().size();
        for (int i = 0; i < n; ++i) {
            entryInfoNumber[i] = info.getEntrys().get(i);
        }
        FMBGHelper.fillBgItem((Context)ctx, (IFMBgUsed[])entryInfoNumber);
    }

    protected IObjectPK _save(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        ICoreBase iCoreBase;
        AgentPayBillInfo info = (AgentPayBillInfo)model;
        boolean delFlag = false;
        if (info.getSourceBillId() != null && (iCoreBase = BizCollUtil.getBizInterfaceByBOSUuid((Context)ctx, (BOSUuid)BOSUuid.read((String)info.getSourceBillId().toString()))) != null && iCoreBase instanceof IBizCollBillBase) {
            delFlag = true;
        }
        AgentPayBillEntryCollection dbillentrycoll = null;
        if (delFlag) {
            AgentPayBillEntryCollection ebillentrycoll = info.getEntrys();
            ArrayList<String> elist = new ArrayList<String>();
            ArrayList dlist = new ArrayList();
            if (ebillentrycoll != null) {
                for (int i = 0; i < ebillentrycoll.size(); ++i) {
                    if (ebillentrycoll.get(i).getId() == null) continue;
                    elist.add(ebillentrycoll.get(i).getId().toString());
                }
                if (info.getId() != null) {
                    String billId = info.getId().toString();
                    EntityViewInfo View = new EntityViewInfo();
                    SelectorItemCollection Sic = new SelectorItemCollection();
                    Sic.add(new SelectorItemInfo("*"));
                    View.setSelector(Sic);
                    FilterInfo filter = new FilterInfo();
                    filter.getFilterItems().add(new FilterItemInfo("parent", (Object)billId, CompareType.EQUALS));
                    View.setFilter(filter);
                    dbillentrycoll = AgentPayBillEntryFactory.getLocalInstance(ctx).getAgentPayBillEntryCollection(View);
                    for (int i = 0; i < dbillentrycoll.size(); ++i) {
                        String pid = dbillentrycoll.get(i).getId().toString();
                        if (!elist.contains(pid)) continue;
                        dbillentrycoll.removeObject(i);
                    }
                }
            }
        }
        if (info.getBillStatus() == null || info.getBillStatus().equals((Object)BillStatusEnum.SAVE)) {
            info.setBillStatus(BillStatusEnum.SAVE);
        }
        if (info.getId() != null && this.isStatusChanged(ctx, info)) {
            throw new AgentPayBillException(AgentPayBillException.CHANGENOSAVE);
        }
        info.setBizDate(DateTimeUtils.truncateDate((Date)info.getBizDate()));
        AgentPayBillInfo oldInfo = null;
        if (null != info.getId() && AgentPayBillFactory.getLocalInstance(ctx).exists((IObjectPK)new ObjectUuidPK(info.getId()))) {
            oldInfo = AgentPayBillFactory.getLocalInstance(ctx).getAgentPayBillInfo((IObjectPK)new ObjectUuidPK(info.getId().toString()), this.getSelectorForLog());
        }
        IObjectPK pk = super._save(ctx, model);
        boolean CS127 = ContextHelperFactory.getLocalInstance((Context)ctx).getBooleanParam("CS127", (IObjectPK)new ObjectUuidPK(info.getCompany().getId()));
        if (CS127) {
            this.recordPayInfoLog(ctx, oldInfo, info, PaymentOperateType.SAVE);
        }
        if (dbillentrycoll != null) {
            this.disporse(ctx, info, dbillentrycoll, DisposerActionEnum.SAVE);
        } else {
            this.disporse(ctx, info, DisposerActionEnum.SAVE);
        }
        IObjectPK pkOut = LogUtil.beginLog((Context)ctx, null, (BOSObjectType)info.getBOSType(), null, (String)info.getNumber(), (String)"cas_agentpaymentBill_save");
        LogUtil.afterLog((Context)ctx, (IObjectPK)pkOut);
        return pk;
    }

    @Override
    protected Map _saveBatch(Context ctx, List idList) throws BOSException, EASBizException {
        AgentPayBillCollection agentPayBillCol = this.getAgentPayBillCollection(ctx, this.getEntityViewByIDList(idList));
        int size = agentPayBillCol.size();
        AgentPayBillInfo info = null;
        for (int i = 0; i < size; ++i) {
            info = agentPayBillCol.get(i);
            if (info.getBillStatus() != BillStatusEnum.SAVE && info.getBillStatus() != BillStatusEnum.SUBMIT) continue;
            info.setBillStatus(BillStatusEnum.SUBMIT);
            this.submit(ctx, (CoreBaseInfo)info);
        }
        return null;
    }

    private EntityViewInfo getEntityViewByIDList(List idList) {
        EntityViewInfo env = new EntityViewInfo();
        FilterInfo f = new FilterInfo();
        HashSet idSet = new HashSet();
        idSet.addAll(idList);
        f.getFilterItems().add(new FilterItemInfo("id", idSet, CompareType.INCLUDE));
        env.setFilter(f);
        return env;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        block10: {
            AgentPayBillInfo info = (AgentPayBillInfo)this.getValue(ctx, (IObjectPK)new ObjectStringPK(pk.toString()));
            IMutexServiceControl iMutex = MutexServiceControlFactory.getLocalInstance((Context)ctx);
            boolean isLock = false;
            try {
                isLock = iMutex.requestObjIDForUpdate(pk.toString());
                if (!isLock) {
                    throw new RecPayException(RecPayException.COMMON, new Object[]{ResourceBase.getString((String)"com.kingdee.eas.fi.cas.web.CasWebResource", (String)"HAS_LOCKED", (Locale)ctx.getLocale())});
                }
                if (info.isIsGenerateBill()) {
                    throw new RecPayException(RecPayException.NOTALLOW_DELGENPAYBILL);
                }
                if (info.getBillStatus().getValue() < 12) {
                    FMBGHelper.signBgItemRelease((Context)ctx, (IObjectPK)pk);
                    ObjectStringPK[] entryPks = new ObjectStringPK[info.getEntrys().size()];
                    AgentPayBillEntryInfo entryInfo = null;
                    String entryId = null;
                    int n = info.getEntrys().size();
                    for (int i = 0; i < n; ++i) {
                        entryInfo = info.getEntrys().get(i);
                        entryId = entryInfo.getId().toString();
                        entryPks[i] = new ObjectStringPK(entryId);
                    }
                    FMBGHelper.signBgItemRelease((Context)ctx, (IObjectPK[])entryPks);
                    IBgControlFacade iBgCtrlFacade = BgControlFacadeFactory.getLocalInstance((Context)ctx);
                    BgControlCaller caller = new BgControlCaller();
                    caller.returnBudget(ctx, BOSUuid.read((String)pk.toString()));
                    iBgCtrlFacade.cancelRequestBudget(pk.toString());
                    this.disporse(ctx, info, DisposerActionEnum.DELETE);
                    super._delete(ctx, pk);
                    this.disporse(ctx, info, DisposerActionEnum.DELETE);
                    if (info.isIsCBPay()) {
                        DbUtil.execute((Context)ctx, (String)("delete from t_cbs_cbpayment where fpaymentbillid = '" + pk.toString() + "'"));
                    }
                    if (info.getSourceBillId() != null && BOSUuid.read((String)info.getSourceBillId()).getType().equals((Object)new AgentPayBillInfo().getBOSType())) {
                        String sql = "Update T_CAS_AgentPayBill Set FIsGenerateBill = 0 where FIsGenerateBill = 1 and Fid= ?";
                        DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{info.getSourceBillId()});
                    }
                    break block10;
                }
                throw new AgentPayBillException(AgentPayBillException.CANNOTDELETE);
            }
            finally {
                if (isLock) {
                    iMutex.releaseObjIDForUpdate(pk.toString());
                }
            }
        }
    }

    @Override
    protected void _antiAudit(Context ctx, Set idSet) throws BOSException, EASBizException {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)idSet, CompareType.INCLUDE));
        view.setFilter(filter);
        CoreBaseCollection colls = AgentPayBillFactory.getLocalInstance(ctx).getCollection(view);
        for (int i = 0; i < colls.size(); ++i) {
            AgentPayBillInfo info = (AgentPayBillInfo)colls.get(i);
            this.antiAuditWF(ctx, info.getId());
        }
    }

    @Override
    protected void _audit(Context ctx, Set idSet) throws BOSException, EASBizException {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)idSet, CompareType.INCLUDE));
        view.setFilter(filter);
        CoreBaseCollection colls = AgentPayBillFactory.getLocalInstance(ctx).getCollection(view);
        for (int i = 0; i < colls.size(); ++i) {
            AgentPayBillInfo info = (AgentPayBillInfo)colls.get(i);
            if (info.getBillStatus().equals((Object)BillStatusEnum.AUDITED)) continue;
            if (!info.getBillStatus().equals((Object)BillStatusEnum.SUBMIT)) {
                throw new AgentPayBillException(AgentPayBillException.CANNOTAUDIT, new Object[]{info.getNumber()});
            }
            info.setBillStatus(BillStatusEnum.AUDITED);
            info.setAuditor(ContextUtil.getCurrentUserInfo((Context)ctx));
            info.setAuditDate(DateHelper.getDayBegin());
            this.disporse(ctx, info, DisposerActionEnum.AUDIT);
            IObjectPK pkOut = LogUtil.beginLog((Context)ctx, null, (BOSObjectType)info.getBOSType(), null, (String)info.getNumber(), (String)"cas_agentpaymentBill_audit");
            LogUtil.afterLog((Context)ctx, (IObjectPK)pkOut);
        }
        if (colls.size() > 0) {
            super.update(ctx, colls);
        }
    }

    private void checkGetVersion(Context ctx) throws FMException {
        String strValue = ContextHelperFactory.getLocalInstance((Context)ctx).getStringParam("TM018", (IObjectPK)new ObjectUuidPK(ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentCompany().getId().toString()));
        if (strValue == null || "1".equals(strValue)) {
            return;
        }
        try {
            BankFacadeFactory.getLocalInstance((Context)ctx).getVersion();
        }
        catch (Exception e1) {
            throw new FMException(FMException.COMMMONEXCEPTION, new Object[]{ErrCodeHelper.getResourceByErrCode((String)"BE1002", (String)e1.getMessage())});
        }
    }

    @Override
    protected Set _commitToBE(Context ctx, Set idSet) throws BOSException, EASBizException {
        this.checkGetVersion(ctx);
        if (idSet.size() > 1) {
            throw new BEException(BEException.NOTALLOWBATCHSUBMIT);
        }
        AgentPayBillCollection payColl = this.checkIdIsValid(ctx, idSet);
        IBankAgentPayBill iBankAgentPayBill = BankAgentPayBillFactory.getLocalInstance((Context)ctx);
        this.checkEntryAmount(ctx, idSet);
        this.afterCommitToBe(ctx, idSet);
        String ids = FMHelper.setTran2String((Set)idSet);
        UserInfo userInfo = ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentUser();
        String sql = "UPDATE T_CAS_AgentPayBill SET FCashierID = ?, FBillStatus = ?,FActualAmount = FAmount, FActualCount = FCount WHERE FID IN " + ids;
        Integer status = new Integer(15);
        DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{userInfo.getId().toString(), status});
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("sourceBillId", (Object)idSet, CompareType.INCLUDE));
        filter.getFilterItems().add(new FilterItemInfo("isBitBack", (Object)false));
        if (iBankAgentPayBill.exists(filter)) {
            throw new BEException(BEException.BANKAGENT_NO_REPEAT);
        }
        this.helper.bookPaymentBill(ctx, AgentPayBillBookNotifyBuilder.class.getName(), idSet);
        this.reverseBill(ctx, idSet, true, true);
        String builderName = payColl.get(0).isIsCBPay() ? "com.kingdee.eas.fm.cbs.CBBankAgentPayBillBuilder" : BankAgentPayBillBuilder.class.getName();
        IObjectPK bankAgentPayBillId = null;
        HashSet<IObjectPK> bankAgentPayBillSet = new HashSet<IObjectPK>();
        int size = payColl.size();
        for (int i = 0; i < size; ++i) {
            AgentPayBillInfo payInfo = payColl.get(i);
            String billId = payInfo.getId().toString();
            bankAgentPayBillId = iBankAgentPayBill.commitBankAgentPayBill(billId, builderName);
            bankAgentPayBillSet.add(bankAgentPayBillId);
            IObjectPK pkOut = LogUtil.beginLog((Context)ctx, null, (BOSObjectType)payInfo.getBOSType(), null, (String)payInfo.getNumber(), (String)"cas_agentpaymentBill_commitBe");
            LogUtil.afterLog((Context)ctx, (IObjectPK)pkOut);
        }
        for (String billId : idSet) {
            this.commitToBeWF(ctx, (IObjectPK)new ObjectUuidPK(billId));
        }
        return bankAgentPayBillSet;
    }

    @Override
    protected void _commitToBeAll(Context ctx, Set idSet, Set bankPayingbillIdSet) throws BOSException, EASBizException {
        IBankAgentPayBill iBankAgentPayBill = BankAgentPayBillFactory.getLocalInstance((Context)ctx);
        Iterator iterator = bankPayingbillIdSet.iterator();
        while (iterator.hasNext()) {
            try {
                iBankAgentPayBill.commitToBeAll((IObjectPK)iterator.next());
            }
            catch (BEException ex) {
                logger.error((Object)"summit to ebGateWay failure! exception message is:", (Throwable)ex);
                this.reverseSaveForAgentPayBill(ctx, idSet);
                throw new BEException(BEException.COMMON, new Object[]{ex.getMessage()});
            }
        }
    }

    private void reverseSaveForAgentPayBill(Context ctx, Set idSet) throws BOSException, BTPException {
        Set destSet = FMHelper.getDestBillIdSet((Context)ctx, (String)((String)idSet.iterator().next()));
        if (destSet.size() > 0) {
            IBOTRelation iBotRelation = BOTRelationFactory.getLocalInstance((Context)ctx);
            iBotRelation.removeRelationByDestObjId((String)destSet.iterator().next(), new AgentPayBillInfo().getBOSType().toString());
        }
        String ids = FMHelper.setTran2String((Set)idSet);
        Integer status = new Integer(12);
        String sql = "UPDATE T_CAS_AgentPayBill SET FCashierID = ?, FBillStatus = ?, FisCommitToBe = 0 WHERE FID IN " + ids;
        DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{"", status});
        String sqlRev = "Update T_CAS_AgentPayBillEntry set fissuccess = 0,FState = 0,FBankReturnInfo = '' where FPARENTID in " + ids;
        DbUtil.execute((Context)ctx, (String)sqlRev);
        for (String id : idSet) {
            BOTRelationFactory.getLocalInstance((Context)ctx).removeRelationBySrcObjId(id, new BankAgentPayBillInfo().getBOSType().toString());
        }
    }

    @Override
    protected Map _registerJournal(Context ctx, Set idSet) throws BOSException, EASBizException {
        String ids = FMHelper.setTran2String((Set)idSet);
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        String validId = "";
        HashSet<String> validSet = new HashSet<String>();
        HashSet idSetForSqlNoJournalFinal = new HashSet();
        String sqlAmountNotEquals = "select ap.fid as agentpaybillid from T_CAS_AGENTPAYBILL ap LEFT JOIN T_CAS_JOURNAL j ON ap.fid=j.fbillid where ap.factualamount <> 0 and ap.factualamount <> j.fcreditamount and ap.fid in" + ids;
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        Iterator itForIdSet = null;
        try {
            conn = this.getConnection(ctx);
            pstmt = conn.prepareStatement(sqlAmountNotEquals);
            rs = pstmt.executeQuery();
            while (rs.next()) {
                validId = rs.getString("agentpaybillid");
                validSet.add(validId);
                idSet.remove(validId);
            }
            ids = FMHelper.setTran2String((Set)idSet);
            String sqlNoJournal = "select fbillid from T_CAS_JOURNAL WHERE fbilltype=40 and fbillid in " + ids;
            pstmt = conn.prepareStatement(sqlNoJournal);
            rs = pstmt.executeQuery();
            itForIdSet = idSet.iterator();
            while (itForIdSet.hasNext()) {
                idSetForSqlNoJournalFinal.add(itForIdSet.next());
            }
            while (rs.next()) {
                validId = rs.getString("fbillid");
                idSetForSqlNoJournalFinal.remove(validId);
            }
            ids = FMHelper.setTran2String(idSetForSqlNoJournalFinal);
            String sqlNoJournalFinal = "select fid from T_CAS_AGENTPAYBILL where factualamount <> 0 and fid in" + ids;
            pstmt = conn.prepareStatement(sqlNoJournalFinal);
            rs = pstmt.executeQuery();
            while (rs.next()) {
                validId = rs.getString("fid");
                validSet.add(validId);
                idSet.remove(validId);
            }
        }
        catch (SQLException e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)pstmt, (Connection)conn);
        String validIds = FMHelper.setTran2String(validSet);
        String sql = "DELETE from T_CAS_JOURNAL where FBILLTYPE = 40 AND FBILLID IN " + validIds;
        DbUtil.execute((Context)ctx, (String)sql);
        this.helper.bookPaymentBill(ctx, AgentPayBillBookNotifyBuilder.class.getName(), validSet);
        String successNumbers = "";
        String failedNumbers = "";
        if (validSet.size() != 0) {
            successNumbers = this.getAgentPayBillNumbers(ctx, validSet);
            failedNumbers = this.getAgentPayBillNumbers(ctx, idSet);
        }
        resultMap.put("successNumbers", successNumbers);
        resultMap.put("failedNumbers", failedNumbers);
        resultMap.put("successSize", new Integer(validSet.size()));
        resultMap.put("failedSize", new Integer(idSet.size()));
        return resultMap;
    }

    private String getAgentPayBillNumbers(Context ctx, Set idSet) throws BOSException, EASBizException {
        String ids = FMHelper.setTran2String((Set)idSet);
        String sql = "select FNumber from T_CAS_AGENTPAYBILL where fid in " + ids;
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        StringBuffer sb = new StringBuffer();
        try {
            conn = this.getConnection(ctx);
            pstmt = conn.prepareStatement(sql);
            rs = pstmt.executeQuery();
            BOSObjectType bosType = new AgentPayBillInfo().getBOSType();
            while (rs.next()) {
                sb.append(rs.getString("Fnumber")).append(",");
                IObjectPK pkOut = LogUtil.beginLog((Context)ctx, null, (BOSObjectType)bosType, null, (String)rs.getString("Fnumber"), (String)"cas_agentpaymentbill_journal");
                LogUtil.afterLog((Context)ctx, (IObjectPK)pkOut);
            }
        }
        catch (SQLException e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)pstmt, (Connection)conn);
        return sb.toString();
    }

    @Override
    protected void _pay(Context ctx, Set idSet) throws BOSException, EASBizException {
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)idSet, CompareType.INCLUDE));
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(filter);
        IAgentPayBill iAgentPayBill = AgentPayBillFactory.getLocalInstance(ctx);
        AgentPayBillCollection coll = iAgentPayBill.getAgentPayBillCollection(evi);
        int size = coll.size();
        for (int i = 0; i < size; ++i) {
            AgentPayBillInfo info = coll.get(i);
            if (info.getBillStatus().equals((Object)BillStatusEnum.AUDITED)) continue;
            throw new AgentPayBillException(AgentPayBillException.CANSUBMITPAY);
        }
        String ids = FMHelper.setTran2String((Set)idSet);
        UserInfo userInfo = ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentUser();
        String sql = "UPDATE T_CAS_AgentPayBill SET FCashierID = ?, FBillStatus = ? WHERE FID IN " + ids;
        Integer status = new Integer(15);
        DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{userInfo.getId().toString(), status});
        this.reverseBill(ctx, idSet, true, false);
        for (String id : idSet) {
            HashSet<String> idsSet = new HashSet<String>();
            idsSet.add(id);
            this.helper.bookPaymentBill(ctx, AgentPayBillBookNotifyBuilder.class.getName(), idsSet);
            this.payWF(ctx, (IObjectPK)new ObjectUuidPK(id));
        }
    }

    private void afterCommitToBe(Context ctx, Set idSet) throws BOSException {
        String ids = FMHelper.setTran2String((Set)idSet);
        String sql = "UPDATE T_CAS_AgentPayBill SET  FIsCommittoBe = 1 WHERE FID IN " + ids;
        DbUtil.execute((Context)ctx, (String)sql);
    }

    @Override
    protected void _cancelPay(Context ctx, Set idSet) throws BOSException, EASBizException {
        EntityViewInfo idview = new EntityViewInfo();
        FilterInfo idfilter = new FilterInfo();
        idview.setFilter(idfilter);
        idfilter.getFilterItems().add(new FilterItemInfo("id", (Object)idSet, CompareType.INCLUDE));
        AgentPayBillCollection agentPayBillColl = AgentPayBillFactory.getLocalInstance(ctx).getAgentPayBillCollection(idview);
        for (int idseq = 0; idseq < agentPayBillColl.size(); ++idseq) {
            AgentPayBillInfo info = agentPayBillColl.get(idseq);
            String billId = info.getId().toString();
            IBOTRelation iBotRelation = BOTRelationFactory.getLocalInstance((Context)ctx);
            BOSObjectType destType = new BankAgentPayBillInfo().getBOSType();
            ArrayList destIds = iBotRelation.getDestObjIdByDestType(info.getId().toString(), destType.toString());
            if (!info.getBillStatus().equals((Object)BillStatusEnum.PAYED)) {
                throw new AgentPayBillException(AgentPayBillException.CANNOTCANCELPAY);
            }
            if (destIds != null && !destIds.isEmpty()) {
                throw new BEException(BEException.COMMON, (Object[])new String[]{ResourceBase.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"7_AgentPayBillControllerBean", (Locale)ctx.getLocale()) + info.getNumber() + ResourceBase.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"8_AgentPayBillControllerBean", (Locale)ctx.getLocale())});
            }
            if (info.isFivouchered()) {
                throw new BEException(BEException.COMMON, (Object[])new String[]{ResourceBase.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"7_AgentPayBillControllerBean", (Locale)ctx.getLocale()) + info.getNumber() + ResourceBase.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"9_AgentPayBillControllerBean", (Locale)ctx.getLocale())});
            }
            if (info.isPcaVouchered()) {
                throw new BEException(BEException.COMMON, (Object[])new String[]{ResourceBase.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"7_AgentPayBillControllerBean", (Locale)ctx.getLocale()) + info.getNumber() + ResourceBase.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"534_AgentPayBillControllerBean", (Locale)ctx.getLocale())});
            }
            String sql = "UPDATE T_CAS_AgentPayBill SET FCashierID = null,FIsCommittoBe=0, FBillStatus = ? WHERE FID = ?";
            Integer status = new Integer(12);
            DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{status, info.getId().toString()});
            HashSet<String> idsSet = new HashSet<String>();
            idsSet.add(info.getId().toString());
            this.reverseBill(ctx, idsSet, false, false);
            BookNotifyFacadeFactory.getLocalInstance(ctx).batchAntiBook(idsSet);
            this.cancelPayWF(ctx, (IObjectPK)new ObjectUuidPK(info.getId().toString()));
        }
    }

    private AgentPayBillCollection checkIdIsValid(Context ctx, Set idSet) throws EASBizException, BOSException {
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)idSet, CompareType.INCLUDE));
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(filter);
        evi.getSelector().add("*");
        evi.getSelector().add("PayBankAccount.isSetBankInterface");
        evi.getSelector().add("OppAccount.*");
        evi.getSelector().add("company.*");
        evi.getSelector().add("SettlementType.payThroughBE");
        evi.getSelector().add("PayBankAccount.bankInterfaceType");
        IAgentPayBill iAgentPayBill = AgentPayBillFactory.getLocalInstance(ctx);
        AgentPayBillCollection coll = iAgentPayBill.getAgentPayBillCollection(evi);
        int size = coll.size();
        for (int i = 0; i < size; ++i) {
            AgentPayBillInfo info = coll.get(i);
            if (EmptyUtil.isEmpty((CoreBaseInfo)info.getPayBankAccount())) {
                throw new BEException(BEException.COMMON, new Object[]{ResourceBase.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"10_AgentPayBillControllerBean", (Locale)ctx.getLocale())});
            }
            if (!info.getPayBankAccount().isIsSetBankInterface()) {
                throw new BEException(BEException.COMMON, new Object[]{ResourceBase.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"533_AgentPayBillControllerBean", (Locale)ctx.getLocale())});
            }
            if (!info.getBillStatus().equals((Object)BillStatusEnum.AUDITED)) {
                throw new AgentPayBillException(AgentPayBillException.CANNOTCOMMITTOBE);
            }
            if (EmptyUtil.isEmpty((String)info.getUsage())) {
                throw new BEException(BEException.COMMON, new Object[]{ResourceBase.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"11_AgentPayBillControllerBean", (Locale)ctx.getLocale())});
            }
            if (EmptyUtil.isEmpty((CoreBaseInfo)info.getSettlementType())) {
                throw new BEException(BEException.COMMON, new Object[]{ResourceBase.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"12_AgentPayBillControllerBean", (Locale)ctx.getLocale())});
            }
            if (!info.getSettlementType().isPayThroughBE()) {
                throw new BEException(BEException.COMMON, new Object[]{ResourceBase.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"13_AgentPayBillControllerBean", (Locale)ctx.getLocale())});
            }
            if (info.getPayerAccount() != null) {
                RecPayHelper.checkAcctViewIsValid(ctx, info.getNumber(), info.getCompany(), info.getPayerAccount());
            }
            if (info.getOppAccount() == null) continue;
            RecPayHelper.checkAcctViewIsValid(ctx, info.getNumber(), info.getCompany(), info.getOppAccount());
        }
        return coll;
    }

    private void checkEntryAmount(Context ctx, Set idSet) throws EASBizException, BOSException {
        FilterInfo eFilter = new FilterInfo();
        eFilter.getFilterItems().add(new FilterItemInfo("parent.id", (Object)idSet, CompareType.INCLUDE));
        EntityViewInfo eEvi = new EntityViewInfo();
        eEvi.setFilter(eFilter);
        eEvi.getSelector().add("amount");
        IAgentPayBillEntry iAgentPayBillEntry = AgentPayBillEntryFactory.getLocalInstance(ctx);
        AgentPayBillEntryCollection eColl = iAgentPayBillEntry.getAgentPayBillEntryCollection(eEvi);
        for (int i = 0; i < eColl.size(); ++i) {
            AgentPayBillEntryInfo info = eColl.get(i);
            BigDecimal amount = info.getAmount();
            if (info.getAmount().compareTo(Constants.ZERO) >= 0) continue;
            throw new FMException(FMException.MUSTMORETHANZERO, new Object[]{ResourceBase.getString((String)"com.kingdee.eas.fi.cas.CASAutoResource", (String)"19_AgentPayBillControllerBean", (Locale)ctx.getLocale())});
        }
    }

    private void reverseBill(Context ctx, Set idSet, boolean isPay, boolean isCommitToBE) throws EASBizException, BOSException {
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)idSet, CompareType.INCLUDE));
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(filter);
        IAgentPayBill iAgentPayBill = AgentPayBillFactory.getLocalInstance(ctx);
        IAgentPayBillEntry iAgentPayBillEntry = AgentPayBillEntryFactory.getLocalInstance(ctx);
        SelectorItemCollection sicForBill = new SelectorItemCollection();
        sicForBill.add(new SelectorItemInfo("ActualAmount"));
        sicForBill.add(new SelectorItemInfo("ActualCount"));
        SelectorItemCollection sicForEntry = new SelectorItemCollection();
        sicForEntry.add(new SelectorItemInfo("isSuccess"));
        sicForEntry.add(new SelectorItemInfo("state"));
        sicForEntry.add(new SelectorItemInfo("bankReturnInfo"));
        AgentPayBillCollection coll = iAgentPayBill.getAgentPayBillCollection(evi);
        int size = coll.size();
        for (int i = 0; i < size; ++i) {
            AgentPayBillInfo info = coll.get(i);
            DisposerActionEnum disposerActionEnum = DisposerActionEnum.PAY;
            if (isPay) {
                info.setActualAmount(info.getAmount());
                info.setActualCount(info.getCount());
            } else {
                info.setActualAmount(Constants.ZERO);
                info.setActualCount(0);
                disposerActionEnum = DisposerActionEnum.CANCEL_PAY;
            }
            for (int j = 0; j < info.getEntrys().size(); ++j) {
                if (isPay) {
                    info.getEntrys().get(j).setIsSuccess(true);
                    if (!isCommitToBE) continue;
                    info.getEntrys().get(j).setState(BankPayingBillStateEnum.OS);
                    continue;
                }
                info.getEntrys().get(j).setIsSuccess(false);
                info.getEntrys().get(j).setState(BankPayingBillStateEnum.DE);
                info.getEntrys().get(j).setBankReturnInfo(null);
            }
            iAgentPayBillEntry.updatePartialBatchData((IObjectCollection)info.getEntrys(), sicForEntry);
            iAgentPayBill.updatePartial((CoreBaseInfo)info, sicForBill);
            this.disporse(ctx, info, disposerActionEnum);
        }
    }

    private void disporse(Context ctx, AgentPayBillInfo info, DisposerActionEnum disposerActionEnum) throws EASBizException, BOSException {
        BillDisposerAction disposerAction = new BillDisposerAction();
        disposerAction.setDestBill((CoreBaseInfo)info);
        disposerAction.setActionType(disposerActionEnum);
        IPaymentDisposer disposer = AgentPayBillDisposerFactory.getDisposer(ctx, info);
        if (disposer != null) {
            disposer.dispose(ctx, disposerAction);
        }
    }

    private void disporse(Context ctx, AgentPayBillInfo info, AgentPayBillEntryCollection dbillentrycoll, DisposerActionEnum disposerActionEnum) throws EASBizException, BOSException {
        BillDisposerAction disposerAction = new BillDisposerAction();
        disposerAction.setDestBill((CoreBaseInfo)info);
        disposerAction.setActionType(disposerActionEnum);
        disposerAction.setDeleteEntry((AbstractObjectCollection)dbillentrycoll);
        IPaymentDisposer disposer = AgentPayBillDisposerFactory.getDisposer(ctx, info);
        if (disposer != null) {
            disposer.dispose(ctx, disposerAction);
        }
    }

    protected void _reverseSave(Context ctx, IObjectPK srcBillPK, IObjectValue srcBillVO, BOTBillOperStateEnum bOTBillOperStateEnum, IObjectValue bOTRelationInfo) throws BOSException, EASBizException {
        BOTRelationInfo botRelation = (BOTRelationInfo)bOTRelationInfo;
        AgentPayBillInfo info = (AgentPayBillInfo)srcBillVO;
        if (new VoucherInfo().getBOSType().toString().equals(botRelation.getDestEntityID())) {
            if (BOTBillOperStateEnum.DELETE.equals((Object)bOTBillOperStateEnum)) {
                info.setFivouchered(false);
                info.setPcaVouchered(false);
                info.setAccountant(null);
                info.setVoucherId(null);
                info.setVoucherNumber(null);
            } else {
                VoucherInfo voucherBaseInfo = (VoucherInfo)VoucherFactory.getLocalInstance((Context)ctx).getObjectBaseInfo((IObjectPK)new ObjectUuidPK(botRelation.getDestObjectID()));
                info.setVoucherId(voucherBaseInfo);
                info.setVoucherNumber(voucherBaseInfo.getNumber());
                UserInfo userInfo = ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentUser();
                info.setAccountant(userInfo);
                info.setFivouchered(true);
                info.setPcaVouchered(true);
            }
        }
        if (new PcVoucherInfo().getBOSType().toString().equals(botRelation.getDestEntityID())) {
            if (BOTBillOperStateEnum.DELETE.equals((Object)bOTBillOperStateEnum)) {
                info.setPcaVouchered(false);
            } else if (BOTBillOperStateEnum.ADDNEW.equals((Object)bOTBillOperStateEnum)) {
                info.setPcaVouchered(true);
            }
        }
        super._reverseSave(ctx, srcBillPK, (IObjectValue)info, bOTBillOperStateEnum, bOTRelationInfo);
    }

    @Override
    protected void _auditWF(Context ctx, BOSUuid id) throws BOSException, EASBizException {
        HashSet<String> ids = new HashSet<String>();
        ids.add(id.toString());
        this._audit(ctx, ids);
    }

    @Override
    protected void _antiAuditWF(Context ctx, BOSUuid id) throws BOSException, EASBizException {
        HashSet<String> ids = new HashSet<String>();
        ids.add(id.toString());
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", ids, CompareType.INCLUDE));
        view.setFilter(filter);
        CoreBaseCollection colls = AgentPayBillFactory.getLocalInstance(ctx).getCollection(view);
        for (int i = 0; i < colls.size(); ++i) {
            AgentPayBillInfo info = (AgentPayBillInfo)colls.get(i);
            if (!info.getBillStatus().equals((Object)BillStatusEnum.AUDITED)) {
                throw new RecPayException(RecPayException.HASNOT_VALID_LISTS);
            }
            info.setBillStatus(BillStatusEnum.SAVE);
            info.setAuditor(null);
            info.setAuditDate(null);
            this.disporse(ctx, info, DisposerActionEnum.ANTI_AUDIT);
            IObjectPK pkOut = LogUtil.beginLog((Context)ctx, null, (BOSObjectType)info.getBOSType(), null, (String)info.getNumber(), (String)"cas_agentpaymentBill_antiaudit");
            LogUtil.afterLog((Context)ctx, (IObjectPK)pkOut);
            boolean CS108 = ContextHelperFactory.getLocalInstance((Context)ctx).getBooleanParam("CS108", (IObjectPK)new ObjectUuidPK(info.getCompany().getId()));
            if (!CS108) continue;
            logger.info((Object)"-----------------\u8c03\u7528\u9884\u7b97\u6263\u51cf-----------------");
            IBgControlFacade iBgCtrlFacade = BgControlFacadeFactory.getLocalInstance((Context)ctx);
            BgControlCaller caller = new BgControlCaller();
            caller.returnBudget(ctx, BOSUuid.read((String)info.getId().toString()));
            iBgCtrlFacade.cancelRequestBudget(new ObjectUuidPK(info.getId()).toString());
        }
        super.update(ctx, colls);
    }

    @Override
    protected void _commitToBeWF(Context ctx, IObjectPK id) throws BOSException, EASBizException {
    }

    @Override
    protected void _payWF(Context ctx, IObjectPK id) throws BOSException, EASBizException {
    }

    @Override
    protected void _cancelPayWF(Context ctx, IObjectPK id) throws BOSException, EASBizException {
    }

    public Map _getSumInfo(Context ctx, String filter, String selectedIds) throws BOSException, EASBizException {
        ICasUtilFacade casUtil = CasUtilFacadeFactory.getLocalInstance(ctx);
        CompanyOrgUnitCollection orgUnitCollection = casUtil.getAuthrizedCompanyOrg(ctx.getCaller().toString(), "cas_paymentbill_01view", false);
        StringBuffer where = new StringBuffer("company.id in ('NE',");
        for (int i = 0; i < orgUnitCollection.size(); ++i) {
            where.append("'" + orgUnitCollection.get(i).getId().toString() + "',");
        }
        where.deleteCharAt(where.length() - 1);
        where.append(")");
        filter = filter == null || filter.equals("") ? where.toString() : filter + " AND " + where.toString();
        IQueryExecutor queryExecutor = QueryExecutorFactory.getLocalInstance((Context)ctx, (IMetaDataPK)new MetaDataPK("com.kingdee.eas.fi.cas.CasPaymentBillSumQuery"));
        queryExecutor.setObjectView("SELECT billCount,moneySum where " + filter);
        logger.info((Object)("Paymentbill SumInfo SQL: " + queryExecutor.getSQL()));
        IRowSet rowSet = queryExecutor.executeQuery();
        HashMap<String, Object> result = new HashMap<String, Object>();
        try {
            rowSet.next();
            result.put("billCount", rowSet.getBigDecimal("billCount"));
            result.put("moneySum", rowSet.getBigDecimal("moneySum"));
            result.put("error", 0);
        }
        catch (Exception e) {
            result.put("error", 1);
            result.put("msg", e.getMessage());
            e.printStackTrace();
        }
        StringBuffer validIdSql = new StringBuffer("SELECT id where " + filter + " and id in('NE'");
        ArrayList<String> validIdList = new ArrayList<String>();
        if (!selectedIds.equals("")) {
            String[] idArr = selectedIds.split(",");
            for (int i = 0; i < idArr.length; ++i) {
                validIdSql.append(",'" + idArr[i] + "'");
            }
            validIdSql.append(")");
            queryExecutor = QueryExecutorFactory.getLocalInstance((Context)ctx, (IMetaDataPK)new MetaDataPK("com.kingdee.eas.fi.cas.PaymentBillWebQuery"));
            queryExecutor.setObjectView(validIdSql.toString());
            rowSet = queryExecutor.executeQuery();
            try {
                while (rowSet.next()) {
                    validIdList.add(rowSet.getString("id"));
                }
            }
            catch (Exception e) {
                result.put("error", 1);
                result.put("msg", e.getMessage());
                e.printStackTrace();
            }
        }
        result.put("validIdList", validIdList);
        return result;
    }

    public String getAppSolutionID(Context ctx, IObjectPK id, IObjectValue model, String type) throws BOSException, EASBizException {
        String appSolutionID = null;
        AgentPayBillInfo info = null;
        if (model != null) {
            info = (AgentPayBillInfo)model;
        } else if (id != null) {
            info = (AgentPayBillInfo)this.getValue(ctx, id);
        }
        if (info != null) {
            appSolutionID = info.isIsCBPay() ? "c6oAAAB/cQs7dcWQ" : "e74AAAAYH8o7dcWQ";
        }
        return appSolutionID;
    }

    @Override
    protected List _getBEBanksToSHR(Context ctx, String province, String city, String BankName) throws BOSException, EASBizException {
        ArrayList BEBanks = new ArrayList();
        if (EmptyUtil.isEmpty((String)province) || EmptyUtil.isEmpty((String)city) || EmptyUtil.isEmpty((String)BankName)) {
            logger.error((Object)"province city or BankName is null by SHR _getBeBanksToSHR");
            return BEBanks;
        }
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("BeProvince", (Object)province, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("BeCity", (Object)city, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("name", (Object)BankName, CompareType.LIKE));
        view.setFilter(filter);
        BEBankCollection coll = BEBankFactory.getLocalInstance((Context)ctx).getBEBankCollection(view);
        if (coll == null || coll.size() == 0) {
            return BEBanks;
        }
        for (int i = 0; i < coll.size(); ++i) {
            HashMap<String, String> BEBank = new HashMap<String, String>();
            BEBankInfo beBankInfo = coll.get(i);
            BEBank.put("bankName", beBankInfo.getName());
            BEBank.put("bankNumber", beBankInfo.getNumber());
            BEBank.put("BeProvince", beBankInfo.getBeProvince());
            BEBank.put("BeCity", beBankInfo.getBeCity());
            BEBank.put("Adress", beBankInfo.getAdress());
            BEBank.put("description", beBankInfo.getDescription());
            BEBanks.add(BEBank);
        }
        return BEBanks;
    }

    @Override
    protected void _notifyBankAgentPayStateChange(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        try {
            AgentPayBillInfo info = (AgentPayBillInfo)this._getValue(ctx, pk);
            this.disporse(ctx, info, DisposerActionEnum.AgentPayBankStateChange);
        }
        catch (Exception e) {
            logger.error((Object)("\u4ee3\u53d1\u5355\u53cd\u5199\u5931\u8d25 \u53cd\u5199\u7c7b\u578b:12\u4ee3\u53d1\u5355\u5355\u636eID:" + pk.toString()));
        }
    }

    @Override
    protected Map _getPersonBySHR(Context ctx, String personId) throws BOSException, EASBizException {
        String SHRAPIClass = "com.kingdee.shr.compensation.agentpay.SHRCmpAgentPayBillApi";
        String MethodNmae = "getCmpEmpAccount";
        try {
            Class<?> SHRAPI = Class.forName(SHRAPIClass);
            Method method = SHRAPI.getMethod(MethodNmae, ctx.getClass(), String.class);
            Object result = method.invoke((Object)ctx, personId);
            if (result != null) {
                return (Map)result;
            }
            return null;
        }
        catch (ClassNotFoundException e) {
            logger.error((Object)("\u6ca1\u6709\u627e\u5230SHRAPI\u7c7b\uff1a" + SHRAPIClass));
            e.printStackTrace();
        }
        catch (SecurityException e) {
            logger.error((Object)("SecurityException \u7c7b\uff1a" + SHRAPIClass + " \u65b9\u6cd5\u540d\uff1a" + MethodNmae));
            e.printStackTrace();
        }
        catch (NoSuchMethodException e) {
            logger.error((Object)("\u6ca1\u6709\u627e\u5230SHRAPI\u7c7b\u5bf9\u5e94\u7684\u65b9\u6cd5 \u7c7b\u540d\uff1a" + SHRAPIClass + " \u65b9\u6cd5\u540d\uff1a" + MethodNmae));
            e.printStackTrace();
        }
        catch (IllegalArgumentException e) {
            logger.error((Object)("IllegalArgumentException \u7c7b\u540d\uff1a" + SHRAPIClass + " \u65b9\u6cd5\u540d\uff1a" + MethodNmae));
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            logger.error((Object)("IllegalAccessException \u7c7b\u540d\uff1a" + SHRAPIClass + " \u65b9\u6cd5\u540d\uff1a" + MethodNmae));
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            logger.error((Object)("InvocationTargetException \u7c7b\u540d\uff1a" + SHRAPIClass + " \u65b9\u6cd5\u540d\uff1a" + MethodNmae));
            e.printStackTrace();
        }
        return null;
    }

    protected String _getAssignUipk4Entity(Context ctx, IObjectPK id, IObjectValue model, String viewType) throws BOSException, EASBizException {
        if ("list".equals(viewType)) {
            return "com.kingdee.eas.fi.cas.cas_agentpaybill_list";
        }
        return "com.kingdee.eas.fi.cas.cas_agentpaybill_edit";
    }

    @Override
    protected void _autoPay4WF(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        HashSet<String> idSet = new HashSet<String>();
        idSet.add(pk.toString());
        this._pay(ctx, idSet);
    }

    @Override
    protected void _autoCommitToBE4WF(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        HashSet<String> idSet = new HashSet<String>();
        idSet.add(pk.toString());
        Set bankPayingBillId = this._commitToBE(ctx, idSet);
        this._commitToBeAll(ctx, idSet, bankPayingBillId);
    }

    private void setEntries_oppAccount(Context ctx, AgentPayBillInfo info) {
        AgentPayBillEntryCollection entries = info.getEntrys();
        Iterator it = entries.iterator();
        while (it.hasNext()) {
            AgentPayBillEntryInfo entryInfo = (AgentPayBillEntryInfo)it.next();
            if (entryInfo.getOppAccount() != null || entryInfo.getExpenseType() == null) continue;
            try {
                EntityViewInfo view = new EntityViewInfo();
                FilterInfo filter = new FilterInfo();
                view.setFilter(filter);
                SelectorItemCollection sic = new SelectorItemCollection();
                view.setSelector(sic);
                sic.add(new SelectorItemInfo("id"));
                sic.add(new SelectorItemInfo("accountId.*"));
                filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)info.getCompany().getId()));
                filter.getFilterItems().add(new FilterItemInfo("expenseTypeId.id", (Object)entryInfo.getExpenseType().getId()));
                ExpenseTypeSubjectMappingCollection colls = ExpenseTypeSubjectMappingFactory.getLocalInstance((Context)ctx).getExpenseTypeSubjectMappingCollection(view);
                if (colls == null || colls.size() <= 0) continue;
                entryInfo.setOppAccount(colls.get(0).getAccountId());
            }
            catch (BOSException e) {
                logger.error((Object)e);
            }
        }
    }

    @Override
    protected void _batchReverseSave(Context ctx, IObjectPK[] srcBillPKs, CoreBillBaseCollection srcBillVOs, BOTBillOperStateEnum bOTBillOperStateEnum, BOTRelationCollection bOTRelationInfos, IObjectCollection destObjCol) throws BOSException, EASBizException {
        if (bOTRelationInfos == null || bOTRelationInfos.size() < 1) {
            return;
        }
        BOTRelationInfo botRelation = bOTRelationInfos.get(0);
        Connection conn = null;
        Statement stmt = null;
        try {
            conn = this.getConnection(ctx);
            stmt = conn.createStatement();
            if (new VoucherInfo().getBOSType().toString().equals(botRelation.getDestEntityID())) {
                for (int i = 0; i < bOTRelationInfos.size(); ++i) {
                    int j;
                    VoucherEntryCollection col;
                    HashSet<String> idSet;
                    String srcBillId = bOTRelationInfos.get(i).getSrcObjectID();
                    VoucherInfo voucherInfo = new VoucherInfo();
                    if (destObjCol != null && destObjCol.size() > 0) {
                        try {
                            for (int j2 = 0; j2 < destObjCol.size(); ++j2) {
                                voucherInfo = (VoucherInfo)destObjCol.getObject(j2);
                                if (bOTRelationInfos.get(i).getDestObjectID().equals(voucherInfo.getId().toString())) break;
                            }
                        }
                        catch (Exception e) {
                            voucherInfo = (VoucherInfo)VoucherFactory.getLocalInstance((Context)ctx).getValue((IObjectPK)new ObjectStringPK(bOTRelationInfos.get(i).getDestObjectID()));
                        }
                    } else {
                        voucherInfo = (VoucherInfo)VoucherFactory.getLocalInstance((Context)ctx).getValue((IObjectPK)new ObjectStringPK(bOTRelationInfos.get(i).getDestObjectID()));
                    }
                    String oppAccountId = "";
                    VoucherEntryCollection coll = voucherInfo.getEntries();
                    for (int j3 = 0; j3 < coll.size(); ++j3) {
                        VoucherEntryInfo entryInfo = coll.get(j3);
                        if (EntryDC.DEBIT != entryInfo.getEntryDC() || entryInfo.getAccount() == null) continue;
                        oppAccountId = entryInfo.getAccount().getId().toString();
                        break;
                    }
                    FilterInfo filter = new FilterInfo();
                    filter.getFilterItems().add(new FilterItemInfo("billId", (Object)srcBillId, CompareType.EQUALS));
                    boolean isexist = JournalFactory.getLocalInstance(ctx).exists(filter);
                    String billSql = "";
                    String journalSql = "";
                    String vcResultSql = "";
                    if (BOTBillOperStateEnum.DELETE.equals((Object)bOTBillOperStateEnum)) {
                        billSql = "Update T_CAS_AgentPayBill set FVoucherID = null, FVoucherNumber = null , FFivouchered = 0 where FID = '" + srcBillId + "'";
                        if (isexist) {
                            journalSql = "Update T_CAS_Journal set FVoucherNumber = null , FVoucherTypeID = null, FVoucherId = null where FBillId = '" + srcBillId + "'";
                            vcResultSql = "Update T_VC_VcResult set FVOUCHERNUMBER = null, FVOUCHERTYPEID = null where FBIZOBJECTID in (select FID from T_CAS_Journal where FBillID = '" + srcBillId + "')";
                        } else {
                            idSet = new HashSet<String>();
                            col = voucherInfo.getEntries();
                            for (j = 0; j < col.size(); ++j) {
                                idSet.add(col.get(j).getId().toString());
                            }
                            journalSql = "Update T_CAS_Journal set FVoucherNumber = null , FBillNumber = null ,FVoucherTypeID = null, FVoucherId = null where FBillId = '" + voucherInfo.getId().toString() + "'  or FBillId in  (" + this.newBuildIn(idSet.toArray());
                            vcResultSql = "Update T_VC_VcResult set FVOUCHERNUMBER = null ,FbillNumber = null , FVOUCHERTYPEID = null where FBIZOBJECTID in (select FID from T_CAS_Journal where FBillID = '" + voucherInfo.getId().toString() + "'  or FBillId in  (" + this.newBuildIn(idSet.toArray()) + ")";
                        }
                    } else if (BOTBillOperStateEnum.EDIT.equals((Object)bOTBillOperStateEnum)) {
                        billSql = "Update T_CAS_AgentPayBill set FVoucherID =  '" + voucherInfo.getId().toString() + "' , FVoucherNumber = '" + voucherInfo.getNumber() + "' where Fid = '" + srcBillId + "'";
                        if (isexist) {
                            journalSql = "Update T_CAS_Journal set FVoucherNumber = '" + voucherInfo.getNumber() + "' , FVoucherTypeID = '" + voucherInfo.getVoucherType().getId().toString() + "' , FVoucherId = '" + voucherInfo.getId().toString() + "' , FOPPACCOUNTVIEWID = '" + oppAccountId + "' where FBillId = '" + srcBillId + "'";
                            vcResultSql = "Update T_VC_VcResult set FVOUCHERNUMBER = '" + voucherInfo.getNumber() + "', FVOUCHERTYPEID = '" + voucherInfo.getVoucherType().getId().toString() + "' where FBIZOBJECTID in (select FID from T_CAS_Journal where FBillID = '" + srcBillId + "')";
                        } else {
                            idSet = new HashSet();
                            col = voucherInfo.getEntries();
                            for (j = 0; j < col.size(); ++j) {
                                idSet.add(col.get(j).getId().toString());
                            }
                            if (idSet.size() > 0) {
                                journalSql = "Update T_CAS_Journal set FVoucherNumber = '" + voucherInfo.getNumber() + "' , FbillNumber  = '" + voucherInfo.getNumber() + "' , FVoucherTypeID = '" + voucherInfo.getVoucherType().getId().toString() + "' , FVoucherId = '" + voucherInfo.getId().toString() + "' where FBillId = '" + voucherInfo.getId().toString() + "' or FBillId in  (" + this.newBuildIn(idSet.toArray());
                                vcResultSql = "Update T_VC_VcResult set FVOUCHERNUMBER = '" + voucherInfo.getNumber() + "', FbillNumber  = '" + voucherInfo.getNumber() + "', FVOUCHERTYPEID = '" + voucherInfo.getVoucherType().getId().toString() + "' where FBIZOBJECTID in (select FID from T_CAS_Journal where FBillID = '" + voucherInfo.getId().toString() + "' or FBillId in  (" + this.newBuildIn(idSet.toArray()) + ")";
                            }
                        }
                    } else {
                        billSql = "Update T_CAS_AgentPayBill set FVoucherID =  '" + voucherInfo.getId().toString() + "' , FVoucherNumber = '" + voucherInfo.getNumber() + "' , FFivouchered = 1   where Fid = '" + srcBillId + "'";
                        if (isexist) {
                            journalSql = "Update T_CAS_Journal set FVoucherNumber = '" + voucherInfo.getNumber() + "' , FVoucherTypeID = '" + voucherInfo.getVoucherType().getId().toString() + "' , FVoucherId = '" + voucherInfo.getId().toString() + "' , FOPPACCOUNTVIEWID = '" + oppAccountId + "' where FBillId = '" + srcBillId + "'";
                            vcResultSql = "Update T_VC_VcResult set FVOUCHERNUMBER = '" + voucherInfo.getNumber() + "', FVOUCHERTYPEID = '" + voucherInfo.getVoucherType().getId().toString() + "' where FBIZOBJECTID in (select FID from T_CAS_Journal where FBillID = '" + srcBillId + "')";
                        } else {
                            idSet = new HashSet();
                            col = voucherInfo.getEntries();
                            for (j = 0; j < col.size(); ++j) {
                                idSet.add(col.get(j).getId().toString());
                            }
                            if (idSet.size() > 0) {
                                journalSql = "Update T_CAS_Journal set FVoucherNumber = '" + voucherInfo.getNumber() + "' , FbillNumber  = '" + voucherInfo.getNumber() + "' , FVoucherTypeID = '" + voucherInfo.getVoucherType().getId().toString() + "' , FVoucherId = '" + voucherInfo.getId().toString() + "' where FBillId = '" + voucherInfo.getId().toString() + "' or FBillId in  (" + this.newBuildIn(idSet.toArray());
                                vcResultSql = "Update T_VC_VcResult set FVOUCHERNUMBER = '" + voucherInfo.getNumber() + "' , FbillNumber  = '" + voucherInfo.getNumber() + "', FVOUCHERTYPEID = '" + voucherInfo.getVoucherType().getId().toString() + "' where FBIZOBJECTID in (select FID from T_CAS_Journal where FBillID = '" + voucherInfo.getId().toString() + "' or FBillId in  (" + this.newBuildIn(idSet.toArray()) + ")";
                            }
                        }
                    }
                    if (!EmptyUtil.isEmpty((String)billSql)) {
                        stmt.addBatch(billSql);
                    }
                    if (!EmptyUtil.isEmpty((String)journalSql)) {
                        stmt.addBatch(journalSql);
                    }
                    if (EmptyUtil.isEmpty((String)vcResultSql)) continue;
                    stmt.addBatch(vcResultSql);
                }
                stmt.executeBatch();
            }
        }
        catch (SQLException e) {
            try {
                logger.error((Object)e);
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(stmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)stmt, (Connection)conn);
    }

    private String newBuildIn(Object[] set) {
        if (set == null || set.length == 0) {
            return " ";
        }
        StringBuffer sb = new StringBuffer(1204);
        for (int i = 0; i < set.length; ++i) {
            if (i == set.length - 1) {
                StringUtil.appendStrValue((StringBuffer)sb, (Object)set[i]);
                continue;
            }
            StringUtil.appendStrValue((StringBuffer)sb, (Object)set[i]);
            sb.append(",");
        }
        sb.append(")");
        return sb.toString();
    }

    private static void initAgentPayBillNumber(Context ctx, BillBaseInfo info) throws BOSException, EASBizException {
        FilterInfo filter;
        if (!EmptyUtil.isEmpty((String)info.getNumber())) {
            return;
        }
        int i = 0;
        IAgentPayBill iAgentPayBill = AgentPayBillFactory.getLocalInstance(ctx);
        do {
            String numberSilent = null;
            try {
                numberSilent = NumberRuleUtil.getNumberSilent((Context)ctx, (CoreBaseInfo)info, (String)info.getCompany().getId().toString());
            }
            catch (CodingRuleException e) {
                logger.info((Object)e);
                throw new FMException(FMException.COMMMONEXCEPTION, new Object[]{e.getMessage()});
            }
            if (EmptyUtil.isEmpty((String)numberSilent)) {
                return;
            }
            info.setNumber(numberSilent);
            filter = NumberRuleUtil.getCheckNumberDupFilter((IObjectValue)info, (boolean)true);
            ++i;
        } while (iAgentPayBill.exists(filter));
    }

    private void recordPayInfoLog(Context ctx, AgentPayBillInfo oldInfo, AgentPayBillInfo newInfo, PaymentOperateType operateType) throws BOSException, EASBizException {
        PaymentBillLogInfo logInfo;
        int i;
        if (oldInfo == null) {
            return;
        }
        UserInfo userInfo = ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentUser();
        Timestamp currTime = new Timestamp(System.currentTimeMillis());
        CoreBaseCollection logCollection = new CoreBaseCollection();
        if (!EmptyUtil.isEmpty((CoreBaseInfo)oldInfo.getFeeType()) && EmptyUtil.isEmpty((CoreBaseInfo)newInfo.getFeeType()) || EmptyUtil.isEmpty((CoreBaseInfo)oldInfo.getFeeType()) && !EmptyUtil.isEmpty((CoreBaseInfo)newInfo.getFeeType()) || !EmptyUtil.isEmpty((CoreBaseInfo)oldInfo.getFeeType()) && !EmptyUtil.isEmpty((CoreBaseInfo)newInfo.getFeeType()) && !newInfo.getFeeType().getId().equals((Object)oldInfo.getFeeType().getId())) {
            logCollection = this.createPaymentLogInfo(ctx, logCollection, newInfo, oldInfo, userInfo, currTime, operateType, FEETYPE);
        }
        if (!EmptyUtil.isEmpty((CoreBaseInfo)oldInfo.getPayBankAccount()) && EmptyUtil.isEmpty((CoreBaseInfo)newInfo.getPayBankAccount()) || EmptyUtil.isEmpty((CoreBaseInfo)oldInfo.getPayBankAccount()) && !EmptyUtil.isEmpty((CoreBaseInfo)newInfo.getPayBankAccount()) || !EmptyUtil.isEmpty((CoreBaseInfo)oldInfo.getPayBankAccount()) && !EmptyUtil.isEmpty((CoreBaseInfo)newInfo.getPayBankAccount()) && !newInfo.getPayBankAccount().getId().equals((Object)oldInfo.getPayBankAccount().getId())) {
            logCollection = this.createPaymentLogInfo(ctx, logCollection, newInfo, oldInfo, userInfo, currTime, operateType, PAYBANKACCOUNT);
        }
        if (!EmptyUtil.isEmpty((CoreBaseInfo)oldInfo.getPayerAccount()) && EmptyUtil.isEmpty((CoreBaseInfo)newInfo.getPayerAccount()) || EmptyUtil.isEmpty((CoreBaseInfo)oldInfo.getPayerAccount()) && !EmptyUtil.isEmpty((CoreBaseInfo)newInfo.getPayerAccount()) || !EmptyUtil.isEmpty((CoreBaseInfo)oldInfo.getPayerAccount()) && !EmptyUtil.isEmpty((CoreBaseInfo)newInfo.getPayerAccount()) && !newInfo.getPayerAccount().getId().equals((Object)oldInfo.getPayerAccount().getId())) {
            logCollection = this.createPaymentLogInfo(ctx, logCollection, newInfo, oldInfo, userInfo, currTime, operateType, PAYERACCOUNT);
        }
        if (!EmptyUtil.isEmpty((CoreBaseInfo)oldInfo.getPayerBank()) && EmptyUtil.isEmpty((CoreBaseInfo)newInfo.getPayerBank()) || EmptyUtil.isEmpty((CoreBaseInfo)oldInfo.getPayerBank()) && !EmptyUtil.isEmpty((CoreBaseInfo)newInfo.getPayerBank()) || !EmptyUtil.isEmpty((CoreBaseInfo)oldInfo.getPayerBank()) && !EmptyUtil.isEmpty((CoreBaseInfo)newInfo.getPayerBank()) && !newInfo.getPayerBank().getId().equals((Object)oldInfo.getPayerBank().getId())) {
            logCollection = this.createPaymentLogInfo(ctx, logCollection, newInfo, oldInfo, userInfo, currTime, operateType, PAYERBANK);
        }
        if (!(EmptyUtil.isEmpty((CoreBaseInfo)oldInfo.getCurrency()) || EmptyUtil.isEmpty((CoreBaseInfo)newInfo.getCurrency()) || newInfo.getCurrency().getId().equals((Object)oldInfo.getCurrency().getId()))) {
            logCollection = this.createPaymentLogInfo(ctx, logCollection, newInfo, oldInfo, userInfo, currTime, operateType, CURRENCY);
        }
        if (newInfo.getExchangeRate().compareTo(oldInfo.getExchangeRate()) != 0) {
            logCollection = this.createPaymentLogInfo(ctx, logCollection, newInfo, oldInfo, userInfo, currTime, operateType, EXCHANGERATE);
        }
        if (!EmptyUtil.isEmpty((CoreBaseInfo)oldInfo.getSettlementType()) && EmptyUtil.isEmpty((CoreBaseInfo)newInfo.getSettlementType()) || EmptyUtil.isEmpty((CoreBaseInfo)oldInfo.getSettlementType()) && !EmptyUtil.isEmpty((CoreBaseInfo)newInfo.getSettlementType()) || !EmptyUtil.isEmpty((CoreBaseInfo)oldInfo.getSettlementType()) && !EmptyUtil.isEmpty((CoreBaseInfo)newInfo.getSettlementType()) && !newInfo.getSettlementType().getId().equals((Object)oldInfo.getSettlementType().getId())) {
            logCollection = this.createPaymentLogInfo(ctx, logCollection, newInfo, oldInfo, userInfo, currTime, operateType, SETTLEMENTTYPE);
        }
        if (!EmptyUtil.isEmpty((String)oldInfo.getUsage()) && EmptyUtil.isEmpty((String)newInfo.getUsage()) || EmptyUtil.isEmpty((String)oldInfo.getUsage()) && !EmptyUtil.isEmpty((String)newInfo.getUsage()) || !EmptyUtil.isEmpty((String)oldInfo.getUsage()) && !EmptyUtil.isEmpty((String)newInfo.getUsage()) && !newInfo.getUsage().equals(oldInfo.getUsage())) {
            logCollection = this.createPaymentLogInfo(ctx, logCollection, newInfo, oldInfo, userInfo, currTime, operateType, USAGE);
        }
        if (!EmptyUtil.isEmpty((Object)oldInfo.getExpectDealTime()) && EmptyUtil.isEmpty((Object)newInfo.getExpectDealTime()) || EmptyUtil.isEmpty((Object)oldInfo.getExpectDealTime()) && !EmptyUtil.isEmpty((Object)newInfo.getExpectDealTime()) || !EmptyUtil.isEmpty((Object)oldInfo.getExpectDealTime()) && !EmptyUtil.isEmpty((Object)newInfo.getExpectDealTime()) && !newInfo.getExpectDealTime().equals(oldInfo.getExpectDealTime())) {
            logCollection = this.createPaymentLogInfo(ctx, logCollection, newInfo, oldInfo, userInfo, currTime, operateType, EXPECTDEALTIME);
        }
        if (!EmptyUtil.isEmpty((CoreBaseInfo)oldInfo.getFundFlowItem()) && EmptyUtil.isEmpty((CoreBaseInfo)newInfo.getFundFlowItem()) || EmptyUtil.isEmpty((CoreBaseInfo)oldInfo.getFundFlowItem()) && !EmptyUtil.isEmpty((CoreBaseInfo)newInfo.getFundFlowItem()) || !EmptyUtil.isEmpty((CoreBaseInfo)oldInfo.getFundFlowItem()) && !EmptyUtil.isEmpty((CoreBaseInfo)newInfo.getFundFlowItem()) && !newInfo.getFundFlowItem().getId().equals((Object)oldInfo.getFundFlowItem().getId())) {
            logCollection = this.createPaymentLogInfo(ctx, logCollection, newInfo, oldInfo, userInfo, currTime, operateType, FUNDFLOWITEM);
        }
        AgentPayBillEntryCollection oldEntrys = oldInfo.getEntrys();
        HashMap<String, AgentPayBillEntryInfo> oldEntryMap = new HashMap<String, AgentPayBillEntryInfo>();
        for (int i2 = 0; i2 < oldEntrys.size(); ++i2) {
            AgentPayBillEntryInfo entry = oldEntrys.get(i2);
            oldEntryMap.put(entry.getId().toString(), entry);
        }
        AgentPayBillEntryCollection newEntrys = newInfo.getEntrys();
        HashMap<String, AgentPayBillEntryInfo> newEntryMap = new HashMap<String, AgentPayBillEntryInfo>();
        for (i = 0; i < newEntrys.size(); ++i) {
            AgentPayBillEntryInfo entry = newEntrys.get(i);
            newEntryMap.put(entry.getId().toString(), entry);
        }
        for (i = 0; i < oldEntrys.size(); ++i) {
            AgentPayBillEntryInfo oldEntry = oldEntrys.get(i);
            AgentPayBillEntryInfo newEntry = (AgentPayBillEntryInfo)newEntryMap.get(oldEntry.getId().toString());
            logInfo = new PaymentBillLogInfo();
            logInfo.setIP(ctx.getClientHostIP());
            logInfo.setOperateBillEnum(OperateBillEnum.AgentPayBill);
            logInfo.setBillNumber(newInfo.getNumber());
            logInfo.setEntryID(oldEntry.getId().toString());
            logInfo.setOperateTime(currTime);
            logInfo.setUserName(userInfo.getName());
            logInfo.setUserNumber(userInfo.getNumber());
            logInfo.setOperateType(operateType);
            logInfo.setCompany(newInfo.getCompany());
            if (newEntry == null) {
                logInfo.setUpdateColumn("\u5220\u9664\u5206\u5f55");
                logCollection.add((CoreBaseInfo)logInfo);
                continue;
            }
            logInfo.setUpdateColumn("\u4ee3\u53d1\u5355\u5206\u5f55");
            if (!EmptyUtil.isEmpty((String)oldEntry.getRecName()) && EmptyUtil.isEmpty((String)newEntry.getRecName()) || EmptyUtil.isEmpty((String)oldEntry.getRecName()) && !EmptyUtil.isEmpty((String)newEntry.getRecName()) || !EmptyUtil.isEmpty((String)oldEntry.getRecName()) && !EmptyUtil.isEmpty((String)newEntry.getRecName()) && !newEntry.getRecName().equals(oldEntry.getRecName())) {
                this.createPaymentLogInfo(logInfo, newEntry, oldEntry, RECNAME);
            }
            if (!EmptyUtil.isEmpty((String)oldEntry.getRecBankAccount()) && EmptyUtil.isEmpty((String)newEntry.getRecBankAccount()) || EmptyUtil.isEmpty((String)oldEntry.getRecBankAccount()) && !EmptyUtil.isEmpty((String)newEntry.getRecBankAccount()) || !EmptyUtil.isEmpty((String)oldEntry.getRecBankAccount()) && !EmptyUtil.isEmpty((String)newEntry.getRecBankAccount()) && !newEntry.getRecBankAccount().equals(oldEntry.getRecBankAccount())) {
                this.createPaymentLogInfo(logInfo, newEntry, oldEntry, RECBANKACCOUNT);
            }
            if (!EmptyUtil.isEmpty((String)oldEntry.getRecBankName()) && EmptyUtil.isEmpty((String)newEntry.getRecBankName()) || EmptyUtil.isEmpty((String)oldEntry.getRecBankName()) && !EmptyUtil.isEmpty((String)newEntry.getRecBankName()) || !EmptyUtil.isEmpty((String)oldEntry.getRecBankName()) && !EmptyUtil.isEmpty((String)newEntry.getRecBankName()) && !newEntry.getRecBankName().equals(oldEntry.getRecBankName())) {
                this.createPaymentLogInfo(logInfo, newEntry, oldEntry, RECBANKNAME);
            }
            if (newEntry.getAmount().compareTo(oldEntry.getAmount()) != 0) {
                this.createPaymentLogInfo(logInfo, newEntry, oldEntry, AMOUNT);
            }
            if (!EmptyUtil.isEmpty((String)oldEntry.getRecProvince()) && EmptyUtil.isEmpty((String)newEntry.getRecProvince()) || EmptyUtil.isEmpty((String)oldEntry.getRecProvince()) && !EmptyUtil.isEmpty((String)newEntry.getRecProvince()) || !EmptyUtil.isEmpty((String)oldEntry.getRecProvince()) && !EmptyUtil.isEmpty((String)newEntry.getRecProvince()) && !newEntry.getRecProvince().equals(oldEntry.getRecProvince())) {
                this.createPaymentLogInfo(logInfo, newEntry, oldEntry, RECPROVINCE);
            }
            if (!EmptyUtil.isEmpty((String)oldEntry.getRecCity()) && EmptyUtil.isEmpty((String)newEntry.getRecCity()) || EmptyUtil.isEmpty((String)oldEntry.getRecCity()) && !EmptyUtil.isEmpty((String)newEntry.getRecCity()) || !EmptyUtil.isEmpty((String)oldEntry.getRecCity()) && !EmptyUtil.isEmpty((String)newEntry.getRecCity()) && !newEntry.getRecCity().equals(oldEntry.getRecCity())) {
                this.createPaymentLogInfo(logInfo, newEntry, oldEntry, RECCITY);
            }
            if (!EmptyUtil.isEmpty((Object)oldEntry.getCertType()) && EmptyUtil.isEmpty((Object)newEntry.getCertType()) || EmptyUtil.isEmpty((Object)oldEntry.getCertType()) && !EmptyUtil.isEmpty((Object)newEntry.getCertType()) || !EmptyUtil.isEmpty((Object)oldEntry.getCertType()) && !EmptyUtil.isEmpty((Object)newEntry.getCertType()) && !newEntry.getCertType().equals((Object)oldEntry.getCertType())) {
                this.createPaymentLogInfo(logInfo, newEntry, oldEntry, CERTTYPE);
            }
            if (!EmptyUtil.isEmpty((String)oldEntry.getCertNum()) && EmptyUtil.isEmpty((String)newEntry.getCertNum()) || EmptyUtil.isEmpty((String)oldEntry.getCertNum()) && !EmptyUtil.isEmpty((String)newEntry.getCertNum()) || !EmptyUtil.isEmpty((String)oldEntry.getCertNum()) && !EmptyUtil.isEmpty((String)newEntry.getCertNum()) && !newEntry.getCertNum().equals(oldEntry.getCertNum())) {
                this.createPaymentLogInfo(logInfo, newEntry, oldEntry, CERTNUM);
            }
            if (EmptyUtil.isEmpty((String)logInfo.getUpdateBefore())) continue;
            logCollection.add((CoreBaseInfo)logInfo);
        }
        for (i = 0; i < newEntrys.size(); ++i) {
            AgentPayBillEntryInfo newEntry = newEntrys.get(i);
            AgentPayBillEntryInfo oldEntry = (AgentPayBillEntryInfo)oldEntryMap.get(newEntry.getId().toString());
            logInfo = new PaymentBillLogInfo();
            logInfo.setIP(ctx.getClientHostIP());
            logInfo.setOperateBillEnum(OperateBillEnum.AgentPayBill);
            logInfo.setBillNumber(newInfo.getNumber());
            logInfo.setEntryID(newEntry.getId().toString());
            logInfo.setOperateTime(currTime);
            logInfo.setUserName(userInfo.getName());
            logInfo.setUserNumber(userInfo.getNumber());
            logInfo.setOperateType(operateType);
            logInfo.setCompany(newInfo.getCompany());
            if (oldEntry != null) continue;
            logInfo.setUpdateColumn("\u65b0\u589e\u5206\u5f55");
            logCollection.add((CoreBaseInfo)logInfo);
        }
        Date DestDate = DateTimeUtils.truncateDate((Date)this.getSrcDate(-30));
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("operateTime", (Object)DestDate, CompareType.LESS_EQUALS));
        PaymentBillLogFactory.getLocalInstance(ctx).delete(filter);
        PaymentBillLogFactory.getLocalInstance(ctx).addnewBatchData(logCollection);
    }

    private CoreBaseCollection createPaymentLogInfo(Context ctx, CoreBaseCollection logCollection, AgentPayBillInfo newInfo, AgentPayBillInfo oldInfo, UserInfo userInfo, Timestamp currTime, PaymentOperateType operateType, String column) {
        PaymentBillLogInfo logInfo = new PaymentBillLogInfo();
        logInfo.setIP(ctx.getClientHostIP());
        logInfo.setOperateBillEnum(OperateBillEnum.AgentPayBill);
        logInfo.setBillNumber(newInfo.getNumber());
        logInfo.setOperateTime(currTime);
        logInfo.setUserName(userInfo.getName());
        logInfo.setUserNumber(userInfo.getNumber());
        logInfo.setOperateType(operateType);
        logInfo.setCompany(newInfo.getCompany());
        if (FEETYPE.equals(column)) {
            logInfo.setUpdateColumn(FEETYPE);
            if (oldInfo.getFeeType() != null) {
                logInfo.setUpdateBefore(oldInfo.getFeeType().getName());
            }
            if (newInfo.getFeeType() != null) {
                logInfo.setUpdateAfter(newInfo.getFeeType().getName());
            }
        } else if (PAYBANKACCOUNT.equals(column)) {
            logInfo.setUpdateColumn(PAYBANKACCOUNT);
            if (oldInfo.getPayBankAccount() != null) {
                logInfo.setUpdateBefore(oldInfo.getPayBankAccount().getBankAccountNumber());
            }
            if (newInfo.getPayBankAccount() != null) {
                logInfo.setUpdateAfter(newInfo.getPayBankAccount().getBankAccountNumber());
            }
        } else if (PAYERACCOUNT.equals(column)) {
            logInfo.setUpdateColumn(PAYERACCOUNT);
            if (oldInfo.getPayerAccount() != null) {
                logInfo.setUpdateBefore(oldInfo.getPayerAccount().getName());
            }
            if (newInfo.getPayerAccount() != null) {
                logInfo.setUpdateAfter(newInfo.getPayerAccount().getName());
            }
        } else if (PAYERBANK.equals(column)) {
            logInfo.setUpdateColumn(PAYERBANK);
            if (oldInfo.getPayerBank() != null) {
                logInfo.setUpdateBefore(oldInfo.getPayerBank().getName());
            }
            if (newInfo.getPayerBank() != null) {
                logInfo.setUpdateAfter(newInfo.getPayerBank().getName());
            }
        } else if (CURRENCY.equals(column)) {
            logInfo.setUpdateColumn(CURRENCY);
            if (oldInfo.getCurrency() != null) {
                logInfo.setUpdateBefore(oldInfo.getCurrency().getName());
            }
            if (newInfo.getCurrency() != null) {
                logInfo.setUpdateAfter(newInfo.getCurrency().getName());
            }
        } else if (EXCHANGERATE.equals(column)) {
            logInfo.setUpdateColumn(EXCHANGERATE);
            if (oldInfo.getExchangeRate() != null) {
                logInfo.setUpdateBefore(String.valueOf(oldInfo.getExchangeRate()));
            }
            if (newInfo.getExchangeRate() != null) {
                logInfo.setUpdateAfter(String.valueOf(newInfo.getExchangeRate()));
            }
        } else if (SETTLEMENTTYPE.equals(column)) {
            logInfo.setUpdateColumn(SETTLEMENTTYPE);
            if (oldInfo.getSettlementType() != null) {
                logInfo.setUpdateBefore(oldInfo.getSettlementType().getName());
            }
            if (newInfo.getSettlementType() != null) {
                logInfo.setUpdateAfter(newInfo.getSettlementType().getName());
            }
        } else if (USAGE.equals(column)) {
            logInfo.setUpdateColumn(USAGE);
            if (oldInfo.getUsage() != null) {
                logInfo.setUpdateBefore(oldInfo.getUsage());
            }
            if (newInfo.getUsage() != null) {
                logInfo.setUpdateAfter(newInfo.getUsage());
            }
        } else if (EXPECTDEALTIME.equals(column)) {
            logInfo.setUpdateColumn(EXPECTDEALTIME);
            if (oldInfo.getExpectDealTime() != null) {
                logInfo.setUpdateBefore(oldInfo.getExpectDealTime().toString());
            }
            if (newInfo.getExpectDealTime() != null) {
                logInfo.setUpdateAfter(newInfo.getExpectDealTime().toString());
            }
        } else if (FUNDFLOWITEM.equals(column)) {
            logInfo.setUpdateColumn(FUNDFLOWITEM);
            if (oldInfo.getFundFlowItem() != null) {
                logInfo.setUpdateBefore(oldInfo.getFundFlowItem().getName());
            }
            if (newInfo.getFundFlowItem() != null) {
                logInfo.setUpdateAfter(newInfo.getFundFlowItem().getName());
            }
        }
        logCollection.add((CoreBaseInfo)logInfo);
        return logCollection;
    }

    private void createPaymentLogInfo(PaymentBillLogInfo logInfo, AgentPayBillEntryInfo newEntry, AgentPayBillEntryInfo oldEntry, String column) {
        if (logInfo.getUpdateAfter() == null) {
            logInfo.setUpdateAfter("");
        }
        if (logInfo.getUpdateBefore() == null) {
            logInfo.setUpdateBefore("");
        }
        if (RECNAME.equals(column)) {
            logInfo.setUpdateBefore(logInfo.getUpdateBefore() + RECNAME + "\uff1a" + (oldEntry.getRecName() == null ? " " : oldEntry.getRecName()) + "\uff1b ");
            logInfo.setUpdateAfter(logInfo.getUpdateAfter() + RECNAME + "\uff1a" + (newEntry.getRecName() == null ? " " : newEntry.getRecName()) + "\uff1b ");
        } else if (RECBANKACCOUNT.equals(column)) {
            logInfo.setUpdateBefore(logInfo.getUpdateBefore() + RECBANKACCOUNT + "\uff1a" + (oldEntry.getRecBankAccount() == null ? " " : oldEntry.getRecBankAccount()) + "\uff1b ");
            logInfo.setUpdateAfter(logInfo.getUpdateAfter() + RECBANKACCOUNT + "\uff1a" + (newEntry.getRecBankAccount() == null ? " " : newEntry.getRecBankAccount()) + "\uff1b ");
        } else if (RECBANKNAME.equals(column)) {
            logInfo.setUpdateBefore(logInfo.getUpdateBefore() + RECBANKNAME + "\uff1a" + (oldEntry.getRecBankName() == null ? " " : oldEntry.getRecBankName()) + "\uff1b ");
            logInfo.setUpdateAfter(logInfo.getUpdateAfter() + RECBANKNAME + "\uff1a" + (newEntry.getRecBankName() == null ? " " : newEntry.getRecBankName()) + "\uff1b ");
        } else if (AMOUNT.equals(column)) {
            logInfo.setUpdateBefore(logInfo.getUpdateBefore() + AMOUNT + "\uff1a" + oldEntry.getAmount().setScale(4, 4) + "\uff1b ");
            logInfo.setUpdateAfter(logInfo.getUpdateAfter() + AMOUNT + "\uff1a" + newEntry.getAmount().setScale(4, 4) + "\uff1b ");
        } else if (RECPROVINCE.equals(column)) {
            logInfo.setUpdateBefore(logInfo.getUpdateBefore() + RECPROVINCE + "\uff1a" + (oldEntry.getRecProvince() == null ? " " : oldEntry.getRecProvince()) + "\uff1b ");
            logInfo.setUpdateAfter(logInfo.getUpdateAfter() + RECPROVINCE + "\uff1a" + (newEntry.getRecProvince() == null ? " " : newEntry.getRecProvince()) + "\uff1b ");
        } else if (RECCITY.equals(column)) {
            logInfo.setUpdateBefore(logInfo.getUpdateBefore() + RECCITY + "\uff1a" + (oldEntry.getRecCity() == null ? " " : oldEntry.getRecCity()) + "\uff1b ");
            logInfo.setUpdateAfter(logInfo.getUpdateAfter() + RECCITY + "\uff1a" + (newEntry.getRecCity() == null ? " " : newEntry.getRecCity()) + "\uff1b ");
        } else if (CERTTYPE.equals(column)) {
            logInfo.setUpdateBefore(logInfo.getUpdateBefore() + CERTTYPE + "\uff1a" + (oldEntry.getCertType() == null ? " " : oldEntry.getCertType()) + "\uff1b ");
            logInfo.setUpdateAfter(logInfo.getUpdateAfter() + CERTTYPE + "\uff1a" + (newEntry.getCertType() == null ? " " : newEntry.getCertType()) + "\uff1b ");
        } else if (CERTNUM.equals(column)) {
            logInfo.setUpdateBefore(logInfo.getUpdateBefore() + CERTNUM + "\uff1a" + (oldEntry.getCertNum() == null ? " " : oldEntry.getCertNum()) + "\uff1b ");
            logInfo.setUpdateAfter(logInfo.getUpdateAfter() + CERTNUM + "\uff1a" + (newEntry.getCertNum() == null ? " " : newEntry.getCertNum()) + "\uff1b ");
        }
    }

    private SelectorItemCollection getSelectorForLog() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("lastUpdateUser.id"));
        sic.add(new SelectorItemInfo("company.*"));
        sic.add(new SelectorItemInfo("feeType.id"));
        sic.add(new SelectorItemInfo("feeType.name"));
        sic.add(new SelectorItemInfo("payBankAccount.*"));
        sic.add(new SelectorItemInfo("payerAccount.id"));
        sic.add(new SelectorItemInfo("payerAccount.name"));
        sic.add(new SelectorItemInfo("payerBank.*"));
        sic.add(new SelectorItemInfo("currency.id"));
        sic.add(new SelectorItemInfo("currency.name"));
        sic.add(new SelectorItemInfo("settlementType.id"));
        sic.add(new SelectorItemInfo("settlementType.name"));
        sic.add(new SelectorItemInfo("fundFlowItem.id"));
        sic.add(new SelectorItemInfo("fundFlowItem.name"));
        sic.add(new SelectorItemInfo("entrys.*"));
        sic.add(new SelectorItemInfo("entrys.recBank.*"));
        return sic;
    }

    private Date getSrcDate(int days) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(new Date());
        calendar.set(5, calendar.get(5) + days);
        return calendar.getTime();
    }

    protected void _handleAfterTransform(Context ctx, String action, IObjectValue objectValue) throws BOSException, EASBizException {
        AgentPayBillInfo info = (AgentPayBillInfo)objectValue;
        info.setCount(info.getEntrys().size());
    }
}

