/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.cas.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.AbstractObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.basedata.assistant.AccountBankInfo;
import com.kingdee.eas.basedata.assistant.BankFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.SettlementTypeInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.CostCenterOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.cp.bc.ExpenseTypeInfo;
import com.kingdee.eas.fi.cas.AbstractFMDataImport;
import com.kingdee.eas.fi.cas.AgentPayBillCollection;
import com.kingdee.eas.fi.cas.AgentPayBillDataImportUtil;
import com.kingdee.eas.fi.cas.AgentPayBillEntryCollection;
import com.kingdee.eas.fi.cas.AgentPayBillEntryFactory;
import com.kingdee.eas.fi.cas.AgentPayBillEntryInfo;
import com.kingdee.eas.fi.cas.AgentPayBillFactory;
import com.kingdee.eas.fi.cas.AgentPayBillInfo;
import com.kingdee.eas.fi.cas.BillStatusEnum;
import com.kingdee.eas.fi.cas.CasWebException;
import com.kingdee.eas.fi.cas.FeeTypeInfo;
import com.kingdee.eas.fi.cas.IAgentPayBill;
import com.kingdee.eas.fi.cas.IAgentPayBillEntry;
import com.kingdee.eas.fi.cas.app.AgentPayBillImportVerify;
import com.kingdee.eas.fi.cas.app.RecAndPayDataImportUtil2;
import com.kingdee.eas.fi.cas.utils.CASWebHelper;
import com.kingdee.eas.fm.be.BEBankCollection;
import com.kingdee.eas.fm.be.BEBankFactory;
import com.kingdee.eas.fm.common.ContextHelperFactory;
import com.kingdee.eas.fm.common.FMConstants;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.common.IContextHelper;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.ma.budget.BgItemInfo;
import com.kingdee.eas.tools.datatask.core.TaskExternalException;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.jdbc.rowset.IRowSetMetaData;
import com.kingdee.util.DateTimeUtils;
import com.kingdee.util.TypeConversionUtils;
import com.kingdee.util.Uuid;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.SQLException;
import java.text.DecimalFormat;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;

public class AgentPayBillDataImport
extends AbstractFMDataImport {
    private static Logger logger = Logger.getLogger((String)AgentPayBillDataImport.class.getName());
    private AgentPayBillImportVerify verify;
    private Map infoMap = new HashMap(100);
    private Map seqMap = new HashMap();
    private String lastKey;
    private String curKey;
    private boolean payThroughBE = false;
    private static final String SHREntryAmount = "XXXXXX";

    @Override
    protected ICoreBase _getController(Context ctx) throws EASBizException, BOSException {
        return AgentPayBillFactory.getLocalInstance(ctx);
    }

    public AgentPayBillImportVerify getVerify() {
        if (this.verify == null) {
            this.verify = new AgentPayBillImportVerify();
        }
        return this.verify;
    }

    @Override
    protected void _submit(CoreBaseInfo coreBaseInfo, Context ctx) throws BOSException, EASBizException {
        if (coreBaseInfo == null) {
            return;
        }
        if (coreBaseInfo.getId() == null || !this._getController(ctx).exists((IObjectPK)new ObjectUuidPK(coreBaseInfo.getId()))) {
            this._getController(ctx).addnew(coreBaseInfo);
        } else {
            AgentPayBillInfo info = (AgentPayBillInfo)coreBaseInfo;
            if (BillStatusEnum.SAVE.equals((Object)info.getBillStatus()) || BillStatusEnum.SUBMIT.equals((Object)info.getBillStatus())) {
                this._getController(ctx).update((IObjectPK)new ObjectUuidPK(coreBaseInfo.getId()), coreBaseInfo);
            } else {
                throw new BOSException(ResourceBase.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"14_AgentPayBillDataImport", (Locale)ctx.getLocale()));
            }
        }
    }

    @Override
    protected CoreBaseInfo _transmit(Hashtable hsData, Context ctx) throws EASBizException, BOSException {
        String number = (String)this.getData(hsData, "Fnumber");
        this.curKey = FMHelper.isEmpty((String)number) ? Uuid.create().toString() : number;
        if (this.lastKey == null) {
            this.lastKey = this.curKey;
        }
        IContextHelper contextHelper = ContextHelperFactory.getLocalInstance((Context)ctx);
        CompanyOrgUnitInfo currCompany = contextHelper.getCurrentCompany();
        String companyNumber = (String)this.getData(hsData, "FCompanyId");
        if (!EmptyUtil.isEmpty((String)companyNumber)) {
            currCompany = RecAndPayDataImportUtil2.getCompanyByNumber(ctx, companyNumber);
        }
        AgentPayBillInfo head = null;
        AgentPayBillEntryInfo entry = null;
        String companyId = currCompany.getId().toString();
        boolean isPermission = CASWebHelper.hasFunctionPermission(ctx, ctx.getCaller(), (IObjectPK)new ObjectUuidPK(companyId), "agentPaybill_import");
        if (!isPermission) {
            logger.error((Object)("\u5f53\u524d\u7ec4\u7ec7\u6ca1\u6709\u5bfc\u5165\u6743\u9650,\u5f53\u524d\u8c03\u7528\u8005id=" + ctx.getCaller() + ",companyId=" + companyId));
            throw new CasWebException(CasWebException.NO_COMPANY_IMPORT_AUTHRIZED);
        }
        isPermission = CASWebHelper.hasFunctionPermission(ctx, ctx.getCaller(), (IObjectPK)new ObjectUuidPK(companyId), "agentPaybill_addnew");
        if (!isPermission) {
            logger.error((Object)("\u5f53\u524d\u7ec4\u7ec7\u6ca1\u6709\u65b0\u589e\u6743\u9650,\u5f53\u524d\u8c03\u7528\u8005id=" + ctx.getCaller() + ",companyId=" + companyId));
            throw new CasWebException(CasWebException.NO_COMPANY_ADDNEW_AUTHRIZED);
        }
        CompanyOrgUnitInfo company_temp = new CompanyOrgUnitInfo();
        company_temp.setId(BOSUuid.read((String)companyId));
        CurrencyInfo baseCurrency = contextHelper.getCompanyBaseCurrency(company_temp);
        Integer datataskMode = (Integer)this.getContextParameter().get("DATATASKMODE");
        int mode = datataskMode;
        if (this.infoMap.containsKey(this.curKey)) {
            head = (AgentPayBillInfo)this.infoMap.get(this.curKey);
        } else {
            head = this.getHeadInfo(ctx, mode, number, companyId);
            if (EmptyUtil.isEmpty((CoreBaseInfo)head.getCompany())) {
                head.setCompany(currCompany);
            }
            head = (AgentPayBillInfo)this.parseHead(hsData, ctx, head);
            this.infoMap.put(this.curKey, head);
        }
        String headId = head.getId() == null ? null : head.getId().toString();
        Integer fseq = this.seqMap.get(this.curKey) == null ? new Integer(1) : (Integer)this.seqMap.get(this.curKey);
        entry = this.getEntryInfo(ctx, mode, headId, fseq.toString());
        this.seqMap.put(this.curKey, new Integer(fseq + 1));
        entry = (AgentPayBillEntryInfo)this.parseEntry(hsData, ctx, entry, currCompany);
        entry.setSeq(fseq);
        AgentPayBillEntryCollection coll = head.getEntrys();
        int collSize = coll.size();
        if (coll != null && coll.size() > 0) {
            for (int i = 0; i < collSize; ++i) {
                AgentPayBillEntryInfo entryInfo = coll.get(i);
                if (entryInfo.getSeq() == entry.getSeq()) {
                    coll.set(i, entry);
                } else {
                    if (entry.getSeq() <= collSize) continue;
                    coll.add(entry);
                }
                break;
            }
        } else {
            coll.add(entry);
        }
        int scale = head.getCurrency().getPrecision();
        BigDecimal rate = head.getExchangeRate();
        int round = 4;
        AgentPayBillEntryCollection col = head.getEntrys();
        if (col != null) {
            BigDecimal amt = FMConstants.ZERO;
            BigDecimal amtLoc = FMConstants.ZERO;
            for (int i = 0; i < col.size(); ++i) {
                AgentPayBillEntryInfo entryInfo = col.get(i);
                amt = amt.add(entryInfo.getAmount()).setScale(scale, round);
            }
            head.setAmount(amt);
            amtLoc = amt.multiply(rate).setScale(baseCurrency.getPrecision(), round);
            head.setLocalAmount(amtLoc);
            head.setCount(head.getEntrys().size());
            head.setActualAmount(FMConstants.ZERO);
        }
        this.getVerify().verifyHead(ctx, (CoreBaseInfo)head);
        return head;
    }

    private AgentPayBillEntryInfo getEntryInfo(Context ctx, int mode, String parentId, String FSeq) throws BOSException, EASBizException {
        if (mode == 16 || mode == 128) {
            if (parentId == null || FSeq == null) {
                return new AgentPayBillEntryInfo();
            }
            try {
                IAgentPayBillEntry iAgentPayBillEntry = AgentPayBillEntryFactory.getLocalInstance(ctx);
                AgentPayBillEntryCollection coll = iAgentPayBillEntry.getAgentPayBillEntryCollection("where parent = '" + parentId + "' and seq = '" + FSeq + "'");
                if (coll != null && coll.size() > 0) {
                    return coll.get(0);
                }
                return new AgentPayBillEntryInfo();
            }
            catch (Exception e) {
                logger.error((Object)e);
                throw new BOSException(ResourceBase.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"15_AgentPayBillDataImport", (Locale)ctx.getLocale()));
            }
        }
        if (mode == 8) {
            return new AgentPayBillEntryInfo();
        }
        return new AgentPayBillEntryInfo();
    }

    private AgentPayBillInfo getHeadInfo(Context ctx, int mode, String number, String companyId) throws BOSException, EASBizException {
        if (mode == 16 || mode == 128) {
            if (companyId == null || number == null) {
                return new AgentPayBillInfo();
            }
            try {
                IAgentPayBill iAgentPayBill = (IAgentPayBill)this.getController(ctx);
                AgentPayBillCollection coll = iAgentPayBill.getAgentPayBillCollection("where number = '" + number + "' and company.id = '" + companyId + "'");
                if (coll != null && coll.size() > 0) {
                    return coll.get(0);
                }
                return new AgentPayBillInfo();
            }
            catch (Exception e) {
                logger.error((Object)e);
                throw new BOSException(ResourceBase.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"15_AgentPayBillDataImport", (Locale)ctx.getLocale()));
            }
        }
        if (mode == 8) {
            return new AgentPayBillInfo();
        }
        return new AgentPayBillInfo();
    }

    private CoreBaseInfo parseHead(Hashtable hsData, Context ctx, AgentPayBillInfo info) throws BOSException, EASBizException {
        this.prepareImport(ctx, (IObjectValue)info, hsData);
        Object data = null;
        data = this.getData(hsData, "Fnumber");
        if (data != null && data.toString().trim().length() > 0) {
            info.setNumber(data.toString());
        }
        if ((data = this.getData(hsData, "FBizDate")) == null || data.toString().trim().length() <= 0) {
            throw new BOSException(ResourceBase.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"16_AgentPayBillDataImport", (Locale)ctx.getLocale()));
        }
        info.setBizDate(RecAndPayDataImportUtil2.objToDate(ctx, data));
        data = this.getData(hsData, "FCurrencyID");
        if (data != null && data.toString().trim().length() > 0) {
            info.setCurrency(RecAndPayDataImportUtil2.getCurrencyByNumber(ctx, data.toString()));
        } else {
            try {
                info.setCurrency(ContextHelperFactory.getLocalInstance((Context)ctx).getCompanyBaseCurrency(info.getCompany()));
            }
            catch (Exception e) {
                throw new BOSException(ResourceBase.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"17_AgentPayBillDataImport", (Locale)ctx.getLocale()));
            }
        }
        data = this.getData(hsData, "FExchangeRate");
        if (data != null && data.toString().trim().length() > 0) {
            info.setExchangeRate(TypeConversionUtils.objToBigDecimal((Object)data));
        }
        if ((data = this.getData(hsData, "FPayerAccountID")) != null && data.toString().trim().length() > 0) {
            info.setPayerAccount(RecAndPayDataImportUtil2.getAccountByNumber(ctx, ResourceBase.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"18_AgentPayBillDataImport", (Locale)ctx.getLocale()), info.getCompany().getId().toString(), null, data.toString()));
        }
        if ((data = this.getData(hsData, "FPayBankAccountID")) != null && data.toString().trim().length() > 0) {
            AccountBankInfo accountBank = RecAndPayDataImportUtil2.getAccountBankByNumber(ctx, ResourceBase.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"19_AgentPayBillDataImport", (Locale)ctx.getLocale()), info.getCompany().getId().toString(), data.toString(), true, false);
            info.setPayBankAccount(accountBank);
            if (accountBank != null) {
                info.setPayerBank(BankFactory.getLocalInstance((Context)ctx).getBankInfo((IObjectPK)new ObjectUuidPK(accountBank.getBank().getId())));
            }
        }
        if ((data = this.getData(hsData, "FCostCenterID")) != null && data.toString().trim().length() > 0) {
            CostCenterOrgUnitInfo costCenter = AgentPayBillDataImportUtil.getCostCenterByNumber((String)data, ctx);
            info.setCostCenter(costCenter);
        }
        if ((data = this.getData(hsData, "FFeeTypeID")) != null && data.toString().trim().length() > 0) {
            FeeTypeInfo feeType = AgentPayBillDataImportUtil.getFeeTypeByNumber((String)data, ctx);
            info.setFeeType(feeType);
        }
        if ((data = this.getData(hsData, "FSettlementTypeID")) != null && data.toString().trim().length() > 0) {
            SettlementTypeInfo settleType = RecAndPayDataImportUtil2.getSettlementTypeByNumber(data.toString(), ctx);
            this.payThroughBE = settleType.isPayThroughBE();
            info.setSettlementType(settleType);
        }
        if ((data = this.getData(hsData, "FSettleNumber")) != null && data.toString().trim().length() > 0) {
            info.setSettleNumber(data.toString());
        }
        if ((data = this.getData(hsData, "FOppAccountID")) != null && data.toString().trim().length() > 0) {
            info.setOppAccount(AgentPayBillDataImportUtil.getAccountByNumber(ctx, ResourceBase.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"20_AgentPayBillDataImport", (Locale)ctx.getLocale()), info.getCompany().getId().toString(), null, data.toString()));
        }
        if ((data = this.getData(hsData, "FUsage")) != null && data.toString().trim().length() > 0) {
            info.setUsage(data.toString());
        }
        if (info.getBillStatus() == null) {
            info.setBillStatus(BillStatusEnum.SAVE);
        }
        info.setFivouchered(false);
        info.setIsCommitToBE(false);
        data = this.getData(hsData, "FBgItemNumber");
        if (data != null && data.toString().trim().length() > 0) {
            BgItemInfo bgItemInfo = RecAndPayDataImportUtil2.getBgItemByNumber(data.toString(), ResourceBase.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"21_AgentPayBillDataImport", (Locale)ctx.getLocale()), ctx);
            info.setBgItemNumber(data.toString());
            info.setBgItemId(bgItemInfo.getId().toString());
            info.setBgItemName(bgItemInfo.getName());
        }
        return info;
    }

    public void submitHead(CoreBaseInfo coreBaseInfo, Context ctx) throws BOSException {
        try {
            AgentPayBillFactory.getLocalInstance(ctx).save(coreBaseInfo);
        }
        catch (Exception e) {
            throw new BOSException(e.getMessage());
        }
    }

    private CoreBaseInfo parseEntry(Hashtable hsData, Context ctx, AgentPayBillEntryInfo info, CompanyOrgUnitInfo company) throws BOSException {
        this.prepareImport(ctx, (IObjectValue)info, hsData, "entrys");
        Object data = null;
        data = this.getData(hsData, "FRecNameID");
        if (data != null && data.toString().trim().length() > 0) {
            info.setRecName(data.toString());
        }
        if ((data = this.getData(hsData, "FRemark")) != null && data.toString().trim().length() > 0) {
            info.setRemark(data.toString());
        }
        if ((data = this.getData(hsData, "FEntrys_BgItemNumber")) != null && data.toString().trim().length() > 0) {
            BgItemInfo bgItemInfo = RecAndPayDataImportUtil2.getBgItemByNumber(data.toString(), ResourceBase.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"23_AgentPayBillDataImport", (Locale)ctx.getLocale()), ctx);
            info.setBgItemNumber(data.toString());
            info.setBgItemId(bgItemInfo.getId().toString());
            info.setBgItemName(bgItemInfo.getName());
        }
        CurrencyInfo currency = null;
        data = this.getData(hsData, "FCurrencyID");
        if (data != null && data.toString().trim().length() > 0) {
            currency = RecAndPayDataImportUtil2.getCurrencyByNumber(ctx, data.toString());
        } else {
            try {
                currency = ContextHelperFactory.getLocalInstance((Context)ctx).getCompanyBaseCurrency(company);
            }
            catch (Exception e) {
                throw new BOSException(ResourceBase.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"481_AgentPayBillDataImport", (Locale)ctx.getLocale()));
            }
        }
        data = this.getData(hsData, "FEntryOppAccountID");
        if (data != null && data.toString().trim().length() > 0) {
            info.setOppAccount(AgentPayBillDataImportUtil.getAccountByNumber(ctx, ResourceBase.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"20_AgentPayBillDataImport", (Locale)ctx.getLocale()), company.getId().toString(), null, data.toString()));
        }
        if ((data = this.getData(hsData, "FEntryCostCenterID")) != null && data.toString().trim().length() > 0) {
            CostCenterOrgUnitInfo costCenter = AgentPayBillDataImportUtil.getCostCenterByNumber((String)data, ctx);
            info.setCostCenter(costCenter);
        }
        if ((data = this.getData(hsData, "FRECBANKID")) != null && data.toString().trim().length() > 0) {
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("name", data, CompareType.EQUALS));
            filter.getFilterItems().add(new FilterItemInfo("state", (Object)1, CompareType.EQUALS));
            view.setFilter(filter);
            BEBankCollection coll = BEBankFactory.getLocalInstance((Context)ctx).getBEBankCollection(view);
            if (!EmptyUtil.isEmpty((AbstractObjectCollection)coll)) {
                info.setRecBankName(coll.get(0).getName());
            } else {
                EntityViewInfo nview = new EntityViewInfo();
                FilterInfo nfilter = new FilterInfo();
                nfilter.getFilterItems().add(new FilterItemInfo("number", data, CompareType.EQUALS));
                nfilter.getFilterItems().add(new FilterItemInfo("state", (Object)1, CompareType.EQUALS));
                nview.setFilter(nfilter);
                BEBankCollection ncoll = BEBankFactory.getLocalInstance((Context)ctx).getBEBankCollection(nview);
                if (!EmptyUtil.isEmpty((AbstractObjectCollection)ncoll)) {
                    info.setRecBankName(ncoll.get(0).getName());
                } else {
                    info.setRecBankName(data.toString());
                }
            }
        }
        if ((data = this.getData(hsData, "FExpenseTypeID")) != null && data.toString().trim().length() > 0) {
            ExpenseTypeInfo expenseType = AgentPayBillDataImportUtil.getExpenseTypeByNumber((String)data, ctx);
            info.setExpenseType(expenseType);
        }
        data = this.getData(hsData, "FRecBankAccountID");
        info.setRecBankAccount(data.toString());
        data = this.getData(hsData, "FRECPROVINCE");
        if ((data == null || data.toString().trim().length() <= 0) && this.payThroughBE) {
            throw new BOSException(ResourceBase.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"RecProvinceCityNotNull", (Locale)ctx.getLocale()));
        }
        info.setRecProvince(data.toString());
        data = this.getData(hsData, "FRECCITY");
        if ((data == null || data.toString().trim().length() <= 0) && this.payThroughBE) {
            throw new BOSException(ResourceBase.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"RecProvinceCityNotNull", (Locale)ctx.getLocale()));
        }
        info.setRecCity(data.toString());
        data = this.getData(hsData, "FEntryAmount");
        if (data != null && data.toString().trim().length() > 0 && !data.toString().trim().equals(SHREntryAmount)) {
            try {
                if (data.toString().contains(",")) {
                    Double douData = new DecimalFormat().parse(data.toString()).doubleValue();
                    info.setAmount(new BigDecimal(douData).setScale(currency.getPrecision(), 4));
                } else {
                    info.setAmount(new BigDecimal(data.toString()).setScale(currency.getPrecision(), 4));
                }
            }
            catch (Exception e) {
                throw new BOSException(ResourceBase.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"24_AgentPayBillDataImport", (Locale)ctx.getLocale()));
            }
        }
        return info;
    }

    @Override
    protected String getTemplateNumber() {
        return "AgentPayBill";
    }

    public FilterInfo getExportFilterForQuery(Context ctx) {
        FilterInfo filter = new FilterInfo();
        Object obj = this.getContextParameter().get("filter");
        if (obj instanceof FilterInfo) {
            FilterInfo filter1 = (FilterInfo)obj;
            try {
                filter.mergeFilter(filter1, "AND");
            }
            catch (BOSException e) {
                logger.error((Object)e);
            }
        }
        return filter;
    }

    public String getExportQueryInfo(Context ctx) {
        return "com.kingdee.eas.fi.cas.AgentPayBillExportQuery";
    }

    @Override
    public Hashtable exportTransmit(IRowSet rs, Context ctx) throws TaskExternalException {
        Hashtable<String, Object> result = new Hashtable<String, Object>();
        try {
            String entryBgItemNumber;
            String entryOppAccount;
            String costCenter;
            String recCity;
            String recProvince;
            String recBankName;
            String remark;
            String bankCheckFlag;
            String expenseType;
            String recBankAccount;
            String recName;
            String bgItem;
            String description;
            String oppAccount;
            String costcenter;
            String settlementNumber;
            String settlementType;
            BigDecimal count;
            BigDecimal actualAmt;
            String feeType;
            String payerBank;
            String payerAccountBank;
            String payerAccount;
            BigDecimal exchangeRate;
            String currency;
            BigDecimal actualLocalAmt;
            Date bizDate;
            String number = this.getString(rs, "number");
            if (number != null) {
                result.put("Fnumber", number);
            }
            String company = this.getString(rs, "company.number");
            if (number != null) {
                result.put("FCompanyId", company);
            }
            if ((bizDate = rs.getDate("bizDate")) != null) {
                result.put("FBizDate", DateTimeUtils.format((java.util.Date)bizDate, (String)"yyyy-MM-dd"));
            }
            if ((actualLocalAmt = rs.getBigDecimal("LocalAmount")) != null) {
                result.put("FLocalAmount", actualLocalAmt);
            }
            if ((currency = this.getString(rs, "currency.number")) != null) {
                result.put("FCurrencyID", currency);
            }
            if ((exchangeRate = rs.getBigDecimal("ExchangeRate")) != null) {
                result.put("FExchangeRate", exchangeRate);
            }
            if ((payerAccount = this.getString(rs, "payerAccount.number")) != null) {
                result.put("FPayerAccountID", payerAccount);
            }
            if ((payerAccountBank = this.getString(rs, "PayBankAccount.number")) != null) {
                result.put("FPayBankAccountID", payerAccountBank);
            }
            if ((payerBank = this.getString(rs, "payerBank.number")) != null) {
                result.put("FPayerBankID", payerBank);
            }
            if ((feeType = this.getString(rs, "FeeType.number")) != null) {
                result.put("FFeeTypeID", feeType);
            }
            if ((actualAmt = rs.getBigDecimal("Amount")) != null) {
                result.put("FAmount", actualAmt);
            }
            if ((count = rs.getBigDecimal("Count")) != null) {
                result.put("FCount", count);
            }
            if ((settlementType = this.getString(rs, "SettlementType.number")) != null) {
                result.put("FSettlementTypeID", settlementType);
            }
            if ((settlementNumber = this.getString(rs, "SettleNumber")) != null) {
                result.put("FSettleNumber", settlementNumber);
            }
            if ((costcenter = this.getString(rs, "CostCenter.number")) != null) {
                result.put("FCostCenterID", costcenter);
            }
            if ((oppAccount = this.getString(rs, "OppAccount.number")) != null) {
                result.put("FOppAccountID", oppAccount);
            }
            if ((description = this.getString(rs, "Usage")) != null) {
                result.put("FUsage", description);
            }
            if ((bgItem = this.getString(rs, "BgItemNumber")) != null) {
                result.put("FBgItemNumber", bgItem);
            }
            if ((recName = rs.getString("entrys.RecName")) != null) {
                result.put("FRecNameID", recName);
            }
            if ((recBankAccount = rs.getString("entrys.RecBankAccount")) != null) {
                result.put("FRecBankAccountID", recBankAccount);
            }
            if ((expenseType = rs.getString("ExpenseType.number")) != null) {
                result.put("FExpenseTypeID", expenseType);
            }
            if ((bankCheckFlag = rs.getString("bankCheckFlag")) != null) {
                result.put("FBankCheckFlag", bankCheckFlag);
            }
            if ((remark = rs.getString("entrys.Remark")) != null) {
                result.put("FRemark", remark);
            }
            if ((recBankName = rs.getString("entrys.recBankName")) != null) {
                result.put("FRECBANKID", recBankName);
            }
            if ((recProvince = rs.getString("entrys.recProvince")) != null) {
                result.put("FRECPROVINCE", recProvince);
            }
            if ((recCity = rs.getString("entrys.recCity")) != null) {
                result.put("FRECCITY", recCity);
            }
            if ((costCenter = rs.getString("CostCenter1.number")) != null) {
                result.put("FEntryCostCenterID", costCenter);
            }
            if ((entryOppAccount = this.getString(rs, "OppAccount1.number")) != null) {
                result.put("FEntryOppAccountID", entryOppAccount);
            }
            if ((entryBgItemNumber = this.getString(rs, "entrys.BgItemNumber")) != null) {
                result.put("FEntrys_BgItemNumber", entryBgItemNumber);
            }
            if (rs.getString("sourceType").equals("SHR")) {
                String companyID = rs.getString("company.id");
                boolean encryption = ContextHelperFactory.getRemoteInstance().getBooleanParam("CS112", (IObjectPK)new ObjectUuidPK(companyID));
                if (encryption) {
                    IRowSetMetaData rsmd = rs.getRowSetMetaData();
                    rsmd.setColumnType(rsmd.getColumnIndex("entrys.amount"), 1);
                    rs.updateString("entrys.amount", SHREntryAmount);
                } else {
                    BigDecimal FEntryActualAmt = rs.getBigDecimal("entrys.Amount");
                    if (FEntryActualAmt != null) {
                        result.put("FEntryAmount", FEntryActualAmt);
                    }
                }
            } else {
                BigDecimal FEntryActualAmt = rs.getBigDecimal("entrys.Amount");
                if (FEntryActualAmt != null) {
                    result.put("FEntryAmount", FEntryActualAmt);
                }
            }
        }
        catch (SQLException e) {
            logger.error((Object)e);
        }
        return result;
    }

    public String getEntryName() {
        return "entrys";
    }

    public String getMainField() {
        return "Fnumber";
    }
}

