/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.cas.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.dao.query.QueryExecutorFactory;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.bot.BOTRelationCollection;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.function.WfEventListenerStateManager;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.bos.workflow.ProcessInstInfo;
import com.kingdee.bos.workflow.exception.biz.WfBizException;
import com.kingdee.bos.workflow.service.ormrpc.EnactmentServiceFactory;
import com.kingdee.bos.workflow.service.ormrpc.IEnactmentService;
import com.kingdee.eas.base.btp.BTPManagerFactory;
import com.kingdee.eas.base.btp.IBTPManager;
import com.kingdee.eas.base.core.Constants;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.base.core.util.NumberRuleUtil;
import com.kingdee.eas.base.netctrl.IMutexServiceControl;
import com.kingdee.eas.base.netctrl.MutexServiceControlFactory;
import com.kingdee.eas.base.permission.IDSecondAuthorizeFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.base.security.EASSignatureFactory;
import com.kingdee.eas.base.security.IEASSignature;
import com.kingdee.eas.base.wssc.BillImageFacadeFactory;
import com.kingdee.eas.base.wssc.IBillImageFacade;
import com.kingdee.eas.basedata.assistant.AccountBankException;
import com.kingdee.eas.basedata.assistant.AccountBankFactory;
import com.kingdee.eas.basedata.assistant.AccountBankGroupInfo;
import com.kingdee.eas.basedata.assistant.AccountBankInfo;
import com.kingdee.eas.basedata.assistant.AccountMgrStrategyFactory;
import com.kingdee.eas.basedata.assistant.AccountMgrStrategyInfo;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.OverdraftCtrlEnum;
import com.kingdee.eas.basedata.assistant.SettlementTypeFactory;
import com.kingdee.eas.basedata.assistant.SettlementTypeInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitCollection;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.cas.AgentPayBillCollection;
import com.kingdee.eas.fi.cas.AgentPayBillEntryInfo;
import com.kingdee.eas.fi.cas.AgentPayBillFactory;
import com.kingdee.eas.fi.cas.AgentPayBillInfo;
import com.kingdee.eas.fi.cas.ArApRecPayException;
import com.kingdee.eas.fi.cas.BillStatusEnum;
import com.kingdee.eas.fi.cas.CasConstants;
import com.kingdee.eas.fi.cas.CasException;
import com.kingdee.eas.fi.cas.CasForArApUtil;
import com.kingdee.eas.fi.cas.CasWebException;
import com.kingdee.eas.fi.cas.IAgentPayBill;
import com.kingdee.eas.fi.cas.InnerCashFacadeFactory;
import com.kingdee.eas.fi.cas.PaymentBillFactory;
import com.kingdee.eas.fi.cas.PaymentBillInfo;
import com.kingdee.eas.fi.cas.RecPayException;
import com.kingdee.eas.fi.cas.ReceivingBillInfo;
import com.kingdee.eas.fi.cas.app.AbstractAgentPayBillWebFacadeControllerBean;
import com.kingdee.eas.fi.cas.basedata.CasUtilFacadeFactory;
import com.kingdee.eas.fi.cas.basedata.ICasUtilFacade;
import com.kingdee.eas.fi.cas.client.CasRecPayHandler;
import com.kingdee.eas.fi.cas.model.BatchExecuteResult;
import com.kingdee.eas.fi.cas.utils.CASWebHelper;
import com.kingdee.eas.fi.cas.utils.CASWebUtil;
import com.kingdee.eas.fi.cas.utils.JournalWebUtil;
import com.kingdee.eas.fi.cas.utils.PeriodHelper;
import com.kingdee.eas.fm.be.BEException;
import com.kingdee.eas.fm.be.BankPayingBillStateEnum;
import com.kingdee.eas.fm.be.BatchPayRuleFactory;
import com.kingdee.eas.fm.be.BatchPayRuleInfo;
import com.kingdee.eas.fm.be.CertTypeEnum;
import com.kingdee.eas.fm.common.FMConstants;
import com.kingdee.eas.fm.fs.TransUpBillInfo;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.CoreBillBaseInfo;
import com.kingdee.eas.util.EASCommonResource;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class AgentPayBillWebFacadeControllerBean
extends AbstractAgentPayBillWebFacadeControllerBean {
    private static final long serialVersionUID = -7330216274356414072L;
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fi.cas.app.AgentPayBillWebFacadeControllerBean");
    private static final String OPERATESTATE = "operateState";
    private static final String CASRES = "com.kingdee.eas.fi.cas.CASAutoGenerateResource";

    @Override
    protected Map<String, Object> _getSumInfo(Context ctx, String filter, String selectedIds) throws BOSException, EASBizException {
        ICasUtilFacade casUtil = CasUtilFacadeFactory.getLocalInstance(ctx);
        CompanyOrgUnitCollection orgUnitCollection = casUtil.getAuthrizedCompanyOrg(ctx.getCaller().toString(), "agentPaybill_view", false);
        StringBuffer where = new StringBuffer("company.id in ('NE',");
        for (int i = 0; i < orgUnitCollection.size(); ++i) {
            where.append("'" + orgUnitCollection.get(i).getId().toString() + "',");
        }
        where.deleteCharAt(where.length() - 1);
        where.append(")");
        filter = filter == null || filter.equals("") ? where.toString() : filter + " AND " + where.toString();
        IQueryExecutor queryExecutor = QueryExecutorFactory.getLocalInstance((Context)ctx, (IMetaDataPK)new MetaDataPK("com.kingdee.eas.fi.cas.CasAgentPayBillSumQuery"));
        queryExecutor.setObjectView("SELECT billCount,moneySum where " + filter);
        logger.info((Object)("AgentPayBill SumInfo SQL: " + queryExecutor.getSQL()));
        IRowSet rowSet = queryExecutor.executeQuery();
        HashMap<String, Object> result = new HashMap<String, Object>();
        try {
            rowSet.next();
            result.put("billCount", rowSet.getBigDecimal("billCount"));
            result.put("moneySum", rowSet.getBigDecimal("moneySum"));
            result.put("error", 0);
        }
        catch (Exception e) {
            result.put("error", 1);
            result.put("msg", e.getMessage());
            e.printStackTrace();
        }
        HashMap<String, BigDecimal> idMap = new HashMap<String, BigDecimal>();
        queryExecutor.setObjectView("SELECT id,LocalAmount where " + filter);
        try {
            rowSet = queryExecutor.executeQuery();
            while (rowSet.next()) {
                idMap.put(rowSet.getString("id"), rowSet.getBigDecimal("LocalAmount"));
            }
            result.put("idMap", idMap);
        }
        catch (Exception e) {
            result.put("error", 1);
            result.put("msg", e.getMessage());
            e.printStackTrace();
        }
        StringBuffer validIdSql = new StringBuffer("SELECT id where " + filter + " and id in('NE'");
        ArrayList<String> validIdList = new ArrayList<String>();
        if (!selectedIds.equals("")) {
            String[] idArr = selectedIds.split(",");
            for (int i = 0; i < idArr.length; ++i) {
                validIdSql.append(",'" + idArr[i] + "'");
            }
            validIdSql.append(")");
            queryExecutor = QueryExecutorFactory.getLocalInstance((Context)ctx, (IMetaDataPK)new MetaDataPK("com.kingdee.eas.fi.cas.app.AgentPayBillQuery"));
            queryExecutor.setObjectView(validIdSql.toString());
            rowSet = queryExecutor.executeQuery();
            try {
                while (rowSet.next()) {
                    validIdList.add(rowSet.getString("id"));
                }
            }
            catch (Exception e) {
                result.put("error", 1);
                result.put("msg", e.getMessage());
                e.printStackTrace();
            }
        }
        result.put("validIdList", validIdList);
        return result;
    }

    @Override
    protected Map _getAllParam(Context ctx, String companyId, String operateState) throws BOSException, EASBizException {
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put(OPERATESTATE, operateState);
        long dTime = System.currentTimeMillis();
        this.setDefaultCompany(ctx, companyId, param);
        logger.info((Object)("setDefaultCompany: " + (System.currentTimeMillis() - dTime)));
        dTime = System.currentTimeMillis();
        CompanyOrgUnitInfo company = (CompanyOrgUnitInfo)param.get("company");
        companyId = company.getId().toString();
        Map paramValue = CASWebHelper.getParamMap(ctx, companyId, "CS082", "CS041", "CS050", "CS107", "CS112", "MBG_C001");
        param.putAll(paramValue);
        return param;
    }

    protected void setDefaultCompany(Context ctx, String companyId, Map<String, Object> param) throws BOSException, EASBizException {
        ICasUtilFacade casUtil = CasUtilFacadeFactory.getLocalInstance(ctx);
        String operateState = (String)param.get(OPERATESTATE);
        String permItem = "agentPaybill_view";
        if (operateState.equals("ADDNEW")) {
            permItem = "agentPaybill_addnew";
        }
        CompanyOrgUnitCollection orgUnitCollection = casUtil.getAuthrizedCompanyOrg(ctx.getCaller().toString(), permItem, false);
        param.put("authrizedCompanyOrg", orgUnitCollection);
        CompanyOrgUnitInfo company = null;
        if (companyId == null) {
            CompanyOrgUnitInfo defaultOrgUnit = ContextUtil.getCurrentFIUnit((Context)ctx);
            if (defaultOrgUnit.isIsBizUnit()) {
                boolean havePower = false;
                for (int i = 0; i < orgUnitCollection.size(); ++i) {
                    if (!orgUnitCollection.get(i).getId().toString().equals(defaultOrgUnit.getId().toString())) continue;
                    havePower = true;
                    break;
                }
                if (havePower) {
                    company = defaultOrgUnit;
                } else if (orgUnitCollection.size() > 0) {
                    company = orgUnitCollection.get(0);
                }
            } else {
                for (int i = 0; i < orgUnitCollection.size(); ++i) {
                    if (!orgUnitCollection.get(i).isIsBizUnit()) continue;
                    company = orgUnitCollection.get(i);
                    break;
                }
            }
        } else {
            for (int i = 0; i < orgUnitCollection.size(); ++i) {
                if (!orgUnitCollection.get(i).getId().toString().equals(companyId) || !orgUnitCollection.get(i).isIsBizUnit()) continue;
                company = orgUnitCollection.get(i);
                break;
            }
        }
        if (company == null) {
            throw new CasWebException(CasWebException.NO_ORG_AUTHRIZED);
        }
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("baseCurrency.id"));
        sic.add(new SelectorItemInfo("baseCurrency.number"));
        sic.add(new SelectorItemInfo("baseCurrency.name"));
        sic.add(new SelectorItemInfo("baseCurrency.precision"));
        sic.add(new SelectorItemInfo("CU.longNumber"));
        company = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(company.getId().toString()), sic);
        param.put("company", company);
        UserInfo userinfo = ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentUser();
        param.put("userInfo", userinfo);
    }

    @Override
    protected AgentPayBillInfo _createNewModel(Context ctx, String companyId, String operate, String billId, Map param) throws BOSException, EASBizException {
        if (param == null) {
            param = this.getAllParam(ctx, companyId, "ADDNEW");
        }
        AgentPayBillInfo info = null;
        UserInfo userinfo = ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentUser();
        if (operate == null) {
            CompanyOrgUnitInfo addNewDefaultcompany = (CompanyOrgUnitInfo)param.get("company");
            info = new AgentPayBillInfo();
            info.setId(BOSUuid.create((BOSObjectType)info.getBOSType()));
            info.setBizDate(new Date());
            info.setCompany(addNewDefaultcompany);
            info.setCurrency(addNewDefaultcompany.getBaseCurrency());
            info.setCreator(userinfo);
            info.setCreateTime(new Timestamp(System.currentTimeMillis()));
            info.setBillStatus(BillStatusEnum.SAVE);
            info.setBalance(Constants.ZERO);
            info.setCount(0);
            info.setIsCommitToBE(false);
            info.setFivouchered(false);
            info.setPcaVouchered(false);
            AgentPayBillEntryInfo entryInfo = new AgentPayBillEntryInfo();
            entryInfo.setSeq(1);
            entryInfo.setCertType(CertTypeEnum.IDCARD);
            info.getEntrys().add(entryInfo);
        } else if ("copy".equals(operate)) {
            IAgentPayBill iAgentPayBill = AgentPayBillFactory.getLocalInstance(ctx);
            AgentPayBillInfo oldInfo = (AgentPayBillInfo)iAgentPayBill.getValue((IObjectPK)new ObjectUuidPK(billId), this.getSelector());
            info = oldInfo.copy();
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add("expectDealTime");
            AgentPayBillInfo infoCopy = iAgentPayBill.getAgentPayBillInfo((IObjectPK)new ObjectUuidPK(billId), sic);
            info.setExpectDealTime(infoCopy.getExpectDealTime());
            info.setBizDate(new Date());
            info.setCompany(oldInfo.getCompany());
            info.setCreator(userinfo);
            info.setCreateTime(new Timestamp(System.currentTimeMillis()));
        } else if ("genBill".equals(operate)) {
            IAgentPayBill iAgentPayBill = AgentPayBillFactory.getLocalInstance(ctx);
            AgentPayBillInfo oldInfo = (AgentPayBillInfo)iAgentPayBill.getValue((IObjectPK)new ObjectUuidPK(billId), this.getSelector());
            info = oldInfo.generateBill();
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add("expectDealTime");
            AgentPayBillInfo genInfo = iAgentPayBill.getAgentPayBillInfo((IObjectPK)new ObjectUuidPK(billId), sic);
            info.setExpectDealTime(genInfo.getExpectDealTime());
            info.setBizDate(new Date());
            info.setCompany(oldInfo.getCompany());
            info.setCreator(userinfo);
            info.setCreateTime(new Timestamp(System.currentTimeMillis()));
            info.setSourceBillId(billId);
            info.setIsReGenBill(true);
            info.setSourceType(oldInfo.getSourceType());
        }
        return info;
    }

    protected SelectorItemCollection getSelector() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("creator.name"));
        sic.add(new SelectorItemInfo("creator.number"));
        sic.add(new SelectorItemInfo("createTime"));
        sic.add(new SelectorItemInfo("lastUpdateUser.*"));
        sic.add(new SelectorItemInfo("lastUpdateTime"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("bizDate"));
        sic.add(new SelectorItemInfo("description"));
        sic.add(new SelectorItemInfo("entrys.id"));
        sic.add(new SelectorItemInfo("entrys.number"));
        sic.add(new SelectorItemInfo("entrys.RecName"));
        sic.add(new SelectorItemInfo("entrys.recBank.id"));
        sic.add(new SelectorItemInfo("entrys.recBank.name"));
        sic.add(new SelectorItemInfo("entrys.recBank.number"));
        sic.add(new SelectorItemInfo("entrys.ExpenseType.name"));
        sic.add(new SelectorItemInfo("entrys.ExpenseType.number"));
        sic.add(new SelectorItemInfo("entrys.Amount"));
        sic.add(new SelectorItemInfo("entrys.Remark"));
        sic.add(new SelectorItemInfo("entrys.CostCenter.name"));
        sic.add(new SelectorItemInfo("entrys.CostCenter.number"));
        sic.add(new SelectorItemInfo("entrys.OppAccount.name"));
        sic.add(new SelectorItemInfo("entrys.OppAccount.number"));
        sic.add(new SelectorItemInfo("entrys.recProvince"));
        sic.add(new SelectorItemInfo("entrys.recCity"));
        sic.add(new SelectorItemInfo("entrys.isSuccess"));
        sic.add(new SelectorItemInfo("entrys.RecBankAccount"));
        sic.add(new SelectorItemInfo("entrys.BgItemName"));
        sic.add(new SelectorItemInfo("entrys.BgItemNumber"));
        sic.add(new SelectorItemInfo("entrys.BgItemId"));
        sic.add(new SelectorItemInfo("entrys.DifferPalace"));
        sic.add(new SelectorItemInfo("entrys.RecBankName"));
        sic.add(new SelectorItemInfo("entrys.fundFlowItem.id"));
        sic.add(new SelectorItemInfo("entrys.fundFlowItem.number"));
        sic.add(new SelectorItemInfo("entrys.fundFlowItem.name"));
        sic.add(new SelectorItemInfo("entrys.certType"));
        sic.add(new SelectorItemInfo("entrys.certNum"));
        sic.add(new SelectorItemInfo("entrys.state"));
        sic.add(new SelectorItemInfo("entrys.bankReturnInfo"));
        sic.add(new SelectorItemInfo("company.id"));
        sic.add(new SelectorItemInfo("company.number"));
        sic.add(new SelectorItemInfo("company.longNumber"));
        sic.add(new SelectorItemInfo("company.name"));
        sic.add(new SelectorItemInfo("company.isBizUnit"));
        sic.add(new SelectorItemInfo("company.CU"));
        sic.add(new SelectorItemInfo("company.baseCurrency.number"));
        sic.add(new SelectorItemInfo("company.baseCurrency.id"));
        sic.add(new SelectorItemInfo("SettleNumber"));
        sic.add(new SelectorItemInfo("payerBank.name"));
        sic.add(new SelectorItemInfo("Amount"));
        sic.add(new SelectorItemInfo("Count"));
        sic.add(new SelectorItemInfo("LocalAmount"));
        sic.add(new SelectorItemInfo("ActualAmount"));
        sic.add(new SelectorItemInfo("ActualCount"));
        sic.add(new SelectorItemInfo("Usage"));
        sic.add(new SelectorItemInfo("Balance"));
        sic.add(new SelectorItemInfo("company.name"));
        sic.add(new SelectorItemInfo("billStatus"));
        sic.add(new SelectorItemInfo("ExchangeRate"));
        sic.add(new SelectorItemInfo("PayBankAccount.name"));
        sic.add(new SelectorItemInfo("PayBankAccount.number"));
        sic.add(new SelectorItemInfo("PayBankAccount.company"));
        sic.add(new SelectorItemInfo("PayBankAccount.company.id"));
        sic.add(new SelectorItemInfo("PayBankAccount.bank"));
        sic.add(new SelectorItemInfo("PayBankAccount.isByCurrency"));
        sic.add(new SelectorItemInfo("FeeType.name"));
        sic.add(new SelectorItemInfo("FeeType.number"));
        sic.add(new SelectorItemInfo("payerAccount.name"));
        sic.add(new SelectorItemInfo("payerAccount.number"));
        sic.add(new SelectorItemInfo("Currency.*"));
        sic.add(new SelectorItemInfo("CostCenter.name"));
        sic.add(new SelectorItemInfo("CostCenter.number"));
        sic.add(new SelectorItemInfo("SettlementType.name"));
        sic.add(new SelectorItemInfo("SettlementType.number"));
        sic.add(new SelectorItemInfo("RecBankAccount"));
        sic.add(new SelectorItemInfo("OppAccount.name"));
        sic.add(new SelectorItemInfo("OppAccount.number"));
        sic.add(new SelectorItemInfo("BgItemName"));
        sic.add(new SelectorItemInfo("expectDealTime"));
        sic.add(new SelectorItemInfo("BgItemNumber"));
        sic.add(new SelectorItemInfo("BgItemId"));
        sic.add(new SelectorItemInfo("sourceType"));
        sic.add(new SelectorItemInfo("sourceBillId"));
        sic.add(new SelectorItemInfo("isEmergency"));
        return sic;
    }

    @Override
    protected Map _save(Context ctx, AgentPayBillInfo info) throws BOSException, EASBizException {
        HashMap<String, Object> pageModel = new HashMap<String, Object>();
        try {
            IAgentPayBill iAgentPayBill = AgentPayBillFactory.getLocalInstance(ctx);
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add("billStatus");
            if (iAgentPayBill.exists((IObjectPK)new ObjectUuidPK(info.getId().toString()))) {
                AgentPayBillInfo oldInfo = (AgentPayBillInfo)iAgentPayBill.getValue((IObjectPK)new ObjectUuidPK(info.getId().toString()), sic);
                if (this.isStatusChanged(ctx, info)) {
                    throw new RuntimeException(CASWebUtil.getResource(ctx, "BILL_STATUS_CHANGED"));
                }
                boolean isBillInShareFlow = false;
                if (null != info && null != info.getId() && null != info.getBillStatus()) {
                    String billID = info.getId().toString();
                    isBillInShareFlow = CasForArApUtil.isBillInShareFlow(ctx, isBillInShareFlow, billID, info.getBillStatus().getValue(), 11);
                    logger.error((Object)("\u4fdd\u5b58\u5355\u636eID\u4e3a\uff1a" + billID + "\u5355\u636e\u662f\u5426\u5728\u5171\u4eab\u4e2d\uff1a" + isBillInShareFlow));
                    if (!isBillInShareFlow && oldInfo.getBillStatus().getValue() != 10) {
                        throw new RuntimeException(CASWebUtil.getResource(ctx, "BILL_STATUS_NOT_SAVE"));
                    }
                }
            }
            this.verifyBeforeSave(ctx, info);
            IObjectPK pk = this.getSavePk(ctx, iAgentPayBill, info);
            pageModel.put("error", 0);
            pageModel.put("id", pk.toString());
        }
        catch (Exception e) {
            logger.error((Object)e);
            e.printStackTrace();
            pageModel.put("error", 1);
            pageModel.put("msg", e.getMessage());
        }
        return pageModel;
    }

    private boolean isStatusChanged(Context ctx, AgentPayBillInfo info) throws BOSException {
        IAgentPayBill iAgentPayBill = AgentPayBillFactory.getLocalInstance(ctx);
        boolean changed = false;
        AgentPayBillInfo agentPayBillInfo = null;
        AgentPayBillCollection coll = null;
        EntityViewInfo query = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        query.setFilter(filter);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("billStatus");
        sic.add("Fivouchered");
        query.setSelector(sic);
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)info.getId().toString()));
        coll = iAgentPayBill.getAgentPayBillCollection(query);
        if (coll.size() > 0) {
            agentPayBillInfo = coll.get(0);
            if (info.getBillStatus() != agentPayBillInfo.getBillStatus()) {
                changed = true;
            }
            if (info.isFivouchered() != agentPayBillInfo.isFivouchered()) {
                changed = true;
            }
        }
        return changed;
    }

    protected IObjectPK getSavePk(Context ctx, IAgentPayBill iAgentPayBill, AgentPayBillInfo info) throws Exception {
        IObjectPK objectPK = null;
        IBTPManager iBTPManager = BTPManagerFactory.getLocalInstance((Context)ctx);
        BOTRelationCollection btpRelationCollection = CASWebHelper.getBOTRelationColFromExtendProperty(ctx, (IObjectValue)info);
        if (info.get("id") != null && (btpRelationCollection == null || btpRelationCollection.size() == 0)) {
            btpRelationCollection = iBTPManager.getRelationCollection(info.get("id").toString());
        }
        objectPK = btpRelationCollection != null && btpRelationCollection.size() > 0 ? iBTPManager.saveRelations((CoreBillBaseInfo)info, btpRelationCollection) : iAgentPayBill.save((CoreBaseInfo)info);
        return objectPK;
    }

    @Override
    protected BigDecimal _getBalanceValue(Context ctx, String companyId, String acctViewId, String acctBankId, String currencyId, String bizDate) throws BOSException, EASBizException {
        ObjectUuidPK companyPK = companyId == null || companyId.equals("") ? null : new ObjectUuidPK(companyId);
        ObjectUuidPK acctViewPK = acctViewId == null || acctViewId.equals("") ? null : new ObjectUuidPK(acctViewId);
        ObjectUuidPK acctBankPK = acctBankId == null || acctBankId.equals("") ? null : new ObjectUuidPK(acctBankId);
        ObjectUuidPK currencyPK = currencyId == null || currencyId.equals("") ? null : new ObjectUuidPK(currencyId);
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        BigDecimal totalBalance = new BigDecimal("0");
        boolean isBankinterface = false;
        if (currencyPK != null && (acctViewPK != null || acctBankPK != null)) {
            if (!EmptyUtil.isEmpty((Object)acctBankPK)) {
                AccountBankInfo acctBankInfo = AccountBankFactory.getLocalInstance((Context)ctx).getAccountBankInfo((IObjectPK)acctBankPK);
                isBankinterface = acctBankInfo.isIsSetBankInterface();
                String CS132 = ContextHelperFactory.getLocalInstance((Context)ctx).getStringParam("CS132", (IObjectPK)companyPK);
                if ("1".equals(CS132)) {
                    isBankinterface = false;
                }
            }
            if (acctBankPK != null && acctViewPK != null && currencyPK != null && companyPK != null && !isBankinterface) {
                try {
                    totalBalance = InnerCashFacadeFactory.getLocalInstance(ctx).getInstantBalance((IObjectPK)companyPK, (IObjectPK)acctViewPK, (IObjectPK)acctBankPK, (IObjectPK)currencyPK, sdf.parse(bizDate));
                }
                catch (Exception e) {
                    throw new BOSException((Throwable)e);
                }
            } else if (isBankinterface) {
                totalBalance = PaymentBillFactory.getLocalInstance(ctx).getBalanceValue(acctBankId, currencyId);
            }
        }
        if (currencyId != null) {
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("precision"));
            int precision = CurrencyFactory.getLocalInstance((Context)ctx).getCurrencyInfo((IObjectPK)currencyPK, sic).getPrecision();
            totalBalance = totalBalance.setScale(precision, 4);
        }
        return totalBalance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Map _batchAudit(Context ctx, String[] ids) throws BOSException, EASBizException {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("billStatus"));
        sic.add(new SelectorItemInfo("company.name"));
        sic.add(new SelectorItemInfo("company.id"));
        IAgentPayBill agentPayBill = AgentPayBillFactory.getLocalInstance(ctx);
        BatchExecuteResult result = new BatchExecuteResult();
        String summary = CASWebUtil.getResource(ctx, "BILLSUM", new String[]{ids.length + ""});
        int success = 0;
        ArrayList<String> allIdList = new ArrayList<String>();
        for (int i = 0; i < ids.length; ++i) {
            allIdList.add(ids[i]);
        }
        ArrayList<String> correctList = new ArrayList<String>();
        ArrayList<String> lockedList = new ArrayList<String>();
        try {
            this.requesMutexs(ctx, allIdList, correctList, lockedList);
            for (int i = 0; i < ids.length; ++i) {
                AgentPayBillInfo info = agentPayBill.getAgentPayBillInfo((IObjectPK)new ObjectUuidPK(ids[i]), sic);
                HashSet<String> idList = new HashSet<String>();
                idList.add(ids[i]);
                try {
                    if (lockedList.contains(info.getId().toString())) {
                        throw new RuntimeException(CASWebUtil.getResource(ctx, "HAS_LOCKED"));
                    }
                    boolean isPermission = CASWebHelper.hasFunctionPermission(ctx, ctx.getCaller(), (IObjectPK)new ObjectUuidPK(info.getCompany().getId()), "agentPaybill_audit");
                    if (!isPermission) {
                        throw new CasWebException(CasWebException.NO_AUDIT_AUTHRIZED);
                    }
                    if (CASWebHelper.isAdjustPeriod(ctx, info.getCompany())) {
                        throw new RuntimeException(CASWebUtil.getResource(ctx, "IN_ADJUST_PERIOD_SINGLE"));
                    }
                    this.verify(info);
                    if (this.isInWorkFlow(ids[i], ctx)) {
                        result.getDetailMsgList().add(CASWebUtil.getResource(ctx, "474_AGENTPAYBILL_AUDIT_FAILED", new String[]{info.getCompany().getName(), info.getNumber(), CASWebUtil.getResource(ctx, "ALREADY_IN_WORKFLOW")}));
                        continue;
                    }
                    agentPayBill.audit(idList);
                    ++success;
                    continue;
                }
                catch (Exception e) {
                    result.getDetailMsgList().add(CASWebUtil.getResource(ctx, "474_AGENTPAYBILL_AUDIT_FAILED", new String[]{info.getCompany().getName(), info.getNumber(), e.getMessage()}));
                }
            }
        }
        finally {
            if (correctList != null && correctList.size() > 0) {
                MutexServiceControlFactory.getLocalInstance((Context)ctx).batchReleaseObjIDForUpdate(correctList);
            }
        }
        summary = success == ids.length ? summary + CASWebUtil.getResource(ctx, "ALL_AUDIT_SUCCESS") : summary + CASWebUtil.getResource(ctx, "AUDIT_RESULT", new String[]{String.valueOf(success), String.valueOf(ids.length - success)});
        result.setSummaryMsg(summary);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Map _batchUnaudit(Context ctx, String[] ids) throws BOSException, EASBizException {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("billStatus"));
        sic.add(new SelectorItemInfo("Fivouchered"));
        sic.add(new SelectorItemInfo("pcaVouchered"));
        sic.add(new SelectorItemInfo("company.name"));
        sic.add(new SelectorItemInfo("company.id"));
        IAgentPayBill agentPayBill = AgentPayBillFactory.getLocalInstance(ctx);
        BatchExecuteResult result = new BatchExecuteResult();
        String summary = CASWebUtil.getResource(ctx, "BILLSUM", new String[]{ids.length + ""});
        int success = 0;
        ArrayList<String> allIdList = new ArrayList<String>();
        for (int i = 0; i < ids.length; ++i) {
            allIdList.add(ids[i]);
        }
        ArrayList<String> correctList = new ArrayList<String>();
        ArrayList<String> lockedList = new ArrayList<String>();
        try {
            this.requesMutexs(ctx, allIdList, correctList, lockedList);
            for (int i = 0; i < ids.length; ++i) {
                AgentPayBillInfo info = agentPayBill.getAgentPayBillInfo((IObjectPK)new ObjectUuidPK(ids[i]), sic);
                HashSet<String> idList = new HashSet<String>();
                idList.add(ids[i]);
                try {
                    if (lockedList.contains(info.getId().toString())) {
                        throw new RuntimeException(CASWebUtil.getResource(ctx, "HAS_LOCKED"));
                    }
                    boolean isPermission = CASWebHelper.hasFunctionPermission(ctx, ctx.getCaller(), (IObjectPK)new ObjectUuidPK(info.getCompany().getId()), "agentPaybill_antiaudit");
                    if (!isPermission) {
                        throw new CasWebException(CasWebException.NO_UNAUDIT_AUTHRIZED);
                    }
                    if (!info.getBillStatus().equals((Object)BillStatusEnum.AUDITED)) {
                        throw new RuntimeException(CASWebUtil.getResource(ctx, "478_AGENTPAYBILL_CANNOT_UNAUDIT", new String[]{info.getBillStatus().getAlias()}));
                    }
                    if (info.isFivouchered()) {
                        throw new RecPayException(RecPayException.VOUCHER_ANTIAUDIT);
                    }
                    if (info.isPcaVouchered()) {
                        throw new RecPayException(RecPayException.PCAVOUCHER_ANTIAUDIT);
                    }
                    if (this.isInWorkFlow(ids[i], ctx)) {
                        result.getDetailMsgList().add(CASWebUtil.getResource(ctx, "475_AGENTPAYBILL_UNAUDIT_FAILED", new String[]{info.getCompany().getName(), info.getNumber(), CASWebUtil.getResource(ctx, "ALREADY_IN_WORKFLOW")}));
                    }
                    agentPayBill.antiAudit(idList);
                    ++success;
                    continue;
                }
                catch (Exception e) {
                    result.getDetailMsgList().add(CASWebUtil.getResource(ctx, "475_AGENTPAYBILL_UNAUDIT_FAILED", new String[]{info.getCompany().getName(), info.getNumber(), e.getMessage()}));
                }
            }
        }
        finally {
            if (correctList != null && correctList.size() > 0) {
                MutexServiceControlFactory.getLocalInstance((Context)ctx).batchReleaseObjIDForUpdate(correctList);
            }
        }
        summary = success == ids.length ? summary + CASWebUtil.getResource(ctx, "ALL_UNAUDIT_SUCCESS") : summary + CASWebUtil.getResource(ctx, "UNAUDIT_RESULT", new String[]{String.valueOf(success), String.valueOf(ids.length - success)});
        result.setSummaryMsg(summary);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Map _auditById(Context ctx, String id) throws BOSException, EASBizException {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("company.name"));
        sic.add(new SelectorItemInfo("company.id"));
        IAgentPayBill agentPayBill = AgentPayBillFactory.getLocalInstance(ctx);
        BatchExecuteResult result = new BatchExecuteResult();
        String summary = CASWebUtil.getResource(ctx, "AUDIT_SUCCESS");
        AgentPayBillInfo info = agentPayBill.getAgentPayBillInfo((IObjectPK)new ObjectUuidPK(id), sic);
        HashSet<String> idList = new HashSet<String>();
        idList.add(id);
        IMutexServiceControl iMutex = MutexServiceControlFactory.getLocalInstance((Context)ctx);
        boolean isLock = false;
        try {
            isLock = iMutex.requestObjIDForUpdate(id);
            if (!isLock) {
                throw new RuntimeException(CASWebUtil.getResource(ctx, "HAS_LOCKED"));
            }
            boolean isPermission = CASWebHelper.hasFunctionPermission(ctx, ctx.getCaller(), (IObjectPK)new ObjectUuidPK(info.getCompany().getId()), "agentPaybill_audit");
            if (!isPermission) {
                throw new CasWebException(CasWebException.NO_AUDIT_AUTHRIZED);
            }
            if (CASWebHelper.isAdjustPeriod(ctx, info.getCompany())) {
                throw new RuntimeException(CASWebUtil.getResource(ctx, "IN_ADJUST_PERIOD_SINGLE"));
            }
            if (this.isInWorkFlow(id, ctx)) {
                result.setError(1);
                result.getDetailMsgList().add(CASWebUtil.getResource(ctx, "AUDIT_FAILED", new String[]{CASWebUtil.getResource(ctx, "ALREADY_IN_WORKFLOW")}));
                summary = CASWebUtil.getResource(ctx, "AUDIT_FAILED", new String[]{CASWebUtil.getResource(ctx, "ALREADY_IN_WORKFLOW")});
            } else {
                agentPayBill.audit(idList);
                result.setError(0);
            }
        }
        catch (Exception e) {
            logger.equals(e);
            result.setError(1);
            result.getDetailMsgList().add(CASWebUtil.getResource(ctx, "AUDIT_FAILED", new String[]{e.getMessage()}));
            summary = CASWebUtil.getResource(ctx, "AUDIT_FAILED", new String[]{e.getMessage()});
        }
        finally {
            if (isLock) {
                iMutex.releaseObjIDForUpdate(id);
            }
        }
        result.setSummaryMsg(summary);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Map _unauditById(Context ctx, String id) throws BOSException, EASBizException {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("company.name"));
        sic.add(new SelectorItemInfo("company.id"));
        IAgentPayBill agentPayBill = AgentPayBillFactory.getLocalInstance(ctx);
        BatchExecuteResult result = new BatchExecuteResult();
        String summary = CASWebUtil.getResource(ctx, "UNAUDIT_SUCCESS");
        AgentPayBillInfo info = agentPayBill.getAgentPayBillInfo((IObjectPK)new ObjectUuidPK(id), sic);
        HashSet<String> idList = new HashSet<String>();
        idList.add(id);
        IMutexServiceControl iMutex = MutexServiceControlFactory.getLocalInstance((Context)ctx);
        boolean isLock = false;
        try {
            isLock = iMutex.requestObjIDForUpdate(id);
            if (!isLock) {
                throw new RuntimeException(CASWebUtil.getResource(ctx, "HAS_LOCKED"));
            }
            boolean isPermission = CASWebHelper.hasFunctionPermission(ctx, ctx.getCaller(), (IObjectPK)new ObjectUuidPK(info.getCompany().getId()), "agentPaybill_antiaudit");
            if (!isPermission) {
                throw new CasWebException(CasWebException.NO_UNAUDIT_AUTHRIZED);
            }
            if (CASWebHelper.isAdjustPeriod(ctx, info.getCompany())) {
                throw new RuntimeException(CASWebUtil.getResource(ctx, "IN_ADJUST_PERIOD_SINGLE"));
            }
            if (this.isInWorkFlow(id, ctx)) {
                result.setError(1);
                result.getDetailMsgList().add(CASWebUtil.getResource(ctx, "UNAUDIT_FAILED", new String[]{CASWebUtil.getResource(ctx, "ALREADY_IN_WORKFLOW")}));
                summary = CASWebUtil.getResource(ctx, "UNAUDIT_FAILED", new String[]{CASWebUtil.getResource(ctx, "ALREADY_IN_WORKFLOW")});
            } else {
                agentPayBill.antiAudit(idList);
                result.setError(0);
            }
        }
        catch (Exception e) {
            logger.error((Object)e);
            result.setError(1);
            result.getDetailMsgList().add(CASWebUtil.getResource(ctx, "UNAUDIT_FAILED", new String[]{e.getMessage()}));
            summary = CASWebUtil.getResource(ctx, "UNAUDIT_FAILED", new String[]{e.getMessage()});
        }
        finally {
            if (isLock) {
                iMutex.releaseObjIDForUpdate(id);
            }
        }
        result.setSummaryMsg(summary);
        return result;
    }

    protected void verify(AgentPayBillInfo info) throws RecPayException {
        if (info.getBillStatus() != null) {
            int billStatus = info.getBillStatus().getValue();
            if (billStatus < 11) {
                throw new RecPayException(ArApRecPayException.CANNOT_AUDIT_NOT_SUBMIT);
            }
            if (billStatus >= 12) {
                throw new RecPayException(ArApRecPayException.CANNOT_MULTI_AUDIT);
            }
        }
    }

    @Override
    protected Map _batchDelete(Context ctx, String[] ids) throws BOSException, EASBizException {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("company.name"));
        sic.add(new SelectorItemInfo("company.id"));
        IAgentPayBill agentPayBill = AgentPayBillFactory.getLocalInstance(ctx);
        BatchExecuteResult result = new BatchExecuteResult();
        String summary = CASWebUtil.getResource(ctx, "BILLSUM", new String[]{ids.length + ""});
        int success = 0;
        for (int i = 0; i < ids.length; ++i) {
            AgentPayBillInfo info = agentPayBill.getAgentPayBillInfo((IObjectPK)new ObjectUuidPK(ids[i]), sic);
            try {
                boolean isPermission = CASWebHelper.hasFunctionPermission(ctx, ctx.getCaller(), (IObjectPK)new ObjectUuidPK(info.getCompany().getId()), "agentPaybill_remove");
                if (!isPermission) {
                    throw new CasWebException(CasWebException.NO_DELETE_AUTHRIZED);
                }
                if (CASWebHelper.isAdjustPeriod(ctx, info.getCompany())) {
                    throw new RuntimeException(CASWebUtil.getResource(ctx, "IN_ADJUST_PERIOD_SINGLE"));
                }
                agentPayBill.delete((IObjectPK)new ObjectUuidPK(ids[i]));
                ++success;
                continue;
            }
            catch (WfBizException e) {
                result.getDetailMsgList().add(CASWebUtil.getResource(ctx, "473_AGENTPAYBILL_DELETE_FAILED", new String[]{info.getCompany().getName(), info.getNumber(), CASWebUtil.getResource(ctx, "ALREADY_IN_WORKFLOW")}));
                continue;
            }
            catch (Exception e) {
                result.getDetailMsgList().add(CASWebUtil.getResource(ctx, "473_AGENTPAYBILL_DELETE_FAILED", new String[]{info.getCompany().getName(), info.getNumber(), e.getMessage()}));
            }
        }
        summary = success == ids.length ? summary + CASWebUtil.getResource(ctx, "ALL_DELETE_SUCCESS") : summary + CASWebUtil.getResource(ctx, "DELETE_RESULT", new String[]{String.valueOf(success), String.valueOf(ids.length - success)});
        result.setSummaryMsg(summary);
        return result;
    }

    @Override
    protected Map _deleteById(Context ctx, String id) throws BOSException, EASBizException {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("company.name"));
        sic.add(new SelectorItemInfo("company.id"));
        IAgentPayBill agentPayBill = AgentPayBillFactory.getLocalInstance(ctx);
        BatchExecuteResult result = new BatchExecuteResult();
        String summary = CASWebUtil.getResource(ctx, "327_DELETE_SUCCESS");
        ObjectUuidPK pk = new ObjectUuidPK(id);
        AgentPayBillInfo info = agentPayBill.getAgentPayBillInfo((IObjectPK)pk, sic);
        try {
            boolean isPermission = CASWebHelper.hasFunctionPermission(ctx, ctx.getCaller(), (IObjectPK)new ObjectUuidPK(info.getCompany().getId()), "agentPaybill_remove");
            if (!isPermission) {
                throw new CasWebException(CasWebException.NO_DELETE_AUTHRIZED);
            }
            if (CASWebHelper.isAdjustPeriod(ctx, info.getCompany())) {
                throw new RuntimeException(CASWebUtil.getResource(ctx, "IN_ADJUST_PERIOD_SINGLE"));
            }
            String sourceBillId = info.getSourceBillId();
            if (!EmptyUtil.isEmpty((String)sourceBillId)) {
                BOSUuid sbid = BOSUuid.read((String)sourceBillId);
                if (sbid.getType().equals((Object)new ReceivingBillInfo().getBOSType())) {
                    throw new RecPayException(RecPayException.CANNOTDELETERECFORSOURCE);
                }
                if (sbid.getType().equals((Object)new PaymentBillInfo().getBOSType())) {
                    throw new RecPayException(RecPayException.AGENTPAYBILLNOTDELETE);
                }
                BOSObjectType transUpBillInfo_Type = new TransUpBillInfo().getBOSType();
                if (transUpBillInfo_Type.equals((Object)sbid.getType())) {
                    throw new RecPayException(RecPayException.PAYMENTBILLDELETEERROR, new Object[]{info.getNumber()});
                }
            }
            agentPayBill.delete((IObjectPK)pk);
            result.setError(0);
        }
        catch (WfBizException e) {
            result.setError(1);
            result.getDetailMsgList().add(CASWebUtil.getResource(ctx, "328_DELETE_FAILED", new String[]{CASWebUtil.getResource(ctx, "ALREADY_IN_WORKFLOW")}));
            summary = CASWebUtil.getResource(ctx, "328_DELETE_FAILED", new String[]{CASWebUtil.getResource(ctx, "ALREADY_IN_WORKFLOW")});
        }
        catch (Exception e) {
            result.setError(1);
            result.getDetailMsgList().add(CASWebUtil.getResource(ctx, "328_DELETE_FAILED", new String[]{e.getMessage()}));
            summary = CASWebUtil.getResource(ctx, "328_DELETE_FAILED", new String[]{e.getMessage()});
        }
        result.setSummaryMsg(summary);
        return result;
    }

    private boolean isInWorkFlow(String selectId, Context ctx) {
        try {
            IEnactmentService service2 = EnactmentServiceFactory.createEnactService((Context)ctx);
            ProcessInstInfo[] procInsts = service2.getProcessInstanceByHoldedObjectId(selectId);
            return procInsts != null && procInsts.length != 0;
        }
        catch (Exception e) {
            logger.error((Object)e);
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Map _payById(Context ctx, String id) throws BOSException, EASBizException {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("company.name"));
        sic.add(new SelectorItemInfo("company.id"));
        IAgentPayBill agentPayBill = AgentPayBillFactory.getLocalInstance(ctx);
        BatchExecuteResult result = new BatchExecuteResult();
        String summary = CASWebUtil.getResource(ctx, "PAY_SUCCESS");
        AgentPayBillInfo info = agentPayBill.getAgentPayBillInfo((IObjectPK)new ObjectUuidPK(id), sic);
        HashSet<String> idList = new HashSet<String>();
        idList.add(id);
        IMutexServiceControl iMutex = MutexServiceControlFactory.getLocalInstance((Context)ctx);
        boolean isLock = false;
        try {
            isLock = iMutex.requestObjIDForUpdate(id);
            if (!isLock) {
                throw new RuntimeException(CASWebUtil.getResource(ctx, "HAS_LOCKED"));
            }
            boolean isPermission = CASWebHelper.hasFunctionPermission(ctx, ctx.getCaller(), (IObjectPK)new ObjectUuidPK(info.getCompany().getId()), "agentPaybill_pay");
            if (!isPermission) {
                throw new CasWebException(CasWebException.NO_PAY_AUTHRIZED);
            }
            if (CASWebHelper.isAdjustPeriod(ctx, info.getCompany())) {
                throw new RuntimeException(CASWebUtil.getResource(ctx, "IN_ADJUST_PERIOD_SINGLE"));
            }
            agentPayBill.pay(idList);
            result.setError(0);
        }
        catch (WfBizException e) {
            result.setError(1);
            result.getDetailMsgList().add(CASWebUtil.getResource(ctx, "PAY_FAILED", new String[]{CASWebUtil.getResource(ctx, "ALREADY_IN_WORKFLOW")}));
            summary = CASWebUtil.getResource(ctx, "PAY_FAILED", new String[]{CASWebUtil.getResource(ctx, "ALREADY_IN_WORKFLOW")});
        }
        catch (Exception e) {
            result.setError(1);
            result.getDetailMsgList().add(CASWebUtil.getResource(ctx, "PAY_FAILED", new String[]{e.getMessage()}));
            summary = CASWebUtil.getResource(ctx, "PAY_FAILED", new String[]{e.getMessage()});
        }
        finally {
            if (isLock) {
                iMutex.releaseObjIDForUpdate(id);
            }
        }
        result.setSummaryMsg(summary);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Map _cancelPayById(Context ctx, String id) throws BOSException, EASBizException {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("company.name"));
        sic.add(new SelectorItemInfo("company.id"));
        IAgentPayBill agentPayBill = AgentPayBillFactory.getLocalInstance(ctx);
        BatchExecuteResult result = new BatchExecuteResult();
        String summary = CASWebUtil.getResource(ctx, "CANCELPAY_SUCCESS");
        AgentPayBillInfo info = agentPayBill.getAgentPayBillInfo((IObjectPK)new ObjectUuidPK(id), sic);
        HashSet<String> idList = new HashSet<String>();
        idList.add(id);
        IMutexServiceControl iMutex = MutexServiceControlFactory.getLocalInstance((Context)ctx);
        boolean isLock = false;
        try {
            isLock = iMutex.requestObjIDForUpdate(id);
            if (!isLock) {
                throw new RuntimeException(CASWebUtil.getResource(ctx, "HAS_LOCKED"));
            }
            boolean isPermission = CASWebHelper.hasFunctionPermission(ctx, ctx.getCaller(), (IObjectPK)new ObjectUuidPK(info.getCompany().getId()), "agentPaybill_cancelpay");
            if (!isPermission) {
                throw new CasWebException(CasWebException.NO_CANCELPAY_AUTHRIZED);
            }
            if (CASWebHelper.isAdjustPeriod(ctx, info.getCompany())) {
                throw new RuntimeException(CASWebUtil.getResource(ctx, "IN_ADJUST_PERIOD_SINGLE"));
            }
            if (this.isInWorkFlow(id, ctx)) {
                result.setError(1);
                result.getDetailMsgList().add(CASWebUtil.getResource(ctx, "CANCELPAY_FAILED", new String[]{CASWebUtil.getResource(ctx, "ALREADY_IN_WORKFLOW")}));
                summary = CASWebUtil.getResource(ctx, "CANCELPAY_FAILED", new String[]{CASWebUtil.getResource(ctx, "ALREADY_IN_WORKFLOW")});
            } else {
                agentPayBill.cancelPay(idList);
                result.setError(0);
            }
        }
        catch (Exception e) {
            result.setError(1);
            result.getDetailMsgList().add(CASWebUtil.getResource(ctx, "CANCELPAY_FAILED", new String[]{e.getMessage()}));
            summary = CASWebUtil.getResource(ctx, "CANCELPAY_FAILED", new String[]{e.getMessage()});
        }
        finally {
            if (isLock) {
                iMutex.releaseObjIDForUpdate(id);
            }
        }
        result.setSummaryMsg(summary);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Map _batchPay(Context ctx, String[] ids) throws BOSException, EASBizException {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("company.name"));
        sic.add(new SelectorItemInfo("company.id"));
        IAgentPayBill agentPayBill = AgentPayBillFactory.getLocalInstance(ctx);
        BatchExecuteResult result = new BatchExecuteResult();
        String summary = CASWebUtil.getResource(ctx, "BILLSUM", new String[]{ids.length + ""});
        int success = 0;
        ArrayList<String> allIdList = new ArrayList<String>();
        for (int i = 0; i < ids.length; ++i) {
            allIdList.add(ids[i]);
        }
        ArrayList<String> correctList = new ArrayList<String>();
        ArrayList<String> lockedList = new ArrayList<String>();
        try {
            this.requesMutexs(ctx, allIdList, correctList, lockedList);
            for (int i = 0; i < ids.length; ++i) {
                AgentPayBillInfo info = agentPayBill.getAgentPayBillInfo((IObjectPK)new ObjectUuidPK(ids[i]), sic);
                HashSet<String> idList = new HashSet<String>();
                idList.add(ids[i]);
                try {
                    if (lockedList.contains(info.getId().toString())) {
                        throw new RuntimeException(CASWebUtil.getResource(ctx, "HAS_LOCKED"));
                    }
                    boolean isPermission = CASWebHelper.hasFunctionPermission(ctx, ctx.getCaller(), (IObjectPK)new ObjectUuidPK(info.getCompany().getId()), "agentPaybill_pay");
                    if (!isPermission) {
                        throw new CasWebException(CasWebException.NO_PAY_AUTHRIZED);
                    }
                    if (CASWebHelper.isAdjustPeriod(ctx, info.getCompany())) {
                        throw new RuntimeException(CASWebUtil.getResource(ctx, "IN_ADJUST_PERIOD_SINGLE"));
                    }
                    agentPayBill.pay(idList);
                    ++success;
                    continue;
                }
                catch (Exception e) {
                    result.getDetailMsgList().add(CASWebUtil.getResource(ctx, "476_AGENTPAYBILL_PAY_FAILED", new String[]{info.getCompany().getName(), info.getNumber(), e.getMessage()}));
                }
            }
        }
        finally {
            if (correctList != null && correctList.size() > 0) {
                MutexServiceControlFactory.getLocalInstance((Context)ctx).batchReleaseObjIDForUpdate(correctList);
            }
        }
        summary = success == ids.length ? summary + CASWebUtil.getResource(ctx, "ALL_PAY_SUCCESS") : summary + CASWebUtil.getResource(ctx, "PAY_RESULT", new String[]{String.valueOf(success), String.valueOf(ids.length - success)});
        result.setSummaryMsg(summary);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Map _batchCancelPay(Context ctx, String[] ids) throws BOSException, EASBizException {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("billStatus"));
        sic.add(new SelectorItemInfo("company.name"));
        sic.add(new SelectorItemInfo("company.id"));
        IAgentPayBill agentPayBill = AgentPayBillFactory.getLocalInstance(ctx);
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)CASWebUtil.ids2Set(ids), CompareType.INCLUDE));
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(filter);
        evi.setSelector(sic);
        SorterItemInfo sorterItemInfo = new SorterItemInfo("number");
        sorterItemInfo.setSortType(SortType.DESCEND);
        evi.getSorter().add(sorterItemInfo);
        AgentPayBillCollection coll = agentPayBill.getAgentPayBillCollection(evi);
        BatchExecuteResult result = new BatchExecuteResult();
        String summary = CASWebUtil.getResource(ctx, "BILLSUM", new String[]{ids.length + ""});
        int success = 0;
        ArrayList<String> allIdList = new ArrayList<String>();
        for (int i = 0; i < ids.length; ++i) {
            allIdList.add(ids[i]);
        }
        ArrayList<String> correctList = new ArrayList<String>();
        ArrayList<String> lockedList = new ArrayList<String>();
        try {
            this.requesMutexs(ctx, allIdList, correctList, lockedList);
            for (int i = 0; i < coll.size(); ++i) {
                AgentPayBillInfo info = coll.get(i);
                HashSet<String> idList = new HashSet<String>();
                String id = info.getId().toString();
                idList.add(id);
                try {
                    if (lockedList.contains(info.getId().toString())) {
                        throw new RuntimeException(CASWebUtil.getResource(ctx, "HAS_LOCKED"));
                    }
                    boolean isPermission = CASWebHelper.hasFunctionPermission(ctx, ctx.getCaller(), (IObjectPK)new ObjectUuidPK(info.getCompany().getId()), "agentPaybill_cancelpay");
                    if (!isPermission) {
                        throw new CasWebException(CasWebException.NO_CANCELPAY_AUTHRIZED);
                    }
                    if (CASWebHelper.isAdjustPeriod(ctx, info.getCompany())) {
                        throw new RuntimeException(CASWebUtil.getResource(ctx, "IN_ADJUST_PERIOD_SINGLE"));
                    }
                    if (!info.getBillStatus().equals((Object)BillStatusEnum.PAYED)) {
                        throw new RecPayException(RecPayException.CANNOT_CANCELPAY_BEFORE_PAYED);
                    }
                    if (info.getBillStatus().equals((Object)BillStatusEnum.PAYED)) {
                        if (this.isInWorkFlow(ids[i], ctx)) {
                            result.getDetailMsgList().add(CASWebUtil.getResource(ctx, "477_AGENTPAYBILL_CANCELPAY_FAILED", new String[]{info.getCompany().getName(), info.getNumber(), CASWebUtil.getResource(ctx, "ALREADY_IN_WORKFLOW")}));
                            continue;
                        }
                        agentPayBill.cancelPay(idList);
                        ++success;
                        continue;
                    }
                    ++success;
                    continue;
                }
                catch (Exception e) {
                    result.getDetailMsgList().add(CASWebUtil.getResource(ctx, "477_AGENTPAYBILL_CANCELPAY_FAILED", new String[]{info.getCompany().getName(), info.getNumber(), e.getMessage()}));
                }
            }
        }
        finally {
            if (correctList != null && correctList.size() > 0) {
                MutexServiceControlFactory.getLocalInstance((Context)ctx).batchReleaseObjIDForUpdate(correctList);
            }
        }
        summary = success == ids.length ? summary + CASWebUtil.getResource(ctx, "ALL_CANCELPAY_SUCCESS") : summary + CASWebUtil.getResource(ctx, "CANCELPAY_RESULT", new String[]{String.valueOf(success), String.valueOf(ids.length - success)});
        result.setSummaryMsg(summary);
        return result;
    }

    @Override
    protected Map<String, Object> _commitToBe(Context ctx, String id) throws BOSException, EASBizException {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("billStatus"));
        sic.add(new SelectorItemInfo("company.name"));
        sic.add(new SelectorItemInfo("company.id"));
        IAgentPayBill agentPayBill = AgentPayBillFactory.getLocalInstance(ctx);
        BatchExecuteResult result = new BatchExecuteResult();
        String summary = CASWebUtil.getResource(ctx, "332_COMMITTOBE_SUCCESS");
        AgentPayBillInfo info = agentPayBill.getAgentPayBillInfo((IObjectPK)new ObjectUuidPK(id), sic);
        try {
            boolean isPermission = CASWebHelper.hasFunctionPermission(ctx, ctx.getCaller(), (IObjectPK)new ObjectUuidPK(info.getCompany().getId()), "agentPaybill_commitBe");
            if (!isPermission) {
                throw new CasWebException(CasWebException.NO_COMMITTOBE_AUTHRIZED);
            }
            if (CASWebHelper.isAdjustPeriod(ctx, info.getCompany())) {
                throw new RuntimeException(CASWebUtil.getResource(ctx, "IN_ADJUST_PERIOD_SINGLE"));
            }
            if (!info.getBillStatus().equals((Object)BillStatusEnum.AUDITED)) {
                throw new RuntimeException(CASWebUtil.getResource(ctx, "329_COMMITTOBE_AUDITED"));
            }
            HashSet<String> idSet = new HashSet<String>();
            idSet.add(id);
            Set bankPayingBillId = agentPayBill.commitToBE(idSet);
            AgentPayBillFactory.getLocalInstance(ctx).commitToBeAll(idSet, bankPayingBillId);
            result.setError(0);
        }
        catch (WfBizException e) {
            result.setError(1);
            result.getDetailMsgList().add(CASWebUtil.getResource(ctx, "333_COMMITTOBE_FAILED", new String[]{CASWebUtil.getResource(ctx, "ALREADY_IN_WORKFLOW")}));
            summary = CASWebUtil.getResource(ctx, "333_COMMITTOBE_FAILED", new String[]{CASWebUtil.getResource(ctx, "ALREADY_IN_WORKFLOW")});
        }
        catch (Exception e) {
            result.setError(1);
            result.getDetailMsgList().add(CASWebUtil.getResource(ctx, "333_COMMITTOBE_FAILED", new String[]{e.getMessage()}));
            summary = CASWebUtil.getResource(ctx, "333_COMMITTOBE_FAILED", new String[]{e.getMessage()});
        }
        result.setSummaryMsg(summary);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Map<String, Object> _submit(Context ctx, AgentPayBillInfo info) throws BOSException, EASBizException {
        HashMap<String, Object> pageModel = new HashMap<String, Object>();
        try {
            IAgentPayBill iAgentPayBill = AgentPayBillFactory.getLocalInstance(ctx);
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add("billStatus");
            if (info.getId() != null && iAgentPayBill.exists((IObjectPK)new ObjectUuidPK(info.getId().toString()))) {
                IMutexServiceControl iMutex = MutexServiceControlFactory.getLocalInstance((Context)ctx);
                boolean isLock = false;
                try {
                    isLock = iMutex.requestObjIDForUpdate(info.getId().toString());
                    if (!isLock) {
                        throw new RuntimeException(CASWebUtil.getResource(ctx, "HAS_LOCKED"));
                    }
                    boolean isEdit = CASWebHelper.hasFunctionPermission(ctx, ctx.getCaller(), (IObjectPK)new ObjectUuidPK(info.getCompany().getId()), "agentPaybill_batchSubmit");
                    if (!isEdit) {
                        throw new CasWebException(CasWebException.NO_SUBMIT_AUTHRIZED);
                    }
                    AgentPayBillInfo oldInfo = (AgentPayBillInfo)iAgentPayBill.getValue((IObjectPK)new ObjectUuidPK(info.getId().toString()), sic);
                    if (oldInfo.getBillStatus().getValue() != 10 && oldInfo.getBillStatus().getValue() != 11) {
                        throw new RuntimeException(CASWebUtil.getResource(ctx, "304_BILL_STATUS_NOT_SUBMIT", new String[]{oldInfo.getBillStatus().toString()}));
                    }
                }
                finally {
                    if (isLock) {
                        iMutex.releaseObjIDForUpdate(info.getId().toString());
                    }
                }
            }
            if (PeriodHelper.isAdjustPeriod(ctx, info.getCompany().getId().toString())) {
                throw new RuntimeException(CASWebUtil.getResource(ctx, "IN_ADJUST_PERIOD", new String[]{info.getNumber()}));
            }
            if (this.isStatusChanged(ctx, info)) {
                throw new RuntimeException(CASWebUtil.getResource(ctx, "CANNOT_SUBMIT_BILL_STATUS_CHANGED"));
            }
            if (info.getId() != null && info.getNumber() == null && !iAgentPayBill.exists((IObjectPK)new ObjectUuidPK(info.getId().toString()))) {
                String numberSilent = NumberRuleUtil.getNumberSilent((Context)ctx, (CoreBaseInfo)info, (String)info.getCompany().getId().toString());
                info.setNumber(numberSilent);
                this.checkNumberDup(ctx, info);
            }
            this.verifyBeforeSubmit(ctx, info);
            IObjectPK objectPK = this.getSubmitPk(ctx, iAgentPayBill, info);
            pageModel.put("id", objectPK.toString());
            pageModel.put("error", 0);
        }
        catch (WfBizException e) {
            pageModel.put("error", 1);
            pageModel.put("msg", CASWebUtil.getResource(ctx, "ALREADY_IN_WORKFLOW"));
        }
        catch (Exception e) {
            e.printStackTrace();
            pageModel.put("error", 1);
            pageModel.put("msg", e.getMessage());
        }
        return pageModel;
    }

    protected IObjectPK getSubmitPk(Context ctx, IAgentPayBill iAgentPayBill, AgentPayBillInfo info) throws Exception {
        IObjectPK objectPK = null;
        IBTPManager iBTPManager = BTPManagerFactory.getLocalInstance((Context)ctx);
        BOTRelationCollection btpRelationCollection = CASWebHelper.getBOTRelationColFromExtendProperty(ctx, (IObjectValue)info);
        if (info.get("id") != null && (btpRelationCollection == null || btpRelationCollection.size() == 0)) {
            btpRelationCollection = iBTPManager.getRelationCollection(info.get("id").toString());
        }
        boolean enable = false;
        if (btpRelationCollection != null && btpRelationCollection.size() > 0) {
            if (null != info && null != info.getId() && null != info.getBillStatus() && CasForArApUtil.isBillInShareFlow(ctx, false, info.getId().toString(), info.getBillStatus().getValue(), 11)) {
                logger.error((Object)("\u5355\u636eID\u4e3a\uff1a" + info.getId().toString() + "\u4e14\u5355\u636e\u5904\u4e8e\u5171\u4eab\u5de5\u4f5c\u6d41\u4e2d\uff0c\u5173\u95ed\u5de5\u4f5c\u6d41\u6821\u9a8c"));
                WfEventListenerStateManager.getInstance().disableEventListener();
                enable = true;
            }
            objectPK = iBTPManager.submitRelations((CoreBillBaseInfo)info, btpRelationCollection);
            if (enable) {
                logger.error((Object)("\u5355\u636eID\u4e3a\uff1a" + info.getId().toString() + "\u4e14\u5355\u636e\u5904\u4e8e\u5171\u4eab\u5de5\u4f5c\u6d41\u4e2d\uff0c\u6253\u5f00\u5de5\u4f5c\u6d41\u6821\u9a8c"));
                WfEventListenerStateManager.getInstance().enableEventListener();
            }
        } else {
            if (null != info && null != info.getId() && null != info.getBillStatus() && CasForArApUtil.isBillInShareFlow(ctx, false, info.getId().toString(), info.getBillStatus().getValue(), 11)) {
                logger.error((Object)("\u5355\u636eID\u4e3a\uff1a" + info.getId().toString() + "\u4e14\u5355\u636e\u5904\u4e8e\u5171\u4eab\u5de5\u4f5c\u6d41\u4e2d\uff0c\u5173\u95ed\u5de5\u4f5c\u6d41\u6821\u9a8c"));
                WfEventListenerStateManager.getInstance().disableEventListener();
                enable = true;
            }
            objectPK = iAgentPayBill.submit((CoreBaseInfo)info);
            if (enable) {
                logger.error((Object)("\u5355\u636eID\u4e3a\uff1a" + info.getId().toString() + "\u4e14\u5355\u636e\u5904\u4e8e\u5171\u4eab\u5de5\u4f5c\u6d41\u4e2d\uff0c\u6253\u5f00\u5de5\u4f5c\u6d41\u6821\u9a8c"));
                WfEventListenerStateManager.getInstance().enableEventListener();
            }
        }
        return objectPK;
    }

    protected void verifyBeforeSave(Context ctx, AgentPayBillInfo info) throws Exception {
        this.verifyHead(ctx, info);
        this.verifyHeadInput(ctx, info);
        this.verifyRate(ctx, info);
        this.verifyEntryInput(ctx, info);
    }

    protected void verifyBeforeSubmit(Context ctx, AgentPayBillInfo info) throws Exception {
        this.verifyHeadInput(ctx, info);
        this.verifyRate(ctx, info);
        this.verifyEntryInput(ctx, info);
    }

    private void verifyHead(Context ctx, AgentPayBillInfo info) throws Exception {
        if (EmptyUtil.isEmpty((CoreBaseInfo)info.getSettlementType())) {
            throw new RuntimeException(CASWebUtil.getResource(ctx, "292_SETTLEMENTTYPE_NOT_EMPTY"));
        }
        if (EmptyUtil.isEmpty((CoreBaseInfo)info.getPayerAccount())) {
            throw new RuntimeException(CASWebUtil.getResource(ctx, "290_PAYERACCOUNT_NOT_EMPTY"));
        }
        if (EmptyUtil.isEmpty((String)info.getUsage())) {
            throw new RuntimeException(CASWebUtil.getResource(ctx, "293_USAGE_NOT_EMPTY"));
        }
    }

    private void verifyHeadInput(Context ctx, AgentPayBillInfo info) throws Exception {
        if (EmptyUtil.isEmpty((Object)info.getAmount())) {
            throw new RuntimeException(CASWebUtil.getResource(ctx, "484_AGENTPAYBILL_AMOUNT_EMPTY"));
        }
        if (info.getAmount().compareTo(CasConstants.ZERO) != 1) {
            throw new RuntimeException(CASWebUtil.getResource(ctx, "485_AGENTPAYBILL_AMOUNT_ZERO"));
        }
        if (EmptyUtil.isEmpty((Object)info.getLocalAmount())) {
            throw new RuntimeException(CASWebUtil.getResource(ctx, "486_AGENTPAYBILL_LOCALAMOUNT_EMPTY"));
        }
        if (info.getLocalAmount().compareTo(CasConstants.ZERO) != 1) {
            throw new RuntimeException(CASWebUtil.getResource(ctx, "487_AGENTPAYBILL_LOCALAMOUNT_ZERO"));
        }
        if (info.getUsage() != null && info.getUsage().length() > 200) {
            throw new RuntimeException(CASWebUtil.getResource(ctx, CASRES, "225_AgentPayBillEditUI"));
        }
    }

    private void verifyRate(Context ctx, AgentPayBillInfo info) throws Exception {
        BigDecimal rate;
        CompanyOrgUnitInfo company = info.getCompany();
        SelectorItemCollection sict = new SelectorItemCollection();
        sict.add(new SelectorItemInfo("id"));
        sict.add(new SelectorItemInfo("currency.id"));
        sict.add(new SelectorItemInfo("currency.number"));
        sict.add(new SelectorItemInfo("baseExchangeTable.id"));
        sict.add(new SelectorItemInfo("baseCurrency.id"));
        sict.add(new SelectorItemInfo("baseCurrency.number"));
        company = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(company.getId()), sict);
        String srcCurrency = info.getCurrency().getId().toString();
        String destCurrency = company.getBaseCurrency().getId().toString();
        if (!srcCurrency.equals(destCurrency) && EmptyUtil.isEmpty((Object)(rate = JournalWebUtil.getExchange(ctx, company, info.getCurrency(), company.getBaseCurrency(), info.getBizDate())))) {
            throw new BOSException(CASWebUtil.getResource(ctx, "com.kingdee.eas.fi.cas.CasResources", "NoExchange"));
        }
    }

    private boolean verifyEntryProvinceCityIsEmpty(Context ctx, AgentPayBillInfo info) throws Exception {
        boolean isThroughBE = false;
        if (info.getSettlementType() != null) {
            SettlementTypeInfo settleType = SettlementTypeFactory.getLocalInstance((Context)ctx).getSettlementTypeInfo((IObjectPK)new ObjectUuidPK(info.getSettlementType().getId().toString()));
            isThroughBE = settleType.isPayThroughBE();
        }
        int length = info.getEntrys().size();
        for (int i = 0; i < length; ++i) {
            AgentPayBillEntryInfo entry = info.getEntrys().get(i);
            if (!isThroughBE || !EmptyUtil.isEmpty((String)entry.getRecProvince()) && !EmptyUtil.isEmpty((String)entry.getRecCity()) || !isThroughBE || !EmptyUtil.isEmpty((String)entry.getRecProvince()) && !EmptyUtil.isEmpty((String)entry.getRecCity()) || info.isIsCBPay()) continue;
            return true;
        }
        return false;
    }

    private void verifyEntryInput(Context ctx, AgentPayBillInfo info) throws Exception {
        boolean isThroughBE = false;
        if (info.getSettlementType() != null) {
            SettlementTypeInfo settleType = SettlementTypeFactory.getLocalInstance((Context)ctx).getSettlementTypeInfo((IObjectPK)new ObjectUuidPK(info.getSettlementType().getId().toString()));
            isThroughBE = settleType.isPayThroughBE();
        }
        BatchPayRuleInfo batchPayRuleInfo = null;
        BigDecimal maxAmount = FMConstants.ZERO;
        int maxBarchNo = 0;
        String errorDetail = "";
        String errorNo = "";
        if (info.getPayBankAccount() != null) {
            AccountBankInfo payerAccount = info.getPayBankAccount();
            payerAccount = AccountBankFactory.getLocalInstance((Context)ctx).getAccountBankInfo((IObjectPK)new ObjectUuidPK(payerAccount.getId().toString()));
            if (payerAccount.isIsSetBankInterface() && payerAccount.getBankInterFaceID() != null && (batchPayRuleInfo = BatchPayRuleFactory.getLocalInstance((Context)ctx).getBatchPayRuleByBankInterface(payerAccount.getBankInterFaceID())) != null) {
                maxAmount = batchPayRuleInfo.getMaxAmount();
                maxBarchNo = batchPayRuleInfo.getMaxBarchNo();
            }
        }
        int length = info.getEntrys().size();
        if (batchPayRuleInfo != null && maxBarchNo < length) {
            errorNo = MessageFormat.format(this.getBatchPayResource(ctx, "moreThanMaxBatchNo"), String.valueOf(length), String.valueOf(maxBarchNo));
            throw new Exception(errorNo);
        }
        boolean cs107 = ContextHelperFactory.getLocalInstance((Context)ctx).getBooleanParam("CS107", (IObjectPK)new ObjectUuidPK(info.getCompany().getId()));
        for (int i = 0; i < length; ++i) {
            AgentPayBillEntryInfo entry = info.getEntrys().get(i);
            if (EmptyUtil.isEmpty((String)entry.getRecName())) {
                throw new RuntimeException(CASWebUtil.getResource(ctx, CASRES, "226_AgentPayBillEditUI"));
            }
            if (EmptyUtil.isEmpty((String)entry.getRecBankAccount())) {
                throw new RuntimeException(CASWebUtil.getResource(ctx, CASRES, "227_AgentPayBillEditUI"));
            }
            if (EmptyUtil.isEmpty((String)entry.getRecBankName())) {
                throw new RuntimeException(CASWebUtil.getResource(ctx, CASRES, "228_AgentPayBillEditUI"));
            }
            if (EmptyUtil.isEmpty((Object)entry.getAmount())) {
                throw new RuntimeException(CASWebUtil.getResource(ctx, CASRES, "229_AgentPayBillEditUI"));
            }
            if (entry.getAmount().compareTo(Constants.ZERO) == 0) {
                throw new RuntimeException(CASWebUtil.getResource(ctx, CASRES, "230_AgentPayBillEditUI"));
            }
            if (cs107 && EmptyUtil.isEmpty((String)entry.getBgItemName())) {
                throw new RuntimeException(CASWebUtil.getResource(ctx, "488_AGENTPAYBILL_BGITEM_EMPTY"));
            }
            if (batchPayRuleInfo == null || entry.getAmount().compareTo(maxAmount) <= 0) continue;
            String errorInfo = MessageFormat.format(this.getBatchPayResource(ctx, "detailNumber"), String.valueOf(i + 1), maxAmount.toString());
            errorDetail = errorDetail + errorInfo + "\n";
        }
        if (errorDetail != null && !errorDetail.equals("")) {
            errorDetail = errorDetail + errorNo;
            throw new Exception(errorDetail);
        }
    }

    private String getBatchPayResource(Context ctx, String resName) {
        return CASWebUtil.getResource(ctx, "com.kingdee.eas.fm.be.BatchPayResource", resName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Map _batchSubmit(Context ctx, String[] ids) throws BOSException, EASBizException {
        IAgentPayBill agentPayBill = AgentPayBillFactory.getLocalInstance(ctx);
        BatchExecuteResult result = new BatchExecuteResult();
        String summary = CASWebUtil.getResource(ctx, "BILLSUM", new String[]{ids.length + ""});
        int success = ids.length;
        ArrayList<String> allIdList = new ArrayList<String>();
        for (int i = 0; i < ids.length; ++i) {
            allIdList.add(ids[i]);
        }
        ArrayList<String> correctList = new ArrayList<String>();
        ArrayList<String> lockedList = new ArrayList<String>();
        try {
            this.requesMutexs(ctx, allIdList, correctList, lockedList);
            for (int i = 0; i < ids.length; ++i) {
                AgentPayBillInfo info = agentPayBill.getAgentPayBillInfo((IObjectPK)new ObjectUuidPK(ids[i]), this.getSelector());
                ArrayList<String> idList = new ArrayList<String>();
                idList.add(ids[i]);
                try {
                    if (lockedList.contains(info.getId().toString())) {
                        throw new RuntimeException(CASWebUtil.getResource(ctx, "HAS_LOCKED"));
                    }
                    boolean isPermission = CASWebHelper.hasFunctionPermission(ctx, ctx.getCaller(), (IObjectPK)new ObjectUuidPK(info.getCompany().getId()), "agentPaybill_batchSubmit");
                    if (!isPermission) {
                        throw new CasWebException(CasWebException.NO_SUBMIT_AUTHRIZED);
                    }
                    if (CASWebHelper.isAdjustPeriod(ctx, info.getCompany())) {
                        throw new RuntimeException(CASWebUtil.getResource(ctx, "IN_ADJUST_PERIOD_SINGLE"));
                    }
                    if (info.getBillStatus() != BillStatusEnum.SAVE && info.getBillStatus() != BillStatusEnum.SUBMIT) {
                        throw new RuntimeException(CASWebUtil.getResource(ctx, CASRES, "169_PaymentBillControllerBean"));
                    }
                    this.verifyBeforeSubmit(ctx, info);
                    Map map = agentPayBill.saveBatch(idList);
                    continue;
                }
                catch (WfBizException e) {
                    --success;
                    result.getDetailMsgList().add(CASWebUtil.getResource(ctx, "472_AGENTPAYBILL_SUBMIT_FAILED", new String[]{info.getCompany().getName(), info.getNumber(), CASWebUtil.getResource(ctx, "ALREADY_IN_WORKFLOW")}));
                    continue;
                }
                catch (Exception e) {
                    --success;
                    result.getDetailMsgList().add(CASWebUtil.getResource(ctx, "472_AGENTPAYBILL_SUBMIT_FAILED", new String[]{info.getCompany().getName(), info.getNumber(), e.getMessage()}));
                }
            }
        }
        finally {
            if (correctList != null && correctList.size() > 0) {
                MutexServiceControlFactory.getLocalInstance((Context)ctx).batchReleaseObjIDForUpdate(correctList);
            }
        }
        summary = success == ids.length ? summary + CASWebUtil.getResource(ctx, "ALL_SUBMIT_SUCCESS") : summary + CASWebUtil.getResource(ctx, "SUBMIT_RESULT", new String[]{String.valueOf(success), String.valueOf(ids.length - success)});
        result.setSummaryMsg(summary);
        return result;
    }

    private void requesMutexs(Context ctx, List idList, List<String> correctList, List<String> lockedList) throws BOSException {
        IMutexServiceControl iMutex = MutexServiceControlFactory.getLocalInstance((Context)ctx);
        HashMap map = new HashMap();
        try {
            Map resultRequest = iMutex.batchRequestObjIDForUpdate(idList);
            for (int i = 0; i < idList.size(); ++i) {
                Boolean boolResult = (Boolean)resultRequest.get(idList.get(i));
                if (!boolResult.booleanValue()) {
                    lockedList.add((String)idList.get(i));
                    continue;
                }
                correctList.add((String)idList.get(i));
            }
        }
        catch (Exception en) {
            logger.error((Object)en);
        }
    }

    @Override
    protected Map<String, Object> _beforeSubmit(Context ctx, AgentPayBillInfo info) throws BOSException, EASBizException {
        HashMap<String, Object> pageModel = new HashMap<String, Object>();
        try {
            List<String> dupList;
            boolean isEdit;
            IAgentPayBill iAgentPayBill = AgentPayBillFactory.getLocalInstance(ctx);
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add("billStatus");
            if (info.getId() != null && iAgentPayBill.exists((IObjectPK)new ObjectUuidPK(info.getId().toString())) && !(isEdit = CASWebHelper.hasFunctionPermission(ctx, ctx.getCaller(), (IObjectPK)new ObjectUuidPK(info.getCompany().getId()), "agentPaybill_edit"))) {
                throw new CasWebException(CasWebException.NO_EDIT_AUTHRIZED);
            }
            if (PeriodHelper.isAdjustPeriod(ctx, info.getCompany().getId().toString())) {
                throw new RuntimeException(CASWebUtil.getResource(ctx, "IN_ADJUST_PERIOD", new String[]{info.getNumber()}));
            }
            if (this.isStatusChanged(ctx, info)) {
                throw new RuntimeException(CASWebUtil.getResource(ctx, "CANNOT_SUBMIT_BILL_STATUS_CHANGED"));
            }
            this.verifyBeforeSubmit(ctx, info);
            String overDraft = null;
            AccountBankInfo payerAcctBank = info.getPayBankAccount();
            if (payerAcctBank != null && payerAcctBank.getCtrlStrategy() != null) {
                AccountMgrStrategyInfo strategy = payerAcctBank.getCtrlStrategy();
                BigDecimal balance = info.getBalance();
                overDraft = this.verifyOverDraftForAgentPayBill(ctx, new CasRecPayHandler().getInstanceBean(), strategy, balance, info);
            }
            pageModel.put("overDraft", overDraft);
            String dupBankAccount = null;
            if (info.getEntrys().size() > 1 && !EmptyUtil.isEmpty(dupList = this.getDupRecBankAccount(info))) {
                dupBankAccount = MessageFormat.format(CASWebUtil.getResource(ctx, "com.kingdee.eas.fi.cas.CasResources", "AgentPayRecBankAcctCheck"), CASWebUtil.list2Str(dupList));
            }
            pageModel.put("dupBankAccount", dupBankAccount);
            String provinceCityNull = null;
            if (this.verifyEntryProvinceCityIsEmpty(ctx, info)) {
                provinceCityNull = MessageFormat.format(CASWebUtil.getResource(ctx, "com.kingdee.eas.fi.cas.CasResources", "RecProvinceCity"), null);
                pageModel.put("provinceCityNull", provinceCityNull);
            }
            pageModel.put("error", 0);
        }
        catch (WfBizException e) {
            pageModel.put("error", 1);
            pageModel.put("msg", CASWebUtil.getResource(ctx, "ALREADY_IN_WORKFLOW"));
        }
        catch (Exception e) {
            e.printStackTrace();
            pageModel.put("error", 1);
            pageModel.put("msg", e.getMessage());
        }
        return pageModel;
    }

    private List<String> getDupRecBankAccount(AgentPayBillInfo info) {
        ArrayList<String> list = new ArrayList<String>();
        ArrayList<String> dupList = new ArrayList<String>();
        for (int i = 0; i < info.getEntrys().size(); ++i) {
            AgentPayBillEntryInfo entry = info.getEntrys().get(i);
            String bankAccount = entry.getRecBankAccount();
            if (list.contains(bankAccount)) {
                if (dupList.contains(bankAccount)) continue;
                dupList.add(bankAccount);
                continue;
            }
            list.add(bankAccount);
        }
        return dupList;
    }

    private void checkNumberDup(Context ctx, AgentPayBillInfo info) throws EASBizException, BOSException {
        FilterInfo filter = NumberRuleUtil.getCheckNumberDupFilter((IObjectValue)info, (boolean)true);
        if (AgentPayBillFactory.getLocalInstance(ctx).exists(filter)) {
            throw new EASBizException(EASBizException.CHECKDUPNUMBER, new Object[]{info.getNumber(), ""});
        }
    }

    private String verifyOverDraftForAgentPayBill(Context ctx, CasRecPayHandler.RecPayInstanceAmountBean bean, AccountMgrStrategyInfo strategy, BigDecimal balance, AgentPayBillInfo editData) throws Exception {
        boolean isAcctViewNotChanged;
        String overDraft = null;
        if (balance == null) {
            return overDraft;
        }
        boolean isCtrlAcctBank = true;
        AccountBankInfo payerAcctBank = editData.getPayBankAccount();
        if (strategy == null) {
            isCtrlAcctBank = false;
        }
        boolean isRemind = false;
        if (strategy != null) {
            if (null == strategy.getOverdraftCtrl()) {
                strategy = AccountMgrStrategyFactory.getLocalInstance((Context)ctx).getAccountMgrStrategyInfo((IObjectPK)new ObjectUuidPK(strategy.getId()));
            }
            isRemind = strategy.getOverdraftCtrl().equals((Object)OverdraftCtrlEnum.NOTCONTROL) && strategy.isRemind();
        }
        boolean isAcctBankNotChanged = bean.getAcctBank() != null && editData.getPayBankAccount() != null && bean.getAcctBank().getId().equals((Object)editData.getPayBankAccount().getId());
        boolean bl = isAcctViewNotChanged = bean.getAcctBank() == null && editData.getPayBankAccount() == null && bean.getAcctView() != null && editData.getPayerAccount() != null && bean.getAcctView().getId().equals((Object)editData.getPayerAccount().getId());
        if (isAcctBankNotChanged || isAcctViewNotChanged) {
            balance = balance.add(bean.getOrignalAmt());
        }
        BigDecimal amount = balance.subtract(editData.getActualAmount());
        this.ctrlAcctBank(ctx, strategy, isCtrlAcctBank, payerAcctBank, isRemind, amount);
        AccountBankGroupInfo acctBankGroup = AccountBankFactory.getLocalInstance((Context)ctx).getAcctBankGroup(editData.getPayBankAccount().getId().toString());
        if (acctBankGroup == null) {
            return overDraft;
        }
        strategy = acctBankGroup.getStrategy();
        isRemind = strategy.getOverdraftCtrl().equals((Object)OverdraftCtrlEnum.NOTCONTROL) && strategy.isRemind();
        ObjectUuidPK companyPK = new ObjectUuidPK(editData.getCompany().getId());
        ObjectUuidPK currencyPK = new ObjectUuidPK(editData.getCurrency().getId());
        ObjectUuidPK acctBankGroupPK = new ObjectUuidPK(acctBankGroup.getId());
        BigDecimal totalbalance = InnerCashFacadeFactory.getLocalInstance(ctx).getAcctGroupInstantBalance((IObjectPK)companyPK, (IObjectPK)acctBankGroupPK, (IObjectPK)currencyPK);
        if (isAcctBankNotChanged || isAcctViewNotChanged) {
            totalbalance = totalbalance.add(bean.getOrignalAmt());
        }
        if ((amount = totalbalance.subtract(editData.getActualAmount())).compareTo(Constants.ZERO) < 0 && isRemind) {
            overDraft = CASWebUtil.getResource(ctx, "com.kingdee.eas.fi.cas.RecPayResource", "GroupBALLESSTHANODAMT");
        }
        return overDraft;
    }

    private void ctrlAcctBank(Context ctx, AccountMgrStrategyInfo strategy, boolean isCtrlAcctBank, AccountBankInfo payerAcctBank, boolean isRemind, BigDecimal amount) throws AccountBankException {
        if (strategy.getOverdraftCtrl().equals((Object)OverdraftCtrlEnum.INLIMITCANOVERDRAFT) && amount.compareTo(Constants.ZERO) < 0 && amount.negate().compareTo(strategy.getOverDraftAmount()) > 0) {
            throw new AccountBankException(AccountBankException.OVERDRAFT, new Object[]{payerAcctBank.getName(), strategy.getOverDraftAmount(), amount.abs().subtract(strategy.getOverDraftAmount())});
        }
        if (strategy.getOverdraftCtrl().equals((Object)OverdraftCtrlEnum.NOTALLOW)) {
            if (amount.compareTo(Constants.ZERO) < 0) {
                throw new AccountBankException(AccountBankException.NOALLOWOVERDRAFT, new Object[]{payerAcctBank.getName(), amount.abs()});
            }
        } else if (strategy.getOverdraftCtrl().equals((Object)OverdraftCtrlEnum.LOWESTDEPOSITGUARANTEE) && amount.compareTo(strategy.getLowestBalance()) < 0) {
            throw new AccountBankException(AccountBankException.OVERLOWAMOUNT, new Object[]{payerAcctBank.getName(), strategy.getLowestBalance(), strategy.getLowestBalance().subtract(amount).abs()});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Map _batchAudit4Ca(Context ctx, String[] ids, String signature) throws BOSException, EASBizException {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("billStatus"));
        sic.add(new SelectorItemInfo("company.name"));
        sic.add(new SelectorItemInfo("company.id"));
        IAgentPayBill agentPayBill = AgentPayBillFactory.getLocalInstance(ctx);
        BatchExecuteResult result = new BatchExecuteResult();
        String summary = CASWebUtil.getResource(ctx, "BILLSUM", new String[]{ids.length + ""});
        int success = 0;
        List<String> signatureList = CASWebUtil.ids2List(signature != null ? signature.split(",") : null);
        if (signatureList == null || signatureList != null && signatureList.size() != ids.length) {
            result.setError(1);
            result.setSummaryMsg(summary + CASWebUtil.getResource(ctx, "343_AUDIT_FAILED").concat(CASWebUtil.getResource(ctx, "342_SIGNATURE_CHK_ERR")));
            return result;
        }
        IMutexServiceControl iMutex = MutexServiceControlFactory.getLocalInstance((Context)ctx);
        for (int i = 0; i < ids.length; ++i) {
            boolean islocked = false;
            AgentPayBillInfo info = agentPayBill.getAgentPayBillInfo((IObjectPK)new ObjectUuidPK(ids[i]), sic);
            HashSet<String> idList = new HashSet<String>();
            idList.add(ids[i]);
            try {
                islocked = iMutex.requestObjIDForUpdate(ids[i]);
                if (!islocked) {
                    throw new RuntimeException(CASWebUtil.getResource(ctx, "HAS_LOCKED"));
                }
                boolean isPermission = CASWebHelper.hasFunctionPermission(ctx, ctx.getCaller(), (IObjectPK)new ObjectUuidPK(info.getCompany().getId()), "agentPaybill_audit");
                if (!isPermission) {
                    throw new CasWebException(CasWebException.NO_AUDIT_AUTHRIZED);
                }
                if (CASWebHelper.isAdjustPeriod(ctx, info.getCompany())) {
                    throw new RuntimeException(CASWebUtil.getResource(ctx, "IN_ADJUST_PERIOD_SINGLE"));
                }
                IEASSignature iEASSignature = EASSignatureFactory.getLocalInstance((Context)ctx);
                ArrayList<String> list = new ArrayList<String>();
                list.add(ids[i]);
                iEASSignature.checkSignature4Web(list, "agentPaybill_audit");
                ArrayList<String> signatureSubList = new ArrayList<String>();
                signatureSubList.add(signatureList.get(i));
                iEASSignature.checkSignature4Web(list, signatureSubList, "agentPaybill_audit");
                this.verify(info);
                if (this.isInWorkFlow(ids[i], ctx)) {
                    result.getDetailMsgList().add(CASWebUtil.getResource(ctx, "474_AGENTPAYBILL_AUDIT_FAILED", new String[]{info.getCompany().getName(), info.getNumber(), CASWebUtil.getResource(ctx, "ALREADY_IN_WORKFLOW")}));
                    continue;
                }
                agentPayBill.audit(idList);
                iEASSignature.checkSignature4Web(list, "agentPaybill_audit");
                iEASSignature.saveSignature4Web(signatureSubList, list, "agentPaybill_audit");
                ++success;
                continue;
            }
            catch (Exception e) {
                result.getDetailMsgList().add(CASWebUtil.getResource(ctx, "474_AGENTPAYBILL_AUDIT_FAILED", new String[]{info.getCompany().getName(), info.getNumber(), e.getMessage()}));
                continue;
            }
            finally {
                if (islocked) {
                    iMutex.releaseObjIDForUpdate(ids[i]);
                }
            }
        }
        summary = success == ids.length ? summary + CASWebUtil.getResource(ctx, "ALL_AUDIT_SUCCESS") : summary + CASWebUtil.getResource(ctx, "AUDIT_RESULT", new String[]{String.valueOf(success), String.valueOf(ids.length - success)});
        result.setSummaryMsg(summary);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Map _batchPay4Ca(Context ctx, String[] ids, String signature) throws BOSException, EASBizException {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("company.name"));
        sic.add(new SelectorItemInfo("company.id"));
        IAgentPayBill agentPayBill = AgentPayBillFactory.getLocalInstance(ctx);
        BatchExecuteResult result = new BatchExecuteResult();
        String summary = CASWebUtil.getResource(ctx, "BILLSUM", new String[]{ids.length + ""});
        int success = 0;
        List<String> signatureList = CASWebUtil.ids2List(signature != null ? signature.split(",") : null);
        if (signatureList == null || signatureList != null && signatureList.size() != ids.length) {
            result.setError(1);
            result.setSummaryMsg(summary + CASWebUtil.getResource(ctx, "344_PAY_FAILED").concat(CASWebUtil.getResource(ctx, "342_SIGNATURE_CHK_ERR")));
            return result;
        }
        IEASSignature iEASSignature = EASSignatureFactory.getLocalInstance((Context)ctx);
        IMutexServiceControl iMutex = MutexServiceControlFactory.getLocalInstance((Context)ctx);
        for (int i = 0; i < ids.length; ++i) {
            boolean islocked = false;
            AgentPayBillInfo info = agentPayBill.getAgentPayBillInfo((IObjectPK)new ObjectUuidPK(ids[i]), sic);
            HashSet<String> idList = new HashSet<String>();
            idList.add(ids[i]);
            try {
                islocked = iMutex.requestObjIDForUpdate(ids[i]);
                if (!islocked) {
                    throw new RuntimeException(CASWebUtil.getResource(ctx, "HAS_LOCKED"));
                }
                boolean isPermission = CASWebHelper.hasFunctionPermission(ctx, ctx.getCaller(), (IObjectPK)new ObjectUuidPK(info.getCompany().getId()), "agentPaybill_pay");
                if (!isPermission) {
                    throw new CasWebException(CasWebException.NO_PAY_AUTHRIZED);
                }
                if (CASWebHelper.isAdjustPeriod(ctx, info.getCompany())) {
                    throw new RuntimeException(CASWebUtil.getResource(ctx, "IN_ADJUST_PERIOD_SINGLE"));
                }
                ArrayList<String> list = new ArrayList<String>();
                list.add(ids[i]);
                iEASSignature.checkSignature4Web(list, "agentPaybill_pay");
                ArrayList<String> signatureSubList = new ArrayList<String>();
                signatureSubList.add(signatureList.get(i));
                iEASSignature.checkSignature4Web(list, signatureSubList, "agentPaybill_pay");
                if (this.isInWorkFlow(ids[i], ctx)) {
                    result.getDetailMsgList().add(CASWebUtil.getResource(ctx, "476_AGENTPAYBILL_PAY_FAILED", new String[]{info.getCompany().getName(), info.getNumber(), CASWebUtil.getResource(ctx, "ALREADY_IN_WORKFLOW")}));
                    continue;
                }
                agentPayBill.pay(idList);
                iEASSignature.checkSignature4Web(list, "agentPaybill_pay");
                iEASSignature.saveSignature4Web(signatureSubList, list, "agentPaybill_pay");
                ++success;
                continue;
            }
            catch (Exception e) {
                result.getDetailMsgList().add(CASWebUtil.getResource(ctx, "476_AGENTPAYBILL_PAY_FAILED", new String[]{info.getCompany().getName(), info.getNumber(), e.getMessage()}));
                continue;
            }
            finally {
                if (islocked) {
                    iMutex.releaseObjIDForUpdate(ids[i]);
                }
            }
        }
        summary = success == ids.length ? summary + CASWebUtil.getResource(ctx, "ALL_PAY_SUCCESS") : summary + CASWebUtil.getResource(ctx, "PAY_RESULT", new String[]{String.valueOf(success), String.valueOf(ids.length - success)});
        result.setSummaryMsg(summary);
        return result;
    }

    @Override
    protected Map _pay4CaById(Context ctx, String id, String plainText, String signature) throws BOSException, EASBizException {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("company.name"));
        sic.add(new SelectorItemInfo("company.id"));
        IAgentPayBill agentPayBill = AgentPayBillFactory.getLocalInstance(ctx);
        BatchExecuteResult result = new BatchExecuteResult();
        String summary = CASWebUtil.getResource(ctx, "PAY_SUCCESS");
        AgentPayBillInfo info = agentPayBill.getAgentPayBillInfo((IObjectPK)new ObjectUuidPK(id), sic);
        HashSet<String> idList = new HashSet<String>();
        idList.add(id);
        try {
            boolean isPermission = CASWebHelper.hasFunctionPermission(ctx, ctx.getCaller(), (IObjectPK)new ObjectUuidPK(info.getCompany().getId()), "agentPaybill_pay");
            if (!isPermission) {
                throw new CasWebException(CasWebException.NO_PAY_AUTHRIZED);
            }
            if (CASWebHelper.isAdjustPeriod(ctx, info.getCompany())) {
                throw new RuntimeException(CASWebUtil.getResource(ctx, "IN_ADJUST_PERIOD_SINGLE"));
            }
            IEASSignature iEASSignature = EASSignatureFactory.getLocalInstance((Context)ctx);
            ArrayList<String> list = new ArrayList<String>();
            list.add(id);
            iEASSignature.checkSignature4Web(list, "agentPaybill_pay");
            iEASSignature.checkSignature4Web(plainText, signature, "agentPaybill_pay");
            if (this.isInWorkFlow(id, ctx)) {
                result.setError(1);
                result.getDetailMsgList().add(CASWebUtil.getResource(ctx, "PAY_FAILED", new String[]{CASWebUtil.getResource(ctx, "ALREADY_IN_WORKFLOW")}));
                summary = CASWebUtil.getResource(ctx, "PAY_FAILED", new String[]{CASWebUtil.getResource(ctx, "ALREADY_IN_WORKFLOW")});
            } else {
                agentPayBill.pay(idList);
                iEASSignature.checkSignature4Web(list, "agentPaybill_pay");
                iEASSignature.saveSignature4Web(signature, plainText, id, "agentPaybill_pay");
                result.setError(0);
            }
        }
        catch (Exception e) {
            result.setError(1);
            result.getDetailMsgList().add(CASWebUtil.getResource(ctx, "PAY_FAILED", new String[]{e.getMessage()}));
            summary = CASWebUtil.getResource(ctx, "PAY_FAILED", new String[]{e.getMessage()});
        }
        result.setSummaryMsg(summary);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Map<String, Object> _batchCommitToBe(Context ctx, String[] ids) throws BOSException, EASBizException {
        BatchExecuteResult result = new BatchExecuteResult();
        if (EmptyUtil.isEmpty((Object[])ids)) {
            return result;
        }
        String summary = CASWebUtil.getResource(ctx, "BILLSUM", new String[]{ids.length + ""});
        String lockedString = CASWebUtil.getResource(ctx, "551_LOCKED");
        int success = 0;
        for (int i = 0; i < ids.length; ++i) {
            IAgentPayBill agentPayBill = AgentPayBillFactory.getLocalInstance(ctx);
            IMutexServiceControl iMutex = MutexServiceControlFactory.getLocalInstance((Context)ctx);
            String id = ids[i];
            HashSet<String> idSet = new HashSet<String>();
            idSet.add(id);
            try {
                if (idSet.size() > 1) {
                    throw new BEException(BEException.NOTALLOWBATCHSUBMIT);
                }
            }
            catch (Exception e) {
                result.setError(1);
                result.setSummaryMsg(e.getMessage());
                return result;
            }
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("number"));
            sic.add(new SelectorItemInfo("billStatus"));
            sic.add(new SelectorItemInfo("company.name"));
            sic.add(new SelectorItemInfo("company.id"));
            boolean isRequset = false;
            AgentPayBillInfo info = new AgentPayBillInfo();
            try {
                info = agentPayBill.getAgentPayBillInfo((IObjectPK)new ObjectUuidPK(id), sic);
                isRequset = iMutex.requestObjIDForUpdate(id);
                if (!isRequset) {
                    throw new RuntimeException(CASWebUtil.getResource(ctx, "AGENTPAYBILL_COMMITTOBE_FAILED", new String[]{info.getCompany().getName(), info.getNumber(), lockedString}));
                }
                boolean isPermission = CASWebHelper.hasFunctionPermission(ctx, ctx.getCaller(), (IObjectPK)new ObjectUuidPK(info.getCompany().getId()), "agentPaybill_commitBe");
                if (!isPermission) {
                    throw new CasWebException(CasWebException.NO_COMMITTOBE_AUTHRIZED);
                }
                if (CASWebHelper.isAdjustPeriod(ctx, info.getCompany())) {
                    throw new RuntimeException(CASWebUtil.getResource(ctx, "IN_ADJUST_PERIOD_SINGLE"));
                }
                if (!info.getBillStatus().equals((Object)BillStatusEnum.AUDITED)) {
                    throw new RuntimeException(CASWebUtil.getResource(ctx, "329_COMMITTOBE_AUDITED"));
                }
                Set bankPayingBillId = agentPayBill.commitToBE(idSet);
                AgentPayBillFactory.getLocalInstance(ctx).commitToBeAll(idSet, bankPayingBillId);
                ++success;
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
                result.setError(1);
                result.getDetailMsgList().add(CASWebUtil.getResource(ctx, "AGENTPAYBILL_COMMITTOBE_FAILED", new String[]{info.getCompany().getName(), info.getNumber(), e.getMessage()}));
                continue;
            }
            finally {
                if (isRequset) {
                    iMutex.releaseObjIDForUpdate(id);
                }
            }
        }
        if (success < ids.length) {
            result.setError(1);
            summary = summary + CASWebUtil.getResource(ctx, "COMMITTOBE_RESULT", new String[]{String.valueOf(success), String.valueOf(ids.length - success)});
        } else if (success == ids.length) {
            result.setError(0);
            summary = summary + CASWebUtil.getResource(ctx, "ALL_COMMITTOBE_SUCCESS");
        }
        result.setSummaryMsg(summary);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Map _batchCommitToBe4Ca(Context ctx, String[] ids, String signature) throws BOSException, EASBizException {
        BatchExecuteResult result = new BatchExecuteResult();
        if (EmptyUtil.isEmpty((Object[])ids)) {
            return result;
        }
        String summary = CASWebUtil.getResource(ctx, "BILLSUM", new String[]{ids.length + ""});
        List<String> signatureList = CASWebUtil.ids2List(signature != null ? signature.split(",") : null);
        ArrayList<String> newIds = new ArrayList<String>();
        if (signatureList != null) {
            for (int i = 0; i < ids.length; ++i) {
                boolean orgCheck = false;
                orgCheck = IDSecondAuthorizeFactory.getLocalInstance((Context)ctx).getCaOrgRangeCheck(ids[i], "agentPaybill_commitBe");
                if (!orgCheck) continue;
                newIds.add(ids[i]);
            }
        }
        if (signatureList == null || signatureList != null && signatureList.size() != newIds.size()) {
            result.setError(1);
            result.setSummaryMsg(summary + CASWebUtil.getResource(ctx, "345_COMMITTOBE_FAILED").concat(CASWebUtil.getResource(ctx, "342_SIGNATURE_CHK_ERR")));
            return result;
        }
        String lockedString = CASWebUtil.getResource(ctx, "551_LOCKED");
        int success = 0;
        for (int i = 0; i < ids.length; ++i) {
            IAgentPayBill agentPayBill = AgentPayBillFactory.getLocalInstance(ctx);
            IMutexServiceControl iMutex = MutexServiceControlFactory.getLocalInstance((Context)ctx);
            String id = ids[i];
            HashSet<String> idSet = new HashSet<String>();
            idSet.add(id);
            try {
                if (idSet.size() > 1) {
                    throw new BEException(BEException.NOTALLOWBATCHSUBMIT);
                }
            }
            catch (Exception e) {
                result.setError(1);
                result.setSummaryMsg(e.getMessage());
                return result;
            }
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("number"));
            sic.add(new SelectorItemInfo("billStatus"));
            sic.add(new SelectorItemInfo("company.name"));
            sic.add(new SelectorItemInfo("company.id"));
            boolean isRequset = false;
            AgentPayBillInfo info = new AgentPayBillInfo();
            try {
                info = agentPayBill.getAgentPayBillInfo((IObjectPK)new ObjectUuidPK(id), sic);
                isRequset = iMutex.requestObjIDForUpdate(id);
                if (!isRequset) {
                    throw new RuntimeException(CASWebUtil.getResource(ctx, "AGENTPAYBILL_COMMITTOBE_FAILED", new String[]{info.getCompany().getName(), info.getNumber(), lockedString}));
                }
                boolean isPermission = CASWebHelper.hasFunctionPermission(ctx, ctx.getCaller(), (IObjectPK)new ObjectUuidPK(info.getCompany().getId()), "agentPaybill_commitBe");
                if (!isPermission) {
                    throw new CasWebException(CasWebException.NO_COMMITTOBE_AUTHRIZED);
                }
                if (CASWebHelper.isAdjustPeriod(ctx, info.getCompany())) {
                    throw new RuntimeException(CASWebUtil.getResource(ctx, "IN_ADJUST_PERIOD_SINGLE"));
                }
                if (!info.getBillStatus().equals((Object)BillStatusEnum.AUDITED)) {
                    throw new RuntimeException(CASWebUtil.getResource(ctx, "329_COMMITTOBE_AUDITED"));
                }
                IEASSignature iEASSignature = EASSignatureFactory.getLocalInstance((Context)ctx);
                ArrayList<String> list = new ArrayList<String>();
                list.add(ids[0]);
                iEASSignature.checkSignature4Web(list, "agentPaybill_commitBe");
                ArrayList<String> signatureSubList = new ArrayList<String>();
                signatureSubList.add(signatureList.get(0));
                iEASSignature.checkSignature4Web(list, signatureSubList, "agentPaybill_commitBe");
                Set bankPayingBillId = agentPayBill.commitToBE(idSet);
                AgentPayBillFactory.getLocalInstance(ctx).commitToBeAll(idSet, bankPayingBillId);
                iEASSignature.checkSignature4Web(list, "agentPaybill_commitBe");
                iEASSignature.saveSignature4Web(signatureSubList, list, "agentPaybill_commitBe");
                ++success;
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
                result.setError(1);
                result.getDetailMsgList().add(CASWebUtil.getResource(ctx, "AGENTPAYBILL_COMMITTOBE_FAILED", new String[]{info.getCompany().getName(), info.getNumber(), e.getMessage()}));
                continue;
            }
            finally {
                if (isRequset) {
                    iMutex.releaseObjIDForUpdate(id);
                }
            }
        }
        if (success < ids.length) {
            result.setError(1);
            summary = summary + CASWebUtil.getResource(ctx, "COMMITTOBE_RESULT", new String[]{String.valueOf(success), String.valueOf(ids.length - success)});
        } else if (success == ids.length) {
            result.setError(0);
            summary = summary + CASWebUtil.getResource(ctx, "ALL_COMMITTOBE_SUCCESS");
        }
        result.setSummaryMsg(summary);
        return result;
    }

    @Override
    protected Map _commitToBe4Ca(Context ctx, String id, String plainText, String signature) throws BOSException, EASBizException {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("billStatus"));
        sic.add(new SelectorItemInfo("company.name"));
        sic.add(new SelectorItemInfo("company.id"));
        IAgentPayBill agentPayBill = AgentPayBillFactory.getLocalInstance(ctx);
        BatchExecuteResult result = new BatchExecuteResult();
        String summary = CASWebUtil.getResource(ctx, "332_COMMITTOBE_SUCCESS");
        AgentPayBillInfo info = agentPayBill.getAgentPayBillInfo((IObjectPK)new ObjectUuidPK(id), sic);
        try {
            boolean isPermission = CASWebHelper.hasFunctionPermission(ctx, ctx.getCaller(), (IObjectPK)new ObjectUuidPK(info.getCompany().getId()), "agentPaybill_commitBe");
            if (!isPermission) {
                throw new CasWebException(CasWebException.NO_COMMITTOBE_AUTHRIZED);
            }
            if (CASWebHelper.isAdjustPeriod(ctx, info.getCompany())) {
                throw new RuntimeException(CASWebUtil.getResource(ctx, "IN_ADJUST_PERIOD_SINGLE"));
            }
            if (!info.getBillStatus().equals((Object)BillStatusEnum.AUDITED)) {
                throw new RuntimeException(CASWebUtil.getResource(ctx, "329_COMMITTOBE_AUDITED"));
            }
            IEASSignature iEASSignature = EASSignatureFactory.getLocalInstance((Context)ctx);
            ArrayList<String> list = new ArrayList<String>();
            list.add(id);
            iEASSignature.checkSignature4Web(list, "agentPaybill_commitBe");
            iEASSignature.checkSignature4Web(plainText, signature, "agentPaybill_commitBe");
            HashSet<String> idSet = new HashSet<String>();
            idSet.add(id);
            Set bankPayingBillId = agentPayBill.commitToBE(idSet);
            AgentPayBillFactory.getLocalInstance(ctx).commitToBeAll(idSet, bankPayingBillId);
            iEASSignature.checkSignature4Web(list, "agentPaybill_commitBe");
            iEASSignature.saveSignature4Web(signature, plainText, id, "agentPaybill_commitBe");
            result.setError(0);
        }
        catch (WfBizException e) {
            result.setError(1);
            result.getDetailMsgList().add(CASWebUtil.getResource(ctx, "333_COMMITTOBE_FAILED", new String[]{CASWebUtil.getResource(ctx, "ALREADY_IN_WORKFLOW")}));
            summary = CASWebUtil.getResource(ctx, "333_COMMITTOBE_FAILED", new String[]{CASWebUtil.getResource(ctx, "ALREADY_IN_WORKFLOW")});
        }
        catch (Exception e) {
            result.setError(1);
            result.getDetailMsgList().add(CASWebUtil.getResource(ctx, "333_COMMITTOBE_FAILED", new String[]{e.getMessage()}));
            summary = CASWebUtil.getResource(ctx, "333_COMMITTOBE_FAILED", new String[]{e.getMessage()});
        }
        result.setSummaryMsg(summary);
        return result;
    }

    @Override
    protected Map _auditById4Ca(Context ctx, String id, String plainText, String signature) throws BOSException, EASBizException {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("company.name"));
        sic.add(new SelectorItemInfo("company.id"));
        IAgentPayBill agentPayBill = AgentPayBillFactory.getLocalInstance(ctx);
        BatchExecuteResult result = new BatchExecuteResult();
        String summary = CASWebUtil.getResource(ctx, "AUDIT_SUCCESS");
        AgentPayBillInfo info = agentPayBill.getAgentPayBillInfo((IObjectPK)new ObjectUuidPK(id), sic);
        HashSet<String> idList = new HashSet<String>();
        idList.add(id);
        try {
            boolean isPermission = CASWebHelper.hasFunctionPermission(ctx, ctx.getCaller(), (IObjectPK)new ObjectUuidPK(info.getCompany().getId()), "agentPaybill_audit");
            if (!isPermission) {
                throw new CasWebException(CasWebException.NO_AUDIT_AUTHRIZED);
            }
            if (CASWebHelper.isAdjustPeriod(ctx, info.getCompany())) {
                throw new RuntimeException(CASWebUtil.getResource(ctx, "IN_ADJUST_PERIOD_SINGLE"));
            }
            IEASSignature iEASSignature = EASSignatureFactory.getLocalInstance((Context)ctx);
            ArrayList<String> list = new ArrayList<String>();
            list.add(id);
            iEASSignature.checkSignature4Web(list, "agentPaybill_audit");
            iEASSignature.checkSignature4Web(plainText, signature, "agentPaybill_audit");
            if (this.isInWorkFlow(id, ctx)) {
                result.setError(1);
                result.getDetailMsgList().add(CASWebUtil.getResource(ctx, "AUDIT_FAILED", new String[]{CASWebUtil.getResource(ctx, "ALREADY_IN_WORKFLOW")}));
                summary = CASWebUtil.getResource(ctx, "AUDIT_FAILED", new String[]{CASWebUtil.getResource(ctx, "ALREADY_IN_WORKFLOW")});
            } else {
                agentPayBill.audit(idList);
                iEASSignature.checkSignature4Web(list, "agentPaybill_audit");
                iEASSignature.saveSignature4Web(signature, plainText, id, "agentPaybill_audit");
                result.setError(0);
            }
        }
        catch (Exception e) {
            logger.equals(e);
            result.setError(1);
            result.getDetailMsgList().add(CASWebUtil.getResource(ctx, "AUDIT_FAILED", new String[]{e.getMessage()}));
            summary = CASWebUtil.getResource(ctx, "AUDIT_FAILED", new String[]{e.getMessage()});
        }
        result.setSummaryMsg(summary);
        return result;
    }

    @Override
    protected Map _submit4Ca(Context ctx, AgentPayBillInfo info, String plainText, String signature) throws BOSException, EASBizException {
        HashMap<String, Object> pageModel = new HashMap<String, Object>();
        try {
            IAgentPayBill iAgentPayBill = AgentPayBillFactory.getLocalInstance(ctx);
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add("billStatus");
            if (info.getId() != null && iAgentPayBill.exists((IObjectPK)new ObjectUuidPK(info.getId().toString()))) {
                boolean isEdit = CASWebHelper.hasFunctionPermission(ctx, ctx.getCaller(), (IObjectPK)new ObjectUuidPK(info.getCompany().getId()), "agentPaybill_batchSubmit");
                if (!isEdit) {
                    throw new CasWebException(CasWebException.NO_SUBMIT_AUTHRIZED);
                }
                AgentPayBillInfo oldInfo = (AgentPayBillInfo)iAgentPayBill.getValue((IObjectPK)new ObjectUuidPK(info.getId().toString()), sic);
                if (oldInfo.getBillStatus().getValue() != 10 && oldInfo.getBillStatus().getValue() != 11) {
                    throw new RuntimeException(CASWebUtil.getResource(ctx, "304_BILL_STATUS_NOT_SUBMIT", new String[]{oldInfo.getBillStatus().toString()}));
                }
                if (this.isInWorkFlow(info.getId().toString(), ctx)) {
                    throw new RuntimeException(CASWebUtil.getResource(ctx, "ALREADY_IN_WORKFLOW"));
                }
            }
            if (PeriodHelper.isAdjustPeriod(ctx, info.getCompany().getId().toString())) {
                throw new RuntimeException(CASWebUtil.getResource(ctx, "IN_ADJUST_PERIOD", new String[]{info.getNumber()}));
            }
            if (this.isStatusChanged(ctx, info)) {
                throw new RuntimeException(CASWebUtil.getResource(ctx, "CANNOT_SUBMIT_BILL_STATUS_CHANGED"));
            }
            if (info.getId() != null && info.getNumber() == null && !iAgentPayBill.exists((IObjectPK)new ObjectUuidPK(info.getId().toString()))) {
                String numberSilent = NumberRuleUtil.getNumberSilent((Context)ctx, (CoreBaseInfo)info, (String)info.getCompany().getId().toString());
                info.setNumber(numberSilent);
                this.checkNumberDup(ctx, info);
            }
            IEASSignature iEASSignature = EASSignatureFactory.getLocalInstance((Context)ctx);
            ArrayList<String> list = new ArrayList<String>();
            list.add(info.getId().toString());
            iEASSignature.checkSignature4Web(list, "agentPaybill_batchSubmit");
            iEASSignature.checkSignature4Web(plainText, signature, "agentPaybill_batchSubmit");
            this.verifyBeforeSubmit(ctx, info);
            IObjectPK objectPK = this.getSubmitPk(ctx, iAgentPayBill, info);
            iEASSignature.checkSignature4Web(list, "agentPaybill_batchSubmit");
            iEASSignature.saveSignature4Web(signature, plainText, info.getId().toString(), "agentPaybill_batchSubmit");
            pageModel.put("id", objectPK.toString());
            pageModel.put("error", 0);
        }
        catch (WfBizException e) {
            pageModel.put("error", 1);
            pageModel.put("msg", CASWebUtil.getResource(ctx, "ALREADY_IN_WORKFLOW"));
        }
        catch (Exception e) {
            e.printStackTrace();
            pageModel.put("error", 1);
            pageModel.put("msg", e.getMessage());
        }
        return pageModel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Map _batchSubmit4Ca(Context ctx, String[] ids, String signature) throws BOSException, EASBizException {
        IAgentPayBill agentPayBill = AgentPayBillFactory.getLocalInstance(ctx);
        BatchExecuteResult result = new BatchExecuteResult();
        String summary = CASWebUtil.getResource(ctx, "BILLSUM", new String[]{ids.length + ""});
        int success = ids.length;
        List<String> signatureList = CASWebUtil.ids2List(signature != null ? signature.split(",") : null);
        if (signatureList == null || signatureList != null && signatureList.size() != ids.length) {
            result.setError(1);
            result.setSummaryMsg(summary + CASWebUtil.getResource(ctx, "345_COMMITTOBE_FAILED").concat(CASWebUtil.getResource(ctx, "342_SIGNATURE_CHK_ERR")));
            return result;
        }
        IMutexServiceControl iMutex = MutexServiceControlFactory.getLocalInstance((Context)ctx);
        for (int i = 0; i < ids.length; ++i) {
            boolean islocked = false;
            AgentPayBillInfo info = agentPayBill.getAgentPayBillInfo((IObjectPK)new ObjectUuidPK(ids[i]), this.getSelector());
            ArrayList<String> idList = new ArrayList<String>();
            idList.add(ids[i]);
            try {
                islocked = iMutex.requestObjIDForUpdate(ids[i]);
                if (!islocked) {
                    throw new RuntimeException(CASWebUtil.getResource(ctx, "HAS_LOCKED"));
                }
                boolean isPermission = CASWebHelper.hasFunctionPermission(ctx, ctx.getCaller(), (IObjectPK)new ObjectUuidPK(info.getCompany().getId()), "agentPaybill_batchSubmit");
                if (!isPermission) {
                    throw new CasWebException(CasWebException.NO_SUBMIT_AUTHRIZED);
                }
                if (CASWebHelper.isAdjustPeriod(ctx, info.getCompany())) {
                    throw new RuntimeException(CASWebUtil.getResource(ctx, "IN_ADJUST_PERIOD_SINGLE"));
                }
                if (info.getBillStatus() != BillStatusEnum.SAVE && info.getBillStatus() != BillStatusEnum.SUBMIT) {
                    throw new RuntimeException(CASWebUtil.getResource(ctx, CASRES, "169_PaymentBillControllerBean"));
                }
                IEASSignature iEASSignature = EASSignatureFactory.getLocalInstance((Context)ctx);
                ArrayList<String> list = new ArrayList<String>();
                list.add(ids[i]);
                iEASSignature.checkSignature4Web(list, "agentPaybill_batchSubmit");
                ArrayList<String> signatureSubList = new ArrayList<String>();
                signatureSubList.add(signatureList.get(0));
                iEASSignature.checkSignature4Web(list, signatureSubList, "agentPaybill_batchSubmit");
                this.verifyBeforeSubmit(ctx, info);
                Map errorMsg = agentPayBill.saveBatch(idList);
                iEASSignature.checkSignature4Web(list, "agentPaybill_batchSubmit");
                iEASSignature.saveSignature4Web(signatureSubList, list, "agentPaybill_batchSubmit");
                continue;
            }
            catch (WfBizException e) {
                --success;
                result.getDetailMsgList().add(CASWebUtil.getResource(ctx, "472_AGENTPAYBILL_SUBMIT_FAILED", new String[]{info.getCompany().getName(), info.getNumber(), CASWebUtil.getResource(ctx, "ALREADY_IN_WORKFLOW")}));
                continue;
            }
            catch (Exception e) {
                --success;
                result.getDetailMsgList().add(CASWebUtil.getResource(ctx, "472_AGENTPAYBILL_SUBMIT_FAILED", new String[]{info.getCompany().getName(), info.getNumber(), e.getMessage()}));
                continue;
            }
            finally {
                if (islocked) {
                    iMutex.releaseObjIDForUpdate(ids[i]);
                }
            }
        }
        summary = success == ids.length ? summary + CASWebUtil.getResource(ctx, "ALL_SUBMIT_SUCCESS") : summary + CASWebUtil.getResource(ctx, "SUBMIT_RESULT", new String[]{String.valueOf(success), String.valueOf(ids.length - success)});
        result.setSummaryMsg(summary);
        return result;
    }

    @Override
    protected Map _imageById(Context ctx, String id) throws BOSException, EASBizException {
        HashMap<String, Object> pageModel = new HashMap<String, Object>();
        try {
            IBillImageFacade image = BillImageFacadeFactory.getLocalInstance((Context)ctx);
            String imageUrl = image.getImageURL(BOSUuid.read((String)id).getType().toString(), id);
            if (StringUtils.isEmpty((String)imageUrl) || "null".equalsIgnoreCase(imageUrl)) {
                pageModel.put("error", 1);
                pageModel.put("summaryMsg", CASWebUtil.getResource(ctx, "ShareCenter_NO_ImageUrl"));
            } else {
                pageModel.put("error", 0);
                pageModel.put("imageUrl", imageUrl);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            pageModel.put("error", 1);
            pageModel.put("summaryMsg", CASWebUtil.getResource(ctx, "ShareCenter_NO_ImageUrl"));
        }
        return pageModel;
    }

    @Override
    protected Map _beforeGenBill(Context ctx, String[] ids) throws BOSException, EASBizException {
        HashMap<String, Object> pageModel = new HashMap<String, Object>();
        try {
            IAgentPayBill iAgentPayBill = AgentPayBillFactory.getLocalInstance(ctx);
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add("*");
            sic.add("entrys.*");
            AgentPayBillInfo info = iAgentPayBill.getAgentPayBillInfo((IObjectPK)new ObjectUuidPK(ids[0]), sic);
            AgentPayBillEntryInfo entryInfo = null;
            int failCount = 0;
            int midState = 0;
            for (int i = 0; i < info.getEntrys().size(); ++i) {
                entryInfo = info.getEntrys().get(i);
                if (!EmptyUtil.isEmpty((Object)entryInfo.getState()) && entryInfo.getState().equals((Object)BankPayingBillStateEnum.TF)) {
                    ++failCount;
                }
                if (entryInfo.getState().equals((Object)BankPayingBillStateEnum.TF) || entryInfo.getState().equals((Object)BankPayingBillStateEnum.TS)) continue;
                ++midState;
            }
            if (failCount <= 0 || !info.isIsCommitToBE()) {
                throw new CasException(CasException.COMMMON, new Object[]{EASCommonResource.getString((String)"com.kingdee.eas.fi.cas.CasResource", (String)"GenAgentPayBillErr", (Locale)ctx.getLocale())});
            }
            if (info.isIsGenerateBill()) {
                throw new CasException(CasException.COMMMON, new Object[]{EASCommonResource.getString((String)"com.kingdee.eas.fi.cas.CasResource", (String)"NotAllowGenAgentPayBill", (Locale)ctx.getLocale())});
            }
            pageModel.put("error", 0);
            pageModel.put("comfirm", midState);
        }
        catch (Exception e) {
            e.printStackTrace();
            pageModel.put("error", 1);
            pageModel.put("msg", e.getMessage());
        }
        return pageModel;
    }
}

