/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.cas.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.service.IServiceContext;
import com.kingdee.eas.base.netctrl.MutexServiceControlFactory;
import com.kingdee.eas.base.permission.PermissionServiceException;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.cas.AgentPayBillCollection;
import com.kingdee.eas.fi.cas.AgentPayBillFactory;
import com.kingdee.eas.fi.cas.AgentPayBillInfo;
import com.kingdee.eas.fi.cas.BillStatusEnum;
import com.kingdee.eas.fi.cas.IAgentPayBill;
import com.kingdee.eas.fi.cas.app.CasAndFmServiceAdapter;
import com.kingdee.eas.fi.cas.utils.PayAdmitUtils;
import com.kingdee.eas.fm.be.BEException;
import com.kingdee.eas.framework.CoreBaseInfo;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class AgentPayEventServiceAdapter
extends CasAndFmServiceAdapter {
    @Override
    public void beforeVerify(IServiceContext svcCtx) throws BOSException {
        Map result = this.getMethodName(svcCtx);
        Context ctx = svcCtx.getContext();
        String methodName = (String)result.get("methodName");
        Object[] parameters = svcCtx.getOperationParameters();
        if (methodName != null) {
            ArrayList<String> correctList = new ArrayList<String>();
            ArrayList<String> lockedList = new ArrayList<String>();
            try {
                this.admitVerify(ctx, methodName, parameters);
                this.billStatusVerify(ctx, methodName, parameters);
                this.mutexsVerify(ctx, methodName, parameters, correctList, lockedList);
            }
            catch (EASBizException e) {
                throw new PermissionServiceException(e.getMessage());
            }
            finally {
                if (correctList.size() > 0) {
                    MutexServiceControlFactory.getLocalInstance((Context)ctx).batchReleaseObjIDForUpdate(correctList);
                }
            }
        }
    }

    private void mutexsVerify(Context ctx, String methodName, Object[] parameters, List<String> correctList, List<String> lockedList) throws BOSException, EASBizException {
        String id;
        ArrayList<String> allIdList;
        Object object;
        if ((methodName.equalsIgnoreCase("batchSubmit") || methodName.equalsIgnoreCase("batchSubmit4Ca") || methodName.equalsIgnoreCase("batchAudit") || methodName.equalsIgnoreCase("batchAudit4Ca") || methodName.equalsIgnoreCase("batchPay") || methodName.equalsIgnoreCase("batchPay4Ca") || methodName.equalsIgnoreCase("batchUnaudit") || methodName.equalsIgnoreCase("batchCancelPay")) && (object = parameters[1]) != null && object instanceof String[]) {
            int i;
            String[] ids = (String[])object;
            allIdList = new ArrayList<String>();
            for (i = 0; i < ids.length; ++i) {
                allIdList.add(ids[i]);
            }
            this.requesMutexs(ctx, allIdList, correctList, lockedList);
            for (i = 0; i < ids.length; ++i) {
                AgentPayBillInfo info = AgentPayBillFactory.getLocalInstance(ctx).getAgentPayBillInfo((IObjectPK)new ObjectUuidPK(ids[i]));
                if (!lockedList.contains(info.getId().toString())) continue;
                throw new BEException(BEException.COMMON, (Object[])new String[]{"\u5355\u636e\u5df2\u88ab\u9501\u5b9a" + this.commTag});
            }
        }
        if (methodName.equalsIgnoreCase("saveBatch") && (object = parameters[1]) != null && object instanceof List) {
            List idList = (List)object;
            EntityViewInfo env = new EntityViewInfo();
            FilterInfo f = new FilterInfo();
            HashSet idSet = new HashSet();
            idSet.addAll(idList);
            f.getFilterItems().add(new FilterItemInfo("id", idSet, CompareType.INCLUDE));
            env.setFilter(f);
            AgentPayBillCollection collection = AgentPayBillFactory.getLocalInstance(ctx).getAgentPayBillCollection(env);
            this.requesMutexs(ctx, idList, correctList, lockedList);
            for (int i = 0; i < collection.size(); ++i) {
                AgentPayBillInfo billInfo = collection.get(i);
                if (!lockedList.contains(billInfo.getId().toString())) continue;
                throw new BEException(BEException.COMMON, (Object[])new String[]{"\u5355\u636e\u5df2\u88ab\u9501\u5b9a" + this.commTag});
            }
        }
        if ((methodName.equalsIgnoreCase("auditById") || methodName.equalsIgnoreCase("unauditById") || methodName.equalsIgnoreCase("payById") || methodName.equalsIgnoreCase("cancelPayById") || methodName.equalsIgnoreCase("deleteById")) && (object = parameters[1]) != null && object instanceof String) {
            id = (String)object;
            allIdList = new ArrayList();
            allIdList.add(id);
            this.requesMutexs(ctx, allIdList, correctList, lockedList);
            if (lockedList.size() > 0) {
                throw new BEException(BEException.COMMON, (Object[])new String[]{"\u5355\u636e\u5df2\u88ab\u9501\u5b9a" + this.commTag});
            }
        }
        if (methodName.equalsIgnoreCase("delete") && (object = parameters[1]) != null && object instanceof IObjectPK) {
            id = (IObjectPK)object;
            allIdList = new ArrayList();
            allIdList.add(id.toString());
            this.requesMutexs(ctx, allIdList, correctList, lockedList);
            if (lockedList.size() > 0) {
                throw new BEException(BEException.COMMON, (Object[])new String[]{"\u5355\u636e\u5df2\u88ab\u9501\u5b9a" + this.commTag});
            }
        }
    }

    private void billStatusVerify(Context ctx, String methodName, Object[] parameters) throws BOSException, EASBizException {
        AgentPayBillInfo oldInfo;
        AgentPayBillInfo info;
        Object object;
        if (methodName.equalsIgnoreCase("save") && (object = parameters[1]) != null && object instanceof AgentPayBillInfo && (info = (AgentPayBillInfo)object).getId() != null && AgentPayEventServiceAdapter.isStatusChanged(ctx, info)) {
            throw new BEException(BEException.COMMON, (Object[])new String[]{"\u5355\u636e\u72b6\u6001\u5df2\u7ecf\u6539\u53d8\uff0c\u4e0d\u80fd\u4fdd\u5b58\uff01" + this.commTag});
        }
        if (methodName.equalsIgnoreCase("submit") && (object = parameters[1]) != null && object instanceof AgentPayBillInfo && (info = (AgentPayBillInfo)object).getId() != null && AgentPayBillFactory.getLocalInstance(ctx).exists((IObjectPK)new ObjectUuidPK(info.getId())) && (oldInfo = AgentPayBillFactory.getLocalInstance(ctx).getAgentPayBillInfo((IObjectPK)new ObjectStringPK(info.getId().toString()))).getBillStatus().getValue() != 10 && oldInfo.getBillStatus().getValue() != 11) {
            throw new BEException(BEException.COMMON, (Object[])new String[]{"\u5355\u636e\u72b6\u6001\u4e0d\u662f\u4fdd\u5b58\u6216\u8005\u63d0\u4ea4\uff0c\u4e0d\u80fd\u63d0\u4ea4\uff01" + this.commTag});
        }
        if (methodName.equalsIgnoreCase("saveBatch") && (object = parameters[1]) != null && object instanceof List) {
            List idList = (List)object;
            EntityViewInfo env = new EntityViewInfo();
            FilterInfo f = new FilterInfo();
            HashSet idSet = new HashSet();
            idSet.addAll(idList);
            f.getFilterItems().add(new FilterItemInfo("id", idSet, CompareType.INCLUDE));
            env.setFilter(f);
            AgentPayBillCollection collection = AgentPayBillFactory.getLocalInstance(ctx).getAgentPayBillCollection(env);
            for (int i = 0; i < collection.size(); ++i) {
                AgentPayBillInfo billInfo = collection.get(i);
                if (billInfo.getBillStatus().getValue() == 10 || billInfo.getBillStatus().getValue() == 11) continue;
                throw new BEException(BEException.COMMON, (Object[])new String[]{"\u5355\u636e\u72b6\u6001\u4e0d\u662f\u4fdd\u5b58\u6216\u8005\u63d0\u4ea4\uff0c\u4e0d\u80fd\u63d0\u4ea4\uff01" + this.commTag});
            }
        }
        if (methodName.equalsIgnoreCase("cancelPay") && parameters[1] != null && parameters[1] instanceof Set) {
            EntityViewInfo idview = new EntityViewInfo();
            Set idSet = (Set)parameters[1];
            FilterInfo idfilter = new FilterInfo();
            idview.setFilter(idfilter);
            idfilter.getFilterItems().add(new FilterItemInfo("id", (Object)idSet, CompareType.INCLUDE));
            AgentPayBillCollection agentPayBillColl = AgentPayBillFactory.getLocalInstance(ctx).getAgentPayBillCollection(idview);
            for (int idseq = 0; idseq < agentPayBillColl.size(); ++idseq) {
                AgentPayBillInfo info2 = agentPayBillColl.get(idseq);
                if (info2.getBillStatus().equals((Object)BillStatusEnum.PAYED)) continue;
                throw new BEException(BEException.COMMON, (Object[])new String[]{"\u53ea\u6709\u5df2\u4ed8\u6b3e\u72b6\u6001\u7684\u5355\u636e\u624d\u80fd\u53d6\u6d88\u4ed8\u6b3e" + this.commTag});
            }
        }
    }

    private void admitVerify(Context ctx, String methodName, Object[] parameters) throws BOSException, EASBizException {
        AgentPayBillInfo info;
        Object object;
        if (methodName.equalsIgnoreCase("addNew") && (object = parameters[1]) != null && object instanceof AgentPayBillInfo) {
            info = (AgentPayBillInfo)object;
            PayAdmitUtils.verifyPayadmit(ctx, (CoreBaseInfo)info, true);
        }
        if (methodName.equalsIgnoreCase("update") && parameters.length > 2 && (object = parameters[2]) != null && object instanceof AgentPayBillInfo) {
            info = (AgentPayBillInfo)object;
            PayAdmitUtils.verifyPayadmit(ctx, (CoreBaseInfo)info, false);
        }
    }

    @Override
    public void afterDeal(IServiceContext svcCtx) throws BOSException {
    }

    private static boolean isStatusChanged(Context ctx, AgentPayBillInfo info) throws BOSException {
        IAgentPayBill iAgentPayBill = AgentPayBillFactory.getLocalInstance(ctx);
        boolean changed = false;
        AgentPayBillInfo agentPayBillInfo = null;
        AgentPayBillCollection coll = null;
        EntityViewInfo query = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        query.setFilter(filter);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("billStatus");
        sic.add("Fivouchered");
        query.setSelector(sic);
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)info.getId().toString()));
        coll = iAgentPayBill.getAgentPayBillCollection(query);
        if (coll.size() > 0) {
            agentPayBillInfo = coll.get(0);
            if (info.getBillStatus() != agentPayBillInfo.getBillStatus()) {
                changed = true;
            }
            if (info.isFivouchered() != agentPayBillInfo.isFivouchered()) {
                changed = true;
            }
        }
        return changed;
    }
}

