/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.cas.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.appframework.databinding.BindingUtility;
import com.kingdee.bos.appframework.databinding.Field;
import com.kingdee.bos.ctrl.extendcontrols.util.BosHelper;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.bot.BOTRelationCollection;
import com.kingdee.bos.metadata.bot.BOTRelationFactory;
import com.kingdee.bos.metadata.bot.IBOTRelation;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.base.attachment.BizobjectFacadeFactory;
import com.kingdee.eas.base.btp.BTPManagerFactory;
import com.kingdee.eas.base.btp.BTPTransformResult;
import com.kingdee.eas.base.btp.IBTPManager;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.basedata.assistant.AccountBankInfo;
import com.kingdee.eas.basedata.assistant.BankFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.ExchangeRateInfo;
import com.kingdee.eas.basedata.master.account.AccountViewInfo;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeCollection;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeFactory;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeInfo;
import com.kingdee.eas.basedata.master.cssp.CSSPGroupStandardFactory;
import com.kingdee.eas.basedata.master.cssp.ICSSPGroupStandard;
import com.kingdee.eas.basedata.master.cssp.SupplierFactory;
import com.kingdee.eas.basedata.master.material.MaterialFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.SysConstant;
import com.kingdee.eas.fi.cas.BillStatusEnum;
import com.kingdee.eas.fi.cas.CasException;
import com.kingdee.eas.fi.cas.CasRecPayAsstActTypeHelper;
import com.kingdee.eas.fi.cas.CasRecPayBillTypeEnum;
import com.kingdee.eas.fi.cas.CashHelper;
import com.kingdee.eas.fi.cas.IPaymentBill;
import com.kingdee.eas.fi.cas.PaymentBillEntryCollection;
import com.kingdee.eas.fi.cas.PaymentBillEntryInfo;
import com.kingdee.eas.fi.cas.PaymentBillFactory;
import com.kingdee.eas.fi.cas.PaymentBillInfo;
import com.kingdee.eas.fi.cas.PropertySynchronizer;
import com.kingdee.eas.fi.cas.RecPayException;
import com.kingdee.eas.fi.cas.ReceivingBillEntryCollection;
import com.kingdee.eas.fi.cas.ReceivingBillEntryInfo;
import com.kingdee.eas.fi.cas.ReceivingBillFactory;
import com.kingdee.eas.fi.cas.ReceivingBillInfo;
import com.kingdee.eas.fi.cas.SourceTypeEnum;
import com.kingdee.eas.fm.common.ContextHelperFactory;
import com.kingdee.eas.fm.common.ConvertUtils;
import com.kingdee.eas.fm.common.FMIsqlFacadeFactory;
import com.kingdee.eas.fm.common.FMVerifyHelper;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.CoreBillBaseCollection;
import com.kingdee.eas.framework.CoreBillBaseInfo;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import org.apache.log4j.Logger;

public class AgentRecPayServerHelper {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fi.cas.app.AgentRecPayServerHelper");

    public static void saveOrSubmitPaymentBillForAgentPay(Context ctx, PaymentBillInfo paymentBill) throws BOSException, EASBizException {
        AgentRecPayServerHelper.setOtherPropsForPaymentBill(ctx, paymentBill);
    }

    public static void saveOrSubmitPaymentBillForAgentRec(Context ctx, ReceivingBillInfo receivingBill) throws BOSException, EASBizException {
        AgentRecPayServerHelper.setOtherPropsForReceivingBill(ctx, receivingBill);
    }

    public static void verifyPaymentBillAcctBank(Context ctx, PaymentBillInfo paymentBill) throws BOSException, EASBizException {
        CompanyOrgUnitInfo company = paymentBill.getAgentPayCompany();
        AccountBankInfo acct = paymentBill.getPayerAccountBank();
        if (company == null || acct == null || paymentBill.getAuditor() != null) {
            return;
        }
        if (CasRecPayBillTypeEnum.commonType.equals((Object)paymentBill.getPaymentBillType())) {
            return;
        }
    }

    public static void verifyReceivingBillAcctBank(Context ctx, ReceivingBillInfo receivingbill) throws BOSException, EASBizException {
        CompanyOrgUnitInfo company = receivingbill.getRealRecCompany();
        AccountBankInfo acct = receivingbill.getPayeeAccountBank();
        if (company == null || acct == null) {
            return;
        }
        if (!CasRecPayBillTypeEnum.AgentType.equals((Object)receivingbill.getReceivingBillType())) {
            return;
        }
        boolean isTrustCompanyAcct = acct.getCompany().getId().equals((Object)company.getId());
        boolean isOwnCompanyAcct = acct.getCompany().getId().equals((Object)receivingbill.getCompany().getId());
        if (!isOwnCompanyAcct && !isTrustCompanyAcct) {
            throw new RecPayException(RecPayException.PAYEEACCTBANKNOTTURSTEDRIGHT);
        }
    }

    public static void setOtherPropsForPaymentBill(Context ctx, PaymentBillInfo paymentBill) throws BOSException, EASBizException {
        IPaymentBill biz;
        CompanyOrgUnitInfo company = paymentBill.getAgentPayCompany();
        boolean isClearHouseCompany = false;
        if (company != null) {
            isClearHouseCompany = BankFactory.getLocalInstance((Context)ctx).isClearinghouseCompany(company.getId().toString());
        }
        if (SourceTypeEnum.AP.equals((Object)paymentBill.getSourceType()) && paymentBill.getId() != null && (biz = PaymentBillFactory.getLocalInstance(ctx)).exists(ConvertUtils.PK((Object)paymentBill))) {
            paymentBill.setSrcAgenPaymentBillID(biz.getPaymentBillInfo(ConvertUtils.PK((Object)paymentBill)).getSrcAgenPaymentBillID());
        }
        boolean flag = EmptyUtil.isEmpty((String)paymentBill.getSrcAgenPaymentBillID());
        if (company != null) {
            if (isClearHouseCompany) {
                paymentBill.setPaymentBillType(CasRecPayBillTypeEnum.commonType);
                throw new RecPayException(RecPayException.AGENTPAYCOMPANYISSC);
            }
            paymentBill.setPaymentBillType(CasRecPayBillTypeEnum.RealType);
        } else if (flag) {
            paymentBill.setPaymentBillType(CasRecPayBillTypeEnum.commonType);
        } else {
            paymentBill.setPaymentBillType(CasRecPayBillTypeEnum.AgentType);
        }
    }

    public static void setOtherPropsForReceivingBill(Context ctx, ReceivingBillInfo receivingBill) throws BOSException, EASBizException {
        CompanyOrgUnitInfo company = receivingBill.getRealRecCompany();
        if (company != null) {
            receivingBill.setReceivingBillType(CasRecPayBillTypeEnum.AgentType);
        } else if (company == null && !EmptyUtil.isEmpty((String)receivingBill.getSrcRealRecBillID())) {
            receivingBill.setReceivingBillType(CasRecPayBillTypeEnum.RealType);
        } else {
            receivingBill.setReceivingBillType(CasRecPayBillTypeEnum.commonType);
        }
    }

    public static PaymentBillInfo botpTransformAgentPaymentbill(Context ctx, PaymentBillInfo info) throws BOSException, EASBizException {
        BOSObjectType bosType = new PaymentBillInfo().getBOSType();
        CoreBillBaseCollection paymentBillColl = new CoreBillBaseCollection();
        paymentBillColl.add((CoreBillBaseInfo)info);
        IBTPManager iBTPManager = BTPManagerFactory.getLocalInstance((Context)ctx);
        BTPTransformResult result = iBTPManager.transformMultiBill(paymentBillColl, bosType.toString());
        IObjectCollection destBillColl = result.getBills();
        BOTRelationCollection botRelateColl = result.getBOTRelationCollection();
        PaymentBillInfo destBillInfo = null;
        int size = destBillColl.size();
        for (int i = 0; i < size; ++i) {
            destBillInfo = (PaymentBillInfo)destBillColl.getObject(i);
            AgentRecPayServerHelper.setOtherPropertiesForPayBill(ctx, info, destBillInfo);
            AgentRecPayServerHelper.verifyPaymentBillProperties(ctx, destBillInfo);
            iBTPManager.saveRelations((CoreBillBaseInfo)destBillInfo, botRelateColl);
        }
        return destBillInfo;
    }

    public static ReceivingBillInfo botpTransformRealReceivingbill(Context ctx, ReceivingBillInfo info) throws BOSException, EASBizException {
        BOSObjectType bosType = new ReceivingBillInfo().getBOSType();
        CoreBillBaseCollection ReceivingBillColl = new CoreBillBaseCollection();
        ReceivingBillColl.add((CoreBillBaseInfo)info);
        IBTPManager iBTPManager = BTPManagerFactory.getLocalInstance((Context)ctx);
        BTPTransformResult result = iBTPManager.transformMultiBill(ReceivingBillColl, bosType.toString());
        IObjectCollection destBillColl = result.getBills();
        BOTRelationCollection botRelateColl = result.getBOTRelationCollection();
        ReceivingBillInfo destBillInfo = null;
        int size = destBillColl.size();
        for (int i = 0; i < size; ++i) {
            destBillInfo = (ReceivingBillInfo)destBillColl.getObject(i);
            AgentRecPayServerHelper.setOtherPropertiesForRecBill(ctx, info, destBillInfo);
            AgentRecPayServerHelper.verifyReceivingBillProperties(ctx, destBillInfo);
            iBTPManager.saveRelations((CoreBillBaseInfo)destBillInfo, botRelateColl);
        }
        return destBillInfo;
    }

    private static void setOtherPropertiesForPayBill(Context ctx, PaymentBillInfo srcBillInfo, PaymentBillInfo destBillInfo) throws EASBizException, BOSException {
        int i;
        if (destBillInfo.getBizDate() == null) {
            destBillInfo.setBizDate(new Date());
        }
        CompanyOrgUnitInfo company = srcBillInfo.getAgentPayCompany();
        destBillInfo.setCompany(company);
        FMVerifyHelper.checkBlank((Context)ctx, (IObjectValue)destBillInfo, (String)"company");
        destBillInfo.setSourceSysType(SourceTypeEnum.CASH);
        if (EmptyUtil.isEmpty((Object)destBillInfo.getSourceType())) {
            destBillInfo.setSourceType(SourceTypeEnum.CASH);
        }
        if (EmptyUtil.isEmpty((CoreBaseInfo)destBillInfo.getCurrency())) {
            destBillInfo.setCurrency(srcBillInfo.getCurrency());
        }
        if (EmptyUtil.isEmpty((Object)destBillInfo.getExchangeRate())) {
            destBillInfo.setExchangeRate(srcBillInfo.getExchangeRate());
        }
        if (EmptyUtil.isEmpty((Object)((Object)destBillInfo.getBillStatus()))) {
            destBillInfo.setBillStatus(BillStatusEnum.SAVE);
        }
        if (EmptyUtil.isEmpty((String)destBillInfo.getSourceBillId())) {
            destBillInfo.setSourceBillId(srcBillInfo.getId().toString());
        }
        if (destBillInfo.getOppAccount() != null) {
            if (destBillInfo.getOppAccount() instanceof AccountViewInfo) {
                if (srcBillInfo.getOppAccount() != null && destBillInfo.getOppAccount().getId().equals((Object)srcBillInfo.getOppAccount().getId())) {
                    destBillInfo.setOppAccount(null);
                }
            } else {
                destBillInfo.setOppAccount(null);
            }
        } else {
            destBillInfo.setOppAccount(null);
        }
        PaymentBillEntryCollection entries = srcBillInfo.getEntries();
        HashMap<String, PaymentBillEntryInfo> entriesMap = new HashMap<String, PaymentBillEntryInfo>();
        for (i = 0; i < entries.size(); ++i) {
            PaymentBillEntryInfo entry = entries.get(i);
            entriesMap.put(entry.getId().toString(), entry);
        }
        entries = destBillInfo.getEntries();
        for (i = 0; i < entries.size(); ++i) {
            PaymentBillEntryInfo entryInfo = entries.get(i);
            if (entryInfo.getOppAccount() != null) {
                PaymentBillEntryInfo sourceEntry;
                String sourceEntryId = entryInfo.getSourceBillEntryId();
                if (!entriesMap.containsKey(sourceEntryId) || (sourceEntry = (PaymentBillEntryInfo)entriesMap.get(sourceEntryId)).getOppAccount() == null || !entryInfo.getOppAccount().getId().equals((Object)sourceEntry.getOppAccount().getId())) continue;
                entryInfo.setOppAccount(null);
                continue;
            }
            entryInfo.setOppAccount(null);
        }
        destBillInfo.setPaymentBillType(CasRecPayBillTypeEnum.AgentType);
        destBillInfo.setSrcAgenPaymentBillID(srcBillInfo.getId().toString());
        company = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(company.getId()));
        String companyID = company.getId().toString();
        AsstActTypeInfo srcAsstActType = srcBillInfo.getPayeeType();
        AsstActTypeCollection asstActTypeColl = CasRecPayAsstActTypeHelper.getAsstActTypeColl(ctx, companyID, false, false);
        if (asstActTypeColl == null || srcAsstActType == null || !asstActTypeColl.containsKey((Object)srcAsstActType.getId())) {
            destBillInfo.setPayeeType(null);
        }
        if (destBillInfo.getPayeeType() != null && srcBillInfo.getPayeeID() != null) {
            try {
                boolean isCompanyHasAsst = AgentRecPayServerHelper.isCompanyHasAsst(ctx, company, srcAsstActType, srcBillInfo.getPayeeID());
                if (isCompanyHasAsst) {
                    destBillInfo.setPayeeID(srcBillInfo.getPayeeID());
                } else {
                    destBillInfo.setPayeeType(null);
                }
            }
            catch (SQLException e) {
                logger.error((Object)e);
            }
        }
        if (!EmptyUtil.isEmpty((CoreBaseInfo)destBillInfo.getPayerAccountBank()) && EmptyUtil.isEmpty((CoreBaseInfo)destBillInfo.getPayerAccount())) {
            destBillInfo.setPayerAccount(destBillInfo.getPayerAccountBank().getAccount());
        }
        if (!EmptyUtil.isEmpty((CoreBaseInfo)destBillInfo.getPayerAccountBank()) && EmptyUtil.isEmpty((CoreBaseInfo)destBillInfo.getPayerBank())) {
            destBillInfo.setPayerBank(destBillInfo.getPayerAccountBank().getBank());
        }
        if (ctx != null && destBillInfo.getSourceBillId() != null) {
            BizobjectFacadeFactory.getLocalInstance((Context)ctx).copyBizRelation(destBillInfo.getSourceBillId(), destBillInfo.getId().toString());
        }
        CurrencyInfo srcCur = destBillInfo.getCurrency();
        CurrencyInfo destCur = ContextHelperFactory.getLocalInstance((Context)ctx).getCompanyBaseCurrency(company);
        if (!srcCur.getId().equals((Object)destCur.getId())) {
            ExchangeRateInfo eri = CashHelper.getExRateInfo(ctx, srcCur, destCur, company, destBillInfo.getBizDate());
            BigDecimal exchangeRate = SysConstant.BIGZERO;
            if (null == eri) {
                throw new RecPayException(RecPayException.NOTFINDAGENCYEXRATE);
            }
            exchangeRate = eri.getConvertRate();
            boolean isIndirect = CashHelper.isIndirectExRate(eri);
            destBillInfo.setIsIndirectRate(isIndirect);
            destBillInfo.setExchangeRate(exchangeRate);
            BigDecimal actRecAmt = SysConstant.BIGZERO;
            PaymentBillEntryCollection paymentBillEntryCollection = destBillInfo.getEntries();
            if (paymentBillEntryCollection != null && paymentBillEntryCollection.size() > 0) {
                for (int j = 0; j < paymentBillEntryCollection.size(); ++j) {
                    BigDecimal actualAmt = paymentBillEntryCollection.get(j).getActualAmt();
                    if (destBillInfo.getIsIndirectRate()) {
                        paymentBillEntryCollection.get(j).setActualLocAmt(actualAmt.divide(destBillInfo.getExchangeRate(), 20, 4));
                        paymentBillEntryCollection.get(j).setRebateLocAmt(actualAmt.multiply(destBillInfo.getExchangeRate()));
                    } else {
                        paymentBillEntryCollection.get(j).setActualLocAmt(actualAmt.multiply(destBillInfo.getExchangeRate()));
                        paymentBillEntryCollection.get(j).setRebateLocAmt(actualAmt.multiply(destBillInfo.getExchangeRate()));
                    }
                    actRecAmt = actRecAmt.add(actualAmt);
                }
                destBillInfo.setActPayAmt(actRecAmt);
                if (destBillInfo.getIsIndirectRate()) {
                    destBillInfo.setActPayLocAmt(actRecAmt.divide(destBillInfo.getExchangeRate(), 20, 4));
                } else {
                    destBillInfo.setActPayLocAmt(actRecAmt.multiply(destBillInfo.getExchangeRate()));
                }
                destBillInfo.setSourceSysType(destBillInfo.getPayBillType().getSourceSysType());
            }
        }
        destBillInfo.setSrcAgenPaymentBillID(srcBillInfo.getId().toString());
    }

    private static void setOtherPropertiesForRecBill(Context ctx, ReceivingBillInfo srcBillInfo, ReceivingBillInfo destBillInfo) throws EASBizException, BOSException {
        if (destBillInfo.getBizDate() == null) {
            destBillInfo.setBizDate(new Date());
        }
        CompanyOrgUnitInfo company = srcBillInfo.getRealRecCompany();
        destBillInfo.setCompany(company);
        FMVerifyHelper.checkBlank((Context)ctx, (IObjectValue)destBillInfo, (String)"company");
        destBillInfo.setSourceSysType(SourceTypeEnum.CASH);
        destBillInfo.setOppAccount(null);
        destBillInfo.setOppAccount(null);
        destBillInfo.setReceivingBillType(CasRecPayBillTypeEnum.RealType);
        destBillInfo.setSrcRealRecBillID(srcBillInfo.getId().toString());
        company = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(company.getId()));
        String companyID = company.getId().toString();
        AsstActTypeInfo srcAsstActType = srcBillInfo.getPayerType();
        AsstActTypeCollection asstActTypeColl = CasRecPayAsstActTypeHelper.getAsstActTypeColl(ctx, companyID, false, false);
        if (asstActTypeColl == null || srcAsstActType == null || !asstActTypeColl.containsKey((Object)srcAsstActType.getId())) {
            destBillInfo.setPayerType(null);
        }
        if (destBillInfo.getPayerType() != null && srcBillInfo.getPayerID() != null) {
            try {
                boolean isCompanyHasAsst = AgentRecPayServerHelper.isCompanyHasAsst(ctx, company, srcAsstActType, srcBillInfo.getPayerID());
                if (isCompanyHasAsst) {
                    destBillInfo.setPayerID(srcBillInfo.getPayerID());
                } else {
                    destBillInfo.setPayerType(null);
                }
            }
            catch (SQLException e) {
                logger.error((Object)e);
            }
        }
        if (!EmptyUtil.isEmpty((CoreBaseInfo)destBillInfo.getPayeeAccountBank()) && EmptyUtil.isEmpty((CoreBaseInfo)destBillInfo.getPayeeAccount())) {
            destBillInfo.setPayeeAccount(destBillInfo.getPayeeAccountBank().getAccount());
        }
        if (!EmptyUtil.isEmpty((CoreBaseInfo)destBillInfo.getPayeeAccountBank()) && EmptyUtil.isEmpty((CoreBaseInfo)destBillInfo.getPayeeBank())) {
            destBillInfo.setPayeeBank(destBillInfo.getPayeeAccountBank().getBank());
        }
        if (ctx != null && destBillInfo.getSourceBillId() != null) {
            BizobjectFacadeFactory.getLocalInstance((Context)ctx).copyBizRelation(destBillInfo.getSourceBillId(), destBillInfo.getId().toString());
        }
        CurrencyInfo srcCur = destBillInfo.getCurrency();
        CurrencyInfo destCur = ContextHelperFactory.getLocalInstance((Context)ctx).getCompanyBaseCurrency(company);
        if (!srcCur.getId().equals((Object)destCur.getId())) {
            ExchangeRateInfo eri = CashHelper.getExRateInfo(ctx, srcCur, destCur, company, destBillInfo.getBizDate());
            BigDecimal exchangeRate = SysConstant.BIGZERO;
            if (null == eri) {
                throw new RecPayException(RecPayException.NOTFINDAGENCYEXRATE);
            }
            exchangeRate = eri.getConvertRate();
            boolean isIndirect = CashHelper.isIndirectExRate(eri);
            destBillInfo.setIsIndirectRate(isIndirect);
            destBillInfo.setExchangeRate(exchangeRate);
            BigDecimal actRecAmt = SysConstant.BIGZERO;
            ReceivingBillEntryCollection receivingBillEntryCollection = destBillInfo.getEntries();
            if (receivingBillEntryCollection != null && receivingBillEntryCollection.size() > 0) {
                for (int j = 0; j < receivingBillEntryCollection.size(); ++j) {
                    BigDecimal actualAmt = receivingBillEntryCollection.get(j).getActualAmt();
                    if (destBillInfo.getIsIndirectRate()) {
                        receivingBillEntryCollection.get(j).setActualLocAmt(actualAmt.divide(destBillInfo.getExchangeRate(), 20, 4));
                        receivingBillEntryCollection.get(j).setRebateLocAmt(actualAmt.multiply(destBillInfo.getExchangeRate()));
                    } else {
                        receivingBillEntryCollection.get(j).setActualLocAmt(actualAmt.multiply(destBillInfo.getExchangeRate()));
                        receivingBillEntryCollection.get(j).setRebateLocAmt(actualAmt.multiply(destBillInfo.getExchangeRate()));
                    }
                    actRecAmt = actRecAmt.add(actualAmt);
                }
                destBillInfo.setActRecAmt(actRecAmt);
                if (destBillInfo.getIsIndirectRate()) {
                    destBillInfo.setActRecLocAmt(actRecAmt.divide(destBillInfo.getExchangeRate(), 20, 4));
                } else {
                    destBillInfo.setActRecLocAmt(actRecAmt.multiply(destBillInfo.getExchangeRate()));
                }
                destBillInfo.setSourceSysType(destBillInfo.getRecBillType().getSourceSysType());
            }
        }
        destBillInfo.setSrcRealRecBillID(srcBillInfo.getId().toString());
    }

    public static boolean isCompanyHasAsst(Context ctx, CompanyOrgUnitInfo company, AsstActTypeInfo asstActType, String payeeID) throws EASBizException, BOSException, SQLException {
        StringBuffer fromWhere = new StringBuffer();
        asstActType = AsstActTypeFactory.getLocalInstance((Context)ctx).getAsstActTypeInfo((IObjectPK)new ObjectUuidPK(asstActType.getId()));
        String realObject = asstActType.getRealtionDataObject();
        String cuList = company.getCU().getId().toString();
        String cuId = company.getCU().getId().toString();
        String companyID = company.getId().toString();
        String alis = "T_1";
        boolean isForCompany = asstActType.isIsForCompany();
        String asstHG = asstActType.getAsstHGAttribute();
        StringBuffer selectFrom = new StringBuffer();
        selectFrom.append("select " + alis + ".FID from  " + realObject + " " + alis);
        if (isForCompany) {
            if (!(asstHG.equals("person") || asstHG.equals("bankAccount") || asstHG.equals("innerAccount") || asstHG.equals("ProductType") || asstHG.equals("CurProject"))) {
                fromWhere.append(" where (" + alis + ".fcompanyId='" + companyID + "' or " + alis + ".fcompanyId is null)");
            }
        } else if (!(asstHG.equals("region") || asstHG.equals("adminOrg") || asstHG.equals("fpItem") || asstHG.equals("project") || asstHG.equals("country") || asstHG.equals("city") || asstHG.equals("costOrg") || asstHG.equals("companyOrg") || asstHG.equals("saleOrg") || asstHG.equals("profitOrg") || asstHG.equals("purchaseOrg") || asstHG.equals("storeageOrg"))) {
            FilterInfo filter;
            if (asstHG.equals("customer") || asstHG.equals("provider") || asstHG.equals("material") || asstHG.equals("supplier")) {
                ICSSPGroupStandard cSSPGroupStandard;
                filter = new FilterInfo();
                if (asstHG.equals("customer")) {
                    cSSPGroupStandard = CSSPGroupStandardFactory.getLocalInstance((Context)ctx);
                    String groupStandardId = cSSPGroupStandard.getBasicStandardId("1");
                    fromWhere.append(" INNER JOIN T_BD_CustomerCompanyInfo  cc ON " + alis + ".FID = cc.FCustomerID ");
                    fromWhere.append(" LEFT OUTER JOIN T_ORG_Company   cp ON cc.FComOrgID = cp.FID ");
                    fromWhere.append(" left outer join T_BD_CSSPGroup  G on " + alis + ".FBrowseGroupID=G.FID ");
                    fromWhere.append(" where ( cp.fid='" + companyID + "'  ");
                    fromWhere.append(" and G.FCSSPGROUPSTANDARDID='" + groupStandardId + "' ");
                    fromWhere.append(" and " + alis + ".FusedStatus=" + 1 + ") ");
                } else if (asstHG.equals("provider")) {
                    filter = SupplierFactory.getLocalInstance((Context)ctx).getDatabaseDFilter((IObjectPK)new ObjectUuidPK(cuId), alis + ".FID", alis + ".FControlUnitID");
                } else if (asstHG.equals("material")) {
                    filter = MaterialFactory.getLocalInstance((Context)ctx).getDatabaseDFilter((IObjectPK)new ObjectUuidPK(cuId), alis + ".FID", alis + ".FControlUnitID");
                    fromWhere.append(" INNER JOIN T_BD_MaterialCompanyInfo  cc ON " + alis + ".FID = cc.FMaterial ");
                    fromWhere.append(" LEFT OUTER JOIN T_ORG_Company   cp ON cc.FComOrgID = cp.FID ");
                    fromWhere.append(" where (").append(filter.toString()).append(" )");
                    fromWhere.append(" and cc.FStatus=1");
                    fromWhere.append(" and " + alis + ".FStatus=" + 1 + ")");
                } else if (asstHG.equals("supplier")) {
                    cSSPGroupStandard = CSSPGroupStandardFactory.getLocalInstance((Context)ctx);
                    String groupStandardId = cSSPGroupStandard.getBasicStandardId("2");
                    fromWhere.append(" INNER JOIN T_BD_SupplierCompanyInfo  cc ON " + alis + ".FID = cc.FSupplierID ");
                    fromWhere.append(" LEFT OUTER JOIN T_ORG_Company   cp ON cc.FComOrgID = cp.FID ");
                    fromWhere.append(" left outer join T_BD_CSSPGroup  G on " + alis + ".FBrowseGroupID=G.FID ");
                    fromWhere.append(" where ( cp.fid='" + companyID + "'  ");
                    fromWhere.append(" and G.FCSSPGROUPSTANDARDID='" + groupStandardId + "' ");
                    fromWhere.append(" and " + alis + ".FusedStatus=" + 1 + ") ");
                }
            } else if (realObject.equalsIgnoreCase("T_BD_GeneralAsstActType")) {
                filter = new FilterInfo();
                filter.getFilterItems().add(new FilterItemInfo("fgroupid", (Object)asstActType.getGlAsstActTypeGrp().getId().toString()));
                fromWhere.append(" where (").append(filter.toString()).append(" )");
            } else {
                fromWhere.append(" where " + alis).append(".FControlUnitID in('").append(cuList).append("'))");
            }
        }
        if (fromWhere.length() == 0) {
            fromWhere.append(" where (" + alis).append(".FID ='").append(payeeID).append("')");
        } else {
            fromWhere.append(" and (" + alis).append(".FID ='").append(payeeID).append("')");
        }
        IRowSet rs = null;
        String sql = selectFrom.append(fromWhere).toString();
        rs = ctx == null ? FMIsqlFacadeFactory.getRemoteInstance().executeQuery(sql, new Object[0]) : FMIsqlFacadeFactory.getLocalInstance((Context)ctx).executeQuery(sql, new Object[0]);
        return rs.next();
    }

    /*
     * Enabled aggressive block sorting
     */
    public static boolean isCompanyHasAsstUseFilter(Context ctx, CompanyOrgUnitInfo company, AsstActTypeInfo asstActType, String payeeID) throws EASBizException, BOSException, SQLException {
        StringBuffer selectFrom;
        String alis;
        StringBuffer fromWhere;
        block10: {
            String cuList;
            String realObject;
            block12: {
                FilterInfo filter;
                String asstHG;
                String cuId;
                block13: {
                    String companyID;
                    block11: {
                        fromWhere = new StringBuffer();
                        asstActType = AsstActTypeFactory.getLocalInstance((Context)ctx).getAsstActTypeInfo((IObjectPK)new ObjectUuidPK(asstActType.getId()));
                        realObject = asstActType.getRealtionDataObject();
                        cuList = company.getCU().getId().toString();
                        cuId = company.getCU().getId().toString();
                        companyID = company.getId().toString();
                        alis = "T_1";
                        boolean isForCompany = asstActType.isIsForCompany();
                        asstHG = asstActType.getAsstHGAttribute();
                        selectFrom = new StringBuffer();
                        selectFrom.append("select " + alis + ".FID from  " + realObject + " " + alis);
                        if (!isForCompany) break block11;
                        if (!(asstHG.equals("person") || asstHG.equals("bankAccount") || asstHG.equals("innerAccount") || asstHG.equals("ProductType") || asstHG.equals("CurProject"))) {
                            fromWhere.append(" where (" + alis + ".fcompanyId='" + companyID + "' or " + alis + ".fcompanyId is null)");
                        }
                        break block10;
                    }
                    if (asstHG.equals("region") || asstHG.equals("adminOrg") || asstHG.equals("fpItem") || asstHG.equals("project") || asstHG.equals("country") || asstHG.equals("city") || asstHG.equals("costOrg") || asstHG.equals("companyOrg") || asstHG.equals("saleOrg") || asstHG.equals("profitOrg") || asstHG.equals("purchaseOrg") || asstHG.equals("storeageOrg")) break block10;
                    if (!asstHG.equals("customer") && !asstHG.equals("provider") && !asstHG.equals("material") && !asstHG.equals("supplier")) break block12;
                    EntityViewInfo view = new EntityViewInfo();
                    filter = new FilterInfo();
                    view.setFilter(filter);
                    if (!asstHG.equals("customer")) break block13;
                    filter.getFilterItems().add(new FilterItemInfo("companyOrgUnit.id", (Object)companyID));
                    ICSSPGroupStandard cSSPGroupStandard = CSSPGroupStandardFactory.getLocalInstance((Context)ctx);
                    String groupStandardId = cSSPGroupStandard.getBasicStandardId("1");
                    filter.getFilterItems().add(new FilterItemInfo("browseGroup.groupStandard", (Object)groupStandardId));
                    filter.getFilterItems().add(new FilterItemInfo("usedStatus", (Object)new Integer(1)));
                    MetaDataPK metaDataPK = new MetaDataPK("com.kingdee.eas.basedata.master.cssp.app.F7CustomerCompanyQuery");
                    IQueryExecutor queryExecutor = BosHelper.createQueryExecutor((MetaDataPK)metaDataPK, (Context)ctx);
                    queryExecutor.setObjectView(view);
                    break block10;
                }
                if (asstHG.equals("provider")) {
                    filter = SupplierFactory.getLocalInstance((Context)ctx).getDatabaseDFilter((IObjectPK)new ObjectUuidPK(cuId), alis + ".FID", alis + ".FControlUnitID");
                    break block10;
                } else if (asstHG.equals("material")) {
                    filter = MaterialFactory.getLocalInstance((Context)ctx).getDatabaseDFilter((IObjectPK)new ObjectUuidPK(cuId), alis + ".FID", alis + ".FControlUnitID");
                    break block10;
                } else if (!asstHG.equals("supplier")) {
                    // empty if block
                }
                break block10;
            }
            if (realObject.equalsIgnoreCase("T_BD_GeneralAsstActType")) {
                FilterInfo filter = new FilterInfo();
                filter.getFilterItems().add(new FilterItemInfo("fgroupid", (Object)asstActType.getGlAsstActTypeGrp().getId().toString()));
                fromWhere.append(" where (").append(filter.toString()).append(" )");
            } else {
                fromWhere.append(" where " + alis).append(".FControlUnitID in('").append(cuList).append("'))");
            }
        }
        if (fromWhere.length() == 0) {
            fromWhere.append(" where (" + alis).append(".FID ='").append(payeeID).append("')");
        } else {
            fromWhere.append(" and (" + alis).append(".FID ='").append(payeeID).append("')");
        }
        IRowSet rs = null;
        String sql = selectFrom.append(fromWhere).toString();
        rs = ctx == null ? FMIsqlFacadeFactory.getRemoteInstance().executeQuery(sql, new Object[0]) : FMIsqlFacadeFactory.getLocalInstance((Context)ctx).executeQuery(sql, new Object[0]);
        return rs.next();
    }

    private static void verifyPaymentBillProperties(Context ctx, PaymentBillInfo info) throws EASBizException, BOSException {
        FMVerifyHelper.checkBlank((Context)ctx, (IObjectValue)info, (String)"company");
        FMVerifyHelper.checkBlank((Context)ctx, (IObjectValue)info, (String)"actPayAmt");
        FMVerifyHelper.checkBlank((Context)ctx, (IObjectValue)info, (String)"actPayLocAmt");
        FMVerifyHelper.checkBlank((Context)ctx, (IObjectValue)info, (String)"sourceSysType");
        FMVerifyHelper.checkBlank((Context)ctx, (IObjectValue)info, (String)"sourceType");
        FMVerifyHelper.checkBlank((Context)ctx, (IObjectValue)info, (String)"currency");
        FMVerifyHelper.checkBlank((Context)ctx, (IObjectValue)info, (String)"exchangeRate");
        FMVerifyHelper.checkBlank((Context)ctx, (IObjectValue)info, (String)"billStatus");
        FMVerifyHelper.checkBlank((Context)ctx, (IObjectValue)info, (String)"billStatus");
        FMVerifyHelper.checkBlank((Context)ctx, (IObjectValue)info, (String)"bizDate");
        if (EmptyUtil.isEmpty((String)info.getSourceBillId())) {
            throw new CasException(CasException.SRCBILLIDNULL);
        }
    }

    private static void verifyReceivingBillProperties(Context ctx, ReceivingBillInfo info) throws EASBizException, BOSException {
        FMVerifyHelper.checkBlank((Context)ctx, (IObjectValue)info, (String)"company");
        FMVerifyHelper.checkBlank((Context)ctx, (IObjectValue)info, (String)"actRecAmt");
        FMVerifyHelper.checkBlank((Context)ctx, (IObjectValue)info, (String)"actRecLocAmt");
        FMVerifyHelper.checkBlank((Context)ctx, (IObjectValue)info, (String)"sourceSysType");
        FMVerifyHelper.checkBlank((Context)ctx, (IObjectValue)info, (String)"sourceType");
        FMVerifyHelper.checkBlank((Context)ctx, (IObjectValue)info, (String)"currency");
        FMVerifyHelper.checkBlank((Context)ctx, (IObjectValue)info, (String)"exchangeRate");
        FMVerifyHelper.checkBlank((Context)ctx, (IObjectValue)info, (String)"billStatus");
        FMVerifyHelper.checkBlank((Context)ctx, (IObjectValue)info, (String)"bizDate");
        if (EmptyUtil.isEmpty((String)info.getSourceBillId())) {
            throw new CasException(CasException.SRCBILLIDNULL);
        }
    }

    public static void deleteAgentPaymentBill(Context ctx, PaymentBillInfo info) throws EASBizException, BOSException {
        if (EmptyUtil.isEmpty((String)info.getAgentPaymentBillID())) {
            info = PaymentBillFactory.getLocalInstance(ctx).getPaymentBillInfo((IObjectPK)new ObjectUuidPK(info.getId()));
        }
        if (EmptyUtil.isEmpty((String)info.getAgentPaymentBillID())) {
            return;
        }
        ctx.put((Object)"deleteFromAgentOrgFlag", (Object)1);
        try {
            PaymentBillFactory.getLocalInstance(ctx).delete((IObjectPK)new ObjectUuidPK(info.getAgentPaymentBillID()));
        }
        finally {
            ctx.remove((Object)"deleteFromAgentOrgFlag");
        }
        info.setAgentPaymentBillID(null);
        String sql = "UPDATE T_CAS_PaymentBill SET FAgentPaymentBillID = null WHERE FID = ? ";
        DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{info.getId().toString()});
        IBOTRelation iBot = BOTRelationFactory.getLocalInstance((Context)ctx);
        iBot.removeRelationByDestObjId(info.getAgentPaymentBillID(), new PaymentBillInfo().getBOSType().toString());
    }

    public static void deleteRealRecReceivingBill(Context ctx, ReceivingBillInfo info) throws EASBizException, BOSException {
        if (EmptyUtil.isEmpty((String)info.getRealRecBillID())) {
            return;
        }
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("billStatus");
        sic.add("number");
        ReceivingBillInfo recInfo = ReceivingBillFactory.getLocalInstance(ctx).getReceivingBillInfo((IObjectPK)new ObjectUuidPK(info.getRealRecBillID()), sic);
        if (BillStatusEnum.AUDITED.equals((Object)recInfo.getBillStatus()) || BillStatusEnum.RECED.equals((Object)recInfo.getBillStatus())) {
            throw new RecPayException(RecPayException.CANNOT_CANCELREC_REALBILLRECD, new Object[]{recInfo.getNumber()});
        }
        ReceivingBillFactory.getLocalInstance(ctx).delete((IObjectPK)new ObjectUuidPK(info.getRealRecBillID()));
        info.setRealRecBillID(null);
        String sqlUpdate = "UPDATE T_CAS_ReceivingBill SET FRealRecBillID = null WHERE FID = ? ";
        DbUtil.execute((Context)ctx, (String)sqlUpdate, (Object[])new Object[]{info.getId().toString()});
        IBOTRelation iBot = BOTRelationFactory.getLocalInstance((Context)ctx);
        iBot.removeRelationByDestObjId(info.getRealRecBillID(), new ReceivingBillInfo().getBOSType().toString());
    }

    public static PaymentBillInfo getSynchronizedInfo(Context ctx, PaymentBillInfo info) throws EASBizException, BOSException {
        String relatedID;
        ArrayList<String> list = new ArrayList<String>();
        list.add("payeeType");
        list.add("fiVouchered");
        list.add("voucherType");
        list.add("voucher");
        list.add("voucherNumber");
        list.add("payerAccount");
        list.add("oppAccount");
        PropertySynchronizer sync = new PropertySynchronizer(ctx, info.getBOSType(), list);
        sync.reverse();
        String string = relatedID = EmptyUtil.isEmpty((String)info.getAgentPaymentBillID()) ? info.getSrcAgenPaymentBillID() : info.getAgentPaymentBillID();
        if (EmptyUtil.isEmpty((String)relatedID)) {
            return null;
        }
        ObjectUuidPK ralatedRecBillPK = new ObjectUuidPK(relatedID);
        PaymentBillInfo payBill = null;
        try {
            payBill = PaymentBillFactory.getLocalInstance(ctx).getPaymentBillInfo((IObjectPK)ralatedRecBillPK, AgentRecPayServerHelper.getSyncSelector());
        }
        catch (BOSException e) {
            throw new BOSException(ResourceBase.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"32_AgentRecPayServerHelper", (Locale)ctx.getLocale()));
        }
        sync.syncProperties((CoreBaseInfo)info, (CoreBaseInfo)payBill);
        payBill = AgentRecPayServerHelper.syncEntriesForPay(ctx, info, payBill);
        return payBill;
    }

    public static ReceivingBillInfo getSynchronizedInfo(Context ctx, ReceivingBillInfo info) throws EASBizException, BOSException {
        String relatedID;
        ArrayList<String> list = new ArrayList<String>();
        list.add("payeeAccount");
        list.add("oppAccount");
        list.add("fiVouchered");
        list.add("voucherType");
        list.add("voucher");
        list.add("voucherNumber");
        PropertySynchronizer sync = new PropertySynchronizer(ctx, info.getBOSType(), list);
        sync.reverse();
        String string = relatedID = EmptyUtil.isEmpty((String)info.getRealRecBillID()) ? info.getSrcRealRecBillID() : info.getRealRecBillID();
        if (EmptyUtil.isEmpty((String)relatedID)) {
            return null;
        }
        ObjectUuidPK ralatedRecBillPK = new ObjectUuidPK(relatedID);
        ReceivingBillInfo recBill = ReceivingBillFactory.getLocalInstance(ctx).getReceivingBillInfo((IObjectPK)ralatedRecBillPK, AgentRecPayServerHelper.getSyncSelector());
        sync.syncProperties((CoreBaseInfo)info, (CoreBaseInfo)recBill);
        recBill = AgentRecPayServerHelper.syncEntriesForRec(ctx, info, recBill);
        return recBill;
    }

    private static PaymentBillInfo syncEntriesForPay(Context ctx, PaymentBillInfo info, PaymentBillInfo payBill) throws EASBizException, BOSException {
        PaymentBillEntryCollection payEntries1 = info.getEntries();
        PaymentBillEntryCollection payEntries2 = payBill.getEntries();
        String[] needSyncPayProperties = AgentRecPayServerHelper.getNeedSyncPayEntryNames();
        for (int i = 0; i < payEntries1.size(); ++i) {
            PaymentBillEntryInfo entry1 = payEntries1.get(i);
            PaymentBillEntryInfo entry2 = payEntries2.get(i);
            for (int j = 0; j < needSyncPayProperties.length; ++j) {
                String property = needSyncPayProperties[j];
                Object vo = BindingUtility.getValue((IObjectValue)entry1, (Field)new Field(property));
                BindingUtility.setValue((IObjectValue)entry2, (Field)new Field(property), (Object)vo);
            }
        }
        return payBill;
    }

    private static ReceivingBillInfo syncEntriesForRec(Context ctx, ReceivingBillInfo info, ReceivingBillInfo recBill) throws EASBizException, BOSException {
        ReceivingBillEntryCollection payEntries1 = info.getEntries();
        ReceivingBillEntryCollection payEntries2 = recBill.getEntries();
        String[] needSyncRecProperties = AgentRecPayServerHelper.getNeedSyncRecEntryNames();
        for (int i = 0; i < payEntries1.size(); ++i) {
            ReceivingBillEntryInfo entry1 = payEntries1.get(i);
            ReceivingBillEntryInfo entry2 = payEntries2.get(i);
            for (int j = 0; j < needSyncRecProperties.length; ++j) {
                String property = needSyncRecProperties[j];
                Object vo = BindingUtility.getValue((IObjectValue)entry1, (Field)new Field(property));
                BindingUtility.setValue((IObjectValue)entry2, (Field)new Field(property), (Object)vo);
            }
        }
        return recBill;
    }

    private static String[] getNeedSyncPayEntryNames() {
        String[] properties = new String[]{"expenseType", "fpItem", "remark"};
        return properties;
    }

    private static String[] getNeedSyncRecEntryNames() {
        String[] properties = new String[]{"expenseType", "fpItem", "remark"};
        return properties;
    }

    private static SelectorItemCollection getSyncSelector() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("*");
        sic.add("assItems.*");
        sic.add("entries.*");
        return sic;
    }
}

