/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.cas.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.sql.ParserException;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.codingrule.CodingRuleManagerFactory;
import com.kingdee.eas.base.codingrule.ICodingRuleManager;
import com.kingdee.eas.basedata.assistant.AccountBankInfo;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.PaymentTypeInfo;
import com.kingdee.eas.basedata.assistant.SettlementTypeInfo;
import com.kingdee.eas.basedata.master.account.AccountViewInfo;
import com.kingdee.eas.basedata.master.material.app.DataImportTools;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.fi.cas.AbstractPaymentBillInfo;
import com.kingdee.eas.fi.cas.BillStatusEnum;
import com.kingdee.eas.fi.cas.CasConstants;
import com.kingdee.eas.fi.cas.CasForArApUtil;
import com.kingdee.eas.fi.cas.IPaymentBill;
import com.kingdee.eas.fi.cas.PaymentBillCollection;
import com.kingdee.eas.fi.cas.PaymentBillEntryInfo;
import com.kingdee.eas.fi.cas.PaymentBillFactory;
import com.kingdee.eas.fi.cas.PaymentBillInfo;
import com.kingdee.eas.fi.cas.PaymentBillTypeInfo;
import com.kingdee.eas.fi.cas.SourceTypeEnum;
import com.kingdee.eas.fi.cas.app.ARAPImportCache;
import com.kingdee.eas.fi.cas.app.PaymentBillImportVerify;
import com.kingdee.eas.fi.cas.app.RecAndPayDataImportUtil;
import com.kingdee.eas.fi.cas.utils.CollectionUtils;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.tools.datatask.AbstractDataTransmission;
import com.kingdee.eas.tools.datatask.core.TaskExternalException;
import com.kingdee.eas.tools.datatask.runtime.DataToken;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.IllegalConversionException;
import com.kingdee.util.StringUtils;
import com.kingdee.util.TypeConversionUtils;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;

public class ArApPaymentBillDataImport
extends AbstractDataTransmission {
    private static Logger logger = Logger.getLogger((String)ArApPaymentBillDataImport.class.getName());
    private PaymentBillImportVerify verify;
    private Map infoMap = new HashMap(100);
    private String curKey;
    protected static final String Arap_RecPayDataImport = "com.kingdee.eas.fi.cas.ArApRecPayDataImportResource";
    private boolean isImportDataByRule = false;
    private ARAPImportCache importCache = new ARAPImportCache();

    protected ICoreBase getController(Context ctx) throws TaskExternalException {
        try {
            return PaymentBillFactory.getLocalInstance(ctx);
        }
        catch (BOSException e) {
            throw new TaskExternalException(e.getMessage());
        }
    }

    public PaymentBillImportVerify getVerify() {
        if (this.verify == null) {
            this.verify = new PaymentBillImportVerify();
        }
        return this.verify;
    }

    public CoreBaseInfo transmit(Hashtable hsData, Context ctx) throws TaskExternalException {
        Hashtable data = CollectionUtils.reverseTableValue(hsData);
        PaymentBillInfo head = this.generatePayBillInfo(ctx, data);
        this.getVerify().verifyHead(ctx, (CoreBaseInfo)head);
        return head;
    }

    protected PaymentBillInfo generatePayBillInfo(Context ctx, Hashtable tableData) throws TaskExternalException {
        String errorMsg = "";
        PaymentBillEntryInfo entry = null;
        IPaymentBill iPaymentBill = null;
        AbstractPaymentBillInfo head = null;
        HashMap<Integer, PaymentBillEntryInfo> entryMap = new HashMap<Integer, PaymentBillEntryInfo>();
        Enumeration dataEnumeration = tableData.keys();
        boolean isUpdateImport = false;
        boolean isExistedBill = false;
        HashSet<String> set = new HashSet<String>();
        while (dataEnumeration.hasMoreElements()) {
            Object key = dataEnumeration.nextElement();
            Hashtable hsData = (Hashtable)tableData.get(key);
            set.add((String)this.getData(hsData, "FPayeeNumber"));
            String number = (String)this.getData(hsData, "FNumber");
            this.isImportDataByRule = this.importCache.getImportParamByCache(ctx);
            String companyNumber = (String)this.getData(hsData, "FCompanyID");
            CompanyOrgUnitInfo curCompany = this.importCache.getCompanyByCache(ctx, hsData, "FCompanyID");
            this.importCache.checkOrgPermissionByCache(ctx, curCompany, "cas_paymentbill_14import");
            this.curKey = curCompany.getNumber() + number;
            boolean isNumberNull = StringUtils.isEmpty((String)number);
            try {
                if (!this.infoMap.containsKey(this.curKey)) {
                    PaymentBillCollection payColl;
                    this.infoMap.clear();
                    if (this.isSltImportUpdate() && !isNumberNull && (payColl = (iPaymentBill = PaymentBillFactory.getLocalInstance(ctx)).getPaymentBillCollection("where number ='" + number + "' and company.number = '" + curCompany.getNumber() + "'")) != null && payColl.size() > 0) {
                        head = payColl.get(0);
                        if (!BillStatusEnum.SAVE.equals((Object)head.getBillStatus())) {
                            errorMsg = ResourceBase.getString((String)Arap_RecPayDataImport, (String)"ONLY_CAN_IMPORT", (Locale)ctx.getLocale()) + ResourceBase.getString((String)Arap_RecPayDataImport, (String)"PaymentBill", (Locale)ctx.getLocale());
                            throw new TaskExternalException(errorMsg);
                        }
                        if (head.getEntries() != null && head.getEntries().size() > 0 && head.getEntries().get(0).getSourceBillId() != null) {
                            errorMsg = ResourceBase.getString((String)Arap_RecPayDataImport, (String)"CANNOT_OVER_IMPORT", (Locale)ctx.getLocale()) + ResourceBase.getString((String)Arap_RecPayDataImport, (String)"PaymentBill", (Locale)ctx.getLocale());
                            throw new TaskExternalException(errorMsg);
                        }
                        for (int i = 0; i < head.getEntries().size(); ++i) {
                            entry = head.getEntries().get(i);
                            entryMap.put(entry.getSeq(), entry);
                        }
                        isExistedBill = true;
                    }
                    if (head == null) {
                        head = new PaymentBillInfo();
                    }
                    head.setCompany(curCompany);
                    head.setCU(curCompany.getCU());
                    this.parseHead(hsData, ctx, (PaymentBillInfo)head);
                    this.infoMap.put(this.curKey, head);
                } else {
                    isUpdateImport = true;
                    head = (PaymentBillInfo)this.infoMap.get(this.curKey);
                }
            }
            catch (Exception e) {
                throw new TaskExternalException(e.getMessage());
            }
            entry = (PaymentBillEntryInfo)this.parseEntry(hsData, ctx);
            this.getVerify().verifyEntry(ctx, (CoreBaseInfo)entry, head.getSourceType());
            this.getVerify().verifyEntryAmt(ctx, entry, head);
            if (this.isSltImportUpdate()) {
                if (entryMap.get(entry.getSeq()) != null) {
                    head.getEntries().remove((PaymentBillEntryInfo)entryMap.get(entry.getSeq()));
                }
                entryMap.put(entry.getSeq(), entry);
            }
            head.getEntries().add(entry);
            if (!this.isImportDataByRule || isUpdateImport || isExistedBill) continue;
            try {
                ICodingRuleManager iCodingRuleManager = CodingRuleManagerFactory.getLocalInstance((Context)ctx);
                String cid = curCompany.getId().toString();
                if (iCodingRuleManager.isExist((IObjectValue)head, cid)) {
                    head.setNumber(iCodingRuleManager.getNumber((IObjectValue)head, cid, ""));
                    continue;
                }
                Object[] name = new String[]{ResourceBase.getString((String)Arap_RecPayDataImport, (String)"PaymentBill", (Locale)ctx.getLocale())};
                throw new TaskExternalException(MessageFormat.format(CasForArApUtil.getStrResource("CodingRule_Error"), name));
            }
            catch (Exception e) {
                Object[] name = new String[]{ResourceBase.getString((String)Arap_RecPayDataImport, (String)"PaymentBill", (Locale)ctx.getLocale())};
                throw new TaskExternalException(MessageFormat.format(CasForArApUtil.getStrResource("CodingRule_Error"), name));
            }
        }
        if (tableData.size() > 1 && set.size() > 1 && set.size() <= tableData.size()) {
            throw new TaskExternalException(ResourceBase.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"500_ReceivingBillImport", (Locale)ctx.getLocale()));
        }
        BigDecimal sumActualAmt = CasConstants.ZERO;
        BigDecimal sumActualLocAmt = CasConstants.ZERO;
        for (int i = 0; i < head.getEntries().size(); ++i) {
            PaymentBillEntryInfo entryInfo = head.getEntries().get(0);
            sumActualAmt = sumActualAmt.add(entryInfo.getActualAmt());
            sumActualLocAmt = sumActualLocAmt.add(entryInfo.getActualLocAmt());
        }
        head.setActPayAmt(sumActualAmt);
        head.setActPayLocAmt(sumActualLocAmt);
        return head;
    }

    private CoreBaseInfo parseHead(Hashtable hsData, Context ctx, PaymentBillInfo info) throws TaskExternalException {
        SettlementTypeInfo settleInfo;
        AccountViewInfo accountViewInfo;
        Object data = null;
        data = this.getData(hsData, "FPayType");
        PaymentBillTypeInfo payTypeInfo = null;
        if (data != null && data.toString().trim().length() > 0) {
            String key = data.toString();
            if (this.importCache.getPayTypeCache().get(key) != null) {
                payTypeInfo = (PaymentBillTypeInfo)this.importCache.getPayTypeCache().get(key);
            } else {
                payTypeInfo = RecAndPayDataImportUtil.getPayTypeByNumber(data.toString(), ctx);
                this.importCache.getPayTypeCache().put(key, payTypeInfo);
            }
        }
        data = this.getData(hsData, "FPaymentTypeID");
        PaymentTypeInfo paymentType = null;
        if (data != null && data.toString().trim().length() > 0) {
            try {
                paymentType = this.importCache.getPaymentTypeInfoByCache(ctx, hsData, "FPaymentTypeID");
            }
            catch (BOSException e) {
                throw new TaskExternalException(ResourceBase.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"33_ArApPaymentBillDataImport", (Locale)ctx.getLocale()));
            }
        } else {
            throw new TaskExternalException(ResourceBase.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"33_ArApPaymentBillDataImport", (Locale)ctx.getLocale()));
        }
        if (null != payTypeInfo && (payTypeInfo.isPrePay() || payTypeInfo.isProxyPay()) && null != paymentType && !"2fa35444-5a23-43fb-99ee-6d4fa5f260da6BCA0AB5".equals(paymentType.getId().toString())) {
            throw new TaskExternalException(ResourceBase.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"577_PaymentType_CREDIT_PUR", (Locale)ctx.getLocale()));
        }
        if (null != payTypeInfo && payTypeInfo.isIsPurPay() && null != paymentType && !"2fa35444-5a23-43fb-99ee-6d4fa5f260da6BCA0AB5".equals(paymentType.getId().toString()) && !"40b75328-7f57-463f-8d19-280574ef24bf6BCA0AB5".equals(paymentType.getId().toString())) {
            throw new TaskExternalException(ResourceBase.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"579_PaymentType_CREDIT_CURRENCY_PUR", (Locale)ctx.getLocale()));
        }
        info.setPaymentType(paymentType);
        if (payTypeInfo != null) {
            if (!payTypeInfo.isIsPurPay() && info.getPaymentType().toString().equals(ResourceBase.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"34_ArApPaymentBillDataImport", (Locale)ctx.getLocale()))) {
                throw new TaskExternalException(ResourceBase.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"35_ArApPaymentBillDataImport", (Locale)ctx.getLocale()));
            }
            info.setPayBillType(payTypeInfo);
        }
        if ((data = this.getData(hsData, "FNumber")) != null && data.toString().trim().length() > 0) {
            info.setNumber(data.toString());
        } else if (!this.isImportDataByRule) {
            throw new TaskExternalException(ResourceBase.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"36_ArApPaymentBillDataImport", (Locale)ctx.getLocale()));
        }
        data = this.getData(hsData, "FBizDate");
        if (data != null && data.toString().trim().length() > 0) {
            info.setBizDate(RecAndPayDataImportUtil.objToDate(ctx, data));
        }
        if ((data = this.getData(hsData, "FSourceType")) != null && data.toString().trim().length() > 0) {
            info.setSourceType(SourceTypeEnum.getEnum((int)TypeConversionUtils.objToInt((Object)data)));
        }
        if ((data = this.getData(hsData, "FCurrencyID")) != null && data.toString().trim().length() > 0) {
            info.setCurrency(this.importCache.getCurrencyInfoByCache(ctx, hsData, "FCurrencyID"));
        } else {
            try {
                info.setCurrency(info.getCompany().getBaseCurrency());
            }
            catch (Exception e) {
                throw new TaskExternalException(EASResource.getString((String)Arap_RecPayDataImport, (String)"Error_LocalAmt"));
            }
        }
        data = this.getData(hsData, "FExchangeRate");
        if (data != null && data.toString().trim().length() > 0) {
            info.setExchangeRate(TypeConversionUtils.objToBigDecimal((Object)data));
        }
        if ((data = this.getData(hsData, "FPayerAccountBankID")) != null && data.toString().trim().length() > 0) {
            AccountBankInfo accountBank = this.importCache.getAccountBankByCache(ctx, hsData, info.getCompany().getId().toString(), ResourceBase.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"19_AgentPayBillDataImport", (Locale)ctx.getLocale()), "FPayerAccountBankID");
            if (accountBank != null) {
                if (!accountBank.getCompany().getId().toString().equals(info.getCompany().getId().toString())) {
                    throw new TaskExternalException(this.getResourceString(ctx, "509_PayAccountNotIncloudCompany"));
                }
                if (accountBank.isIsClosed()) {
                    throw new TaskExternalException(this.getResourceString(ctx, "510_PayAccountHasCloused"));
                }
                if (accountBank != null && accountBank.isIsByCurrency()) {
                    CurrencyInfo currency = accountBank.getCurrency();
                    if (!info.getCurrency().getId().equals((Object)currency.getId())) {
                        throw new TaskExternalException(this.getResourceString(ctx, "511_PayAccountCurrencyNotEquesCurrency"));
                    }
                }
                info.setPayerAccountBank(accountBank);
                info.setPayerBank(info.getPayerAccountBank().getBank());
            } else {
                throw new TaskExternalException(this.getResourceString(ctx, "512_getPayAccountError", new String[]{data.toString()}));
            }
        }
        if ((data = this.getData(hsData, "FPayerAccountID")) != null && data.toString().trim().length() > 0) {
            accountViewInfo = this.importCache.getRecPayAccountViewInfoByCache(ctx, hsData, info.getCompany().getId().toString(), info.getCurrency().getId().toString(), ResourceBase.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"18_AgentPayBillDataImport", (Locale)ctx.getLocale()), "FPayerAccountID");
            info.setPayerAccount(accountViewInfo);
        }
        if ((data = this.getData(hsData, "FSettlementTypeID")) != null && data.toString().trim().length() > 0 && (settleInfo = this.importCache.getSettlementTypeInfoByCache(ctx, hsData, "FSettlementTypeID")) != null) {
            info.setSettlementType(settleInfo);
        }
        if ((data = this.getData(hsData, "FSettlementNumber")) != null && data.toString().trim().length() > 0) {
            info.setSettlementNumber(data.toString());
        }
        if ((data = this.getData(hsData, "FOppAccountID")) != null && data.toString().trim().length() > 0) {
            accountViewInfo = this.importCache.getRecPayAccountViewInfoByCache(ctx, hsData, info.getCompany().getId().toString(), info.getCurrency().getId().toString(), ResourceBase.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"20_AgentPayBillDataImport", (Locale)ctx.getLocale()), "FOppAccountID");
            info.setOppAccount(accountViewInfo);
        }
        if ((data = this.getData(hsData, "FDescription")) != null && data.toString().trim().length() > 0) {
            info.setDescription(data.toString());
        }
        if ((data = this.getData(hsData, "FPayeeTypeID")) != null && data.toString().trim().length() > 0) {
            info.setPayeeType(this.importCache.getAsstActTypeInfoByCache(ctx, hsData, "FPayeeTypeID"));
        }
        if ((data = this.getData(hsData, "FPayeeNumber")) != null && data.toString().trim().length() > 0) {
            IRowSet asstActInfo = null;
            String tableName = info.getPayeeType().getRealtionDataObject();
            if ("T_BD_GeneralAsstActType".equals(tableName)) {
                String asstActTypeGroupId = info.getPayeeType().getGlAsstActTypeGrp() != null ? info.getPayeeType().getGlAsstActTypeGrp().getId().toString() : null;
                asstActInfo = RecAndPayDataImportUtil.getAsstActByNumberAndAsstActTypeID(ctx, tableName, data.toString(), asstActTypeGroupId);
            } else {
                asstActInfo = RecAndPayDataImportUtil.getAsstActInfo(info.getPayeeType(), data.toString(), ctx);
            }
            try {
                if (asstActInfo.next()) {
                    info.setPayeeID(asstActInfo.getString("fid"));
                    info.setPayeeNumber(asstActInfo.getString("fnumber"));
                    info.setPayeeName(asstActInfo.getString("fname"));
                }
            }
            catch (SQLException e) {
                throw new TaskExternalException(e.getMessage());
            }
        }
        if ((data = this.getData(hsData, "FPayeeBank")) != null && data.toString().trim().length() > 0) {
            info.setPayeeBank(data.toString());
        }
        if ((data = this.getData(hsData, "FPayeeAccountBank")) != null && data.toString().trim().length() > 0) {
            info.setPayeeAccountBank(data.toString());
        }
        if ((data = this.getData(hsData, "FAdminOrgUnit")) != null && data.toString().trim().length() > 0) {
            AdminOrgUnitInfo adminOrg = this.importCache.getAdminOrgUnitInfoByCache(ctx, hsData, "FAdminOrgUnit");
            info.setAdminOrgUnit(adminOrg);
        }
        if ((data = this.getData(hsData, "FPerson")) != null && data.toString().trim().length() > 0) {
            PersonInfo person = this.importCache.getPersonInfoByCache(ctx, hsData, "FPerson");
            info.setPerson(person);
        }
        info.setIsInitializeBill(false);
        info.setIsImport(true);
        info.setBillStatus(BillStatusEnum.SAVE);
        info.setSourceType(SourceTypeEnum.AP);
        info.setSourceSysType(SourceTypeEnum.AP);
        return info;
    }

    private boolean isExistHead(Hashtable hsData, Context ctx, CompanyOrgUnitInfo company) throws TaskExternalException {
        String number = (String)this.getData(hsData, "FNumber");
        if (this.infoMap.containsKey(this.curKey)) {
            return false;
        }
        if (company == null || number == null) {
            return true;
        }
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo fi = new FilterInfo();
        fi.getFilterItems().add(new FilterItemInfo("number", (Object)number));
        fi.getFilterItems().add(new FilterItemInfo("company.number", (Object)company.getNumber()));
        view.setFilter(fi);
        try {
            PaymentBillCollection coll = PaymentBillFactory.getLocalInstance(ctx).getPaymentBillCollection(view);
            if (coll != null && coll.size() > 0) {
                throw new TaskExternalException(number + ResourceBase.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"22_AgentPayBillDataImport", (Locale)ctx.getLocale()));
            }
            return false;
        }
        catch (BOSException e) {
            throw new TaskExternalException(ResourceBase.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"41_ArApPaymentBillDataImport", (Locale)ctx.getLocale()) + e.getMessage());
        }
    }

    public void submitHead(CoreBaseInfo coreBaseInfo, Context ctx) throws TaskExternalException {
        try {
            PaymentBillFactory.getLocalInstance(ctx).save(coreBaseInfo);
        }
        catch (Exception e) {
            throw new TaskExternalException(e.getMessage());
        }
    }

    private CoreBaseInfo parseEntry(Hashtable hsData, Context ctx) throws TaskExternalException {
        PaymentBillEntryInfo info = new PaymentBillEntryInfo();
        Object data = null;
        data = this.getData(hsData, "FSeq");
        try {
            if (data != null && data.toString().trim().length() > 0) {
                info.setSeq(TypeConversionUtils.objToInt((Object)data));
            }
        }
        catch (IllegalConversionException e) {
            throw new TaskExternalException(ResourceBase.getString((String)"com.kingdee.eas.fi.cas.CASAutoResource", (String)"68_ArApPaymentBillDataImport", (Locale)ctx.getLocale()));
        }
        try {
            info.setPaymentBill(RecAndPayDataImportUtil.getPaymentBillByNumber(hsData, ctx));
            data = this.getData(hsData, "Famount");
            if (data != null && data.toString().trim().length() > 0) {
                info.setAmount(RecAndPayDataImportUtil.objToBigDecimal(ctx, data));
            }
            if ((data = this.getData(hsData, "FLocalAount")) != null && data.toString().trim().length() > 0) {
                info.setLocalAmt(RecAndPayDataImportUtil.objToBigDecimal(ctx, data));
            }
            if ((data = this.getData(hsData, "Frebate")) != null && data.toString().trim().length() > 0) {
                info.setRebate(RecAndPayDataImportUtil.objToBigDecimal(ctx, data));
            }
            if ((data = this.getData(hsData, "FRebateLocAmt")) != null && data.toString().trim().length() > 0) {
                info.setRebateLocAmt(RecAndPayDataImportUtil.objToBigDecimal(ctx, data));
            }
            if ((data = this.getData(hsData, "FActualAmt")) != null && data.toString().trim().length() > 0) {
                info.setActualAmt(RecAndPayDataImportUtil.objToBigDecimal(ctx, data));
            }
            if ((data = this.getData(hsData, "FActualLocAmt")) != null && data.toString().trim().length() > 0) {
                info.setActualLocAmt(RecAndPayDataImportUtil.objToBigDecimal(ctx, data));
            }
        }
        catch (IllegalConversionException e) {
            throw new TaskExternalException(ResourceBase.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"42_ArApPaymentBillDataImport", (Locale)ctx.getLocale()));
        }
        data = this.getData(hsData, "FRemark");
        if (data != null && data.toString().trim().length() > 0) {
            info.setRemark(data.toString());
        }
        try {
            info.setCoreBillType(this.importCache.getBillTypeByCache(ctx, hsData, "FCoreBillType"));
        }
        catch (Exception e) {
            throw new TaskExternalException(ResourceBase.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"43_ArApPaymentBillDataImport", (Locale)ctx.getLocale()));
        }
        try {
            info.setCoreBillNumber(RecAndPayDataImportUtil.getDataString(hsData, "FCoreBillNum"));
        }
        catch (Exception e) {
            throw new TaskExternalException(ResourceBase.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"44_ArApPaymentBillDataImport", (Locale)ctx.getLocale()));
        }
        try {
            info.setCoreBillEntrySeq(RecAndPayDataImportUtil.getDataInt(hsData, "FCoreBillSeq"));
        }
        catch (Exception e) {
            throw new TaskExternalException(ResourceBase.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"45_ArApPaymentBillDataImport", (Locale)ctx.getLocale()));
        }
        return info;
    }

    private Object getData(Hashtable hsData, String fieldName) {
        Object data = null;
        if (hsData.get(fieldName) != null) {
            data = ((DataToken)hsData.get((Object)fieldName)).data;
        }
        return data;
    }

    public boolean isSameBlock(Hashtable firstData, Hashtable currentData) {
        return RecAndPayDataImportUtil.isSameBlock(firstData, currentData, this.getMainFields());
    }

    public String[] getMainFields() {
        return new String[]{"FNumber", "FCompanyID"};
    }

    public void submit(CoreBaseInfo coreBaseInfo, Context ctx) throws TaskExternalException {
        if (coreBaseInfo == null) {
            return;
        }
        try {
            PaymentBillInfo info = (PaymentBillInfo)coreBaseInfo;
            info.getEntries().sort("seq");
            IObjectPK pk = this.getController(ctx).save(coreBaseInfo);
            if (coreBaseInfo != null && coreBaseInfo.getId() != null) {
                coreBaseInfo.setId(BOSUuid.read((String)pk.toString()));
            }
        }
        catch (Exception e) {
            logger.error((Object)e);
            throw new TaskExternalException(e.getMessage(), e.getCause());
        }
    }

    public int getSubmitType() {
        return 1;
    }

    public String getExportQueryInfo(Context ctx) {
        return "com.kingdee.eas.fi.cas.PaymentBillQuery";
    }

    public FilterInfo getExportFilterForQuery(Context ctx) {
        FilterInfo filter = new FilterInfo();
        if (this.getContextMap().get("filter") != null) {
            String filterStr = this.getContextMap().get("filter").toString();
            filterStr = filterStr.replace("$", "'");
            try {
                filter = new FilterInfo(filterStr);
            }
            catch (ParserException e) {
                logger.error((Object)e);
            }
        }
        if (this.getContextMap().get("bizCommonQueryFilter") != null) {
            String filterItems = this.getContextMap().get("bizCommonQueryFilter").toString();
            filterItems = filterItems.replace("$", "'");
            try {
                filter = new FilterInfo(filterItems);
            }
            catch (ParserException e) {
                logger.error((Object)e);
            }
        }
        return filter;
    }

    public Map exportTransmit(IRowSet rs, Context ctx) throws TaskExternalException {
        Hashtable result = new Hashtable();
        try {
            this.putTable(result, "FNumber", rs.getString("number"));
            this.putTable(result, "FCompanyID", rs.getString("company.number"));
            this.putTable(result, "FBizDate", rs.getString("bizDate"));
            this.putTable(result, "FPayType", rs.getString("payBillType.number"));
            this.putTable(result, "FPaymentTypeID", rs.getString("paymentType.number"));
            this.putTable(result, "FCurrencyID", rs.getString("currency.number"));
            this.putTable(result, "FExchangeRate", rs.getString("exchangeRate"));
            this.putTable(result, "FPayerAccountBankID", rs.getString("payerAccountBank.number"));
            this.putTable(result, "FPayerBankID", rs.getString("payerBank.number"));
            this.putTable(result, "FPayerAccountID", rs.getString("payerAccount.number"));
            this.putTable(result, "FOppAccountID", rs.getString("oppAccount.number"));
            this.putTable(result, "FSettlementTypeID", rs.getString("settlementType.number"));
            this.putTable(result, "FSettlementNumber", rs.getString("settlementNumber"));
            this.putTable(result, "FPayeeTypeID", rs.getString("payeeType.number"));
            this.putTable(result, "FPayeeNumber", rs.getString("payeeNumber"));
            this.putTable(result, "FPayeeBank", rs.getString("payeeBank"));
            this.putTable(result, "FPayeeAccountBank", rs.getString("payeeAccountBank"));
            this.putTable(result, "FAdminOrgUnit", rs.getString("adminOrgUnit.number"));
            this.putTable(result, "FPerson", rs.getString("person.number"));
            this.putTable(result, "FSeq", rs.getString("entries.seq"));
            this.putTable(result, "FDescription", rs.getString("description"));
            this.putTable(result, "Famount", rs.getString("entries.amount"));
            this.putTable(result, "FLocalAount", rs.getString("entries.localAmt"));
            this.putTable(result, "Frebate", rs.getString("entries.rebate"));
            this.putTable(result, "FRebateLocAmt", rs.getString("entries.rebateLocAmt"));
            this.putTable(result, "FActualAmt", rs.getString("entries.actualAmt"));
            this.putTable(result, "FActualLocAmt", rs.getString("entries.actualLocAmt"));
            this.putTable(result, "FCoreBillType", rs.getString("coreBillType.number"));
            this.putTable(result, "FCoreBillNum", rs.getString("entries.coreBillNumber"));
            this.putTable(result, "FCoreBillSeq", rs.getString("entries.coreBillEntrySeq"));
            this.putTable(result, "FRemark", rs.getString("entries.remark"));
        }
        catch (Exception e) {
            throw new TaskExternalException(e.getMessage(), (Throwable)e);
        }
        return result;
    }

    protected void putTable(Hashtable htable, Object key, Object value) {
        DataImportTools.putToHashtable((Hashtable)htable, (Object)key, (Object)value);
    }

    private String getResourceString(Context ctx, String key) {
        return ResourceBase.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)key, (Locale)ctx.getLocale());
    }

    private String getResourceString(Context ctx, String key, Object[] params) {
        return MessageFormat.format(ResourceBase.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)key, (Locale)ctx.getLocale()), params);
    }
}

