/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.cas.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.framework.DynamicObjectFactory;
import com.kingdee.bos.framework.IDynamicObject;
import com.kingdee.bos.metadata.bot.BOTRelationCollection;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.metadata.util.MetaDataLoader;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.core.Constants;
import com.kingdee.eas.base.netctrl.IMutexServiceControl;
import com.kingdee.eas.base.netctrl.MutexServiceControlFactory;
import com.kingdee.eas.base.param.util.ParamManager;
import com.kingdee.eas.basedata.assistant.AccountBankFactory;
import com.kingdee.eas.basedata.assistant.AccountBankInfo;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.IAccountBank;
import com.kingdee.eas.basedata.assistant.ISystemStatusCtrol;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolCollection;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolFactory;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolInfo;
import com.kingdee.eas.basedata.master.account.AccountCurrencyCollection;
import com.kingdee.eas.basedata.master.account.AccountViewCollection;
import com.kingdee.eas.basedata.master.account.AccountViewFactory;
import com.kingdee.eas.basedata.master.account.AccountViewInfo;
import com.kingdee.eas.basedata.master.account.AccountingCurrencyEnum;
import com.kingdee.eas.basedata.master.account.IAccountView;
import com.kingdee.eas.basedata.master.cssp.CustomerFactory;
import com.kingdee.eas.basedata.master.cssp.CustomerInfo;
import com.kingdee.eas.basedata.master.cssp.SupplierFactory;
import com.kingdee.eas.basedata.master.cssp.SupplierInfo;
import com.kingdee.eas.basedata.master.cssp.UsedStatusEnum;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.ICompanyOrgUnit;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.cas.ArApRecPayException;
import com.kingdee.eas.fi.cas.BillStatusEnum;
import com.kingdee.eas.fi.cas.CasForArApException;
import com.kingdee.eas.fi.cas.CasForArApUtil;
import com.kingdee.eas.fi.cas.IPaymentBill;
import com.kingdee.eas.fi.cas.IReceivingBill;
import com.kingdee.eas.fi.cas.IReceivingDisposer;
import com.kingdee.eas.fi.cas.PaymentBillCollection;
import com.kingdee.eas.fi.cas.PaymentBillEntryCollection;
import com.kingdee.eas.fi.cas.PaymentBillFactory;
import com.kingdee.eas.fi.cas.PaymentBillInfo;
import com.kingdee.eas.fi.cas.RecPayBillInfo;
import com.kingdee.eas.fi.cas.RecPayException;
import com.kingdee.eas.fi.cas.ReceivingBillCollection;
import com.kingdee.eas.fi.cas.ReceivingBillEntryCollection;
import com.kingdee.eas.fi.cas.ReceivingBillEntryInfo;
import com.kingdee.eas.fi.cas.ReceivingBillFactory;
import com.kingdee.eas.fi.cas.ReceivingBillInfo;
import com.kingdee.eas.fi.cas.ReceivingBillTypeCollection;
import com.kingdee.eas.fi.cas.ReceivingBillTypeInfo;
import com.kingdee.eas.fi.cas.SettlementStatusEnum;
import com.kingdee.eas.fi.cas.SourceTypeEnum;
import com.kingdee.eas.fm.common.FMVerifyHelper;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.framework.batchaction.BatchActionEnum;
import com.kingdee.eas.scm.framework.bizflow.BizFlowFacadeFactory;
import com.kingdee.eas.scm.framework.bizflow.IBizFlowFacade;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.Set;
import org.apache.log4j.Logger;

public class ArApRecPayServerHelper {
    public static final int REMOVE = 10;
    public static final int AUDIT = 20;
    public static final int ANTI_AUDIT = 30;
    public static final int COMMIT_SETTLE = 40;
    public static final int COMMIT_BE = 41;
    public static final int CHEQUE = 50;
    public static final int PAY = 60;
    public static final int CANCEL_PAY = 70;
    public static final int REC = 61;
    public static final int CANCEL_REC = 71;
    public static final int VOUCHER = 80;
    public static final int DEL_VOUCHER = 90;
    public static final int SUBMIT = 100;
    public static final String CR = " \r\n ";
    public static final int SYSTEM_AR = 1;
    public static final int SYSTEM_AP = 2;
    public static final String COL_SRC_BILL_ID = "sourceBillId";
    public static final String COL_SRC_BILL_ENTRY_ID = "sourceBillEntryId";
    public static final String BIZFLOW_RELATION_FIELD = "FBizFlowRelation";
    private static Logger logger = Logger.getLogger((String)ArApRecPayServerHelper.class.getName());
    String resourcePath = "com.kingdee.eas.fi.ar.ARRecPayResource";
    public static final String srcPath = "com.kingdee.eas.fi.cas.RecPayResource";
    public static final String BIZFLOW_BOTP_RELATION_KEY = "relationColl";

    public static ReceivingBillCollection getRecColl(Context ctx, Set idSet) throws BOSException {
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)idSet, CompareType.INCLUDE));
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(filter);
        evi.getSelector().add("*");
        evi.getSelector().add("payeeAccount.InnerAcct.*");
        evi.getSelector().add("settlementType.*");
        evi.getSelector().add("settlementType.ntType.*");
        evi.getSelector().add("payeeBank.*");
        evi.getSelector().add("bizType.*");
        evi.getSelector().add("oppInnerAcct.*");
        evi.getSelector().add("recBillType.id");
        evi.getSelector().add("recBillType.number");
        evi.getSelector().add("recBillType.name");
        evi.getSelector().add("entries.*");
        evi.getSelector().add("entries.id");
        evi.getSelector().add("entries.amount");
        evi.getSelector().add("entries.rebate");
        evi.getSelector().add("entries.actualAmt");
        evi.getSelector().add("entries.actualAmtVc");
        evi.getSelector().add("entries.sourceBillId");
        evi.getSelector().add("entries.sourceBillEntryId");
        evi.getSelector().add("entries.vcStatus");
        evi.getSelector().add("entries.recBillType.*");
        IReceivingBill iReceivingBill = null;
        iReceivingBill = ctx == null ? ReceivingBillFactory.getRemoteInstance() : ReceivingBillFactory.getLocalInstance(ctx);
        return iReceivingBill.getReceivingBillCollection(evi);
    }

    private Set getRecValidIdSetBySubmit(Context ctx, ReceivingBillCollection coll) throws EASBizException, BOSException {
        HashSet<String> set = new HashSet<String>();
        ReceivingBillInfo info = null;
        int size = coll.size();
        for (int i = 0; i < size; ++i) {
            info = coll.get(i);
            if (!this.checkRecIsCanSubmit(ctx, info)) continue;
            set.add(info.getId().toString());
        }
        return set;
    }

    private boolean checkRecIsCanSubmit(Context ctx, ReceivingBillInfo info) throws EASBizException, BOSException {
        boolean DAPCheckAccount;
        boolean bl = DAPCheckAccount = !this.isDAPCheckAccount(ctx);
        if ((info.getBillStatus().equals((Object)BillStatusEnum.SAVE) || info.getBillStatus().equals((Object)BillStatusEnum.SUBMIT)) && info.getBizDate() != null && info.getSourceType() != null && info.getRecBillType() != null && info.getCurrency() != null && info.getExchangeRate() != null && info.getActRecAmt() != null && info.getActRecLocAmt() != null && info.getEntries() != null) {
            AccountBankInfo payeeAcctBank;
            IAccountView iaccountView;
            AccountViewInfo payeeAccount;
            if ((info.isIsInitializeBill() || DAPCheckAccount) && info.getOppAccount() == null) {
                String message = ResourceBase.getString((String)this.resourcePath, (String)"oppAccount", (Locale)ctx.getLocale());
                this.throwExcetion(message);
            }
            if (info.isIsInitializeBill() || DAPCheckAccount || null != info.getEntries().get(0).getSourceBillId()) {
                if (info.getPayerType() == null) {
                    this.throwExcetion(ctx, "Condition_AsstType");
                }
                if (info.getPayerID() == null) {
                    this.throwExcetion(ctx, "Condition_Asst");
                }
            }
            if (info.isIsTransBill() && (info.getSettlementType() == null || info.getPayeeAccount() == null)) {
                this.throwMessagesException(ctx, new String[]{"Condition_TransSettle", "payeeAccount"});
            }
            if (info.getPayeeAccount() != null && (payeeAccount = (iaccountView = AccountViewFactory.getLocalInstance((Context)ctx)).getAccountViewInfo((IObjectPK)new ObjectUuidPK(info.getPayeeAccount().getId()))).isIsBank() && (info.getPayeeAccountBank() == null || info.getPayeeBank() == null)) {
                this.throwMessagesException(ctx, new String[]{"payeeAccount", "Condition_PayeeAcctAttribute"});
            }
            if (info.getPayeeAccountBank() != null && (payeeAcctBank = info.getPayeeAccountBank()) != null) {
                IAccountBank iAccountBank = AccountBankFactory.getLocalInstance((Context)ctx);
                payeeAcctBank = iAccountBank.getAccountBankInfo((IObjectPK)new ObjectUuidPK(info.getPayeeAccountBank().getId()));
                CurrencyInfo Crinfo = info.getCurrency();
                CurrencyInfo acctBankCrinfo = payeeAcctBank.getCurrency();
                if (payeeAcctBank.isIsByCurrency() && !acctBankCrinfo.getId().equals((Object)Crinfo.getId())) {
                    this.throwMessagesException(ctx, new String[]{"arCurrencyNotEqual"});
                }
            }
            ReceivingBillEntryCollection entrys = info.getEntries();
            int n = entrys.size();
            for (int i = 0; i < n; ++i) {
                if (entrys.get(i).getAmount() == null || entrys.get(i).getAmount().compareTo(Constants.ZERO) == 0) {
                    this.throwMessagesException(ctx, new String[]{"Condition_EntryHead", new Integer(i + 1).toString(), "Condition_EntryRecAmt"});
                }
                if (entrys.get(i).getLocalAmt() != null && entrys.get(i).getLocalAmt().compareTo(Constants.ZERO) != 0) continue;
                this.throwMessagesException(ctx, new String[]{"Condition_EntryHead", new Integer(i + 1).toString(), "Condition_EntryRecLocAmt"});
            }
            return true;
        }
        if (!info.getBillStatus().equals((Object)BillStatusEnum.SAVE) && !info.getBillStatus().equals((Object)BillStatusEnum.SUBMIT)) {
            this.throwBlankExcetion(ctx, "Condition_BillStatus");
        }
        if (info.getBizDate() == null) {
            this.throwExcetion(ctx, "Condition_BizDate");
        }
        if (info.getSourceType() == null) {
            this.throwExcetion(ctx, "Condition_SourceSys");
        }
        if (info.getRecBillType() == null) {
            this.throwExcetion(ctx, "Condition_RecType");
        }
        if (info.getCurrency() == null) {
            this.throwExcetion(ctx, "Condition_Currency");
        }
        if (info.getExchangeRate() == null) {
            this.throwExcetion(ctx, "Condition_ExchangeRate");
        }
        if (info.getActRecAmt() == null) {
            this.throwExcetion(ctx, "Condition_HeadActRecAmt");
        }
        if (info.getActRecLocAmt() == null) {
            this.throwExcetion(ctx, "Condition_HeadLocActAmt");
        }
        if (info.getEntries() == null) {
            this.throwExcetion(ctx, "Condition_HeadEntries");
        }
        return false;
    }

    public void throwExcetion(String message) throws EASBizException {
        throw new ArApRecPayException(ArApRecPayException.CHECKBLANK, new String[]{message});
    }

    public void throwExcetion(Context ctx, String messageItem) throws EASBizException {
        throw new ArApRecPayException(ArApRecPayException.CHECKBLANK, new String[]{ResourceBase.getString((String)this.resourcePath, (String)messageItem, (Locale)ctx.getLocale())});
    }

    public void throwBlankExcetion(Context ctx, String messageItem) throws EASBizException {
        throw new ArApRecPayException(ArApRecPayException.BLANK, new String[]{ResourceBase.getString((String)this.resourcePath, (String)messageItem, (Locale)ctx.getLocale())});
    }

    public void throwBlankMessageExcetion(String message) throws EASBizException {
        throw new ArApRecPayException(ArApRecPayException.BLANK, new String[]{message});
    }

    public void throwMessagesException(Context ctx, String[] messages) throws EASBizException {
        StringBuffer messageBuf = new StringBuffer();
        for (int i = 0; i < messages.length; ++i) {
            String res = ResourceBase.getString((String)this.resourcePath, (String)messages[i], (Locale)ctx.getLocale());
            if ("Missing Resource".equals(res)) {
                messageBuf.append(messages[i]);
                continue;
            }
            messageBuf.append(res);
        }
        this.throwExcetion(messageBuf.toString());
    }

    private boolean isNullOrZero(BigDecimal amt) {
        return amt == null || amt.compareTo(Constants.ZERO) == 0;
    }

    public Set getRecValidIdSetByAction(Context ctx, Set idSet, int action) throws BOSException, EASBizException {
        ReceivingBillCollection coll = ArApRecPayServerHelper.getRecColl(ctx, idSet);
        Set validSet = null;
        switch (action) {
            case 100: {
                validSet = this.getRecValidIdSetBySubmit(ctx, coll);
                break;
            }
            case 10: {
                validSet = this.getRecValidIdSetByRemove(ctx, coll);
                break;
            }
            case 20: {
                validSet = this.getRecValidIdSetByAudit(ctx, coll);
                break;
            }
            case 30: {
                validSet = this.getRecValidIdSetByAntiAudit(ctx, coll);
                break;
            }
            case 40: {
                ArApRecPayServerHelper.checkAcctViewIsValid(ctx, (IObjectCollection)coll);
                validSet = this.getRecValidIdSetByCommit(ctx, coll);
                break;
            }
            case 50: {
                ArApRecPayServerHelper.checkAcctViewIsValid(ctx, (IObjectCollection)coll);
                validSet = this.getRecValidIdSetByCheque(ctx, coll);
                break;
            }
            case 61: {
                ArApRecPayServerHelper.checkAcctViewIsValid(ctx, (IObjectCollection)coll);
                validSet = this.getRecValidIdSetByRec(ctx, coll);
                break;
            }
            case 71: {
                validSet = this.getRecValidIdSetByCancelRec(ctx, coll);
                break;
            }
            case 80: {
                ArApRecPayServerHelper.checkAcctViewIsValid(ctx, (IObjectCollection)coll);
                validSet = this.getRecValidIdSetByVoucher(ctx, coll);
                break;
            }
            case 90: {
                validSet = this.getRecValidIdSetByDelVoucher(ctx, coll);
            }
        }
        if (validSet == null || validSet.isEmpty()) {
            throw new RecPayException(RecPayException.HASNOT_VALID_LISTS);
        }
        return validSet;
    }

    private Set getRecValidIdSetByRemove(Context ctx, ReceivingBillCollection coll) {
        HashSet<String> set = new HashSet<String>();
        ReceivingBillInfo info = null;
        int size = coll.size();
        for (int i = 0; i < size; ++i) {
            info = coll.get(i);
            if (!info.getBillStatus().equals((Object)BillStatusEnum.SAVE) && !info.getBillStatus().equals((Object)BillStatusEnum.SUBMIT)) continue;
            set.add(info.getId().toString());
        }
        return set;
    }

    private Set getRecValidIdSetByAudit(Context ctx, ReceivingBillCollection coll) {
        HashSet<String> set = new HashSet<String>();
        ReceivingBillInfo info = null;
        int size = coll.size();
        for (int i = 0; i < size; ++i) {
            info = coll.get(i);
            if (!info.getBillStatus().equals((Object)BillStatusEnum.SUBMIT) || info.getPayeeAccount() == null || info.getSettlementType() == null) continue;
            set.add(info.getId().toString());
        }
        return set;
    }

    private Set getRecValidIdSetByAntiAudit(Context ctx, ReceivingBillCollection coll) {
        HashSet<String> set = new HashSet<String>();
        ReceivingBillInfo info = null;
        int size = coll.size();
        for (int i = 0; i < size; ++i) {
            info = coll.get(i);
            if (!info.getBillStatus().equals((Object)BillStatusEnum.AUDITED) || !info.getSettlementStatus().equals((Object)SettlementStatusEnum.UNSUBMIT) || info.isFiVouchered()) continue;
            set.add(info.getId().toString());
        }
        return set;
    }

    private Set getRecValidIdSetByCommit(Context ctx, ReceivingBillCollection coll) {
        HashSet<String> set = new HashSet<String>();
        ReceivingBillInfo info = null;
        int size = coll.size();
        for (int i = 0; i < size; ++i) {
            info = coll.get(i);
            if (!info.canCommitCH()) continue;
            set.add(info.getId().toString());
        }
        return set;
    }

    private Set getRecValidIdSetByCheque(Context ctx, ReceivingBillCollection coll) {
        HashSet<String> set = new HashSet<String>();
        ReceivingBillInfo info = null;
        int size = coll.size();
        for (int i = 0; i < size; ++i) {
            info = coll.get(i);
            if (!info.getBillStatus().equals((Object)BillStatusEnum.AUDITED)) continue;
            set.add(info.getId().toString());
        }
        return set;
    }

    private Set getRecValidIdSetByRec(Context ctx, ReceivingBillCollection coll) throws CasForArApException, BOSException {
        HashSet<String> set = new HashSet<String>();
        ReceivingBillInfo info = null;
        int size = coll.size();
        for (int i = 0; i < size; ++i) {
            info = coll.get(i);
            if (info.getSourceType() != SourceTypeEnum.AR || !info.getBillStatus().equals((Object)BillStatusEnum.AUDITED) || !this.isCanCanceRec(ctx, info.getId().toString())) continue;
            set.add(info.getId().toString());
        }
        return set;
    }

    public boolean isCanCanceRec(Context ctx, String billId) throws BOSException, CasForArApException {
        IDynamicObject dynamicObject = DynamicObjectFactory.getLocalInstance((Context)ctx);
        IObjectCollection collection = dynamicObject.getCollection(BOSObjectType.create((String)"E8E08EAC"), "where billID = '" + billId + "'");
        if (collection.size() > 0) {
            throw new CasForArApException(CasForArApException.BILLVERIFIED);
        }
        return true;
    }

    private Set getRecValidIdSetByCancelRec(Context ctx, ReceivingBillCollection coll) {
        HashSet<String> set = new HashSet<String>();
        ReceivingBillInfo info = null;
        int size = coll.size();
        for (int i = 0; i < size; ++i) {
            info = coll.get(i);
            if (!info.getBillStatus().equals((Object)BillStatusEnum.RECED)) continue;
            set.add(info.getId().toString());
        }
        return set;
    }

    private Set getRecValidIdSetByVoucher(Context ctx, ReceivingBillCollection coll) throws EASBizException, BOSException {
        HashSet<String> set = new HashSet<String>();
        ReceivingBillInfo info = null;
        int size = coll.size();
        for (int i = 0; i < size; ++i) {
            info = coll.get(i);
            if (info.getSourceType() == SourceTypeEnum.AR && (info.getBillStatus().equals((Object)BillStatusEnum.AUDITED) || info.getBillStatus().equals((Object)BillStatusEnum.RECED)) && !info.isFiVouchered()) {
                this.checkRecInfoAR(ctx, info);
                set.add(info.getId().toString());
            }
            if (info.getSourceType() == SourceTypeEnum.AR) continue;
            set.add(info.getId().toString());
        }
        return set;
    }

    private void checkRecInfoAR(Context ctx, ReceivingBillInfo info) throws EASBizException, BOSException {
        if (info.getPayerType() == null || info.getPayerID() == null) {
            throw new ArApRecPayException(ArApRecPayException.ASSTNULLNOVOUCHER);
        }
        if (info.getCompany() == null) {
            return;
        }
        String companyId = info.getCompany().getId().toString();
        boolean isRecBillCreateVoucher = CasForArApUtil.isRecBillCreateVoucher(ctx, companyId);
        boolean flag = false;
        if (!isRecBillCreateVoucher) {
            int n = info.getEntries().size();
            for (int i = 0; i < n; ++i) {
                ReceivingBillEntryInfo entry = info.getEntries().get(i);
                int recType = 100;
                try {
                    if (entry.getRecBillType() != null) {
                        recType = Integer.parseInt(entry.getRecBillType().getNumber());
                    }
                }
                catch (NumberFormatException e) {
                    flag = false;
                }
                if (recType != 100 && recType != 102 && this.checkIsDefaultBillType(new Integer(recType))) {
                    flag = true;
                    break;
                }
                flag = false;
            }
            if (!flag) {
                this.throwBlankMessageExcetion(ResourceBase.getString((String)srcPath, (String)"CanNotGenRecVou", (Locale)ctx.getLocale()));
            }
        }
    }

    private Set getRecValidIdSetByDelVoucher(Context ctx, ReceivingBillCollection coll) {
        HashSet<String> set = new HashSet<String>();
        ReceivingBillInfo info = null;
        int size = coll.size();
        for (int i = 0; i < size; ++i) {
            info = coll.get(i);
            if (!info.isFiVouchered()) continue;
            set.add(info.getId().toString());
        }
        return set;
    }

    public static void checkAcctViewIsValid(Context ctx, IObjectCollection coll) throws EASBizException, BOSException {
        block4: {
            block3: {
                if (coll == null || coll.isEmpty()) {
                    return;
                }
                if (!(coll instanceof ReceivingBillCollection)) break block3;
                ReceivingBillCollection coll1 = (ReceivingBillCollection)coll;
                int size = coll1.size();
                for (int i = 0; i < size; ++i) {
                    ArApRecPayServerHelper.checkAcctViewIsValid(ctx, coll1.get(i));
                }
                break block4;
            }
            if (!(coll instanceof PaymentBillCollection)) break block4;
            PaymentBillCollection coll1 = (PaymentBillCollection)coll;
            int size = coll1.size();
            for (int i = 0; i < size; ++i) {
                ArApRecPayServerHelper.checkAcctViewIsValid(ctx, coll1.get(i));
            }
        }
    }

    public static void checkAcctViewIsValid(Context ctx, RecPayBillInfo info) throws EASBizException, BOSException {
        if (info == null) {
            return;
        }
        if (info instanceof PaymentBillInfo) {
            PaymentBillInfo info1 = (PaymentBillInfo)info;
            if (info1.getPayerAccount() != null) {
                ArApRecPayServerHelper.checkAcctViewIsValid(ctx, info1.getNumber(), info1.getCompany().getId().toString(), info1.getPayerAccount().getId().toString());
            }
            if (info1.getOppAccount() != null) {
                ArApRecPayServerHelper.checkAcctViewIsValid(ctx, info1.getNumber(), info1.getCompany().getId().toString(), info1.getOppAccount().getId().toString());
            }
        } else if (info instanceof ReceivingBillInfo) {
            ReceivingBillInfo info1 = (ReceivingBillInfo)info;
            if (info1.getPayeeAccount() != null) {
                ArApRecPayServerHelper.checkAcctViewIsValid(ctx, info1.getNumber(), info1.getCompany().getId().toString(), info1.getPayeeAccount().getId().toString());
            }
            if (info1.getOppAccount() != null) {
                ArApRecPayServerHelper.checkAcctViewIsValid(ctx, info1.getNumber(), info1.getCompany().getId().toString(), info1.getOppAccount().getId().toString());
            }
        }
    }

    public static void checkAcctViewIsValid(Context ctx, String billNumber, String companyId, String acctViewId) throws BOSException, EASBizException {
        if (companyId == null || acctViewId == null) {
            return;
        }
        ICompanyOrgUnit iCompany = null;
        iCompany = ctx == null ? CompanyOrgUnitFactory.getRemoteInstance() : CompanyOrgUnitFactory.getLocalInstance((Context)ctx);
        CompanyOrgUnitInfo company = iCompany.getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(companyId));
        IAccountView iAcctView = null;
        iAcctView = ctx == null ? AccountViewFactory.getRemoteInstance() : AccountViewFactory.getLocalInstance((Context)ctx);
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("accountTableID.id", (Object)company.getAccountTable().getId().toString()));
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)acctViewId));
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(filter);
        AccountViewCollection coll = iAcctView.getAccountViewCollection(evi);
        if (coll == null || coll.isEmpty()) {
            throw new RecPayException(RecPayException.ACCTVIEWISNOTVALID, new Object[]{billNumber});
        }
    }

    public boolean checkIsDefaultRedBillType(Integer number) {
        int[] defaultRedBillType = new int[]{102, 103, 105, 203, 204, 206};
        for (int i = 0; i < defaultRedBillType.length; ++i) {
            if (number == null || number != defaultRedBillType[i]) continue;
            return true;
        }
        return false;
    }

    public boolean checkIsDefaultBlueBillType(Integer number) {
        int[] defaultRedBillType = new int[]{100, 101, 104, 110, 201, 202, 205};
        for (int i = 0; i < defaultRedBillType.length; ++i) {
            if (number == null || number != defaultRedBillType[i]) continue;
            return true;
        }
        return false;
    }

    public static PaymentBillCollection getPayColl(Context ctx, Set idSet) throws BOSException {
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)idSet, CompareType.INCLUDE));
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(filter);
        evi.getSelector().add("*");
        evi.getSelector().add("payerAccount.InnerAcct.*");
        evi.getSelector().add("payerAccountBank.*");
        evi.getSelector().add("settlementType.id");
        evi.getSelector().add("settlementType.name");
        evi.getSelector().add("settlementType.number");
        evi.getSelector().add("settlementType.ntType.*");
        evi.getSelector().add("cheque.*");
        evi.getSelector().add("payerBank.*");
        evi.getSelector().add("bizType.*");
        evi.getSelector().add("oppInnerAcct.*");
        evi.getSelector().add("payBillType.id");
        evi.getSelector().add("payBillType.number");
        evi.getSelector().add("payBillType.name");
        evi.getSelector().add("entries.*");
        evi.getSelector().add("entries.id");
        evi.getSelector().add("entries.amount");
        evi.getSelector().add("entries.rebate");
        evi.getSelector().add("entries.actualAmt");
        evi.getSelector().add("entries.actualAmtVc");
        evi.getSelector().add("entries.sourceBillId");
        evi.getSelector().add("entries.sourceBillEntryId");
        evi.getSelector().add("entries.vcStatus");
        IPaymentBill iPaymentBill = null;
        iPaymentBill = ctx == null ? PaymentBillFactory.getRemoteInstance() : PaymentBillFactory.getLocalInstance(ctx);
        return iPaymentBill.getPaymentBillCollection(evi);
    }

    public Set getPayValidIdSetByAction(Context ctx, Set idSet, int action) throws BOSException, EASBizException {
        PaymentBillCollection coll = ArApRecPayServerHelper.getPayColl(ctx, idSet);
        Set validSet = null;
        switch (action) {
            case 100: {
                validSet = this.getPayValidIdSetBySubmit(ctx, coll);
                break;
            }
            case 10: {
                validSet = this.getPayValidIdSetByRemove(ctx, coll);
                break;
            }
            case 20: {
                validSet = this.getPayValidIdSetByAudit(ctx, coll);
                break;
            }
            case 30: {
                validSet = this.getPayValidIdSetByAntiAudit(ctx, coll);
                break;
            }
            case 40: {
                ArApRecPayServerHelper.checkAcctViewIsValid(ctx, (IObjectCollection)coll);
                validSet = this.getPayValidIdSetByCommit(ctx, coll);
                break;
            }
            case 50: {
                ArApRecPayServerHelper.checkAcctViewIsValid(ctx, (IObjectCollection)coll);
                validSet = this.getPayValidIdSetByCheque(ctx, coll);
                break;
            }
            case 60: {
                ArApRecPayServerHelper.checkAcctViewIsValid(ctx, (IObjectCollection)coll);
                validSet = this.getPayValidIdSetByPay(ctx, coll);
                break;
            }
            case 70: {
                validSet = this.getPayValidIdSetByCancelPay(ctx, coll);
                break;
            }
            case 80: {
                ArApRecPayServerHelper.checkAcctViewIsValid(ctx, (IObjectCollection)coll);
                validSet = this.getPayValidIdSetByVoucher(ctx, coll);
                break;
            }
            case 90: {
                validSet = this.getPayValidIdSetByDelVoucher(ctx, coll);
                break;
            }
            case 41: {
                ArApRecPayServerHelper.checkAcctViewIsValid(ctx, (IObjectCollection)coll);
                validSet = this.getPayValidIdSetByCommitBE(ctx, coll);
            }
        }
        if (validSet == null || validSet.isEmpty()) {
            throw new RecPayException(RecPayException.HASNOT_VALID_LISTS);
        }
        return validSet;
    }

    private Set getPayValidIdSetByRemove(Context ctx, PaymentBillCollection coll) {
        HashSet<String> set = new HashSet<String>();
        PaymentBillInfo info = null;
        int size = coll.size();
        for (int i = 0; i < size; ++i) {
            info = coll.get(i);
            if (!info.getBillStatus().equals((Object)BillStatusEnum.SAVE) && !info.getBillStatus().equals((Object)BillStatusEnum.SUBMIT)) continue;
            set.add(info.getId().toString());
        }
        return set;
    }

    private Set getPayValidIdSetBySubmit(Context ctx, PaymentBillCollection coll) throws EASBizException, BOSException {
        HashSet<String> set = new HashSet<String>();
        PaymentBillInfo info = null;
        int size = coll.size();
        for (int i = 0; i < size; ++i) {
            info = coll.get(i);
            if (!this.checkPayIsCanSubmit(ctx, info)) continue;
            set.add(info.getId().toString());
        }
        return set;
    }

    private boolean checkPayIsCanSubmit(Context ctx, PaymentBillInfo info) throws EASBizException, BOSException {
        boolean DAPCheckAccount;
        boolean bl = DAPCheckAccount = !this.isDAPCheckAccount(ctx);
        if ((info.getBillStatus().equals((Object)BillStatusEnum.SAVE) || info.getBillStatus().equals((Object)BillStatusEnum.SUBMIT)) && info.getBizDate() != null && info.getSourceType() != null && info.getPayBillType() != null && info.getCurrency() != null && info.getExchangeRate() != null && info.getPayeeType() != null && info.getPayeeID() != null && info.getActPayAmt() != null && info.getActPayLocAmt() != null && info.getEntries() != null) {
            AccountBankInfo payerAcctBank;
            IAccountView iaccountView;
            AccountViewInfo payerAccount;
            if ((info.isIsInitializeBill() || DAPCheckAccount) && info.getOppAccount() == null) {
                this.throwExcetion(ctx, "oppAccount");
            }
            if (info.isIsTransBill() && (info.getSettlementType() == null || info.getPayerAccount() == null)) {
                this.throwMessagesException(ctx, new String[]{"Condition_TransSettle", "payerAccount"});
            }
            if (info.getPayerAccount() != null && (payerAccount = (iaccountView = AccountViewFactory.getLocalInstance((Context)ctx)).getAccountViewInfo((IObjectPK)new ObjectUuidPK(info.getPayerAccount().getId()))).isIsBank() && (info.getPayerAccountBank() == null || info.getPayerBank() == null)) {
                this.throwMessagesException(ctx, new String[]{"payerAccount", "Condition_PayerAcctAttribute"});
            }
            if (info.getPayerAccountBank() != null && (payerAcctBank = info.getPayerAccountBank()) != null) {
                IAccountBank iAccountBank = AccountBankFactory.getLocalInstance((Context)ctx);
                payerAcctBank = iAccountBank.getAccountBankInfo((IObjectPK)new ObjectUuidPK(info.getPayerAccountBank().getId()));
                CurrencyInfo Crinfo = info.getCurrency();
                CurrencyInfo acctBankCrinfo = payerAcctBank.getCurrency();
                if (payerAcctBank.isIsByCurrency() && !acctBankCrinfo.getId().equals((Object)Crinfo.getId())) {
                    this.throwMessagesException(ctx, new String[]{"apPayeeAccountBank", "apCurrencyNotEqual"});
                }
            }
            PaymentBillEntryCollection entrys = info.getEntries();
            int n = entrys.size();
            for (int i = 0; i < n; ++i) {
                if (entrys.get(i).getAmount() == null || entrys.get(i).getAmount().compareTo(Constants.ZERO) == 0) {
                    this.throwMessagesException(ctx, new String[]{"Condition_EntryHead", new Integer(i + 1).toString(), "Condition_EntryPayAmt"});
                }
                if (entrys.get(i).getLocalAmt() != null && entrys.get(i).getLocalAmt().compareTo(Constants.ZERO) != 0) continue;
                this.throwMessagesException(ctx, new String[]{"Condition_EntryHead", new Integer(i + 1).toString(), "Condition_EntryPayLocAmt"});
            }
            return true;
        }
        if (!info.getBillStatus().equals((Object)BillStatusEnum.SAVE) && !info.getBillStatus().equals((Object)BillStatusEnum.SUBMIT)) {
            this.throwBlankExcetion(ctx, "Condition_BillStatus");
        }
        if (info.getBizDate() == null) {
            this.throwExcetion(ctx, "Condition_BizDate");
        }
        if (info.getSourceType() == null) {
            this.throwExcetion(ctx, "Condition_SourceSys");
        }
        if (info.getPayBillType() == null) {
            this.throwExcetion(ctx, "Condition_PayType");
        }
        if (info.getCurrency() == null) {
            this.throwExcetion(ctx, "Condition_Currency");
        }
        if (info.getExchangeRate() == null) {
            this.throwExcetion(ctx, "Condition_ExchangeRate");
        }
        if (info.getPayeeType() == null) {
            this.throwExcetion(ctx, "Condition_AsstType");
        }
        if (info.getPayeeID() == null) {
            this.throwExcetion(ctx, "Condition_Asst");
        }
        if (info.getActPayAmt() == null) {
            this.throwExcetion(ctx, "Condition_HeadActPayAmt");
        }
        if (info.getActPayLocAmt() == null) {
            this.throwExcetion(ctx, "Condition_HeadLocActPayAmt");
        }
        if (info.getEntries() == null) {
            this.throwExcetion(ctx, "Condition_HeadEntries");
        }
        return false;
    }

    private Set getPayValidIdSetByAudit(Context ctx, PaymentBillCollection coll) {
        HashSet<String> set = new HashSet<String>();
        PaymentBillInfo info = null;
        int size = coll.size();
        for (int i = 0; i < size; ++i) {
            info = coll.get(i);
            if (!info.getBillStatus().equals((Object)BillStatusEnum.SUBMIT)) continue;
            set.add(info.getId().toString());
        }
        return set;
    }

    private Set getPayValidIdSetByAntiAudit(Context ctx, PaymentBillCollection coll) {
        HashSet<String> set = new HashSet<String>();
        PaymentBillInfo info = null;
        int size = coll.size();
        for (int i = 0; i < size; ++i) {
            info = coll.get(i);
            if (!info.getBillStatus().equals((Object)BillStatusEnum.AUDITED) || !info.getSettlementStatus().equals((Object)SettlementStatusEnum.UNSUBMIT) || info.isFiVouchered()) continue;
            set.add(info.getId().toString());
        }
        return set;
    }

    private Set getPayValidIdSetByCommit(Context ctx, PaymentBillCollection coll) {
        HashSet<String> set = new HashSet<String>();
        PaymentBillInfo info = null;
        int size = coll.size();
        for (int i = 0; i < size; ++i) {
            info = coll.get(i);
            if (!info.canCommitCH(true)) continue;
            set.add(info.getId().toString());
        }
        return set;
    }

    private Set getPayValidIdSetByCheque(Context ctx, PaymentBillCollection coll) {
        HashSet<String> set = new HashSet<String>();
        PaymentBillInfo info = null;
        int size = coll.size();
        for (int i = 0; i < size; ++i) {
            info = coll.get(i);
            if (!info.getBillStatus().equals((Object)BillStatusEnum.AUDITED) || info.isIsRelateCheque()) continue;
            set.add(info.getId().toString());
        }
        return set;
    }

    private Set getPayValidIdSetByPay(Context ctx, PaymentBillCollection coll) throws CasForArApException, BOSException {
        HashSet<String> set = new HashSet<String>();
        PaymentBillInfo info = null;
        int size = coll.size();
        for (int i = 0; i < size; ++i) {
            info = coll.get(i);
            if (info.getSourceType() != SourceTypeEnum.AP || !info.getBillStatus().equals((Object)BillStatusEnum.AUDITED) || !this.isCanCancePay(ctx, info.getId().toString())) continue;
            set.add(info.getId().toString());
        }
        return set;
    }

    public boolean isCanCancePay(Context ctx, String id) throws BOSException, CasForArApException {
        IDynamicObject dynamicObject = DynamicObjectFactory.getLocalInstance((Context)ctx);
        IObjectCollection collection = dynamicObject.getCollection(BOSObjectType.create((String)"763E6D2A"), "where billID = '" + id + "'");
        if (collection.size() > 0) {
            throw new CasForArApException(CasForArApException.BILLVERIFIED);
        }
        return true;
    }

    private Set getPayValidIdSetByCancelPay(Context ctx, PaymentBillCollection coll) {
        HashSet<String> set = new HashSet<String>();
        PaymentBillInfo info = null;
        int size = coll.size();
        for (int i = 0; i < size; ++i) {
            info = coll.get(i);
            if (!info.getBillStatus().equals((Object)BillStatusEnum.PAYED)) continue;
            set.add(info.getId().toString());
        }
        return set;
    }

    private Set getPayValidIdSetByVoucher(Context ctx, PaymentBillCollection coll) throws NumberFormatException, EASBizException, BOSException {
        HashSet<String> set = new HashSet<String>();
        PaymentBillInfo info = null;
        int size = coll.size();
        for (int i = 0; i < size; ++i) {
            info = coll.get(i);
            if ((info.getBillStatus().equals((Object)BillStatusEnum.AUDITED) || info.getBillStatus().equals((Object)BillStatusEnum.PAYED)) && !info.isFiVouchered()) {
                set.add(info.getId().toString());
            }
            this.checkPayInfoAP(ctx, info);
        }
        return set;
    }

    private void checkPayInfoAP(Context ctx, PaymentBillInfo info) throws NumberFormatException, EASBizException, BOSException {
        String companyId = info.getCompany().getId().toString();
        boolean isPayBillCreateVoucher = CasForArApUtil.isPayBillCreateVoucher(ctx, companyId);
        if (!isPayBillCreateVoucher) {
            int payType = 201;
            try {
                payType = Integer.parseInt(info.getPayBillType().getNumber());
            }
            catch (NumberFormatException e) {
                payType = 201;
            }
            if (payType == 201 || payType == 203 || !this.checkIsDefaultBillType(new Integer(payType))) {
                this.throwBlankMessageExcetion(ResourceBase.getString((String)srcPath, (String)"CanNotGenPayVou", (Locale)ctx.getLocale()));
            }
        }
    }

    private Set getPayValidIdSetByDelVoucher(Context ctx, PaymentBillCollection coll) {
        HashSet<String> set = new HashSet<String>();
        PaymentBillInfo info = null;
        int size = coll.size();
        for (int i = 0; i < size; ++i) {
            info = coll.get(i);
            if (!info.isFiVouchered()) continue;
            set.add(info.getId().toString());
        }
        return set;
    }

    private Set getPayValidIdSetByCommitBE(Context ctx, PaymentBillCollection coll) throws EASBizException {
        HashSet<String> set = new HashSet<String>();
        PaymentBillInfo info = null;
        int size = coll.size();
        for (int i = 0; i < size; ++i) {
            info = coll.get(i);
            if (!info.getBillStatus().equals((Object)BillStatusEnum.AUDITED) || info.getPayerAccountBank() == null || !info.getPayerAccountBank().isIsSetBankInterface()) continue;
            FMVerifyHelper.checkBlank((Context)ctx, (IObjectValue)info, (String)"payerAccountBank");
            FMVerifyHelper.checkBlank((Context)ctx, (IObjectValue)info, (String)"payeeName");
            FMVerifyHelper.checkBlank((Context)ctx, (IObjectValue)info, (String)"payeeBank");
            FMVerifyHelper.checkBlank((Context)ctx, (IObjectValue)info, (String)"payeeAccountBank");
            set.add(info.getId().toString());
        }
        return set;
    }

    public boolean checkIsDefaultInitBillType(Integer number) {
        int[] defaultBillType = new int[]{100, 102, 104, 105, 110, 201, 203, 205, 206, 210, 211, 212, 999};
        for (int i = 0; i < defaultBillType.length; ++i) {
            if (number != defaultBillType[i]) continue;
            return false;
        }
        return true;
    }

    public boolean checkIsDefaultBillType(Integer number) {
        int[] defaultBillType = new int[]{100, 102, 101, 103, 104, 105, 110, 201, 203, 202, 204, 205, 206, 210, 211, 212, 999};
        for (int i = 0; i < defaultBillType.length; ++i) {
            if (number != defaultBillType[i]) continue;
            return true;
        }
        return false;
    }

    public static SystemStatusCtrolInfo getSysStatusCtrolInfo(Context ctx, Object cmpnyOrgUntInfObj, SystemEnum system) throws BOSException, EASBizException {
        if (ctx == null) {
            throw new IllegalArgumentException();
        }
        if (!(cmpnyOrgUntInfObj instanceof CompanyOrgUnitInfo)) {
            throw new IllegalArgumentException();
        }
        CompanyOrgUnitInfo cmpnyOrgUntInf = (CompanyOrgUnitInfo)cmpnyOrgUntInfObj;
        String cmpnyOrgUntID = cmpnyOrgUntInf.getId().toString();
        ISystemStatusCtrol systemStatusCtrol = SystemStatusCtrolFactory.getLocalInstance((Context)ctx);
        String cndtn0 = "(company='" + cmpnyOrgUntID + "')";
        String cndtn1 = "(systemStatus.name=" + system.getValue() + ")";
        String cndtn = cndtn0 + " and " + cndtn1;
        String oql = "select *,startPeriod.*,currentPeriod.* where " + cndtn;
        SystemStatusCtrolCollection systmStsCtrlCllctn = systemStatusCtrol.getSystemStatusCtrolCollection(oql);
        int size = systmStsCtrlCllctn.size();
        if (size <= 0) {
            return null;
        }
        if (size == 1) {
            SystemStatusCtrolInfo systmStsCtrlInf = systmStsCtrlCllctn.get(0);
            return systmStsCtrlInf;
        }
        throw new IllegalArgumentException();
    }

    public static boolean isEmpty(Object o) {
        if (o instanceof String) {
            return o == null || o.toString().trim().length() == 0;
        }
        return o == null;
    }

    public void verifyAccountView(Context ctx, AccountViewInfo acctViewInfo, CurrencyInfo currInfo, CompanyOrgUnitInfo company) throws EASBizException {
        boolean isValid;
        block13: {
            AccountCurrencyCollection acctCurrColl;
            AccountViewInfo viewInfo;
            block12: {
                CurrencyInfo currency;
                if (acctViewInfo == null || currInfo == null) {
                    return;
                }
                viewInfo = null;
                acctCurrColl = null;
                if (acctViewInfo.getCurrencyID() == null) {
                    SelectorItemCollection sic = new SelectorItemCollection();
                    sic.add(new SelectorItemInfo("*"));
                    sic.add(new SelectorItemInfo("accountCurrency.*"));
                    try {
                        IAccountView iAccountView = AccountViewFactory.getLocalInstance((Context)ctx);
                        viewInfo = iAccountView.getAccountViewInfo((IObjectPK)new ObjectUuidPK(acctViewInfo.getId()), sic);
                        acctCurrColl = viewInfo.getAccountCurrency();
                    }
                    catch (BOSException e) {
                        logger.error((Object)e);
                    }
                    catch (EASBizException e) {
                        logger.error((Object)e);
                    }
                } else {
                    acctCurrColl = acctViewInfo.getAccountCurrency();
                }
                isValid = false;
                if (viewInfo == null || !AccountingCurrencyEnum.NOCURRENCY.equals((Object)viewInfo.getAccountingcurrency())) break block12;
                if (company == null) {
                    company = ContextUtil.getCurrentFIUnit((Context)ctx);
                }
                if ((currency = company.getBaseCurrency()) == null || !currency.getId().toString().equals(currInfo.getId().toString())) break block13;
                isValid = true;
                break block13;
            }
            if (viewInfo != null && AccountingCurrencyEnum.ALLCURRENCY.equals((Object)viewInfo.getAccountingcurrency())) {
                isValid = true;
            } else if (acctCurrColl != null) {
                int size = acctCurrColl.size();
                for (int i = 0; i < size; ++i) {
                    if (!acctCurrColl.get(i).getCurrency().getId().equals((Object)currInfo.getId())) continue;
                    isValid = true;
                    break;
                }
            }
        }
        if (!isValid) {
            this.throwBlankMessageExcetion(ResourceBase.getString((String)srcPath, (String)"AccountViewInvalid", (Locale)ctx.getLocale()));
        }
    }

    public boolean verifyAccountViewBoolean(Context ctx, AccountViewCollection acctCollection, AccountViewInfo acctViewInfo, CurrencyInfo currInfo, CompanyOrgUnitInfo company) throws EASBizException, BOSException {
        boolean isValid;
        block11: {
            AccountCurrencyCollection acctCurrColl;
            AccountViewInfo viewInfo;
            block10: {
                CurrencyInfo currency;
                if (acctViewInfo == null || currInfo == null) {
                    return true;
                }
                viewInfo = null;
                acctCurrColl = null;
                if (acctViewInfo.getCurrencyID() == null) {
                    if (acctCollection.containsKey((Object)acctViewInfo.getId())) {
                        viewInfo = acctCollection.get((Object)acctViewInfo.getId());
                        acctCurrColl = viewInfo.getAccountCurrency();
                    }
                } else {
                    acctCurrColl = acctViewInfo.getAccountCurrency();
                }
                isValid = false;
                if (viewInfo == null || !AccountingCurrencyEnum.NOCURRENCY.equals((Object)viewInfo.getAccountingcurrency())) break block10;
                if (company == null) {
                    company = ContextUtil.getCurrentFIUnit((Context)ctx);
                }
                if ((currency = company.getBaseCurrency()) == null) {
                    currency = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo("SELECT baseCurrency.id WHERE id = '" + String.valueOf(company.getId()) + "'").getBaseCurrency();
                }
                if (!currency.getId().toString().equals(currInfo.getId().toString())) break block11;
                isValid = true;
                break block11;
            }
            if (viewInfo != null && AccountingCurrencyEnum.ALLCURRENCY.equals((Object)viewInfo.getAccountingcurrency())) {
                isValid = true;
            } else if (acctCurrColl != null) {
                int size = acctCurrColl.size();
                for (int i = 0; i < size; ++i) {
                    if (!acctCurrColl.get(i).getCurrency().getId().equals((Object)currInfo.getId())) continue;
                    isValid = true;
                    break;
                }
            }
        }
        return isValid;
    }

    public void requestMutex(Context ctx, String id) throws EASBizException, BOSException {
        IMutexServiceControl mutexServiceControl = MutexServiceControlFactory.getLocalInstance((Context)ctx);
        boolean flag = mutexServiceControl.requestObjIDForUpdate(id);
        if (!flag) {
            ResourceBase.getString((String)"com.kingdee.eas.fi.ar.ArApBillResource", (String)"DataMutex", (Locale)ctx.getLocale());
        }
    }

    public static void releaseMutex(Context ctx, String id) throws BOSException {
        IMutexServiceControl mutexServiceControl = MutexServiceControlFactory.getLocalInstance((Context)ctx);
        mutexServiceControl.releaseObjIDForUpdate(id);
    }

    protected boolean isDAPCheckAccount(Context ctx) throws BOSException, EASBizException {
        StringBuffer sql = new StringBuffer("select FValue from T_ARAP_CommonParam ");
        sql.append(" where fnumber='").append("CHECK_ACCOUNT_RANGE").append("'");
        boolean val = true;
        try {
            String value;
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
            if (rs.next() && (value = rs.getString("fvalue")) != null) {
                val = "DAP_RELATION".equalsIgnoreCase(value);
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return val;
    }

    public static void injectBizFlow(Context ctx, IObjectValue model, BatchActionEnum action) throws EASBizException, BOSException {
        Object object;
        IBizFlowFacade iBizFlow = BizFlowFacadeFactory.getLocalInstance((Context)ctx);
        if (action.equals((Object)BatchActionEnum.SAVE) && (object = model.get(BIZFLOW_BOTP_RELATION_KEY)) instanceof IObjectCollection) {
            iBizFlow.bizFlowInject(model, (IObjectCollection)object, action);
        }
        if (action.equals((Object)BatchActionEnum.SUBMIT)) {
            iBizFlow.bizFlowInject(model, action);
        }
        if (action.equals((Object)BatchActionEnum.AUDIT) || action.equals((Object)BatchActionEnum.UNAUDIT) || action.equals((Object)BatchActionEnum.DELETE)) {
            iBizFlow.bizFlowWriteBack(model, action);
        }
    }

    public static void doWriteBack(Context ctx, IObjectValue model, BatchActionEnum action) throws BOSException, EASBizException {
        IBizFlowFacade iBizFlow = BizFlowFacadeFactory.getLocalInstance((Context)ctx);
        if (action.equals((Object)BatchActionEnum.SUBMIT)) {
            iBizFlow.bizFlowWriteBack(model, action);
        }
    }

    public static boolean isExistsBizFlowField(Context ctx, String tableName) throws BOSException {
        boolean isExists = false;
        if (StringUtils.isEmpty((String)tableName)) {
            return isExists;
        }
        StringBuffer sql = new StringBuffer();
        sql.append("select 1 from ksql_usercolumns where ksql_col_tabname='").append(tableName).append("' and ksql_col_name='");
        sql.append(BIZFLOW_RELATION_FIELD).append("'");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        if (rs != null && rs.size() > 0) {
            isExists = true;
        }
        return isExists;
    }

    public static boolean isHasBizFlowValue(Context ctx, String tableName, Set idSet) throws BOSException {
        boolean isHasValue = false;
        if (StringUtils.isEmpty((String)tableName) || idSet == null || idSet.size() == 0) {
            return isHasValue;
        }
        StringBuffer sql = new StringBuffer();
        sql.append("select ").append(BIZFLOW_RELATION_FIELD).append(" from ").append(tableName);
        sql.append(" where ").append(BIZFLOW_RELATION_FIELD).append(" is not null and FID in ").append(ArApRecPayServerHelper.getInStringFromSet(idSet));
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        if (rs != null && rs.size() > 0) {
            isHasValue = true;
        }
        return isHasValue;
    }

    public static String getInStringFromSet(Set idSet) {
        if (idSet == null || idSet.size() == 0) {
            return null;
        }
        StringBuffer in = new StringBuffer();
        in.append(" (");
        Iterator iter = idSet.iterator();
        while (iter.hasNext()) {
            in.append("'").append(iter.next().toString()).append("'");
            if (!iter.hasNext()) continue;
            in.append(",");
        }
        in.append(") ");
        return in.toString();
    }

    public static SelectorItemCollection getRecPayBillSelector() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("company.id"));
        sic.add(new SelectorItemInfo("company.number"));
        sic.add(new SelectorItemInfo("localAmt"));
        sic.add(new SelectorItemInfo("isTransBill"));
        sic.add(new SelectorItemInfo("isInitializeBill"));
        sic.add(new SelectorItemInfo("isCoopBuild"));
        sic.add(new SelectorItemInfo("isTransOtherBill"));
        sic.add(new SelectorItemInfo(COL_SRC_BILL_ID));
        sic.add(new SelectorItemInfo("AsstActID_SourceBill"));
        sic.add(new SelectorItemInfo("billStatus"));
        sic.add(new SelectorItemInfo("bizDate"));
        return sic;
    }

    public static SelectorItemCollection getRecBillSelector() {
        SelectorItemCollection sic = ArApRecPayServerHelper.getRecPayBillSelector();
        sic.add(new SelectorItemInfo("payerType.id"));
        sic.add(new SelectorItemInfo("payerID"));
        sic.add(new SelectorItemInfo("payerNumber"));
        sic.add(new SelectorItemInfo("recBillType.id"));
        sic.add(new SelectorItemInfo("paymentType.id"));
        sic.add(new SelectorItemInfo("paymentType.number"));
        return sic;
    }

    public static SelectorItemCollection getPayBillSelector() {
        SelectorItemCollection sic = ArApRecPayServerHelper.getRecPayBillSelector();
        sic.add(new SelectorItemInfo("payeeType.id"));
        sic.add(new SelectorItemInfo("payeeID"));
        sic.add(new SelectorItemInfo("payeeNumber"));
        sic.add(new SelectorItemInfo("payBillType.id"));
        sic.add(new SelectorItemInfo("paymentType.id"));
        sic.add(new SelectorItemInfo("paymentType.number"));
        return sic;
    }

    public Integer transRecBillType(Context ctx, ReceivingBillTypeCollection recTypeColl, ReceivingBillTypeInfo recTypeInfo) {
        Integer recType = null;
        if (!(recTypeInfo = recTypeColl.get(recTypeInfo.getId())).isIsPreSet()) {
            if (recTypeInfo.getPreSetBillType() == null) {
                return null;
            }
            String typeid = recTypeInfo.getPreSetBillType().getId().toString();
            if ("DAWSqQEREADgAAGVwKgSfCqo2zU=".equals(typeid)) {
                recType = new Integer(100);
            } else if ("DAWSqQEREADgAAILwKgSfCqo2zU=".equals(typeid)) {
                recType = new Integer(101);
            } else if ("DAWSqQEREADgAAInwKgSfCqo2zU=".equals(typeid)) {
                recType = new Integer(102);
            } else if ("DAWSqQEREADgAAIswKgSfCqo2zU=".equals(typeid)) {
                recType = new Integer(103);
            } else if ("DAWSqQEREADgAAIOwKgSfCqo2zU=".equals(typeid)) {
                recType = new Integer(104);
            } else if ("DAWSqQEREADgAAIvwKgSfCqo2zU=".equals(typeid)) {
                recType = new Integer(105);
            }
        } else {
            recType = new Integer(recTypeInfo.getNumber());
        }
        return recType;
    }

    public static IReceivingDisposer getSettlementBillDisPoser(Context ctx, ReceivingBillInfo info) throws BOSException {
        IReceivingDisposer disposer = null;
        StringBuffer sql = new StringBuffer(100);
        sql.append(" SELECT SETTLEBILLENTRY.FID AS FID FROM T_SBC_SettlementBillENTRY SETTLEBILLENTRY ");
        sql.append(" INNER JOIN T_AR_OTHERBILLENTRY ARENTRY ON SETTLEBILLENTRY.FID = ARENTRY.FSOURCEBILLENTRYID ");
        sql.append(" INNER JOIN T_CAS_RECEIVINGBILLENTRY RECENTRY ON ARENTRY.FID = RECENTRY.FSOURCEBILLENTRYID ");
        sql.append(" INNER JOIN T_CAS_RECEIVINGBILL REC ON REC.FID = RECENTRY.FReceivingBillID ");
        sql.append(" WHERE REC.FID = ? ");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new String[]{info.getId().toString()});
        try {
            if (rs.next()) {
                String disposerName = "com.kingdee.eas.sscbusiness.contract.BizReceivingBillReBack";
                disposer = (IReceivingDisposer)Class.forName(disposerName).newInstance();
            }
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        return disposer;
    }

    public static void appointmentAccount4Verify(Context ctx, String entryID, AccountViewInfo recPayAcct, AccountViewInfo oppAccount, PeriodInfo currentPeriod) throws BOSException {
        try {
            Class<?> clazz = Class.forName("com.kingdee.eas.fi.arap.app.util.ArApServerUtils");
            if (clazz != null) {
                Method method = clazz.getMethod("appointmentAccount4Verify", Context.class, String.class, AccountViewInfo.class, AccountViewInfo.class, PeriodInfo.class);
                Object[] params = new Object[]{ctx, entryID, recPayAcct, oppAccount, currentPeriod};
                Object object = method.invoke(clazz.newInstance(), params);
            }
        }
        catch (Exception e) {
            throw new BOSException(e.getCause());
        }
    }

    public static String getExtServiceClassName(Context ctx, String factoryClassName, SourceTypeEnum sourceType) {
        String extServiceClassName = null;
        String sql = "SELECT FEXTSERVICECLASSNAME FROM T_CAS_RECPAYEXTSERVICE WHERE FFACTORYCLASSNAME = ? AND FSOURCETYPE = ?";
        Object[] param = new Object[]{factoryClassName, sourceType.getValue()};
        try {
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])param);
            while (rowSet.next()) {
                extServiceClassName = rowSet.getString("FEXTSERVICECLASSNAME");
            }
        }
        catch (BOSException e) {
            logger.error((Object)e);
        }
        catch (SQLException e) {
            logger.error((Object)e);
        }
        return extServiceClassName;
    }

    public void checkPayeeForPayment(Context ctx, PaymentBillInfo info) throws EASBizException, BOSException {
        boolean needHandle;
        boolean bl = needHandle = SourceTypeEnum.AP == info.getSourceType() && !StringUtils.isEmpty((String)info.getPayeeID()) && null != info.getPayeeType() && null != info.getCompany();
        if (needHandle) {
            IRowSet rowSet;
            Object[] params;
            String sql;
            String companyId = info.getCompany().getId().toString();
            BOSObjectType bosType = BOSUuid.getBOSObjectType((String)info.getPayeeID(), (boolean)true);
            EntityObjectInfo entity = MetaDataLoader.getEntity((Context)ctx, (BOSObjectType)bosType);
            String relDataObject = entity.getTable().getName().toLowerCase(Locale.ENGLISH);
            String oql = "select id, name, number,usedStatus where id = '" + info.getPayeeID() + "'";
            if ("T_BD_Supplier".equalsIgnoreCase(relDataObject)) {
                SupplierInfo supplierInfo = SupplierFactory.getLocalInstance((Context)ctx).getSupplierInfo(oql);
                if (supplierInfo.getUsedStatus() != UsedStatusEnum.APPROVED) {
                    this.throwBlankExcetion(ctx, "asstActNotApproved");
                }
                sql = "SELECT FID,FIsFreezePayment,FUsingStatus FROM T_BD_SUPPLIERCOMPANYINFO WHERE FCOMORGID = ? AND FSUPPLIERID= ?";
                params = new String[]{companyId, info.getPayeeID()};
                rowSet = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])params);
                boolean isFreezePayment = false;
                int usingStatus = 0;
                try {
                    if (rowSet.next()) {
                        isFreezePayment = rowSet.getBoolean("FIsFreezePayment");
                        usingStatus = rowSet.getInt("FUsingStatus");
                    }
                }
                catch (SQLException e) {
                    logger.error((Object)e);
                    throw new BOSException((Throwable)e);
                }
                if (usingStatus != 0) {
                    this.throwBlankExcetion(ctx, "asstActCompanyNotApproved");
                }
                if (isFreezePayment) {
                    this.throwBlankExcetion(ctx, "supplierHasFreezePayment");
                }
            }
            if ("T_BD_Customer".equalsIgnoreCase(relDataObject)) {
                CustomerInfo customerInfo = CustomerFactory.getLocalInstance((Context)ctx).getCustomerInfo(oql);
                if (customerInfo.getUsedStatus() != UsedStatusEnum.APPROVED) {
                    this.throwBlankExcetion(ctx, "asstActNotApproved");
                }
                sql = "SELECT FID,FUsingStatus FROM T_BD_CUSTOMERCOMPANYINFO WHERE FCOMORGID = ? AND FCUSTOMERID = ?";
                params = new String[]{companyId, info.getPayeeID()};
                rowSet = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])params);
                int usingStatus = 0;
                try {
                    if (rowSet.next()) {
                        usingStatus = rowSet.getInt("FUsingStatus");
                    }
                }
                catch (SQLException e) {
                    logger.error((Object)e);
                    throw new BOSException((Throwable)e);
                }
                if (usingStatus != 0) {
                    this.throwBlankExcetion(ctx, "asstActCompanyNotApproved");
                }
            }
        }
    }

    public static boolean isAR_045(Context ctx, String companyID) throws BOSException, EASBizException {
        return ArApRecPayServerHelper.getBooleanParamValue(ctx, companyID, "AR_045");
    }

    public static boolean getBooleanParamValue(Context ctx, String companyID, String key) {
        ObjectUuidPK pk = new ObjectUuidPK(companyID);
        String value = null;
        try {
            value = ParamManager.getParamValue((Context)ctx, (IObjectPK)pk, (String)key);
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
        return "true".equalsIgnoreCase(value) || "1".equalsIgnoreCase(value);
    }

    private static boolean canDAPVoucherAddEntry(Context ctx) throws BOSException {
        boolean canModifyEntry = false;
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)"SELECT FVALUE FROM T_ARAP_COMMONPARAM WHERE FNUMBER = 'canDAPVoucherAddEntry'");
        try {
            if (rs.next() && "1".equals(rs.getString("FVALUE"))) {
                canModifyEntry = true;
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return canModifyEntry;
    }

    private static void canDapVoucherModifyEntry(Context ctx, String srcBillId, String destBillId, String companyId) throws BOSException, EASBizException {
        if (ArApRecPayServerHelper.canDAPVoucherAddEntry(ctx)) {
            return;
        }
        CompanyOrgUnitInfo company = new CompanyOrgUnitInfo();
        company.setId(BOSUuid.read((String)companyId));
        PeriodInfo arPeriod = CasForArApUtil.getSysStatusCtrolInfo(ctx, company, SystemEnum.ACCOUNTSRECEIVABLE).getCurrentPeriod();
        PeriodInfo apPeriod = CasForArApUtil.getSysStatusCtrolInfo(ctx, company, SystemEnum.ACCOUNTSPAYABLE).getCurrentPeriod();
        if (arPeriod == null) {
            arPeriod = apPeriod;
        } else if (apPeriod == null) {
            apPeriod = arPeriod;
        }
        StringBuilder sb = new StringBuilder(500);
        sb.append("SELECT DISTINCT VOUENTRY.FID FID FROM T_GL_VOUCHERENTRY VOUENTRY ").append(CR);
        sb.append("  INNER JOIN T_AR_CONTRASTACCOUNTVIEW ACCOUNT ").append(CR);
        sb.append("\t   ON VOUENTRY.FACCOUNTID = ACCOUNT.FACCOUNTID ").append(CR);
        sb.append(" AND (( 1= 1").append(CR);
        if (arPeriod != null) {
            sb.append(" AND account.FSystem = ").append(1).append(CR);
            sb.append(" AND account.FPeriodYear = ").append(arPeriod.getPeriodYear()).append(CR);
            sb.append(" AND account.FPeriodNumber = ").append(arPeriod.getPeriodNumber()).append(CR);
        }
        sb.append(") OR ( 1= 1 ");
        if (apPeriod != null) {
            sb.append(" AND account.FSystem = ").append(2).append(CR);
            sb.append(" AND account.FPeriodYear = ").append(apPeriod.getPeriodYear()).append(CR);
            sb.append(" AND account.FPeriodNumber = ").append(apPeriod.getPeriodNumber()).append(CR);
        }
        sb.append(")) AND account.FCompanyID = '").append(companyId).append("'").append(CR);
        sb.append("WHERE VOUENTRY.FBILLID = '").append(destBillId).append("'").append(CR);
        sb.append(" AND NOT EXISTS (SELECT 1 FROM T_AR_ARAPRELATIONENTRY REL ").append(CR);
        sb.append("                 WHERE VOUENTRY.FID = REL.FDESTENTRYID ").append(CR);
        sb.append("                   AND REL.FDESTOBJECTID = '").append(destBillId).append("'").append(CR);
        sb.append("                    AND REL.FSRCOBJECTID IN ").append(srcBillId).append(CR);
        sb.append("                )");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sb.toString());
        if (null != rs && rs.size() > 0) {
            throw new ArApRecPayException(ArApRecPayException.VOUCHER_FROM_DAP);
        }
    }

    public static void checkDapVoucherEntryCanModify(Context ctx, StringBuffer sqlID, BOTRelationCollection bOTRelationInfos, int system) throws BOSException, EASBizException {
        if (null != sqlID && sqlID.length() > 0) {
            String tableName = 101 == system ? "T_CAS_PAYMENTBILL" : "T_CAS_RECEIVINGBILL";
            String paramsql = "select fcompanyid, fisAppointVoucher, fid from " + tableName + " where fid in (" + sqlID.toString() + ") and fsourceType=" + system;
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)paramsql);
            HashMap<String, String> companyMap = new HashMap<String, String>();
            HashSet<String> checkIdSet = new HashSet<String>();
            try {
                while (rs.next()) {
                    String companyID = rs.getString(1);
                    boolean isAppointVoucher = rs.getBoolean(2);
                    String billId = rs.getString(3);
                    companyMap.put(billId, companyID);
                    if (isAppointVoucher) continue;
                    checkIdSet.add(billId);
                }
            }
            catch (SQLException e) {
                throw new BOSException((Throwable)e);
            }
            if (checkIdSet.size() > 0) {
                String checkIds = ArApRecPayServerHelper.convertSetToString(checkIdSet);
                int size = bOTRelationInfos.size();
                for (int i = 0; i < size; ++i) {
                    String companyId;
                    String destBillId = bOTRelationInfos.get(i).getDestObjectID();
                    String srcBillId = bOTRelationInfos.get(i).getSrcObjectID();
                    if (!checkIdSet.contains(srcBillId) || ArApRecPayServerHelper.isAR_045(ctx, companyId = (String)companyMap.get(srcBillId))) continue;
                    ArApRecPayServerHelper.canDapVoucherModifyEntry(ctx, checkIds, destBillId, companyId);
                }
            }
        }
    }

    public static String convertSetToString(Set idSet) {
        StringBuilder idString = new StringBuilder(120);
        if (idSet.size() > 0) {
            Iterator iterator = idSet.iterator();
            idString.append("(");
            while (iterator.hasNext()) {
                idString.append("'").append(iterator.next().toString()).append("'").append(",");
            }
            idString.deleteCharAt(idString.length() - 1);
            idString.append(")");
        }
        return idString.toString();
    }
}

