/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.cas.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.codingrule.CodingRuleManagerFactory;
import com.kingdee.eas.base.codingrule.ICodingRuleManager;
import com.kingdee.eas.basedata.assistant.AccountBankInfo;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.PaymentTypeInfo;
import com.kingdee.eas.basedata.assistant.SettlementTypeInfo;
import com.kingdee.eas.basedata.master.material.app.DataImportTools;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.fi.cas.AbstractReceivingBillInfo;
import com.kingdee.eas.fi.cas.BillStatusEnum;
import com.kingdee.eas.fi.cas.CasConstants;
import com.kingdee.eas.fi.cas.CasForArApUtil;
import com.kingdee.eas.fi.cas.IReceivingBill;
import com.kingdee.eas.fi.cas.RecPayHelper;
import com.kingdee.eas.fi.cas.ReceivingBillCollection;
import com.kingdee.eas.fi.cas.ReceivingBillEntryInfo;
import com.kingdee.eas.fi.cas.ReceivingBillFactory;
import com.kingdee.eas.fi.cas.ReceivingBillInfo;
import com.kingdee.eas.fi.cas.ReceivingBillTypeInfo;
import com.kingdee.eas.fi.cas.SourceTypeEnum;
import com.kingdee.eas.fi.cas.app.ARAPImportCache;
import com.kingdee.eas.fi.cas.app.RecAndPayDataImportUtil;
import com.kingdee.eas.fi.cas.app.ReceivingBillImportVerify;
import com.kingdee.eas.fi.cas.utils.CollectionUtils;
import com.kingdee.eas.fm.common.ContextHelperFactory;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.scm.common.util.StringUtil;
import com.kingdee.eas.tools.datatask.AbstractDataTransmission;
import com.kingdee.eas.tools.datatask.core.TaskExternalException;
import com.kingdee.eas.tools.datatask.runtime.DataToken;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.IllegalConversionException;
import com.kingdee.util.TypeConversionUtils;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;

public class ArApReceivingBillDataImport
extends AbstractDataTransmission {
    private static Logger logger = Logger.getLogger((String)ArApReceivingBillDataImport.class.getName());
    private ARAPImportCache importCache = new ARAPImportCache();
    private ReceivingBillImportVerify verify;
    private Map infoMap = new HashMap(100);
    private String curKey;
    protected static final String Arap_RecPayDataImport = "com.kingdee.eas.fi.cas.ArApRecPayDataImportResource";
    private boolean isImportDataByRule = false;

    protected ICoreBase getController(Context ctx) throws TaskExternalException {
        try {
            return ReceivingBillFactory.getLocalInstance(ctx);
        }
        catch (BOSException e) {
            throw new TaskExternalException(e.getMessage());
        }
    }

    public ReceivingBillImportVerify getVerify() {
        if (this.verify == null) {
            this.verify = new ReceivingBillImportVerify();
        }
        return this.verify;
    }

    public void setVerify(ReceivingBillImportVerify verify) {
        this.verify = verify;
    }

    public CoreBaseInfo transmit(Hashtable hsData, Context ctx) throws TaskExternalException {
        Hashtable data = CollectionUtils.reverseTableValue(hsData);
        ReceivingBillInfo head = this.generateReceivingBillInfo(ctx, data);
        this.getVerify().verifyHead(ctx, (CoreBaseInfo)head);
        return head;
    }

    protected ReceivingBillInfo generateReceivingBillInfo(Context ctx, Hashtable tableData) throws TaskExternalException {
        String errorMsg = "";
        ReceivingBillEntryInfo entry = null;
        IReceivingBill iReceivingBill = null;
        boolean isUpdateImport = false;
        boolean isExistedBill = false;
        AbstractReceivingBillInfo head = null;
        HashMap<Integer, ReceivingBillEntryInfo> entryMap = new HashMap<Integer, ReceivingBillEntryInfo>();
        Enumeration dataEnumeration = tableData.keys();
        HashSet<String> set = new HashSet<String>();
        while (dataEnumeration.hasMoreElements()) {
            Object key = dataEnumeration.nextElement();
            Hashtable hsData = (Hashtable)tableData.get(key);
            set.add((String)this.getData(hsData, "FPayerNumber"));
            String number = (String)this.getData(hsData, "FNumber");
            this.isImportDataByRule = RecPayHelper.getImportParam(ctx);
            hsData.put("IsImportDataByRule", this.isImportDataByRule);
            CompanyOrgUnitInfo curCompany = this.importCache.getCompanyByCache(ctx, hsData, "FCompanyID");
            this.importCache.checkOrgPermissionByCache(ctx, curCompany, "cas_receivingbill_14inport");
            this.curKey = curCompany.getNumber() + number;
            boolean isNumberNull = StringUtil.isEmpty((String)number);
            try {
                iReceivingBill = ReceivingBillFactory.getLocalInstance(ctx);
                if (!this.infoMap.containsKey(this.curKey)) {
                    ReceivingBillCollection recColl;
                    if (this.isSltImportUpdate() && !isNumberNull && (recColl = iReceivingBill.getReceivingBillCollection("where number ='" + number + "' and company.number = '" + curCompany.getNumber() + "'")) != null && recColl.size() > 0) {
                        head = iReceivingBill.getReceivingBillInfo((IObjectPK)new ObjectUuidPK(recColl.get(0).getId()));
                        if (!BillStatusEnum.SAVE.equals((Object)head.getBillStatus())) {
                            errorMsg = ResourceBase.getString((String)Arap_RecPayDataImport, (String)"ONLY_CAN_IMPORT", (Locale)ctx.getLocale()) + ResourceBase.getString((String)Arap_RecPayDataImport, (String)"ReceivingBill", (Locale)ctx.getLocale());
                            throw new TaskExternalException(errorMsg);
                        }
                        if (head.getEntries() != null && head.getEntries().size() > 0 && head.getEntries().get(0).getSourceBillId() != null) {
                            errorMsg = ResourceBase.getString((String)Arap_RecPayDataImport, (String)"CANNOT_OVER_IMPORT", (Locale)ctx.getLocale()) + ResourceBase.getString((String)Arap_RecPayDataImport, (String)"ReceivingBill", (Locale)ctx.getLocale());
                            throw new TaskExternalException(errorMsg);
                        }
                        for (int i = 0; i < head.getEntries().size(); ++i) {
                            entry = head.getEntries().get(i);
                            entryMap.put(entry.getSeq(), entry);
                        }
                        isExistedBill = true;
                    }
                    if (null == head) {
                        head = new ReceivingBillInfo();
                    }
                    head.setCompany(curCompany);
                    head.setCU(curCompany.getCU());
                    this.parseHead(hsData, ctx, (ReceivingBillInfo)head);
                    this.infoMap.put(this.curKey, head);
                } else {
                    isUpdateImport = true;
                    head = (ReceivingBillInfo)this.infoMap.get(this.curKey);
                }
            }
            catch (Exception e) {
                throw new TaskExternalException(e.getMessage());
            }
            entry = (ReceivingBillEntryInfo)this.parseEntry(hsData, ctx, curCompany, head.getCurrency());
            this.getVerify().verifyEntry(ctx, (CoreBaseInfo)entry, head.getSourceType());
            this.getVerify().verifyEntryAmt(ctx, entry, head);
            if (this.isSltImportUpdate()) {
                if (entryMap.get(entry.getSeq()) != null) {
                    head.getEntries().remove((ReceivingBillEntryInfo)entryMap.get(entry.getSeq()));
                }
                entryMap.put(entry.getSeq(), entry);
            }
            head.getEntries().add(entry);
            if (!this.isImportDataByRule || isUpdateImport || isExistedBill) continue;
            try {
                ICodingRuleManager iCodingRuleManager = CodingRuleManagerFactory.getLocalInstance((Context)ctx);
                String cid = curCompany.getId().toString();
                if (iCodingRuleManager.isExist((IObjectValue)head, cid)) {
                    head.setNumber(iCodingRuleManager.getNumber((IObjectValue)head, cid, ""));
                    continue;
                }
                Object[] name = new String[]{ResourceBase.getString((String)Arap_RecPayDataImport, (String)"ReceivingBill", (Locale)ctx.getLocale())};
                throw new TaskExternalException(MessageFormat.format(CasForArApUtil.getStrResource("CodingRule_Error"), name));
            }
            catch (Exception e) {
                Object[] name = new String[]{ResourceBase.getString((String)Arap_RecPayDataImport, (String)"ReceivingBill", (Locale)ctx.getLocale())};
                throw new TaskExternalException(MessageFormat.format(CasForArApUtil.getStrResource("CodingRule_Error"), name));
            }
        }
        if (tableData.size() > 1 && set.size() > 1 && set.size() <= tableData.size()) {
            throw new TaskExternalException(ResourceBase.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"500_ReceivingBillImport", (Locale)ctx.getLocale()));
        }
        BigDecimal sumActualAmt = CasConstants.ZERO;
        BigDecimal sumActualLocAmt = CasConstants.ZERO;
        for (int i = 0; i < head.getEntries().size(); ++i) {
            ReceivingBillEntryInfo entryInfo = head.getEntries().get(0);
            sumActualAmt = sumActualAmt.add(entryInfo.getActualAmt());
            sumActualLocAmt = sumActualLocAmt.add(entryInfo.getActualLocAmt());
        }
        head.setActRecAmt(sumActualAmt);
        head.setActRecLocAmt(sumActualLocAmt);
        return head;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void parseHead(Hashtable hsData, Context ctx, ReceivingBillInfo info) throws TaskExternalException {
        SettlementTypeInfo settleInfo;
        Object data = null;
        boolean isImportDataByRule = false;
        if (hsData.get("IsImportDataByRule") != null) {
            isImportDataByRule = (Boolean)hsData.get("IsImportDataByRule");
        }
        data = this.getData(hsData, "FRecType");
        ReceivingBillTypeInfo recTypeInfo = null;
        if (data != null && data.toString().trim().length() > 0) {
            recTypeInfo = this.importCache.getReceivingTypeInfoByCache(ctx, hsData, "FRecType");
        }
        data = this.getData(hsData, "FPaymentTypeID");
        PaymentTypeInfo paymentType = null;
        if (data == null || data.toString().trim().length() <= 0) throw new TaskExternalException(ResourceBase.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"33_ArApPaymentBillDataImport", (Locale)ctx.getLocale()));
        try {
            paymentType = this.importCache.getPaymentTypeInfoByCache(ctx, hsData, "FPaymentTypeID");
        }
        catch (BOSException e) {
            throw new TaskExternalException(ResourceBase.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"33_ArApPaymentBillDataImport", (Locale)ctx.getLocale()));
        }
        if (null != recTypeInfo && (recTypeInfo.isPreRec() || recTypeInfo.isProxyRec()) && null != paymentType && !"91f078d7-fb90-4827-83e2-3538237b67a06BCA0AB5".equals(paymentType.getId().toString())) {
            throw new TaskExternalException(ResourceBase.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"576_PaymentType_CREDIT_SALE", (Locale)ctx.getLocale()));
        }
        if (null != recTypeInfo && recTypeInfo.isSaleRec() && null != paymentType && !"91f078d7-fb90-4827-83e2-3538237b67a06BCA0AB5".equals(paymentType.getId().toString()) && !"cd54aa9f-03a4-459c-9c5a-5489dce5f0676BCA0AB5".equals(paymentType.getId().toString())) {
            throw new TaskExternalException(ResourceBase.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"578_PaymentType_CREDIT_CURRENCY_SALE", (Locale)ctx.getLocale()));
        }
        info.setPaymentType(paymentType);
        data = this.getData(hsData, "FNumber");
        if (data != null && data.toString().trim().length() > 0) {
            info.setNumber(data.toString());
        } else if (!isImportDataByRule) {
            throw new TaskExternalException(ResourceBase.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"36_ArApPaymentBillDataImport", (Locale)ctx.getLocale()));
        }
        data = this.getData(hsData, "FBizDate");
        if (data != null && data.toString().trim().length() > 0) {
            info.setBizDate(RecAndPayDataImportUtil.objToDate(ctx, data));
        }
        if ((data = this.getData(hsData, "FCurrencyID")) != null && data.toString().trim().length() > 0) {
            info.setCurrency(this.importCache.getCurrencyInfoByCache(ctx, hsData, "FCurrencyID"));
        } else {
            CompanyOrgUnitInfo company = ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentCompany();
            try {
                info.setCurrency(ContextHelperFactory.getRemoteInstance().getCompanyBaseCurrency(company));
            }
            catch (Exception e) {
                throw new TaskExternalException(EASResource.getString((String)Arap_RecPayDataImport, (String)"Error_LocalAmt"));
            }
        }
        data = this.getData(hsData, "FExchangeRate");
        if (data != null && data.toString().trim().length() > 0) {
            info.setExchangeRate(TypeConversionUtils.objToBigDecimal((Object)data));
        }
        if (recTypeInfo != null) {
            if (!recTypeInfo.isIsSaleRec()) {
                String cash = EASResource.getString((String)"com.kingdee.eas.fi.ar.ArApBillResource", (String)"cashrec");
                if (info.getPaymentType().toString().equals(cash)) {
                    throw new TaskExternalException(ResourceBase.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"46_ArApReceivingBillDataImport", (Locale)ctx.getLocale()));
                }
            }
            info.setRecBillType(recTypeInfo);
        }
        if ((data = this.getData(hsData, "FPayeeAccountBankID")) != null && data.toString().trim().length() > 0) {
            AccountBankInfo accountBank = RecAndPayDataImportUtil.getAccountBankByNumber(ctx, ResourceBase.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"47_ArApReceivingBillDataImport", (Locale)ctx.getLocale()), info.getCompany().getId().toString(), data.toString());
            if (accountBank == null) throw new TaskExternalException(this.getResourceString(ctx, "508_getRecAccountError", new String[]{data.toString()}));
            if (!accountBank.getCompany().getId().toString().equals(info.getCompany().getId().toString())) {
                throw new TaskExternalException(this.getResourceString(ctx, "505_RecAccountNotIncloudCompany"));
            }
            if (accountBank.isIsClosed()) {
                throw new TaskExternalException(this.getResourceString(ctx, "506_RecAccountHasCloused"));
            }
            if (accountBank != null && accountBank.isIsByCurrency()) {
                CurrencyInfo currency = accountBank.getCurrency();
                if (!info.getCurrency().getId().equals((Object)currency.getId())) {
                    throw new TaskExternalException(this.getResourceString(ctx, "507_RecAccountCurrencyNotEquesCurrency"));
                }
            }
            info.setPayeeAccountBank(accountBank);
            info.setPayeeBank(info.getPayeeAccountBank().getBank());
        }
        AccountBankInfo payeeAccountBank = info.getPayeeAccountBank();
        data = this.getData(hsData, "FPayeeAccountID");
        if (data != null && data.toString().trim().length() > 0) {
            info.setPayeeAccount(this.importCache.getRecPayAccountViewInfoByCache(ctx, hsData, info.getCompany().getId().toString(), info.getCurrency().getId().toString(), ResourceBase.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"48_ArApReceivingBillDataImport", (Locale)ctx.getLocale()), "FPayeeAccountID"));
        }
        if ((data = this.getData(hsData, "FSettlementTypeID")) != null && data.toString().trim().length() > 0 && (settleInfo = this.importCache.getSettlementTypeInfoByCache(ctx, hsData, "FSettlementTypeID")) != null) {
            info.setSettlementType(settleInfo);
        }
        if ((data = this.getData(hsData, "FSettlementNumber")) != null && data.toString().trim().length() > 0) {
            info.setSettlementNumber(data.toString());
        }
        if ((data = this.getData(hsData, "FOppAccountID")) != null && data.toString().trim().length() > 0) {
            info.setOppAccount(this.importCache.getRecPayAccountViewInfoByCache(ctx, hsData, info.getCompany().getId().toString(), info.getCurrency().getId().toString(), ResourceBase.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"20_AgentPayBillDataImport", (Locale)ctx.getLocale()), "FOppAccountID"));
        }
        if ((data = this.getData(hsData, "FDescription")) != null && data.toString().trim().length() > 0) {
            info.setDescription(data.toString());
        }
        if ((data = this.getData(hsData, "FPayerTypeID")) == null || data.toString().trim().length() <= 0) {
            throw new TaskExternalException(ResourceBase.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"49_ArApReceivingBillDataImport", (Locale)ctx.getLocale()));
        }
        info.setPayerType(this.importCache.getAsstActTypeInfoByCache(ctx, hsData, "FPayerTypeID"));
        data = this.getData(hsData, "FPayerNumber");
        if (data == null || data.toString().trim().length() <= 0) throw new TaskExternalException(ResourceBase.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"50_ArApReceivingBillDataImport", (Locale)ctx.getLocale()));
        IRowSet asstActInfo = null;
        String tableName = info.getPayerType().getRealtionDataObject();
        if ("T_BD_GeneralAsstActType".equals(tableName)) {
            String asstActTypeGroupId = info.getPayerType().getGlAsstActTypeGrp() != null ? info.getPayerType().getGlAsstActTypeGrp().getId().toString() : null;
            asstActInfo = RecAndPayDataImportUtil.getAsstActByNumberAndAsstActTypeID(ctx, tableName, data.toString(), asstActTypeGroupId);
        } else {
            asstActInfo = RecAndPayDataImportUtil.getAsstActInfo(info.getPayerType(), data.toString(), ctx);
        }
        try {
            if (asstActInfo.next()) {
                info.setPayerID(asstActInfo.getString("fid"));
                info.setPayerNumber(asstActInfo.getString("fnumber"));
                info.setPayerName(asstActInfo.getString("fname"));
            }
        }
        catch (SQLException e) {
            throw new TaskExternalException(e.getMessage());
        }
        data = this.getData(hsData, "FPayerBank");
        if (data != null && data.toString().trim().length() > 0) {
            info.setPayerBank(data.toString());
        }
        if ((data = this.getData(hsData, "FPayerAccountBank")) != null && data.toString().trim().length() > 0) {
            info.setPayerAccountBank(data.toString());
        }
        if ((data = this.getData(hsData, "FAdminOrgUnit")) != null && data.toString().trim().length() > 0) {
            info.setAdminOrgUnit(this.importCache.getAdminOrgUnitInfoByCache(ctx, hsData, "FAdminOrgUnit"));
        }
        if ((data = this.getData(hsData, "FPerson")) != null && data.toString().trim().length() > 0) {
            info.setPerson(this.importCache.getPersonInfoByCache(ctx, hsData, "FPerson"));
        }
        info.setIsInitializeBill(false);
        info.setIsImport(true);
        info.setBillStatus(BillStatusEnum.SAVE);
        info.setSourceType(SourceTypeEnum.AR);
        info.setSourceSysType(SourceTypeEnum.AR);
        info.setIsRelateReceipt(false);
    }

    private boolean isExistHead(Hashtable hsData, Context ctx, CompanyOrgUnitInfo company) throws TaskExternalException {
        String number = (String)this.getData(hsData, "FNumber");
        if (this.infoMap.containsKey(this.curKey)) {
            return false;
        }
        if (company == null || number == null) {
            return true;
        }
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo fi = new FilterInfo();
        fi.getFilterItems().add(new FilterItemInfo("number", (Object)number));
        fi.getFilterItems().add(new FilterItemInfo("company.number", (Object)company.getNumber()));
        view.setFilter(fi);
        try {
            ReceivingBillCollection coll = ReceivingBillFactory.getLocalInstance(ctx).getReceivingBillCollection(view);
            if (coll != null && coll.size() > 0) {
                throw new TaskExternalException(number + ResourceBase.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"22_AgentPayBillDataImport", (Locale)ctx.getLocale()));
            }
            return false;
        }
        catch (BOSException e) {
            throw new TaskExternalException(ResourceBase.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"51_ArApReceivingBillDataImport", (Locale)ctx.getLocale()) + e.getMessage());
        }
    }

    public void submitHead(CoreBaseInfo coreBaseInfo, Context ctx) throws TaskExternalException {
        try {
            IObjectPK pk = ReceivingBillFactory.getLocalInstance(ctx).save(coreBaseInfo);
            coreBaseInfo.setId(BOSUuid.read((String)pk.toString()));
        }
        catch (Exception e) {
            throw new TaskExternalException(e.getMessage());
        }
    }

    private CoreBaseInfo parseEntry(Hashtable hsData, Context ctx, CompanyOrgUnitInfo curCompany, CurrencyInfo currency) throws TaskExternalException {
        ReceivingBillTypeInfo recTypeInfo;
        ReceivingBillEntryInfo info = new ReceivingBillEntryInfo();
        Object data = null;
        data = this.getData(hsData, "FSeq");
        try {
            if (data != null && data.toString().trim().length() > 0) {
                info.setSeq(TypeConversionUtils.objToInt((Object)data));
            }
        }
        catch (IllegalConversionException e) {
            throw new TaskExternalException(ResourceBase.getString((String)"com.kingdee.eas.fi.cas.CASAutoResource", (String)"68_ArApPaymentBillDataImport", (Locale)ctx.getLocale()));
        }
        info.setReceivingBill(RecAndPayDataImportUtil.getReceivingBillByNumber(hsData, ctx));
        data = this.getData(hsData, "FEntryRecType");
        if (data != null && data.toString().trim().length() > 0 && (recTypeInfo = this.importCache.getReceivingTypeInfoByCache(ctx, hsData, "FEntryRecType")) != null) {
            info.setRecBillType(recTypeInfo);
        }
        try {
            data = this.getData(hsData, "Famount");
            if (data != null && data.toString().trim().length() > 0) {
                info.setAmount(RecAndPayDataImportUtil.objToBigDecimal(ctx, data));
            }
            if ((data = this.getData(hsData, "FLocalAount")) != null && data.toString().trim().length() > 0) {
                info.setLocalAmt(RecAndPayDataImportUtil.objToBigDecimal(ctx, data));
            }
            if ((data = this.getData(hsData, "Frebate")) != null && data.toString().trim().length() > 0) {
                info.setRebate(RecAndPayDataImportUtil.objToBigDecimal(ctx, data));
            }
            if ((data = this.getData(hsData, "FRebateLocAmt")) != null && data.toString().trim().length() > 0) {
                info.setRebateLocAmt(RecAndPayDataImportUtil.objToBigDecimal(ctx, data));
            }
            if ((data = this.getData(hsData, "FActualAmt")) != null && data.toString().trim().length() > 0) {
                info.setActualAmt(RecAndPayDataImportUtil.objToBigDecimal(ctx, data));
            }
            if ((data = this.getData(hsData, "FActualLocAmt")) != null && data.toString().trim().length() > 0) {
                info.setActualLocAmt(RecAndPayDataImportUtil.objToBigDecimal(ctx, data));
            }
            if ((data = this.getData(hsData, "FEntries_commission")) != null && data.toString().trim().length() > 0) {
                info.setCommission(RecAndPayDataImportUtil.objToBigDecimal(ctx, data));
            }
            if ((data = this.getData(hsData, "FEntries_commissionLocAmt")) != null && data.toString().trim().length() > 0) {
                info.setCommissionLocAmt(RecAndPayDataImportUtil.objToBigDecimal(ctx, data));
            }
        }
        catch (IllegalConversionException e) {
            throw new TaskExternalException(ResourceBase.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"42_ArApPaymentBillDataImport", (Locale)ctx.getLocale()));
        }
        data = this.getData(hsData, "FRemark");
        if (data != null && data.toString().trim().length() > 0) {
            info.setRemark(data.toString());
        }
        if ((data = this.getData(hsData, "FEntryOppAccountID")) != null && data.toString().trim().length() > 0) {
            info.setOppAccount(this.importCache.getRecPayAccountViewInfoByCache(ctx, hsData, curCompany.getId().toString(), currency.getId().toString(), ResourceBase.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"20_AgentPayBillDataImport", (Locale)ctx.getLocale()), "FEntryOppAccountID"));
        }
        try {
            info.setCoreBillType(RecAndPayDataImportUtil.getBillType(ctx, hsData, "FCoreBillType"));
        }
        catch (Exception e) {
            throw new TaskExternalException(ResourceBase.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"43_ArApPaymentBillDataImport", (Locale)ctx.getLocale()));
        }
        try {
            info.setCoreBillNumber(RecAndPayDataImportUtil.getDataString(hsData, "FCoreBillNum"));
        }
        catch (Exception e) {
            throw new TaskExternalException(ResourceBase.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"44_ArApPaymentBillDataImport", (Locale)ctx.getLocale()));
        }
        try {
            info.setCoreBillEntrySeq(RecAndPayDataImportUtil.getDataInt(hsData, "FCoreBillSeq"));
        }
        catch (Exception e) {
            throw new TaskExternalException(ResourceBase.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"45_ArApPaymentBillDataImport", (Locale)ctx.getLocale()));
        }
        return info;
    }

    private Object getData(Hashtable hsData, String fieldName) {
        Object data = null;
        if (hsData.get(fieldName) != null) {
            data = ((DataToken)hsData.get((Object)fieldName)).data;
        }
        return data;
    }

    public boolean isSameBlock(Hashtable firstData, Hashtable currentData) {
        return RecAndPayDataImportUtil.isSameBlock(firstData, currentData, this.getMainFields());
    }

    public String[] getMainFields() {
        return new String[]{"FNumber", "FCompanyID"};
    }

    public void submit(CoreBaseInfo coreBaseInfo, Context ctx) throws TaskExternalException {
        if (coreBaseInfo == null) {
            return;
        }
        try {
            ReceivingBillInfo info = (ReceivingBillInfo)coreBaseInfo;
            info.getEntries().sort("seq");
            IObjectPK pk = this.getController(ctx).save(coreBaseInfo);
            if (coreBaseInfo != null && coreBaseInfo.getId() != null) {
                coreBaseInfo.setId(BOSUuid.read((String)pk.toString()));
            }
        }
        catch (Exception e) {
            logger.error((Object)e);
            throw new TaskExternalException(e.getMessage(), e.getCause());
        }
    }

    public int getSubmitType() {
        return 1;
    }

    public Hashtable exportTransmit(IRowSet rs, Context ctx) throws TaskExternalException {
        Hashtable result = null;
        try {
            result = new Hashtable();
            this.putTable(result, "FNumber", rs.getString("number"));
            this.putTable(result, "FCompanyID", rs.getString("company.number"));
            this.putTable(result, "FBizDate", rs.getString("bizDate"));
            this.putTable(result, "FRecType", rs.getString("recBillType.number"));
            this.putTable(result, "FPaymentTypeID", rs.getString("paymentType.number"));
            this.putTable(result, "FCurrencyID", rs.getString("currency.number"));
            this.putTable(result, "FExchangeRate", rs.getString("exchangeRate"));
            this.putTable(result, "FPayeeAccountBankID", rs.getString("payeeAccountBank.number"));
            this.putTable(result, "FPayeeBankID", rs.getString("payeeBank.number"));
            this.putTable(result, "FPayeeAccountID", rs.getString("payeeAccount.number"));
            this.putTable(result, "FSettlementTypeID", rs.getString("settlementType.number"));
            this.putTable(result, "FSettlementNumber", rs.getString("settlementNumber"));
            this.putTable(result, "FOppAccountID", rs.getString("oppAccount.number"));
            this.putTable(result, "FPayerTypeID", rs.getString("payerType.number"));
            this.putTable(result, "FPayerNumber", rs.getString("payerNumber"));
            this.putTable(result, "FPayerBank", rs.getString("payerBank"));
            this.putTable(result, "FPayerAccountBank", rs.getString("payerAccountBank"));
            this.putTable(result, "FAdminOrgUnit", rs.getString("adminOrgUnit.number"));
            this.putTable(result, "FPerson", rs.getString("person.number"));
            this.putTable(result, "FDescription", rs.getString("description"));
            this.putTable(result, "FSeq", rs.getString("entries.seq"));
            this.putTable(result, "FEntryRecType", rs.getString("entryRecBillType.number"));
            this.putTable(result, "Famount", rs.getString("entries.amount"));
            this.putTable(result, "FLocalAount", rs.getString("entries.localAmt"));
            this.putTable(result, "Frebate", rs.getString("entries.rebate"));
            this.putTable(result, "FRebateLocAmt", rs.getString("entries.rebateLocAmt"));
            this.putTable(result, "FActualAmt", rs.getString("entries.actualAmt"));
            this.putTable(result, "FActualLocAmt", rs.getString("entries.actualLocAmt"));
            this.putTable(result, "FCoreBillType", rs.getString("coreBillType.number"));
            this.putTable(result, "FCoreBillNum", rs.getString("entries.coreBillNumber"));
            this.putTable(result, "FCoreBillSeq", rs.getString("entries.coreBillEntrySeq"));
            this.putTable(result, "FRemark", rs.getString("entries.remark"));
            this.putTable(result, "FEntryOppAccountID", rs.getString("entryOppAccount.number"));
        }
        catch (Exception e) {
            throw new TaskExternalException(e.getMessage());
        }
        return result;
    }

    private void putTable(Hashtable htable, Object key, Object value) {
        DataImportTools.putToHashtable((Hashtable)htable, (Object)key, (Object)value);
    }

    private String getResourceString(Context ctx, String key) {
        return ResourceBase.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)key, (Locale)ctx.getLocale());
    }

    private String getResourceString(Context ctx, String key, Object[] params) {
        return MessageFormat.format(ResourceBase.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)key, (Locale)ctx.getLocale()), params);
    }
}

