/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.cas.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.json.JSONUtils;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.service.ServiceStateManager;
import com.kingdee.eas.base.core.util.DateUtil;
import com.kingdee.eas.base.netctrl.IMutexServiceControl;
import com.kingdee.eas.base.netctrl.MutexServiceControlFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.cas.AutoGenRuleException;
import com.kingdee.eas.fi.cas.AutoGenRuleForPayBillFactory;
import com.kingdee.eas.fi.cas.AutoGenRuleForPayBillInfo;
import com.kingdee.eas.fi.cas.CasWebException;
import com.kingdee.eas.fi.cas.EnableStatusEnum;
import com.kingdee.eas.fi.cas.IAutoGenRuleForPayBill;
import com.kingdee.eas.fi.cas.app.AbstractAutoGenRuleForPayBillControllerBean;
import com.kingdee.eas.fi.cas.model.BatchExecuteResult;
import com.kingdee.eas.fi.cas.utils.CASWebUtil;
import com.kingdee.eas.fi.cas.vo.AutoGenRuleForPayBillVO;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.app.DbUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.Map;
import org.apache.log4j.Logger;

public class AutoGenRuleForPayBillControllerBean
extends AbstractAutoGenRuleForPayBillControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fi.cas.app.AutoGenRuleForPayBillControllerBean");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected IObjectPK _save(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        IMutexServiceControl iMutex = MutexServiceControlFactory.getLocalInstance((Context)ctx);
        AutoGenRuleForPayBillInfo info = (AutoGenRuleForPayBillInfo)model;
        String id = null;
        if (info.getId() != null) {
            id = info.getId().toString();
        }
        boolean isCanUpdate = false;
        IObjectPK idAfterSave = null;
        if (id != null && !(isCanUpdate = iMutex.requestObjIDForUpdate(id))) {
            throw new AutoGenRuleException(AutoGenRuleException.BFS_RULEISRUNNINGCANNOTSAVE);
        }
        try {
            if (info.getUser() == null || info.getUser().getId() == null) {
                UserInfo user = (UserInfo)ctx.get((Object)"UserInfo");
                info.setUser(user);
            }
            idAfterSave = this.saveAutoGenerateRule(ctx, (AutoGenRuleForPayBillInfo)model);
        }
        finally {
            if (id != null) {
                iMutex.releaseObjIDForUpdate(id);
            }
        }
        return idAfterSave;
    }

    private IObjectPK saveAutoGenerateRule(Context ctx, AutoGenRuleForPayBillInfo model) throws EASBizException, BOSException {
        AutoGenRuleForPayBillInfo coreBaseInfo = model;
        if (this._isExistPropertyName(ctx, (CoreBaseInfo)coreBaseInfo, "effectedStatus")) {
            coreBaseInfo.setInt("effectedStatus", 1);
        }
        ServiceStateManager.getInstance().enableNextCallServices();
        if (coreBaseInfo.getId() != null && this._exists(ctx, (IObjectPK)new ObjectUuidPK(coreBaseInfo.getId()))) {
            ObjectUuidPK retValue = new ObjectUuidPK(coreBaseInfo.getId());
            super.update(ctx, (IObjectPK)retValue, (CoreBaseInfo)coreBaseInfo);
            return retValue;
        }
        this.duplicateCheck(ctx, model);
        IObjectPK retValue = super.addnew(ctx, (CoreBaseInfo)coreBaseInfo);
        return retValue;
    }

    private void duplicateCheck(Context ctx, AutoGenRuleForPayBillInfo info) throws BOSException, EASBizException {
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("ruleNumber", (Object)info.getRuleNumber()));
        if (this.exists(ctx, filter)) {
            throw new AutoGenRuleException(AutoGenRuleException.BFS_NUMBERDUPLI);
        }
        filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("name", (Object)info.getName()));
        if (this.exists(ctx, filter)) {
            throw new AutoGenRuleException(AutoGenRuleException.BFS_NAMEDUPLI);
        }
        filter = new FilterInfo();
        if (info.getAccountBank() != null) {
            filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)info.getCompany().getId().toString()));
            filter.getFilterItems().add(new FilterItemInfo("accountBank.id", (Object)info.getAccountBank().getId().toString()));
            if (this.exists(ctx, filter)) {
                throw new AutoGenRuleException(AutoGenRuleException.BFS_CHECKDUPLICOMANDACCT);
            }
        }
    }

    @Override
    protected Map _deleteAutoGenerateRule(Context ctx, String jsonstr) throws BOSException, EASBizException {
        BatchExecuteResult result = new BatchExecuteResult();
        AutoGenRuleForPayBillVO dataVO = (AutoGenRuleForPayBillVO)JSONUtils.convertJsonToObject((Context)ctx, (String)jsonstr, AutoGenRuleForPayBillVO.class);
        IAutoGenRuleForPayBill iAutoGenerateRecRule = AutoGenRuleForPayBillFactory.getLocalInstance(ctx);
        ArrayList<ObjectUuidPK> PKList = new ArrayList<ObjectUuidPK>();
        for (String id : dataVO.getDeleteIDs()) {
            PKList.add(new ObjectUuidPK(id));
        }
        int sucDelCount = PKList.size();
        if (sucDelCount > 0) {
            ObjectUuidPK[] sucDelPKArray = new ObjectUuidPK[sucDelCount];
            for (int idx = 0; idx < sucDelCount; ++idx) {
                try {
                    sucDelPKArray[idx] = (IObjectPK)PKList.get(idx);
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            iAutoGenerateRecRule.deleteBatchData((IObjectPK[])sucDelPKArray);
        }
        result.setSummaryMsg(CASWebUtil.getResource(ctx, "555_DeletedOK"));
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Map _closeAutoGenerateRule(Context ctx, String jsonstr) throws BOSException, EASBizException {
        IMutexServiceControl iMutex = MutexServiceControlFactory.getLocalInstance((Context)ctx);
        BatchExecuteResult result = new BatchExecuteResult();
        String[] ids = jsonstr.split(",");
        boolean isCanUpdate = iMutex.requestObjIDForUpdate(ids[0]);
        AutoGenRuleForPayBillInfo info = AutoGenRuleForPayBillFactory.getLocalInstance(ctx).getAutoGenRuleForPayBillInfo((IObjectPK)new ObjectUuidPK(ids[0]));
        if (info.getIsStart().equals((Object)EnableStatusEnum.disable)) {
            throw new CasWebException(CasWebException.NO_CLOSE);
        }
        if (!isCanUpdate) {
            throw new CasWebException(CasWebException.BFS_RULEISRUNNINGCANNOTCLOSE);
        }
        ArrayList<String> idList = new ArrayList<String>();
        try {
            for (String id : ids) {
                idList.add(id);
            }
            int sucDelCount = idList.size();
            if (sucDelCount > 0) {
                String[] sucDelPKArray = new String[sucDelCount];
                for (int idx = 0; idx < sucDelCount; ++idx) {
                    try {
                        sucDelPKArray[idx] = (String)idList.get(idx);
                        continue;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                this.close(ctx, sucDelPKArray);
            }
            result.setSummaryMsg(CASWebUtil.getResource(ctx, "553_CloseOK"));
        }
        finally {
            iMutex.releaseObjIDForUpdate(ids[0]);
        }
        return result;
    }

    public void close(Context ctx, String[] ids) throws BOSException, EASBizException {
        String bizDate = DateUtil.getSQLBegin((Date)new Date()).toString();
        StringBuffer sqlBuffer = new StringBuffer("update T_CAS_AutoGenRuleForPayBill set FIsStart = 0,FEndDate = {d'");
        sqlBuffer.append(bizDate).append("'}");
        sqlBuffer.append(" where FID in (");
        for (String id : ids) {
            sqlBuffer.append("'" + id + "',");
        }
        String sql = sqlBuffer.substring(0, sqlBuffer.length() - 1);
        sql = sql + ")";
        DbUtil.execute((Context)ctx, (String)sql);
    }

    @Override
    protected Map _startAutoGenerateRule(Context ctx, String jsonstr) throws BOSException, EASBizException {
        BatchExecuteResult result = new BatchExecuteResult();
        String[] ids = jsonstr.split(",");
        AutoGenRuleForPayBillInfo info = AutoGenRuleForPayBillFactory.getLocalInstance(ctx).getAutoGenRuleForPayBillInfo((IObjectPK)new ObjectUuidPK(ids[0]));
        if (info.getIsStart().equals((Object)EnableStatusEnum.enable)) {
            throw new CasWebException(CasWebException.NO_STRART);
        }
        ArrayList<String> idList = new ArrayList<String>();
        for (String id : ids) {
            idList.add(id);
        }
        int sucDelCount = idList.size();
        if (sucDelCount > 0) {
            String[] sucDelPKArray = new String[sucDelCount];
            for (int idx = 0; idx < sucDelCount; ++idx) {
                try {
                    sucDelPKArray[idx] = (String)idList.get(idx);
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            this.start(ctx, sucDelPKArray);
        }
        result.setSummaryMsg(CASWebUtil.getResource(ctx, "554_StartOK"));
        return result;
    }

    public void start(Context ctx, String[] ids) throws BOSException, EASBizException {
        StringBuffer sqlBuffer = new StringBuffer("update T_CAS_AutoGenRuleForPayBill set FIsStart = 1,FEndDate = null where FID in (");
        for (String id : ids) {
            sqlBuffer.append("'" + id + "',");
        }
        String sql = sqlBuffer.substring(0, sqlBuffer.length() - 1);
        sql = sql + ")";
        DbUtil.execute((Context)ctx, (String)sql);
    }
}

