/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.cas.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.json.JSONUtils;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.eas.base.netctrl.IMutexServiceControl;
import com.kingdee.eas.base.netctrl.MutexServiceControlFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.cas.AutoGenerateRecRuleFactory;
import com.kingdee.eas.fi.cas.AutoGenerateRecRuleInfo;
import com.kingdee.eas.fi.cas.IAutoGenerateRecRule;
import com.kingdee.eas.fi.cas.ReceivingCenterException;
import com.kingdee.eas.fi.cas.UnPaidBillCenterException;
import com.kingdee.eas.fi.cas.app.AbstractAutoGenerateRecRuleControllerBean;
import com.kingdee.eas.fi.cas.model.BatchExecuteResult;
import com.kingdee.eas.fi.cas.utils.CASWebUtil;
import com.kingdee.eas.fi.cas.vo.AutoGenerateRuleVO;
import com.kingdee.eas.util.app.DbUtil;
import java.util.ArrayList;
import java.util.Map;
import org.apache.log4j.Logger;

public class AutoGenerateRecRuleControllerBean
extends AbstractAutoGenerateRecRuleControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fi.cas.app.AutoGenerateRecRuleControllerBean");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected IObjectPK _save(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        IMutexServiceControl iMutex = MutexServiceControlFactory.getLocalInstance((Context)ctx);
        AutoGenerateRecRuleInfo info = (AutoGenerateRecRuleInfo)model;
        String id = null;
        if (info.getId() != null) {
            id = info.getId().toString();
        }
        boolean isCanUpdate = false;
        IObjectPK idAfterSave = null;
        if (id != null && !(isCanUpdate = iMutex.requestObjIDForUpdate(id))) {
            throw new UnPaidBillCenterException(UnPaidBillCenterException.BFS_RULEISRUNNINGCANNOTSAVE);
        }
        try {
            if (info.getUser() == null || info.getUser().getId() == null) {
                UserInfo user = (UserInfo)ctx.get((Object)"UserInfo");
                info.setUser(user);
            }
            this.duplicateCheck(ctx, info);
            idAfterSave = super._save(ctx, model);
        }
        finally {
            if (id != null) {
                iMutex.releaseObjIDForUpdate(id);
            }
        }
        return idAfterSave;
    }

    private void duplicateCheck(Context ctx, AutoGenerateRecRuleInfo info) throws BOSException, EASBizException {
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)info.getCompany().getId().toString()));
        if (this.exists(ctx, filter)) {
            throw new ReceivingCenterException(ReceivingCenterException.BFS_CHECKDUPLICATE);
        }
    }

    @Override
    protected Map _deleteAutoGenerateRule(Context ctx, String jsonstr) throws BOSException, EASBizException {
        BatchExecuteResult result = new BatchExecuteResult();
        AutoGenerateRuleVO dataVO = (AutoGenerateRuleVO)JSONUtils.convertJsonToObject((Context)ctx, (String)jsonstr, AutoGenerateRuleVO.class);
        IAutoGenerateRecRule iAutoGenerateRecRule = AutoGenerateRecRuleFactory.getLocalInstance(ctx);
        ArrayList<ObjectUuidPK> PKList = new ArrayList<ObjectUuidPK>();
        for (String id : dataVO.getDeleteIDs()) {
            PKList.add(new ObjectUuidPK(id));
        }
        int sucDelCount = PKList.size();
        if (sucDelCount > 0) {
            ObjectUuidPK[] sucDelPKArray = new ObjectUuidPK[sucDelCount];
            for (int idx = 0; idx < sucDelCount; ++idx) {
                try {
                    sucDelPKArray[idx] = (IObjectPK)PKList.get(idx);
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            iAutoGenerateRecRule.deleteBatchData((IObjectPK[])sucDelPKArray);
        }
        result.setSummaryMsg(CASWebUtil.getResource(ctx, "DeletedOK"));
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Map _closeAutoGenerateRule(Context ctx, String jsonstr) throws BOSException, EASBizException {
        IMutexServiceControl iMutex = MutexServiceControlFactory.getLocalInstance((Context)ctx);
        BatchExecuteResult result = new BatchExecuteResult();
        String[] ids = jsonstr.split(",");
        boolean isCanUpdate = iMutex.requestObjIDForUpdate(ids[0]);
        if (!isCanUpdate) {
            throw new UnPaidBillCenterException(UnPaidBillCenterException.BFS_RULEISRUNNINGCANNOTCLOSE);
        }
        ArrayList<String> idList = new ArrayList<String>();
        try {
            for (String id : ids) {
                idList.add(id);
            }
            int sucDelCount = idList.size();
            if (sucDelCount > 0) {
                String[] sucDelPKArray = new String[sucDelCount];
                for (int idx = 0; idx < sucDelCount; ++idx) {
                    try {
                        sucDelPKArray[idx] = (String)idList.get(idx);
                        continue;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                this.close(ctx, sucDelPKArray);
            }
            result.setSummaryMsg(CASWebUtil.getResource(ctx, "509_CloseOK"));
        }
        finally {
            iMutex.releaseObjIDForUpdate(ids[0]);
        }
        return result;
    }

    public void close(Context ctx, String[] ids) throws BOSException, EASBizException {
        StringBuffer sqlBuffer = new StringBuffer("update T_CAS_AutoGenerateRecRule set FIsStart = 0 where FID in (");
        for (String id : ids) {
            sqlBuffer.append("'" + id + "',");
        }
        String sql = sqlBuffer.substring(0, sqlBuffer.length() - 1);
        sql = sql + ")";
        DbUtil.execute((Context)ctx, (String)sql);
    }

    @Override
    protected Map _startAutoGenerateRule(Context ctx, String jsonstr) throws BOSException, EASBizException {
        BatchExecuteResult result = new BatchExecuteResult();
        String[] ids = jsonstr.split(",");
        ArrayList<String> idList = new ArrayList<String>();
        for (String id : ids) {
            idList.add(id);
        }
        int sucDelCount = idList.size();
        if (sucDelCount > 0) {
            String[] sucDelPKArray = new String[sucDelCount];
            for (int idx = 0; idx < sucDelCount; ++idx) {
                try {
                    sucDelPKArray[idx] = (String)idList.get(idx);
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            this.start(ctx, sucDelPKArray);
        }
        result.setSummaryMsg(CASWebUtil.getResource(ctx, "508_StartOK"));
        return result;
    }

    public void start(Context ctx, String[] ids) throws BOSException, EASBizException {
        StringBuffer sqlBuffer = new StringBuffer("update T_CAS_AutoGenerateRecRule set FIsStart = 1 where FID in (");
        for (String id : ids) {
            sqlBuffer.append("'" + id + "',");
        }
        String sql = sqlBuffer.substring(0, sqlBuffer.length() - 1);
        sql = sql + ")";
        DbUtil.execute((Context)ctx, (String)sql);
    }
}

