/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.cas.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.json.JSONUtils;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.base.netctrl.IMutexServiceControl;
import com.kingdee.eas.base.netctrl.MutexServiceControlFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.cas.AutoGenerateRuleFactory;
import com.kingdee.eas.fi.cas.AutoGenerateRuleInfo;
import com.kingdee.eas.fi.cas.FilterTypeEnum;
import com.kingdee.eas.fi.cas.IAutoGenerateRule;
import com.kingdee.eas.fi.cas.UnPaidBillCenterException;
import com.kingdee.eas.fi.cas.app.AbstractAutoGenerateRuleControllerBean;
import com.kingdee.eas.fi.cas.model.BatchExecuteResult;
import com.kingdee.eas.fi.cas.utils.CASWebUtil;
import com.kingdee.eas.fi.cas.vo.AutoGenerateRuleVO;
import com.kingdee.eas.util.app.DbUtil;
import java.util.ArrayList;
import java.util.Map;
import org.apache.log4j.Logger;

public class AutoGenerateRuleControllerBean
extends AbstractAutoGenerateRuleControllerBean {
    private static final long serialVersionUID = 1L;
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fi.cas.app.AutoGenerateRuleControllerBean");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected IObjectPK _save(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        IMutexServiceControl iMutex = MutexServiceControlFactory.getLocalInstance((Context)ctx);
        AutoGenerateRuleInfo info = (AutoGenerateRuleInfo)model;
        String id = null;
        if (info.getId() != null) {
            id = info.getId().toString();
        }
        boolean isCanUpdate = false;
        IObjectPK idAfterSave = null;
        if (id != null && !(isCanUpdate = iMutex.requestObjIDForUpdate(id))) {
            throw new UnPaidBillCenterException(UnPaidBillCenterException.BFS_RULEISRUNNINGCANNOTSAVE);
        }
        try {
            if (info.getUser() == null || info.getUser().getId() == null) {
                UserInfo user = (UserInfo)ctx.get((Object)"UserInfo");
                info.setUser(user);
            }
            this.checkFilter(ctx, info);
            idAfterSave = super._save(ctx, model);
        }
        finally {
            if (id != null) {
                iMutex.releaseObjIDForUpdate(id);
            }
        }
        return idAfterSave;
    }

    private void checkFilter(Context ctx, AutoGenerateRuleInfo info) throws BOSException, EASBizException {
        if (info.getCompany() == null || info.getCompany().getId() == null || info.getSubSystem() == null || info.getBillType() == null || info.getBillType().getId() == null || info.getFilterType() == null) {
            throw new UnPaidBillCenterException(UnPaidBillCenterException.BFS_CHECKEMPTY);
        }
        if (info.getFilterType().equals((Object)FilterTypeEnum.PAID_PART) && (info.getFilter() == null || info.getFilter().trim().length() == 0 || info.getFilter().trim().equals("()"))) {
            throw new UnPaidBillCenterException(UnPaidBillCenterException.BFS_CHECKFILTER);
        }
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)info.getCompany().getId().toString()));
        filter.getFilterItems().add(new FilterItemInfo("subSystem", (Object)new Integer(info.getSubSystem().getValue())));
        filter.getFilterItems().add(new FilterItemInfo("billType.id", (Object)info.getBillType().getId().toString()));
        filter.getFilterItems().add(new FilterItemInfo("user.id", (Object)info.getUser().getId().toString()));
        if (info.getId() != null) {
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)info.getId().toString(), CompareType.NOTEQUALS));
        }
        if (this.exists(ctx, filter)) {
            throw new UnPaidBillCenterException(UnPaidBillCenterException.BFS_CHECKDUPLICATE);
        }
        FilterInfo apfilter = new FilterInfo();
        if (info.getBillType().getBosObjectType().equals("48DA3A71") || info.getBillType().getBosObjectType().toString().equals("D001019A")) {
            apfilter.getFilterItems().add(new FilterItemInfo("company.id", (Object)info.getCompany().getId().toString()));
            if (info.getId() != null) {
                apfilter.getFilterItems().add(new FilterItemInfo("id", (Object)info.getId().toString(), CompareType.NOTEQUALS));
            }
            if (info.getBillType().getBosObjectType().toString().equals("48DA3A71")) {
                apfilter.getFilterItems().add(new FilterItemInfo("billType.bosObjectType", (Object)"D001019A"));
                if (this.exists(ctx, apfilter)) {
                    throw new UnPaidBillCenterException(UnPaidBillCenterException.BFS_CHECKAPPRDUPLICATE, new String[]{info.getCompany().getName()});
                }
            } else {
                apfilter.getFilterItems().add(new FilterItemInfo("billType.bosObjectType", (Object)"48DA3A71"));
                if (this.exists(ctx, apfilter)) {
                    throw new UnPaidBillCenterException(UnPaidBillCenterException.BFS_CHECKAPOBDUPLICATE, new String[]{info.getCompany().getName()});
                }
            }
        }
    }

    @Override
    protected Map _deleteAutoGenerateRule(Context ctx, String jsonstr) throws BOSException, EASBizException {
        BatchExecuteResult result = new BatchExecuteResult();
        AutoGenerateRuleVO dataVO = (AutoGenerateRuleVO)JSONUtils.convertJsonToObject((Context)ctx, (String)jsonstr, AutoGenerateRuleVO.class);
        IAutoGenerateRule iAutoGenerateRule = AutoGenerateRuleFactory.getLocalInstance(ctx);
        StringBuffer errorMsg = new StringBuffer();
        ArrayList errorMsgList = new ArrayList();
        ArrayList<ObjectUuidPK> PKList = new ArrayList<ObjectUuidPK>();
        for (String id : dataVO.getDeleteIDs()) {
            PKList.add(new ObjectUuidPK(id));
        }
        int sucDelCount = PKList.size();
        if (sucDelCount > 0) {
            ObjectUuidPK[] sucDelPKArray = new ObjectUuidPK[sucDelCount];
            for (int idx = 0; idx < sucDelCount; ++idx) {
                try {
                    sucDelPKArray[idx] = (IObjectPK)PKList.get(idx);
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            iAutoGenerateRule.deleteBatchData((IObjectPK[])sucDelPKArray);
        }
        result.setSummaryMsg(CASWebUtil.getResource(ctx, "DeletedOK"));
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Map _closeAutoGenerateRule(Context ctx, String jsonstr) throws BOSException, EASBizException {
        IMutexServiceControl iMutex = MutexServiceControlFactory.getLocalInstance((Context)ctx);
        BatchExecuteResult result = new BatchExecuteResult();
        String[] ids = jsonstr.split(",");
        boolean isCanUpdate = iMutex.requestObjIDForUpdate(ids[0]);
        if (!isCanUpdate) {
            throw new UnPaidBillCenterException(UnPaidBillCenterException.BFS_RULEISRUNNINGCANNOTCLOSE);
        }
        ArrayList<String> idList = new ArrayList<String>();
        StringBuffer errorMsg = new StringBuffer();
        ArrayList errorMsgList = new ArrayList();
        try {
            for (String id : ids) {
                idList.add(id);
            }
            int sucDelCount = idList.size();
            if (sucDelCount > 0) {
                String[] sucDelPKArray = new String[sucDelCount];
                for (int idx = 0; idx < sucDelCount; ++idx) {
                    try {
                        sucDelPKArray[idx] = (String)idList.get(idx);
                        continue;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                this.close(ctx, sucDelPKArray);
            }
            result.setSummaryMsg(CASWebUtil.getResource(ctx, "509_CloseOK"));
        }
        finally {
            iMutex.releaseObjIDForUpdate(ids[0]);
        }
        return result;
    }

    public void close(Context ctx, String[] ids) throws BOSException, EASBizException {
        StringBuffer sqlBuffer = new StringBuffer("update T_CAS_AutoGenerateRule set FIsStart = 0 where FID in (");
        for (String id : ids) {
            sqlBuffer.append("'" + id + "',");
        }
        String sql = sqlBuffer.substring(0, sqlBuffer.length() - 1);
        sql = sql + ")";
        DbUtil.execute((Context)ctx, (String)sql);
    }

    @Override
    protected Map _startAutoGenerateRule(Context ctx, String jsonstr) throws BOSException, EASBizException {
        BatchExecuteResult result = new BatchExecuteResult();
        String[] ids = jsonstr.split(",");
        ArrayList<String> idList = new ArrayList<String>();
        StringBuffer errorMsg = new StringBuffer();
        ArrayList errorMsgList = new ArrayList();
        for (String id : ids) {
            idList.add(id);
        }
        int sucDelCount = idList.size();
        if (sucDelCount > 0) {
            String[] sucDelPKArray = new String[sucDelCount];
            for (int idx = 0; idx < sucDelCount; ++idx) {
                try {
                    sucDelPKArray[idx] = (String)idList.get(idx);
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            this.start(ctx, sucDelPKArray);
        }
        result.setSummaryMsg(CASWebUtil.getResource(ctx, "508_StartOK"));
        return result;
    }

    public void start(Context ctx, String[] ids) throws BOSException, EASBizException {
        StringBuffer sqlBuffer = new StringBuffer("update T_CAS_AutoGenerateRule set FIsStart = 1 where FID in (");
        for (String id : ids) {
            sqlBuffer.append("'" + id + "',");
        }
        String sql = sqlBuffer.substring(0, sqlBuffer.length() - 1);
        sql = sql + ")";
        DbUtil.execute((Context)ctx, (String)sql);
    }
}

