/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.cas.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.base.permission.UserFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.assistant.AccountBankCollection;
import com.kingdee.eas.basedata.assistant.AccountBankFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.cas.AbstractFMDataImport;
import com.kingdee.eas.fi.cas.AutoGenRuleForRecBillCollection;
import com.kingdee.eas.fi.cas.AutoGenRuleForRecBillFactory;
import com.kingdee.eas.fi.cas.AutoGenRuleForRecBillInfo;
import com.kingdee.eas.fi.cas.CashHelper;
import com.kingdee.eas.fi.cas.EnableStatusEnum;
import com.kingdee.eas.fi.cas.app.AutoExecOperType;
import com.kingdee.eas.fi.cas.app.RecAndPayDataImportUtil2;
import com.kingdee.eas.fi.cas.app.botp.CasBotpUtil;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.util.StringUtils;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Set;

public class AutoRuleForRecDataImport
extends AbstractFMDataImport {
    @Override
    protected ICoreBase _getController(Context ctx) throws EASBizException, BOSException {
        return AutoGenRuleForRecBillFactory.getLocalInstance(ctx);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected CoreBaseInfo _transmit(Hashtable hsData, Context ctx) throws EASBizException, BOSException {
        AutoGenRuleForRecBillInfo info = new AutoGenRuleForRecBillInfo();
        String companyNum = (String)this.getData(hsData, "FCompany_number");
        if (companyNum == null || companyNum.trim().length() <= 0) throw new BOSException(ResourceBase.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"496_AutoRuleImport", (Locale)ctx.getLocale()));
        Set companyIds = CashHelper.getCompanyIds(ctx, companyNum);
        if (companyIds == null || companyIds.size() <= 0) throw new BOSException(ResourceBase.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"497_AutoRuleImport", (Locale)ctx.getLocale()));
        CompanyOrgUnitInfo company = CasBotpUtil.getCompanyInfoById(ctx, companyIds.toArray()[0].toString());
        ObjectUuidPK companyPK = new ObjectUuidPK(company.getId().toString());
        ObjectUuidPK userPK = new ObjectUuidPK(ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentUser().getId());
        boolean hasFunctionPermission = PermissionFactory.getLocalInstance((Context)ctx).hasFunctionPermission((IObjectPK)userPK, (IObjectPK)companyPK, "cas_paymentbill_19autoRuleImport");
        if (!hasFunctionPermission) {
            throw new BOSException(ResourceBase.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"515_AutoRuleImport", (Locale)ctx.getLocale()));
        }
        info.setCompany(company);
        String number = (String)this.getData(hsData, "FRuleNumber");
        if (StringUtils.isEmpty((String)number)) throw new BOSException(ResourceBase.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"498_AutoRuleImport", (Locale)ctx.getLocale()));
        EntityViewInfo viewInfo = new EntityViewInfo();
        viewInfo.getSelector().add(new SelectorItemInfo("*"));
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("ruleNumber", (Object)number, CompareType.EQUALS));
        viewInfo.setFilter(filterInfo);
        AutoGenRuleForRecBillCollection ruleForRecBillCollection = AutoGenRuleForRecBillFactory.getLocalInstance(ctx).getAutoGenRuleForRecBillCollection(viewInfo);
        if (ruleForRecBillCollection.size() > 0) {
            throw new BOSException(ResourceBase.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"516_AutoRuleImport", (Locale)ctx.getLocale()));
        }
        info.setRuleNumber(number);
        String name = (String)this.getData(hsData, "FName");
        if (StringUtils.isEmpty((String)name)) {
            throw new BOSException(ResourceBase.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"499_AutoRuleImport", (Locale)ctx.getLocale()));
        }
        info.setName(name);
        Object data = this.getData(hsData, "FStartDate");
        if (data == null || data.toString().trim().length() <= 0) {
            throw new BOSException(ResourceBase.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"500_AutoRuleImport", (Locale)ctx.getLocale()));
        }
        info.setStartDate(RecAndPayDataImportUtil2.objToDate(ctx, data));
        String autoExecOper = (String)this.getData(hsData, "FAutoExecOper");
        if (StringUtils.isEmpty((String)autoExecOper)) throw new BOSException(ResourceBase.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"502_AutoRuleImport", (Locale)ctx.getLocale()));
        if (autoExecOper.equals("3")) {
            throw new BOSException(ResourceBase.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"514_AutoRuleImport", (Locale)ctx.getLocale()));
        }
        AutoExecOperType item = null;
        try {
            item = AutoExecOperType.getEnum(Integer.parseInt(autoExecOper));
        }
        catch (NumberFormatException e) {
            throw new BOSException(ResourceBase.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"518_AutoRuleImport", (Locale)ctx.getLocale()));
        }
        if (item == null) {
            throw new BOSException(ResourceBase.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"501_AutoRuleImport", (Locale)ctx.getLocale()));
        }
        info.setAutoExecOper(item);
        String bankAccountNumber = (String)this.getData(hsData, "FAccountBank_bankAccountNumber");
        if (StringUtils.isEmpty((String)bankAccountNumber)) throw new BOSException(ResourceBase.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"504_AutoRuleImport", (Locale)ctx.getLocale()));
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("*"));
        selector.add(new SelectorItemInfo("company.*"));
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("bankAccountNumber", (Object)bankAccountNumber, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)info.getCompany().getId(), CompareType.EQUALS));
        view.setFilter(filter);
        view.setSelector(selector);
        AccountBankCollection acBankCollection = AccountBankFactory.getLocalInstance((Context)ctx).getAccountBankCollection(view);
        if (acBankCollection.size() <= 0) {
            throw new BOSException(ResourceBase.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"503_AutoRuleImport", (Locale)ctx.getLocale()));
        }
        for (int i = 0; i < acBankCollection.size(); ++i) {
            CompanyOrgUnitInfo company2 = acBankCollection.get(i).getCompany();
            if (!company2.getNumber().equals(companyNum)) continue;
            info.setAccountBank(acBankCollection.get(i));
        }
        if (info.getAccountBank() == null) {
            throw new BOSException(ResourceBase.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"503_AutoRuleImport", (Locale)ctx.getLocale()));
        }
        EntityViewInfo view2 = new EntityViewInfo();
        SelectorItemCollection selector2 = new SelectorItemCollection();
        selector2.add(new SelectorItemInfo("*"));
        selector2.add(new SelectorItemInfo("company.*"));
        FilterInfo filter2 = new FilterInfo();
        filter2.getFilterItems().add(new FilterItemInfo("accountBank.id", (Object)info.getAccountBank().getId().toString(), CompareType.EQUALS));
        filter2.getFilterItems().add(new FilterItemInfo("company.id", (Object)info.getCompany().getId(), CompareType.EQUALS));
        view2.setFilter(filter2);
        view2.setSelector(selector2);
        AutoGenRuleForRecBillCollection ruleForRecBillCollection2 = AutoGenRuleForRecBillFactory.getLocalInstance(ctx).getAutoGenRuleForRecBillCollection(view2);
        if (ruleForRecBillCollection2 != null && ruleForRecBillCollection2.size() > 0) {
            throw new BOSException(ResourceBase.getString((String)"com.kingdee.eas.fi.cas.CASAutoResource", (String)"69_AutoRuleForPayDataImport", (Locale)ctx.getLocale()));
        }
        String createrId = (String)this.getData(hsData, "FCreaterId");
        if (StringUtils.isEmpty((String)createrId)) {
            throw new BOSException(ResourceBase.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"505_AutoRuleImport", (Locale)ctx.getLocale()));
        }
        this.getUserInfo(info, createrId, 1, ctx);
        String auditorId = (String)this.getData(hsData, "FAuditorId");
        if (StringUtils.isEmpty((String)auditorId)) {
            throw new BOSException(ResourceBase.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"506_AutoRuleImport", (Locale)ctx.getLocale()));
        }
        this.getUserInfo(info, auditorId, 2, ctx);
        String casherId = (String)this.getData(hsData, "FCasherId");
        if (StringUtils.isEmpty((String)casherId)) {
            throw new BOSException(ResourceBase.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"507_AutoRuleImport", (Locale)ctx.getLocale()));
        }
        this.getUserInfo(info, casherId, 3, ctx);
        String msgReceiverId = (String)this.getData(hsData, "FMsgReceiverId");
        if (StringUtils.isEmpty((String)msgReceiverId)) {
            throw new BOSException(ResourceBase.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"508_AutoRuleImport", (Locale)ctx.getLocale()));
        }
        this.getUserInfo(info, msgReceiverId, 4, ctx);
        UserInfo userInfo = ContextUtil.getCurrentUserInfo((Context)ctx);
        info.setUser(userInfo);
        info.setCreator(userInfo);
        EntityViewInfo viewInfo2 = new EntityViewInfo();
        viewInfo2.getSelector().add(new SelectorItemInfo("*"));
        FilterInfo filterInfo2 = new FilterInfo();
        filterInfo2.getFilterItems().add(new FilterItemInfo("company.id", (Object)info.getCompany().getId(), CompareType.EQUALS));
        filterInfo2.getFilterItems().add(new FilterItemInfo("accountbank.id", (Object)info.getAccountBank().getId(), CompareType.EQUALS));
        viewInfo2.setFilter(filterInfo2);
        AutoGenRuleForRecBillCollection ruleForRecCollection = AutoGenRuleForRecBillFactory.getLocalInstance(ctx).getAutoGenRuleForRecBillCollection(viewInfo2);
        if (ruleForRecCollection != null && ruleForRecCollection.size() > 0) {
            for (int i = 0; i < ruleForRecCollection.size(); ++i) {
                AutoGenRuleForRecBillInfo recInfo = ruleForRecCollection.get(i);
                EnableStatusEnum isStart = recInfo.getIsStart();
                if (isStart.equals((Object)EnableStatusEnum.getEnum("enable"))) {
                    info.setIsStart(EnableStatusEnum.getEnum("disable"));
                    return info;
                }
                info.setIsStart(EnableStatusEnum.getEnum("enable"));
            }
            return info;
        }
        info.setIsStart(EnableStatusEnum.getEnum("enable"));
        return info;
    }

    private void getUserInfo(AutoGenRuleForRecBillInfo info, String userNumber, int type, Context ctx) throws BOSException, EASBizException {
        UserInfo userInfo;
        block13: {
            userInfo = null;
            try {
                userInfo = UserFactory.getLocalInstance((Context)ctx).getUserInfoByNumber(userNumber);
            }
            catch (Exception e) {
                if (type == 1) {
                    throw new BOSException(ResourceBase.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"509_AutoRuleImport", (Locale)ctx.getLocale()));
                }
                if (type == 2) {
                    throw new BOSException(ResourceBase.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"510_AutoRuleImport", (Locale)ctx.getLocale()));
                }
                if (type == 3) {
                    throw new BOSException(ResourceBase.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"511_AutoRuleImport", (Locale)ctx.getLocale()));
                }
                if (type != 4) break block13;
                throw new BOSException(ResourceBase.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"512_AutoRuleImport", (Locale)ctx.getLocale()));
            }
        }
        if (userInfo != null) {
            if (type == 1) {
                info.setCreaterId(userInfo.getId().toString());
                info.setCreaterName(userInfo.getName());
            } else if (type == 2) {
                info.setAuditorId(userInfo.getId().toString());
                info.setAuditorName(userInfo.getName());
            } else if (type == 3) {
                info.setCasherId(userInfo.getId().toString());
                info.setCasherName(userInfo.getName());
            } else if (type == 4) {
                info.setMsgReceiverId(userInfo.getId().toString());
                info.setMsgReceiverName(userInfo.getName());
            }
        }
    }

    @Override
    protected void _submit(CoreBaseInfo coreBaseInfo, Context ctx) throws BOSException, EASBizException {
        if (coreBaseInfo == null) {
            return;
        }
        if (coreBaseInfo.getId() == null || !this._getController(ctx).exists((IObjectPK)new ObjectUuidPK(coreBaseInfo.getId()))) {
            AutoGenRuleForRecBillInfo info = (AutoGenRuleForRecBillInfo)coreBaseInfo;
            this._getController(ctx).addnew((CoreBaseInfo)info);
        } else {
            AutoGenRuleForRecBillInfo info = (AutoGenRuleForRecBillInfo)coreBaseInfo;
            if (info.getId() != null) {
                this._getController(ctx).update((IObjectPK)new ObjectUuidPK(coreBaseInfo.getId()), (CoreBaseInfo)info);
            } else {
                throw new BOSException(ResourceBase.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"14_AgentPayBillDataImport", (Locale)ctx.getLocale()));
            }
        }
    }
}

