/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.cas.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.dao.DataAccessException;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ORMappingDAO;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.ormapping.SQLAccessException;
import com.kingdee.bos.framework.DynamicObjectFactory;
import com.kingdee.bos.framework.IDynamicObject;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.metadata.bot.BOTExtMappingInfo;
import com.kingdee.bos.metadata.bot.BOTGroupingCollection;
import com.kingdee.bos.metadata.bot.BOTGroupingInfo;
import com.kingdee.bos.metadata.bot.BOTMappingCollection;
import com.kingdee.bos.metadata.bot.BOTMappingFactory;
import com.kingdee.bos.metadata.bot.BOTMappingInfo;
import com.kingdee.bos.metadata.bot.BOTRuleCollection;
import com.kingdee.bos.metadata.bot.BOTRuleInfo;
import com.kingdee.bos.metadata.bot.BOTRuleSegmentCollection;
import com.kingdee.bos.metadata.bot.BOTRuleSegmentInfo;
import com.kingdee.bos.metadata.bot.DefineSysEnum;
import com.kingdee.bos.metadata.bot.IBOTMapping;
import com.kingdee.bos.metadata.bot.MappingTypeEnum;
import com.kingdee.bos.metadata.bot.app.BOTRuleFilterTools;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.sql.ParserException;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.botp.BOTPException;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.CtrlUnitFactory;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBillBaseInfo;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.LowTimer;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class BOTMappingHelperForCas {
    private static final Logger logger = Logger.getLogger(BOTMappingHelperForCas.class);
    private static final String SEPERATOR = ",";

    public static ArrayList getTargetBillTypeList(Context ctx, String sourceBillType) throws BOSException {
        ArrayList<String> result = new ArrayList<String>();
        HashMap<String, String> map = new HashMap<String, String>();
        try {
            String sqlToGetTargetBillTypeList = "SELECT FDESTENTITYNAME FROM T_BOT_MAPPING MAPPING INNER JOIN T_BOT_EXTMAPPING EM ON MAPPING.FEXTMAPPINGID=EM.FID WHERE (MAPPING.FUIDisable=0 OR MAPPING.FUIDisable IS NULL)  AND MAPPING.FSRCENTITYNAME=? AND MAPPING.FDEFINESYS=? AND EM.FISEFFECTED=? AND EM.FTRANSMODE<>?" + BOTMappingHelperForCas.getOrderTypeSql(ctx);
            IRowSet rsToGetTargetBillTypeList = DbUtil.executeQuery((Context)ctx, (String)sqlToGetTargetBillTypeList, (Object[])new Object[]{sourceBillType, new Integer(20), Boolean.TRUE, new Integer(20)});
            while (rsToGetTargetBillTypeList.next()) {
                String destEntityName = rsToGetTargetBillTypeList.getString("FDESTENTITYNAME");
                if (map.containsKey(destEntityName)) continue;
                result.add(destEntityName);
                map.put(destEntityName, destEntityName);
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return result;
    }

    public static ArrayList getSourceBillTypeList(Context ctx, String targetBillType) throws BOSException {
        ArrayList<String> result = new ArrayList<String>();
        HashMap<String, String> map = new HashMap<String, String>();
        try {
            String sqlToGetTargetBillTypeList = "SELECT FSRCENTITYNAME FROM T_BOT_MAPPING MAPPING INNER JOIN T_BOT_EXTMAPPING EM ON MAPPING.FEXTMAPPINGID=EM.FID WHERE (MAPPING.FUIDisable=0 OR MAPPING.FUIDisable IS NULL)  AND MAPPING.FDESTENTITYNAME=? AND MAPPING.FDEFINESYS=? AND EM.FISEFFECTED=? AND EM.FTRANSMODE<>?" + BOTMappingHelperForCas.getOrderTypeSql(ctx);
            IRowSet rsToGetTargetBillTypeList = DbUtil.executeQuery((Context)ctx, (String)sqlToGetTargetBillTypeList, (Object[])new Object[]{targetBillType, new Integer(20), Boolean.TRUE, new Integer(20)});
            while (rsToGetTargetBillTypeList.next()) {
                String srcEntityName = rsToGetTargetBillTypeList.getString("FSRCENTITYNAME");
                if (map.containsKey(srcEntityName)) continue;
                result.add(srcEntityName);
                map.put(srcEntityName, srcEntityName);
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return result;
    }

    private static Connection getConnection(Context ctx) throws SQLDataException {
        try {
            return EJBFactory.getConnection((Context)ctx);
        }
        catch (SQLException sqle) {
            throw new SQLDataException(sqle);
        }
    }

    public static BOTMappingInfo getMapping(Context ctx, IObjectValue sourceBill, String targetBillType) throws BOSException, EASBizException {
        CtrlUnitInfo unitInfo = ContextUtil.getCurrentCtrlUnit((Context)ctx);
        HashMap map = new HashMap();
        BOTMappingInfo info = BOTMappingHelperForCas.getMapping(ctx, sourceBill, targetBillType, null, unitInfo, map);
        if (map.get("flag") != null && map.get("flag").equals("1")) {
            throw new BOTPException(BOTPException.NOMAPPING);
        }
        if (map.get("flag") != null && map.get("flag").equals("2")) {
            throw new BOTPException(BOTPException.NOCOMPANYMAPPING);
        }
        if (map.get("flag") != null && map.get("flag").equals("3")) {
            throw new BOTPException(BOTPException.MAPPINGNUMZERO);
        }
        if (info == null && map.get("mappingInfo") != null) {
            info = (BOTMappingInfo)map.get("mappingInfo");
        }
        if (info == null) {
            throw new BOTPException(BOTPException.MAPPINGNUMZERO);
        }
        return info;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BOTMappingInfo getMapping(Context ctx, IObjectValue sourceBill, String targetBillType, DefineSysEnum defineSys, CtrlUnitInfo unitInfo, Map map) throws BOSException, EASBizException {
        String sourceBillType = sourceBill.getBOSType().toString();
        if (unitInfo.getParent() != null) {
            System.out.println("unitInfo====parent=======" + unitInfo.getParent().getId().toString());
        }
        int flag = 0;
        LowTimer t = new LowTimer();
        t.reset();
        BOTMappingCollection mappingCol = BOTMappingHelperForCas.getBOTMappingCollection(ctx, sourceBillType, targetBillType, defineSys, unitInfo.getId().toString());
        if (mappingCol.size() == 0) {
            flag = 1;
            map.put("flag", flag + "");
        } else {
            Iterator iter = mappingCol.iterator();
            ArrayList<BOTMappingInfo> companyMappings = new ArrayList<BOTMappingInfo>();
            while (iter.hasNext()) {
                String currentOrgId;
                BOTMappingInfo mappingInfo = (BOTMappingInfo)iter.next();
                String string = currentOrgId = ContextUtil.getCurrentFIUnit((Context)ctx) == null ? "" : ContextUtil.getCurrentFIUnit((Context)ctx).getId().toString();
                if (mappingInfo.getExtRule() != null && mappingInfo.getExtRule().getOrg() != null && !mappingInfo.getExtRule().getOrg().getId().toString().equals(currentOrgId)) continue;
                companyMappings.add(mappingInfo);
            }
            if (companyMappings.size() == 0) {
                flag = 2;
                map.put("flag", flag + "");
            } else {
                for (BOTMappingInfo mappingInfo : companyMappings) {
                    if (!BOTMappingHelperForCas.acceptMapping(ctx, sourceBill, mappingInfo)) continue;
                    t.reset();
                    Connection conn = null;
                    try {
                        conn = BOTMappingHelperForCas.getConnection(ctx);
                        ORMappingDAO dao = new ORMappingDAO(new BOSObjectType("045122C4"), ctx, conn);
                        mappingInfo = (BOTMappingInfo)dao.getValue((IObjectPK)new ObjectUuidPK(mappingInfo.getId()));
                    }
                    finally {
                        SQLUtils.cleanup((Connection)conn);
                    }
                    flag = 0;
                    map.put("flag", flag + "");
                    map.put("mappingInfo", mappingInfo);
                    return mappingInfo;
                }
                flag = 3;
                map.put("flag", flag + "");
            }
        }
        unitInfo = CtrlUnitFactory.getLocalInstance((Context)ctx).getCtrlUnitInfo((IObjectPK)new ObjectUuidPK(unitInfo.getId()), BOTMappingHelperForCas.getSelector());
        CtrlUnitInfo parentUnitInfo = unitInfo.getParent();
        if (flag != 0 && parentUnitInfo != null) {
            return BOTMappingHelperForCas.getMapping(ctx, sourceBill, targetBillType, null, parentUnitInfo, map);
        }
        return null;
    }

    private static SelectorItemCollection getSelector() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("parent.*"));
        return sic;
    }

    private static BOTMappingCollection getBOTMappingCollection(Context ctx, String sourceBillType, String targetBillType, DefineSysEnum defineSys, String currentCuId) throws BOSException, BOTPException {
        BOTMappingCollection result = new BOTMappingCollection();
        try {
            IRowSet rowset = BOTMappingHelperForCas.getMappingByCU(ctx, sourceBillType, targetBillType, defineSys, currentCuId);
            while (rowset.next()) {
                BOTMappingInfo mappingInfo = new BOTMappingInfo();
                mappingInfo.setId(BOSUuid.read((String)rowset.getString("FID")));
                mappingInfo.setSrcEntityName(rowset.getString("FSRCENTITYNAME"));
                mappingInfo.setDestEntityName(rowset.getString("FDESTENTITYNAME"));
                mappingInfo.setDefineSys(DefineSysEnum.getEnum((int)rowset.getInt("FDEFINESYS")));
                BOTExtMappingInfo extRule = new BOTExtMappingInfo();
                extRule.setFilter(rowset.getString("FFILTER"));
                String orgId = rowset.getString("FORGID");
                if (!StringUtils.isEmpty((String)orgId)) {
                    CompanyOrgUnitInfo org = new CompanyOrgUnitInfo();
                    org.setId(BOSUuid.read((String)orgId));
                    extRule.setOrg(org);
                }
                mappingInfo.setExtRule(extRule);
                result.add(mappingInfo);
            }
        }
        catch (SQLException exc) {
            throw new BOTPException(BOTPException.MAPPINGNUMZERO, (Throwable)exc);
        }
        return result;
    }

    private static BOTMappingCollection getBOTMappingCollectionForSelect(Context ctx, String sourceBillType, String targetBillType, DefineSysEnum defineSys, Map transmitCtx) throws BOSException, BOTPException {
        return BOTMappingHelperForCas.getBOTMappingCollectionForSelect(ctx, sourceBillType, targetBillType, defineSys, transmitCtx, false);
    }

    private static BOTMappingCollection getBOTMappingCollectionForSelect(Context ctx, String sourceBillType, String targetBillType, DefineSysEnum defineSys, Map transmitCtx, boolean isAllCUMode) throws BOSException, BOTPException {
        BOTMappingCollection result = new BOTMappingCollection();
        try {
            IRowSet rowset = null;
            String transmitCuId = null;
            if (!isAllCUMode) {
                if (transmitCtx == null) {
                    transmitCuId = ContextUtil.getCurrentCtrlUnit((Context)ctx).getId().toString();
                } else {
                    transmitCuId = (String)transmitCtx.get("TRANSMITCU_ID");
                    if (StringUtils.isEmpty((String)transmitCuId)) {
                        Object transmitCu = transmitCtx.get("TRANSMITCU");
                        transmitCuId = transmitCu != null && transmitCu instanceof CtrlUnitInfo ? ((CtrlUnitInfo)transmitCu).getId().toString() : ContextUtil.getCurrentCtrlUnit((Context)ctx).getId().toString();
                    }
                }
                rowset = BOTMappingHelperForCas.getMappingByCUForSelect(ctx, sourceBillType, targetBillType, defineSys, transmitCuId);
            } else {
                rowset = BOTMappingHelperForCas.getMappingAllCUForSelect(ctx, sourceBillType, targetBillType, defineSys);
            }
            while (rowset.next()) {
                BOTMappingInfo mappingInfo = new BOTMappingInfo();
                mappingInfo.setId(BOSUuid.read((String)rowset.getString("FID")));
                mappingInfo.setName(rowset.getString("FNAME"));
                mappingInfo.setAlias(rowset.getString("FALIAS_" + ctx.getLocale().toString()), ctx.getLocale());
                mappingInfo.setSrcEntityName(rowset.getString("FSRCENTITYNAME"));
                mappingInfo.setDestEntityName(rowset.getString("FDESTENTITYNAME"));
                mappingInfo.setDescription(rowset.getString("FDESCRIPTION_" + ctx.getLocale().toString()), ctx.getLocale());
                mappingInfo.setDefineSys(DefineSysEnum.getEnum((int)rowset.getInt("FDEFINESYS")));
                mappingInfo.setLastUpdateTime(rowset.getTimestamp("FLASTUPDATETIME"));
                mappingInfo.setIsTempSave(rowset.getInt("FISTEMPSAVE"));
                mappingInfo.setIsShowEditUI(rowset.getInt("FISSHOWEDITUI"));
                mappingInfo.setExtConfig(rowset.getString("FEXTCONFIG"));
                mappingInfo.setMappingType(MappingTypeEnum.getEnum((int)rowset.getInt("FMappingType")));
                IRowSet ruleRS = DbUtil.executeQuery((Context)ctx, (String)"SELECT BotRule.FID AS FRuleID, Segment.FID AS FSegmentID, Segment.FSrcPropertyName, Segment.FExpression FROM T_BOT_RULE BotRule INNER JOIN T_BOT_RULESEGMENT Segment ON BotRule.FID = Segment.FRuleID WHERE BotRule.FMappingID = ?", (Object[])new Object[]{rowset.getString("FID")});
                BOTRuleCollection ruleColl = mappingInfo.getRules();
                while (ruleRS.next()) {
                    BOTRuleInfo rule;
                    if (!ruleColl.containsKey((Object)BOSUuid.read((String)ruleRS.getString("FRuleID")))) {
                        rule = new BOTRuleInfo();
                        rule.setId(BOSUuid.read((String)ruleRS.getString("FRuleID")));
                        ruleColl.add(rule);
                    } else {
                        rule = ruleColl.get((Object)BOSUuid.read((String)ruleRS.getString("FRuleID")));
                    }
                    BOTRuleSegmentInfo segment = new BOTRuleSegmentInfo();
                    segment.setId(BOSUuid.read((String)ruleRS.getString("FSegmentID")));
                    segment.setSrcPropertyName(ruleRS.getString("FSrcPropertyName"));
                    segment.setExpression(ruleRS.getString("FExpression"));
                    rule.getRuleSegments().add(segment);
                }
                BOTExtMappingInfo extRule = new BOTExtMappingInfo();
                extRule.setFilter(rowset.getString("FFILTER"));
                extRule.setDataFilter(rowset.getString("FDATAFILTER"));
                extRule.setIsEffected(true);
                String orgId = rowset.getString("FORGID");
                if (!StringUtils.isEmpty((String)orgId)) {
                    CompanyOrgUnitInfo org = new CompanyOrgUnitInfo();
                    org.setId(BOSUuid.read((String)orgId));
                    extRule.setOrg(org);
                }
                mappingInfo.setExtRule(extRule);
                result.add(mappingInfo);
            }
        }
        catch (SQLException exc) {
            throw new BOTPException(BOTPException.MAPPINGNUMZERO, (Throwable)exc);
        }
        return result;
    }

    private static String getOrderSql(Context ctx) {
        return " ORDER BY MAPPING.FAlias_" + ctx.getLocale().toString() + " schinese_pinyin ASC";
    }

    private static String getOrderTypeSql(Context ctx) {
        return " ORDER BY MAPPING.FAlias_" + ctx.getLocale().toString() + " schinese_pinyin ASC";
    }

    private static IRowSet getMappingByCUForSelect(Context ctx, String sourceBillType, String targetBillType, DefineSysEnum defineSys, String transmitCuId) throws BOSException {
        IRowSet rs;
        if (defineSys != null) {
            ArrayList<Object> paramsWithDefineSys = new ArrayList<Object>();
            paramsWithDefineSys.add(transmitCuId);
            paramsWithDefineSys.add(sourceBillType);
            paramsWithDefineSys.add(new Integer(1));
            paramsWithDefineSys.add(new Integer(10));
            paramsWithDefineSys.add(new Integer(30));
            paramsWithDefineSys.add(new Integer(defineSys.getValue()));
            String sql = "SELECT MAPPING.FNAME,MAPPING.FMAPPINGTYPE,MAPPING.FDESCRIPTION_" + ctx.getLocale().toString() + ",MAPPING.FAlias_" + ctx.getLocale().toString() + ",MAPPING.FControlUnitID CUID,MAPPING.FID, MAPPING.FSRCENTITYNAME, MAPPING.FDESTENTITYNAME, MAPPING.FDEFINESYS, MAPPING.FISTEMPSAVE, MAPPING.FISSHOWEDITUI,MAPPING.FEXTCONFIG,MAPPING.FLASTUPDATETIME, EXTRULE.FFILTER, EXTRULE.FDATAFILTER, EXTRULE.FORGID  FROM T_BOT_MAPPING MAPPING LEFT OUTER JOIN T_BOT_EXTMAPPING EXTRULE ON MAPPING.FEXTMAPPINGID = EXTRULE.FID  WHERE (MAPPING.FUIDisable=0 OR MAPPING.FUIDisable IS NULL)  AND MAPPING.FControlUnitID = ?  AND MAPPING.FSRCENTITYNAME = ? AND EXTRULE.FISEFFECTED = ? AND (EXTRULE.FTRANSMODE = ? OR EXTRULE.FTRANSMODE = ?) AND MAPPING.FDEFINESYS = ?";
            if (targetBillType != null && targetBillType.length() > 0) {
                sql = sql + " AND MAPPING.FDESTENTITYNAME = ? " + BOTMappingHelperForCas.getOrderSql(ctx);
                paramsWithDefineSys.add(targetBillType);
            } else {
                sql = sql + BOTMappingHelperForCas.getOrderSql(ctx);
            }
            rs = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])paramsWithDefineSys.toArray());
            if (rs == null || rs.size() < 1) {
                paramsWithDefineSys.remove(0);
                paramsWithDefineSys.add(0, "00000000-0000-0000-0000-000000000000CCE7AED4");
                rs = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])paramsWithDefineSys.toArray());
            }
        } else {
            ArrayList<Object> paramsWithoutDefineSys = new ArrayList<Object>();
            paramsWithoutDefineSys.add(transmitCuId);
            paramsWithoutDefineSys.add(sourceBillType);
            paramsWithoutDefineSys.add(new Integer(1));
            paramsWithoutDefineSys.add(new Integer(10));
            paramsWithoutDefineSys.add(new Integer(30));
            String sql = "SELECT MAPPING.FNAME,MAPPING.FMAPPINGTYPE,MAPPING.FDESCRIPTION_" + ctx.getLocale().toString() + ",MAPPING.FAlias_" + ctx.getLocale().toString() + ",MAPPING.FControlUnitID CUID,MAPPING.FID, MAPPING.FSRCENTITYNAME, MAPPING.FDESTENTITYNAME, MAPPING.FDEFINESYS, MAPPING.FISTEMPSAVE, MAPPING.FISSHOWEDITUI,MAPPING.FEXTCONFIG, MAPPING.FLASTUPDATETIME, EXTRULE.FFILTER, EXTRULE.FDATAFILTER, EXTRULE.FORGID  FROM T_BOT_MAPPING MAPPING LEFT OUTER JOIN T_BOT_EXTMAPPING EXTRULE ON MAPPING.FEXTMAPPINGID = EXTRULE.FID  WHERE (MAPPING.FUIDisable=0 OR MAPPING.FUIDisable IS NULL)  AND MAPPING.FControlUnitID = ?  AND MAPPING.FSRCENTITYNAME = ? AND EXTRULE.FISEFFECTED = ? AND (EXTRULE.FTRANSMODE = ? OR EXTRULE.FTRANSMODE = ?) ";
            if (targetBillType != null && targetBillType.length() > 0) {
                sql = sql + " AND MAPPING.FDESTENTITYNAME = ? " + BOTMappingHelperForCas.getOrderSql(ctx);
                paramsWithoutDefineSys.add(targetBillType);
            } else {
                sql = sql + BOTMappingHelperForCas.getOrderSql(ctx);
            }
            rs = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])paramsWithoutDefineSys.toArray());
            if (rs == null || rs.size() < 1) {
                paramsWithoutDefineSys.remove(0);
                paramsWithoutDefineSys.add(0, "00000000-0000-0000-0000-000000000000CCE7AED4");
                rs = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])paramsWithoutDefineSys.toArray());
            }
        }
        return rs;
    }

    private static IRowSet getMappingAllCUForSelect(Context ctx, String sourceBillType, String targetBillType, DefineSysEnum defineSys) throws BOSException {
        IRowSet rs;
        if (defineSys != null) {
            ArrayList<Object> paramsWithDefineSys = new ArrayList<Object>();
            paramsWithDefineSys.add(sourceBillType);
            paramsWithDefineSys.add(new Integer(1));
            paramsWithDefineSys.add(new Integer(10));
            paramsWithDefineSys.add(new Integer(30));
            paramsWithDefineSys.add(new Integer(defineSys.getValue()));
            String sql = "SELECT MAPPING.FNAME,MAPPING.FMAPPINGTYPE,MAPPING.FDESCRIPTION_" + ctx.getLocale().toString() + ",MAPPING.FAlias_" + ctx.getLocale().toString() + ",MAPPING.FControlUnitID CUID,MAPPING.FID, MAPPING.FSRCENTITYNAME, MAPPING.FDESTENTITYNAME, MAPPING.FDEFINESYS, MAPPING.FISTEMPSAVE, MAPPING.FISSHOWEDITUI,MAPPING.FEXTCONFIG,MAPPING.FLASTUPDATETIME, EXTRULE.FFILTER, EXTRULE.FDATAFILTER, EXTRULE.FORGID  FROM T_BOT_MAPPING MAPPING LEFT OUTER JOIN T_BOT_EXTMAPPING EXTRULE ON MAPPING.FEXTMAPPINGID = EXTRULE.FID  WHERE (MAPPING.FUIDisable=0 OR MAPPING.FUIDisable IS NULL)  AND  MAPPING.FSRCENTITYNAME = ? AND EXTRULE.FISEFFECTED = ? AND (EXTRULE.FTRANSMODE = ? OR EXTRULE.FTRANSMODE = ?) AND MAPPING.FDEFINESYS = ?";
            if (targetBillType != null && targetBillType.length() > 0) {
                sql = sql + " AND MAPPING.FDESTENTITYNAME = ? " + BOTMappingHelperForCas.getOrderSql(ctx);
                paramsWithDefineSys.add(targetBillType);
            } else {
                sql = sql + BOTMappingHelperForCas.getOrderSql(ctx);
            }
            rs = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])paramsWithDefineSys.toArray());
        } else {
            ArrayList<Object> paramsWithoutDefineSys = new ArrayList<Object>();
            paramsWithoutDefineSys.add(sourceBillType);
            paramsWithoutDefineSys.add(new Integer(1));
            paramsWithoutDefineSys.add(new Integer(10));
            paramsWithoutDefineSys.add(new Integer(30));
            String sql = "SELECT MAPPING.FNAME,MAPPING.FMAPPINGTYPE,MAPPING.FDESCRIPTION_" + ctx.getLocale().toString() + ",MAPPING.FAlias_" + ctx.getLocale().toString() + ",MAPPING.FControlUnitID CUID,MAPPING.FID, MAPPING.FSRCENTITYNAME, MAPPING.FDESTENTITYNAME, MAPPING.FDEFINESYS, MAPPING.FISTEMPSAVE, MAPPING.FISSHOWEDITUI,MAPPING.FEXTCONFIG, MAPPING.FLASTUPDATETIME, EXTRULE.FFILTER, EXTRULE.FDATAFILTER, EXTRULE.FORGID  FROM T_BOT_MAPPING MAPPING LEFT OUTER JOIN T_BOT_EXTMAPPING EXTRULE ON MAPPING.FEXTMAPPINGID = EXTRULE.FID  WHERE (MAPPING.FUIDisable=0 OR MAPPING.FUIDisable IS NULL)  AND  MAPPING.FSRCENTITYNAME = ? AND EXTRULE.FISEFFECTED = ? AND (EXTRULE.FTRANSMODE = ? OR EXTRULE.FTRANSMODE = ?) ";
            if (targetBillType != null && targetBillType.length() > 0) {
                sql = sql + " AND MAPPING.FDESTENTITYNAME = ? " + BOTMappingHelperForCas.getOrderSql(ctx);
                paramsWithoutDefineSys.add(targetBillType);
            } else {
                sql = sql + BOTMappingHelperForCas.getOrderSql(ctx);
            }
            rs = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])paramsWithoutDefineSys.toArray());
        }
        return rs;
    }

    private static IRowSet getMappingByCU(Context ctx, String sourceBillType, String targetBillType, DefineSysEnum defineSys, String currentCuId) throws SQLException, BOSException {
        IRowSet rs;
        System.out.println("currentCuId===========" + currentCuId);
        if (defineSys != null) {
            ArrayList<Object> paramsWithDefineSys = new ArrayList<Object>();
            paramsWithDefineSys.add(currentCuId);
            paramsWithDefineSys.add(sourceBillType);
            paramsWithDefineSys.add(targetBillType);
            paramsWithDefineSys.add(new Integer(1));
            paramsWithDefineSys.add(new Integer(10));
            paramsWithDefineSys.add(new Integer(30));
            paramsWithDefineSys.add(new Integer(defineSys.getValue()));
            String sql = "SELECT MAPPING.FControlUnitID CUID,MAPPING.FMAPPINGTYPE, MAPPING.FID, MAPPING.FSRCENTITYNAME, MAPPING.FDESTENTITYNAME, MAPPING.FDEFINESYS, EXTRULE.FFILTER, EXTRULE.FORGID FROM T_BOT_MAPPING MAPPING LEFT OUTER JOIN T_BOT_EXTMAPPING EXTRULE ON MAPPING.FEXTMAPPINGID = EXTRULE.FID WHERE (MAPPING.FUIDisable=0 OR MAPPING.FUIDisable IS NULL)  AND MAPPING.FControlUnitID = ?  AND MAPPING.FSRCENTITYNAME = ? AND MAPPING.FDESTENTITYNAME = ? AND EXTRULE.FISEFFECTED = ? AND (EXTRULE.FTRANSMODE = ? OR EXTRULE.FTRANSMODE = ?) AND MAPPING.FDEFINESYS = ? " + BOTMappingHelperForCas.getOrderSql(ctx);
            rs = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])paramsWithDefineSys.toArray());
        } else {
            ArrayList<Object> paramsWithoutDefineSys = new ArrayList<Object>();
            paramsWithoutDefineSys.add(currentCuId);
            paramsWithoutDefineSys.add(sourceBillType);
            paramsWithoutDefineSys.add(targetBillType);
            paramsWithoutDefineSys.add(new Integer(1));
            paramsWithoutDefineSys.add(new Integer(10));
            paramsWithoutDefineSys.add(new Integer(30));
            String sql = "SELECT MAPPING.FControlUnitID CUID,MAPPING.FMAPPINGTYPE, MAPPING.FID, MAPPING.FSRCENTITYNAME, MAPPING.FDESTENTITYNAME, MAPPING.FDEFINESYS, EXTRULE.FFILTER, EXTRULE.FORGID FROM T_BOT_MAPPING MAPPING LEFT OUTER JOIN T_BOT_EXTMAPPING EXTRULE ON MAPPING.FEXTMAPPINGID = EXTRULE.FID WHERE (MAPPING.FUIDisable=0 OR MAPPING.FUIDisable IS NULL)  AND ( MAPPING.FControlUnitID = ?  )  AND MAPPING.FSRCENTITYNAME = ? AND MAPPING.FDESTENTITYNAME = ? AND EXTRULE.FISEFFECTED = ? AND (EXTRULE.FTRANSMODE = ? OR EXTRULE.FTRANSMODE = ?) " + BOTMappingHelperForCas.getOrderSql(ctx);
            rs = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])paramsWithoutDefineSys.toArray());
        }
        return rs;
    }

    public static void checkBillVouchered(IObjectCollection sourceBillCollection, String targetBillType, DefineSysEnum defineSys) throws BOTPException {
    }

    public static ArrayList getGroupingProperties(Context ctx, BOTMappingInfo mappingInfo) throws BOSException, BOTPException {
        if (mappingInfo.getRules().size() == 0) {
            throw new BOTPException(BOTPException.RULENUMZERO);
        }
        BOTRuleInfo rule = mappingInfo.getRules().get(0);
        BOTGroupingCollection groupCol = rule.getGroups();
        ArrayList<String> result = new ArrayList<String>();
        block0: for (BOTGroupingInfo group : groupCol) {
            if (group.getGroupingLevel() != 1) continue;
            for (BOTRuleSegmentInfo botRuleSegmentInfo : rule.getRuleSegments()) {
                if (!botRuleSegmentInfo.getDestPropertyName().equals(group.getGroupingProperty())) continue;
                result.add(botRuleSegmentInfo.getSrcPropertyName());
                continue block0;
            }
        }
        return result;
    }

    public static ArrayList getRelationProperties(Context ctx, BOTMappingInfo mappingInfo) throws BOSException, BOTPException {
        if (mappingInfo.getRules().size() == 0) {
            throw new BOTPException(BOTPException.RULENUMZERO);
        }
        BOTRuleInfo rule = mappingInfo.getRules().get(0);
        BOTRuleSegmentCollection ruleSegs = rule.getRuleSegments();
        ArrayList<String> result = new ArrayList<String>();
        for (BOTRuleSegmentInfo ruleSeg : ruleSegs) {
            if (!ruleSeg.isRegInRelation() || ruleSeg.getSrcPropertyName() == null || ruleSeg.getSrcPropertyName().length() == 0) continue;
            result.add(ruleSeg.getSrcPropertyName());
        }
        return result;
    }

    public static ArrayList getMatchProperties(Context ctx, BOTMappingInfo mappingInfo) throws BOSException, BOTPException {
        if (mappingInfo.getRules().size() == 0) {
            throw new BOTPException(BOTPException.RULENUMZERO);
        }
        BOTRuleInfo rule = mappingInfo.getRules().get(0);
        BOTRuleSegmentCollection ruleSegs = rule.getRuleSegments();
        ArrayList<String> result = new ArrayList<String>();
        for (BOTRuleSegmentInfo ruleSeg : ruleSegs) {
            if (!ruleSeg.isRegInRelation()) continue;
            result.add(ruleSeg.getDestPropertyName());
        }
        return result;
    }

    public static String listToString(ArrayList list) {
        return BOTMappingHelperForCas.listToString(list, SEPERATOR);
    }

    public static String listToString(ArrayList list, String sep) {
        int i = 0;
        StringBuffer result = new StringBuffer("");
        Iterator iter = list.iterator();
        while (iter.hasNext()) {
            if (i > 0) {
                result.append(sep);
            }
            result.append(iter.next().toString());
            ++i;
        }
        return result.toString();
    }

    private static boolean acceptMapping(Context ctx, IObjectValue sourceBill, BOTMappingInfo mappingInfo) throws BOSException {
        EntityViewInfo evi = BOTMappingHelperForCas.getBOTMappingFilter(ctx, mappingInfo);
        FilterInfo filterInfo = evi.getFilter();
        if (evi == null) {
            evi = new EntityViewInfo();
        }
        if (filterInfo == null || filterInfo.getFilterItems().size() == 0) {
            return true;
        }
        System.out.println("filterInfo === evi.toString()====" + filterInfo);
        return BOTMappingHelperForCas.accept(ctx, sourceBill.getBOSType(), (IObjectPK)new ObjectUuidPK(sourceBill.getBOSUuid(sourceBill.getPKField())), evi);
    }

    private static void acceptMapping(Context ctx, IObjectCollection sourceBillCollection, BOTMappingInfo mappingInfo) throws BOSException, BOTPException {
        int i;
        IObjectValue sourceBill0 = sourceBillCollection.getObject(0);
        boolean hasEntryFilter = false;
        EntityViewInfo evi = BOTMappingHelperForCas.getBOTMappingFilter(ctx, mappingInfo);
        evi.getSelector().add("id");
        FilterInfo filterInfo = evi.getFilter();
        if (evi.getEntryFilters() != null && evi.getEntryFilters().size() > 0) {
            hasEntryFilter = true;
            int count = evi.getEntryFilters().size();
            for (int i2 = 0; i2 < count; ++i2) {
                FilterInfo entryFilter = evi.getEntryFilters().get(i2);
                String entryName = entryFilter.getEntryName();
                evi.getSelector().add(entryName + ".id");
            }
        }
        if (!(filterInfo != null && filterInfo.getFilterItems().size() != 0 || evi.getEntryFilters() != null && evi.getEntryFilters().size() != 0)) {
            return;
        }
        ArrayList<Object> billIdList = new ArrayList<Object>();
        int count = sourceBillCollection.size();
        for (int i3 = 0; i3 < count; ++i3) {
            billIdList.add(sourceBillCollection.getObject(i3).get("id"));
        }
        FilterInfo newHeadFilterInfo = BOTMappingHelperForCas.mergeFilterWithIdList(billIdList, filterInfo);
        if (filterInfo == null) {
            filterInfo = newHeadFilterInfo;
            evi.setFilter(newHeadFilterInfo);
        }
        if (hasEntryFilter) {
            int es = evi.getEntryFilters().size();
            for (int e = 0; e < es; ++e) {
                FilterInfo entryFilterInfo = evi.getEntryFilters().get(e);
                String entryName = entryFilterInfo.getEntryName();
                ArrayList<Object> entryIdList = new ArrayList<Object>();
                int count2 = sourceBillCollection.size();
                for (i = 0; i < count2; ++i) {
                    IObjectValue srcBillInfo = sourceBillCollection.getObject(i);
                    if (srcBillInfo.get(entryName) == null || !(srcBillInfo.get(entryName) instanceof IObjectCollection)) continue;
                    IObjectCollection entryCols = (IObjectCollection)srcBillInfo.get(entryName);
                    int entryCount = entryCols.size();
                    for (int j = 0; j < entryCount; ++j) {
                        entryIdList.add(entryCols.getObject(j).get("id"));
                    }
                }
                BOTMappingHelperForCas.mergeFilterWithIdList(entryIdList, entryFilterInfo);
            }
        }
        ArrayList<CoreBillBaseInfo> errorBillCollection = new ArrayList<CoreBillBaseInfo>();
        IDynamicObject iDynObj = DynamicObjectFactory.getLocalInstance((Context)ctx);
        IObjectCollection filteredCols = iDynObj.getCollection(sourceBill0.getBOSType(), evi);
        ArrayList<String> filteredIdList = new ArrayList<String>();
        int count3 = filteredCols.size();
        for (int i4 = 0; i4 < count3; ++i4) {
            IObjectValue filteredInfo = filteredCols.getObject(i4);
            boolean flag = true;
            if (hasEntryFilter) {
                int es = evi.getEntryFilters().size();
                for (int e = 0; e < es; ++e) {
                    FilterInfo entryFilterInfo = evi.getEntryFilters().get(e);
                    String entryName = entryFilterInfo.getEntryName();
                    if (filteredInfo.get(entryName) != null && filteredInfo.get(entryName) instanceof IObjectCollection && ((IObjectCollection)filteredInfo.get(entryName)).size() > 0) continue;
                    flag = false;
                    break;
                }
                if (!flag) continue;
                filteredIdList.add(filteredInfo.get("id").toString());
                continue;
            }
            filteredIdList.add(filteredInfo.get("id").toString());
        }
        HashMap pkListMap = new HashMap();
        for (i = 0; i < filteredIdList.size(); ++i) {
            pkListMap.put(filteredIdList.get(i), null);
        }
        for (CoreBillBaseInfo sourceBillInfo : sourceBillCollection) {
            if (pkListMap.containsKey(sourceBillInfo.getId().toString())) continue;
            errorBillCollection.add(sourceBillInfo);
        }
        if (errorBillCollection.size() > 0) {
            StringBuffer billNumberList = new StringBuffer();
            for (CoreBillBaseInfo sourceBillInfo : errorBillCollection) {
                billNumberList.append(sourceBillInfo.getNumber());
                billNumberList.append(" ");
            }
            throw new BOTPException(BOTPException.ILLEGALBILLLIST, new Object[]{billNumberList.toString()});
        }
    }

    private static FilterInfo mergeFilterWithIdList(List idList, FilterInfo filterInfo) {
        int index = 0;
        StringBuffer sbMaskString = new StringBuffer();
        if (filterInfo == null) {
            filterInfo = new FilterInfo();
        }
        if (filterInfo.getMaskString() == null || filterInfo.getMaskString().length() == 0) {
            Iterator iterFilter = filterInfo.getFilterItems().iterator();
            while (iterFilter.hasNext()) {
                if (index != 0) {
                    sbMaskString.append(" and ");
                }
                iterFilter.next();
                sbMaskString.append("#" + String.valueOf(index));
                ++index;
            }
            filterInfo.setMaskString(sbMaskString.toString());
        }
        StringBuffer sbNewMaskString = new StringBuffer();
        index = 0;
        String strIdLists = BOTMappingHelperForCas.objectArray2String(idList.toArray(), SEPERATOR);
        sbNewMaskString.append("#" + String.valueOf(filterInfo.getFilterItems().size()));
        filterInfo.getFilterItems().add(new FilterItemInfo("id", (Object)strIdLists, CompareType.INCLUDE));
        if (filterInfo.getMaskString() == null || filterInfo.getMaskString().length() == 0) {
            filterInfo.setMaskString(sbNewMaskString.toString());
        } else if (sbNewMaskString.length() > 0) {
            filterInfo.setMaskString("(" + filterInfo.getMaskString() + ") and (" + sbNewMaskString.toString() + ")");
        }
        return filterInfo;
    }

    public static final String objectArray2String(Object[] objs, String split) {
        if (objs == null) {
            return "";
        }
        StringBuffer buffer = new StringBuffer();
        for (int i = 0; i < objs.length; ++i) {
            buffer.append(objs[i] == null ? "null" : objs[i].toString());
            buffer.append(split);
        }
        if (buffer.length() > 0) {
            return buffer.substring(0, buffer.length() - split.length());
        }
        return buffer.toString();
    }

    public static EntityViewInfo getBOTMappingFilter(Context ctx, BOTMappingInfo mappingInfo) throws BOSException {
        EntityViewInfo entityViewInfo;
        if (StringUtils.isEmpty((String)mappingInfo.getExtRule().getFilter())) {
            entityViewInfo = new EntityViewInfo();
            FilterInfo filterInfo = new FilterInfo();
            entityViewInfo.setFilter(filterInfo);
        } else {
            try {
                entityViewInfo = new EntityViewInfo(mappingInfo.getExtRule().getFilter());
            }
            catch (ParserException exc) {
                throw new BOSException(exc.getMessage(), (Throwable)exc);
            }
        }
        return entityViewInfo;
    }

    private static boolean accept(Context ctx, BOSObjectType bosType, IObjectPK pk, EntityViewInfo evi) throws DataAccessException {
        FilterInfo rule = evi.getFilter();
        int index = 0;
        StringBuffer sbMaskString = new StringBuffer();
        if (rule.getMaskString() == null || rule.getMaskString().length() == 0) {
            Iterator iterFilter = rule.getFilterItems().iterator();
            while (iterFilter.hasNext()) {
                if (index != 0) {
                    sbMaskString.append(" and ");
                }
                iterFilter.next();
                sbMaskString.append("#" + String.valueOf(index));
                ++index;
            }
            rule.setMaskString(sbMaskString.toString());
        }
        rule.getFilterItems().add(new FilterItemInfo("id", (Object)pk.toString()));
        rule.setMaskString("(" + rule.getMaskString() + ") and #" + (rule.getFilterItems().size() - 1));
        Connection conn = null;
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            ORMappingDAO dao = new ORMappingDAO(bosType, ctx, conn);
            System.out.println("evi.toString()====" + evi.toString());
            System.out.println("bosType====" + bosType);
            boolean bl = dao.exists(evi.toString());
            return bl;
        }
        catch (SQLException sqle) {
            throw new SQLAccessException(sqle);
        }
        finally {
            SQLUtils.cleanup((Connection)conn);
        }
    }

    public static IObjectCollection getMappingForSelect(Context ctx, String srcBosType, String destBosType, Map transmitCtx) throws BOTPException, BOSException {
        LowTimer t = new LowTimer();
        t.reset();
        BOTMappingCollection mappingCol = BOTMappingHelperForCas.getBOTMappingCollectionForSelect(ctx, srcBosType, destBosType, null, transmitCtx);
        logger.debug((Object)("getBOTMappingCollection time: " + t.msValue()));
        if (mappingCol.size() == 0) {
            logger.error((Object)("destBosType:" + destBosType), (Throwable)new BOTPException(BOTPException.NOMAPPING));
        }
        return mappingCol;
    }

    public static IObjectCollection getMappingForSelectAllCU(Context ctx, String srcBosType, String destBosType, Map transmitCtx) throws BOTPException, BOSException {
        LowTimer t = new LowTimer();
        t.reset();
        BOTMappingCollection mappingCol = BOTMappingHelperForCas.getBOTMappingCollectionForSelect(ctx, srcBosType, destBosType, null, transmitCtx, true);
        logger.debug((Object)("getBOTMappingCollection time: " + t.msValue()));
        if (mappingCol.size() == 0) {
            logger.error((Object)("destBosType:" + destBosType), (Throwable)new BOTPException(BOTPException.NOMAPPING));
        }
        return mappingCol;
    }

    public static BOTMappingCollection getMappingForSelect(Context ctx, String srcBillType, String targetBillType, DefineSysEnum defineSys, Map transmitCtx) throws BOSException, BOTPException {
        LowTimer t = new LowTimer();
        t.reset();
        BOTMappingCollection mappingCol = BOTMappingHelperForCas.getBOTMappingCollectionForSelect(ctx, srcBillType, targetBillType, defineSys, transmitCtx);
        logger.debug((Object)("getBOTMappingCollection time: " + t.msValue()));
        if (mappingCol.size() == 0) {
            logger.error((Object)("destBosType:" + targetBillType), (Throwable)new BOTPException(BOTPException.NOMAPPING));
        }
        return mappingCol;
    }

    private static BOTMappingCollection getMappingByOneCUAfterCheck(Context ctx, IObjectCollection sourceBillCollection, String sourceBillType, String targetBillType, DefineSysEnum defineSys, String transmitCuId) throws BOTPException, BOSException {
        BOTMappingCollection botMappingCols = new BOTMappingCollection();
        BOTMappingCollection result = new BOTMappingCollection();
        try {
            IRowSet rowset = BOTMappingHelperForCas.getMappingByOneCUForSelect(ctx, sourceBillType, targetBillType, defineSys, transmitCuId);
            while (rowset.next()) {
                BOTMappingInfo mappingInfo = new BOTMappingInfo();
                mappingInfo.setId(BOSUuid.read((String)rowset.getString("FID")));
                mappingInfo.setName(rowset.getString("FNAME"));
                mappingInfo.setAlias(rowset.getString("FALIAS_" + ctx.getLocale().toString()), ctx.getLocale());
                mappingInfo.setSrcEntityName(rowset.getString("FSRCENTITYNAME"));
                mappingInfo.setDestEntityName(rowset.getString("FDESTENTITYNAME"));
                mappingInfo.setDescription(rowset.getString("FDESCRIPTION_" + ctx.getLocale().toString()), ctx.getLocale());
                mappingInfo.setDefineSys(DefineSysEnum.getEnum((int)rowset.getInt("FDEFINESYS")));
                mappingInfo.setLastUpdateTime(rowset.getTimestamp("FLASTUPDATETIME"));
                mappingInfo.setIsTempSave(rowset.getInt("FISTEMPSAVE"));
                mappingInfo.setIsShowEditUI(rowset.getInt("FISSHOWEDITUI"));
                mappingInfo.setExtConfig(rowset.getString("FEXTCONFIG"));
                mappingInfo.setMappingType(MappingTypeEnum.getEnum((int)rowset.getInt("FMappingType")));
                IRowSet ruleRS = DbUtil.executeQuery((Context)ctx, (String)"SELECT BotRule.FID AS FRuleID, Segment.FID AS FSegmentID, Segment.FSrcPropertyName, Segment.FExpression FROM T_BOT_RULE BotRule INNER JOIN T_BOT_RULESEGMENT Segment ON BotRule.FID = Segment.FRuleID WHERE BotRule.FMappingID = ?", (Object[])new Object[]{rowset.getString("FID")});
                BOTRuleCollection ruleColl = mappingInfo.getRules();
                while (ruleRS.next()) {
                    BOTRuleInfo rule;
                    if (!ruleColl.containsKey((Object)BOSUuid.read((String)ruleRS.getString("FRuleID")))) {
                        rule = new BOTRuleInfo();
                        rule.setId(BOSUuid.read((String)ruleRS.getString("FRuleID")));
                        ruleColl.add(rule);
                    } else {
                        rule = ruleColl.get((Object)BOSUuid.read((String)ruleRS.getString("FRuleID")));
                    }
                    BOTRuleSegmentInfo segment = new BOTRuleSegmentInfo();
                    segment.setId(BOSUuid.read((String)ruleRS.getString("FSegmentID")));
                    segment.setSrcPropertyName(ruleRS.getString("FSrcPropertyName"));
                    segment.setExpression(ruleRS.getString("FExpression"));
                    rule.getRuleSegments().add(segment);
                }
                BOTExtMappingInfo extRule = new BOTExtMappingInfo();
                extRule.setFilter(rowset.getString("FFILTER"));
                extRule.setDataFilter(rowset.getString("FDATAFILTER"));
                extRule.setIsEffected(true);
                String orgId = rowset.getString("FORGID");
                if (!StringUtils.isEmpty((String)orgId)) {
                    CompanyOrgUnitInfo org = new CompanyOrgUnitInfo();
                    org.setId(BOSUuid.read((String)orgId));
                    extRule.setOrg(org);
                }
                mappingInfo.setExtRule(extRule);
                result.add(mappingInfo);
            }
        }
        catch (SQLException exc) {
            throw new BOTPException(BOTPException.MAPPINGNUMZERO, (Throwable)exc);
        }
        if (!BOTRuleFilterTools.isShowBOTPWithRuleFilter((Context)ctx)) {
            return result;
        }
        Iterator iter = result.iterator();
        ArrayList<BOTMappingInfo> companyMappings = new ArrayList<BOTMappingInfo>();
        while (iter.hasNext()) {
            String currentOrgId;
            BOTMappingInfo mappingInfo = (BOTMappingInfo)iter.next();
            String string = currentOrgId = ContextUtil.getCurrentFIUnit((Context)ctx) == null ? "" : ContextUtil.getCurrentFIUnit((Context)ctx).getId().toString();
            if (mappingInfo.getExtRule() != null && mappingInfo.getExtRule().getOrg() != null && !mappingInfo.getExtRule().getOrg().getId().toString().equals(currentOrgId)) continue;
            companyMappings.add(mappingInfo);
        }
        for (BOTMappingInfo mappingInfo : companyMappings) {
            try {
                BOTMappingHelperForCas.acceptMapping(ctx, sourceBillCollection, mappingInfo);
                botMappingCols.add(mappingInfo);
            }
            catch (BOTPException bOTPException) {}
        }
        return botMappingCols;
    }

    public static BOTMappingCollection getMappingForSelect(Context ctx, IObjectCollection sourceBillCollection, String targetBillType, DefineSysEnum defineSys, Map transmitCtx) throws BOSException, BOTPException {
        BOTMappingCollection botMappingCols = new BOTMappingCollection();
        if (sourceBillCollection.size() == 0) {
            throw new BOTPException(BOTPException.NOBILL);
        }
        try {
            CoreBillBaseInfo sourceBill = (CoreBillBaseInfo)sourceBillCollection.getObject(0);
            String sourceBillType = sourceBill.getBOSType().toString();
            LowTimer t = new LowTimer();
            t.reset();
            BOTMappingCollection mappingCol = BOTMappingHelperForCas.getBOTMappingCollectionForSelect(ctx, sourceBillType, targetBillType, defineSys, transmitCtx);
            if (mappingCol.size() == 0) {
                throw new BOTPException(BOTPException.NOMAPPING);
            }
            Iterator iter = mappingCol.iterator();
            ArrayList<BOTMappingInfo> companyMappings = new ArrayList<BOTMappingInfo>();
            while (iter.hasNext()) {
                String currentOrgId;
                BOTMappingInfo mappingInfo = (BOTMappingInfo)iter.next();
                String string = currentOrgId = ContextUtil.getCurrentFIUnit((Context)ctx) == null ? "" : ContextUtil.getCurrentFIUnit((Context)ctx).getId().toString();
                if (mappingInfo.getExtRule() != null && mappingInfo.getExtRule().getOrg() != null && !mappingInfo.getExtRule().getOrg().getId().toString().equals(currentOrgId)) continue;
                companyMappings.add(mappingInfo);
            }
            if (companyMappings.size() == 0) {
                throw new BOTPException(BOTPException.NOCOMPANYMAPPING);
            }
            for (BOTMappingInfo mappingInfo : companyMappings) {
                try {
                    BOTMappingHelperForCas.acceptMapping(ctx, sourceBillCollection, mappingInfo);
                }
                catch (BOTPException e) {
                    continue;
                }
                botMappingCols.add(mappingInfo);
            }
            if (botMappingCols.size() <= 0) {
                throw new BOTPException(BOTPException.MAPPINGNUMZERO);
            }
        }
        catch (BOTPException e) {
            logger.error((Object)("targetBillType:" + targetBillType), (Throwable)e);
        }
        return botMappingCols;
    }

    public static boolean isMappingEnabled(BOTMappingInfo mappingInfo) throws BOSException, BOTPException {
        return mappingInfo != null && mappingInfo.getExtRule() != null && mappingInfo.getExtRule().isIsEffected();
    }

    public static BOTMappingCollection getBOTMappingCollection(Context ctx, List mappingIdList) throws BOSException, BOTPException {
        int iStep;
        if (ctx == null) {
            return null;
        }
        int iMax = 100;
        int iTotal = mappingIdList.size();
        if (iTotal > (iStep = iTotal / iMax) * iMax) {
            ++iStep;
        }
        BOTMappingCollection mappings = new BOTMappingCollection();
        IBOTMapping iBotMapping = BOTMappingFactory.getLocalInstance((Context)ctx);
        for (int k = 1; k <= iStep; ++k) {
            HashSet<String> set = new HashSet<String>();
            int lCurrStart = (k - 1) * iMax;
            int lCurrEnd = k * iMax;
            if (lCurrEnd > iTotal) {
                lCurrEnd = iTotal;
            }
            for (int i = lCurrStart; i < lCurrEnd; ++i) {
                String id = (String)mappingIdList.get(i);
                set.add(id);
            }
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("id", set, CompareType.INCLUDE));
            EntityViewInfo view = new EntityViewInfo();
            view.setFilter(filter);
            CoreBaseCollection mappingInfos = iBotMapping.getCollection(view);
            mappings.addObjectCollection((IObjectCollection)mappingInfos);
        }
        return mappings;
    }

    private static BOTMappingCollection getBOTMappingCollectionForSelectByCU(Context ctx, String sourceBillType, String targetBillType, DefineSysEnum defineSys, String transmitID) throws BOSException, BOTPException {
        return BOTMappingHelperForCas.getBOTMappingCollectionForSelectByCU(ctx, sourceBillType, targetBillType, defineSys, transmitID, false);
    }

    private static BOTMappingCollection getBOTMappingCollectionForSelectByCU(Context ctx, String sourceBillType, String targetBillType, DefineSysEnum defineSys, String transmitID, boolean isAllCUMode) throws BOSException, BOTPException {
        BOTMappingCollection result = new BOTMappingCollection();
        try {
            IRowSet rowset = null;
            rowset = !isAllCUMode ? BOTMappingHelperForCas.getMappingByOneCUForSelect(ctx, sourceBillType, targetBillType, defineSys, transmitID) : BOTMappingHelperForCas.getMappingAllCUForSelect(ctx, sourceBillType, targetBillType, defineSys);
            if (rowset != null || rowset.size() > 0) {
                while (rowset.next()) {
                    BOTMappingInfo mappingInfo = new BOTMappingInfo();
                    mappingInfo.setId(BOSUuid.read((String)rowset.getString("FID")));
                    mappingInfo.setName(rowset.getString("FNAME"));
                    mappingInfo.setAlias(rowset.getString("FALIAS_" + ctx.getLocale().toString()), ctx.getLocale());
                    mappingInfo.setSrcEntityName(rowset.getString("FSRCENTITYNAME"));
                    mappingInfo.setDestEntityName(rowset.getString("FDESTENTITYNAME"));
                    mappingInfo.setDescription(rowset.getString("FDESCRIPTION_" + ctx.getLocale().toString()), ctx.getLocale());
                    mappingInfo.setDefineSys(DefineSysEnum.getEnum((int)rowset.getInt("FDEFINESYS")));
                    mappingInfo.setLastUpdateTime(rowset.getTimestamp("FLASTUPDATETIME"));
                    mappingInfo.setIsTempSave(rowset.getInt("FISTEMPSAVE"));
                    mappingInfo.setIsShowEditUI(rowset.getInt("FISSHOWEDITUI"));
                    mappingInfo.setExtConfig(rowset.getString("FEXTCONFIG"));
                    mappingInfo.setMappingType(MappingTypeEnum.getEnum((int)rowset.getInt("FMappingType")));
                    BOTExtMappingInfo extRule = new BOTExtMappingInfo();
                    extRule.setFilter(rowset.getString("FFILTER"));
                    extRule.setDataFilter(rowset.getString("FDATAFILTER"));
                    extRule.setIsEffected(true);
                    String orgId = rowset.getString("FORGID");
                    if (!StringUtils.isEmpty((String)orgId)) {
                        CompanyOrgUnitInfo org = new CompanyOrgUnitInfo();
                        org.setId(BOSUuid.read((String)orgId));
                        extRule.setOrg(org);
                    }
                    mappingInfo.setExtRule(extRule);
                    result.add(mappingInfo);
                }
            }
        }
        catch (SQLException exc) {
            throw new BOTPException(BOTPException.MAPPINGNUMZERO, (Throwable)exc);
        }
        return result;
    }

    private static IRowSet getMappingByOneCUForSelect(Context ctx, String sourceBillType, String targetBillType, DefineSysEnum defineSys, String transmitCuId) throws BOSException {
        IRowSet rs;
        if (defineSys != null) {
            ArrayList<Object> paramsWithDefineSys = new ArrayList<Object>();
            paramsWithDefineSys.add(transmitCuId);
            paramsWithDefineSys.add(sourceBillType);
            paramsWithDefineSys.add(new Integer(1));
            paramsWithDefineSys.add(new Integer(10));
            paramsWithDefineSys.add(new Integer(30));
            paramsWithDefineSys.add(new Integer(defineSys.getValue()));
            String sql = "SELECT MAPPING.FNAME,MAPPING.FMAPPINGTYPE,MAPPING.FDESCRIPTION_" + ctx.getLocale().toString() + ",MAPPING.FAlias_" + ctx.getLocale().toString() + ",MAPPING.FControlUnitID CUID,MAPPING.FID, MAPPING.FSRCENTITYNAME, MAPPING.FDESTENTITYNAME, MAPPING.FDEFINESYS, MAPPING.FISTEMPSAVE, MAPPING.FISSHOWEDITUI,MAPPING.FEXTCONFIG,MAPPING.FLASTUPDATETIME, EXTRULE.FFILTER, EXTRULE.FDATAFILTER, EXTRULE.FORGID  FROM T_BOT_MAPPING MAPPING LEFT OUTER JOIN T_BOT_EXTMAPPING EXTRULE ON MAPPING.FEXTMAPPINGID = EXTRULE.FID  WHERE (MAPPING.FUIDisable=0 OR MAPPING.FUIDisable IS NULL)  AND MAPPING.FControlUnitID = ?  AND MAPPING.FSRCENTITYNAME = ? AND EXTRULE.FISEFFECTED = ? AND (EXTRULE.FTRANSMODE = ? OR EXTRULE.FTRANSMODE = ?) AND MAPPING.FDEFINESYS = ?";
            if (targetBillType != null && targetBillType.length() > 0) {
                sql = sql + " AND MAPPING.FDESTENTITYNAME = ? " + BOTMappingHelperForCas.getOrderSql(ctx);
                paramsWithDefineSys.add(targetBillType);
            } else {
                sql = sql + BOTMappingHelperForCas.getOrderSql(ctx);
            }
            rs = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])paramsWithDefineSys.toArray());
        } else {
            ArrayList<Object> paramsWithoutDefineSys = new ArrayList<Object>();
            paramsWithoutDefineSys.add(transmitCuId);
            paramsWithoutDefineSys.add(sourceBillType);
            paramsWithoutDefineSys.add(new Integer(1));
            paramsWithoutDefineSys.add(new Integer(10));
            paramsWithoutDefineSys.add(new Integer(30));
            String sql = "SELECT MAPPING.FNAME,MAPPING.FMAPPINGTYPE,MAPPING.FDESCRIPTION_" + ctx.getLocale().toString() + ",MAPPING.FAlias_" + ctx.getLocale().toString() + ",MAPPING.FControlUnitID CUID,MAPPING.FID, MAPPING.FSRCENTITYNAME, MAPPING.FDESTENTITYNAME, MAPPING.FDEFINESYS, MAPPING.FISTEMPSAVE, MAPPING.FISSHOWEDITUI,MAPPING.FEXTCONFIG, MAPPING.FLASTUPDATETIME, EXTRULE.FFILTER, EXTRULE.FDATAFILTER, EXTRULE.FORGID  FROM T_BOT_MAPPING MAPPING LEFT OUTER JOIN T_BOT_EXTMAPPING EXTRULE ON MAPPING.FEXTMAPPINGID = EXTRULE.FID  WHERE (MAPPING.FUIDisable=0 OR MAPPING.FUIDisable IS NULL)  AND MAPPING.FControlUnitID = ?  AND MAPPING.FSRCENTITYNAME = ? AND EXTRULE.FISEFFECTED = ? AND (EXTRULE.FTRANSMODE = ? OR EXTRULE.FTRANSMODE = ?) ";
            if (targetBillType != null && targetBillType.length() > 0) {
                sql = sql + " AND MAPPING.FDESTENTITYNAME = ? " + BOTMappingHelperForCas.getOrderSql(ctx);
                paramsWithoutDefineSys.add(targetBillType);
            } else {
                sql = sql + BOTMappingHelperForCas.getOrderSql(ctx);
            }
            rs = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])paramsWithoutDefineSys.toArray());
        }
        return rs;
    }

    public static BOTMappingCollection getMappingForSelectByCU(Context ctx, String srcBillType, String targetBillType, DefineSysEnum defineSys, String transmitID) throws BOSException, BOTPException {
        LowTimer t = new LowTimer();
        t.reset();
        BOTMappingCollection mappingCol = BOTMappingHelperForCas.getBOTMappingCollectionForSelectByCU(ctx, srcBillType, targetBillType, defineSys, transmitID);
        logger.debug((Object)("getBOTMappingCollection time: " + t.msValue()));
        if (mappingCol.size() == 0) {
            logger.error((Object)("destBosType:" + targetBillType), (Throwable)new BOTPException(BOTPException.NOMAPPING));
        }
        return mappingCol;
    }
}

