/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.cas.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.SettlementTypeInfo;
import com.kingdee.eas.basedata.master.account.AccountViewFactory;
import com.kingdee.eas.basedata.master.account.AccountViewInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.SysConstant;
import com.kingdee.eas.fi.cas.BankStatementException;
import com.kingdee.eas.fi.cas.BankStatementInfo;
import com.kingdee.eas.fi.cas.CasException;
import com.kingdee.eas.fi.cas.CashCommonException;
import com.kingdee.eas.fm.common.ContextHelperFactory;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.common.FMVerifyHelper;
import com.kingdee.eas.fm.common.util.AccountCurrencyVerifyUtil;
import java.util.HashMap;

public class BSBatchSubmitVerifyDelegate {
    private HashMap acctView_Map = new HashMap();
    Context ctx = null;
    CompanyOrgUnitInfo currentCompany = null;

    public BSBatchSubmitVerifyDelegate(Context ctx) {
        this.ctx = ctx;
        this.currentCompany = ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentCompany();
    }

    public void validate(BankStatementInfo info) throws EASBizException, BOSException {
        if (info.getCompany() == null) {
            throw new CashCommonException(CashCommonException.NULL_COMPANY);
        }
        if (info.getCurrency() == null) {
            throw new CashCommonException(CashCommonException.NULL_CURRENCY);
        }
        if (info.getAccountBank() == null) {
            throw new CashCommonException(CashCommonException.NULL_BANK);
        }
        if (info.getDebitAmount() == null && info.getCreditAmount() == null) {
            throw new BankStatementException(BankStatementException.DEBIT_CREDIT_NULL);
        }
        Object sett = info.get("settleType");
        if (!(sett instanceof SettlementTypeInfo)) {
            info.setSettleType(null);
        }
        String number = info.getSettleNumber();
        if (FMHelper.isEmpty((String)number)) {
            info.setSettleNumber(null);
        }
        FMVerifyHelper.checkBlank((Context)this.ctx, (IObjectValue)info, (String)"createDate");
        AccountViewInfo accountView = info.getAccountView();
        if (accountView == null) {
            throw new CasException(CasException.ACCT_NULL);
        }
        ObjectUuidPK acctViewPK = new ObjectUuidPK(accountView.getId());
        if (this.acctView_Map.get(acctViewPK) != null) {
            accountView = (AccountViewInfo)this.acctView_Map.get(acctViewPK);
        } else {
            accountView = AccountViewFactory.getLocalInstance((Context)this.ctx).getAccountViewInfo((IObjectPK)acctViewPK, this.getAcctViewSelector());
            this.acctView_Map.put(acctViewPK, accountView);
        }
        if (!accountView.isIsBank() && !accountView.isIsCash()) {
            throw new CasException(CasException.ACCT_NOTCASBANK, new Object[]{accountView.getNumber()});
        }
        if (info.getDebitAmount() != null && info.getDebitAmount().signum() > 0) {
            info.setIsDebit(true);
            info.setCreditAmount(SysConstant.BIGZERO);
        } else if (info.getCreditAmount() != null && info.getCreditAmount().signum() < 0) {
            info.setIsDebit(false);
            info.setDebitAmount(SysConstant.BIGZERO);
        }
        if (info.getDebitAmount().signum() > 0 && info.getCreditAmount().signum() > 0) {
            throw new BankStatementException(BankStatementException.DEBIT_OR_CREDIT);
        }
        String currencyID = info.getCurrency().getId().toString();
        CurrencyInfo baseCurrency = ContextHelperFactory.getLocalInstance((Context)this.ctx).getCompanyBaseCurrency(this.currentCompany);
        AccountCurrencyVerifyUtil.verifyAccountCurrency((Context)this.ctx, (AccountViewInfo)accountView, (String)currencyID, (String)baseCurrency.getId().toString());
    }

    public SelectorItemCollection getAcctViewSelector() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("accountingcurrency"));
        sic.add(new SelectorItemInfo("accountCurrency.id"));
        sic.add(new SelectorItemInfo("accountCurrency.currency"));
        sic.add(new SelectorItemInfo("accountCurrency.currency.id"));
        return sic;
    }
}

