/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.cas.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.basedata.assistant.AccountBankInfo;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.ExchangeRateUtils;
import com.kingdee.eas.basedata.assistant.IPeriod;
import com.kingdee.eas.basedata.assistant.PeriodCollection;
import com.kingdee.eas.basedata.assistant.PeriodException;
import com.kingdee.eas.basedata.assistant.PeriodFactory;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.PeriodUtils;
import com.kingdee.eas.basedata.master.account.AccountViewInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.cas.app.AbstractBalanceModifyFacadeControllerBean;
import com.kingdee.util.db.SQLUtils;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Date;
import org.apache.log4j.Logger;

public class BalanceModifyFacadeControllerBean
extends AbstractBalanceModifyFacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fi.cas.app.BalanceModifyFacadeControllerBean");

    @Override
    protected void _reCalculate(Context ctx, String companyId, IObjectValue currency, IObjectValue account, IObjectValue accountBank, IObjectValue periodFrom, IObjectValue periodTo, boolean flag, IObjectValue periodS) throws BOSException, EASBizException {
        String accountBankId = null;
        String accountId = ((AccountViewInfo)account).getId().toString();
        String currencyId = ((CurrencyInfo)currency).getId().toString();
        if (flag) {
            accountBankId = ((AccountBankInfo)accountBank).getId().toString();
        }
        PeriodInfo periodStart = (PeriodInfo)periodS;
        PeriodInfo periodCurrent = (PeriodInfo)periodFrom;
        PeriodInfo periodPre = BalanceModifyFacadeControllerBean.getPrePeriodInfo(ctx, periodCurrent);
        PeriodInfo periodNext = BalanceModifyFacadeControllerBean.getNextPeriodInfo(ctx, periodCurrent);
        boolean isCurAfterPt = false;
        String periodId = "";
        String periodPreId = "";
        String sql1 = "";
        String sql2 = "";
        String sql3 = "";
        StringBuffer strBuff1 = new StringBuffer();
        StringBuffer strBuff2 = new StringBuffer();
        StringBuffer strBuff3 = new StringBuffer();
        BigDecimal fMonthStartAmt = null;
        BigDecimal fMonthBalance = null;
        BigDecimal fYearStartAmt = null;
        BigDecimal fYearDebitAmt = null;
        BigDecimal fYearCreditAmt = null;
        BigDecimal fYearBalance = null;
        BigDecimal fMonthDebitAmt = null;
        BigDecimal fMonthCreditAmt = null;
        Connection conn = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            conn = this.getConnection(ctx);
            do {
                if (periodPre == null || !PeriodUtils.PeriodCompare((PeriodInfo)periodPre, (PeriodInfo)periodStart)) {
                    periodPre = periodStart;
                    periodId = periodCurrent.getId().toString();
                    periodPreId = periodPre.getId().toString();
                    strBuff1.append("SELECT FMonthStartAmt,   \r\n").append("FMonthBalance, \r\n").append("FYearStartAmt, \r\n").append("FYearDebitAmt, \r\n").append("FYearCreditAmt, \r\n").append("FYearBalance \r\n").append("FROM T_CAS_JOURNALBALANCE WHERE \r\n").append("FCompanyId=?  \r\n");
                    if (flag) {
                        strBuff1.append("AND FAccountBankId=?  \r\n");
                    }
                    strBuff1.append("AND FAccountViewId=?  \r\n").append("AND FCurrencyId=?  \r\n").append("AND FPeriodId=?  \r\n");
                    sql1 = strBuff1.toString();
                    strBuff1.delete(0, strBuff1.length());
                    ps = conn.prepareStatement(sql1);
                    if (flag) {
                        ps.setString(1, companyId);
                        ps.setString(2, accountBankId);
                        ps.setString(3, accountId);
                        ps.setString(4, currencyId);
                        ps.setString(5, periodPreId);
                    } else {
                        ps.setString(1, companyId);
                        ps.setString(2, accountId);
                        ps.setString(3, currencyId);
                        ps.setString(4, periodPreId);
                    }
                    rs = ps.executeQuery();
                    if (rs.next()) {
                        fMonthStartAmt = rs.getBigDecimal("FMonthStartAmt");
                        fMonthBalance = rs.getBigDecimal("FMonthBalance");
                        fYearStartAmt = rs.getBigDecimal("FYearStartAmt");
                        fYearDebitAmt = rs.getBigDecimal("FYearDebitAmt");
                        fYearCreditAmt = rs.getBigDecimal("FYearCreditAmt");
                        fYearBalance = rs.getBigDecimal("FYearBalance");
                    }
                    strBuff2.append("SELECT \r\n").append("sum(ISNULL(FDebitAmount,0.00)) as FDA, \r\n").append("sum(ISNULL(FCreditAmount,0.00)) as FCA  \r\n").append("FROM T_CAS_JOURNAL WHERE \r\n").append("FCompanyId=?  \r\n");
                    if (flag) {
                        strBuff2.append("AND FAccountBankId=?  \r\n");
                    }
                    strBuff2.append("AND FAccountViewId=?  \r\n").append("AND FCurrencyId=?  \r\n").append("AND FPeriodId=?  \r\n");
                    sql2 = strBuff2.toString();
                    strBuff2.delete(0, strBuff2.length());
                    ps = conn.prepareStatement(sql2);
                    if (flag) {
                        ps.setString(1, companyId);
                        ps.setString(2, accountBankId);
                        ps.setString(3, accountId);
                        ps.setString(4, currencyId);
                        ps.setString(5, periodId);
                    } else {
                        ps.setString(1, companyId);
                        ps.setString(2, accountId);
                        ps.setString(3, currencyId);
                        ps.setString(4, periodId);
                    }
                    rs = ps.executeQuery();
                    if (rs.next()) {
                        fMonthDebitAmt = rs.getBigDecimal("FDA");
                        fMonthCreditAmt = rs.getBigDecimal("FCA");
                    }
                    if (fMonthDebitAmt == null) {
                        fMonthDebitAmt = new BigDecimal(0);
                    }
                    if (fMonthCreditAmt == null) {
                        fMonthCreditAmt = new BigDecimal(0);
                    }
                    if (fMonthStartAmt == null) {
                        fMonthStartAmt = new BigDecimal(0);
                    }
                    if (fMonthBalance == null) {
                        fMonthBalance = new BigDecimal(0);
                    }
                    if (fYearBalance == null) {
                        fYearBalance = new BigDecimal(0);
                    }
                    if (fYearDebitAmt == null) {
                        fYearDebitAmt = new BigDecimal(0);
                    }
                    if (fYearCreditAmt == null) {
                        fYearCreditAmt = new BigDecimal(0);
                    }
                    if (fYearStartAmt == null) {
                        fYearStartAmt = new BigDecimal(0);
                    }
                    strBuff3.append("UPDATE T_CAS_JOURNALBALANCE \r\n").append("SET FMonthStartAmt =?, \r\n").append("FMonthDebitAmt =?, \r\n").append("FMonthCreditAmt =?, \r\n").append("FMonthBalance =?, \r\n").append("FYearStartAmt =?, \r\n").append("FYearDebitAmt =?, \r\n").append("FYearCreditAmt =?, \r\n").append("FYearBalance =? \r\n").append("WHERE FCompanyId=? \r\n");
                    if (flag) {
                        strBuff3.append("AND FAccountBankId=?  \r\n");
                    }
                    strBuff3.append("AND FAccountViewId=?  \r\n").append("AND FCurrencyId=?  \r\n").append("AND FPeriodId=?  \r\n");
                    sql3 = strBuff3.toString();
                    strBuff3.delete(0, strBuff3.length());
                    ps = conn.prepareStatement(sql3);
                    if (periodCurrent.getPeriodYear() != periodPre.getPeriodYear()) {
                        ps.setBigDecimal(1, fMonthBalance);
                        ps.setBigDecimal(2, fMonthDebitAmt);
                        ps.setBigDecimal(3, fMonthCreditAmt);
                        ps.setBigDecimal(4, fMonthBalance.add(fMonthDebitAmt).subtract(fMonthCreditAmt));
                        ps.setBigDecimal(5, fMonthBalance);
                        ps.setBigDecimal(6, fMonthDebitAmt);
                        ps.setBigDecimal(7, fMonthCreditAmt);
                        ps.setBigDecimal(8, fMonthBalance.add(fMonthDebitAmt).subtract(fMonthCreditAmt));
                    } else {
                        ps.setBigDecimal(1, fMonthStartAmt);
                        ps.setBigDecimal(2, fMonthDebitAmt);
                        ps.setBigDecimal(3, fMonthCreditAmt);
                        ps.setBigDecimal(4, fMonthStartAmt.add(fMonthDebitAmt).subtract(fMonthCreditAmt));
                        ps.setBigDecimal(5, fYearStartAmt);
                        ps.setBigDecimal(6, fMonthDebitAmt);
                        ps.setBigDecimal(7, fMonthCreditAmt);
                        ps.setBigDecimal(8, fYearStartAmt.add(fMonthDebitAmt).subtract(fMonthCreditAmt));
                    }
                    if (flag) {
                        ps.setString(9, companyId);
                        ps.setString(10, accountBankId);
                        ps.setString(11, accountId);
                        ps.setString(12, currencyId);
                        ps.setString(13, periodId);
                    } else {
                        ps.setString(9, companyId);
                        ps.setString(10, accountId);
                        ps.setString(11, currencyId);
                        ps.setString(12, periodId);
                    }
                    ps.executeUpdate();
                } else {
                    periodId = periodCurrent.getId().toString();
                    periodPreId = periodPre.getId().toString();
                    strBuff1.append("SELECT FMonthStartAmt,   \r\n").append("FMonthBalance, \r\n").append("FYearStartAmt, \r\n").append("FYearDebitAmt, \r\n").append("FYearCreditAmt, \r\n").append("FYearBalance \r\n").append("FROM T_CAS_JOURNALBALANCE WHERE \r\n").append("FCompanyId=?  \r\n");
                    if (flag) {
                        strBuff1.append("AND FAccountBankId=?  \r\n");
                    }
                    strBuff1.append("AND FAccountViewId=?  \r\n").append("AND FCurrencyId=?  \r\n").append("AND FPeriodId=?  \r\n");
                    sql1 = strBuff1.toString();
                    strBuff1.delete(0, strBuff1.length());
                    ps = conn.prepareStatement(sql1);
                    if (flag) {
                        ps.setString(1, companyId);
                        ps.setString(2, accountBankId);
                        ps.setString(3, accountId);
                        ps.setString(4, currencyId);
                        ps.setString(5, periodPreId);
                    } else {
                        ps.setString(1, companyId);
                        ps.setString(2, accountId);
                        ps.setString(3, currencyId);
                        ps.setString(4, periodPreId);
                    }
                    rs = ps.executeQuery();
                    if (rs.next()) {
                        fMonthStartAmt = rs.getBigDecimal("FMonthStartAmt");
                        fMonthBalance = rs.getBigDecimal("FMonthBalance");
                        fYearStartAmt = rs.getBigDecimal("FYearStartAmt");
                        fYearDebitAmt = rs.getBigDecimal("FYearDebitAmt");
                        fYearCreditAmt = rs.getBigDecimal("FYearCreditAmt");
                        fYearBalance = rs.getBigDecimal("FYearBalance");
                    }
                    strBuff2.append("SELECT \r\n").append("sum(ISNULL(FDebitAmount,0.00)) as FDA, \r\n").append("sum(ISNULL(FCreditAmount,0.00)) as FCA  \r\n").append("FROM T_CAS_JOURNAL WHERE \r\n").append("FCompanyId=?  \r\n");
                    if (flag) {
                        strBuff2.append("AND FAccountBankId=?  \r\n");
                    }
                    strBuff2.append("AND FAccountViewId=?  \r\n").append("AND FCurrencyId=?  \r\n").append("AND FPeriodId=?  \r\n");
                    sql2 = strBuff2.toString();
                    strBuff2.delete(0, strBuff2.length());
                    ps = conn.prepareStatement(sql2);
                    if (flag) {
                        ps.setString(1, companyId);
                        ps.setString(2, accountBankId);
                        ps.setString(3, accountId);
                        ps.setString(4, currencyId);
                        ps.setString(5, periodId);
                    } else {
                        ps.setString(1, companyId);
                        ps.setString(2, accountId);
                        ps.setString(3, currencyId);
                        ps.setString(4, periodId);
                    }
                    rs = ps.executeQuery();
                    if (rs.next()) {
                        fMonthDebitAmt = rs.getBigDecimal("FDA");
                        fMonthCreditAmt = rs.getBigDecimal("FCA");
                    }
                    if (fMonthDebitAmt == null) {
                        fMonthDebitAmt = new BigDecimal(0);
                    }
                    if (fMonthCreditAmt == null) {
                        fMonthCreditAmt = new BigDecimal(0);
                    }
                    if (fMonthStartAmt == null) {
                        fMonthStartAmt = new BigDecimal(0);
                    }
                    if (fMonthBalance == null) {
                        fMonthBalance = new BigDecimal(0);
                    }
                    if (fYearBalance == null) {
                        fYearBalance = new BigDecimal(0);
                    }
                    if (fYearDebitAmt == null) {
                        fYearDebitAmt = new BigDecimal(0);
                    }
                    if (fYearCreditAmt == null) {
                        fYearCreditAmt = new BigDecimal(0);
                    }
                    if (fYearStartAmt == null) {
                        fYearStartAmt = new BigDecimal(0);
                    }
                    strBuff3.append("UPDATE T_CAS_JOURNALBALANCE \r\n").append("SET FMonthStartAmt =?, \r\n").append("FMonthDebitAmt =?, \r\n").append("FMonthCreditAmt =?, \r\n").append("FMonthBalance =?, \r\n").append("FYearStartAmt =?, \r\n").append("FYearDebitAmt =?, \r\n").append("FYearCreditAmt =?, \r\n").append("FYearBalance =? \r\n").append("WHERE FCompanyId=? \r\n");
                    if (flag) {
                        strBuff3.append("AND FAccountBankId=?  \r\n");
                    }
                    strBuff3.append("AND FAccountViewId=?  \r\n").append("AND FCurrencyId=?  \r\n").append("AND FPeriodId=?  \r\n");
                    sql3 = strBuff3.toString();
                    strBuff3.delete(0, strBuff3.length());
                    ps = conn.prepareStatement(sql3);
                    if (periodCurrent.getPeriodYear() != periodPre.getPeriodYear()) {
                        ps.setBigDecimal(1, fMonthBalance);
                        ps.setBigDecimal(2, fMonthDebitAmt);
                        ps.setBigDecimal(3, fMonthCreditAmt);
                        ps.setBigDecimal(4, fMonthBalance.add(fMonthDebitAmt).subtract(fMonthCreditAmt));
                        ps.setBigDecimal(5, fMonthBalance);
                        ps.setBigDecimal(6, fMonthDebitAmt);
                        ps.setBigDecimal(7, fMonthCreditAmt);
                        ps.setBigDecimal(8, fMonthBalance.add(fMonthDebitAmt).subtract(fMonthCreditAmt));
                    } else {
                        ps.setBigDecimal(1, fMonthBalance);
                        ps.setBigDecimal(2, fMonthDebitAmt);
                        ps.setBigDecimal(3, fMonthCreditAmt);
                        ps.setBigDecimal(4, fMonthBalance.add(fMonthDebitAmt).subtract(fMonthCreditAmt));
                        ps.setBigDecimal(5, fYearStartAmt);
                        ps.setBigDecimal(6, fYearDebitAmt.add(fMonthDebitAmt));
                        ps.setBigDecimal(7, fYearCreditAmt.add(fMonthCreditAmt));
                        ps.setBigDecimal(8, fYearBalance.add(fMonthDebitAmt).subtract(fMonthCreditAmt));
                    }
                    if (flag) {
                        ps.setString(9, companyId);
                        ps.setString(10, accountBankId);
                        ps.setString(11, accountId);
                        ps.setString(12, currencyId);
                        ps.setString(13, periodId);
                    } else {
                        ps.setString(9, companyId);
                        ps.setString(10, accountId);
                        ps.setString(11, currencyId);
                        ps.setString(12, periodId);
                    }
                    ps.executeUpdate();
                }
                if (periodCurrent.equals((Object)((PeriodInfo)periodTo))) break;
                periodPre = periodCurrent;
            } while ((periodNext = PeriodUtils.getNextPeriodInfo((Context)ctx, (PeriodInfo)(periodCurrent = periodNext))) != null && periodNext.getPeriodYear() != 0 && (isCurAfterPt = PeriodUtils.PeriodCompare((PeriodInfo)((PeriodInfo)periodTo), (PeriodInfo)periodCurrent)));
            ps.executeUpdate();
        }
        catch (SQLException e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(ps, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)ps, (Connection)conn);
    }

    public static PeriodInfo getNextPeriodInfo(Context ctx, PeriodInfo periodInfo) throws BOSException, EASBizException {
        if (periodInfo == null) {
            throw new PeriodException(PeriodException.PERIODNOTNULL);
        }
        PeriodInfo nextPeriodInfo = null;
        IPeriod iPeriod = PeriodFactory.getLocalInstance((Context)ctx);
        periodInfo = iPeriod.getPeriodInfo((IObjectPK)new ObjectUuidPK(periodInfo.getId()));
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("beginDate", (Object)ExchangeRateUtils.covertToSimpleDate((Date)periodInfo.getEndDate()), CompareType.GREATER_EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("periodType", (Object)periodInfo.getPeriodType().getId().toString(), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("periodNumber", (Object)new Integer(periodInfo.getPeriodNumber() + 1), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("periodYear", (Object)new Integer(periodInfo.getPeriodYear()), CompareType.EQUALS));
        evi.setFilter(filter);
        evi.getSorter().add(new SorterItemInfo("periodNumber"));
        PeriodCollection periodc = iPeriod.getPeriodCollection(evi);
        if (periodc.size() > 0) {
            periodInfo = periodc.get(0);
        }
        if (periodc.size() == 0) {
            EntityViewInfo evi1 = new EntityViewInfo();
            FilterInfo filter1 = new FilterInfo();
            filter1.getFilterItems().add(new FilterItemInfo("periodYear", (Object)new Integer(periodInfo.getPeriodYear() + 1), CompareType.EQUALS));
            filter1.getFilterItems().add(new FilterItemInfo("periodType", (Object)periodInfo.getPeriodType().getId().toString(), CompareType.EQUALS));
            filter1.getFilterItems().add(new FilterItemInfo("Periodnumber", (Object)new Integer(1), CompareType.EQUALS));
            filter1.setMaskString("#0 and #1 and #2");
            evi1.setFilter(filter1);
            evi1.getSorter().add(new SorterItemInfo("periodNumber"));
            periodc = iPeriod.getPeriodCollection(evi1);
        }
        if (periodc.size() > 0) {
            nextPeriodInfo = periodc.get(0);
        }
        return nextPeriodInfo;
    }

    public static PeriodInfo getPrePeriodInfo(Context ctx, PeriodInfo periodInfo) throws BOSException, EASBizException {
        if (periodInfo == null) {
            throw new PeriodException(PeriodException.PERIODNOTNULL);
        }
        PeriodInfo prePeriodInfo = new PeriodInfo();
        IPeriod iPeriod = PeriodFactory.getLocalInstance((Context)ctx);
        periodInfo = iPeriod.getPeriodInfo((IObjectPK)new ObjectUuidPK(periodInfo.getId()));
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("beginDate", (Object)ExchangeRateUtils.covertToSimpleDate((Date)periodInfo.getEndDate()), CompareType.LESS_EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("periodType", (Object)periodInfo.getPeriodType().getId().toString(), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("periodNumber", (Object)new Integer(periodInfo.getPeriodNumber() - 1), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("periodYear", (Object)new Integer(periodInfo.getPeriodYear()), CompareType.EQUALS));
        evi.setFilter(filter);
        PeriodCollection periodc = iPeriod.getPeriodCollection(evi);
        if (periodc.size() > 0) {
            periodInfo = periodc.get(0);
        }
        if (periodc.size() == 0) {
            EntityViewInfo evi1 = new EntityViewInfo();
            FilterInfo filter1 = new FilterInfo();
            filter1.getFilterItems().add(new FilterItemInfo("periodYear", (Object)new Integer(periodInfo.getPeriodYear() - 1), CompareType.EQUALS));
            filter1.getFilterItems().add(new FilterItemInfo("periodType", (Object)periodInfo.getPeriodType().getId().toString(), CompareType.EQUALS));
            filter1.setMaskString("#0 and #1");
            evi1.setFilter(filter1);
            evi1.getSorter().add(new SorterItemInfo("periodNumber"));
            periodc = iPeriod.getPeriodCollection(evi1);
        }
        if (periodc.size() > 0) {
            prePeriodInfo = periodc.get(periodc.size() - 1);
        }
        if (prePeriodInfo.getId() == null) {
            prePeriodInfo = null;
        }
        return prePeriodInfo;
    }
}

