/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.cas.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.excel.model.struct.Parameter;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.basedata.assistant.AccountBankCollection;
import com.kingdee.eas.basedata.assistant.AccountBankFactory;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.newrpt.formula.ICalculateContextProvider;
import com.kingdee.eas.framework.CoreBaseInfo;
import java.util.List;
import org.apache.log4j.Logger;

public class BankAcctCaculaterStrategy {
    private static Logger logger = Logger.getLogger((String)BankAcctCaculaterStrategy.class.getName());
    private static Context ctx = null;
    private static String dataTypeValue;

    public static BankAcctCaculaterStrategy getInstance(Context serverCtx, String dataType) {
        dataTypeValue = dataType;
        ctx = serverCtx;
        return new BankAcctCaculaterStrategy();
    }

    public void doCash(List params, ICalculateContextProvider context) throws EASBizException, BOSException {
        for (int i = 0; i < params.size(); ++i) {
            Parameter param = (Parameter)params.get(i);
            Object[] args = param.getArgs();
            String bankAcctNum = args[1] == null ? "" : args[1].toString();
            String result = this.getBankAcctByNumber(ctx, bankAcctNum);
            param.setValue((Object)result);
        }
    }

    private String getBankAcctByNumber(Context ctx, String bankAcctNum) throws BOSException, EASBizException {
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("bankAccountNumber"));
        sic.add(new SelectorItemInfo("name"));
        sic.add(new SelectorItemInfo("company.name"));
        sic.add(new SelectorItemInfo("bank.name"));
        sic.add(new SelectorItemInfo("currency.name"));
        sic.add(new SelectorItemInfo("property.name"));
        sic.add(new SelectorItemInfo("ctrlStrategy.name"));
        FilterInfo filter = new FilterInfo();
        view.setFilter(filter);
        view.setSelector(sic);
        filter.getFilterItems().add(new FilterItemInfo("number", (Object)bankAcctNum, CompareType.EQUALS));
        AccountBankCollection colls = AccountBankFactory.getLocalInstance((Context)ctx).getAccountBankCollection(view);
        if (colls.size() > 0) {
            if (dataTypeValue.equals("-1")) {
                return colls.get(0).getCompany().getName();
            }
            if (dataTypeValue.equals("0")) {
                return colls.get(0).getBank().getName();
            }
            if (dataTypeValue.equals("1")) {
                return colls.get(0).getBankAccountNumber();
            }
            if (dataTypeValue.equals("2") && !EmptyUtil.isEmpty((CoreBaseInfo)colls.get(0).getProperty())) {
                return colls.get(0).getProperty().getName();
            }
            if (dataTypeValue.equals("3")) {
                return colls.get(0).getName();
            }
            if (dataTypeValue.equals("4") && !EmptyUtil.isEmpty((CoreBaseInfo)colls.get(0).getCurrency())) {
                return colls.get(0).getCurrency().getName();
            }
            if (dataTypeValue.equals("5") && !EmptyUtil.isEmpty((CoreBaseInfo)colls.get(0).getCtrlStrategy())) {
                return colls.get(0).getCtrlStrategy().getName();
            }
        }
        return "";
    }
}

