/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.cas.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.bos.workflow.service.ormrpc.EnactmentServiceFactory;
import com.kingdee.bos.workflow.service.ormrpc.IEnactmentService;
import com.kingdee.eas.base.core.Constants;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.base.core.util.DbUtil;
import com.kingdee.eas.base.log.LogUtil;
import com.kingdee.eas.base.netctrl.IMutexServiceControl;
import com.kingdee.eas.base.netctrl.MutexServiceControlFactory;
import com.kingdee.eas.base.permission.IPermission;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.base.vc.VerifyScopeEnum;
import com.kingdee.eas.basedata.assistant.AccountBankFactory;
import com.kingdee.eas.basedata.assistant.AccountBankInfo;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.PeriodFactory;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.cas.AdjustStatusEnum;
import com.kingdee.eas.fi.cas.BankBalUnreachDetailCollection;
import com.kingdee.eas.fi.cas.BankBalUnreachDetailFactory;
import com.kingdee.eas.fi.cas.BankBalUnreachDetailInfo;
import com.kingdee.eas.fi.cas.BankBalanceAdjustCollection;
import com.kingdee.eas.fi.cas.BankBalanceAdjustFactory;
import com.kingdee.eas.fi.cas.BankBalanceAdjustInfo;
import com.kingdee.eas.fi.cas.BankBalanceAdjustmentFactory;
import com.kingdee.eas.fi.cas.BankBalanceCondition;
import com.kingdee.eas.fi.cas.BankStatementCollection;
import com.kingdee.eas.fi.cas.BankStatementFactory;
import com.kingdee.eas.fi.cas.BankStatementInfo;
import com.kingdee.eas.fi.cas.BankStmtBookReportInfo;
import com.kingdee.eas.fi.cas.JournalCollection;
import com.kingdee.eas.fi.cas.JournalFactory;
import com.kingdee.eas.fi.cas.JournalInfo;
import com.kingdee.eas.fi.cas.RecPayException;
import com.kingdee.eas.fi.cas.app.AbstractBankBalanceAdjustControllerBean;
import com.kingdee.eas.fi.cas.app.GenBankAdjustDataService;
import com.kingdee.eas.fm.be.TransDetailCollection;
import com.kingdee.eas.fm.be.TransDetailFactory;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.ResourceBase;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class BankBalanceAdjustControllerBean
extends AbstractBankBalanceAdjustControllerBean {
    private static final long serialVersionUID = -155129478201588429L;
    public static final String srcPath = "com.kingdee.eas.fi.cas.CasResources";
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fi.cas.app.BankBalanceAdjustControllerBean");

    @Override
    protected void _audit(Context ctx, String[] ids) throws BOSException, EASBizException {
        for (int i = 0; i < ids.length; ++i) {
            this.auditWf(ctx, (IObjectPK)new ObjectUuidPK(ids[i]));
        }
    }

    @Override
    protected void _antiAudit(Context ctx, String[] ids) throws BOSException, EASBizException {
        for (int i = 0; i < ids.length; ++i) {
            this.antiAuditWf(ctx, (IObjectPK)new ObjectUuidPK(ids[i]));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void _genBankBalance(Context ctx, Set conditions) throws BOSException, EASBizException {
        IMutexServiceControl iMutexServiceControl = MutexServiceControlFactory.getLocalInstance((Context)ctx);
        if (conditions.size() > 0) {
            CoreBaseCollection colls = new CoreBaseCollection();
            for (BankBalanceCondition condition : conditions) {
                IPermission iPermission = PermissionFactory.getLocalInstance((Context)ctx);
                if (condition.getPeriodId() != null) {
                    iPermission.checkFunctionPermission(ctx.getCaller(), (IObjectPK)new ObjectUuidPK(condition.getCompanyInfo().getId().toString()), "cas_bankbanlance_01view");
                } else {
                    iPermission.checkFunctionPermission(ctx.getCaller(), (IObjectPK)new ObjectUuidPK(condition.getCompanyInfo().getId().toString()), "cas_bankbalanceForDate_01view");
                }
                boolean request = iMutexServiceControl.requestObjIDForUpdate(condition.getBankId() + "/bankadjust");
                try {
                    if (request) {
                        logger.info((Object)("----------------\u8d26\u6237 " + condition.getBankId() + " \u83b7\u53d6\u5230\u9501----------------"));
                        long startTime = System.currentTimeMillis();
                        Map map = this.checkAddTempBankBalanceAdjustAndReason(ctx, condition);
                        long endTime = System.currentTimeMillis();
                        long time = (endTime - startTime) / 1000L;
                        logger.info((Object)("\u8d26\u6237 " + condition.getBankId() + " \u68c0\u67e5\u8017\u65f6\uff1a" + time + "\u79d2"));
                        if (!((Boolean)map.get("isAddNew")).booleanValue()) continue;
                        startTime = System.currentTimeMillis();
                        BankBalanceAdjustInfo info = this.genBankBalance(ctx, condition);
                        endTime = System.currentTimeMillis();
                        time = (endTime - startTime) / 1000L;
                        logger.info((Object)("\u8d26\u6237 " + condition.getBankId() + " \u751f\u6210\u8c03\u8282\u8868\u6570\u636e\u8017\u65f6\uff1a" + time + "\u79d2"));
                        colls.add((CoreBaseInfo)info);
                        continue;
                    }
                    logger.info((Object)("---------------\u8d26\u6237 " + condition.getBankId() + " \u672a\u83b7\u53d6\u5230\u9501----------------"));
                }
                finally {
                    if (!request) continue;
                    iMutexServiceControl.releaseObjIDForUpdate(condition.getBankId() + "/bankadjust");
                    logger.info((Object)("---------------\u8d26\u6237 " + condition.getBankId() + " \u91ca\u653e\u9501----------------"));
                }
            }
            if (colls.size() > 0) {
                long startTime = System.currentTimeMillis();
                BankBalanceAdjustFactory.getLocalInstance(ctx).addnewBatchData(colls);
                long endTime = System.currentTimeMillis();
                long time = (endTime - startTime) / 1000L;
                logger.info((Object)("\u63d0\u4ea4\u8c03\u8282\u8868\u8017\u65f6\uff1a" + time + "\u79d2"));
            }
        }
    }

    protected boolean checkAddTempBankBalanceAdjust(Context ctx, BankBalanceCondition condition) throws EASBizException, BOSException {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        view.setFilter(filter);
        filter.getFilterItems().add(new FilterItemInfo("bankAccount.id", (Object)condition.getBankId()));
        filter.getFilterItems().add(new FilterItemInfo("currency.id", (Object)condition.getCurrencyId()));
        if (condition.getPeriodId() == null) {
            filter.getFilterItems().add(new FilterItemInfo("bizDate", (Object)condition.getEndDate()));
        } else {
            filter.getFilterItems().add(new FilterItemInfo("period.id", (Object)condition.getPeriodId()));
        }
        filter.getFilterItems().add(new FilterItemInfo("auditTime", null, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("toWfTime", null, CompareType.EQUALS));
        BankBalanceAdjustCollection colls = BankBalanceAdjustFactory.getLocalInstance(ctx).getBankBalanceAdjustCollection(view);
        if (colls.size() > 0) {
            String id = colls.get(0).getId().toString();
            BankBalanceAdjustFactory.getLocalInstance(ctx).delete(filter);
            FilterInfo fi = new FilterInfo();
            fi.getFilterItems().add(new FilterItemInfo("bankBalAdjustId", (Object)id));
            BankBalUnreachDetailFactory.getLocalInstance(ctx).delete(fi);
        }
        FilterInfo fi = new FilterInfo();
        fi.getFilterItems().add(new FilterItemInfo("bankAccount.id", (Object)condition.getBankId()));
        fi.getFilterItems().add(new FilterItemInfo("currency.id", (Object)condition.getCurrencyId()));
        if (condition.getPeriodId() == null) {
            fi.getFilterItems().add(new FilterItemInfo("bizDate", (Object)condition.getEndDate()));
        } else {
            fi.getFilterItems().add(new FilterItemInfo("period.id", (Object)condition.getPeriodId()));
        }
        fi.getFilterItems().add(new FilterItemInfo("auditTime", null, CompareType.NOTEQUALS));
        fi.getFilterItems().add(new FilterItemInfo("toWfTime", null, CompareType.NOTEQUALS));
        fi.setMaskString("#0 AND #1 AND #2 AND (#3 OR #4 )");
        boolean isExistAudit = BankBalanceAdjustFactory.getLocalInstance(ctx).exists(fi);
        return !isExistAudit;
    }

    protected Map checkAddTempBankBalanceAdjustAndReason(Context ctx, BankBalanceCondition condition) throws EASBizException, BOSException {
        HashMap<String, Boolean> map = new HashMap<String, Boolean>();
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        view.setFilter(filter);
        filter.getFilterItems().add(new FilterItemInfo("bankAccount.id", (Object)condition.getBankId()));
        filter.getFilterItems().add(new FilterItemInfo("currency.id", (Object)condition.getCurrencyId()));
        if (condition.getPeriodId() == null) {
            filter.getFilterItems().add(new FilterItemInfo("bizDate", (Object)condition.getEndDate()));
        } else {
            filter.getFilterItems().add(new FilterItemInfo("period.id", (Object)condition.getPeriodId()));
        }
        filter.getFilterItems().add(new FilterItemInfo("auditTime", null, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("toWfTime", null, CompareType.EQUALS));
        BankBalanceAdjustCollection colls = BankBalanceAdjustFactory.getLocalInstance(ctx).getBankBalanceAdjustCollection(view);
        if (colls.size() > 0) {
            String id = colls.get(0).getId().toString();
            BankBalanceAdjustFactory.getLocalInstance(ctx).delete(filter);
            FilterInfo fi = new FilterInfo();
            fi.getFilterItems().add(new FilterItemInfo("bankBalAdjustId", (Object)id));
            BankBalUnreachDetailFactory.getLocalInstance(ctx).delete(fi);
            map.put("isAddNew", true);
            return map;
        }
        FilterInfo fi = new FilterInfo();
        fi.getFilterItems().add(new FilterItemInfo("bankAccount.id", (Object)condition.getBankId()));
        fi.getFilterItems().add(new FilterItemInfo("currency.id", (Object)condition.getCurrencyId()));
        if (condition.getPeriodId() == null) {
            fi.getFilterItems().add(new FilterItemInfo("bizDate", (Object)condition.getEndDate()));
        } else {
            fi.getFilterItems().add(new FilterItemInfo("period.id", (Object)condition.getPeriodId()));
        }
        fi.getFilterItems().add(new FilterItemInfo("auditTime", null, CompareType.NOTEQUALS));
        fi.getFilterItems().add(new FilterItemInfo("toWfTime", null, CompareType.NOTEQUALS));
        fi.setMaskString("#0 AND #1 AND #2 AND (#3 OR #4 )");
        boolean isExistAudit = BankBalanceAdjustFactory.getLocalInstance(ctx).exists(fi);
        if (isExistAudit) {
            map.put("isAddNew", false);
            return map;
        }
        map.put("isAddNew", true);
        return map;
    }

    protected BankBalanceAdjustInfo genBankBalance(Context ctx, BankBalanceCondition condition) throws EASBizException, BOSException {
        long startTime = System.currentTimeMillis();
        BankStmtBookReportInfo rptInfo = BankBalanceAdjustmentFactory.getLocalInstance(ctx).getBalanceReport(condition);
        long endTime = System.currentTimeMillis();
        long time = (endTime - startTime) / 1000L;
        logger.info((Object)("\u8d26\u6237" + condition.getBankId() + " \u83b7\u53d6\u8c03\u8282\u8868\u6570\u636e\u8017\u65f6\uff1a" + time + "\u79d2"));
        BigDecimal oJournalEndAmount = rptInfo.getBankBookAmt();
        BigDecimal oStatmntEndAmount = rptInfo.getBankStmtAmt();
        BigDecimal oBankGotAmount = rptInfo.getBankGotAmt();
        BigDecimal oBankPayedAmount = rptInfo.getBankPayedAmt();
        BigDecimal oEntprGotAmount = rptInfo.getEntprGotAmt();
        BigDecimal oEntprPayedAmount = rptInfo.getEntprPayedAmt();
        BigDecimal transDetailAmt = null;
        BigDecimal journalDifferenceAmt = null;
        Date endDate = null;
        Date fromDate = null;
        if (condition.getPeriodId() == null && condition.getIncludeTranDetail()) {
            fromDate = condition.getFromDate();
            endDate = condition.getEndDate();
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("bankAccount.id", (Object)condition.getBankId()));
            filter.getFilterItems().add(new FilterItemInfo("bizTime", (Object)fromDate, CompareType.GREATER_EQUALS));
            filter.getFilterItems().add(new FilterItemInfo("bizTime", (Object)this.afterDays(endDate), CompareType.LESS_EQUALS));
            view.setFilter(filter);
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("transBalance"));
            view.setSelector(sic);
            SorterItemCollection sorter = new SorterItemCollection();
            sorter.add(new SorterItemInfo("bizTime"));
            view.setSorter(sorter);
            TransDetailCollection tColl = TransDetailFactory.getLocalInstance((Context)ctx).getTransDetailCollection(view);
            if (tColl.size() > 0) {
                transDetailAmt = tColl.get(tColl.size() - 1).getTransBalance();
            }
        }
        oJournalEndAmount = oJournalEndAmount == null ? Constants.ZERO : oJournalEndAmount;
        oBankGotAmount = oBankGotAmount == null ? Constants.ZERO : oBankGotAmount;
        oBankPayedAmount = oBankPayedAmount == null ? Constants.ZERO : oBankPayedAmount;
        BigDecimal oAdjustedJournalAmount = oJournalEndAmount.add(oBankGotAmount).subtract(oBankPayedAmount);
        oStatmntEndAmount = oStatmntEndAmount == null ? Constants.ZERO : oStatmntEndAmount;
        oEntprGotAmount = oEntprGotAmount == null ? Constants.ZERO : oEntprGotAmount;
        oEntprPayedAmount = oEntprPayedAmount == null ? Constants.ZERO : oEntprPayedAmount;
        BigDecimal oAdjustedStatmntAmount = oStatmntEndAmount.add(oEntprGotAmount).subtract(oEntprPayedAmount);
        if (transDetailAmt != null) {
            journalDifferenceAmt = oJournalEndAmount.subtract(transDetailAmt);
        }
        BankBalanceAdjustInfo info = new BankBalanceAdjustInfo();
        info.setId(BOSUuid.create((BOSObjectType)this.getBOSType()));
        info.setCompany(condition.getCompanyInfo());
        ObjectUuidPK bpk = new ObjectUuidPK(condition.getBankId());
        AccountBankInfo bankAcct = AccountBankFactory.getLocalInstance((Context)ctx).getAccountBankInfo((IObjectPK)bpk);
        info.setBankAccount(bankAcct);
        ObjectUuidPK cpk = new ObjectUuidPK(condition.getCurrencyId());
        CurrencyInfo currency = CurrencyFactory.getLocalInstance((Context)ctx).getCurrencyInfo((IObjectPK)cpk);
        info.setCurrency(currency);
        if (condition.getPeriodId() == null) {
            info.setBizDate(condition.getEndDate());
        } else {
            ObjectUuidPK ppk = new ObjectUuidPK(condition.getPeriodId());
            PeriodInfo period = PeriodFactory.getLocalInstance((Context)ctx).getPeriodInfo((IObjectPK)ppk);
            info.setPeriod(period);
        }
        info.setJournalBalAmt(oJournalEndAmount);
        info.setBankGotAmt(oBankGotAmount);
        info.setBankPayedAmt(oBankPayedAmount);
        info.setAdjustJournalAmt(oAdjustedJournalAmount);
        info.setTransDetailAmt(transDetailAmt);
        info.setJournalDifferenceAmt(journalDifferenceAmt);
        info.setStatmntBalAmt(oStatmntEndAmount);
        info.setEntprGotAmt(oEntprGotAmount);
        info.setEntprPayedAmt(oEntprPayedAmount);
        info.setAdjustStatementAmt(oAdjustedStatmntAmount);
        info.setStatus(AdjustStatusEnum.unflat);
        if (info.getJournalBalAmt().compareTo(info.getStatmntBalAmt()) == 0) {
            info.setStatus(AdjustStatusEnum.flat);
        }
        this.genBankBalanceDetail(ctx, rptInfo, info);
        return info;
    }

    protected void genBankBalanceDetail(Context ctx, BankStmtBookReportInfo rptInfo, BankBalanceAdjustInfo bankBalAdjust) throws EASBizException, BOSException {
        BankBalUnreachDetailInfo info;
        int index;
        CoreBaseCollection colls = new CoreBaseCollection();
        IObjectCollection journal = rptInfo.getBanks();
        IObjectCollection bankState = rptInfo.getEntprs();
        for (index = 0; index < journal.size(); ++index) {
            info = new BankBalUnreachDetailInfo();
            info.setBankBalAdjustId(bankBalAdjust.getId().toString());
            info.setBillid(((JournalInfo)journal.getObject(index)).getId().toString());
            info.setBosType(new JournalInfo().getBOSType().toString());
            colls.add((CoreBaseInfo)info);
        }
        for (index = 0; index < bankState.size(); ++index) {
            info = new BankBalUnreachDetailInfo();
            info.setBankBalAdjustId(bankBalAdjust.getId().toString());
            info.setBillid(((BankStatementInfo)bankState.getObject(index)).getId().toString());
            info.setBosType(new BankStatementInfo().getBOSType().toString());
            colls.add((CoreBaseInfo)info);
        }
        if (colls.size() > 0) {
            if (colls.size() > 1000) {
                GenBankAdjustDataService service = new GenBankAdjustDataService();
                service.mutilThreadTrans(ctx, colls);
            } else {
                BankBalUnreachDetailFactory.getLocalInstance(ctx).addnewBatchData(colls);
            }
        }
    }

    @Override
    protected Set _getBalanceAdjustPageInitData(Context ctx, String jsonstr) throws BOSException, EASBizException {
        String[] ids = jsonstr.split(",");
        HashSet balSet = new HashSet();
        for (int index = 0; index < ids.length; ++index) {
            HashMap<String, Object> rstDataMap = new HashMap<String, Object>();
            String id = ids[index];
            ObjectUuidPK pk = new ObjectUuidPK(id);
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("*"));
            sic.add(new SelectorItemInfo("company.id"));
            sic.add(new SelectorItemInfo("company.number"));
            sic.add(new SelectorItemInfo("company.name"));
            sic.add(new SelectorItemInfo("bankAccount.id"));
            sic.add(new SelectorItemInfo("bankAccount.number"));
            sic.add(new SelectorItemInfo("bankAccount.name"));
            sic.add(new SelectorItemInfo("bankAccount.bankAccountNumber"));
            sic.add(new SelectorItemInfo("bankAccount.account.number"));
            sic.add(new SelectorItemInfo("bankAccount.account.name"));
            sic.add(new SelectorItemInfo("bankAccount.company"));
            sic.add(new SelectorItemInfo("currency.id"));
            sic.add(new SelectorItemInfo("currency.number"));
            sic.add(new SelectorItemInfo("currency.name"));
            sic.add(new SelectorItemInfo("currency.precision"));
            sic.add(new SelectorItemInfo("period.periodYear"));
            sic.add(new SelectorItemInfo("period.periodNumber"));
            sic.add(new SelectorItemInfo("period.description"));
            sic.add(new SelectorItemInfo("auditor.name"));
            sic.add(new SelectorItemInfo("bizDate"));
            sic.add(new SelectorItemInfo("transDetailAmt"));
            sic.add(new SelectorItemInfo("journalDifferenceAmt"));
            BankBalanceAdjustInfo info = null;
            try {
                info = BankBalanceAdjustFactory.getLocalInstance(ctx).getBankBalanceAdjustInfo((IObjectPK)pk, sic);
            }
            catch (BOSException e) {
                logger.error((Object)e.getMessage());
                throw new RecPayException(RecPayException.REFRESH_OPEN);
            }
            rstDataMap.put("id", info.getId().toString());
            rstDataMap.put("companyOrg", info.getCompany());
            rstDataMap.put("accountBank", info.getBankAccount());
            rstDataMap.put("currencyInfo", info.getCurrency());
            rstDataMap.put("periodInfo", info.getPeriod());
            rstDataMap.put("precision", info.getCurrency().getPrecision());
            rstDataMap.put("currencyInfo", info.getCurrency());
            rstDataMap.put("bizDate", info.getBizDate());
            rstDataMap.put("transDetailAmt", info.getTransDetailAmt());
            rstDataMap.put("journalDifferenceAmt", info.getJournalDifferenceAmt());
            if (info.getAuditor() != null && info.getAuditor().getName() != null) {
                rstDataMap.put("audit", info.getAuditor().getName());
            }
            if (info.getAuditTime() != null) {
                SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                rstDataMap.put("auditTime", format.format(info.getAuditTime().getTime()));
            }
            BankStmtBookReportInfo report = new BankStmtBookReportInfo();
            BigDecimal oJournalEndAmount = info.getJournalBalAmt();
            BigDecimal oBankGotAmount = info.getBankGotAmt();
            BigDecimal oBankPayedAmount = info.getBankPayedAmt();
            BigDecimal oStatmntEndAmount = info.getStatmntBalAmt();
            BigDecimal oEntprGotAmount = info.getEntprGotAmt();
            BigDecimal oEntprPayedAmount = info.getEntprPayedAmt();
            oJournalEndAmount = oJournalEndAmount == null ? Constants.ZERO : oJournalEndAmount;
            oBankGotAmount = oBankGotAmount == null ? Constants.ZERO : oBankGotAmount;
            oBankPayedAmount = oBankPayedAmount == null ? Constants.ZERO : oBankPayedAmount;
            BigDecimal oAdjustedJournalAmount = oJournalEndAmount.add(oBankGotAmount).subtract(oBankPayedAmount);
            oStatmntEndAmount = oStatmntEndAmount == null ? Constants.ZERO : oStatmntEndAmount;
            oEntprGotAmount = oEntprGotAmount == null ? Constants.ZERO : oEntprGotAmount;
            oEntprPayedAmount = oEntprPayedAmount == null ? Constants.ZERO : oEntprPayedAmount;
            BigDecimal oAdjustedStatmntAmount = oStatmntEndAmount.add(oEntprGotAmount).subtract(oEntprPayedAmount);
            report.setBankStmtAmt(oStatmntEndAmount);
            report.setBankPayedAmt(oBankPayedAmount);
            report.setBankGotAmt(oBankGotAmount);
            report.setBankBookAmt(oJournalEndAmount);
            report.setEntprPayedAmt(oEntprPayedAmount);
            report.setEntprGotAmt(oEntprGotAmount);
            rstDataMap.put("rptInfo", report);
            rstDataMap.put("entBalance", oAdjustedJournalAmount);
            rstDataMap.put("bankBalance", oAdjustedStatmntAmount);
            String bid = info.getId().toString();
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            view.setFilter(filter);
            SelectorItemCollection siccc = new SelectorItemCollection();
            siccc.add(new SelectorItemInfo("*"));
            siccc.add(new SelectorItemInfo("company.name"));
            siccc.add(new SelectorItemInfo("settlementType.name"));
            view.setSelector(siccc);
            filter.getFilterItems().add(new FilterItemInfo("bankBalAdjustId", (Object)bid));
            BankBalUnreachDetailCollection colls = BankBalUnreachDetailFactory.getLocalInstance(ctx).getBankBalUnreachDetailCollection(view);
            HashSet<String> bankIdSet = new HashSet<String>();
            HashSet<String> journalIdSet = new HashSet<String>();
            for (int i = 0; i < colls.size(); ++i) {
                BankBalUnreachDetailInfo detail = colls.get(i);
                if (detail.getBosType().equals(new JournalInfo().getBOSType().toString())) {
                    journalIdSet.add(detail.getBillid());
                    continue;
                }
                bankIdSet.add(detail.getBillid());
            }
            JournalCollection coll = new JournalCollection();
            if (journalIdSet.size() > 0) {
                EntityViewInfo evi = new EntityViewInfo();
                FilterInfo fi = new FilterInfo();
                SelectorItemCollection sicc = new SelectorItemCollection();
                sicc.add(new SelectorItemInfo("*"));
                sicc.add(new SelectorItemInfo("company.name"));
                sicc.add(new SelectorItemInfo("voucherType.name"));
                sicc.add(new SelectorItemInfo("settlementType.name"));
                evi.setSelector(sicc);
                evi.setFilter(fi);
                SorterItemCollection sorter1 = new SorterItemCollection();
                sorter1.add(new SorterItemInfo("createDate"));
                evi.setSorter(sorter1);
                fi.getFilterItems().add(new FilterItemInfo("id", journalIdSet, CompareType.INCLUDE));
                coll = JournalFactory.getLocalInstance(ctx).getJournalCollection(evi);
            }
            boolean CS125 = false;
            CS125 = ContextHelperFactory.getLocalInstance((Context)ctx).getBooleanParam("CS125", (IObjectPK)new ObjectUuidPK(info.getCompany().getId()));
            if (!CS125) {
                rstDataMap.put("bankUnreachedColl", coll);
            } else {
                JournalCollection newColl = new JournalCollection();
                if (coll.size() > 0) {
                    for (int i = 0; i < coll.size(); ++i) {
                        JournalInfo journal = coll.get(i);
                        if (!journal.getVerifyStatus().equals((Object)VerifyScopeEnum.NOVA)) continue;
                        newColl.add(journal);
                    }
                }
                rstDataMap.put("bankUnreachedColl", newColl);
            }
            BankStatementCollection coll2 = new BankStatementCollection();
            if (bankIdSet.size() > 0) {
                EntityViewInfo evi = new EntityViewInfo();
                FilterInfo fi = new FilterInfo();
                SelectorItemCollection sicc = new SelectorItemCollection();
                sicc.add(new SelectorItemInfo("*"));
                sicc.add(new SelectorItemInfo("company.name"));
                sicc.add(new SelectorItemInfo("settleType.name"));
                evi.setSelector(sicc);
                evi.setFilter(fi);
                SorterItemCollection sorter1 = new SorterItemCollection();
                sorter1.add(new SorterItemInfo("createDate"));
                evi.setSorter(sorter1);
                fi.getFilterItems().add(new FilterItemInfo("id", bankIdSet, CompareType.INCLUDE));
                coll2 = BankStatementFactory.getLocalInstance(ctx).getBankStatementCollection(evi);
            }
            if (!CS125) {
                rstDataMap.put("entprUnreachedColl", (Object)coll2);
            } else {
                BankStatementCollection newColl = new BankStatementCollection();
                if (coll2.size() > 0) {
                    for (int i = 0; i < coll2.size(); ++i) {
                        BankStatementInfo bankState = coll2.get(i);
                        if (!bankState.getVerifyStatus().equals((Object)VerifyScopeEnum.NOVA)) continue;
                        newColl.add(bankState);
                    }
                }
                rstDataMap.put("entprUnreachedColl", (Object)newColl);
            }
            balSet.add(rstDataMap);
        }
        return balSet;
    }

    private Date afterDays(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.set(11, 23);
        calendar.set(12, 59);
        calendar.set(13, 59);
        return calendar.getTime();
    }

    public static String Array2String(Set idSet) {
        String id = "";
        if (idSet != null && idSet.size() > 0) {
            String[] ids = new String[idSet.size()];
            Object[] array = idSet.toArray();
            for (int j = 0; j < array.length; ++j) {
                ids[j] = array[j].toString();
            }
            id = FMHelper.Array2String((String[])ids);
        }
        return id;
    }

    @Override
    protected void _toAuditById(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        if (!BankBalanceAdjustFactory.getLocalInstance(ctx).exists(pk)) {
            throw new RecPayException(RecPayException.COMMON, new Object[]{ResourceBase.getString((String)srcPath, (String)"Not_Exist", (Locale)ctx.getLocale())});
        }
        BankBalanceAdjustInfo info = BankBalanceAdjustFactory.getLocalInstance(ctx).getBankBalanceAdjustInfo(pk, this.getSelectorForLog());
        if (info.getAuditTime() != null) {
            throw new RecPayException(RecPayException.COMMON, new Object[]{ResourceBase.getString((String)srcPath, (String)"Adjust_Be_Auidt", (Locale)ctx.getLocale())});
        }
        IEnactmentService service = EnactmentServiceFactory.createEnactService((Context)ctx);
        String proc = service.findProcDef(ctx.getCaller().toString(), (IObjectValue)info, "com.kingdee.eas.fi.cas.app.BankBalanceAdjustListUIFunction", "ActionToAudit");
        if (proc == null) {
            throw new RecPayException(RecPayException.COMMON, new Object[]{ResourceBase.getString((String)srcPath, (String)"Has_Not_WorkFlow", (Locale)ctx.getLocale())});
        }
        Timestamp currTime = new Timestamp(System.currentTimeMillis());
        String sSQL = "Update T_CAS_BankBalanceAdjust SET  FToWfTime = ? WHERE FAuditorID is null and FID = ? ";
        DbUtil.execute((Context)ctx, (String)sSQL, (Object[])new Object[]{currTime, info.getId().toString()});
        IObjectPK pkOut = LogUtil.beginLog((Context)ctx, (String)"\u4f59\u989d\u8c03\u8282\u8868\u53d1\u8d77\u5ba1\u6279", (BOSObjectType)info.getBOSType(), (IObjectPK)pk, (String)BankBalanceAdjustControllerBean.getLogNumber(info), (String)"cas_bankbalanceForDate_09toAudit", (String)info.getCompany().getId().toString(), (String)"\u4f59\u989d\u8c03\u8282\u8868\u53d1\u8d77\u5ba1\u6279");
        LogUtil.afterLog((Context)ctx, (IObjectPK)pkOut);
    }

    @Override
    protected void _toAntiAuditById(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        if (!BankBalanceAdjustFactory.getLocalInstance(ctx).exists(pk)) {
            throw new RecPayException(RecPayException.COMMON, new Object[]{ResourceBase.getString((String)srcPath, (String)"Not_Exist", (Locale)ctx.getLocale())});
        }
        BankBalanceAdjustInfo info = BankBalanceAdjustFactory.getLocalInstance(ctx).getBankBalanceAdjustInfo(pk, this.getSelectorForLog());
        if (info.getAuditTime() == null) {
            throw new RecPayException(RecPayException.COMMON, new Object[]{ResourceBase.getString((String)srcPath, (String)"Adjust_Not_Be_Auidt", (Locale)ctx.getLocale())});
        }
        IEnactmentService service = EnactmentServiceFactory.createEnactService((Context)ctx);
        String proc = service.findProcDef(ctx.getCaller().toString(), (IObjectValue)info, "com.kingdee.eas.fi.cas.app.BankBalanceAdjustListUIFunction", "ActionToAntiAudit");
        if (proc == null) {
            throw new RecPayException(RecPayException.COMMON, new Object[]{ResourceBase.getString((String)srcPath, (String)"Has_Not_WorkFlow", (Locale)ctx.getLocale())});
        }
        IObjectPK pkOut = LogUtil.beginLog((Context)ctx, (String)"\u4f59\u989d\u8c03\u8282\u8868\u53d1\u8d77\u53cd\u5ba1\u6279", (BOSObjectType)info.getBOSType(), (IObjectPK)pk, (String)BankBalanceAdjustControllerBean.getLogNumber(info), (String)"cas_bankbalanceForDate_10toAntiAudit", (String)info.getCompany().getId().toString(), (String)"\u4f59\u989d\u8c03\u8282\u8868\u53d1\u8d77\u53cd\u5ba1\u6279");
        LogUtil.afterLog((Context)ctx, (IObjectPK)pkOut);
    }

    @Override
    protected void _auditWf(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        if (!BankBalanceAdjustFactory.getLocalInstance(ctx).exists(pk)) {
            throw new RecPayException(RecPayException.COMMON, new Object[]{ResourceBase.getString((String)srcPath, (String)"Not_Exist", (Locale)ctx.getLocale())});
        }
        BankBalanceAdjustInfo info = BankBalanceAdjustFactory.getLocalInstance(ctx).getBankBalanceAdjustInfo(pk, this.getSelectorForLog());
        if (info.getAuditTime() != null) {
            throw new RecPayException(RecPayException.COMMON, new Object[]{ResourceBase.getString((String)srcPath, (String)"Adjust_Be_Auidt", (Locale)ctx.getLocale())});
        }
        UserInfo user = ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentUser();
        Timestamp currTime = new Timestamp(System.currentTimeMillis());
        String sSQL = "Update T_CAS_BankBalanceAdjust SET FAuditorID = ?, FAuditTime = ? WHERE FAuditorID is null and FID = ? ";
        DbUtil.execute((Context)ctx, (String)sSQL, (Object[])new Object[]{user.getId().toString(), currTime, pk.toString()});
        IObjectPK pkOut = LogUtil.beginLog((Context)ctx, (String)"\u4f59\u989d\u8c03\u8282\u8868\u5ba1\u6279", (BOSObjectType)info.getBOSType(), (IObjectPK)pk, (String)BankBalanceAdjustControllerBean.getLogNumber(info), (String)"cas_bankbalanceForDate_02audit", (String)info.getCompany().getId().toString(), (String)"\u4f59\u989d\u8c03\u8282\u8868\u5ba1\u6279");
        LogUtil.afterLog((Context)ctx, (IObjectPK)pkOut);
    }

    @Override
    protected void _antiAuditWf(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        if (!BankBalanceAdjustFactory.getLocalInstance(ctx).exists(pk)) {
            throw new RecPayException(RecPayException.COMMON, new Object[]{ResourceBase.getString((String)srcPath, (String)"Not_Exist", (Locale)ctx.getLocale())});
        }
        BankBalanceAdjustInfo info = BankBalanceAdjustFactory.getLocalInstance(ctx).getBankBalanceAdjustInfo(pk, this.getSelectorForLog());
        if (info.getAuditTime() == null) {
            throw new RecPayException(RecPayException.COMMON, new Object[]{ResourceBase.getString((String)srcPath, (String)"Adjust_Not_Be_Auidt", (Locale)ctx.getLocale())});
        }
        String sSQL = "Update T_CAS_BankBalanceAdjust SET FAuditorID = null, FAuditTime = null,FToWfTime = null WHERE FAuditorID is not null and FID = ? ";
        DbUtil.execute((Context)ctx, (String)sSQL, (Object[])new Object[]{pk.toString()});
        IObjectPK pkOut = LogUtil.beginLog((Context)ctx, (String)"\u4f59\u989d\u8c03\u8282\u8868\u53cd\u5ba1\u6279", (BOSObjectType)info.getBOSType(), (IObjectPK)pk, (String)BankBalanceAdjustControllerBean.getLogNumber(info), (String)"cas_bankbalanceForDate_03antiaudit", (String)info.getCompany().getId().toString(), (String)"\u4f59\u989d\u8c03\u8282\u8868\u53cd\u5ba1\u6279");
        LogUtil.afterLog((Context)ctx, (IObjectPK)pkOut);
    }

    @Override
    protected void _antiToWf(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        if (!BankBalanceAdjustFactory.getLocalInstance(ctx).exists(pk)) {
            throw new RecPayException(RecPayException.COMMON, new Object[]{ResourceBase.getString((String)srcPath, (String)"Not_Exist", (Locale)ctx.getLocale())});
        }
        BankBalanceAdjustInfo info = BankBalanceAdjustFactory.getLocalInstance(ctx).getBankBalanceAdjustInfo(pk, this.getSelectorForLog());
        if (info.getToWfTime() == null) {
            throw new RecPayException(RecPayException.COMMON, new Object[]{ResourceBase.getString((String)srcPath, (String)"toWfTime_Is_Null", (Locale)ctx.getLocale())});
        }
        if (info.getAuditTime() != null) {
            throw new RecPayException(RecPayException.COMMON, new Object[]{ResourceBase.getString((String)srcPath, (String)"Adjust_Be_Auidt", (Locale)ctx.getLocale())});
        }
        String sSQL = "Update T_CAS_BankBalanceAdjust SET FToWfTime = null WHERE FAuditorID is null and FID = ? ";
        DbUtil.execute((Context)ctx, (String)sSQL, (Object[])new Object[]{pk.toString()});
        IObjectPK pkOut = LogUtil.beginLog((Context)ctx, (String)"\u4f59\u989d\u8c03\u8282\u8868\u6e05\u7a7a\u53d1\u8d77\u5ba1\u6279\u65f6\u95f4", (BOSObjectType)info.getBOSType(), (IObjectPK)pk, (String)BankBalanceAdjustControllerBean.getLogNumber(info), (String)"cas_bankbalanceForDate_11antiToWf", (String)info.getCompany().getId().toString(), (String)"\u4f59\u989d\u8c03\u8282\u8868\u6e05\u7a7a\u53d1\u8d77\u5ba1\u6279\u65f6\u95f4");
        LogUtil.afterLog((Context)ctx, (IObjectPK)pkOut);
    }

    private SelectorItemCollection getSelectorForLog() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("auditTime"));
        sic.add(new SelectorItemInfo("toWfTime"));
        sic.add(new SelectorItemInfo("bizDate"));
        sic.add(new SelectorItemInfo("bankAccount.id"));
        sic.add(new SelectorItemInfo("bankAccount.number"));
        sic.add(new SelectorItemInfo("bankAccount.bankAccountNumber"));
        sic.add(new SelectorItemInfo("company.id"));
        sic.add(new SelectorItemInfo("company.number"));
        sic.add(new SelectorItemInfo("company.name"));
        sic.add(new SelectorItemInfo("period.id"));
        sic.add(new SelectorItemInfo("period.number"));
        sic.add(new SelectorItemInfo("currency.id"));
        sic.add(new SelectorItemInfo("currency.name"));
        return sic;
    }

    public static String getLogNumber(BankBalanceAdjustInfo info) {
        String logNumber = "";
        try {
            String date = info.getBizDate() != null ? info.getBizDate().toString() : String.valueOf(info.getPeriod().getNumber());
            logNumber = info.getCompany().getName() + "-" + info.getBankAccount().getBankAccountNumber() + "-" + date + "-" + info.getCurrency().getName();
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        return logNumber;
    }
}

